"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "_ssr_src_lib_betting_ts";
exports.ids = ["_ssr_src_lib_betting_ts"];
exports.modules = {

/***/ "(ssr)/./src/lib/betting.ts":
/*!****************************!*\
  !*** ./src/lib/betting.ts ***!
  \****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BettingEngine: () => (/* binding */ BettingEngine),\n/* harmony export */   recordPriceHistory: () => (/* binding */ recordPriceHistory)\n/* harmony export */ });\n/* harmony import */ var _supabase_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supabase-client */ \"(ssr)/./src/lib/supabase-client.ts\");\n\n// Function to record price history\nasync function recordPriceHistory(marketId, yesPrice, noPrice, yesPool, noPool, totalVolume) {\n    try {\n        await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('price_history').insert({\n            market_id: marketId,\n            yes_price: yesPrice,\n            no_price: noPrice,\n            yes_pool: yesPool,\n            no_pool: noPool,\n            total_volume: totalVolume\n        });\n    } catch (error) {\n        // Silently fail if price_history table doesn't exist yet\n        console.warn('Failed to record price history:', error);\n    }\n}\nclass BettingEngine {\n    /**\n   * Calculate liquidity-adjusted price using constant product formula\n   * This ensures there's always liquidity available for trading\n   */ static calculateLiquidityAdjustedPrice(currentPool, liquidity, betAmount, outcome) {\n        // Constant product formula: x * y = k\n        // Where x = outcome pool, y = opposite pool, k = constant\n        const oppositePool = liquidity - currentPool;\n        // Calculate new pools after bet\n        const newOutcomePool = currentPool + betAmount;\n        const newOppositePool = currentPool * oppositePool / newOutcomePool;\n        // Calculate price based on new pools\n        const totalNewPool = newOutcomePool + newOppositePool;\n        return newOutcomePool / totalNewPool;\n    }\n    /**\n   * Calculate market prices for multiple outcomes with liquidity\n   */ static calculateMultiOutcomePrices(outcomes, totalLiquidity) {\n        return outcomes.map((outcome)=>({\n                ...outcome,\n                price: outcome.pool / totalLiquidity\n            }));\n    }\n    /**\n   * Add liquidity to a market\n   */ static async addLiquidity(userId, marketId, amount, outcomeId// For multi-outcome markets\n    ) {\n        try {\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is active\n            if (market.status !== 'active') {\n                return {\n                    success: false,\n                    error: 'Market is no longer accepting liquidity'\n                };\n            }\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Update user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - amount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Add liquidity to market\n            const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                total_liquidity: (market.total_liquidity || 0) + amount,\n                updated_at: new Date().toISOString()\n            }).eq('id', marketId);\n            if (marketUpdateError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to add liquidity'\n                };\n            }\n            // Create liquidity transaction record\n            const { data: liquidityRecord, error: liquidityError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('liquidity_providers').insert({\n                user_id: userId,\n                market_id: marketId,\n                amount: amount,\n                outcome_id: outcomeId,\n                created_at: new Date().toISOString()\n            }).select().single();\n            if (liquidityError) {\n                return {\n                    success: false,\n                    error: 'Failed to record liquidity provision'\n                };\n            }\n            return {\n                success: true,\n                liquidityId: liquidityRecord.id\n            };\n        } catch (error) {\n            console.error('Error adding liquidity:', error);\n            return {\n                success: false,\n                error: 'Internal server error'\n            };\n        }\n    }\n    /**\n   * Place bet on multiple outcome market\n   */ static async placeMultiOutcomeBet(userId, marketId, outcomeId, amount) {\n        try {\n            // Get market and outcome details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(`\n          *,\n          outcomes:market_outcomes(*)\n        `).eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is multi-outcome\n            if (market.market_type !== 'multi_outcome') {\n                return {\n                    success: false,\n                    error: 'This is not a multi-outcome market'\n                };\n            }\n            // Find the specific outcome\n            const outcome = market.outcomes?.find((o)=>o.id === outcomeId);\n            if (!outcome) {\n                return {\n                    success: false,\n                    error: 'Outcome not found'\n                };\n            }\n            // Calculate liquidity-adjusted price\n            const newPrice = this.calculateLiquidityAdjustedPrice(outcome.pool, market.total_liquidity || 0, amount, outcome.name);\n            // Calculate shares user will receive\n            const shares = amount / newPrice;\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Update user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - amount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Update outcome pool\n            const { error: outcomeError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('market_outcomes').update({\n                pool: outcome.pool + amount,\n                volume: outcome.volume + amount,\n                updated_at: new Date().toISOString()\n            }).eq('id', outcomeId);\n            if (outcomeError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to update outcome pool'\n                };\n            }\n            // Create bet record\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                user_id: userId,\n                market_id: marketId,\n                outcome: outcome.name,\n                outcome_id: outcomeId,\n                amount: amount,\n                price: newPrice,\n                shares: shares,\n                status: 'matched',\n                liquidity_contribution: amount,\n                created_at: new Date().toISOString()\n            }).select().single();\n            if (betError) {\n                return {\n                    success: false,\n                    error: 'Failed to create bet record'\n                };\n            }\n            return {\n                success: true,\n                betId: bet.id\n            };\n        } catch (error) {\n            console.error('Error placing multi-outcome bet:', error);\n            return {\n                success: false,\n                error: 'Internal server error'\n            };\n        }\n    }\n    /**\n   * Seed a bet (pre-fund before making live)\n   */ static async seedBet(userId, marketId, outcome, seededAmount, price) {\n        try {\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is pending (scheduled) - seeding only allowed on scheduled markets\n            if (market.status !== 'pending') {\n                return {\n                    success: false,\n                    error: 'Seeding is only allowed on scheduled markets. This market is not in pending status.'\n                };\n            }\n            // Check if market has ended\n            const now = new Date();\n            const endDate = new Date(market.end_date);\n            if (now >= endDate) {\n                return {\n                    success: false,\n                    error: 'Market has ended'\n                };\n            }\n            // Check if market already has live volume (seeding only allowed before live trading)\n            if ((market.live_volume || 0) > 0) {\n                return {\n                    success: false,\n                    error: 'Market is already live. Seeding is only allowed before live trading begins.'\n                };\n            }\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < seededAmount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Use current market price if not specified\n            const currentPrice = price || (outcome === 'yes' ? market.yes_price : market.no_price);\n            // Create seeded bet\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                user_id: userId,\n                market_id: marketId,\n                outcome,\n                amount: 0,\n                price: currentPrice,\n                shares: 0,\n                status: 'seeded',\n                seeded_amount: seededAmount,\n                live_amount: 0\n            }).select().single();\n            if (betError) {\n                return {\n                    success: false,\n                    error: betError.message\n                };\n            }\n            // Deduct seeded amount from user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - seededAmount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Update market seeded volume\n            const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                seeded_volume: (market.seeded_volume || 0) + seededAmount,\n                total_volume: (market.total_volume || 0) + seededAmount\n            }).eq('id', marketId);\n            if (marketUpdateError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to update market volume'\n                };\n            }\n            // Create transaction record\n            await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').insert({\n                user_id: userId,\n                type: 'bet',\n                amount: -seededAmount,\n                description: `Seeded bet on market (${outcome.toUpperCase()})`,\n                market_id: marketId,\n                bet_id: bet.id\n            });\n            return {\n                success: true,\n                betId: bet.id\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Make a seeded bet live (activate it)\n   */ static async makeBetLive(betId, additionalAmount) {\n        try {\n            // Get the seeded bet\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('id', betId).single();\n            if (betError || !bet) {\n                return {\n                    success: false,\n                    error: 'Bet not found'\n                };\n            }\n            if (bet.status !== 'seeded') {\n                return {\n                    success: false,\n                    error: 'Bet is not in seeded status'\n                };\n            }\n            const totalAmount = bet.seeded_amount + (additionalAmount || 0);\n            const liveAmount = additionalAmount || 0;\n            // If additional amount is provided, check balance\n            if (additionalAmount && additionalAmount > 0) {\n                const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', bet.user_id).single();\n                if (profileError || !profile) {\n                    return {\n                        success: false,\n                        error: 'User profile not found'\n                    };\n                }\n                if (profile.balance < additionalAmount) {\n                    return {\n                        success: false,\n                        error: 'Insufficient balance for additional amount'\n                    };\n                }\n                // Deduct additional amount from user balance\n                const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance - additionalAmount\n                }).eq('id', bet.user_id);\n                if (balanceError) {\n                    return {\n                        success: false,\n                        error: 'Failed to update balance'\n                    };\n                }\n                // Create transaction for additional amount\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').insert({\n                    user_id: bet.user_id,\n                    type: 'bet',\n                    amount: -additionalAmount,\n                    description: `Additional amount for live bet`,\n                    market_id: bet.market_id,\n                    bet_id: bet.id\n                });\n            }\n            // Update bet to live status\n            const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'live',\n                amount: totalAmount,\n                shares: totalAmount / bet.price,\n                live_amount: liveAmount\n            }).eq('id', betId);\n            if (updateError) {\n                return {\n                    success: false,\n                    error: updateError.message\n                };\n            }\n            // Update market pools for live bet\n            if (liveAmount > 0) {\n                const { data: market } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', bet.market_id).single();\n                if (market) {\n                    const updateData = {\n                        live_volume: (market.live_volume || 0) + liveAmount\n                    };\n                    if (bet.outcome === 'yes') {\n                        updateData.yes_pool = (market.yes_pool || 0) + liveAmount;\n                    } else {\n                        updateData.no_pool = (market.no_pool || 0) + liveAmount;\n                    }\n                    // Calculate new prices\n                    const totalYesPool = updateData.yes_pool || market.yes_pool || 0;\n                    const totalNoPool = updateData.no_pool || market.no_pool || 0;\n                    const totalPool = totalYesPool + totalNoPool;\n                    if (totalPool > 0) {\n                        updateData.yes_price = totalYesPool / totalPool;\n                        updateData.no_price = totalNoPool / totalPool;\n                    }\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update(updateData).eq('id', bet.market_id);\n                }\n            }\n            // Try to match with existing bets\n            await this.matchBets(bet.market_id);\n            return {\n                success: true\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Check if market shares are exhausted\n   */ static async checkShareExhaustion(marketId) {\n        try {\n            const { data: market, error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('total_shares, shares_sold, status, market_type, outcomes').eq('id', marketId).single();\n            if (error || !market) {\n                return {\n                    exhausted: false,\n                    reason: 'Market not found'\n                };\n            }\n            // Check if market is already closed/resolved\n            if ([\n                'closed',\n                'resolved',\n                'refunded'\n            ].includes(market.status)) {\n                return {\n                    exhausted: true,\n                    reason: 'Market is closed'\n                };\n            }\n            // For binary markets\n            if (market.market_type === 'binary') {\n                const totalShares = market.total_shares || 1000;\n                const sharesSold = market.shares_sold || 0;\n                const remainingShares = totalShares - sharesSold;\n                if (remainingShares <= 0) {\n                    return {\n                        exhausted: true,\n                        reason: 'All shares have been sold'\n                    };\n                }\n            }\n            // For multi-outcome markets\n            if (market.market_type === 'multi_outcome' && market.outcomes) {\n                for (const outcome of market.outcomes){\n                    const outcomeShares = outcome.pool || 0;\n                    const maxSharesPerOutcome = (market.total_shares || 1000) / market.outcomes.length;\n                    if (outcomeShares >= maxSharesPerOutcome) {\n                        return {\n                            exhausted: true,\n                            reason: `Outcome \"${outcome.name}\" shares exhausted`\n                        };\n                    }\n                }\n            }\n            return {\n                exhausted: false\n            };\n        } catch (error) {\n            console.error('Error checking share exhaustion:', error);\n            return {\n                exhausted: false,\n                reason: 'Error checking shares'\n            };\n        }\n    }\n    /**\n   * Update market status when shares are exhausted\n   */ static async updateMarketForExhaustion(marketId) {\n        try {\n            const { error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                status: 'closed',\n                admin_notes: 'Market closed - shares exhausted',\n                updated_at: new Date().toISOString()\n            }).eq('id', marketId);\n            if (error) {\n                console.error('Failed to update market for exhaustion:', error);\n                return false;\n            }\n            // Send notification to market creator\n            try {\n                const { data: market } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('creator_id, title').eq('id', marketId).single();\n                if (market) {\n                    const { NotificationService } = await __webpack_require__.e(/*! import() */ \"_ssr_src_lib_services_notificationService_ts\").then(__webpack_require__.bind(__webpack_require__, /*! @/lib/services/notificationService */ \"(ssr)/./src/lib/services/notificationService.ts\"));\n                    await NotificationService.createEventNotification(market.creator_id, 'market_shares_exhausted', 'Market Shares Exhausted', `Your market \"${market.title}\" has been closed due to share exhaustion.`, {\n                        market: {\n                            id: marketId,\n                            title: market.title,\n                            reason: 'shares_exhausted'\n                        }\n                    }, true // Send email\n                    );\n                }\n            } catch (notificationError) {\n                console.error('Failed to send exhaustion notification:', notificationError);\n            }\n            return true;\n        } catch (error) {\n            console.error('Error updating market for exhaustion:', error);\n            return false;\n        }\n    }\n    /**\n   * Place a share-based bet on a market\n   */ static async placeBet(userId, marketId, outcome, amount, shares) {\n        try {\n            // Check if shares are exhausted before placing bet\n            const exhaustionCheck = await this.checkShareExhaustion(marketId);\n            if (exhaustionCheck.exhausted) {\n                return {\n                    success: false,\n                    error: `Cannot place bet: ${exhaustionCheck.reason}`\n                };\n            }\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is active\n            if (market.status !== 'active') {\n                return {\n                    success: false,\n                    error: 'Market is no longer accepting bets'\n                };\n            }\n            // Check if market has ended\n            const now = new Date();\n            const endDate = new Date(market.end_date);\n            if (now >= endDate) {\n                return {\n                    success: false,\n                    error: 'Market has ended'\n                };\n            }\n            // Note: shares_remaining column has been removed - prediction markets typically have unlimited shares\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Try the new share-based betting function first\n            try {\n                const { data: result, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('place_share_bet', {\n                    p_user_id: userId,\n                    p_market_id: marketId,\n                    p_outcome: outcome,\n                    p_amount: amount,\n                    p_shares: shares || null\n                }).single();\n                if (betError) {\n                    throw betError;\n                }\n                const betResult = result;\n                if (!betResult.success) {\n                    throw new Error(betResult.message);\n                }\n                // Return success with share information\n                return {\n                    success: true,\n                    betId: betResult.bet_id,\n                    sharesPurchased: betResult.shares_purchased,\n                    sharePrice: betResult.share_price,\n                    potentialPayout: betResult.potential_payout\n                };\n            } catch (shareBetError) {\n                // Fallback to old betting system if share-based functions don't exist\n                console.warn('Share-based betting not available, falling back to old system:', shareBetError);\n                // Use current market price if not specified\n                const betPrice = market.yes_price || market.no_price || 0.5;\n                const calculatedShares = shares || amount / betPrice;\n                // Check if purchase would exceed total shares available\n                const currentSharesSold = market.shares_sold || 0;\n                const totalShares = market.total_shares || 1000;\n                if (currentSharesSold + calculatedShares > totalShares) {\n                    const remainingShares = totalShares - currentSharesSold;\n                    throw new Error(`Purchase would exceed total shares available. Only ${remainingShares.toFixed(2)} shares remaining.`);\n                }\n                // Create live bet using old system\n                const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                    user_id: userId,\n                    market_id: marketId,\n                    outcome,\n                    amount,\n                    price: betPrice,\n                    shares: calculatedShares,\n                    status: 'matched',\n                    seeded_amount: 0,\n                    live_amount: amount\n                }).select().single();\n                if (betError) {\n                    throw new Error(betError.message);\n                }\n                // Deduct amount from user balance\n                const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance - amount\n                }).eq('id', userId);\n                if (balanceError) {\n                    throw new Error('Failed to update balance');\n                }\n                // Update market pools, volumes, and shares sold\n                const updateData = {\n                    live_volume: (market.live_volume || 0) + amount,\n                    total_volume: (market.total_volume || 0) + amount,\n                    shares_sold: (market.shares_sold || 0) + calculatedShares\n                };\n                if (outcome === 'yes') {\n                    updateData.yes_pool = (market.yes_pool || 0) + amount;\n                    updateData.current_yes_share_price = betPrice;\n                } else {\n                    updateData.no_pool = (market.no_pool || 0) + amount;\n                    updateData.current_no_share_price = betPrice;\n                }\n                // Calculate new prices based on updated pools\n                const totalYesPool = updateData.yes_pool || market.yes_pool || 0;\n                const totalNoPool = updateData.no_pool || market.no_pool || 0;\n                const totalPool = totalYesPool + totalNoPool;\n                if (totalPool > 0) {\n                    updateData.yes_price = totalYesPool / totalPool;\n                    updateData.no_price = totalNoPool / totalPool;\n                }\n                const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update(updateData).eq('id', marketId);\n                if (marketUpdateError) {\n                    // Rollback balance update\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                        balance: profile.balance\n                    }).eq('id', userId);\n                    throw new Error('Failed to update market pools');\n                }\n                // Create unified transaction record\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('unified_transactions').insert({\n                    user_id: userId,\n                    type: 'bet',\n                    status: 'completed',\n                    amount: -amount,\n                    currency: 'USD',\n                    description: `Live bet placed on market (${outcome.toUpperCase()})`,\n                    market_id: marketId,\n                    bet_id: bet.id,\n                    fee_amount: 0,\n                    net_amount: -amount,\n                    processed_at: new Date().toISOString(),\n                    metadata: {\n                        outcome: outcome,\n                        price: betPrice,\n                        shares: calculatedShares\n                    }\n                });\n                // Check if shares are now exhausted after this bet\n                const postBetExhaustion = await this.checkShareExhaustion(marketId);\n                if (postBetExhaustion.exhausted) {\n                    console.log('Shares exhausted after bet, updating market status');\n                    await this.updateMarketForExhaustion(marketId);\n                }\n                return {\n                    success: true,\n                    betId: bet.id,\n                    sharesPurchased: calculatedShares,\n                    sharePrice: betPrice,\n                    potentialPayout: calculatedShares * 1.00 // Estimate $1 per share\n                };\n            }\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Match pending bets for a market\n   */ static async matchBets(marketId) {\n        try {\n            // Get all pending bets for this market\n            const { data: pendingBets, error: fetchError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('market_id', marketId).eq('status', 'live').order('created_at', {\n                ascending: true\n            });\n            if (fetchError) {\n                console.error('Error fetching pending bets:', fetchError);\n                return;\n            }\n            if (!pendingBets || pendingBets.length === 0) {\n                return;\n            }\n            // Simple matching logic - match opposite outcome bets\n            const yesBets = pendingBets.filter((bet)=>bet.outcome === 'yes');\n            const noBets = pendingBets.filter((bet)=>bet.outcome === 'no');\n            // Match bets with similar amounts\n            const minMatches = Math.min(yesBets.length, noBets.length);\n            for(let i = 0; i < minMatches; i++){\n                const yesBet = yesBets[i];\n                const noBet = noBets[i];\n                // Update both bets to matched status\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                    status: 'matched'\n                }).eq('id', yesBet.id);\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                    status: 'matched'\n                }).eq('id', noBet.id);\n            }\n        } catch (error) {\n            console.error('Error matching bets:', error);\n        }\n    }\n    /**\n   * Automatically determine the winning outcome based on market data\n   * This can be extended with various algorithms (price-based, volume-based, etc.)\n   */ static async determineWinningOutcome(marketId) {\n        try {\n            // Get market data\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(`\n          id,\n          title,\n          description,\n          category,\n          end_date,\n          yes_price,\n          no_price,\n          total_volume,\n          total_liquidity,\n          status\n        `).eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'Market not found'\n                };\n            }\n            // Get bet data for analysis\n            const { data: bets, error: betsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('outcome, amount, seeded_amount, live_amount, status').eq('market_id', marketId).eq('status', 'matched');\n            if (betsError) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'Failed to fetch bet data'\n                };\n            }\n            if (!bets || bets.length === 0) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'No matched bets found'\n                };\n            }\n            // Calculate metrics for each outcome\n            const yesBets = bets.filter((bet)=>bet.outcome === 'yes');\n            const noBets = bets.filter((bet)=>bet.outcome === 'no');\n            const yesMetrics = {\n                count: yesBets.length,\n                totalAmount: yesBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0),\n                seededAmount: yesBets.reduce((sum, bet)=>sum + (bet.seeded_amount || 0), 0),\n                liveAmount: yesBets.reduce((sum, bet)=>sum + (bet.live_amount || 0), 0),\n                avgAmount: yesBets.length > 0 ? yesBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0) / yesBets.length : 0\n            };\n            const noMetrics = {\n                count: noBets.length,\n                totalAmount: noBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0),\n                seededAmount: noBets.reduce((sum, bet)=>sum + (bet.seeded_amount || 0), 0),\n                liveAmount: noBets.reduce((sum, bet)=>sum + (bet.live_amount || 0), 0),\n                avgAmount: noBets.length > 0 ? noBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0) / noBets.length : 0\n            };\n            // Algorithm 1: Price-based determination (most reliable for prediction markets)\n            let priceBasedOutcome = null;\n            let priceConfidence = 0;\n            if (market.yes_price && market.no_price) {\n                const priceDiff = Math.abs(market.yes_price - market.no_price);\n                const threshold = 0.1 // 10% price difference threshold for high confidence\n                ;\n                if (market.yes_price > market.no_price + threshold) {\n                    priceBasedOutcome = 'yes';\n                    priceConfidence = Math.min(priceDiff * 100, 95); // Cap at 95% confidence\n                } else if (market.no_price > market.yes_price + threshold) {\n                    priceBasedOutcome = 'no';\n                    priceConfidence = Math.min(priceDiff * 100, 95);\n                } else {\n                    priceConfidence = 50; // Low confidence when prices are close\n                }\n            }\n            // Algorithm 2: Volume-based determination\n            let volumeBasedOutcome = null;\n            let volumeConfidence = 0;\n            const totalVolume = yesMetrics.totalAmount + noMetrics.totalAmount;\n            if (totalVolume > 0) {\n                const yesVolumeRatio = yesMetrics.totalAmount / totalVolume;\n                const noVolumeRatio = noMetrics.totalAmount / totalVolume;\n                const volumeDiff = Math.abs(yesVolumeRatio - noVolumeRatio);\n                if (yesVolumeRatio > noVolumeRatio + 0.2) {\n                    volumeBasedOutcome = 'yes';\n                    volumeConfidence = Math.min(volumeDiff * 100, 80);\n                } else if (noVolumeRatio > yesVolumeRatio + 0.2) {\n                    volumeBasedOutcome = 'no';\n                    volumeConfidence = Math.min(volumeDiff * 100, 80);\n                } else {\n                    volumeConfidence = 50;\n                }\n            }\n            // Algorithm 3: Seeded amount analysis (early money)\n            let seededBasedOutcome = null;\n            let seededConfidence = 0;\n            const totalSeeded = yesMetrics.seededAmount + noMetrics.seededAmount;\n            if (totalSeeded > 0) {\n                const yesSeededRatio = yesMetrics.seededAmount / totalSeeded;\n                const noSeededRatio = noMetrics.seededAmount / totalSeeded;\n                const seededDiff = Math.abs(yesSeededRatio - noSeededRatio);\n                if (yesSeededRatio > noSeededRatio + 0.3) {\n                    seededBasedOutcome = 'yes';\n                    seededConfidence = Math.min(seededDiff * 100, 70);\n                } else if (noSeededRatio > yesSeededRatio + 0.3) {\n                    seededBasedOutcome = 'no';\n                    seededConfidence = Math.min(seededDiff * 100, 70);\n                } else {\n                    seededConfidence = 50;\n                }\n            }\n            // Combine algorithms with weighted scoring\n            const algorithms = [\n                {\n                    outcome: priceBasedOutcome,\n                    confidence: priceConfidence,\n                    weight: 0.5,\n                    name: 'price'\n                },\n                {\n                    outcome: volumeBasedOutcome,\n                    confidence: volumeConfidence,\n                    weight: 0.3,\n                    name: 'volume'\n                },\n                {\n                    outcome: seededBasedOutcome,\n                    confidence: seededConfidence,\n                    weight: 0.2,\n                    name: 'seeded'\n                }\n            ];\n            // Calculate weighted scores for each outcome\n            const yesScore = algorithms.reduce((score, algo)=>{\n                return score + (algo.outcome === 'yes' ? algo.confidence * algo.weight : 0);\n            }, 0);\n            const noScore = algorithms.reduce((score, algo)=>{\n                return score + (algo.outcome === 'no' ? algo.confidence * algo.weight : 0);\n            }, 0);\n            // Determine final outcome\n            let finalOutcome = null;\n            let finalConfidence = 0;\n            let reasoning = '';\n            if (yesScore > noScore + 10) {\n                finalOutcome = 'yes';\n                finalConfidence = Math.min(yesScore, 95);\n                reasoning = `YES selected based on: ${algorithms.filter((a)=>a.outcome === 'yes').map((a)=>`${a.name}(${a.confidence.toFixed(1)}%)`).join(', ')}`;\n            } else if (noScore > yesScore + 10) {\n                finalOutcome = 'no';\n                finalConfidence = Math.min(noScore, 95);\n                reasoning = `NO selected based on: ${algorithms.filter((a)=>a.outcome === 'no').map((a)=>`${a.name}(${a.confidence.toFixed(1)}%)`).join(', ')}`;\n            } else {\n                finalOutcome = null;\n                finalConfidence = Math.max(yesScore, noScore);\n                reasoning = `Insufficient confidence for automatic resolution. YES: ${yesScore.toFixed(1)}%, NO: ${noScore.toFixed(1)}%`;\n            }\n            return {\n                outcome: finalOutcome,\n                confidence: finalConfidence,\n                reasoning: reasoning\n            };\n        } catch (error) {\n            console.error('Error determining winning outcome:', error);\n            return {\n                outcome: null,\n                confidence: 0,\n                reasoning: `Error in automatic determination: ${error.message}`\n            };\n        }\n    }\n    /**\n   * Resolve a market with comprehensive payout system\n   * Uses the new payout system to handle all stakeholders: winners, creators, and admin\n   * Can automatically determine winners if outcome is not provided\n   */ static async resolveMarket(marketId, outcome) {\n        try {\n            // Check if market exists and has bets\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(`\n          id, \n          status, \n          market_type,\n          outcomes:market_outcomes (\n            id,\n            name,\n            price,\n            pool\n          )\n        `).eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            if (market.status !== 'active' && market.status !== 'closed') {\n                return {\n                    success: false,\n                    error: 'Market is not in a resolvable state'\n                };\n            }\n            // If no outcome provided, try to determine it automatically\n            let finalOutcome = outcome;\n            let autoDetermined = false;\n            let confidence = 0;\n            if (!outcome) {\n                const determination = await this.determineWinningOutcome(marketId);\n                if (determination.outcome) {\n                    finalOutcome = determination.outcome;\n                    autoDetermined = true;\n                    confidence = determination.confidence;\n                    console.log(`Auto-determined outcome: ${determination.outcome} (${determination.confidence.toFixed(1)}% confidence)`);\n                    console.log(`Reasoning: ${determination.reasoning}`);\n                } else {\n                    return {\n                        success: false,\n                        error: `Cannot automatically determine winner: ${determination.reasoning}`,\n                        confidence: determination.confidence\n                    };\n                }\n            } else {\n                // Validate the provided outcome\n                if (market.market_type === 'binary') {\n                    if (outcome !== 'yes' && outcome !== 'no') {\n                        return {\n                            success: false,\n                            error: 'Invalid outcome for binary market. Must be \"yes\" or \"no\".'\n                        };\n                    }\n                } else if (market.market_type === 'multi_outcome') {\n                    const validOutcomes = market.outcomes?.map((o)=>o.name) || [];\n                    if (!validOutcomes.includes(outcome)) {\n                        return {\n                            success: false,\n                            error: `Invalid outcome for multi-outcome market. Valid outcomes: ${validOutcomes.join(', ')}`\n                        };\n                    }\n                }\n            }\n            // Check if there are any matched bets\n            const { data: bets, error: betsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('id').eq('market_id', marketId).eq('status', 'matched').limit(1);\n            if (betsError) {\n                return {\n                    success: false,\n                    error: betsError.message\n                };\n            }\n            // If no bets, just update market status\n            if (!bets || bets.length === 0) {\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'resolved',\n                    outcome: finalOutcome,\n                    resolution_date: new Date().toISOString()\n                }).eq('id', marketId);\n                if (updateError) {\n                    return {\n                        success: false,\n                        error: updateError.message\n                    };\n                }\n                return {\n                    success: true,\n                    payoutSummary: {\n                        totalPayouts: 0,\n                        totalAmount: 0\n                    },\n                    autoDetermined,\n                    confidence\n                };\n            }\n            // Try to use the comprehensive payout system, fallback to basic resolution if not available\n            let payoutProcessed = false;\n            let payoutSummary = null;\n            try {\n                const { data: payoutResult, error: payoutError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('process_market_payouts', {\n                    p_market_id: marketId,\n                    p_outcome: finalOutcome\n                });\n                if (payoutError) {\n                    console.error('Error processing payouts:', payoutError);\n                    // Check if it's because the payout system isn't set up\n                    if (payoutError.message && (payoutError.message.includes('function process_market_payouts') || payoutError.message.includes('does not exist'))) {\n                        console.log('Payout system not set up, using basic resolution');\n                    } else {\n                        console.error('Payout error:', payoutError.message || 'Unknown payout error');\n                    }\n                } else {\n                    const result = payoutResult?.[0];\n                    if (result && result.success) {\n                        payoutProcessed = true;\n                        payoutSummary = result;\n                    }\n                }\n            } catch (rpcError) {\n                console.error('RPC call failed:', rpcError);\n            }\n            // If payout system failed, do basic market resolution\n            if (!payoutProcessed) {\n                console.log('Using basic market resolution');\n                // Update market status\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'resolved',\n                    outcome: finalOutcome,\n                    resolved_at: new Date().toISOString()\n                }).eq('id', marketId);\n                if (updateError) {\n                    console.error('Error updating market status:', updateError);\n                    return {\n                        success: false,\n                        error: 'Failed to update market status'\n                    };\n                }\n                payoutSummary = {\n                    total_payouts: 0,\n                    total_amount: 0,\n                    winner_count: 0,\n                    message: 'Market resolved (basic resolution - payout system not available)'\n                };\n            }\n            // Update bet statuses to reflect resolution\n            // First get all matched bets for this market\n            const { data: matchedBets, error: fetchError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('id, outcome').eq('market_id', marketId).eq('status', 'matched');\n            if (fetchError) {\n                console.error('Error fetching matched bets:', fetchError);\n            } else if (matchedBets) {\n                // Update each bet individually based on outcome\n                for (const bet of matchedBets){\n                    const newStatus = bet.outcome === finalOutcome ? 'won' : 'lost';\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                        status: newStatus\n                    }).eq('id', bet.id);\n                }\n            }\n            return {\n                success: true,\n                payoutSummary: payoutSummary ? {\n                    totalPayouts: payoutSummary.total_payouts || 0,\n                    totalAmount: payoutSummary.total_amount || 0,\n                    message: payoutSummary.message || 'Market resolved successfully'\n                } : {\n                    totalPayouts: 0,\n                    totalAmount: 0,\n                    message: 'Market resolved (basic resolution)'\n                },\n                autoDetermined,\n                confidence\n            };\n        } catch (error) {\n            console.error('Error in resolveMarket:', error);\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Automatically resolve markets that have ended and have sufficient confidence\n   * This method can be called by a cron job or scheduled task\n   */ static async autoResolveExpiredMarkets(minConfidence = 70) {\n        try {\n            console.log('Starting automatic market resolution...');\n            // Get all expired markets that are still active or closed\n            const { data: expiredMarkets, error: marketsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('id, title, end_date, status').in('status', [\n                'active',\n                'closed'\n            ]).lt('end_date', new Date().toISOString()).order('end_date', {\n                ascending: true\n            });\n            if (marketsError) {\n                return {\n                    success: false,\n                    error: marketsError.message,\n                    processed: 0,\n                    resolved: 0,\n                    failed: 0,\n                    results: []\n                };\n            }\n            if (!expiredMarkets || expiredMarkets.length === 0) {\n                console.log('No expired markets found for auto-resolution');\n                return {\n                    success: true,\n                    processed: 0,\n                    resolved: 0,\n                    failed: 0,\n                    results: []\n                };\n            }\n            console.log(`Found ${expiredMarkets.length} expired markets to process`);\n            const results = [];\n            let resolvedCount = 0;\n            let failedCount = 0;\n            // Process each expired market\n            for (const market of expiredMarkets){\n                console.log(`Processing market: ${market.title} (${market.id})`);\n                try {\n                    // Determine the winning outcome\n                    const determination = await this.determineWinningOutcome(market.id);\n                    if (determination.outcome && determination.confidence >= minConfidence) {\n                        // Auto-resolve the market\n                        const resolveResult = await this.resolveMarket(market.id, determination.outcome);\n                        if (resolveResult.success) {\n                            resolvedCount++;\n                            console.log(`✅ Auto-resolved market \"${market.title}\": ${determination.outcome} (${determination.confidence.toFixed(1)}% confidence)`);\n                            results.push({\n                                marketId: market.id,\n                                marketTitle: market.title,\n                                outcome: determination.outcome,\n                                confidence: determination.confidence,\n                                reasoning: determination.reasoning,\n                                success: true\n                            });\n                        } else {\n                            failedCount++;\n                            console.log(`❌ Failed to resolve market \"${market.title}\": ${resolveResult.error}`);\n                            results.push({\n                                marketId: market.id,\n                                marketTitle: market.title,\n                                outcome: determination.outcome,\n                                confidence: determination.confidence,\n                                reasoning: determination.reasoning,\n                                success: false,\n                                error: resolveResult.error\n                            });\n                        }\n                    } else {\n                        // Insufficient confidence for auto-resolution\n                        console.log(`⚠️ Insufficient confidence for market \"${market.title}\": ${determination.confidence.toFixed(1)}% (min: ${minConfidence}%)`);\n                        results.push({\n                            marketId: market.id,\n                            marketTitle: market.title,\n                            outcome: determination.outcome,\n                            confidence: determination.confidence,\n                            reasoning: determination.reasoning,\n                            success: false,\n                            error: `Insufficient confidence: ${determination.confidence.toFixed(1)}% < ${minConfidence}%`\n                        });\n                    }\n                } catch (error) {\n                    failedCount++;\n                    console.error(`Error processing market \"${market.title}\":`, error);\n                    results.push({\n                        marketId: market.id,\n                        marketTitle: market.title,\n                        outcome: null,\n                        confidence: 0,\n                        reasoning: 'Error during processing',\n                        success: false,\n                        error: error.message\n                    });\n                }\n            }\n            console.log(`Auto-resolution completed: ${resolvedCount} resolved, ${failedCount} failed`);\n            return {\n                success: true,\n                processed: expiredMarkets.length,\n                resolved: resolvedCount,\n                failed: failedCount,\n                results\n            };\n        } catch (error) {\n            console.error('Error in autoResolveExpiredMarkets:', error);\n            return {\n                success: false,\n                error: error.message,\n                processed: 0,\n                resolved: 0,\n                failed: 0,\n                results: []\n            };\n        }\n    }\n    /**\n   * Cancel a market and process refunds\n   */ static async cancelMarket(marketId, reason = 'Market cancelled by admin') {\n        try {\n            // Try to use the refund processing system, fallback to basic cancellation if not available\n            let refundProcessed = false;\n            let refundSummary = null;\n            try {\n                const { data: refundResult, error: refundError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('process_market_refunds', {\n                    p_market_id: marketId\n                });\n                if (refundError) {\n                    console.error('Error processing refunds:', refundError);\n                    // Check if it's because the refund system isn't set up\n                    if (refundError.message && (refundError.message.includes('function process_market_refunds') || refundError.message.includes('does not exist'))) {\n                        console.log('Refund system not set up, using basic cancellation');\n                    } else {\n                        console.error('Refund error:', refundError.message || 'Unknown refund error');\n                    }\n                } else {\n                    const result = refundResult?.[0];\n                    if (result && result.success) {\n                        refundProcessed = true;\n                        refundSummary = result;\n                    }\n                }\n            } catch (rpcError) {\n                console.error('Refund RPC call failed:', rpcError);\n            }\n            // If refund system failed, do basic market cancellation\n            if (!refundProcessed) {\n                console.log('Using basic market cancellation');\n                // Update market status to cancelled\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'cancelled',\n                    cancelled_at: new Date().toISOString(),\n                    cancellation_reason: reason\n                }).eq('id', marketId);\n                if (updateError) {\n                    console.error('Error updating market status:', updateError);\n                    return {\n                        success: false,\n                        error: 'Failed to update market status'\n                    };\n                }\n                refundSummary = {\n                    total_refunds: 0,\n                    refunded_bets: 0,\n                    message: 'Market cancelled (basic cancellation - refund system not available)'\n                };\n            }\n            // Update bet statuses to cancelled\n            const { error: betUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'cancelled'\n            }).eq('market_id', marketId).in('status', [\n                'seeded',\n                'live',\n                'matched'\n            ]);\n            if (betUpdateError) {\n                console.error('Error updating bet statuses:', betUpdateError);\n            // Don't fail the entire operation for this\n            }\n            return {\n                success: true,\n                refundSummary: refundSummary ? {\n                    totalRefunds: refundSummary.total_refunds || 0,\n                    totalAmount: refundSummary.total_amount || 0,\n                    message: refundSummary.message || 'Market cancelled successfully'\n                } : {\n                    totalRefunds: 0,\n                    totalAmount: 0,\n                    message: 'Market cancelled (basic cancellation)'\n                }\n            };\n        } catch (error) {\n            console.error('Error in cancelMarket:', error);\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Calculate market prices based on seeded and live betting system\n   * Prices reflect the distribution of both seeded and live money\n   */ static async calculateMarketPrices(marketId) {\n        try {\n            // Get all matched bets for this market\n            const { data: bets, error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('seeded_amount, live_amount, outcome').eq('market_id', marketId).eq('status', 'matched');\n            if (error) {\n                console.error('Error fetching bets:', error);\n                return {\n                    yes_price: 0.5,\n                    no_price: 0.5,\n                    total_volume: 0,\n                    yes_pool: 0,\n                    no_pool: 0,\n                    seeded_volume: 0,\n                    live_volume: 0\n                };\n            }\n            // Calculate pools for each outcome and type\n            let yesSeededPool = 0;\n            let noSeededPool = 0;\n            let yesLivePool = 0;\n            let noLivePool = 0;\n            let totalSeededVolume = 0;\n            let totalLiveVolume = 0;\n            bets?.forEach((bet)=>{\n                const seededAmount = bet.seeded_amount || 0;\n                const liveAmount = bet.live_amount || 0;\n                totalSeededVolume += seededAmount;\n                totalLiveVolume += liveAmount;\n                if (bet.outcome === 'yes') {\n                    yesSeededPool += seededAmount;\n                    yesLivePool += liveAmount;\n                } else {\n                    noSeededPool += seededAmount;\n                    noLivePool += liveAmount;\n                }\n            });\n            const totalVolume = totalSeededVolume + totalLiveVolume;\n            const yesPool = yesSeededPool + yesLivePool;\n            const noPool = noSeededPool + noLivePool;\n            // Calculate prices based on total pool sizes\n            let yesPrice = 0.5 // Default to 50/50 if no bets\n            ;\n            let noPrice = 0.5;\n            if (totalVolume > 0) {\n                yesPrice = yesPool / totalVolume;\n                noPrice = noPool / totalVolume;\n            }\n            return {\n                yes_price: yesPrice,\n                no_price: noPrice,\n                total_volume: totalVolume,\n                yes_pool: yesPool,\n                no_pool: noPool,\n                seeded_volume: totalSeededVolume,\n                live_volume: totalLiveVolume\n            };\n        } catch (error) {\n            console.error('Error calculating market prices:', error);\n            return {\n                yes_price: 0.5,\n                no_price: 0.5,\n                total_volume: 0,\n                yes_pool: 0,\n                no_pool: 0,\n                seeded_volume: 0,\n                live_volume: 0\n            };\n        }\n    }\n    /**\n   * Get user's portfolio\n   */ static async getUserPortfolio(userId) {\n        try {\n            // Get user profile\n            const { data: profile } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('*').eq('id', userId).single();\n            // Get user's active bets\n            const { data: activeBets } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select(`\n          *,\n          markets (\n            title,\n            status,\n            outcome\n          )\n        `).eq('user_id', userId).eq('status', 'matched');\n            // Get user's transaction history for winnings calculation\n            const { data: transactions } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').select('*').eq('user_id', userId).eq('type', 'win');\n            const totalWinnings = transactions?.reduce((sum, tx)=>sum + tx.amount, 0) || 0;\n            const totalBets = activeBets?.length || 0;\n            return {\n                profile,\n                activeBets: activeBets || [],\n                totalWinnings,\n                totalBets\n            };\n        } catch (error) {\n            console.error('Error getting user portfolio:', error);\n            return {\n                profile: null,\n                activeBets: [],\n                totalWinnings: 0,\n                totalBets: 0\n            };\n        }\n    }\n    /**\n   * Get market analytics\n   */ static async getMarketAnalytics(marketId) {\n        try {\n            // Get all bets for this market\n            const { data: bets } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('market_id', marketId).eq('status', 'matched');\n            const totalBets = bets?.length || 0;\n            const totalVolume = bets?.reduce((sum, bet)=>sum + bet.amount, 0) || 0;\n            const yesBets = bets?.filter((bet)=>bet.outcome === 'yes').length || 0;\n            const noBets = bets?.filter((bet)=>bet.outcome === 'no').length || 0;\n            // Get unique users\n            const uniqueUsers = new Set(bets?.map((bet)=>bet.user_id)).size;\n            // No mock data - return empty price history\n            const priceHistory = [];\n            return {\n                totalBets,\n                totalVolume,\n                yesBets,\n                noBets,\n                uniqueUsers,\n                priceHistory\n            };\n        } catch (error) {\n            console.error('Error getting market analytics:', error);\n            return {\n                totalBets: 0,\n                totalVolume: 0,\n                yesBets: 0,\n                noBets: 0,\n                uniqueUsers: 0,\n                priceHistory: []\n            };\n        }\n    }\n    /**\n   * Cancel a pending bet\n   */ static async cancelBet(betId, userId) {\n        try {\n            // Check if bet exists and belongs to user\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('id', betId).eq('user_id', userId).single();\n            if (betError || !bet) {\n                return {\n                    success: false,\n                    error: 'Bet not found'\n                };\n            }\n            // Check if bet is pending\n            if (bet.status !== 'pending') {\n                return {\n                    success: false,\n                    error: 'Cannot cancel matched bet'\n                };\n            }\n            // Update bet status\n            const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'cancelled'\n            }).eq('id', betId);\n            if (updateError) {\n                return {\n                    success: false,\n                    error: updateError.message\n                };\n            }\n            // Refund the user\n            const { error: refundError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: bet.amount\n            }).eq('id', userId);\n            if (refundError) {\n                return {\n                    success: false,\n                    error: refundError.message\n                };\n            }\n            return {\n                success: true\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./src/lib/betting.ts\n");

/***/ })

};
;