"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "_ssr_src_lib_services_notificationService_ts";
exports.ids = ["_ssr_src_lib_services_notificationService_ts"];
exports.modules = {

/***/ "(ssr)/./src/lib/services/emailService.ts":
/*!******************************************!*\
  !*** ./src/lib/services/emailService.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmailService: () => (/* binding */ EmailService),\n/* harmony export */   defaultEmailConfig: () => (/* binding */ defaultEmailConfig),\n/* harmony export */   emailService: () => (/* binding */ emailService)\n/* harmony export */ });\n// Dynamic import for server-side only\nlet nodemailer = null;\nclass EmailService {\n    constructor(config){\n        this.transporter = null;\n        this.config = config;\n        // Initialize transporter only on server side\n        if (true) {\n            this.initializeTransporter();\n        }\n    }\n    async initializeTransporter() {\n        if (false) {} // Skip on client side\n        try {\n            nodemailer = await __webpack_require__.e(/*! import() */ \"vendor-chunks/nodemailer\").then(__webpack_require__.t.bind(__webpack_require__, /*! nodemailer */ \"(ssr)/./node_modules/nodemailer/lib/nodemailer.js\", 19));\n            this.transporter = nodemailer.createTransporter({\n                host: this.config.host,\n                port: this.config.port,\n                secure: this.config.secure,\n                auth: {\n                    user: this.config.auth.user,\n                    pass: this.config.auth.pass\n                }\n            });\n        } catch (error) {\n            console.error('Failed to initialize email transporter:', error);\n        }\n    }\n    /**\n   * Send an email\n   */ async sendEmail(emailData) {\n        try {\n            // Ensure transporter is initialized\n            if (!this.transporter) {\n                await this.initializeTransporter();\n            }\n            if (!this.transporter) {\n                console.error('Email transporter not available');\n                return false;\n            }\n            const mailOptions = {\n                from: emailData.from || this.config.auth.user,\n                to: emailData.to,\n                subject: emailData.subject,\n                html: emailData.html,\n                text: emailData.text\n            };\n            const result = await this.transporter.sendMail(mailOptions);\n            console.log('Email sent successfully:', result.messageId);\n            return true;\n        } catch (error) {\n            console.error('Error sending email:', error);\n            return false;\n        }\n    }\n    /**\n   * Send welcome email to new user\n   */ async sendWelcomeEmail(userEmail1, userName) {\n        const template = this.getWelcomeEmailTemplate(userName);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send bet result email\n   */ async sendBetResultEmail(userEmail1, userName, outcome, amount, marketTitle) {\n        const template = this.getBetResultEmailTemplate(userName, outcome, amount, marketTitle);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send deposit confirmation email\n   */ async sendDepositConfirmationEmail(userEmail1, userName, amount, transactionId) {\n        const template = this.getDepositConfirmationTemplate(userName, amount, transactionId);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send withdrawal confirmation email\n   */ async sendWithdrawalConfirmationEmail(userEmail1, userName, amount, transactionId) {\n        const template = this.getWithdrawalConfirmationTemplate(userName, amount, transactionId);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send market resolution email\n   */ async sendMarketResolutionEmail(userEmail1, userName, marketTitle, winningOutcome, userOutcome, won, amount) {\n        const template = this.getMarketResolutionTemplate(userName, marketTitle, winningOutcome, userOutcome, won, amount);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send KYC status email\n   */ async sendKYCStatusEmail(userEmail1, userName, status, reason) {\n        const template = this.getKYCStatusTemplate(userName, status, reason);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    async sendRefundEmail(userEmail1, userName, amount, betId, outcome, marketTitle) {\n        const template = this.getRefundEmailTemplate(userName, amount, betId, outcome, marketTitle);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    async sendMarketRefundEmail(userEmail1, userName, amount, marketId, betCount) {\n        const template = this.getMarketRefundEmailTemplate(userName, amount, marketId, betCount);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Get welcome email template\n   */ getWelcomeEmailTemplate(userName) {\n        const subject = 'Welcome to BetFusion Zim! 🎉';\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Welcome to BetFusion Zim</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>🎉 Welcome to BetFusion Zim!</h1>\n            <p>Your prediction market journey starts here</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            <p>Welcome to BetFusion Zim, Zimbabwe's premier prediction market platform! We're excited to have you join our community of smart bettors and market predictors.</p>\n            \n            <h3>🚀 What you can do:</h3>\n            <ul>\n              <li><strong>Bet on Markets:</strong> Predict outcomes on various events and earn rewards</li>\n              <li><strong>Create Markets:</strong> Start your own prediction markets</li>\n              <li><strong>Track Performance:</strong> Monitor your betting history and performance</li>\n              <li><strong>Join Community:</strong> Connect with other predictors and share insights</li>\n            </ul>\n            \n            <p>Ready to start? Your account is all set up and ready to go!</p>\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}\" class=\"button\">Start Betting Now</a>\n            \n            <h3>💡 Quick Tips:</h3>\n            <ul>\n              <li>Start with small bets to get familiar with the platform</li>\n              <li>Read market descriptions carefully before placing bets</li>\n              <li>Check your email regularly for important updates</li>\n              <li>Join our community discussions for market insights</li>\n            </ul>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n            <p>This email was sent to ${userEmail}. If you didn't create an account, please ignore this email.</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\nWelcome to BetFusion Zim!\n\nHello ${userName}!\n\nWelcome to BetFusion Zim, Zimbabwe's premier prediction market platform! We're excited to have you join our community of smart bettors and market predictors.\n\nWhat you can do:\n- Bet on Markets: Predict outcomes on various events and earn rewards\n- Create Markets: Start your own prediction markets  \n- Track Performance: Monitor your betting history and performance\n- Join Community: Connect with other predictors and share insights\n\nReady to start? Your account is all set up and ready to go!\n\nVisit: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}\n\nQuick Tips:\n- Start with small bets to get familiar with the platform\n- Read market descriptions carefully before placing bets\n- Check your email regularly for important updates\n- Join our community discussions for market insights\n\nBest regards,\nThe BetFusion Zim Team\n\nThis email was sent to ${userEmail}. If you didn't create an account, please ignore this email.\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get bet result email template\n   */ getBetResultEmailTemplate(userName, outcome, amount, marketTitle) {\n        const isWin = outcome === 'won';\n        const subject = isWin ? `🎉 You Won $${amount.toFixed(2)} on ${marketTitle}!` : `📉 Bet Result: ${marketTitle}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Bet Result - ${marketTitle}</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: ${isWin ? 'linear-gradient(135deg, #10b981 0%, #059669 100%)' : 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)'}; color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .result-box { background: ${isWin ? '#d1fae5' : '#fee2e2'}; border: 2px solid ${isWin ? '#10b981' : '#ef4444'}; padding: 20px; border-radius: 8px; margin: 20px 0; text-align: center; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>${isWin ? '🎉 Congratulations!' : '📉 Bet Result'}</h1>\n            <p>${isWin ? 'You won your bet!' : 'Your bet result is in'}</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            \n            <div class=\"result-box\">\n              <h3>${isWin ? '🎉 You Won!' : '📉 You Lost'}</h3>\n              <p><strong>Market:</strong> ${marketTitle}</p>\n              <p><strong>Amount:</strong> $${amount.toFixed(2)}</p>\n              <p><strong>Result:</strong> ${isWin ? 'Won' : 'Lost'}</p>\n            </div>\n            \n            ${isWin ? `\n              <p>Congratulations! Your prediction was correct and you've won $${amount.toFixed(2)}! The funds have been added to your account balance.</p>\n              <p>Keep up the great work and continue making smart predictions!</p>\n            ` : `\n              <p>Unfortunately, your prediction didn't work out this time. Don't worry - every great predictor has ups and downs!</p>\n              <p>Keep analyzing the markets and trust your instincts for the next bet.</p>\n            `}\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/portfolio\" class=\"button\">View Your Portfolio</a>\n            \n            <h3>💡 What's Next?</h3>\n            <ul>\n              <li>Check out new markets and opportunities</li>\n              <li>Review your betting strategy</li>\n              <li>Join community discussions for insights</li>\n              <li>Create your own prediction markets</li>\n            </ul>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n${isWin ? '🎉 Congratulations! You Won!' : '📉 Bet Result'}\n\nHello ${userName}!\n\n${isWin ? 'Congratulations! Your prediction was correct and you\\'ve won $' + amount.toFixed(2) + '! The funds have been added to your account balance.' : 'Unfortunately, your prediction didn\\'t work out this time. Don\\'t worry - every great predictor has ups and downs!'}\n\nMarket: ${marketTitle}\nAmount: $${amount.toFixed(2)}\nResult: ${isWin ? 'Won' : 'Lost'}\n\n${isWin ? 'Keep up the great work and continue making smart predictions!' : 'Keep analyzing the markets and trust your instincts for the next bet.'}\n\nWhat's Next?\n- Check out new markets and opportunities\n- Review your betting strategy  \n- Join community discussions for insights\n- Create your own prediction markets\n\nVisit your portfolio: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/portfolio\n\nBest regards,\nThe BetFusion Zim Team\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get deposit confirmation template\n   */ getDepositConfirmationTemplate(userName, amount, transactionId) {\n        const subject = `💰 Deposit Confirmation - $${amount.toFixed(2)}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Deposit Confirmation</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .transaction-box { background: #d1fae5; border: 2px solid #10b981; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>💰 Deposit Confirmed!</h1>\n            <p>Your funds have been added to your account</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            \n            <div class=\"transaction-box\">\n              <h3>💰 Deposit Details</h3>\n              <p><strong>Amount:</strong> $${amount.toFixed(2)}</p>\n              <p><strong>Transaction ID:</strong> ${transactionId}</p>\n              <p><strong>Status:</strong> Completed</p>\n              <p><strong>Date:</strong> ${new Date().toLocaleDateString()}</p>\n            </div>\n            \n            <p>Your deposit has been successfully processed and the funds are now available in your account. You can start betting immediately!</p>\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/wallet\" class=\"button\">View Your Wallet</a>\n            \n            <h3>🚀 Ready to Bet?</h3>\n            <ul>\n              <li>Browse available markets</li>\n              <li>Place your first bet</li>\n              <li>Create your own markets</li>\n              <li>Join community discussions</li>\n            </ul>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n💰 Deposit Confirmation\n\nHello ${userName}!\n\nYour deposit has been successfully processed and the funds are now available in your account.\n\nDeposit Details:\n- Amount: $${amount.toFixed(2)}\n- Transaction ID: ${transactionId}\n- Status: Completed\n- Date: ${new Date().toLocaleDateString()}\n\nYou can start betting immediately!\n\nReady to Bet?\n- Browse available markets\n- Place your first bet\n- Create your own markets\n- Join community discussions\n\nView your wallet: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/wallet\n\nBest regards,\nThe BetFusion Zim Team\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get withdrawal confirmation template\n   */ getWithdrawalConfirmationTemplate(userName, amount, transactionId) {\n        const subject = `💸 Withdrawal Confirmation - $${amount.toFixed(2)}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Withdrawal Confirmation</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .transaction-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>💸 Withdrawal Confirmed!</h1>\n            <p>Your withdrawal request has been processed</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            \n            <div class=\"transaction-box\">\n              <h3>💸 Withdrawal Details</h3>\n              <p><strong>Amount:</strong> $${amount.toFixed(2)}</p>\n              <p><strong>Transaction ID:</strong> ${transactionId}</p>\n              <p><strong>Status:</strong> Processing</p>\n              <p><strong>Date:</strong> ${new Date().toLocaleDateString()}</p>\n            </div>\n            \n            <p>Your withdrawal request has been submitted and is being processed. Funds will be transferred to your account within 1-3 business days.</p>\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/wallet\" class=\"button\">View Your Wallet</a>\n            \n            <h3>📋 Important Notes:</h3>\n            <ul>\n              <li>Processing time: 1-3 business days</li>\n              <li>You'll receive another email when the transfer is complete</li>\n              <li>Contact support if you have any questions</li>\n            </ul>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n💸 Withdrawal Confirmation\n\nHello ${userName}!\n\nYour withdrawal request has been submitted and is being processed.\n\nWithdrawal Details:\n- Amount: $${amount.toFixed(2)}\n- Transaction ID: ${transactionId}\n- Status: Processing\n- Date: ${new Date().toLocaleDateString()}\n\nFunds will be transferred to your account within 1-3 business days.\n\nImportant Notes:\n- Processing time: 1-3 business days\n- You'll receive another email when the transfer is complete\n- Contact support if you have any questions\n\nView your wallet: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/wallet\n\nBest regards,\nThe BetFusion Zim Team\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get market resolution template\n   */ getMarketResolutionTemplate(userName, marketTitle, winningOutcome, userOutcome, won, amount) {\n        const subject = `🏁 Market Resolved: ${marketTitle}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Market Resolution - ${marketTitle}</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .result-box { background: ${won ? '#d1fae5' : '#fee2e2'}; border: 2px solid ${won ? '#10b981' : '#ef4444'}; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>🏁 Market Resolved!</h1>\n            <p>The market has been closed and results are in</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            \n            <div class=\"result-box\">\n              <h3>🏁 Market Results</h3>\n              <p><strong>Market:</strong> ${marketTitle}</p>\n              <p><strong>Winning Outcome:</strong> ${winningOutcome}</p>\n              <p><strong>Your Prediction:</strong> ${userOutcome}</p>\n              <p><strong>Result:</strong> ${won ? '🎉 You Won!' : '📉 You Lost'}</p>\n              ${won ? `<p><strong>Winnings:</strong> $${amount.toFixed(2)}</p>` : ''}\n            </div>\n            \n            <p>The market \"${marketTitle}\" has been resolved. ${won ? 'Congratulations on your winning prediction!' : 'Better luck next time!'}</p>\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/portfolio\" class=\"button\">View Your Portfolio</a>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n🏁 Market Resolved!\n\nHello ${userName}!\n\nThe market \"${marketTitle}\" has been resolved.\n\nMarket Results:\n- Market: ${marketTitle}\n- Winning Outcome: ${winningOutcome}\n- Your Prediction: ${userOutcome}\n- Result: ${won ? '🎉 You Won!' : '📉 You Lost'}\n${won ? `- Winnings: $${amount.toFixed(2)}` : ''}\n\n${won ? 'Congratulations on your winning prediction!' : 'Better luck next time!'}\n\nView your portfolio: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/portfolio\n\nBest regards,\nThe BetFusion Zim Team\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get KYC status template\n   */ getKYCStatusTemplate(userName, status, reason) {\n        const isApproved = status === 'approved';\n        const subject = isApproved ? '✅ KYC Verification Approved!' : '❌ KYC Verification Update';\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>KYC ${isApproved ? 'Approved' : 'Update'}</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: ${isApproved ? 'linear-gradient(135deg, #10b981 0%, #059669 100%)' : 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)'}; color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .status-box { background: ${isApproved ? '#d1fae5' : '#fee2e2'}; border: 2px solid ${isApproved ? '#10b981' : '#ef4444'}; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>${isApproved ? '✅ KYC Approved!' : '❌ KYC Update'}</h1>\n            <p>${isApproved ? 'Your identity has been verified' : 'Your KYC status has been updated'}</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            \n            <div class=\"status-box\">\n              <h3>${isApproved ? '✅ Verification Approved' : '❌ Verification Update'}</h3>\n              <p><strong>Status:</strong> ${isApproved ? 'Approved' : 'Rejected'}</p>\n              ${!isApproved && reason ? `<p><strong>Reason:</strong> ${reason}</p>` : ''}\n              <p><strong>Date:</strong> ${new Date().toLocaleDateString()}</p>\n            </div>\n            \n            ${isApproved ? `\n              <p>Congratulations! Your identity has been successfully verified. You now have full access to all platform features including higher withdrawal limits and enhanced security.</p>\n              <p>You can now enjoy all the benefits of a verified account!</p>\n            ` : `\n              <p>We were unable to verify your identity at this time. ${reason ? `Reason: ${reason}` : 'Please ensure all documents are clear and valid.'}</p>\n              <p>You can resubmit your KYC documents for review.</p>\n            `}\n            \n            <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/kyc\" class=\"button\">${isApproved ? 'View Your Profile' : 'Resubmit KYC'}</a>\n          </div>\n          <div class=\"footer\">\n            <p>Best regards,<br>The BetFusion Zim Team</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n${isApproved ? '✅ KYC Approved!' : '❌ KYC Update'}\n\nHello ${userName}!\n\n${isApproved ? 'Congratulations! Your identity has been successfully verified. You now have full access to all platform features including higher withdrawal limits and enhanced security.' : 'We were unable to verify your identity at this time. ' + (reason ? `Reason: ${reason}` : 'Please ensure all documents are clear and valid.')}\n\nStatus: ${isApproved ? 'Approved' : 'Rejected'}\n${!isApproved && reason ? `Reason: ${reason}` : ''}\nDate: ${new Date().toLocaleDateString()}\n\n${isApproved ? 'You can now enjoy all the benefits of a verified account!' : 'You can resubmit your KYC documents for review.'}\n\n${isApproved ? 'View your profile' : 'Resubmit KYC'}: ${process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000'}/kyc\n\nBest regards,\nThe BetFusion Zim Team\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get refund email template\n   */ getRefundEmailTemplate(userName, amount, betId, outcome, marketTitle) {\n        const subject = `💰 Bet Refund Processed - $${amount.toFixed(2)}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Bet Refund Processed</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .refund-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>💰 Bet Refund Processed</h1>\n            <p>Your bet has been refunded successfully</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            <p>Your bet has been refunded and the amount has been added back to your account balance.</p>\n            \n            <div class=\"refund-box\">\n              <h3>Refund Details</h3>\n              <p><strong>Refund Amount:</strong> $${amount.toFixed(2)}</p>\n              <p><strong>Bet ID:</strong> ${betId}</p>\n              <p><strong>Outcome:</strong> ${outcome}</p>\n              <p><strong>Market:</strong> ${marketTitle}</p>\n            </div>\n            \n            <div style=\"background: #d1fae5; border: 2px solid #10b981; padding: 15px; border-radius: 8px; margin: 20px 0;\">\n              <p style=\"margin: 0; color: #166534;\"><strong>✅ Refund Complete</strong><br>\n              The refunded amount is now available in your account balance and can be used for new bets or withdrawals.</p>\n            </div>\n            \n            <div style=\"text-align: center;\">\n              <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com'}/wallet\" class=\"button\">View Your Wallet</a>\n            </div>\n            \n            <p>If you have any questions about this refund, please contact our support team.</p>\n          </div>\n          <div class=\"footer\">\n            <p>© 2024 BetFusion Zim. All rights reserved.</p>\n            <p>This is an automated message. Please do not reply to this email.</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n      Bet Refund Processed - BetFusion Zim\n      \n      Hello ${userName}!\n      \n      Your bet has been refunded and the amount has been added back to your account balance.\n      \n      Refund Details:\n      - Refund Amount: $${amount.toFixed(2)}\n      - Bet ID: ${betId}\n      - Outcome: ${outcome}\n      - Market: ${marketTitle}\n      \n      The refunded amount is now available in your account balance and can be used for new bets or withdrawals.\n      \n      View Your Wallet: ${process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com'}/wallet\n      \n      If you have any questions about this refund, please contact our support team.\n      \n      © 2024 BetFusion Zim. All rights reserved.\n      This is an automated message. Please do not reply to this email.\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get market refund email template\n   */ getMarketRefundEmailTemplate(userName, amount, marketId, betCount) {\n        const subject = `💰 Market Refund Processed - $${amount.toFixed(2)}`;\n        const html = `\n      <!DOCTYPE html>\n      <html>\n      <head>\n        <meta charset=\"utf-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n        <title>Market Refund Processed</title>\n        <style>\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\n          .refund-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\n        </style>\n      </head>\n      <body>\n        <div class=\"container\">\n          <div class=\"header\">\n            <h1>💰 Market Refund Processed</h1>\n            <p>Your market bets have been refunded successfully</p>\n          </div>\n          <div class=\"content\">\n            <h2>Hello ${userName}!</h2>\n            <p>All your bets in this market have been refunded and the total amount has been added back to your account balance.</p>\n            \n            <div class=\"refund-box\">\n              <h3>Market Refund Details</h3>\n              <p><strong>Total Refund Amount:</strong> $${amount.toFixed(2)}</p>\n              <p><strong>Market ID:</strong> ${marketId}</p>\n              <p><strong>Number of Bets Refunded:</strong> ${betCount}</p>\n            </div>\n            \n            <div style=\"background: #d1fae5; border: 2px solid #10b981; padding: 15px; border-radius: 8px; margin: 20px 0;\">\n              <p style=\"margin: 0; color: #166534;\"><strong>✅ Market Refund Complete</strong><br>\n              All your bets in this market have been refunded. The total amount is now available in your account balance and can be used for new bets or withdrawals.</p>\n            </div>\n            \n            <div style=\"text-align: center;\">\n              <a href=\"${process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com'}/wallet\" class=\"button\">View Your Wallet</a>\n            </div>\n            \n            <p>If you have any questions about this market refund, please contact our support team.</p>\n          </div>\n          <div class=\"footer\">\n            <p>© 2024 BetFusion Zim. All rights reserved.</p>\n            <p>This is an automated message. Please do not reply to this email.</p>\n          </div>\n        </div>\n      </body>\n      </html>\n    `;\n        const text = `\n      Market Refund Processed - BetFusion Zim\n      \n      Hello ${userName}!\n      \n      All your bets in this market have been refunded and the total amount has been added back to your account balance.\n      \n      Market Refund Details:\n      - Total Refund Amount: $${amount.toFixed(2)}\n      - Market ID: ${marketId}\n      - Number of Bets Refunded: ${betCount}\n      \n      All your bets in this market have been refunded. The total amount is now available in your account balance and can be used for new bets or withdrawals.\n      \n      View Your Wallet: ${process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com'}/wallet\n      \n      If you have any questions about this market refund, please contact our support team.\n      \n      © 2024 BetFusion Zim. All rights reserved.\n      This is an automated message. Please do not reply to this email.\n    `;\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n}\n// Default email configuration\nconst defaultEmailConfig = {\n    host: process.env.SMTP_HOST || 'smtp.gmail.com',\n    port: parseInt(process.env.SMTP_PORT || '587'),\n    secure: process.env.SMTP_SECURE === 'true',\n    auth: {\n        user: process.env.SMTP_USER || '',\n        pass: process.env.SMTP_PASS || ''\n    }\n};\n// Create default email service instance\nconst emailService = new EmailService(defaultEmailConfig);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./src/lib/services/emailService.ts\n");

/***/ }),

/***/ "(ssr)/./src/lib/services/notificationService.ts":
/*!*************************************************!*\
  !*** ./src/lib/services/notificationService.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NotificationService: () => (/* binding */ NotificationService),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/lib/supabase-client */ \"(ssr)/./src/lib/supabase-client.ts\");\n/* harmony import */ var _emailService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emailService */ \"(ssr)/./src/lib/services/emailService.ts\");\n// Notification Service for BetFusion Zim\n// Handles real-time notifications for various events\n\n\nclass NotificationService {\n    /**\n   * Create a new notification\n   */ static async createNotification(userId, title, message, type = 'info', data, sendEmail = false) {\n        try {\n            const { data: notification, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').insert({\n                user_id: userId,\n                title,\n                message,\n                type,\n                data,\n                is_read: false\n            }).select().single();\n            if (error) {\n                console.error('Error creating notification:', error);\n                return null;\n            }\n            // Send email if requested\n            if (sendEmail) {\n                await this.sendNotificationEmail(userId, title, message, type, data);\n            }\n            return notification;\n        } catch (error) {\n            console.error('Error in createNotification:', error);\n            return null;\n        }\n    }\n    /**\n   * Get user notifications\n   */ static async getUserNotifications(userId, limit = 20, unreadOnly = false) {\n        try {\n            let query = _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').select('*').eq('user_id', userId).order('created_at', {\n                ascending: false\n            }).limit(limit);\n            if (unreadOnly) {\n                query = query.eq('is_read', false);\n            }\n            const { data, error } = await query;\n            if (error) {\n                console.error('Error fetching notifications:', error);\n                return [];\n            }\n            return data || [];\n        } catch (error) {\n            console.error('Error in getUserNotifications:', error);\n            return [];\n        }\n    }\n    /**\n   * Mark notification as read\n   */ static async markAsRead(notificationId) {\n        try {\n            const { error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').update({\n                is_read: true,\n                updated_at: new Date().toISOString()\n            }).eq('id', notificationId);\n            if (error) {\n                console.error('Error marking notification as read:', error);\n                return false;\n            }\n            return true;\n        } catch (error) {\n            console.error('Error in markAsRead:', error);\n            return false;\n        }\n    }\n    /**\n   * Mark all notifications as read for a user\n   */ static async markAllAsRead(userId) {\n        try {\n            const { error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').update({\n                is_read: true,\n                updated_at: new Date().toISOString()\n            }).eq('user_id', userId).eq('is_read', false);\n            if (error) {\n                console.error('Error marking all notifications as read:', error);\n                return false;\n            }\n            return true;\n        } catch (error) {\n            console.error('Error in markAllAsRead:', error);\n            return false;\n        }\n    }\n    /**\n   * Get unread notification count\n   */ static async getUnreadCount(userId) {\n        try {\n            const { count, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').select('*', {\n                count: 'exact',\n                head: true\n            }).eq('user_id', userId).eq('is_read', false);\n            if (error) {\n                console.error('Error getting unread count:', error);\n                return 0;\n            }\n            return count || 0;\n        } catch (error) {\n            console.error('Error in getUnreadCount:', error);\n            return 0;\n        }\n    }\n    /**\n   * Notification templates for different events\n   */ static getNotificationTemplate(type, data) {\n        switch(type){\n            case 'bet_won':\n                return {\n                    title: '🎉 Bet Won!',\n                    message: `Congratulations! You won $${data?.amount?.toFixed(2) || '0.00'} on \"${data?.marketTitle || 'your bet'}\"`,\n                    notificationType: 'success'\n                };\n            case 'bet_lost':\n                return {\n                    title: 'Bet Result',\n                    message: `Your bet on \"${data?.marketTitle || 'the market'}\" didn't win this time. Better luck next time!`,\n                    notificationType: 'info'\n                };\n            case 'new_market_available':\n                return {\n                    title: '🆕 New Market Available',\n                    message: `\"${data?.marketTitle || 'New market'}\" is now live for betting!`,\n                    notificationType: 'info'\n                };\n            case 'market_resolved':\n                return {\n                    title: 'Market Resolved',\n                    message: `\"${data?.marketTitle || 'Market'}\" has been resolved. Check your results!`,\n                    notificationType: 'info'\n                };\n            case 'deposit_received':\n                return {\n                    title: '💰 Deposit Received',\n                    message: `Your deposit of $${data?.amount?.toFixed(2) || '0.00'} has been processed successfully.`,\n                    notificationType: 'success'\n                };\n            case 'withdrawal_processed':\n                return {\n                    title: '💸 Withdrawal Processed',\n                    message: `Your withdrawal of $${data?.amount?.toFixed(2) || '0.00'} has been processed.`,\n                    notificationType: 'success'\n                };\n            case 'referral_bonus':\n                return {\n                    title: '🎁 Referral Bonus',\n                    message: `You received a $${data?.amount?.toFixed(2) || '0.00'} bonus for referring a friend!`,\n                    notificationType: 'success'\n                };\n            case 'achievement_unlocked':\n                return {\n                    title: '🏆 Achievement Unlocked',\n                    message: `You've unlocked the \"${data?.achievementName || 'Achievement'}\" achievement!`,\n                    notificationType: 'success'\n                };\n            case 'price_alert':\n                return {\n                    title: '📈 Price Alert',\n                    message: `\"${data?.marketTitle || 'Market'}\" price has reached your alert level of ${data?.price || '0'}%`,\n                    notificationType: 'warning'\n                };\n            case 'liquidity_reward':\n                return {\n                    title: '💧 Liquidity Reward',\n                    message: `You earned $${data?.amount?.toFixed(2) || '0.00'} for providing liquidity to \"${data?.marketTitle || 'market'}\"`,\n                    notificationType: 'success'\n                };\n            case 'market_seeded':\n                return {\n                    title: '🌱 Market Seeded',\n                    message: `Your market \"${data?.marketTitle || 'Market'}\" has been successfully seeded with $${data?.amount?.toFixed(2) || '0.00'}`,\n                    notificationType: 'success'\n                };\n            case 'kyc_approved':\n                return {\n                    title: '✅ KYC Approved',\n                    message: 'Your identity verification has been approved. You now have full access to all features.',\n                    notificationType: 'success'\n                };\n            case 'kyc_rejected':\n                return {\n                    title: '❌ KYC Rejected',\n                    message: `Your identity verification was rejected. Reason: ${data?.reason || 'Please try again'}`,\n                    notificationType: 'error'\n                };\n            default:\n                return {\n                    title: 'Notification',\n                    message: 'You have a new notification',\n                    notificationType: 'info'\n                };\n        }\n    }\n    /**\n   * Create notification for specific event type\n   */ static async createEventNotification(userId, eventType, eventData, sendEmail = false) {\n        const template = this.getNotificationTemplate(eventType, eventData);\n        return this.createNotification(userId, template.title, template.message, template.notificationType, eventData, sendEmail);\n    }\n    /**\n   * Bulk create notifications for multiple users\n   */ static async createBulkNotifications(userIds, eventType, eventData) {\n        const template = this.getNotificationTemplate(eventType, eventData);\n        const notifications = [];\n        for (const userId of userIds){\n            const notification = await this.createNotification(userId, template.title, template.message, template.notificationType, eventData);\n            if (notification) {\n                notifications.push(notification);\n            }\n        }\n        return notifications;\n    }\n    /**\n   * Send notification email to user\n   */ static async sendNotificationEmail(userId, title, message, type, data) {\n        try {\n            // Get user profile to get email and name\n            const { data: profile, error: profileError } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('email, first_name, last_name').eq('id', userId).single();\n            if (profileError || !profile?.email) {\n                console.error('Error fetching user profile for email:', profileError);\n                return;\n            }\n            const userName = profile.first_name || 'User';\n            const userEmail = profile.email;\n            // Send appropriate email based on notification type\n            switch(type){\n                case 'success':\n                    if (data?.betResult) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendBetResultEmail(userEmail, userName, data.betResult.outcome, data.betResult.amount, data.betResult.marketTitle);\n                    } else if (data?.deposit) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendDepositConfirmationEmail(userEmail, userName, data.deposit.amount, data.deposit.transactionId);\n                    } else if (data?.withdrawal) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendWithdrawalConfirmationEmail(userEmail, userName, data.withdrawal.amount, data.withdrawal.transactionId);\n                    } else if (data?.kycStatus) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendKYCStatusEmail(userEmail, userName, data.kycStatus.status, data.kycStatus.reason);\n                    }\n                    break;\n                case 'info':\n                    if (data?.marketResolution) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendMarketResolutionEmail(userEmail, userName, data.marketResolution.marketTitle, data.marketResolution.winningOutcome, data.marketResolution.userOutcome, data.marketResolution.won, data.marketResolution.amount);\n                    }\n                    break;\n                default:\n                    // Send generic notification email\n                    await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendEmail({\n                        to: userEmail,\n                        subject: title,\n                        html: `\n              <div style=\"font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;\">\n                <h2>${title}</h2>\n                <p>${message}</p>\n                <p>Best regards,<br>The BetFusion Zim Team</p>\n              </div>\n            `,\n                        text: `${title}\\n\\n${message}\\n\\nBest regards,\\nThe BetFusion Zim Team`\n                    });\n                    break;\n            }\n        } catch (error) {\n            console.error('Error sending notification email:', error);\n        }\n    }\n    /**\n   * Send welcome email to new user\n   */ static async sendWelcomeEmail(userId) {\n        try {\n            const { data: profile, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('email, first_name').eq('id', userId).single();\n            if (error || !profile?.email) {\n                console.error('Error fetching user profile for welcome email:', error);\n                return false;\n            }\n            return await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendWelcomeEmail(profile.email, profile.first_name || 'User');\n        } catch (error) {\n            console.error('Error sending welcome email:', error);\n            return false;\n        }\n    }\n}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationService);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./src/lib/services/notificationService.ts\n");

/***/ })

};
;