/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/js-sha512";
exports.ids = ["vendor-chunks/js-sha512"];
exports.modules = {

/***/ "(ssr)/./node_modules/js-sha512/src/sha512.js":
/*!**********************************************!*\
  !*** ./node_modules/js-sha512/src/sha512.js ***!
  \**********************************************/
/***/ ((module, exports, __webpack_require__) => {

eval("var __WEBPACK_AMD_DEFINE_RESULT__;/*\n * [js-sha512]{@link https://github.com/emn178/js-sha512}\n *\n * @version 0.9.0\n * @author Chen, Yi-Cyuan [emn178@gmail.com]\n * @copyright Chen, Yi-Cyuan 2014-2024\n * @license MIT\n */\n/*jslint bitwise: true */\n(function () {\n  'use strict';\n\n  var INPUT_ERROR = 'input is invalid type';\n  var FINALIZE_ERROR = 'finalize already called';\n  var WINDOW = typeof window === 'object';\n  var root = WINDOW ? window : {};\n  if (root.JS_SHA512_NO_WINDOW) {\n    WINDOW = false;\n  }\n  var WEB_WORKER = !WINDOW && typeof self === 'object';\n  var NODE_JS = !root.JS_SHA512_NO_NODE_JS && typeof process === 'object' && process.versions && process.versions.node;\n  if (NODE_JS) {\n    root = global;\n  } else if (WEB_WORKER) {\n    root = self;\n  }\n  var COMMON_JS = !root.JS_SHA512_NO_COMMON_JS && \"object\" === 'object' && module.exports;\n  var AMD =  true && __webpack_require__.amdO;\n  var ARRAY_BUFFER = !root.JS_SHA512_NO_ARRAY_BUFFER && typeof ArrayBuffer !== 'undefined';\n  var HEX_CHARS = '0123456789abcdef'.split('');\n  var EXTRA = [-2147483648, 8388608, 32768, 128];\n  var SHIFT = [24, 16, 8, 0];\n  var K = [\n    0x428A2F98, 0xD728AE22, 0x71374491, 0x23EF65CD,\n    0xB5C0FBCF, 0xEC4D3B2F, 0xE9B5DBA5, 0x8189DBBC,\n    0x3956C25B, 0xF348B538, 0x59F111F1, 0xB605D019,\n    0x923F82A4, 0xAF194F9B, 0xAB1C5ED5, 0xDA6D8118,\n    0xD807AA98, 0xA3030242, 0x12835B01, 0x45706FBE,\n    0x243185BE, 0x4EE4B28C, 0x550C7DC3, 0xD5FFB4E2,\n    0x72BE5D74, 0xF27B896F, 0x80DEB1FE, 0x3B1696B1,\n    0x9BDC06A7, 0x25C71235, 0xC19BF174, 0xCF692694,\n    0xE49B69C1, 0x9EF14AD2, 0xEFBE4786, 0x384F25E3,\n    0x0FC19DC6, 0x8B8CD5B5, 0x240CA1CC, 0x77AC9C65,\n    0x2DE92C6F, 0x592B0275, 0x4A7484AA, 0x6EA6E483,\n    0x5CB0A9DC, 0xBD41FBD4, 0x76F988DA, 0x831153B5,\n    0x983E5152, 0xEE66DFAB, 0xA831C66D, 0x2DB43210,\n    0xB00327C8, 0x98FB213F, 0xBF597FC7, 0xBEEF0EE4,\n    0xC6E00BF3, 0x3DA88FC2, 0xD5A79147, 0x930AA725,\n    0x06CA6351, 0xE003826F, 0x14292967, 0x0A0E6E70,\n    0x27B70A85, 0x46D22FFC, 0x2E1B2138, 0x5C26C926,\n    0x4D2C6DFC, 0x5AC42AED, 0x53380D13, 0x9D95B3DF,\n    0x650A7354, 0x8BAF63DE, 0x766A0ABB, 0x3C77B2A8,\n    0x81C2C92E, 0x47EDAEE6, 0x92722C85, 0x1482353B,\n    0xA2BFE8A1, 0x4CF10364, 0xA81A664B, 0xBC423001,\n    0xC24B8B70, 0xD0F89791, 0xC76C51A3, 0x0654BE30,\n    0xD192E819, 0xD6EF5218, 0xD6990624, 0x5565A910,\n    0xF40E3585, 0x5771202A, 0x106AA070, 0x32BBD1B8,\n    0x19A4C116, 0xB8D2D0C8, 0x1E376C08, 0x5141AB53,\n    0x2748774C, 0xDF8EEB99, 0x34B0BCB5, 0xE19B48A8,\n    0x391C0CB3, 0xC5C95A63, 0x4ED8AA4A, 0xE3418ACB,\n    0x5B9CCA4F, 0x7763E373, 0x682E6FF3, 0xD6B2B8A3,\n    0x748F82EE, 0x5DEFB2FC, 0x78A5636F, 0x43172F60,\n    0x84C87814, 0xA1F0AB72, 0x8CC70208, 0x1A6439EC,\n    0x90BEFFFA, 0x23631E28, 0xA4506CEB, 0xDE82BDE9,\n    0xBEF9A3F7, 0xB2C67915, 0xC67178F2, 0xE372532B,\n    0xCA273ECE, 0xEA26619C, 0xD186B8C7, 0x21C0C207,\n    0xEADA7DD6, 0xCDE0EB1E, 0xF57D4F7F, 0xEE6ED178,\n    0x06F067AA, 0x72176FBA, 0x0A637DC5, 0xA2C898A6,\n    0x113F9804, 0xBEF90DAE, 0x1B710B35, 0x131C471B,\n    0x28DB77F5, 0x23047D84, 0x32CAAB7B, 0x40C72493,\n    0x3C9EBE0A, 0x15C9BEBC, 0x431D67C4, 0x9C100D4C,\n    0x4CC5D4BE, 0xCB3E42B6, 0x597F299C, 0xFC657E2A,\n    0x5FCB6FAB, 0x3AD6FAEC, 0x6C44198C, 0x4A475817\n  ];\n\n  var OUTPUT_TYPES = ['hex', 'array', 'digest', 'arrayBuffer'];\n\n  var blocks = [];\n\n  var isArray = Array.isArray;\n  if (root.JS_SHA512_NO_NODE_JS || !isArray) {\n    isArray = function (obj) {\n      return Object.prototype.toString.call(obj) === '[object Array]';\n    };\n  }\n\n  var isView = ArrayBuffer.isView;\n  if (ARRAY_BUFFER && (root.JS_SHA512_NO_ARRAY_BUFFER_IS_VIEW || !isView)) {\n    isView = function (obj) {\n      return typeof obj === 'object' && obj.buffer && obj.buffer.constructor === ArrayBuffer;\n    };\n  }\n\n  // [message: string, isString: bool]\n  var formatMessage = function (message) {\n    var type = typeof message;\n    if (type === 'string') {\n      return [message, true];\n    }\n    if (type !== 'object' || message === null) {\n      throw new Error(INPUT_ERROR);\n    }\n    if (ARRAY_BUFFER && message.constructor === ArrayBuffer) {\n      return [new Uint8Array(message), false];\n    }\n    if (!isArray(message) && !isView(message)) {\n      throw new Error(INPUT_ERROR);\n    }\n    return [message, false];\n  }\n\n  var createOutputMethod = function (outputType, bits) {\n    return function (message) {\n      return new Sha512(bits, true).update(message)[outputType]();\n    };\n  };\n\n  var createMethod = function (bits) {\n    var method = createOutputMethod('hex', bits);\n    method.create = function () {\n      return new Sha512(bits);\n    };\n    method.update = function (message) {\n      return method.create().update(message);\n    };\n    for (var i = 0; i < OUTPUT_TYPES.length; ++i) {\n      var type = OUTPUT_TYPES[i];\n      method[type] = createOutputMethod(type, bits);\n    }\n    return method;\n  };\n\n  var createHmacOutputMethod = function (outputType, bits) {\n    return function (key, message) {\n      return new HmacSha512(key, bits, true).update(message)[outputType]();\n    };\n  };\n\n  var createHmacMethod = function (bits) {\n    var method = createHmacOutputMethod('hex', bits);\n    method.create = function (key) {\n      return new HmacSha512(key, bits);\n    };\n    method.update = function (key, message) {\n      return method.create(key).update(message);\n    };\n    for (var i = 0; i < OUTPUT_TYPES.length; ++i) {\n      var type = OUTPUT_TYPES[i];\n      method[type] = createHmacOutputMethod(type, bits);\n    }\n    return method;\n  };\n\n  function Sha512(bits, sharedMemory) {\n    if (sharedMemory) {\n      blocks[0] = blocks[1] = blocks[2] = blocks[3] = blocks[4] =\n      blocks[5] = blocks[6] = blocks[7] = blocks[8] =\n      blocks[9] = blocks[10] = blocks[11] = blocks[12] =\n      blocks[13] = blocks[14] = blocks[15] = blocks[16] =\n      blocks[17] = blocks[18] = blocks[19] = blocks[20] =\n      blocks[21] = blocks[22] = blocks[23] = blocks[24] =\n      blocks[25] = blocks[26] = blocks[27] = blocks[28] =\n      blocks[29] = blocks[30] = blocks[31] = blocks[32] = 0;\n      this.blocks = blocks;\n    } else {\n      this.blocks = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];\n    }\n\n    if (bits == 384) {\n      this.h0h = 0xCBBB9D5D;\n      this.h0l = 0xC1059ED8;\n      this.h1h = 0x629A292A;\n      this.h1l = 0x367CD507;\n      this.h2h = 0x9159015A;\n      this.h2l = 0x3070DD17;\n      this.h3h = 0x152FECD8;\n      this.h3l = 0xF70E5939;\n      this.h4h = 0x67332667;\n      this.h4l = 0xFFC00B31;\n      this.h5h = 0x8EB44A87;\n      this.h5l = 0x68581511;\n      this.h6h = 0xDB0C2E0D;\n      this.h6l = 0x64F98FA7;\n      this.h7h = 0x47B5481D;\n      this.h7l = 0xBEFA4FA4;\n    } else if (bits == 256) {\n      this.h0h = 0x22312194;\n      this.h0l = 0xFC2BF72C;\n      this.h1h = 0x9F555FA3;\n      this.h1l = 0xC84C64C2;\n      this.h2h = 0x2393B86B;\n      this.h2l = 0x6F53B151;\n      this.h3h = 0x96387719;\n      this.h3l = 0x5940EABD;\n      this.h4h = 0x96283EE2;\n      this.h4l = 0xA88EFFE3;\n      this.h5h = 0xBE5E1E25;\n      this.h5l = 0x53863992;\n      this.h6h = 0x2B0199FC;\n      this.h6l = 0x2C85B8AA;\n      this.h7h = 0x0EB72DDC;\n      this.h7l = 0x81C52CA2;\n    } else if (bits == 224) {\n      this.h0h = 0x8C3D37C8;\n      this.h0l = 0x19544DA2;\n      this.h1h = 0x73E19966;\n      this.h1l = 0x89DCD4D6;\n      this.h2h = 0x1DFAB7AE;\n      this.h2l = 0x32FF9C82;\n      this.h3h = 0x679DD514;\n      this.h3l = 0x582F9FCF;\n      this.h4h = 0x0F6D2B69;\n      this.h4l = 0x7BD44DA8;\n      this.h5h = 0x77E36F73;\n      this.h5l = 0x04C48942;\n      this.h6h = 0x3F9D85A8;\n      this.h6l = 0x6A1D36C8;\n      this.h7h = 0x1112E6AD;\n      this.h7l = 0x91D692A1;\n    } else { // 512\n      this.h0h = 0x6A09E667;\n      this.h0l = 0xF3BCC908;\n      this.h1h = 0xBB67AE85;\n      this.h1l = 0x84CAA73B;\n      this.h2h = 0x3C6EF372;\n      this.h2l = 0xFE94F82B;\n      this.h3h = 0xA54FF53A;\n      this.h3l = 0x5F1D36F1;\n      this.h4h = 0x510E527F;\n      this.h4l = 0xADE682D1;\n      this.h5h = 0x9B05688C;\n      this.h5l = 0x2B3E6C1F;\n      this.h6h = 0x1F83D9AB;\n      this.h6l = 0xFB41BD6B;\n      this.h7h = 0x5BE0CD19;\n      this.h7l = 0x137E2179;\n    }\n    this.bits = bits;\n\n    this.block = this.start = this.bytes = this.hBytes = 0;\n    this.finalized = this.hashed = false;\n  }\n\n  Sha512.prototype.update = function (message) {\n    if (this.finalized) {\n      throw new Error(FINALIZE_ERROR);\n    }\n    var result = formatMessage(message);\n    message = result[0];\n    var isString = result[1];\n    var code, index = 0, i, length = message.length, blocks = this.blocks;\n\n    while (index < length) {\n      if (this.hashed) {\n        this.hashed = false;\n        blocks[0] = this.block;\n        this.block = blocks[1] = blocks[2] = blocks[3] = blocks[4] =\n        blocks[5] = blocks[6] = blocks[7] = blocks[8] =\n        blocks[9] = blocks[10] = blocks[11] = blocks[12] =\n        blocks[13] = blocks[14] = blocks[15] = blocks[16] =\n        blocks[17] = blocks[18] = blocks[19] = blocks[20] =\n        blocks[21] = blocks[22] = blocks[23] = blocks[24] =\n        blocks[25] = blocks[26] = blocks[27] = blocks[28] =\n        blocks[29] = blocks[30] = blocks[31] = blocks[32] = 0;\n      }\n\n      if(isString) {\n        for (i = this.start; index < length && i < 128; ++index) {\n          code = message.charCodeAt(index);\n          if (code < 0x80) {\n            blocks[i >>> 2] |= code << SHIFT[i++ & 3];\n          } else if (code < 0x800) {\n            blocks[i >>> 2] |= (0xc0 | (code >>> 6)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];\n          } else if (code < 0xd800 || code >= 0xe000) {\n            blocks[i >>> 2] |= (0xe0 | (code >>> 12)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | ((code >>> 6) & 0x3f)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];\n          } else {\n            code = 0x10000 + (((code & 0x3ff) << 10) | (message.charCodeAt(++index) & 0x3ff));\n            blocks[i >>> 2] |= (0xf0 | (code >>> 18)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | ((code >>> 12) & 0x3f)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | ((code >>> 6) & 0x3f)) << SHIFT[i++ & 3];\n            blocks[i >>> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];\n          }\n        }\n      } else {\n        for (i = this.start; index < length && i < 128; ++index) {\n          blocks[i >>> 2] |= message[index] << SHIFT[i++ & 3];\n        }\n      }\n\n      this.lastByteIndex = i;\n      this.bytes += i - this.start;\n      if (i >= 128) {\n        this.block = blocks[32];\n        this.start = i - 128;\n        this.hash();\n        this.hashed = true;\n      } else {\n        this.start = i;\n      }\n    }\n    if (this.bytes > 4294967295) {\n      this.hBytes += this.bytes / 4294967296 << 0;\n      this.bytes = this.bytes % 4294967296;\n    }\n    return this;\n  };\n\n  Sha512.prototype.finalize = function () {\n    if (this.finalized) {\n      return;\n    }\n    this.finalized = true;\n    var blocks = this.blocks, i = this.lastByteIndex;\n    blocks[32] = this.block;\n    blocks[i >>> 2] |= EXTRA[i & 3];\n    this.block = blocks[32];\n    if (i >= 112) {\n      if (!this.hashed) {\n        this.hash();\n      }\n      blocks[0] = this.block;\n      blocks[1] = blocks[2] = blocks[3] = blocks[4] =\n      blocks[5] = blocks[6] = blocks[7] = blocks[8] =\n      blocks[9] = blocks[10] = blocks[11] = blocks[12] =\n      blocks[13] = blocks[14] = blocks[15] = blocks[16] =\n      blocks[17] = blocks[18] = blocks[19] = blocks[20] =\n      blocks[21] = blocks[22] = blocks[23] = blocks[24] =\n      blocks[25] = blocks[26] = blocks[27] = blocks[28] =\n      blocks[29] = blocks[30] = blocks[31] = blocks[32] = 0;\n    }\n    blocks[30] = this.hBytes << 3 | this.bytes >>> 29;\n    blocks[31] = this.bytes << 3;\n    this.hash();\n  };\n\n  Sha512.prototype.hash = function () {\n    var h0h = this.h0h, h0l = this.h0l, h1h = this.h1h, h1l = this.h1l,\n      h2h = this.h2h, h2l = this.h2l, h3h = this.h3h, h3l = this.h3l,\n      h4h = this.h4h, h4l = this.h4l, h5h = this.h5h, h5l = this.h5l,\n      h6h = this.h6h, h6l = this.h6l, h7h = this.h7h, h7l = this.h7l,\n      blocks = this.blocks, j, s0h, s0l, s1h, s1l, c1, c2, c3, c4,\n      abh, abl, dah, dal, cdh, cdl, bch, bcl,\n      majh, majl, t1h, t1l, t2h, t2l, chh, chl;\n\n    for (j = 32; j < 160; j += 2) {\n      t1h = blocks[j - 30];\n      t1l = blocks[j - 29];\n      s0h = ((t1h >>> 1) | (t1l << 31)) ^ ((t1h >>> 8) | (t1l << 24)) ^ (t1h >>> 7);\n      s0l = ((t1l >>> 1) | (t1h << 31)) ^ ((t1l >>> 8) | (t1h << 24)) ^ ((t1l >>> 7) | t1h << 25);\n\n      t1h = blocks[j - 4];\n      t1l = blocks[j - 3];\n      s1h = ((t1h >>> 19) | (t1l << 13)) ^ ((t1l >>> 29) | (t1h << 3)) ^ (t1h >>> 6);\n      s1l = ((t1l >>> 19) | (t1h << 13)) ^ ((t1h >>> 29) | (t1l << 3)) ^ ((t1l >>> 6) | t1h << 26);\n\n      t1h = blocks[j - 32];\n      t1l = blocks[j - 31];\n      t2h = blocks[j - 14];\n      t2l = blocks[j - 13];\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF) + (s0l & 0xFFFF) + (s1l & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (s0l >>> 16) + (s1l >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (s0h & 0xFFFF) + (s1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (s0h >>> 16) + (s1h >>> 16) + (c3 >>> 16);\n\n      blocks[j] = (c4 << 16) | (c3 & 0xFFFF);\n      blocks[j + 1] = (c2 << 16) | (c1 & 0xFFFF);\n    }\n\n    var ah = h0h, al = h0l, bh = h1h, bl = h1l, ch = h2h, cl = h2l, dh = h3h, dl = h3l, eh = h4h, el = h4l, fh = h5h, fl = h5l, gh = h6h, gl = h6l, hh = h7h, hl = h7l;\n    bch = bh & ch;\n    bcl = bl & cl;\n    for (j = 0; j < 160; j += 8) {\n      s0h = ((ah >>> 28) | (al << 4)) ^ ((al >>> 2) | (ah << 30)) ^ ((al >>> 7) | (ah << 25));\n      s0l = ((al >>> 28) | (ah << 4)) ^ ((ah >>> 2) | (al << 30)) ^ ((ah >>> 7) | (al << 25));\n\n      s1h = ((eh >>> 14) | (el << 18)) ^ ((eh >>> 18) | (el << 14)) ^ ((el >>> 9) | (eh << 23));\n      s1l = ((el >>> 14) | (eh << 18)) ^ ((el >>> 18) | (eh << 14)) ^ ((eh >>> 9) | (el << 23));\n\n      abh = ah & bh;\n      abl = al & bl;\n      majh = abh ^ (ah & ch) ^ bch;\n      majl = abl ^ (al & cl) ^ bcl;\n\n      chh = (eh & fh) ^ (~eh & gh);\n      chl = (el & fl) ^ (~el & gl);\n\n      t1h = blocks[j];\n      t1l = blocks[j + 1];\n      t2h = K[j];\n      t2l = K[j + 1];\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF) + (chl & 0xFFFF) + (s1l & 0xFFFF) + (hl & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (chl >>> 16) + (s1l >>> 16) + (hl >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (chh & 0xFFFF) + (s1h & 0xFFFF) + (hh & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (chh >>> 16) + (s1h >>> 16) + (hh >>> 16) + (c3 >>> 16);\n\n      t1h = (c4 << 16) | (c3 & 0xFFFF);\n      t1l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (majl & 0xFFFF) + (s0l & 0xFFFF);\n      c2 = (majl >>> 16) + (s0l >>> 16) + (c1 >>> 16);\n      c3 = (majh & 0xFFFF) + (s0h & 0xFFFF) + (c2 >>> 16);\n      c4 = (majh >>> 16) + (s0h >>> 16) + (c3 >>> 16);\n\n      t2h = (c4 << 16) | (c3 & 0xFFFF);\n      t2l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (dl & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (dl >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (dh & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (dh >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      hh = (c4 << 16) | (c3 & 0xFFFF);\n      hl = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      dh = (c4 << 16) | (c3 & 0xFFFF);\n      dl = (c2 << 16) | (c1 & 0xFFFF);\n\n      s0h = ((dh >>> 28) | (dl << 4)) ^ ((dl >>> 2) | (dh << 30)) ^ ((dl >>> 7) | (dh << 25));\n      s0l = ((dl >>> 28) | (dh << 4)) ^ ((dh >>> 2) | (dl << 30)) ^ ((dh >>> 7) | (dl << 25));\n\n      s1h = ((hh >>> 14) | (hl << 18)) ^ ((hh >>> 18) | (hl << 14)) ^ ((hl >>> 9) | (hh << 23));\n      s1l = ((hl >>> 14) | (hh << 18)) ^ ((hl >>> 18) | (hh << 14)) ^ ((hh >>> 9) | (hl << 23));\n\n      dah = dh & ah;\n      dal = dl & al;\n      majh = dah ^ (dh & bh) ^ abh;\n      majl = dal ^ (dl & bl) ^ abl;\n\n      chh = (hh & eh) ^ (~hh & fh);\n      chl = (hl & el) ^ (~hl & fl);\n\n      t1h = blocks[j + 2];\n      t1l = blocks[j + 3];\n      t2h = K[j + 2];\n      t2l = K[j + 3];\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF) + (chl & 0xFFFF) + (s1l & 0xFFFF) + (gl & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (chl >>> 16) + (s1l >>> 16) + (gl >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (chh & 0xFFFF) + (s1h & 0xFFFF) + (gh & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (chh >>> 16) + (s1h >>> 16) + (gh >>> 16) + (c3 >>> 16);\n\n      t1h = (c4 << 16) | (c3 & 0xFFFF);\n      t1l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (majl & 0xFFFF) + (s0l & 0xFFFF);\n      c2 = (majl >>> 16) + (s0l >>> 16) + (c1 >>> 16);\n      c3 = (majh & 0xFFFF) + (s0h & 0xFFFF) + (c2 >>> 16);\n      c4 = (majh >>> 16) + (s0h >>> 16) + (c3 >>> 16);\n\n      t2h = (c4 << 16) | (c3 & 0xFFFF);\n      t2l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (cl & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (cl >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (ch & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (ch >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      gh = (c4 << 16) | (c3 & 0xFFFF);\n      gl = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      ch = (c4 << 16) | (c3 & 0xFFFF);\n      cl = (c2 << 16) | (c1 & 0xFFFF);\n\n      s0h = ((ch >>> 28) | (cl << 4)) ^ ((cl >>> 2) | (ch << 30)) ^ ((cl >>> 7) | (ch << 25));\n      s0l = ((cl >>> 28) | (ch << 4)) ^ ((ch >>> 2) | (cl << 30)) ^ ((ch >>> 7) | (cl << 25));\n\n      s1h = ((gh >>> 14) | (gl << 18)) ^ ((gh >>> 18) | (gl << 14)) ^ ((gl >>> 9) | (gh << 23));\n      s1l = ((gl >>> 14) | (gh << 18)) ^ ((gl >>> 18) | (gh << 14)) ^ ((gh >>> 9) | (gl << 23));\n\n      cdh = ch & dh;\n      cdl = cl & dl;\n      majh = cdh ^ (ch & ah) ^ dah;\n      majl = cdl ^ (cl & al) ^ dal;\n\n      chh = (gh & hh) ^ (~gh & eh);\n      chl = (gl & hl) ^ (~gl & el);\n\n      t1h = blocks[j + 4];\n      t1l = blocks[j + 5];\n      t2h = K[j + 4];\n      t2l = K[j + 5];\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF) + (chl & 0xFFFF) + (s1l & 0xFFFF) + (fl & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (chl >>> 16) + (s1l >>> 16) + (fl >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (chh & 0xFFFF) + (s1h & 0xFFFF) + (fh & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (chh >>> 16) + (s1h >>> 16) + (fh >>> 16) + (c3 >>> 16);\n\n      t1h = (c4 << 16) | (c3 & 0xFFFF);\n      t1l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (majl & 0xFFFF) + (s0l & 0xFFFF);\n      c2 = (majl >>> 16) + (s0l >>> 16) + (c1 >>> 16);\n      c3 = (majh & 0xFFFF) + (s0h & 0xFFFF) + (c2 >>> 16);\n      c4 = (majh >>> 16) + (s0h >>> 16) + (c3 >>> 16);\n\n      t2h = (c4 << 16) | (c3 & 0xFFFF);\n      t2l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (bl & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (bl >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (bh & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (bh >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      fh = (c4 << 16) | (c3 & 0xFFFF);\n      fl = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      bh = (c4 << 16) | (c3 & 0xFFFF);\n      bl = (c2 << 16) | (c1 & 0xFFFF);\n\n      s0h = ((bh >>> 28) | (bl << 4)) ^ ((bl >>> 2) | (bh << 30)) ^ ((bl >>> 7) | (bh << 25));\n      s0l = ((bl >>> 28) | (bh << 4)) ^ ((bh >>> 2) | (bl << 30)) ^ ((bh >>> 7) | (bl << 25));\n\n      s1h = ((fh >>> 14) | (fl << 18)) ^ ((fh >>> 18) | (fl << 14)) ^ ((fl >>> 9) | (fh << 23));\n      s1l = ((fl >>> 14) | (fh << 18)) ^ ((fl >>> 18) | (fh << 14)) ^ ((fh >>> 9) | (fl << 23));\n\n      bch = bh & ch;\n      bcl = bl & cl;\n      majh = bch ^ (bh & dh) ^ cdh;\n      majl = bcl ^ (bl & dl) ^ cdl;\n\n      chh = (fh & gh) ^ (~fh & hh);\n      chl = (fl & gl) ^ (~fl & hl);\n\n      t1h = blocks[j + 6];\n      t1l = blocks[j + 7];\n      t2h = K[j + 6];\n      t2l = K[j + 7];\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF) + (chl & 0xFFFF) + (s1l & 0xFFFF) + (el & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (chl >>> 16) + (s1l >>> 16) + (el >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (chh & 0xFFFF) + (s1h & 0xFFFF) + (eh & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (chh >>> 16) + (s1h >>> 16) + (eh >>> 16) + (c3 >>> 16);\n\n      t1h = (c4 << 16) | (c3 & 0xFFFF);\n      t1l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (majl & 0xFFFF) + (s0l & 0xFFFF);\n      c2 = (majl >>> 16) + (s0l >>> 16) + (c1 >>> 16);\n      c3 = (majh & 0xFFFF) + (s0h & 0xFFFF) + (c2 >>> 16);\n      c4 = (majh >>> 16) + (s0h >>> 16) + (c3 >>> 16);\n\n      t2h = (c4 << 16) | (c3 & 0xFFFF);\n      t2l = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (al & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (al >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (ah & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (ah >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      eh = (c4 << 16) | (c3 & 0xFFFF);\n      el = (c2 << 16) | (c1 & 0xFFFF);\n\n      c1 = (t2l & 0xFFFF) + (t1l & 0xFFFF);\n      c2 = (t2l >>> 16) + (t1l >>> 16) + (c1 >>> 16);\n      c3 = (t2h & 0xFFFF) + (t1h & 0xFFFF) + (c2 >>> 16);\n      c4 = (t2h >>> 16) + (t1h >>> 16) + (c3 >>> 16);\n\n      ah = (c4 << 16) | (c3 & 0xFFFF);\n      al = (c2 << 16) | (c1 & 0xFFFF);\n    }\n\n    c1 = (h0l & 0xFFFF) + (al & 0xFFFF);\n    c2 = (h0l >>> 16) + (al >>> 16) + (c1 >>> 16);\n    c3 = (h0h & 0xFFFF) + (ah & 0xFFFF) + (c2 >>> 16);\n    c4 = (h0h >>> 16) + (ah >>> 16) + (c3 >>> 16);\n\n    this.h0h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h0l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h1l & 0xFFFF) + (bl & 0xFFFF);\n    c2 = (h1l >>> 16) + (bl >>> 16) + (c1 >>> 16);\n    c3 = (h1h & 0xFFFF) + (bh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h1h >>> 16) + (bh >>> 16) + (c3 >>> 16);\n\n    this.h1h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h1l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h2l & 0xFFFF) + (cl & 0xFFFF);\n    c2 = (h2l >>> 16) + (cl >>> 16) + (c1 >>> 16);\n    c3 = (h2h & 0xFFFF) + (ch & 0xFFFF) + (c2 >>> 16);\n    c4 = (h2h >>> 16) + (ch >>> 16) + (c3 >>> 16);\n\n    this.h2h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h2l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h3l & 0xFFFF) + (dl & 0xFFFF);\n    c2 = (h3l >>> 16) + (dl >>> 16) + (c1 >>> 16);\n    c3 = (h3h & 0xFFFF) + (dh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h3h >>> 16) + (dh >>> 16) + (c3 >>> 16);\n\n    this.h3h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h3l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h4l & 0xFFFF) + (el & 0xFFFF);\n    c2 = (h4l >>> 16) + (el >>> 16) + (c1 >>> 16);\n    c3 = (h4h & 0xFFFF) + (eh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h4h >>> 16) + (eh >>> 16) + (c3 >>> 16);\n\n    this.h4h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h4l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h5l & 0xFFFF) + (fl & 0xFFFF);\n    c2 = (h5l >>> 16) + (fl >>> 16) + (c1 >>> 16);\n    c3 = (h5h & 0xFFFF) + (fh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h5h >>> 16) + (fh >>> 16) + (c3 >>> 16);\n\n    this.h5h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h5l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h6l & 0xFFFF) + (gl & 0xFFFF);\n    c2 = (h6l >>> 16) + (gl >>> 16) + (c1 >>> 16);\n    c3 = (h6h & 0xFFFF) + (gh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h6h >>> 16) + (gh >>> 16) + (c3 >>> 16);\n\n    this.h6h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h6l = (c2 << 16) | (c1 & 0xFFFF);\n\n    c1 = (h7l & 0xFFFF) + (hl & 0xFFFF);\n    c2 = (h7l >>> 16) + (hl >>> 16) + (c1 >>> 16);\n    c3 = (h7h & 0xFFFF) + (hh & 0xFFFF) + (c2 >>> 16);\n    c4 = (h7h >>> 16) + (hh >>> 16) + (c3 >>> 16);\n\n    this.h7h = (c4 << 16) | (c3 & 0xFFFF);\n    this.h7l = (c2 << 16) | (c1 & 0xFFFF);\n  };\n\n  Sha512.prototype.hex = function () {\n    this.finalize();\n\n    var h0h = this.h0h, h0l = this.h0l, h1h = this.h1h, h1l = this.h1l,\n      h2h = this.h2h, h2l = this.h2l, h3h = this.h3h, h3l = this.h3l,\n      h4h = this.h4h, h4l = this.h4l, h5h = this.h5h, h5l = this.h5l,\n      h6h = this.h6h, h6l = this.h6l, h7h = this.h7h, h7l = this.h7l,\n      bits = this.bits;\n\n    var hex = HEX_CHARS[(h0h >>> 28) & 0x0F] + HEX_CHARS[(h0h >>> 24) & 0x0F] +\n      HEX_CHARS[(h0h >>> 20) & 0x0F] + HEX_CHARS[(h0h >>> 16) & 0x0F] +\n      HEX_CHARS[(h0h >>> 12) & 0x0F] + HEX_CHARS[(h0h >>> 8) & 0x0F] +\n      HEX_CHARS[(h0h >>> 4) & 0x0F] + HEX_CHARS[h0h & 0x0F] +\n      HEX_CHARS[(h0l >>> 28) & 0x0F] + HEX_CHARS[(h0l >>> 24) & 0x0F] +\n      HEX_CHARS[(h0l >>> 20) & 0x0F] + HEX_CHARS[(h0l >>> 16) & 0x0F] +\n      HEX_CHARS[(h0l >>> 12) & 0x0F] + HEX_CHARS[(h0l >>> 8) & 0x0F] +\n      HEX_CHARS[(h0l >>> 4) & 0x0F] + HEX_CHARS[h0l & 0x0F] +\n      HEX_CHARS[(h1h >>> 28) & 0x0F] + HEX_CHARS[(h1h >>> 24) & 0x0F] +\n      HEX_CHARS[(h1h >>> 20) & 0x0F] + HEX_CHARS[(h1h >>> 16) & 0x0F] +\n      HEX_CHARS[(h1h >>> 12) & 0x0F] + HEX_CHARS[(h1h >>> 8) & 0x0F] +\n      HEX_CHARS[(h1h >>> 4) & 0x0F] + HEX_CHARS[h1h & 0x0F] +\n      HEX_CHARS[(h1l >>> 28) & 0x0F] + HEX_CHARS[(h1l >>> 24) & 0x0F] +\n      HEX_CHARS[(h1l >>> 20) & 0x0F] + HEX_CHARS[(h1l >>> 16) & 0x0F] +\n      HEX_CHARS[(h1l >>> 12) & 0x0F] + HEX_CHARS[(h1l >>> 8) & 0x0F] +\n      HEX_CHARS[(h1l >>> 4) & 0x0F] + HEX_CHARS[h1l & 0x0F] +\n      HEX_CHARS[(h2h >>> 28) & 0x0F] + HEX_CHARS[(h2h >>> 24) & 0x0F] +\n      HEX_CHARS[(h2h >>> 20) & 0x0F] + HEX_CHARS[(h2h >>> 16) & 0x0F] +\n      HEX_CHARS[(h2h >>> 12) & 0x0F] + HEX_CHARS[(h2h >>> 8) & 0x0F] +\n      HEX_CHARS[(h2h >>> 4) & 0x0F] + HEX_CHARS[h2h & 0x0F] +\n      HEX_CHARS[(h2l >>> 28) & 0x0F] + HEX_CHARS[(h2l >>> 24) & 0x0F] +\n      HEX_CHARS[(h2l >>> 20) & 0x0F] + HEX_CHARS[(h2l >>> 16) & 0x0F] +\n      HEX_CHARS[(h2l >>> 12) & 0x0F] + HEX_CHARS[(h2l >>> 8) & 0x0F] +\n      HEX_CHARS[(h2l >>> 4) & 0x0F] + HEX_CHARS[h2l & 0x0F] +\n      HEX_CHARS[(h3h >>> 28) & 0x0F] + HEX_CHARS[(h3h >>> 24) & 0x0F] +\n      HEX_CHARS[(h3h >>> 20) & 0x0F] + HEX_CHARS[(h3h >>> 16) & 0x0F] +\n      HEX_CHARS[(h3h >>> 12) & 0x0F] + HEX_CHARS[(h3h >>> 8) & 0x0F] +\n      HEX_CHARS[(h3h >>> 4) & 0x0F] + HEX_CHARS[h3h & 0x0F];\n    if (bits >= 256) {\n      hex += HEX_CHARS[(h3l >>> 28) & 0x0F] + HEX_CHARS[(h3l >>> 24) & 0x0F] +\n        HEX_CHARS[(h3l >>> 20) & 0x0F] + HEX_CHARS[(h3l >>> 16) & 0x0F] +\n        HEX_CHARS[(h3l >>> 12) & 0x0F] + HEX_CHARS[(h3l >>> 8) & 0x0F] +\n        HEX_CHARS[(h3l >>> 4) & 0x0F] + HEX_CHARS[h3l & 0x0F];\n    }\n    if (bits >= 384) {\n      hex += HEX_CHARS[(h4h >>> 28) & 0x0F] + HEX_CHARS[(h4h >>> 24) & 0x0F] +\n        HEX_CHARS[(h4h >>> 20) & 0x0F] + HEX_CHARS[(h4h >>> 16) & 0x0F] +\n        HEX_CHARS[(h4h >>> 12) & 0x0F] + HEX_CHARS[(h4h >>> 8) & 0x0F] +\n        HEX_CHARS[(h4h >>> 4) & 0x0F] + HEX_CHARS[h4h & 0x0F] +\n        HEX_CHARS[(h4l >>> 28) & 0x0F] + HEX_CHARS[(h4l >>> 24) & 0x0F] +\n        HEX_CHARS[(h4l >>> 20) & 0x0F] + HEX_CHARS[(h4l >>> 16) & 0x0F] +\n        HEX_CHARS[(h4l >>> 12) & 0x0F] + HEX_CHARS[(h4l >>> 8) & 0x0F] +\n        HEX_CHARS[(h4l >>> 4) & 0x0F] + HEX_CHARS[h4l & 0x0F] +\n        HEX_CHARS[(h5h >>> 28) & 0x0F] + HEX_CHARS[(h5h >>> 24) & 0x0F] +\n        HEX_CHARS[(h5h >>> 20) & 0x0F] + HEX_CHARS[(h5h >>> 16) & 0x0F] +\n        HEX_CHARS[(h5h >>> 12) & 0x0F] + HEX_CHARS[(h5h >>> 8) & 0x0F] +\n        HEX_CHARS[(h5h >>> 4) & 0x0F] + HEX_CHARS[h5h & 0x0F] +\n        HEX_CHARS[(h5l >>> 28) & 0x0F] + HEX_CHARS[(h5l >>> 24) & 0x0F] +\n        HEX_CHARS[(h5l >>> 20) & 0x0F] + HEX_CHARS[(h5l >>> 16) & 0x0F] +\n        HEX_CHARS[(h5l >>> 12) & 0x0F] + HEX_CHARS[(h5l >>> 8) & 0x0F] +\n        HEX_CHARS[(h5l >>> 4) & 0x0F] + HEX_CHARS[h5l & 0x0F];\n    }\n    if (bits == 512) {\n      hex += HEX_CHARS[(h6h >>> 28) & 0x0F] + HEX_CHARS[(h6h >>> 24) & 0x0F] +\n        HEX_CHARS[(h6h >>> 20) & 0x0F] + HEX_CHARS[(h6h >>> 16) & 0x0F] +\n        HEX_CHARS[(h6h >>> 12) & 0x0F] + HEX_CHARS[(h6h >>> 8) & 0x0F] +\n        HEX_CHARS[(h6h >>> 4) & 0x0F] + HEX_CHARS[h6h & 0x0F] +\n        HEX_CHARS[(h6l >>> 28) & 0x0F] + HEX_CHARS[(h6l >>> 24) & 0x0F] +\n        HEX_CHARS[(h6l >>> 20) & 0x0F] + HEX_CHARS[(h6l >>> 16) & 0x0F] +\n        HEX_CHARS[(h6l >>> 12) & 0x0F] + HEX_CHARS[(h6l >>> 8) & 0x0F] +\n        HEX_CHARS[(h6l >>> 4) & 0x0F] + HEX_CHARS[h6l & 0x0F] +\n        HEX_CHARS[(h7h >>> 28) & 0x0F] + HEX_CHARS[(h7h >>> 24) & 0x0F] +\n        HEX_CHARS[(h7h >>> 20) & 0x0F] + HEX_CHARS[(h7h >>> 16) & 0x0F] +\n        HEX_CHARS[(h7h >>> 12) & 0x0F] + HEX_CHARS[(h7h >>> 8) & 0x0F] +\n        HEX_CHARS[(h7h >>> 4) & 0x0F] + HEX_CHARS[h7h & 0x0F] +\n        HEX_CHARS[(h7l >>> 28) & 0x0F] + HEX_CHARS[(h7l >>> 24) & 0x0F] +\n        HEX_CHARS[(h7l >>> 20) & 0x0F] + HEX_CHARS[(h7l >>> 16) & 0x0F] +\n        HEX_CHARS[(h7l >>> 12) & 0x0F] + HEX_CHARS[(h7l >>> 8) & 0x0F] +\n        HEX_CHARS[(h7l >>> 4) & 0x0F] + HEX_CHARS[h7l & 0x0F];\n    }\n    return hex;\n  };\n\n  Sha512.prototype.toString = Sha512.prototype.hex;\n\n  Sha512.prototype.digest = function () {\n    this.finalize();\n\n    var h0h = this.h0h, h0l = this.h0l, h1h = this.h1h, h1l = this.h1l,\n      h2h = this.h2h, h2l = this.h2l, h3h = this.h3h, h3l = this.h3l,\n      h4h = this.h4h, h4l = this.h4l, h5h = this.h5h, h5l = this.h5l,\n      h6h = this.h6h, h6l = this.h6l, h7h = this.h7h, h7l = this.h7l,\n      bits = this.bits;\n\n    var arr = [\n      (h0h >>> 24) & 0xFF, (h0h >>> 16) & 0xFF, (h0h >>> 8) & 0xFF, h0h & 0xFF,\n      (h0l >>> 24) & 0xFF, (h0l >>> 16) & 0xFF, (h0l >>> 8) & 0xFF, h0l & 0xFF,\n      (h1h >>> 24) & 0xFF, (h1h >>> 16) & 0xFF, (h1h >>> 8) & 0xFF, h1h & 0xFF,\n      (h1l >>> 24) & 0xFF, (h1l >>> 16) & 0xFF, (h1l >>> 8) & 0xFF, h1l & 0xFF,\n      (h2h >>> 24) & 0xFF, (h2h >>> 16) & 0xFF, (h2h >>> 8) & 0xFF, h2h & 0xFF,\n      (h2l >>> 24) & 0xFF, (h2l >>> 16) & 0xFF, (h2l >>> 8) & 0xFF, h2l & 0xFF,\n      (h3h >>> 24) & 0xFF, (h3h >>> 16) & 0xFF, (h3h >>> 8) & 0xFF, h3h & 0xFF\n    ];\n\n    if (bits >= 256) {\n      arr.push((h3l >>> 24) & 0xFF, (h3l >>> 16) & 0xFF, (h3l >>> 8) & 0xFF, h3l & 0xFF);\n    }\n    if (bits >= 384) {\n      arr.push(\n        (h4h >>> 24) & 0xFF, (h4h >>> 16) & 0xFF, (h4h >>> 8) & 0xFF, h4h & 0xFF,\n        (h4l >>> 24) & 0xFF, (h4l >>> 16) & 0xFF, (h4l >>> 8) & 0xFF, h4l & 0xFF,\n        (h5h >>> 24) & 0xFF, (h5h >>> 16) & 0xFF, (h5h >>> 8) & 0xFF, h5h & 0xFF,\n        (h5l >>> 24) & 0xFF, (h5l >>> 16) & 0xFF, (h5l >>> 8) & 0xFF, h5l & 0xFF\n      );\n    }\n    if (bits == 512) {\n      arr.push(\n        (h6h >>> 24) & 0xFF, (h6h >>> 16) & 0xFF, (h6h >>> 8) & 0xFF, h6h & 0xFF,\n        (h6l >>> 24) & 0xFF, (h6l >>> 16) & 0xFF, (h6l >>> 8) & 0xFF, h6l & 0xFF,\n        (h7h >>> 24) & 0xFF, (h7h >>> 16) & 0xFF, (h7h >>> 8) & 0xFF, h7h & 0xFF,\n        (h7l >>> 24) & 0xFF, (h7l >>> 16) & 0xFF, (h7l >>> 8) & 0xFF, h7l & 0xFF\n      );\n    }\n    return arr;\n  };\n\n  Sha512.prototype.array = Sha512.prototype.digest;\n\n  Sha512.prototype.arrayBuffer = function () {\n    this.finalize();\n\n    var bits = this.bits;\n    var buffer = new ArrayBuffer(bits / 8);\n    var dataView = new DataView(buffer);\n    dataView.setUint32(0, this.h0h);\n    dataView.setUint32(4, this.h0l);\n    dataView.setUint32(8, this.h1h);\n    dataView.setUint32(12, this.h1l);\n    dataView.setUint32(16, this.h2h);\n    dataView.setUint32(20, this.h2l);\n    dataView.setUint32(24, this.h3h);\n\n    if (bits >= 256) {\n      dataView.setUint32(28, this.h3l);\n    }\n    if (bits >= 384) {\n      dataView.setUint32(32, this.h4h);\n      dataView.setUint32(36, this.h4l);\n      dataView.setUint32(40, this.h5h);\n      dataView.setUint32(44, this.h5l);\n    }\n    if (bits == 512) {\n      dataView.setUint32(48, this.h6h);\n      dataView.setUint32(52, this.h6l);\n      dataView.setUint32(56, this.h7h);\n      dataView.setUint32(60, this.h7l);\n    }\n    return buffer;\n  };\n\n  Sha512.prototype.clone = function () {\n    var hash = new Sha512(this.bits, false);\n    this.copyTo(hash);\n    return hash;\n  };\n\n  Sha512.prototype.copyTo = function (hash) {\n    var i = 0, attrs = [\n      'h0h', 'h0l', 'h1h', 'h1l', 'h2h', 'h2l', 'h3h', 'h3l', 'h4h', 'h4l', 'h5h', 'h5l', 'h6h', 'h6l', 'h7h', 'h7l',\n      'start', 'bytes', 'hBytes', 'finalized', 'hashed', 'lastByteIndex'\n    ];\n    for (i = 0; i < attrs.length; ++i) {\n      hash[attrs[i]] = this[attrs[i]];\n    }\n    for (i = 0; i < this.blocks.length; ++i) {\n      hash.blocks[i] = this.blocks[i];\n    }\n  };\n\n  function HmacSha512(key, bits, sharedMemory) {\n    var i, result = formatMessage(key);\n    key = result[0];\n    if (result[1]) {\n      var bytes = [], length = key.length, index = 0, code;\n      for (var i = 0; i < length; ++i) {\n        code = key.charCodeAt(i);\n        if (code < 0x80) {\n          bytes[index++] = code;\n        } else if (code < 0x800) {\n          bytes[index++] = (0xc0 | (code >>> 6));\n          bytes[index++] = (0x80 | (code & 0x3f));\n        } else if (code < 0xd800 || code >= 0xe000) {\n          bytes[index++] = (0xe0 | (code >>> 12));\n          bytes[index++] = (0x80 | ((code >>> 6) & 0x3f));\n          bytes[index++] = (0x80 | (code & 0x3f));\n        } else {\n          code = 0x10000 + (((code & 0x3ff) << 10) | (key.charCodeAt(++i) & 0x3ff));\n          bytes[index++] = (0xf0 | (code >>> 18));\n          bytes[index++] = (0x80 | ((code >>> 12) & 0x3f));\n          bytes[index++] = (0x80 | ((code >>> 6) & 0x3f));\n          bytes[index++] = (0x80 | (code & 0x3f));\n        }\n      }\n      key = bytes;\n    }\n\n    if (key.length > 128) {\n      key = (new Sha512(bits, true)).update(key).array();\n    }\n\n    var oKeyPad = [], iKeyPad = [];\n    for (var i = 0; i < 128; ++i) {\n      var b = key[i] || 0;\n      oKeyPad[i] = 0x5c ^ b;\n      iKeyPad[i] = 0x36 ^ b;\n    }\n\n    Sha512.call(this, bits, sharedMemory);\n\n    this.update(iKeyPad);\n    this.oKeyPad = oKeyPad;\n    this.inner = true;\n    this.sharedMemory = sharedMemory;\n  }\n  HmacSha512.prototype = new Sha512();\n\n  HmacSha512.prototype.finalize = function () {\n    Sha512.prototype.finalize.call(this);\n    if (this.inner) {\n      this.inner = false;\n      var innerHash = this.array();\n      Sha512.call(this, this.bits, this.sharedMemory);\n      this.update(this.oKeyPad);\n      this.update(innerHash);\n      Sha512.prototype.finalize.call(this);\n    }\n  };\n\n  HmacSha512.prototype.clone = function () {\n    var hash = new HmacSha512([], this.bits, false);\n    this.copyTo(hash);\n    hash.inner = this.inner;\n    for (var i = 0; i < this.oKeyPad.length; ++i) {\n      hash.oKeyPad[i] = this.oKeyPad[i];\n    }\n    return hash;\n  };\n\n  var exports = createMethod(512);\n  exports.sha512 = exports;\n  exports.sha384 = createMethod(384);\n  exports.sha512_256 = createMethod(256);\n  exports.sha512_224 = createMethod(224);\n  exports.sha512.hmac = createHmacMethod(512);\n  exports.sha384.hmac = createHmacMethod(384);\n  exports.sha512_256.hmac = createHmacMethod(256);\n  exports.sha512_224.hmac = createHmacMethod(224);\n\n  if (COMMON_JS) {\n    module.exports = exports;\n  } else {\n    root.sha512 = exports.sha512;\n    root.sha384 = exports.sha384;\n    root.sha512_256 = exports.sha512_256;\n    root.sha512_224 = exports.sha512_224;\n    if (AMD) {\n      !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {\n        return exports;\n      }).call(exports, __webpack_require__, exports, module),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n    }\n  }\n})();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/js-sha512/src/sha512.js\n");

/***/ })

};
;