"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/nodemailer";
exports.ids = ["vendor-chunks/nodemailer"];
exports.modules = {

/***/ "(ssr)/./node_modules/nodemailer/lib/addressparser/index.js":
/*!************************************************************!*\
  !*** ./node_modules/nodemailer/lib/addressparser/index.js ***!
  \************************************************************/
/***/ ((module) => {

eval("\n\n/**\n * Converts tokens for a single address into an address object\n *\n * @param {Array} tokens Tokens object\n * @return {Object} Address object\n */\nfunction _handleAddress(tokens) {\n    let isGroup = false;\n    let state = 'text';\n    let address;\n    let addresses = [];\n    let data = {\n        address: [],\n        comment: [],\n        group: [],\n        text: [],\n        textWasQuoted: [] // Track which text tokens came from inside quotes\n    };\n    let i;\n    let len;\n    let insideQuotes = false; // Track if we're currently inside a quoted string\n\n    // Filter out <addresses>, (comments) and regular text\n    for (i = 0, len = tokens.length; i < len; i++) {\n        let token = tokens[i];\n        let prevToken = i ? tokens[i - 1] : null;\n        if (token.type === 'operator') {\n            switch (token.value) {\n                case '<':\n                    state = 'address';\n                    insideQuotes = false;\n                    break;\n                case '(':\n                    state = 'comment';\n                    insideQuotes = false;\n                    break;\n                case ':':\n                    state = 'group';\n                    isGroup = true;\n                    insideQuotes = false;\n                    break;\n                case '\"':\n                    // Track quote state for text tokens\n                    insideQuotes = !insideQuotes;\n                    state = 'text';\n                    break;\n                default:\n                    state = 'text';\n                    insideQuotes = false;\n                    break;\n            }\n        } else if (token.value) {\n            if (state === 'address') {\n                // handle use case where unquoted name includes a \"<\"\n                // Apple Mail truncates everything between an unexpected < and an address\n                // and so will we\n                token.value = token.value.replace(/^[^<]*<\\s*/, '');\n            }\n\n            if (prevToken && prevToken.noBreak && data[state].length) {\n                // join values\n                data[state][data[state].length - 1] += token.value;\n                if (state === 'text' && insideQuotes) {\n                    data.textWasQuoted[data.textWasQuoted.length - 1] = true;\n                }\n            } else {\n                data[state].push(token.value);\n                if (state === 'text') {\n                    data.textWasQuoted.push(insideQuotes);\n                }\n            }\n        }\n    }\n\n    // If there is no text but a comment, replace the two\n    if (!data.text.length && data.comment.length) {\n        data.text = data.comment;\n        data.comment = [];\n    }\n\n    if (isGroup) {\n        // http://tools.ietf.org/html/rfc2822#appendix-A.1.3\n        data.text = data.text.join(' ');\n\n        // Parse group members, but flatten any nested groups (RFC 5322 doesn't allow nesting)\n        let groupMembers = [];\n        if (data.group.length) {\n            let parsedGroup = addressparser(data.group.join(','));\n            // Flatten: if any member is itself a group, extract its members into the sequence\n            parsedGroup.forEach(member => {\n                if (member.group) {\n                    // Nested group detected - flatten it by adding its members directly\n                    groupMembers = groupMembers.concat(member.group);\n                } else {\n                    groupMembers.push(member);\n                }\n            });\n        }\n\n        addresses.push({\n            name: data.text || (address && address.name),\n            group: groupMembers\n        });\n    } else {\n        // If no address was found, try to detect one from regular text\n        if (!data.address.length && data.text.length) {\n            for (i = data.text.length - 1; i >= 0; i--) {\n                // Security fix: Do not extract email addresses from quoted strings\n                // RFC 5321 allows @ inside quoted local-parts like \"user@domain\"@example.com\n                // Extracting emails from quoted text leads to misrouting vulnerabilities\n                if (!data.textWasQuoted[i] && data.text[i].match(/^[^@\\s]+@[^@\\s]+$/)) {\n                    data.address = data.text.splice(i, 1);\n                    data.textWasQuoted.splice(i, 1);\n                    break;\n                }\n            }\n\n            let _regexHandler = function (address) {\n                if (!data.address.length) {\n                    data.address = [address.trim()];\n                    return ' ';\n                } else {\n                    return address;\n                }\n            };\n\n            // still no address\n            if (!data.address.length) {\n                for (i = data.text.length - 1; i >= 0; i--) {\n                    // Security fix: Do not extract email addresses from quoted strings\n                    if (!data.textWasQuoted[i]) {\n                        // fixed the regex to parse email address correctly when email address has more than one @\n                        data.text[i] = data.text[i].replace(/\\s*\\b[^@\\s]+@[^\\s]+\\b\\s*/, _regexHandler).trim();\n                        if (data.address.length) {\n                            break;\n                        }\n                    }\n                }\n            }\n        }\n\n        // If there's still is no text but a comment exixts, replace the two\n        if (!data.text.length && data.comment.length) {\n            data.text = data.comment;\n            data.comment = [];\n        }\n\n        // Keep only the first address occurence, push others to regular text\n        if (data.address.length > 1) {\n            data.text = data.text.concat(data.address.splice(1));\n        }\n\n        // Join values with spaces\n        data.text = data.text.join(' ');\n        data.address = data.address.join(' ');\n\n        if (!data.address && isGroup) {\n            return [];\n        } else {\n            address = {\n                address: data.address || data.text || '',\n                name: data.text || data.address || ''\n            };\n\n            if (address.address === address.name) {\n                if ((address.address || '').match(/@/)) {\n                    address.name = '';\n                } else {\n                    address.address = '';\n                }\n            }\n\n            addresses.push(address);\n        }\n    }\n\n    return addresses;\n}\n\n/**\n * Creates a Tokenizer object for tokenizing address field strings\n *\n * @constructor\n * @param {String} str Address field string\n */\nclass Tokenizer {\n    constructor(str) {\n        this.str = (str || '').toString();\n        this.operatorCurrent = '';\n        this.operatorExpecting = '';\n        this.node = null;\n        this.escaped = false;\n\n        this.list = [];\n        /**\n         * Operator tokens and which tokens are expected to end the sequence\n         */\n        this.operators = {\n            '\"': '\"',\n            '(': ')',\n            '<': '>',\n            ',': '',\n            ':': ';',\n            // Semicolons are not a legal delimiter per the RFC2822 grammar other\n            // than for terminating a group, but they are also not valid for any\n            // other use in this context.  Given that some mail clients have\n            // historically allowed the semicolon as a delimiter equivalent to the\n            // comma in their UI, it makes sense to treat them the same as a comma\n            // when used outside of a group.\n            ';': ''\n        };\n    }\n\n    /**\n     * Tokenizes the original input string\n     *\n     * @return {Array} An array of operator|text tokens\n     */\n    tokenize() {\n        let list = [];\n\n        for (let i = 0, len = this.str.length; i < len; i++) {\n            let chr = this.str.charAt(i);\n            let nextChr = i < len - 1 ? this.str.charAt(i + 1) : null;\n            this.checkChar(chr, nextChr);\n        }\n\n        this.list.forEach(node => {\n            node.value = (node.value || '').toString().trim();\n            if (node.value) {\n                list.push(node);\n            }\n        });\n\n        return list;\n    }\n\n    /**\n     * Checks if a character is an operator or text and acts accordingly\n     *\n     * @param {String} chr Character from the address field\n     */\n    checkChar(chr, nextChr) {\n        if (this.escaped) {\n            // ignore next condition blocks\n        } else if (chr === this.operatorExpecting) {\n            this.node = {\n                type: 'operator',\n                value: chr\n            };\n\n            if (nextChr && ![' ', '\\t', '\\r', '\\n', ',', ';'].includes(nextChr)) {\n                this.node.noBreak = true;\n            }\n\n            this.list.push(this.node);\n            this.node = null;\n            this.operatorExpecting = '';\n            this.escaped = false;\n\n            return;\n        } else if (!this.operatorExpecting && chr in this.operators) {\n            this.node = {\n                type: 'operator',\n                value: chr\n            };\n            this.list.push(this.node);\n            this.node = null;\n            this.operatorExpecting = this.operators[chr];\n            this.escaped = false;\n            return;\n        } else if (['\"', \"'\"].includes(this.operatorExpecting) && chr === '\\\\') {\n            this.escaped = true;\n            return;\n        }\n\n        if (!this.node) {\n            this.node = {\n                type: 'text',\n                value: ''\n            };\n            this.list.push(this.node);\n        }\n\n        if (chr === '\\n') {\n            // Convert newlines to spaces. Carriage return is ignored as \\r and \\n usually\n            // go together anyway and there already is a WS for \\n. Lone \\r means something is fishy.\n            chr = ' ';\n        }\n\n        if (chr.charCodeAt(0) >= 0x21 || [' ', '\\t'].includes(chr)) {\n            // skip command bytes\n            this.node.value += chr;\n        }\n\n        this.escaped = false;\n    }\n}\n\n/**\n * Parses structured e-mail addresses from an address field\n *\n * Example:\n *\n *    'Name <address@domain>'\n *\n * will be converted to\n *\n *     [{name: 'Name', address: 'address@domain'}]\n *\n * @param {String} str Address field\n * @return {Array} An array of address objects\n */\nfunction addressparser(str, options) {\n    options = options || {};\n\n    let tokenizer = new Tokenizer(str);\n    let tokens = tokenizer.tokenize();\n\n    let addresses = [];\n    let address = [];\n    let parsedAddresses = [];\n\n    tokens.forEach(token => {\n        if (token.type === 'operator' && (token.value === ',' || token.value === ';')) {\n            if (address.length) {\n                addresses.push(address);\n            }\n            address = [];\n        } else {\n            address.push(token);\n        }\n    });\n\n    if (address.length) {\n        addresses.push(address);\n    }\n\n    addresses.forEach(address => {\n        address = _handleAddress(address);\n        if (address.length) {\n            parsedAddresses = parsedAddresses.concat(address);\n        }\n    });\n\n    if (options.flatten) {\n        let addresses = [];\n        let walkAddressList = list => {\n            list.forEach(address => {\n                if (address.group) {\n                    return walkAddressList(address.group);\n                } else {\n                    addresses.push(address);\n                }\n            });\n        };\n        walkAddressList(parsedAddresses);\n        return addresses;\n    }\n\n    return parsedAddresses;\n}\n\n// expose to the world\nmodule.exports = addressparser;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/addressparser/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/base64/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/nodemailer/lib/base64/index.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst Transform = (__webpack_require__(/*! stream */ \"stream\").Transform);\n\n/**\n * Encodes a Buffer into a base64 encoded string\n *\n * @param {Buffer} buffer Buffer to convert\n * @returns {String} base64 encoded string\n */\nfunction encode(buffer) {\n    if (typeof buffer === 'string') {\n        buffer = Buffer.from(buffer, 'utf-8');\n    }\n\n    return buffer.toString('base64');\n}\n\n/**\n * Adds soft line breaks to a base64 string\n *\n * @param {String} str base64 encoded string that might need line wrapping\n * @param {Number} [lineLength=76] Maximum allowed length for a line\n * @returns {String} Soft-wrapped base64 encoded string\n */\nfunction wrap(str, lineLength) {\n    str = (str || '').toString();\n    lineLength = lineLength || 76;\n\n    if (str.length <= lineLength) {\n        return str;\n    }\n\n    let result = [];\n    let pos = 0;\n    let chunkLength = lineLength * 1024;\n    while (pos < str.length) {\n        let wrappedLines = str.substr(pos, chunkLength).replace(new RegExp('.{' + lineLength + '}', 'g'), '$&\\r\\n');\n        result.push(wrappedLines);\n        pos += chunkLength;\n    }\n\n    return result.join('');\n}\n\n/**\n * Creates a transform stream for encoding data to base64 encoding\n *\n * @constructor\n * @param {Object} options Stream options\n * @param {Number} [options.lineLength=76] Maximum length for lines, set to false to disable wrapping\n */\nclass Encoder extends Transform {\n    constructor(options) {\n        super();\n        this.options = options || {};\n\n        if (this.options.lineLength !== false) {\n            this.options.lineLength = this.options.lineLength || 76;\n        }\n\n        this._curLine = '';\n        this._remainingBytes = false;\n\n        this.inputBytes = 0;\n        this.outputBytes = 0;\n    }\n\n    _transform(chunk, encoding, done) {\n        if (encoding !== 'buffer') {\n            chunk = Buffer.from(chunk, encoding);\n        }\n\n        if (!chunk || !chunk.length) {\n            return setImmediate(done);\n        }\n\n        this.inputBytes += chunk.length;\n\n        if (this._remainingBytes && this._remainingBytes.length) {\n            chunk = Buffer.concat([this._remainingBytes, chunk], this._remainingBytes.length + chunk.length);\n            this._remainingBytes = false;\n        }\n\n        if (chunk.length % 3) {\n            this._remainingBytes = chunk.slice(chunk.length - (chunk.length % 3));\n            chunk = chunk.slice(0, chunk.length - (chunk.length % 3));\n        } else {\n            this._remainingBytes = false;\n        }\n\n        let b64 = this._curLine + encode(chunk);\n\n        if (this.options.lineLength) {\n            b64 = wrap(b64, this.options.lineLength);\n\n            let lastLF = b64.lastIndexOf('\\n');\n            if (lastLF < 0) {\n                this._curLine = b64;\n                b64 = '';\n            } else {\n                this._curLine = b64.substring(lastLF + 1);\n                b64 = b64.substring(0, lastLF + 1);\n\n                if (b64 && !b64.endsWith('\\r\\n')) {\n                    b64 += '\\r\\n';\n                }\n            }\n        } else {\n            this._curLine = '';\n        }\n\n        if (b64) {\n            this.outputBytes += b64.length;\n            this.push(Buffer.from(b64, 'ascii'));\n        }\n\n        setImmediate(done);\n    }\n\n    _flush(done) {\n        if (this._remainingBytes && this._remainingBytes.length) {\n            this._curLine += encode(this._remainingBytes);\n        }\n\n        if (this._curLine) {\n            this.outputBytes += this._curLine.length;\n            this.push(Buffer.from(this._curLine, 'ascii'));\n            this._curLine = '';\n        }\n        done();\n    }\n}\n\nmodule.exports = {\n    encode,\n    wrap,\n    Encoder\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/base64/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/dkim/index.js":
/*!***************************************************!*\
  !*** ./node_modules/nodemailer/lib/dkim/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\n// FIXME:\n// replace this Transform mess with a method that pipes input argument to output argument\n\nconst MessageParser = __webpack_require__(/*! ./message-parser */ \"(ssr)/./node_modules/nodemailer/lib/dkim/message-parser.js\");\nconst RelaxedBody = __webpack_require__(/*! ./relaxed-body */ \"(ssr)/./node_modules/nodemailer/lib/dkim/relaxed-body.js\");\nconst sign = __webpack_require__(/*! ./sign */ \"(ssr)/./node_modules/nodemailer/lib/dkim/sign.js\");\nconst PassThrough = (__webpack_require__(/*! stream */ \"stream\").PassThrough);\nconst fs = __webpack_require__(/*! fs */ \"fs\");\nconst path = __webpack_require__(/*! path */ \"path\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\nconst DKIM_ALGO = 'sha256';\nconst MAX_MESSAGE_SIZE = 2 * 1024 * 1024; // buffer messages larger than this to disk\n\n/*\n// Usage:\n\nlet dkim = new DKIM({\n    domainName: 'example.com',\n    keySelector: 'key-selector',\n    privateKey,\n    cacheDir: '/tmp'\n});\ndkim.sign(input).pipe(process.stdout);\n\n// Where inputStream is a rfc822 message (either a stream, string or Buffer)\n// and outputStream is a DKIM signed rfc822 message\n*/\n\nclass DKIMSigner {\n    constructor(options, keys, input, output) {\n        this.options = options || {};\n        this.keys = keys;\n\n        this.cacheTreshold = Number(this.options.cacheTreshold) || MAX_MESSAGE_SIZE;\n        this.hashAlgo = this.options.hashAlgo || DKIM_ALGO;\n\n        this.cacheDir = this.options.cacheDir || false;\n\n        this.chunks = [];\n        this.chunklen = 0;\n        this.readPos = 0;\n        this.cachePath = this.cacheDir\n            ? path.join(this.cacheDir, 'message.' + Date.now() + '-' + crypto.randomBytes(14).toString('hex'))\n            : false;\n        this.cache = false;\n\n        this.headers = false;\n        this.bodyHash = false;\n        this.parser = false;\n        this.relaxedBody = false;\n\n        this.input = input;\n        this.output = output;\n        this.output.usingCache = false;\n\n        this.hasErrored = false;\n\n        this.input.on('error', err => {\n            this.hasErrored = true;\n            this.cleanup();\n            output.emit('error', err);\n        });\n    }\n\n    cleanup() {\n        if (!this.cache || !this.cachePath) {\n            return;\n        }\n        fs.unlink(this.cachePath, () => false);\n    }\n\n    createReadCache() {\n        // pipe remainings to cache file\n        this.cache = fs.createReadStream(this.cachePath);\n        this.cache.once('error', err => {\n            this.cleanup();\n            this.output.emit('error', err);\n        });\n        this.cache.once('close', () => {\n            this.cleanup();\n        });\n        this.cache.pipe(this.output);\n    }\n\n    sendNextChunk() {\n        if (this.hasErrored) {\n            return;\n        }\n\n        if (this.readPos >= this.chunks.length) {\n            if (!this.cache) {\n                return this.output.end();\n            }\n            return this.createReadCache();\n        }\n        let chunk = this.chunks[this.readPos++];\n        if (this.output.write(chunk) === false) {\n            return this.output.once('drain', () => {\n                this.sendNextChunk();\n            });\n        }\n        setImmediate(() => this.sendNextChunk());\n    }\n\n    sendSignedOutput() {\n        let keyPos = 0;\n        let signNextKey = () => {\n            if (keyPos >= this.keys.length) {\n                this.output.write(this.parser.rawHeaders);\n                return setImmediate(() => this.sendNextChunk());\n            }\n            let key = this.keys[keyPos++];\n            let dkimField = sign(this.headers, this.hashAlgo, this.bodyHash, {\n                domainName: key.domainName,\n                keySelector: key.keySelector,\n                privateKey: key.privateKey,\n                headerFieldNames: this.options.headerFieldNames,\n                skipFields: this.options.skipFields\n            });\n            if (dkimField) {\n                this.output.write(Buffer.from(dkimField + '\\r\\n'));\n            }\n            return setImmediate(signNextKey);\n        };\n\n        if (this.bodyHash && this.headers) {\n            return signNextKey();\n        }\n\n        this.output.write(this.parser.rawHeaders);\n        this.sendNextChunk();\n    }\n\n    createWriteCache() {\n        this.output.usingCache = true;\n        // pipe remainings to cache file\n        this.cache = fs.createWriteStream(this.cachePath);\n        this.cache.once('error', err => {\n            this.cleanup();\n            // drain input\n            this.relaxedBody.unpipe(this.cache);\n            this.relaxedBody.on('readable', () => {\n                while (this.relaxedBody.read() !== null) {\n                    // do nothing\n                }\n            });\n            this.hasErrored = true;\n            // emit error\n            this.output.emit('error', err);\n        });\n        this.cache.once('close', () => {\n            this.sendSignedOutput();\n        });\n        this.relaxedBody.removeAllListeners('readable');\n        this.relaxedBody.pipe(this.cache);\n    }\n\n    signStream() {\n        this.parser = new MessageParser();\n        this.relaxedBody = new RelaxedBody({\n            hashAlgo: this.hashAlgo\n        });\n\n        this.parser.on('headers', value => {\n            this.headers = value;\n        });\n\n        this.relaxedBody.on('hash', value => {\n            this.bodyHash = value;\n        });\n\n        this.relaxedBody.on('readable', () => {\n            let chunk;\n            if (this.cache) {\n                return;\n            }\n            while ((chunk = this.relaxedBody.read()) !== null) {\n                this.chunks.push(chunk);\n                this.chunklen += chunk.length;\n                if (this.chunklen >= this.cacheTreshold && this.cachePath) {\n                    return this.createWriteCache();\n                }\n            }\n        });\n\n        this.relaxedBody.on('end', () => {\n            if (this.cache) {\n                return;\n            }\n            this.sendSignedOutput();\n        });\n\n        this.parser.pipe(this.relaxedBody);\n        setImmediate(() => this.input.pipe(this.parser));\n    }\n}\n\nclass DKIM {\n    constructor(options) {\n        this.options = options || {};\n        this.keys = [].concat(\n            this.options.keys || {\n                domainName: options.domainName,\n                keySelector: options.keySelector,\n                privateKey: options.privateKey\n            }\n        );\n    }\n\n    sign(input, extraOptions) {\n        let output = new PassThrough();\n        let inputStream = input;\n        let writeValue = false;\n\n        if (Buffer.isBuffer(input)) {\n            writeValue = input;\n            inputStream = new PassThrough();\n        } else if (typeof input === 'string') {\n            writeValue = Buffer.from(input);\n            inputStream = new PassThrough();\n        }\n\n        let options = this.options;\n        if (extraOptions && Object.keys(extraOptions).length) {\n            options = {};\n            Object.keys(this.options || {}).forEach(key => {\n                options[key] = this.options[key];\n            });\n            Object.keys(extraOptions || {}).forEach(key => {\n                if (!(key in options)) {\n                    options[key] = extraOptions[key];\n                }\n            });\n        }\n\n        let signer = new DKIMSigner(options, this.keys, inputStream, output);\n        setImmediate(() => {\n            signer.signStream();\n            if (writeValue) {\n                setImmediate(() => {\n                    inputStream.end(writeValue);\n                });\n            }\n        });\n\n        return output;\n    }\n}\n\nmodule.exports = DKIM;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvZGtpbS9pbmRleC5qcyIsIm1hcHBpbmdzIjoiQUFBYTs7QUFFYjtBQUNBOztBQUVBLHNCQUFzQixtQkFBTyxDQUFDLG9GQUFrQjtBQUNoRCxvQkFBb0IsbUJBQU8sQ0FBQyxnRkFBZ0I7QUFDNUMsYUFBYSxtQkFBTyxDQUFDLGdFQUFRO0FBQzdCLG9CQUFvQix5REFBNkI7QUFDakQsV0FBVyxtQkFBTyxDQUFDLGNBQUk7QUFDdkIsYUFBYSxtQkFBTyxDQUFDLGtCQUFNO0FBQzNCLGVBQWUsbUJBQU8sQ0FBQyxzQkFBUTs7QUFFL0I7QUFDQSwwQ0FBMEM7O0FBRTFDO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLENBQUM7QUFDRDs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhO0FBQ2I7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQSxTQUFTO0FBQ1Q7QUFDQTtBQUNBLFNBQVM7QUFDVDtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTOztBQUVUO0FBQ0E7QUFDQSxTQUFTOztBQUVUO0FBQ0E7QUFDQSxTQUFTOztBQUVUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7O0FBRVQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVM7O0FBRVQ7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLDBDQUEwQztBQUMxQztBQUNBLGFBQWE7QUFDYiwwQ0FBMEM7QUFDMUM7QUFDQTtBQUNBO0FBQ0EsYUFBYTtBQUNiOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGlCQUFpQjtBQUNqQjtBQUNBLFNBQVM7O0FBRVQ7QUFDQTtBQUNBOztBQUVBIiwic291cmNlcyI6WyIvaG9tZS9oeGNrZXIvRGVza3RvcC9iZXQvbm9kZV9tb2R1bGVzL25vZGVtYWlsZXIvbGliL2RraW0vaW5kZXguanMiXSwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG4vLyBGSVhNRTpcbi8vIHJlcGxhY2UgdGhpcyBUcmFuc2Zvcm0gbWVzcyB3aXRoIGEgbWV0aG9kIHRoYXQgcGlwZXMgaW5wdXQgYXJndW1lbnQgdG8gb3V0cHV0IGFyZ3VtZW50XG5cbmNvbnN0IE1lc3NhZ2VQYXJzZXIgPSByZXF1aXJlKCcuL21lc3NhZ2UtcGFyc2VyJyk7XG5jb25zdCBSZWxheGVkQm9keSA9IHJlcXVpcmUoJy4vcmVsYXhlZC1ib2R5Jyk7XG5jb25zdCBzaWduID0gcmVxdWlyZSgnLi9zaWduJyk7XG5jb25zdCBQYXNzVGhyb3VnaCA9IHJlcXVpcmUoJ3N0cmVhbScpLlBhc3NUaHJvdWdoO1xuY29uc3QgZnMgPSByZXF1aXJlKCdmcycpO1xuY29uc3QgcGF0aCA9IHJlcXVpcmUoJ3BhdGgnKTtcbmNvbnN0IGNyeXB0byA9IHJlcXVpcmUoJ2NyeXB0bycpO1xuXG5jb25zdCBES0lNX0FMR08gPSAnc2hhMjU2JztcbmNvbnN0IE1BWF9NRVNTQUdFX1NJWkUgPSAyICogMTAyNCAqIDEwMjQ7IC8vIGJ1ZmZlciBtZXNzYWdlcyBsYXJnZXIgdGhhbiB0aGlzIHRvIGRpc2tcblxuLypcbi8vIFVzYWdlOlxuXG5sZXQgZGtpbSA9IG5ldyBES0lNKHtcbiAgICBkb21haW5OYW1lOiAnZXhhbXBsZS5jb20nLFxuICAgIGtleVNlbGVjdG9yOiAna2V5LXNlbGVjdG9yJyxcbiAgICBwcml2YXRlS2V5LFxuICAgIGNhY2hlRGlyOiAnL3RtcCdcbn0pO1xuZGtpbS5zaWduKGlucHV0KS5waXBlKHByb2Nlc3Muc3Rkb3V0KTtcblxuLy8gV2hlcmUgaW5wdXRTdHJlYW0gaXMgYSByZmM4MjIgbWVzc2FnZSAoZWl0aGVyIGEgc3RyZWFtLCBzdHJpbmcgb3IgQnVmZmVyKVxuLy8gYW5kIG91dHB1dFN0cmVhbSBpcyBhIERLSU0gc2lnbmVkIHJmYzgyMiBtZXNzYWdlXG4qL1xuXG5jbGFzcyBES0lNU2lnbmVyIHtcbiAgICBjb25zdHJ1Y3RvcihvcHRpb25zLCBrZXlzLCBpbnB1dCwgb3V0cHV0KSB7XG4gICAgICAgIHRoaXMub3B0aW9ucyA9IG9wdGlvbnMgfHwge307XG4gICAgICAgIHRoaXMua2V5cyA9IGtleXM7XG5cbiAgICAgICAgdGhpcy5jYWNoZVRyZXNob2xkID0gTnVtYmVyKHRoaXMub3B0aW9ucy5jYWNoZVRyZXNob2xkKSB8fCBNQVhfTUVTU0FHRV9TSVpFO1xuICAgICAgICB0aGlzLmhhc2hBbGdvID0gdGhpcy5vcHRpb25zLmhhc2hBbGdvIHx8IERLSU1fQUxHTztcblxuICAgICAgICB0aGlzLmNhY2hlRGlyID0gdGhpcy5vcHRpb25zLmNhY2hlRGlyIHx8IGZhbHNlO1xuXG4gICAgICAgIHRoaXMuY2h1bmtzID0gW107XG4gICAgICAgIHRoaXMuY2h1bmtsZW4gPSAwO1xuICAgICAgICB0aGlzLnJlYWRQb3MgPSAwO1xuICAgICAgICB0aGlzLmNhY2hlUGF0aCA9IHRoaXMuY2FjaGVEaXJcbiAgICAgICAgICAgID8gcGF0aC5qb2luKHRoaXMuY2FjaGVEaXIsICdtZXNzYWdlLicgKyBEYXRlLm5vdygpICsgJy0nICsgY3J5cHRvLnJhbmRvbUJ5dGVzKDE0KS50b1N0cmluZygnaGV4JykpXG4gICAgICAgICAgICA6IGZhbHNlO1xuICAgICAgICB0aGlzLmNhY2hlID0gZmFsc2U7XG5cbiAgICAgICAgdGhpcy5oZWFkZXJzID0gZmFsc2U7XG4gICAgICAgIHRoaXMuYm9keUhhc2ggPSBmYWxzZTtcbiAgICAgICAgdGhpcy5wYXJzZXIgPSBmYWxzZTtcbiAgICAgICAgdGhpcy5yZWxheGVkQm9keSA9IGZhbHNlO1xuXG4gICAgICAgIHRoaXMuaW5wdXQgPSBpbnB1dDtcbiAgICAgICAgdGhpcy5vdXRwdXQgPSBvdXRwdXQ7XG4gICAgICAgIHRoaXMub3V0cHV0LnVzaW5nQ2FjaGUgPSBmYWxzZTtcblxuICAgICAgICB0aGlzLmhhc0Vycm9yZWQgPSBmYWxzZTtcblxuICAgICAgICB0aGlzLmlucHV0Lm9uKCdlcnJvcicsIGVyciA9PiB7XG4gICAgICAgICAgICB0aGlzLmhhc0Vycm9yZWQgPSB0cnVlO1xuICAgICAgICAgICAgdGhpcy5jbGVhbnVwKCk7XG4gICAgICAgICAgICBvdXRwdXQuZW1pdCgnZXJyb3InLCBlcnIpO1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBjbGVhbnVwKCkge1xuICAgICAgICBpZiAoIXRoaXMuY2FjaGUgfHwgIXRoaXMuY2FjaGVQYXRoKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH1cbiAgICAgICAgZnMudW5saW5rKHRoaXMuY2FjaGVQYXRoLCAoKSA9PiBmYWxzZSk7XG4gICAgfVxuXG4gICAgY3JlYXRlUmVhZENhY2hlKCkge1xuICAgICAgICAvLyBwaXBlIHJlbWFpbmluZ3MgdG8gY2FjaGUgZmlsZVxuICAgICAgICB0aGlzLmNhY2hlID0gZnMuY3JlYXRlUmVhZFN0cmVhbSh0aGlzLmNhY2hlUGF0aCk7XG4gICAgICAgIHRoaXMuY2FjaGUub25jZSgnZXJyb3InLCBlcnIgPT4ge1xuICAgICAgICAgICAgdGhpcy5jbGVhbnVwKCk7XG4gICAgICAgICAgICB0aGlzLm91dHB1dC5lbWl0KCdlcnJvcicsIGVycik7XG4gICAgICAgIH0pO1xuICAgICAgICB0aGlzLmNhY2hlLm9uY2UoJ2Nsb3NlJywgKCkgPT4ge1xuICAgICAgICAgICAgdGhpcy5jbGVhbnVwKCk7XG4gICAgICAgIH0pO1xuICAgICAgICB0aGlzLmNhY2hlLnBpcGUodGhpcy5vdXRwdXQpO1xuICAgIH1cblxuICAgIHNlbmROZXh0Q2h1bmsoKSB7XG4gICAgICAgIGlmICh0aGlzLmhhc0Vycm9yZWQpIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICh0aGlzLnJlYWRQb3MgPj0gdGhpcy5jaHVua3MubGVuZ3RoKSB7XG4gICAgICAgICAgICBpZiAoIXRoaXMuY2FjaGUpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdGhpcy5vdXRwdXQuZW5kKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5jcmVhdGVSZWFkQ2FjaGUoKTtcbiAgICAgICAgfVxuICAgICAgICBsZXQgY2h1bmsgPSB0aGlzLmNodW5rc1t0aGlzLnJlYWRQb3MrK107XG4gICAgICAgIGlmICh0aGlzLm91dHB1dC53cml0ZShjaHVuaykgPT09IGZhbHNlKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5vdXRwdXQub25jZSgnZHJhaW4nLCAoKSA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy5zZW5kTmV4dENodW5rKCk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICBzZXRJbW1lZGlhdGUoKCkgPT4gdGhpcy5zZW5kTmV4dENodW5rKCkpO1xuICAgIH1cblxuICAgIHNlbmRTaWduZWRPdXRwdXQoKSB7XG4gICAgICAgIGxldCBrZXlQb3MgPSAwO1xuICAgICAgICBsZXQgc2lnbk5leHRLZXkgPSAoKSA9PiB7XG4gICAgICAgICAgICBpZiAoa2V5UG9zID49IHRoaXMua2V5cy5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgICB0aGlzLm91dHB1dC53cml0ZSh0aGlzLnBhcnNlci5yYXdIZWFkZXJzKTtcbiAgICAgICAgICAgICAgICByZXR1cm4gc2V0SW1tZWRpYXRlKCgpID0+IHRoaXMuc2VuZE5leHRDaHVuaygpKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGxldCBrZXkgPSB0aGlzLmtleXNba2V5UG9zKytdO1xuICAgICAgICAgICAgbGV0IGRraW1GaWVsZCA9IHNpZ24odGhpcy5oZWFkZXJzLCB0aGlzLmhhc2hBbGdvLCB0aGlzLmJvZHlIYXNoLCB7XG4gICAgICAgICAgICAgICAgZG9tYWluTmFtZToga2V5LmRvbWFpbk5hbWUsXG4gICAgICAgICAgICAgICAga2V5U2VsZWN0b3I6IGtleS5rZXlTZWxlY3RvcixcbiAgICAgICAgICAgICAgICBwcml2YXRlS2V5OiBrZXkucHJpdmF0ZUtleSxcbiAgICAgICAgICAgICAgICBoZWFkZXJGaWVsZE5hbWVzOiB0aGlzLm9wdGlvbnMuaGVhZGVyRmllbGROYW1lcyxcbiAgICAgICAgICAgICAgICBza2lwRmllbGRzOiB0aGlzLm9wdGlvbnMuc2tpcEZpZWxkc1xuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICBpZiAoZGtpbUZpZWxkKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5vdXRwdXQud3JpdGUoQnVmZmVyLmZyb20oZGtpbUZpZWxkICsgJ1xcclxcbicpKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBzZXRJbW1lZGlhdGUoc2lnbk5leHRLZXkpO1xuICAgICAgICB9O1xuXG4gICAgICAgIGlmICh0aGlzLmJvZHlIYXNoICYmIHRoaXMuaGVhZGVycykge1xuICAgICAgICAgICAgcmV0dXJuIHNpZ25OZXh0S2V5KCk7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLm91dHB1dC53cml0ZSh0aGlzLnBhcnNlci5yYXdIZWFkZXJzKTtcbiAgICAgICAgdGhpcy5zZW5kTmV4dENodW5rKCk7XG4gICAgfVxuXG4gICAgY3JlYXRlV3JpdGVDYWNoZSgpIHtcbiAgICAgICAgdGhpcy5vdXRwdXQudXNpbmdDYWNoZSA9IHRydWU7XG4gICAgICAgIC8vIHBpcGUgcmVtYWluaW5ncyB0byBjYWNoZSBmaWxlXG4gICAgICAgIHRoaXMuY2FjaGUgPSBmcy5jcmVhdGVXcml0ZVN0cmVhbSh0aGlzLmNhY2hlUGF0aCk7XG4gICAgICAgIHRoaXMuY2FjaGUub25jZSgnZXJyb3InLCBlcnIgPT4ge1xuICAgICAgICAgICAgdGhpcy5jbGVhbnVwKCk7XG4gICAgICAgICAgICAvLyBkcmFpbiBpbnB1dFxuICAgICAgICAgICAgdGhpcy5yZWxheGVkQm9keS51bnBpcGUodGhpcy5jYWNoZSk7XG4gICAgICAgICAgICB0aGlzLnJlbGF4ZWRCb2R5Lm9uKCdyZWFkYWJsZScsICgpID0+IHtcbiAgICAgICAgICAgICAgICB3aGlsZSAodGhpcy5yZWxheGVkQm9keS5yZWFkKCkgIT09IG51bGwpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gZG8gbm90aGluZ1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgdGhpcy5oYXNFcnJvcmVkID0gdHJ1ZTtcbiAgICAgICAgICAgIC8vIGVtaXQgZXJyb3JcbiAgICAgICAgICAgIHRoaXMub3V0cHV0LmVtaXQoJ2Vycm9yJywgZXJyKTtcbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMuY2FjaGUub25jZSgnY2xvc2UnLCAoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLnNlbmRTaWduZWRPdXRwdXQoKTtcbiAgICAgICAgfSk7XG4gICAgICAgIHRoaXMucmVsYXhlZEJvZHkucmVtb3ZlQWxsTGlzdGVuZXJzKCdyZWFkYWJsZScpO1xuICAgICAgICB0aGlzLnJlbGF4ZWRCb2R5LnBpcGUodGhpcy5jYWNoZSk7XG4gICAgfVxuXG4gICAgc2lnblN0cmVhbSgpIHtcbiAgICAgICAgdGhpcy5wYXJzZXIgPSBuZXcgTWVzc2FnZVBhcnNlcigpO1xuICAgICAgICB0aGlzLnJlbGF4ZWRCb2R5ID0gbmV3IFJlbGF4ZWRCb2R5KHtcbiAgICAgICAgICAgIGhhc2hBbGdvOiB0aGlzLmhhc2hBbGdvXG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMucGFyc2VyLm9uKCdoZWFkZXJzJywgdmFsdWUgPT4ge1xuICAgICAgICAgICAgdGhpcy5oZWFkZXJzID0gdmFsdWU7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMucmVsYXhlZEJvZHkub24oJ2hhc2gnLCB2YWx1ZSA9PiB7XG4gICAgICAgICAgICB0aGlzLmJvZHlIYXNoID0gdmFsdWU7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMucmVsYXhlZEJvZHkub24oJ3JlYWRhYmxlJywgKCkgPT4ge1xuICAgICAgICAgICAgbGV0IGNodW5rO1xuICAgICAgICAgICAgaWYgKHRoaXMuY2FjaGUpIHtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB3aGlsZSAoKGNodW5rID0gdGhpcy5yZWxheGVkQm9keS5yZWFkKCkpICE9PSBudWxsKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5jaHVua3MucHVzaChjaHVuayk7XG4gICAgICAgICAgICAgICAgdGhpcy5jaHVua2xlbiArPSBjaHVuay5sZW5ndGg7XG4gICAgICAgICAgICAgICAgaWYgKHRoaXMuY2h1bmtsZW4gPj0gdGhpcy5jYWNoZVRyZXNob2xkICYmIHRoaXMuY2FjaGVQYXRoKSB7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybiB0aGlzLmNyZWF0ZVdyaXRlQ2FjaGUoKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMucmVsYXhlZEJvZHkub24oJ2VuZCcsICgpID0+IHtcbiAgICAgICAgICAgIGlmICh0aGlzLmNhY2hlKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGhpcy5zZW5kU2lnbmVkT3V0cHV0KCk7XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHRoaXMucGFyc2VyLnBpcGUodGhpcy5yZWxheGVkQm9keSk7XG4gICAgICAgIHNldEltbWVkaWF0ZSgoKSA9PiB0aGlzLmlucHV0LnBpcGUodGhpcy5wYXJzZXIpKTtcbiAgICB9XG59XG5cbmNsYXNzIERLSU0ge1xuICAgIGNvbnN0cnVjdG9yKG9wdGlvbnMpIHtcbiAgICAgICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcbiAgICAgICAgdGhpcy5rZXlzID0gW10uY29uY2F0KFxuICAgICAgICAgICAgdGhpcy5vcHRpb25zLmtleXMgfHwge1xuICAgICAgICAgICAgICAgIGRvbWFpbk5hbWU6IG9wdGlvbnMuZG9tYWluTmFtZSxcbiAgICAgICAgICAgICAgICBrZXlTZWxlY3Rvcjogb3B0aW9ucy5rZXlTZWxlY3RvcixcbiAgICAgICAgICAgICAgICBwcml2YXRlS2V5OiBvcHRpb25zLnByaXZhdGVLZXlcbiAgICAgICAgICAgIH1cbiAgICAgICAgKTtcbiAgICB9XG5cbiAgICBzaWduKGlucHV0LCBleHRyYU9wdGlvbnMpIHtcbiAgICAgICAgbGV0IG91dHB1dCA9IG5ldyBQYXNzVGhyb3VnaCgpO1xuICAgICAgICBsZXQgaW5wdXRTdHJlYW0gPSBpbnB1dDtcbiAgICAgICAgbGV0IHdyaXRlVmFsdWUgPSBmYWxzZTtcblxuICAgICAgICBpZiAoQnVmZmVyLmlzQnVmZmVyKGlucHV0KSkge1xuICAgICAgICAgICAgd3JpdGVWYWx1ZSA9IGlucHV0O1xuICAgICAgICAgICAgaW5wdXRTdHJlYW0gPSBuZXcgUGFzc1Rocm91Z2goKTtcbiAgICAgICAgfSBlbHNlIGlmICh0eXBlb2YgaW5wdXQgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICB3cml0ZVZhbHVlID0gQnVmZmVyLmZyb20oaW5wdXQpO1xuICAgICAgICAgICAgaW5wdXRTdHJlYW0gPSBuZXcgUGFzc1Rocm91Z2goKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBvcHRpb25zID0gdGhpcy5vcHRpb25zO1xuICAgICAgICBpZiAoZXh0cmFPcHRpb25zICYmIE9iamVjdC5rZXlzKGV4dHJhT3B0aW9ucykubGVuZ3RoKSB7XG4gICAgICAgICAgICBvcHRpb25zID0ge307XG4gICAgICAgICAgICBPYmplY3Qua2V5cyh0aGlzLm9wdGlvbnMgfHwge30pLmZvckVhY2goa2V5ID0+IHtcbiAgICAgICAgICAgICAgICBvcHRpb25zW2tleV0gPSB0aGlzLm9wdGlvbnNba2V5XTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgT2JqZWN0LmtleXMoZXh0cmFPcHRpb25zIHx8IHt9KS5mb3JFYWNoKGtleSA9PiB7XG4gICAgICAgICAgICAgICAgaWYgKCEoa2V5IGluIG9wdGlvbnMpKSB7XG4gICAgICAgICAgICAgICAgICAgIG9wdGlvbnNba2V5XSA9IGV4dHJhT3B0aW9uc1trZXldO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IHNpZ25lciA9IG5ldyBES0lNU2lnbmVyKG9wdGlvbnMsIHRoaXMua2V5cywgaW5wdXRTdHJlYW0sIG91dHB1dCk7XG4gICAgICAgIHNldEltbWVkaWF0ZSgoKSA9PiB7XG4gICAgICAgICAgICBzaWduZXIuc2lnblN0cmVhbSgpO1xuICAgICAgICAgICAgaWYgKHdyaXRlVmFsdWUpIHtcbiAgICAgICAgICAgICAgICBzZXRJbW1lZGlhdGUoKCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICBpbnB1dFN0cmVhbS5lbmQod3JpdGVWYWx1ZSk7XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH0pO1xuXG4gICAgICAgIHJldHVybiBvdXRwdXQ7XG4gICAgfVxufVxuXG5tb2R1bGUuZXhwb3J0cyA9IERLSU07XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/dkim/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/dkim/message-parser.js":
/*!************************************************************!*\
  !*** ./node_modules/nodemailer/lib/dkim/message-parser.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst Transform = (__webpack_require__(/*! stream */ \"stream\").Transform);\n\n/**\n * MessageParser instance is a transform stream that separates message headers\n * from the rest of the body. Headers are emitted with the 'headers' event. Message\n * body is passed on as the resulting stream.\n */\nclass MessageParser extends Transform {\n    constructor(options) {\n        super(options);\n        this.lastBytes = Buffer.alloc(4);\n        this.headersParsed = false;\n        this.headerBytes = 0;\n        this.headerChunks = [];\n        this.rawHeaders = false;\n        this.bodySize = 0;\n    }\n\n    /**\n     * Keeps count of the last 4 bytes in order to detect line breaks on chunk boundaries\n     *\n     * @param {Buffer} data Next data chunk from the stream\n     */\n    updateLastBytes(data) {\n        let lblen = this.lastBytes.length;\n        let nblen = Math.min(data.length, lblen);\n\n        // shift existing bytes\n        for (let i = 0, len = lblen - nblen; i < len; i++) {\n            this.lastBytes[i] = this.lastBytes[i + nblen];\n        }\n\n        // add new bytes\n        for (let i = 1; i <= nblen; i++) {\n            this.lastBytes[lblen - i] = data[data.length - i];\n        }\n    }\n\n    /**\n     * Finds and removes message headers from the remaining body. We want to keep\n     * headers separated until final delivery to be able to modify these\n     *\n     * @param {Buffer} data Next chunk of data\n     * @return {Boolean} Returns true if headers are already found or false otherwise\n     */\n    checkHeaders(data) {\n        if (this.headersParsed) {\n            return true;\n        }\n\n        let lblen = this.lastBytes.length;\n        let headerPos = 0;\n        this.curLinePos = 0;\n        for (let i = 0, len = this.lastBytes.length + data.length; i < len; i++) {\n            let chr;\n            if (i < lblen) {\n                chr = this.lastBytes[i];\n            } else {\n                chr = data[i - lblen];\n            }\n            if (chr === 0x0a && i) {\n                let pr1 = i - 1 < lblen ? this.lastBytes[i - 1] : data[i - 1 - lblen];\n                let pr2 = i > 1 ? (i - 2 < lblen ? this.lastBytes[i - 2] : data[i - 2 - lblen]) : false;\n                if (pr1 === 0x0a) {\n                    this.headersParsed = true;\n                    headerPos = i - lblen + 1;\n                    this.headerBytes += headerPos;\n                    break;\n                } else if (pr1 === 0x0d && pr2 === 0x0a) {\n                    this.headersParsed = true;\n                    headerPos = i - lblen + 1;\n                    this.headerBytes += headerPos;\n                    break;\n                }\n            }\n        }\n\n        if (this.headersParsed) {\n            this.headerChunks.push(data.slice(0, headerPos));\n            this.rawHeaders = Buffer.concat(this.headerChunks, this.headerBytes);\n            this.headerChunks = null;\n            this.emit('headers', this.parseHeaders());\n            if (data.length - 1 > headerPos) {\n                let chunk = data.slice(headerPos);\n                this.bodySize += chunk.length;\n                // this would be the first chunk of data sent downstream\n                setImmediate(() => this.push(chunk));\n            }\n            return false;\n        } else {\n            this.headerBytes += data.length;\n            this.headerChunks.push(data);\n        }\n\n        // store last 4 bytes to catch header break\n        this.updateLastBytes(data);\n\n        return false;\n    }\n\n    _transform(chunk, encoding, callback) {\n        if (!chunk || !chunk.length) {\n            return callback();\n        }\n\n        if (typeof chunk === 'string') {\n            chunk = Buffer.from(chunk, encoding);\n        }\n\n        let headersFound;\n\n        try {\n            headersFound = this.checkHeaders(chunk);\n        } catch (E) {\n            return callback(E);\n        }\n\n        if (headersFound) {\n            this.bodySize += chunk.length;\n            this.push(chunk);\n        }\n\n        setImmediate(callback);\n    }\n\n    _flush(callback) {\n        if (this.headerChunks) {\n            let chunk = Buffer.concat(this.headerChunks, this.headerBytes);\n            this.bodySize += chunk.length;\n            this.push(chunk);\n            this.headerChunks = null;\n        }\n        callback();\n    }\n\n    parseHeaders() {\n        let lines = (this.rawHeaders || '').toString().split(/\\r?\\n/);\n        for (let i = lines.length - 1; i > 0; i--) {\n            if (/^\\s/.test(lines[i])) {\n                lines[i - 1] += '\\n' + lines[i];\n                lines.splice(i, 1);\n            }\n        }\n        return lines\n            .filter(line => line.trim())\n            .map(line => ({\n                key: line.substr(0, line.indexOf(':')).trim().toLowerCase(),\n                line\n            }));\n    }\n}\n\nmodule.exports = MessageParser;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvZGtpbS9tZXNzYWdlLXBhcnNlci5qcyIsIm1hcHBpbmdzIjoiQUFBYTs7QUFFYixrQkFBa0IsdURBQTJCOztBQUU3QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsZUFBZSxRQUFRO0FBQ3ZCO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EsNkNBQTZDLFNBQVM7QUFDdEQ7QUFDQTs7QUFFQTtBQUNBLHdCQUF3QixZQUFZO0FBQ3BDO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGVBQWUsUUFBUTtBQUN2QixnQkFBZ0IsU0FBUztBQUN6QjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLG1FQUFtRSxTQUFTO0FBQzVFO0FBQ0E7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQSx1Q0FBdUMsT0FBTztBQUM5QztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGFBQWE7QUFDYjtBQUNBOztBQUVBIiwic291cmNlcyI6WyIvaG9tZS9oeGNrZXIvRGVza3RvcC9iZXQvbm9kZV9tb2R1bGVzL25vZGVtYWlsZXIvbGliL2RraW0vbWVzc2FnZS1wYXJzZXIuanMiXSwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG5jb25zdCBUcmFuc2Zvcm0gPSByZXF1aXJlKCdzdHJlYW0nKS5UcmFuc2Zvcm07XG5cbi8qKlxuICogTWVzc2FnZVBhcnNlciBpbnN0YW5jZSBpcyBhIHRyYW5zZm9ybSBzdHJlYW0gdGhhdCBzZXBhcmF0ZXMgbWVzc2FnZSBoZWFkZXJzXG4gKiBmcm9tIHRoZSByZXN0IG9mIHRoZSBib2R5LiBIZWFkZXJzIGFyZSBlbWl0dGVkIHdpdGggdGhlICdoZWFkZXJzJyBldmVudC4gTWVzc2FnZVxuICogYm9keSBpcyBwYXNzZWQgb24gYXMgdGhlIHJlc3VsdGluZyBzdHJlYW0uXG4gKi9cbmNsYXNzIE1lc3NhZ2VQYXJzZXIgZXh0ZW5kcyBUcmFuc2Zvcm0ge1xuICAgIGNvbnN0cnVjdG9yKG9wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIob3B0aW9ucyk7XG4gICAgICAgIHRoaXMubGFzdEJ5dGVzID0gQnVmZmVyLmFsbG9jKDQpO1xuICAgICAgICB0aGlzLmhlYWRlcnNQYXJzZWQgPSBmYWxzZTtcbiAgICAgICAgdGhpcy5oZWFkZXJCeXRlcyA9IDA7XG4gICAgICAgIHRoaXMuaGVhZGVyQ2h1bmtzID0gW107XG4gICAgICAgIHRoaXMucmF3SGVhZGVycyA9IGZhbHNlO1xuICAgICAgICB0aGlzLmJvZHlTaXplID0gMDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBLZWVwcyBjb3VudCBvZiB0aGUgbGFzdCA0IGJ5dGVzIGluIG9yZGVyIHRvIGRldGVjdCBsaW5lIGJyZWFrcyBvbiBjaHVuayBib3VuZGFyaWVzXG4gICAgICpcbiAgICAgKiBAcGFyYW0ge0J1ZmZlcn0gZGF0YSBOZXh0IGRhdGEgY2h1bmsgZnJvbSB0aGUgc3RyZWFtXG4gICAgICovXG4gICAgdXBkYXRlTGFzdEJ5dGVzKGRhdGEpIHtcbiAgICAgICAgbGV0IGxibGVuID0gdGhpcy5sYXN0Qnl0ZXMubGVuZ3RoO1xuICAgICAgICBsZXQgbmJsZW4gPSBNYXRoLm1pbihkYXRhLmxlbmd0aCwgbGJsZW4pO1xuXG4gICAgICAgIC8vIHNoaWZ0IGV4aXN0aW5nIGJ5dGVzXG4gICAgICAgIGZvciAobGV0IGkgPSAwLCBsZW4gPSBsYmxlbiAtIG5ibGVuOyBpIDwgbGVuOyBpKyspIHtcbiAgICAgICAgICAgIHRoaXMubGFzdEJ5dGVzW2ldID0gdGhpcy5sYXN0Qnl0ZXNbaSArIG5ibGVuXTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIGFkZCBuZXcgYnl0ZXNcbiAgICAgICAgZm9yIChsZXQgaSA9IDE7IGkgPD0gbmJsZW47IGkrKykge1xuICAgICAgICAgICAgdGhpcy5sYXN0Qnl0ZXNbbGJsZW4gLSBpXSA9IGRhdGFbZGF0YS5sZW5ndGggLSBpXTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEZpbmRzIGFuZCByZW1vdmVzIG1lc3NhZ2UgaGVhZGVycyBmcm9tIHRoZSByZW1haW5pbmcgYm9keS4gV2Ugd2FudCB0byBrZWVwXG4gICAgICogaGVhZGVycyBzZXBhcmF0ZWQgdW50aWwgZmluYWwgZGVsaXZlcnkgdG8gYmUgYWJsZSB0byBtb2RpZnkgdGhlc2VcbiAgICAgKlxuICAgICAqIEBwYXJhbSB7QnVmZmVyfSBkYXRhIE5leHQgY2h1bmsgb2YgZGF0YVxuICAgICAqIEByZXR1cm4ge0Jvb2xlYW59IFJldHVybnMgdHJ1ZSBpZiBoZWFkZXJzIGFyZSBhbHJlYWR5IGZvdW5kIG9yIGZhbHNlIG90aGVyd2lzZVxuICAgICAqL1xuICAgIGNoZWNrSGVhZGVycyhkYXRhKSB7XG4gICAgICAgIGlmICh0aGlzLmhlYWRlcnNQYXJzZWQpIHtcbiAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IGxibGVuID0gdGhpcy5sYXN0Qnl0ZXMubGVuZ3RoO1xuICAgICAgICBsZXQgaGVhZGVyUG9zID0gMDtcbiAgICAgICAgdGhpcy5jdXJMaW5lUG9zID0gMDtcbiAgICAgICAgZm9yIChsZXQgaSA9IDAsIGxlbiA9IHRoaXMubGFzdEJ5dGVzLmxlbmd0aCArIGRhdGEubGVuZ3RoOyBpIDwgbGVuOyBpKyspIHtcbiAgICAgICAgICAgIGxldCBjaHI7XG4gICAgICAgICAgICBpZiAoaSA8IGxibGVuKSB7XG4gICAgICAgICAgICAgICAgY2hyID0gdGhpcy5sYXN0Qnl0ZXNbaV07XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIGNociA9IGRhdGFbaSAtIGxibGVuXTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGlmIChjaHIgPT09IDB4MGEgJiYgaSkge1xuICAgICAgICAgICAgICAgIGxldCBwcjEgPSBpIC0gMSA8IGxibGVuID8gdGhpcy5sYXN0Qnl0ZXNbaSAtIDFdIDogZGF0YVtpIC0gMSAtIGxibGVuXTtcbiAgICAgICAgICAgICAgICBsZXQgcHIyID0gaSA+IDEgPyAoaSAtIDIgPCBsYmxlbiA/IHRoaXMubGFzdEJ5dGVzW2kgLSAyXSA6IGRhdGFbaSAtIDIgLSBsYmxlbl0pIDogZmFsc2U7XG4gICAgICAgICAgICAgICAgaWYgKHByMSA9PT0gMHgwYSkge1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmhlYWRlcnNQYXJzZWQgPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICBoZWFkZXJQb3MgPSBpIC0gbGJsZW4gKyAxO1xuICAgICAgICAgICAgICAgICAgICB0aGlzLmhlYWRlckJ5dGVzICs9IGhlYWRlclBvcztcbiAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgfSBlbHNlIGlmIChwcjEgPT09IDB4MGQgJiYgcHIyID09PSAweDBhKSB7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuaGVhZGVyc1BhcnNlZCA9IHRydWU7XG4gICAgICAgICAgICAgICAgICAgIGhlYWRlclBvcyA9IGkgLSBsYmxlbiArIDE7XG4gICAgICAgICAgICAgICAgICAgIHRoaXMuaGVhZGVyQnl0ZXMgKz0gaGVhZGVyUG9zO1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodGhpcy5oZWFkZXJzUGFyc2VkKSB7XG4gICAgICAgICAgICB0aGlzLmhlYWRlckNodW5rcy5wdXNoKGRhdGEuc2xpY2UoMCwgaGVhZGVyUG9zKSk7XG4gICAgICAgICAgICB0aGlzLnJhd0hlYWRlcnMgPSBCdWZmZXIuY29uY2F0KHRoaXMuaGVhZGVyQ2h1bmtzLCB0aGlzLmhlYWRlckJ5dGVzKTtcbiAgICAgICAgICAgIHRoaXMuaGVhZGVyQ2h1bmtzID0gbnVsbDtcbiAgICAgICAgICAgIHRoaXMuZW1pdCgnaGVhZGVycycsIHRoaXMucGFyc2VIZWFkZXJzKCkpO1xuICAgICAgICAgICAgaWYgKGRhdGEubGVuZ3RoIC0gMSA+IGhlYWRlclBvcykge1xuICAgICAgICAgICAgICAgIGxldCBjaHVuayA9IGRhdGEuc2xpY2UoaGVhZGVyUG9zKTtcbiAgICAgICAgICAgICAgICB0aGlzLmJvZHlTaXplICs9IGNodW5rLmxlbmd0aDtcbiAgICAgICAgICAgICAgICAvLyB0aGlzIHdvdWxkIGJlIHRoZSBmaXJzdCBjaHVuayBvZiBkYXRhIHNlbnQgZG93bnN0cmVhbVxuICAgICAgICAgICAgICAgIHNldEltbWVkaWF0ZSgoKSA9PiB0aGlzLnB1c2goY2h1bmspKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMuaGVhZGVyQnl0ZXMgKz0gZGF0YS5sZW5ndGg7XG4gICAgICAgICAgICB0aGlzLmhlYWRlckNodW5rcy5wdXNoKGRhdGEpO1xuICAgICAgICB9XG5cbiAgICAgICAgLy8gc3RvcmUgbGFzdCA0IGJ5dGVzIHRvIGNhdGNoIGhlYWRlciBicmVha1xuICAgICAgICB0aGlzLnVwZGF0ZUxhc3RCeXRlcyhkYXRhKTtcblxuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuXG4gICAgX3RyYW5zZm9ybShjaHVuaywgZW5jb2RpbmcsIGNhbGxiYWNrKSB7XG4gICAgICAgIGlmICghY2h1bmsgfHwgIWNodW5rLmxlbmd0aCkge1xuICAgICAgICAgICAgcmV0dXJuIGNhbGxiYWNrKCk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodHlwZW9mIGNodW5rID09PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgY2h1bmsgPSBCdWZmZXIuZnJvbShjaHVuaywgZW5jb2RpbmcpO1xuICAgICAgICB9XG5cbiAgICAgICAgbGV0IGhlYWRlcnNGb3VuZDtcblxuICAgICAgICB0cnkge1xuICAgICAgICAgICAgaGVhZGVyc0ZvdW5kID0gdGhpcy5jaGVja0hlYWRlcnMoY2h1bmspO1xuICAgICAgICB9IGNhdGNoIChFKSB7XG4gICAgICAgICAgICByZXR1cm4gY2FsbGJhY2soRSk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoaGVhZGVyc0ZvdW5kKSB7XG4gICAgICAgICAgICB0aGlzLmJvZHlTaXplICs9IGNodW5rLmxlbmd0aDtcbiAgICAgICAgICAgIHRoaXMucHVzaChjaHVuayk7XG4gICAgICAgIH1cblxuICAgICAgICBzZXRJbW1lZGlhdGUoY2FsbGJhY2spO1xuICAgIH1cblxuICAgIF9mbHVzaChjYWxsYmFjaykge1xuICAgICAgICBpZiAodGhpcy5oZWFkZXJDaHVua3MpIHtcbiAgICAgICAgICAgIGxldCBjaHVuayA9IEJ1ZmZlci5jb25jYXQodGhpcy5oZWFkZXJDaHVua3MsIHRoaXMuaGVhZGVyQnl0ZXMpO1xuICAgICAgICAgICAgdGhpcy5ib2R5U2l6ZSArPSBjaHVuay5sZW5ndGg7XG4gICAgICAgICAgICB0aGlzLnB1c2goY2h1bmspO1xuICAgICAgICAgICAgdGhpcy5oZWFkZXJDaHVua3MgPSBudWxsO1xuICAgICAgICB9XG4gICAgICAgIGNhbGxiYWNrKCk7XG4gICAgfVxuXG4gICAgcGFyc2VIZWFkZXJzKCkge1xuICAgICAgICBsZXQgbGluZXMgPSAodGhpcy5yYXdIZWFkZXJzIHx8ICcnKS50b1N0cmluZygpLnNwbGl0KC9cXHI/XFxuLyk7XG4gICAgICAgIGZvciAobGV0IGkgPSBsaW5lcy5sZW5ndGggLSAxOyBpID4gMDsgaS0tKSB7XG4gICAgICAgICAgICBpZiAoL15cXHMvLnRlc3QobGluZXNbaV0pKSB7XG4gICAgICAgICAgICAgICAgbGluZXNbaSAtIDFdICs9ICdcXG4nICsgbGluZXNbaV07XG4gICAgICAgICAgICAgICAgbGluZXMuc3BsaWNlKGksIDEpO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiBsaW5lc1xuICAgICAgICAgICAgLmZpbHRlcihsaW5lID0+IGxpbmUudHJpbSgpKVxuICAgICAgICAgICAgLm1hcChsaW5lID0+ICh7XG4gICAgICAgICAgICAgICAga2V5OiBsaW5lLnN1YnN0cigwLCBsaW5lLmluZGV4T2YoJzonKSkudHJpbSgpLnRvTG93ZXJDYXNlKCksXG4gICAgICAgICAgICAgICAgbGluZVxuICAgICAgICAgICAgfSkpO1xuICAgIH1cbn1cblxubW9kdWxlLmV4cG9ydHMgPSBNZXNzYWdlUGFyc2VyO1xuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/dkim/message-parser.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/dkim/relaxed-body.js":
/*!**********************************************************!*\
  !*** ./node_modules/nodemailer/lib/dkim/relaxed-body.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\n// streams through a message body and calculates relaxed body hash\n\nconst Transform = (__webpack_require__(/*! stream */ \"stream\").Transform);\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\nclass RelaxedBody extends Transform {\n    constructor(options) {\n        super();\n        options = options || {};\n        this.chunkBuffer = [];\n        this.chunkBufferLen = 0;\n        this.bodyHash = crypto.createHash(options.hashAlgo || 'sha1');\n        this.remainder = '';\n        this.byteLength = 0;\n\n        this.debug = options.debug;\n        this._debugBody = options.debug ? [] : false;\n    }\n\n    updateHash(chunk) {\n        let bodyStr;\n\n        // find next remainder\n        let nextRemainder = '';\n\n        // This crux finds and removes the spaces from the last line and the newline characters after the last non-empty line\n        // If we get another chunk that does not match this description then we can restore the previously processed data\n        let state = 'file';\n        for (let i = chunk.length - 1; i >= 0; i--) {\n            let c = chunk[i];\n\n            if (state === 'file' && (c === 0x0a || c === 0x0d)) {\n                // do nothing, found \\n or \\r at the end of chunk, stil end of file\n            } else if (state === 'file' && (c === 0x09 || c === 0x20)) {\n                // switch to line ending mode, this is the last non-empty line\n                state = 'line';\n            } else if (state === 'line' && (c === 0x09 || c === 0x20)) {\n                // do nothing, found ' ' or \\t at the end of line, keep processing the last non-empty line\n            } else if (state === 'file' || state === 'line') {\n                // non line/file ending character found, switch to body mode\n                state = 'body';\n                if (i === chunk.length - 1) {\n                    // final char is not part of line end or file end, so do nothing\n                    break;\n                }\n            }\n\n            if (i === 0) {\n                // reached to the beginning of the chunk, check if it is still about the ending\n                // and if the remainder also matches\n                if (\n                    (state === 'file' && (!this.remainder || /[\\r\\n]$/.test(this.remainder))) ||\n                    (state === 'line' && (!this.remainder || /[ \\t]$/.test(this.remainder)))\n                ) {\n                    // keep everything\n                    this.remainder += chunk.toString('binary');\n                    return;\n                } else if (state === 'line' || state === 'file') {\n                    // process existing remainder as normal line but store the current chunk\n                    nextRemainder = chunk.toString('binary');\n                    chunk = false;\n                    break;\n                }\n            }\n\n            if (state !== 'body') {\n                continue;\n            }\n\n            // reached first non ending byte\n            nextRemainder = chunk.slice(i + 1).toString('binary');\n            chunk = chunk.slice(0, i + 1);\n            break;\n        }\n\n        let needsFixing = !!this.remainder;\n        if (chunk && !needsFixing) {\n            // check if we even need to change anything\n            for (let i = 0, len = chunk.length; i < len; i++) {\n                if (i && chunk[i] === 0x0a && chunk[i - 1] !== 0x0d) {\n                    // missing \\r before \\n\n                    needsFixing = true;\n                    break;\n                } else if (i && chunk[i] === 0x0d && chunk[i - 1] === 0x20) {\n                    // trailing WSP found\n                    needsFixing = true;\n                    break;\n                } else if (i && chunk[i] === 0x20 && chunk[i - 1] === 0x20) {\n                    // multiple spaces found, needs to be replaced with just one\n                    needsFixing = true;\n                    break;\n                } else if (chunk[i] === 0x09) {\n                    // TAB found, needs to be replaced with a space\n                    needsFixing = true;\n                    break;\n                }\n            }\n        }\n\n        if (needsFixing) {\n            bodyStr = this.remainder + (chunk ? chunk.toString('binary') : '');\n            this.remainder = nextRemainder;\n            bodyStr = bodyStr\n                .replace(/\\r?\\n/g, '\\n') // use js line endings\n                .replace(/[ \\t]*$/gm, '') // remove line endings, rtrim\n                .replace(/[ \\t]+/gm, ' ') // single spaces\n                .replace(/\\n/g, '\\r\\n'); // restore rfc822 line endings\n            chunk = Buffer.from(bodyStr, 'binary');\n        } else if (nextRemainder) {\n            this.remainder = nextRemainder;\n        }\n\n        if (this.debug) {\n            this._debugBody.push(chunk);\n        }\n        this.bodyHash.update(chunk);\n    }\n\n    _transform(chunk, encoding, callback) {\n        if (!chunk || !chunk.length) {\n            return callback();\n        }\n\n        if (typeof chunk === 'string') {\n            chunk = Buffer.from(chunk, encoding);\n        }\n\n        this.updateHash(chunk);\n\n        this.byteLength += chunk.length;\n        this.push(chunk);\n        callback();\n    }\n\n    _flush(callback) {\n        // generate final hash and emit it\n        if (/[\\r\\n]$/.test(this.remainder) && this.byteLength > 2) {\n            // add terminating line end\n            this.bodyHash.update(Buffer.from('\\r\\n'));\n        }\n        if (!this.byteLength) {\n            // emit empty line buffer to keep the stream flowing\n            this.push(Buffer.from('\\r\\n'));\n            // this.bodyHash.update(Buffer.from('\\r\\n'));\n        }\n\n        this.emit('hash', this.bodyHash.digest('base64'), this.debug ? Buffer.concat(this._debugBody) : false);\n        callback();\n    }\n}\n\nmodule.exports = RelaxedBody;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvZGtpbS9yZWxheGVkLWJvZHkuanMiLCJtYXBwaW5ncyI6IkFBQWE7O0FBRWI7O0FBRUEsa0JBQWtCLHVEQUEyQjtBQUM3QyxlQUFlLG1CQUFPLENBQUMsc0JBQVE7O0FBRS9CO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBLHVDQUF1QyxRQUFRO0FBQy9DOztBQUVBO0FBQ0E7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBLGNBQWM7QUFDZDtBQUNBLGNBQWM7QUFDZDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsZ0RBQWdELFNBQVM7QUFDekQ7QUFDQTtBQUNBO0FBQ0E7QUFDQSxrQkFBa0I7QUFDbEI7QUFDQTtBQUNBO0FBQ0Esa0JBQWtCO0FBQ2xCO0FBQ0E7QUFDQTtBQUNBLGtCQUFrQjtBQUNsQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSx5Q0FBeUM7QUFDekM7QUFDQSxVQUFVO0FBQ1Y7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBIiwic291cmNlcyI6WyIvaG9tZS9oeGNrZXIvRGVza3RvcC9iZXQvbm9kZV9tb2R1bGVzL25vZGVtYWlsZXIvbGliL2RraW0vcmVsYXhlZC1ib2R5LmpzIl0sInNvdXJjZXNDb250ZW50IjpbIid1c2Ugc3RyaWN0JztcblxuLy8gc3RyZWFtcyB0aHJvdWdoIGEgbWVzc2FnZSBib2R5IGFuZCBjYWxjdWxhdGVzIHJlbGF4ZWQgYm9keSBoYXNoXG5cbmNvbnN0IFRyYW5zZm9ybSA9IHJlcXVpcmUoJ3N0cmVhbScpLlRyYW5zZm9ybTtcbmNvbnN0IGNyeXB0byA9IHJlcXVpcmUoJ2NyeXB0bycpO1xuXG5jbGFzcyBSZWxheGVkQm9keSBleHRlbmRzIFRyYW5zZm9ybSB7XG4gICAgY29uc3RydWN0b3Iob3B0aW9ucykge1xuICAgICAgICBzdXBlcigpO1xuICAgICAgICBvcHRpb25zID0gb3B0aW9ucyB8fCB7fTtcbiAgICAgICAgdGhpcy5jaHVua0J1ZmZlciA9IFtdO1xuICAgICAgICB0aGlzLmNodW5rQnVmZmVyTGVuID0gMDtcbiAgICAgICAgdGhpcy5ib2R5SGFzaCA9IGNyeXB0by5jcmVhdGVIYXNoKG9wdGlvbnMuaGFzaEFsZ28gfHwgJ3NoYTEnKTtcbiAgICAgICAgdGhpcy5yZW1haW5kZXIgPSAnJztcbiAgICAgICAgdGhpcy5ieXRlTGVuZ3RoID0gMDtcblxuICAgICAgICB0aGlzLmRlYnVnID0gb3B0aW9ucy5kZWJ1ZztcbiAgICAgICAgdGhpcy5fZGVidWdCb2R5ID0gb3B0aW9ucy5kZWJ1ZyA/IFtdIDogZmFsc2U7XG4gICAgfVxuXG4gICAgdXBkYXRlSGFzaChjaHVuaykge1xuICAgICAgICBsZXQgYm9keVN0cjtcblxuICAgICAgICAvLyBmaW5kIG5leHQgcmVtYWluZGVyXG4gICAgICAgIGxldCBuZXh0UmVtYWluZGVyID0gJyc7XG5cbiAgICAgICAgLy8gVGhpcyBjcnV4IGZpbmRzIGFuZCByZW1vdmVzIHRoZSBzcGFjZXMgZnJvbSB0aGUgbGFzdCBsaW5lIGFuZCB0aGUgbmV3bGluZSBjaGFyYWN0ZXJzIGFmdGVyIHRoZSBsYXN0IG5vbi1lbXB0eSBsaW5lXG4gICAgICAgIC8vIElmIHdlIGdldCBhbm90aGVyIGNodW5rIHRoYXQgZG9lcyBub3QgbWF0Y2ggdGhpcyBkZXNjcmlwdGlvbiB0aGVuIHdlIGNhbiByZXN0b3JlIHRoZSBwcmV2aW91c2x5IHByb2Nlc3NlZCBkYXRhXG4gICAgICAgIGxldCBzdGF0ZSA9ICdmaWxlJztcbiAgICAgICAgZm9yIChsZXQgaSA9IGNodW5rLmxlbmd0aCAtIDE7IGkgPj0gMDsgaS0tKSB7XG4gICAgICAgICAgICBsZXQgYyA9IGNodW5rW2ldO1xuXG4gICAgICAgICAgICBpZiAoc3RhdGUgPT09ICdmaWxlJyAmJiAoYyA9PT0gMHgwYSB8fCBjID09PSAweDBkKSkge1xuICAgICAgICAgICAgICAgIC8vIGRvIG5vdGhpbmcsIGZvdW5kIFxcbiBvciBcXHIgYXQgdGhlIGVuZCBvZiBjaHVuaywgc3RpbCBlbmQgb2YgZmlsZVxuICAgICAgICAgICAgfSBlbHNlIGlmIChzdGF0ZSA9PT0gJ2ZpbGUnICYmIChjID09PSAweDA5IHx8IGMgPT09IDB4MjApKSB7XG4gICAgICAgICAgICAgICAgLy8gc3dpdGNoIHRvIGxpbmUgZW5kaW5nIG1vZGUsIHRoaXMgaXMgdGhlIGxhc3Qgbm9uLWVtcHR5IGxpbmVcbiAgICAgICAgICAgICAgICBzdGF0ZSA9ICdsaW5lJztcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoc3RhdGUgPT09ICdsaW5lJyAmJiAoYyA9PT0gMHgwOSB8fCBjID09PSAweDIwKSkge1xuICAgICAgICAgICAgICAgIC8vIGRvIG5vdGhpbmcsIGZvdW5kICcgJyBvciBcXHQgYXQgdGhlIGVuZCBvZiBsaW5lLCBrZWVwIHByb2Nlc3NpbmcgdGhlIGxhc3Qgbm9uLWVtcHR5IGxpbmVcbiAgICAgICAgICAgIH0gZWxzZSBpZiAoc3RhdGUgPT09ICdmaWxlJyB8fCBzdGF0ZSA9PT0gJ2xpbmUnKSB7XG4gICAgICAgICAgICAgICAgLy8gbm9uIGxpbmUvZmlsZSBlbmRpbmcgY2hhcmFjdGVyIGZvdW5kLCBzd2l0Y2ggdG8gYm9keSBtb2RlXG4gICAgICAgICAgICAgICAgc3RhdGUgPSAnYm9keSc7XG4gICAgICAgICAgICAgICAgaWYgKGkgPT09IGNodW5rLmxlbmd0aCAtIDEpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gZmluYWwgY2hhciBpcyBub3QgcGFydCBvZiBsaW5lIGVuZCBvciBmaWxlIGVuZCwgc28gZG8gbm90aGluZ1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChpID09PSAwKSB7XG4gICAgICAgICAgICAgICAgLy8gcmVhY2hlZCB0byB0aGUgYmVnaW5uaW5nIG9mIHRoZSBjaHVuaywgY2hlY2sgaWYgaXQgaXMgc3RpbGwgYWJvdXQgdGhlIGVuZGluZ1xuICAgICAgICAgICAgICAgIC8vIGFuZCBpZiB0aGUgcmVtYWluZGVyIGFsc28gbWF0Y2hlc1xuICAgICAgICAgICAgICAgIGlmIChcbiAgICAgICAgICAgICAgICAgICAgKHN0YXRlID09PSAnZmlsZScgJiYgKCF0aGlzLnJlbWFpbmRlciB8fCAvW1xcclxcbl0kLy50ZXN0KHRoaXMucmVtYWluZGVyKSkpIHx8XG4gICAgICAgICAgICAgICAgICAgIChzdGF0ZSA9PT0gJ2xpbmUnICYmICghdGhpcy5yZW1haW5kZXIgfHwgL1sgXFx0XSQvLnRlc3QodGhpcy5yZW1haW5kZXIpKSlcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgLy8ga2VlcCBldmVyeXRoaW5nXG4gICAgICAgICAgICAgICAgICAgIHRoaXMucmVtYWluZGVyICs9IGNodW5rLnRvU3RyaW5nKCdiaW5hcnknKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoc3RhdGUgPT09ICdsaW5lJyB8fCBzdGF0ZSA9PT0gJ2ZpbGUnKSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIHByb2Nlc3MgZXhpc3RpbmcgcmVtYWluZGVyIGFzIG5vcm1hbCBsaW5lIGJ1dCBzdG9yZSB0aGUgY3VycmVudCBjaHVua1xuICAgICAgICAgICAgICAgICAgICBuZXh0UmVtYWluZGVyID0gY2h1bmsudG9TdHJpbmcoJ2JpbmFyeScpO1xuICAgICAgICAgICAgICAgICAgICBjaHVuayA9IGZhbHNlO1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGlmIChzdGF0ZSAhPT0gJ2JvZHknKSB7XG4gICAgICAgICAgICAgICAgY29udGludWU7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIC8vIHJlYWNoZWQgZmlyc3Qgbm9uIGVuZGluZyBieXRlXG4gICAgICAgICAgICBuZXh0UmVtYWluZGVyID0gY2h1bmsuc2xpY2UoaSArIDEpLnRvU3RyaW5nKCdiaW5hcnknKTtcbiAgICAgICAgICAgIGNodW5rID0gY2h1bmsuc2xpY2UoMCwgaSArIDEpO1xuICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgIH1cblxuICAgICAgICBsZXQgbmVlZHNGaXhpbmcgPSAhIXRoaXMucmVtYWluZGVyO1xuICAgICAgICBpZiAoY2h1bmsgJiYgIW5lZWRzRml4aW5nKSB7XG4gICAgICAgICAgICAvLyBjaGVjayBpZiB3ZSBldmVuIG5lZWQgdG8gY2hhbmdlIGFueXRoaW5nXG4gICAgICAgICAgICBmb3IgKGxldCBpID0gMCwgbGVuID0gY2h1bmsubGVuZ3RoOyBpIDwgbGVuOyBpKyspIHtcbiAgICAgICAgICAgICAgICBpZiAoaSAmJiBjaHVua1tpXSA9PT0gMHgwYSAmJiBjaHVua1tpIC0gMV0gIT09IDB4MGQpIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gbWlzc2luZyBcXHIgYmVmb3JlIFxcblxuICAgICAgICAgICAgICAgICAgICBuZWVkc0ZpeGluZyA9IHRydWU7XG4gICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgIH0gZWxzZSBpZiAoaSAmJiBjaHVua1tpXSA9PT0gMHgwZCAmJiBjaHVua1tpIC0gMV0gPT09IDB4MjApIHtcbiAgICAgICAgICAgICAgICAgICAgLy8gdHJhaWxpbmcgV1NQIGZvdW5kXG4gICAgICAgICAgICAgICAgICAgIG5lZWRzRml4aW5nID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgfSBlbHNlIGlmIChpICYmIGNodW5rW2ldID09PSAweDIwICYmIGNodW5rW2kgLSAxXSA9PT0gMHgyMCkge1xuICAgICAgICAgICAgICAgICAgICAvLyBtdWx0aXBsZSBzcGFjZXMgZm91bmQsIG5lZWRzIHRvIGJlIHJlcGxhY2VkIHdpdGgganVzdCBvbmVcbiAgICAgICAgICAgICAgICAgICAgbmVlZHNGaXhpbmcgPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9IGVsc2UgaWYgKGNodW5rW2ldID09PSAweDA5KSB7XG4gICAgICAgICAgICAgICAgICAgIC8vIFRBQiBmb3VuZCwgbmVlZHMgdG8gYmUgcmVwbGFjZWQgd2l0aCBhIHNwYWNlXG4gICAgICAgICAgICAgICAgICAgIG5lZWRzRml4aW5nID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgaWYgKG5lZWRzRml4aW5nKSB7XG4gICAgICAgICAgICBib2R5U3RyID0gdGhpcy5yZW1haW5kZXIgKyAoY2h1bmsgPyBjaHVuay50b1N0cmluZygnYmluYXJ5JykgOiAnJyk7XG4gICAgICAgICAgICB0aGlzLnJlbWFpbmRlciA9IG5leHRSZW1haW5kZXI7XG4gICAgICAgICAgICBib2R5U3RyID0gYm9keVN0clxuICAgICAgICAgICAgICAgIC5yZXBsYWNlKC9cXHI/XFxuL2csICdcXG4nKSAvLyB1c2UganMgbGluZSBlbmRpbmdzXG4gICAgICAgICAgICAgICAgLnJlcGxhY2UoL1sgXFx0XSokL2dtLCAnJykgLy8gcmVtb3ZlIGxpbmUgZW5kaW5ncywgcnRyaW1cbiAgICAgICAgICAgICAgICAucmVwbGFjZSgvWyBcXHRdKy9nbSwgJyAnKSAvLyBzaW5nbGUgc3BhY2VzXG4gICAgICAgICAgICAgICAgLnJlcGxhY2UoL1xcbi9nLCAnXFxyXFxuJyk7IC8vIHJlc3RvcmUgcmZjODIyIGxpbmUgZW5kaW5nc1xuICAgICAgICAgICAgY2h1bmsgPSBCdWZmZXIuZnJvbShib2R5U3RyLCAnYmluYXJ5Jyk7XG4gICAgICAgIH0gZWxzZSBpZiAobmV4dFJlbWFpbmRlcikge1xuICAgICAgICAgICAgdGhpcy5yZW1haW5kZXIgPSBuZXh0UmVtYWluZGVyO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHRoaXMuZGVidWcpIHtcbiAgICAgICAgICAgIHRoaXMuX2RlYnVnQm9keS5wdXNoKGNodW5rKTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLmJvZHlIYXNoLnVwZGF0ZShjaHVuayk7XG4gICAgfVxuXG4gICAgX3RyYW5zZm9ybShjaHVuaywgZW5jb2RpbmcsIGNhbGxiYWNrKSB7XG4gICAgICAgIGlmICghY2h1bmsgfHwgIWNodW5rLmxlbmd0aCkge1xuICAgICAgICAgICAgcmV0dXJuIGNhbGxiYWNrKCk7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAodHlwZW9mIGNodW5rID09PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgY2h1bmsgPSBCdWZmZXIuZnJvbShjaHVuaywgZW5jb2RpbmcpO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy51cGRhdGVIYXNoKGNodW5rKTtcblxuICAgICAgICB0aGlzLmJ5dGVMZW5ndGggKz0gY2h1bmsubGVuZ3RoO1xuICAgICAgICB0aGlzLnB1c2goY2h1bmspO1xuICAgICAgICBjYWxsYmFjaygpO1xuICAgIH1cblxuICAgIF9mbHVzaChjYWxsYmFjaykge1xuICAgICAgICAvLyBnZW5lcmF0ZSBmaW5hbCBoYXNoIGFuZCBlbWl0IGl0XG4gICAgICAgIGlmICgvW1xcclxcbl0kLy50ZXN0KHRoaXMucmVtYWluZGVyKSAmJiB0aGlzLmJ5dGVMZW5ndGggPiAyKSB7XG4gICAgICAgICAgICAvLyBhZGQgdGVybWluYXRpbmcgbGluZSBlbmRcbiAgICAgICAgICAgIHRoaXMuYm9keUhhc2gudXBkYXRlKEJ1ZmZlci5mcm9tKCdcXHJcXG4nKSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCF0aGlzLmJ5dGVMZW5ndGgpIHtcbiAgICAgICAgICAgIC8vIGVtaXQgZW1wdHkgbGluZSBidWZmZXIgdG8ga2VlcCB0aGUgc3RyZWFtIGZsb3dpbmdcbiAgICAgICAgICAgIHRoaXMucHVzaChCdWZmZXIuZnJvbSgnXFxyXFxuJykpO1xuICAgICAgICAgICAgLy8gdGhpcy5ib2R5SGFzaC51cGRhdGUoQnVmZmVyLmZyb20oJ1xcclxcbicpKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuZW1pdCgnaGFzaCcsIHRoaXMuYm9keUhhc2guZGlnZXN0KCdiYXNlNjQnKSwgdGhpcy5kZWJ1ZyA/IEJ1ZmZlci5jb25jYXQodGhpcy5fZGVidWdCb2R5KSA6IGZhbHNlKTtcbiAgICAgICAgY2FsbGJhY2soKTtcbiAgICB9XG59XG5cbm1vZHVsZS5leHBvcnRzID0gUmVsYXhlZEJvZHk7XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/dkim/relaxed-body.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/dkim/sign.js":
/*!**************************************************!*\
  !*** ./node_modules/nodemailer/lib/dkim/sign.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst punycode = __webpack_require__(/*! ../punycode */ \"(ssr)/./node_modules/nodemailer/lib/punycode/index.js\");\nconst mimeFuncs = __webpack_require__(/*! ../mime-funcs */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\n/**\n * Returns DKIM signature header line\n *\n * @param {Object} headers Parsed headers object from MessageParser\n * @param {String} bodyHash Base64 encoded hash of the message\n * @param {Object} options DKIM options\n * @param {String} options.domainName Domain name to be signed for\n * @param {String} options.keySelector DKIM key selector to use\n * @param {String} options.privateKey DKIM private key to use\n * @return {String} Complete header line\n */\n\nmodule.exports = (headers, hashAlgo, bodyHash, options) => {\n    options = options || {};\n\n    // all listed fields from RFC4871 #5.5\n    let defaultFieldNames =\n        'From:Sender:Reply-To:Subject:Date:Message-ID:To:' +\n        'Cc:MIME-Version:Content-Type:Content-Transfer-Encoding:Content-ID:' +\n        'Content-Description:Resent-Date:Resent-From:Resent-Sender:' +\n        'Resent-To:Resent-Cc:Resent-Message-ID:In-Reply-To:References:' +\n        'List-Id:List-Help:List-Unsubscribe:List-Subscribe:List-Post:' +\n        'List-Owner:List-Archive';\n\n    let fieldNames = options.headerFieldNames || defaultFieldNames;\n\n    let canonicalizedHeaderData = relaxedHeaders(headers, fieldNames, options.skipFields);\n    let dkimHeader = generateDKIMHeader(options.domainName, options.keySelector, canonicalizedHeaderData.fieldNames, hashAlgo, bodyHash);\n\n    let signer, signature;\n\n    canonicalizedHeaderData.headers += 'dkim-signature:' + relaxedHeaderLine(dkimHeader);\n\n    signer = crypto.createSign(('rsa-' + hashAlgo).toUpperCase());\n    signer.update(canonicalizedHeaderData.headers);\n    try {\n        signature = signer.sign(options.privateKey, 'base64');\n    } catch (_E) {\n        return false;\n    }\n\n    return dkimHeader + signature.replace(/(^.{73}|.{75}(?!\\r?\\n|\\r))/g, '$&\\r\\n ').trim();\n};\n\nmodule.exports.relaxedHeaders = relaxedHeaders;\n\nfunction generateDKIMHeader(domainName, keySelector, fieldNames, hashAlgo, bodyHash) {\n    let dkim = [\n        'v=1',\n        'a=rsa-' + hashAlgo,\n        'c=relaxed/relaxed',\n        'd=' + punycode.toASCII(domainName),\n        'q=dns/txt',\n        's=' + keySelector,\n        'bh=' + bodyHash,\n        'h=' + fieldNames\n    ].join('; ');\n\n    return mimeFuncs.foldLines('DKIM-Signature: ' + dkim, 76) + ';\\r\\n b=';\n}\n\nfunction relaxedHeaders(headers, fieldNames, skipFields) {\n    let includedFields = new Set();\n    let skip = new Set();\n    let headerFields = new Map();\n\n    (skipFields || '')\n        .toLowerCase()\n        .split(':')\n        .forEach(field => {\n            skip.add(field.trim());\n        });\n\n    (fieldNames || '')\n        .toLowerCase()\n        .split(':')\n        .filter(field => !skip.has(field.trim()))\n        .forEach(field => {\n            includedFields.add(field.trim());\n        });\n\n    for (let i = headers.length - 1; i >= 0; i--) {\n        let line = headers[i];\n        // only include the first value from bottom to top\n        if (includedFields.has(line.key) && !headerFields.has(line.key)) {\n            headerFields.set(line.key, relaxedHeaderLine(line.line));\n        }\n    }\n\n    let headersList = [];\n    let fields = [];\n    includedFields.forEach(field => {\n        if (headerFields.has(field)) {\n            fields.push(field);\n            headersList.push(field + ':' + headerFields.get(field));\n        }\n    });\n\n    return {\n        headers: headersList.join('\\r\\n') + '\\r\\n',\n        fieldNames: fields.join(':')\n    };\n}\n\nfunction relaxedHeaderLine(line) {\n    return line\n        .substr(line.indexOf(':') + 1)\n        .replace(/\\r?\\n/g, '')\n        .replace(/\\s+/g, ' ')\n        .trim();\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/dkim/sign.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/fetch/cookies.js":
/*!******************************************************!*\
  !*** ./node_modules/nodemailer/lib/fetch/cookies.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\n// module to handle cookies\n\nconst urllib = __webpack_require__(/*! url */ \"url\");\n\nconst SESSION_TIMEOUT = 1800; // 30 min\n\n/**\n * Creates a biskviit cookie jar for managing cookie values in memory\n *\n * @constructor\n * @param {Object} [options] Optional options object\n */\nclass Cookies {\n    constructor(options) {\n        this.options = options || {};\n        this.cookies = [];\n    }\n\n    /**\n     * Stores a cookie string to the cookie storage\n     *\n     * @param {String} cookieStr Value from the 'Set-Cookie:' header\n     * @param {String} url Current URL\n     */\n    set(cookieStr, url) {\n        let urlparts = urllib.parse(url || '');\n        let cookie = this.parse(cookieStr);\n        let domain;\n\n        if (cookie.domain) {\n            domain = cookie.domain.replace(/^\\./, '');\n\n            // do not allow cross origin cookies\n            if (\n                // can't be valid if the requested domain is shorter than current hostname\n                urlparts.hostname.length < domain.length ||\n                // prefix domains with dot to be sure that partial matches are not used\n                ('.' + urlparts.hostname).substr(-domain.length + 1) !== '.' + domain\n            ) {\n                cookie.domain = urlparts.hostname;\n            }\n        } else {\n            cookie.domain = urlparts.hostname;\n        }\n\n        if (!cookie.path) {\n            cookie.path = this.getPath(urlparts.pathname);\n        }\n\n        // if no expire date, then use sessionTimeout value\n        if (!cookie.expires) {\n            cookie.expires = new Date(Date.now() + (Number(this.options.sessionTimeout || SESSION_TIMEOUT) || SESSION_TIMEOUT) * 1000);\n        }\n\n        return this.add(cookie);\n    }\n\n    /**\n     * Returns cookie string for the 'Cookie:' header.\n     *\n     * @param {String} url URL to check for\n     * @returns {String} Cookie header or empty string if no matches were found\n     */\n    get(url) {\n        return this.list(url)\n            .map(cookie => cookie.name + '=' + cookie.value)\n            .join('; ');\n    }\n\n    /**\n     * Lists all valied cookie objects for the specified URL\n     *\n     * @param {String} url URL to check for\n     * @returns {Array} An array of cookie objects\n     */\n    list(url) {\n        let result = [];\n        let i;\n        let cookie;\n\n        for (i = this.cookies.length - 1; i >= 0; i--) {\n            cookie = this.cookies[i];\n\n            if (this.isExpired(cookie)) {\n                this.cookies.splice(i, i);\n                continue;\n            }\n\n            if (this.match(cookie, url)) {\n                result.unshift(cookie);\n            }\n        }\n\n        return result;\n    }\n\n    /**\n     * Parses cookie string from the 'Set-Cookie:' header\n     *\n     * @param {String} cookieStr String from the 'Set-Cookie:' header\n     * @returns {Object} Cookie object\n     */\n    parse(cookieStr) {\n        let cookie = {};\n\n        (cookieStr || '')\n            .toString()\n            .split(';')\n            .forEach(cookiePart => {\n                let valueParts = cookiePart.split('=');\n                let key = valueParts.shift().trim().toLowerCase();\n                let value = valueParts.join('=').trim();\n                let domain;\n\n                if (!key) {\n                    // skip empty parts\n                    return;\n                }\n\n                switch (key) {\n                    case 'expires':\n                        value = new Date(value);\n                        // ignore date if can not parse it\n                        if (value.toString() !== 'Invalid Date') {\n                            cookie.expires = value;\n                        }\n                        break;\n\n                    case 'path':\n                        cookie.path = value;\n                        break;\n\n                    case 'domain':\n                        domain = value.toLowerCase();\n                        if (domain.length && domain.charAt(0) !== '.') {\n                            domain = '.' + domain; // ensure preceeding dot for user set domains\n                        }\n                        cookie.domain = domain;\n                        break;\n\n                    case 'max-age':\n                        cookie.expires = new Date(Date.now() + (Number(value) || 0) * 1000);\n                        break;\n\n                    case 'secure':\n                        cookie.secure = true;\n                        break;\n\n                    case 'httponly':\n                        cookie.httponly = true;\n                        break;\n\n                    default:\n                        if (!cookie.name) {\n                            cookie.name = key;\n                            cookie.value = value;\n                        }\n                }\n            });\n\n        return cookie;\n    }\n\n    /**\n     * Checks if a cookie object is valid for a specified URL\n     *\n     * @param {Object} cookie Cookie object\n     * @param {String} url URL to check for\n     * @returns {Boolean} true if cookie is valid for specifiec URL\n     */\n    match(cookie, url) {\n        let urlparts = urllib.parse(url || '');\n\n        // check if hostname matches\n        // .foo.com also matches subdomains, foo.com does not\n        if (\n            urlparts.hostname !== cookie.domain &&\n            (cookie.domain.charAt(0) !== '.' || ('.' + urlparts.hostname).substr(-cookie.domain.length) !== cookie.domain)\n        ) {\n            return false;\n        }\n\n        // check if path matches\n        let path = this.getPath(urlparts.pathname);\n        if (path.substr(0, cookie.path.length) !== cookie.path) {\n            return false;\n        }\n\n        // check secure argument\n        if (cookie.secure && urlparts.protocol !== 'https:') {\n            return false;\n        }\n\n        return true;\n    }\n\n    /**\n     * Adds (or updates/removes if needed) a cookie object to the cookie storage\n     *\n     * @param {Object} cookie Cookie value to be stored\n     */\n    add(cookie) {\n        let i;\n        let len;\n\n        // nothing to do here\n        if (!cookie || !cookie.name) {\n            return false;\n        }\n\n        // overwrite if has same params\n        for (i = 0, len = this.cookies.length; i < len; i++) {\n            if (this.compare(this.cookies[i], cookie)) {\n                // check if the cookie needs to be removed instead\n                if (this.isExpired(cookie)) {\n                    this.cookies.splice(i, 1); // remove expired/unset cookie\n                    return false;\n                }\n\n                this.cookies[i] = cookie;\n                return true;\n            }\n        }\n\n        // add as new if not already expired\n        if (!this.isExpired(cookie)) {\n            this.cookies.push(cookie);\n        }\n\n        return true;\n    }\n\n    /**\n     * Checks if two cookie objects are the same\n     *\n     * @param {Object} a Cookie to check against\n     * @param {Object} b Cookie to check against\n     * @returns {Boolean} True, if the cookies are the same\n     */\n    compare(a, b) {\n        return a.name === b.name && a.path === b.path && a.domain === b.domain && a.secure === b.secure && a.httponly === a.httponly;\n    }\n\n    /**\n     * Checks if a cookie is expired\n     *\n     * @param {Object} cookie Cookie object to check against\n     * @returns {Boolean} True, if the cookie is expired\n     */\n    isExpired(cookie) {\n        return (cookie.expires && cookie.expires < new Date()) || !cookie.value;\n    }\n\n    /**\n     * Returns normalized cookie path for an URL path argument\n     *\n     * @param {String} pathname\n     * @returns {String} Normalized path\n     */\n    getPath(pathname) {\n        let path = (pathname || '/').split('/');\n        path.pop(); // remove filename part\n        path = path.join('/').trim();\n\n        // ensure path prefix /\n        if (path.charAt(0) !== '/') {\n            path = '/' + path;\n        }\n\n        // ensure path suffix /\n        if (path.substr(-1) !== '/') {\n            path += '/';\n        }\n\n        return path;\n    }\n}\n\nmodule.exports = Cookies;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/fetch/cookies.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/fetch/index.js":
/*!****************************************************!*\
  !*** ./node_modules/nodemailer/lib/fetch/index.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst http = __webpack_require__(/*! http */ \"http\");\nconst https = __webpack_require__(/*! https */ \"https\");\nconst urllib = __webpack_require__(/*! url */ \"url\");\nconst zlib = __webpack_require__(/*! zlib */ \"zlib\");\nconst PassThrough = (__webpack_require__(/*! stream */ \"stream\").PassThrough);\nconst Cookies = __webpack_require__(/*! ./cookies */ \"(ssr)/./node_modules/nodemailer/lib/fetch/cookies.js\");\nconst packageData = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst net = __webpack_require__(/*! net */ \"net\");\n\nconst MAX_REDIRECTS = 5;\n\nmodule.exports = function (url, options) {\n    return nmfetch(url, options);\n};\n\nmodule.exports.Cookies = Cookies;\n\nfunction nmfetch(url, options) {\n    options = options || {};\n\n    options.fetchRes = options.fetchRes || new PassThrough();\n    options.cookies = options.cookies || new Cookies();\n    options.redirects = options.redirects || 0;\n    options.maxRedirects = isNaN(options.maxRedirects) ? MAX_REDIRECTS : options.maxRedirects;\n\n    if (options.cookie) {\n        [].concat(options.cookie || []).forEach(cookie => {\n            options.cookies.set(cookie, url);\n        });\n        options.cookie = false;\n    }\n\n    let fetchRes = options.fetchRes;\n    let parsed = urllib.parse(url);\n    let method = (options.method || '').toString().trim().toUpperCase() || 'GET';\n    let finished = false;\n    let cookies;\n    let body;\n\n    let handler = parsed.protocol === 'https:' ? https : http;\n\n    let headers = {\n        'accept-encoding': 'gzip,deflate',\n        'user-agent': 'nodemailer/' + packageData.version\n    };\n\n    Object.keys(options.headers || {}).forEach(key => {\n        headers[key.toLowerCase().trim()] = options.headers[key];\n    });\n\n    if (options.userAgent) {\n        headers['user-agent'] = options.userAgent;\n    }\n\n    if (parsed.auth) {\n        headers.Authorization = 'Basic ' + Buffer.from(parsed.auth).toString('base64');\n    }\n\n    if ((cookies = options.cookies.get(url))) {\n        headers.cookie = cookies;\n    }\n\n    if (options.body) {\n        if (options.contentType !== false) {\n            headers['Content-Type'] = options.contentType || 'application/x-www-form-urlencoded';\n        }\n\n        if (typeof options.body.pipe === 'function') {\n            // it's a stream\n            headers['Transfer-Encoding'] = 'chunked';\n            body = options.body;\n            body.on('error', err => {\n                if (finished) {\n                    return;\n                }\n                finished = true;\n                err.type = 'FETCH';\n                err.sourceUrl = url;\n                fetchRes.emit('error', err);\n            });\n        } else {\n            if (options.body instanceof Buffer) {\n                body = options.body;\n            } else if (typeof options.body === 'object') {\n                try {\n                    // encodeURIComponent can fail on invalid input (partial emoji etc.)\n                    body = Buffer.from(\n                        Object.keys(options.body)\n                            .map(key => {\n                                let value = options.body[key].toString().trim();\n                                return encodeURIComponent(key) + '=' + encodeURIComponent(value);\n                            })\n                            .join('&')\n                    );\n                } catch (E) {\n                    if (finished) {\n                        return;\n                    }\n                    finished = true;\n                    E.type = 'FETCH';\n                    E.sourceUrl = url;\n                    fetchRes.emit('error', E);\n                    return;\n                }\n            } else {\n                body = Buffer.from(options.body.toString().trim());\n            }\n\n            headers['Content-Type'] = options.contentType || 'application/x-www-form-urlencoded';\n            headers['Content-Length'] = body.length;\n        }\n        // if method is not provided, use POST instead of GET\n        method = (options.method || '').toString().trim().toUpperCase() || 'POST';\n    }\n\n    let req;\n    let reqOptions = {\n        method,\n        host: parsed.hostname,\n        path: parsed.path,\n        port: parsed.port ? parsed.port : parsed.protocol === 'https:' ? 443 : 80,\n        headers,\n        rejectUnauthorized: false,\n        agent: false\n    };\n\n    if (options.tls) {\n        Object.keys(options.tls).forEach(key => {\n            reqOptions[key] = options.tls[key];\n        });\n    }\n\n    if (\n        parsed.protocol === 'https:' &&\n        parsed.hostname &&\n        parsed.hostname !== reqOptions.host &&\n        !net.isIP(parsed.hostname) &&\n        !reqOptions.servername\n    ) {\n        reqOptions.servername = parsed.hostname;\n    }\n\n    try {\n        req = handler.request(reqOptions);\n    } catch (E) {\n        finished = true;\n        setImmediate(() => {\n            E.type = 'FETCH';\n            E.sourceUrl = url;\n            fetchRes.emit('error', E);\n        });\n        return fetchRes;\n    }\n\n    if (options.timeout) {\n        req.setTimeout(options.timeout, () => {\n            if (finished) {\n                return;\n            }\n            finished = true;\n            req.abort();\n            let err = new Error('Request Timeout');\n            err.type = 'FETCH';\n            err.sourceUrl = url;\n            fetchRes.emit('error', err);\n        });\n    }\n\n    req.on('error', err => {\n        if (finished) {\n            return;\n        }\n        finished = true;\n        err.type = 'FETCH';\n        err.sourceUrl = url;\n        fetchRes.emit('error', err);\n    });\n\n    req.on('response', res => {\n        let inflate;\n\n        if (finished) {\n            return;\n        }\n\n        switch (res.headers['content-encoding']) {\n            case 'gzip':\n            case 'deflate':\n                inflate = zlib.createUnzip();\n                break;\n        }\n\n        if (res.headers['set-cookie']) {\n            [].concat(res.headers['set-cookie'] || []).forEach(cookie => {\n                options.cookies.set(cookie, url);\n            });\n        }\n\n        if ([301, 302, 303, 307, 308].includes(res.statusCode) && res.headers.location) {\n            // redirect\n            options.redirects++;\n            if (options.redirects > options.maxRedirects) {\n                finished = true;\n                let err = new Error('Maximum redirect count exceeded');\n                err.type = 'FETCH';\n                err.sourceUrl = url;\n                fetchRes.emit('error', err);\n                req.abort();\n                return;\n            }\n            // redirect does not include POST body\n            options.method = 'GET';\n            options.body = false;\n            return nmfetch(urllib.resolve(url, res.headers.location), options);\n        }\n\n        fetchRes.statusCode = res.statusCode;\n        fetchRes.headers = res.headers;\n\n        if (res.statusCode >= 300 && !options.allowErrorResponse) {\n            finished = true;\n            let err = new Error('Invalid status code ' + res.statusCode);\n            err.type = 'FETCH';\n            err.sourceUrl = url;\n            fetchRes.emit('error', err);\n            req.abort();\n            return;\n        }\n\n        res.on('error', err => {\n            if (finished) {\n                return;\n            }\n            finished = true;\n            err.type = 'FETCH';\n            err.sourceUrl = url;\n            fetchRes.emit('error', err);\n            req.abort();\n        });\n\n        if (inflate) {\n            res.pipe(inflate).pipe(fetchRes);\n            inflate.on('error', err => {\n                if (finished) {\n                    return;\n                }\n                finished = true;\n                err.type = 'FETCH';\n                err.sourceUrl = url;\n                fetchRes.emit('error', err);\n                req.abort();\n            });\n        } else {\n            res.pipe(fetchRes);\n        }\n    });\n\n    setImmediate(() => {\n        if (body) {\n            try {\n                if (typeof body.pipe === 'function') {\n                    return body.pipe(req);\n                } else {\n                    req.write(body);\n                }\n            } catch (err) {\n                finished = true;\n                err.type = 'FETCH';\n                err.sourceUrl = url;\n                fetchRes.emit('error', err);\n                return;\n            }\n        }\n        req.end();\n    });\n\n    return fetchRes;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/fetch/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/json-transport/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/nodemailer/lib/json-transport/index.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst packageData = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\n\n/**\n * Generates a Transport object to generate JSON output\n *\n * @constructor\n * @param {Object} optional config parameter\n */\nclass JSONTransport {\n    constructor(options) {\n        options = options || {};\n\n        this.options = options || {};\n\n        this.name = 'JSONTransport';\n        this.version = packageData.version;\n\n        this.logger = shared.getLogger(this.options, {\n            component: this.options.component || 'json-transport'\n        });\n    }\n\n    /**\n     * <p>Compiles a mailcomposer message and forwards it to handler that sends it.</p>\n     *\n     * @param {Object} emailMessage MailComposer object\n     * @param {Function} callback Callback function to run when the sending is completed\n     */\n    send(mail, done) {\n        // Sendmail strips this header line by itself\n        mail.message.keepBcc = true;\n\n        let envelope = mail.data.envelope || mail.message.getEnvelope();\n        let messageId = mail.message.messageId();\n\n        let recipients = [].concat(envelope.to || []);\n        if (recipients.length > 3) {\n            recipients.push('...and ' + recipients.splice(2).length + ' more');\n        }\n        this.logger.info(\n            {\n                tnx: 'send',\n                messageId\n            },\n            'Composing JSON structure of %s to <%s>',\n            messageId,\n            recipients.join(', ')\n        );\n\n        setImmediate(() => {\n            mail.normalize((err, data) => {\n                if (err) {\n                    this.logger.error(\n                        {\n                            err,\n                            tnx: 'send',\n                            messageId\n                        },\n                        'Failed building JSON structure for %s. %s',\n                        messageId,\n                        err.message\n                    );\n                    return done(err);\n                }\n\n                delete data.envelope;\n                delete data.normalizedHeaders;\n\n                return done(null, {\n                    envelope,\n                    messageId,\n                    message: this.options.skipEncoding ? data : JSON.stringify(data)\n                });\n            });\n        });\n    }\n}\n\nmodule.exports = JSONTransport;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/json-transport/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mail-composer/index.js":
/*!************************************************************!*\
  !*** ./node_modules/nodemailer/lib/mail-composer/index.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("/* eslint no-undefined: 0 */\n\n\n\nconst MimeNode = __webpack_require__(/*! ../mime-node */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/index.js\");\nconst mimeFuncs = __webpack_require__(/*! ../mime-funcs */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js\");\nconst parseDataURI = (__webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\").parseDataURI);\n\n/**\n * Creates the object for composing a MimeNode instance out from the mail options\n *\n * @constructor\n * @param {Object} mail Mail options\n */\nclass MailComposer {\n    constructor(mail) {\n        this.mail = mail || {};\n        this.message = false;\n    }\n\n    /**\n     * Builds MimeNode instance\n     */\n    compile() {\n        this._alternatives = this.getAlternatives();\n        this._htmlNode = this._alternatives.filter(alternative => /^text\\/html\\b/i.test(alternative.contentType)).pop();\n        this._attachments = this.getAttachments(!!this._htmlNode);\n\n        this._useRelated = !!(this._htmlNode && this._attachments.related.length);\n        this._useAlternative = this._alternatives.length > 1;\n        this._useMixed = this._attachments.attached.length > 1 || (this._alternatives.length && this._attachments.attached.length === 1);\n\n        // Compose MIME tree\n        if (this.mail.raw) {\n            this.message = new MimeNode('message/rfc822', { newline: this.mail.newline }).setRaw(this.mail.raw);\n        } else if (this._useMixed) {\n            this.message = this._createMixed();\n        } else if (this._useAlternative) {\n            this.message = this._createAlternative();\n        } else if (this._useRelated) {\n            this.message = this._createRelated();\n        } else {\n            this.message = this._createContentNode(\n                false,\n                []\n                    .concat(this._alternatives || [])\n                    .concat(this._attachments.attached || [])\n                    .shift() || {\n                    contentType: 'text/plain',\n                    content: ''\n                }\n            );\n        }\n\n        // Add custom headers\n        if (this.mail.headers) {\n            this.message.addHeader(this.mail.headers);\n        }\n\n        // Add headers to the root node, always overrides custom headers\n        ['from', 'sender', 'to', 'cc', 'bcc', 'reply-to', 'in-reply-to', 'references', 'subject', 'message-id', 'date'].forEach(header => {\n            let key = header.replace(/-(\\w)/g, (o, c) => c.toUpperCase());\n            if (this.mail[key]) {\n                this.message.setHeader(header, this.mail[key]);\n            }\n        });\n\n        // Sets custom envelope\n        if (this.mail.envelope) {\n            this.message.setEnvelope(this.mail.envelope);\n        }\n\n        // ensure Message-Id value\n        this.message.messageId();\n\n        return this.message;\n    }\n\n    /**\n     * List all attachments. Resulting attachment objects can be used as input for MimeNode nodes\n     *\n     * @param {Boolean} findRelated If true separate related attachments from attached ones\n     * @returns {Object} An object of arrays (`related` and `attached`)\n     */\n    getAttachments(findRelated) {\n        let icalEvent, eventObject;\n        let attachments = [].concat(this.mail.attachments || []).map((attachment, i) => {\n            let data;\n\n            if (/^data:/i.test(attachment.path || attachment.href)) {\n                attachment = this._processDataUrl(attachment);\n            }\n\n            let contentType =\n                attachment.contentType || mimeFuncs.detectMimeType(attachment.filename || attachment.path || attachment.href || 'bin');\n\n            let isImage = /^image\\//i.test(contentType);\n            let isMessageNode = /^message\\//i.test(contentType);\n\n            let contentDisposition =\n                attachment.contentDisposition || (isMessageNode || (isImage && attachment.cid) ? 'inline' : 'attachment');\n\n            let contentTransferEncoding;\n            if ('contentTransferEncoding' in attachment) {\n                // also contains `false`, to set\n                contentTransferEncoding = attachment.contentTransferEncoding;\n            } else if (isMessageNode) {\n                contentTransferEncoding = '7bit';\n            } else {\n                contentTransferEncoding = 'base64'; // the default\n            }\n\n            data = {\n                contentType,\n                contentDisposition,\n                contentTransferEncoding\n            };\n\n            if (attachment.filename) {\n                data.filename = attachment.filename;\n            } else if (!isMessageNode && attachment.filename !== false) {\n                data.filename = (attachment.path || attachment.href || '').split('/').pop().split('?').shift() || 'attachment-' + (i + 1);\n                if (data.filename.indexOf('.') < 0) {\n                    data.filename += '.' + mimeFuncs.detectExtension(data.contentType);\n                }\n            }\n\n            if (/^https?:\\/\\//i.test(attachment.path)) {\n                attachment.href = attachment.path;\n                attachment.path = undefined;\n            }\n\n            if (attachment.cid) {\n                data.cid = attachment.cid;\n            }\n\n            if (attachment.raw) {\n                data.raw = attachment.raw;\n            } else if (attachment.path) {\n                data.content = {\n                    path: attachment.path\n                };\n            } else if (attachment.href) {\n                data.content = {\n                    href: attachment.href,\n                    httpHeaders: attachment.httpHeaders\n                };\n            } else {\n                data.content = attachment.content || '';\n            }\n\n            if (attachment.encoding) {\n                data.encoding = attachment.encoding;\n            }\n\n            if (attachment.headers) {\n                data.headers = attachment.headers;\n            }\n\n            return data;\n        });\n\n        if (this.mail.icalEvent) {\n            if (\n                typeof this.mail.icalEvent === 'object' &&\n                (this.mail.icalEvent.content || this.mail.icalEvent.path || this.mail.icalEvent.href || this.mail.icalEvent.raw)\n            ) {\n                icalEvent = this.mail.icalEvent;\n            } else {\n                icalEvent = {\n                    content: this.mail.icalEvent\n                };\n            }\n\n            eventObject = {};\n            Object.keys(icalEvent).forEach(key => {\n                eventObject[key] = icalEvent[key];\n            });\n\n            eventObject.contentType = 'application/ics';\n            if (!eventObject.headers) {\n                eventObject.headers = {};\n            }\n            eventObject.filename = eventObject.filename || 'invite.ics';\n            eventObject.headers['Content-Disposition'] = 'attachment';\n            eventObject.headers['Content-Transfer-Encoding'] = 'base64';\n        }\n\n        if (!findRelated) {\n            return {\n                attached: attachments.concat(eventObject || []),\n                related: []\n            };\n        } else {\n            return {\n                attached: attachments.filter(attachment => !attachment.cid).concat(eventObject || []),\n                related: attachments.filter(attachment => !!attachment.cid)\n            };\n        }\n    }\n\n    /**\n     * List alternatives. Resulting objects can be used as input for MimeNode nodes\n     *\n     * @returns {Array} An array of alternative elements. Includes the `text` and `html` values as well\n     */\n    getAlternatives() {\n        let alternatives = [],\n            text,\n            html,\n            watchHtml,\n            amp,\n            icalEvent,\n            eventObject;\n\n        if (this.mail.text) {\n            if (\n                typeof this.mail.text === 'object' &&\n                (this.mail.text.content || this.mail.text.path || this.mail.text.href || this.mail.text.raw)\n            ) {\n                text = this.mail.text;\n            } else {\n                text = {\n                    content: this.mail.text\n                };\n            }\n            text.contentType = 'text/plain; charset=utf-8';\n        }\n\n        if (this.mail.watchHtml) {\n            if (\n                typeof this.mail.watchHtml === 'object' &&\n                (this.mail.watchHtml.content || this.mail.watchHtml.path || this.mail.watchHtml.href || this.mail.watchHtml.raw)\n            ) {\n                watchHtml = this.mail.watchHtml;\n            } else {\n                watchHtml = {\n                    content: this.mail.watchHtml\n                };\n            }\n            watchHtml.contentType = 'text/watch-html; charset=utf-8';\n        }\n\n        if (this.mail.amp) {\n            if (\n                typeof this.mail.amp === 'object' &&\n                (this.mail.amp.content || this.mail.amp.path || this.mail.amp.href || this.mail.amp.raw)\n            ) {\n                amp = this.mail.amp;\n            } else {\n                amp = {\n                    content: this.mail.amp\n                };\n            }\n            amp.contentType = 'text/x-amp-html; charset=utf-8';\n        }\n\n        // NB! when including attachments with a calendar alternative you might end up in a blank screen on some clients\n        if (this.mail.icalEvent) {\n            if (\n                typeof this.mail.icalEvent === 'object' &&\n                (this.mail.icalEvent.content || this.mail.icalEvent.path || this.mail.icalEvent.href || this.mail.icalEvent.raw)\n            ) {\n                icalEvent = this.mail.icalEvent;\n            } else {\n                icalEvent = {\n                    content: this.mail.icalEvent\n                };\n            }\n\n            eventObject = {};\n            Object.keys(icalEvent).forEach(key => {\n                eventObject[key] = icalEvent[key];\n            });\n\n            if (eventObject.content && typeof eventObject.content === 'object') {\n                // we are going to have the same attachment twice, so mark this to be\n                // resolved just once\n                eventObject.content._resolve = true;\n            }\n\n            eventObject.filename = false;\n            eventObject.contentType =\n                'text/calendar; charset=utf-8; method=' + (eventObject.method || 'PUBLISH').toString().trim().toUpperCase();\n            if (!eventObject.headers) {\n                eventObject.headers = {};\n            }\n        }\n\n        if (this.mail.html) {\n            if (\n                typeof this.mail.html === 'object' &&\n                (this.mail.html.content || this.mail.html.path || this.mail.html.href || this.mail.html.raw)\n            ) {\n                html = this.mail.html;\n            } else {\n                html = {\n                    content: this.mail.html\n                };\n            }\n            html.contentType = 'text/html; charset=utf-8';\n        }\n\n        []\n            .concat(text || [])\n            .concat(watchHtml || [])\n            .concat(amp || [])\n            .concat(html || [])\n            .concat(eventObject || [])\n            .concat(this.mail.alternatives || [])\n            .forEach(alternative => {\n                let data;\n\n                if (/^data:/i.test(alternative.path || alternative.href)) {\n                    alternative = this._processDataUrl(alternative);\n                }\n\n                data = {\n                    contentType:\n                        alternative.contentType ||\n                        mimeFuncs.detectMimeType(alternative.filename || alternative.path || alternative.href || 'txt'),\n                    contentTransferEncoding: alternative.contentTransferEncoding\n                };\n\n                if (alternative.filename) {\n                    data.filename = alternative.filename;\n                }\n\n                if (/^https?:\\/\\//i.test(alternative.path)) {\n                    alternative.href = alternative.path;\n                    alternative.path = undefined;\n                }\n\n                if (alternative.raw) {\n                    data.raw = alternative.raw;\n                } else if (alternative.path) {\n                    data.content = {\n                        path: alternative.path\n                    };\n                } else if (alternative.href) {\n                    data.content = {\n                        href: alternative.href\n                    };\n                } else {\n                    data.content = alternative.content || '';\n                }\n\n                if (alternative.encoding) {\n                    data.encoding = alternative.encoding;\n                }\n\n                if (alternative.headers) {\n                    data.headers = alternative.headers;\n                }\n\n                alternatives.push(data);\n            });\n\n        return alternatives;\n    }\n\n    /**\n     * Builds multipart/mixed node. It should always contain different type of elements on the same level\n     * eg. text + attachments\n     *\n     * @param {Object} parentNode Parent for this note. If it does not exist, a root node is created\n     * @returns {Object} MimeNode node element\n     */\n    _createMixed(parentNode) {\n        let node;\n\n        if (!parentNode) {\n            node = new MimeNode('multipart/mixed', {\n                baseBoundary: this.mail.baseBoundary,\n                textEncoding: this.mail.textEncoding,\n                boundaryPrefix: this.mail.boundaryPrefix,\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        } else {\n            node = parentNode.createChild('multipart/mixed', {\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        }\n\n        if (this._useAlternative) {\n            this._createAlternative(node);\n        } else if (this._useRelated) {\n            this._createRelated(node);\n        }\n\n        []\n            .concat((!this._useAlternative && this._alternatives) || [])\n            .concat(this._attachments.attached || [])\n            .forEach(element => {\n                // if the element is a html node from related subpart then ignore it\n                if (!this._useRelated || element !== this._htmlNode) {\n                    this._createContentNode(node, element);\n                }\n            });\n\n        return node;\n    }\n\n    /**\n     * Builds multipart/alternative node. It should always contain same type of elements on the same level\n     * eg. text + html view of the same data\n     *\n     * @param {Object} parentNode Parent for this note. If it does not exist, a root node is created\n     * @returns {Object} MimeNode node element\n     */\n    _createAlternative(parentNode) {\n        let node;\n\n        if (!parentNode) {\n            node = new MimeNode('multipart/alternative', {\n                baseBoundary: this.mail.baseBoundary,\n                textEncoding: this.mail.textEncoding,\n                boundaryPrefix: this.mail.boundaryPrefix,\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        } else {\n            node = parentNode.createChild('multipart/alternative', {\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        }\n\n        this._alternatives.forEach(alternative => {\n            if (this._useRelated && this._htmlNode === alternative) {\n                this._createRelated(node);\n            } else {\n                this._createContentNode(node, alternative);\n            }\n        });\n\n        return node;\n    }\n\n    /**\n     * Builds multipart/related node. It should always contain html node with related attachments\n     *\n     * @param {Object} parentNode Parent for this note. If it does not exist, a root node is created\n     * @returns {Object} MimeNode node element\n     */\n    _createRelated(parentNode) {\n        let node;\n\n        if (!parentNode) {\n            node = new MimeNode('multipart/related; type=\"text/html\"', {\n                baseBoundary: this.mail.baseBoundary,\n                textEncoding: this.mail.textEncoding,\n                boundaryPrefix: this.mail.boundaryPrefix,\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        } else {\n            node = parentNode.createChild('multipart/related; type=\"text/html\"', {\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        }\n\n        this._createContentNode(node, this._htmlNode);\n\n        this._attachments.related.forEach(alternative => this._createContentNode(node, alternative));\n\n        return node;\n    }\n\n    /**\n     * Creates a regular node with contents\n     *\n     * @param {Object} parentNode Parent for this note. If it does not exist, a root node is created\n     * @param {Object} element Node data\n     * @returns {Object} MimeNode node element\n     */\n    _createContentNode(parentNode, element) {\n        element = element || {};\n        element.content = element.content || '';\n\n        let node;\n        let encoding = (element.encoding || 'utf8')\n            .toString()\n            .toLowerCase()\n            .replace(/[-_\\s]/g, '');\n\n        if (!parentNode) {\n            node = new MimeNode(element.contentType, {\n                filename: element.filename,\n                baseBoundary: this.mail.baseBoundary,\n                textEncoding: this.mail.textEncoding,\n                boundaryPrefix: this.mail.boundaryPrefix,\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        } else {\n            node = parentNode.createChild(element.contentType, {\n                filename: element.filename,\n                textEncoding: this.mail.textEncoding,\n                disableUrlAccess: this.mail.disableUrlAccess,\n                disableFileAccess: this.mail.disableFileAccess,\n                normalizeHeaderKey: this.mail.normalizeHeaderKey,\n                newline: this.mail.newline\n            });\n        }\n\n        // add custom headers\n        if (element.headers) {\n            node.addHeader(element.headers);\n        }\n\n        if (element.cid) {\n            node.setHeader('Content-Id', '<' + element.cid.replace(/[<>]/g, '') + '>');\n        }\n\n        if (element.contentTransferEncoding) {\n            node.setHeader('Content-Transfer-Encoding', element.contentTransferEncoding);\n        } else if (this.mail.encoding && /^text\\//i.test(element.contentType)) {\n            node.setHeader('Content-Transfer-Encoding', this.mail.encoding);\n        }\n\n        if (!/^text\\//i.test(element.contentType) || element.contentDisposition) {\n            node.setHeader(\n                'Content-Disposition',\n                element.contentDisposition || (element.cid && /^image\\//i.test(element.contentType) ? 'inline' : 'attachment')\n            );\n        }\n\n        if (typeof element.content === 'string' && !['utf8', 'usascii', 'ascii'].includes(encoding)) {\n            element.content = Buffer.from(element.content, encoding);\n        }\n\n        // prefer pregenerated raw content\n        if (element.raw) {\n            node.setRaw(element.raw);\n        } else {\n            node.setContent(element.content);\n        }\n\n        return node;\n    }\n\n    /**\n     * Parses data uri and converts it to a Buffer\n     *\n     * @param {Object} element Content element\n     * @return {Object} Parsed element\n     */\n    _processDataUrl(element) {\n        const dataUrl = element.path || element.href;\n\n        // Early validation to prevent ReDoS\n        if (!dataUrl || typeof dataUrl !== 'string') {\n            return element;\n        }\n\n        if (!dataUrl.startsWith('data:')) {\n            return element;\n        }\n\n        if (dataUrl.length > 52428800) {\n            // 52428800 chars = 50MB limit for data URL string (~37.5MB decoded image)\n            // Extract content type before rejecting to preserve MIME type\n            let detectedType = 'application/octet-stream';\n            const commaPos = dataUrl.indexOf(',');\n\n            if (commaPos > 0 && commaPos < 200) {\n                // Parse header safely with size limit\n                const header = dataUrl.substring(5, commaPos); // skip 'data:'\n                const parts = header.split(';');\n                if (parts[0] && parts[0].includes('/')) {\n                    detectedType = parts[0].trim();\n                }\n            }\n\n            // Return empty content for excessively long data URLs\n            return Object.assign({}, element, {\n                path: false,\n                href: false,\n                content: Buffer.alloc(0),\n                contentType: element.contentType || detectedType\n            });\n        }\n\n        let parsedDataUri;\n        try {\n            parsedDataUri = parseDataURI(dataUrl);\n        } catch (_err) {\n            return element;\n        }\n\n        if (!parsedDataUri) {\n            return element;\n        }\n\n        element.content = parsedDataUri.data;\n        element.contentType = element.contentType || parsedDataUri.contentType;\n\n        if ('path' in element) {\n            element.path = false;\n        }\n\n        if ('href' in element) {\n            element.href = false;\n        }\n\n        return element;\n    }\n}\n\nmodule.exports = MailComposer;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mail-composer/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mailer/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/nodemailer/lib/mailer/index.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst EventEmitter = __webpack_require__(/*! events */ \"events\");\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\nconst mimeTypes = __webpack_require__(/*! ../mime-funcs/mime-types */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/mime-types.js\");\nconst MailComposer = __webpack_require__(/*! ../mail-composer */ \"(ssr)/./node_modules/nodemailer/lib/mail-composer/index.js\");\nconst DKIM = __webpack_require__(/*! ../dkim */ \"(ssr)/./node_modules/nodemailer/lib/dkim/index.js\");\nconst httpProxyClient = __webpack_require__(/*! ../smtp-connection/http-proxy-client */ \"(ssr)/./node_modules/nodemailer/lib/smtp-connection/http-proxy-client.js\");\nconst util = __webpack_require__(/*! util */ \"util\");\nconst urllib = __webpack_require__(/*! url */ \"url\");\nconst packageData = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst MailMessage = __webpack_require__(/*! ./mail-message */ \"(ssr)/./node_modules/nodemailer/lib/mailer/mail-message.js\");\nconst net = __webpack_require__(/*! net */ \"net\");\nconst dns = __webpack_require__(/*! dns */ \"dns\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\n\n/**\n * Creates an object for exposing the Mail API\n *\n * @constructor\n * @param {Object} transporter Transport object instance to pass the mails to\n */\nclass Mail extends EventEmitter {\n    constructor(transporter, options, defaults) {\n        super();\n\n        this.options = options || {};\n        this._defaults = defaults || {};\n\n        this._defaultPlugins = {\n            compile: [(...args) => this._convertDataImages(...args)],\n            stream: []\n        };\n\n        this._userPlugins = {\n            compile: [],\n            stream: []\n        };\n\n        this.meta = new Map();\n\n        this.dkim = this.options.dkim ? new DKIM(this.options.dkim) : false;\n\n        this.transporter = transporter;\n        this.transporter.mailer = this;\n\n        this.logger = shared.getLogger(this.options, {\n            component: this.options.component || 'mail'\n        });\n\n        this.logger.debug(\n            {\n                tnx: 'create'\n            },\n            'Creating transport: %s',\n            this.getVersionString()\n        );\n\n        // setup emit handlers for the transporter\n        if (typeof this.transporter.on === 'function') {\n            // deprecated log interface\n            this.transporter.on('log', log => {\n                this.logger.debug(\n                    {\n                        tnx: 'transport'\n                    },\n                    '%s: %s',\n                    log.type,\n                    log.message\n                );\n            });\n\n            // transporter errors\n            this.transporter.on('error', err => {\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'transport'\n                    },\n                    'Transport Error: %s',\n                    err.message\n                );\n                this.emit('error', err);\n            });\n\n            // indicates if the sender has became idle\n            this.transporter.on('idle', (...args) => {\n                this.emit('idle', ...args);\n            });\n\n            // indicates if the sender has became idle and all connections are terminated\n            this.transporter.on('clear', (...args) => {\n                this.emit('clear', ...args);\n            });\n        }\n\n        /**\n         * Optional methods passed to the underlying transport object\n         */\n        ['close', 'isIdle', 'verify'].forEach(method => {\n            this[method] = (...args) => {\n                if (typeof this.transporter[method] === 'function') {\n                    if (method === 'verify' && typeof this.getSocket === 'function') {\n                        this.transporter.getSocket = this.getSocket;\n                        this.getSocket = false;\n                    }\n                    return this.transporter[method](...args);\n                } else {\n                    this.logger.warn(\n                        {\n                            tnx: 'transport',\n                            methodName: method\n                        },\n                        'Non existing method %s called for transport',\n                        method\n                    );\n                    return false;\n                }\n            };\n        });\n\n        // setup proxy handling\n        if (this.options.proxy && typeof this.options.proxy === 'string') {\n            this.setupProxy(this.options.proxy);\n        }\n    }\n\n    use(step, plugin) {\n        step = (step || '').toString();\n        if (!this._userPlugins.hasOwnProperty(step)) {\n            this._userPlugins[step] = [plugin];\n        } else {\n            this._userPlugins[step].push(plugin);\n        }\n\n        return this;\n    }\n\n    /**\n     * Sends an email using the preselected transport object\n     *\n     * @param {Object} data E-data description\n     * @param {Function?} callback Callback to run once the sending succeeded or failed\n     */\n    sendMail(data, callback = null) {\n        let promise;\n\n        if (!callback) {\n            promise = new Promise((resolve, reject) => {\n                callback = shared.callbackPromise(resolve, reject);\n            });\n        }\n\n        if (typeof this.getSocket === 'function') {\n            this.transporter.getSocket = this.getSocket;\n            this.getSocket = false;\n        }\n\n        let mail = new MailMessage(this, data);\n\n        this.logger.debug(\n            {\n                tnx: 'transport',\n                name: this.transporter.name,\n                version: this.transporter.version,\n                action: 'send'\n            },\n            'Sending mail using %s/%s',\n            this.transporter.name,\n            this.transporter.version\n        );\n\n        this._processPlugins('compile', mail, err => {\n            if (err) {\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'plugin',\n                        action: 'compile'\n                    },\n                    'PluginCompile Error: %s',\n                    err.message\n                );\n                return callback(err);\n            }\n\n            mail.message = new MailComposer(mail.data).compile();\n\n            mail.setMailerHeader();\n            mail.setPriorityHeaders();\n            mail.setListHeaders();\n\n            this._processPlugins('stream', mail, err => {\n                if (err) {\n                    this.logger.error(\n                        {\n                            err,\n                            tnx: 'plugin',\n                            action: 'stream'\n                        },\n                        'PluginStream Error: %s',\n                        err.message\n                    );\n                    return callback(err);\n                }\n\n                if (mail.data.dkim || this.dkim) {\n                    mail.message.processFunc(input => {\n                        let dkim = mail.data.dkim ? new DKIM(mail.data.dkim) : this.dkim;\n                        this.logger.debug(\n                            {\n                                tnx: 'DKIM',\n                                messageId: mail.message.messageId(),\n                                dkimDomains: dkim.keys.map(key => key.keySelector + '.' + key.domainName).join(', ')\n                            },\n                            'Signing outgoing message with %s keys',\n                            dkim.keys.length\n                        );\n                        return dkim.sign(input, mail.data._dkim);\n                    });\n                }\n\n                this.transporter.send(mail, (...args) => {\n                    if (args[0]) {\n                        this.logger.error(\n                            {\n                                err: args[0],\n                                tnx: 'transport',\n                                action: 'send'\n                            },\n                            'Send Error: %s',\n                            args[0].message\n                        );\n                    }\n                    callback(...args);\n                });\n            });\n        });\n\n        return promise;\n    }\n\n    getVersionString() {\n        return util.format(\n            '%s (%s; +%s; %s/%s)',\n            packageData.name,\n            packageData.version,\n            packageData.homepage,\n            this.transporter.name,\n            this.transporter.version\n        );\n    }\n\n    _processPlugins(step, mail, callback) {\n        step = (step || '').toString();\n\n        if (!this._userPlugins.hasOwnProperty(step)) {\n            return callback();\n        }\n\n        let userPlugins = this._userPlugins[step] || [];\n        let defaultPlugins = this._defaultPlugins[step] || [];\n\n        if (userPlugins.length) {\n            this.logger.debug(\n                {\n                    tnx: 'transaction',\n                    pluginCount: userPlugins.length,\n                    step\n                },\n                'Using %s plugins for %s',\n                userPlugins.length,\n                step\n            );\n        }\n\n        if (userPlugins.length + defaultPlugins.length === 0) {\n            return callback();\n        }\n\n        let pos = 0;\n        let block = 'default';\n        let processPlugins = () => {\n            let curplugins = block === 'default' ? defaultPlugins : userPlugins;\n            if (pos >= curplugins.length) {\n                if (block === 'default' && userPlugins.length) {\n                    block = 'user';\n                    pos = 0;\n                    curplugins = userPlugins;\n                } else {\n                    return callback();\n                }\n            }\n            let plugin = curplugins[pos++];\n            plugin(mail, err => {\n                if (err) {\n                    return callback(err);\n                }\n                processPlugins();\n            });\n        };\n\n        processPlugins();\n    }\n\n    /**\n     * Sets up proxy handler for a Nodemailer object\n     *\n     * @param {String} proxyUrl Proxy configuration url\n     */\n    setupProxy(proxyUrl) {\n        let proxy = urllib.parse(proxyUrl);\n\n        // setup socket handler for the mailer object\n        this.getSocket = (options, callback) => {\n            let protocol = proxy.protocol.replace(/:$/, '').toLowerCase();\n\n            if (this.meta.has('proxy_handler_' + protocol)) {\n                return this.meta.get('proxy_handler_' + protocol)(proxy, options, callback);\n            }\n\n            switch (protocol) {\n                // Connect using a HTTP CONNECT method\n                case 'http':\n                case 'https':\n                    httpProxyClient(proxy.href, options.port, options.host, (err, socket) => {\n                        if (err) {\n                            return callback(err);\n                        }\n                        return callback(null, {\n                            connection: socket\n                        });\n                    });\n                    return;\n                case 'socks':\n                case 'socks5':\n                case 'socks4':\n                case 'socks4a': {\n                    if (!this.meta.has('proxy_socks_module')) {\n                        return callback(new Error('Socks module not loaded'));\n                    }\n                    let connect = ipaddress => {\n                        let proxyV2 = !!this.meta.get('proxy_socks_module').SocksClient;\n                        let socksClient = proxyV2 ? this.meta.get('proxy_socks_module').SocksClient : this.meta.get('proxy_socks_module');\n                        let proxyType = Number(proxy.protocol.replace(/\\D/g, '')) || 5;\n                        let connectionOpts = {\n                            proxy: {\n                                ipaddress,\n                                port: Number(proxy.port),\n                                type: proxyType\n                            },\n                            [proxyV2 ? 'destination' : 'target']: {\n                                host: options.host,\n                                port: options.port\n                            },\n                            command: 'connect'\n                        };\n\n                        if (proxy.auth) {\n                            let username = decodeURIComponent(proxy.auth.split(':').shift());\n                            let password = decodeURIComponent(proxy.auth.split(':').pop());\n                            if (proxyV2) {\n                                connectionOpts.proxy.userId = username;\n                                connectionOpts.proxy.password = password;\n                            } else if (proxyType === 4) {\n                                connectionOpts.userid = username;\n                            } else {\n                                connectionOpts.authentication = {\n                                    username,\n                                    password\n                                };\n                            }\n                        }\n\n                        socksClient.createConnection(connectionOpts, (err, info) => {\n                            if (err) {\n                                return callback(err);\n                            }\n                            return callback(null, {\n                                connection: info.socket || info\n                            });\n                        });\n                    };\n\n                    if (net.isIP(proxy.hostname)) {\n                        return connect(proxy.hostname);\n                    }\n\n                    return dns.resolve(proxy.hostname, (err, address) => {\n                        if (err) {\n                            return callback(err);\n                        }\n                        connect(Array.isArray(address) ? address[0] : address);\n                    });\n                }\n            }\n            callback(new Error('Unknown proxy configuration'));\n        };\n    }\n\n    _convertDataImages(mail, callback) {\n        if ((!this.options.attachDataUrls && !mail.data.attachDataUrls) || !mail.data.html) {\n            return callback();\n        }\n        mail.resolveContent(mail.data, 'html', (err, html) => {\n            if (err) {\n                return callback(err);\n            }\n            let cidCounter = 0;\n            html = (html || '')\n                .toString()\n                .replace(/(<img\\b[^<>]{0,1024} src\\s{0,20}=[\\s\"']{0,20})(data:([^;]+);[^\"'>\\s]+)/gi, (match, prefix, dataUri, mimeType) => {\n                    let cid = crypto.randomBytes(10).toString('hex') + '@localhost';\n                    if (!mail.data.attachments) {\n                        mail.data.attachments = [];\n                    }\n                    if (!Array.isArray(mail.data.attachments)) {\n                        mail.data.attachments = [].concat(mail.data.attachments || []);\n                    }\n                    mail.data.attachments.push({\n                        path: dataUri,\n                        cid,\n                        filename: 'image-' + ++cidCounter + '.' + mimeTypes.detectExtension(mimeType)\n                    });\n                    return prefix + 'cid:' + cid;\n                });\n            mail.data.html = html;\n            callback();\n        });\n    }\n\n    set(key, value) {\n        return this.meta.set(key, value);\n    }\n\n    get(key) {\n        return this.meta.get(key);\n    }\n}\n\nmodule.exports = Mail;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mailer/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mailer/mail-message.js":
/*!************************************************************!*\
  !*** ./node_modules/nodemailer/lib/mailer/mail-message.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\nconst MimeNode = __webpack_require__(/*! ../mime-node */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/index.js\");\nconst mimeFuncs = __webpack_require__(/*! ../mime-funcs */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js\");\n\nclass MailMessage {\n    constructor(mailer, data) {\n        this.mailer = mailer;\n        this.data = {};\n        this.message = null;\n\n        data = data || {};\n        let options = mailer.options || {};\n        let defaults = mailer._defaults || {};\n\n        Object.keys(data).forEach(key => {\n            this.data[key] = data[key];\n        });\n\n        this.data.headers = this.data.headers || {};\n\n        // apply defaults\n        Object.keys(defaults).forEach(key => {\n            if (!(key in this.data)) {\n                this.data[key] = defaults[key];\n            } else if (key === 'headers') {\n                // headers is a special case. Allow setting individual default headers\n                Object.keys(defaults.headers).forEach(key => {\n                    if (!(key in this.data.headers)) {\n                        this.data.headers[key] = defaults.headers[key];\n                    }\n                });\n            }\n        });\n\n        // force specific keys from transporter options\n        ['disableFileAccess', 'disableUrlAccess', 'normalizeHeaderKey'].forEach(key => {\n            if (key in options) {\n                this.data[key] = options[key];\n            }\n        });\n    }\n\n    resolveContent(...args) {\n        return shared.resolveContent(...args);\n    }\n\n    resolveAll(callback) {\n        let keys = [\n            [this.data, 'html'],\n            [this.data, 'text'],\n            [this.data, 'watchHtml'],\n            [this.data, 'amp'],\n            [this.data, 'icalEvent']\n        ];\n\n        if (this.data.alternatives && this.data.alternatives.length) {\n            this.data.alternatives.forEach((alternative, i) => {\n                keys.push([this.data.alternatives, i]);\n            });\n        }\n\n        if (this.data.attachments && this.data.attachments.length) {\n            this.data.attachments.forEach((attachment, i) => {\n                if (!attachment.filename) {\n                    attachment.filename =\n                        (attachment.path || attachment.href || '').split('/').pop().split('?').shift() || 'attachment-' + (i + 1);\n                    if (attachment.filename.indexOf('.') < 0) {\n                        attachment.filename += '.' + mimeFuncs.detectExtension(attachment.contentType);\n                    }\n                }\n\n                if (!attachment.contentType) {\n                    attachment.contentType = mimeFuncs.detectMimeType(attachment.filename || attachment.path || attachment.href || 'bin');\n                }\n\n                keys.push([this.data.attachments, i]);\n            });\n        }\n\n        let mimeNode = new MimeNode();\n\n        let addressKeys = ['from', 'to', 'cc', 'bcc', 'sender', 'replyTo'];\n\n        addressKeys.forEach(address => {\n            let value;\n            if (this.message) {\n                value = [].concat(mimeNode._parseAddresses(this.message.getHeader(address === 'replyTo' ? 'reply-to' : address)) || []);\n            } else if (this.data[address]) {\n                value = [].concat(mimeNode._parseAddresses(this.data[address]) || []);\n            }\n            if (value && value.length) {\n                this.data[address] = value;\n            } else if (address in this.data) {\n                this.data[address] = null;\n            }\n        });\n\n        let singleKeys = ['from', 'sender'];\n        singleKeys.forEach(address => {\n            if (this.data[address]) {\n                this.data[address] = this.data[address].shift();\n            }\n        });\n\n        let pos = 0;\n        let resolveNext = () => {\n            if (pos >= keys.length) {\n                return callback(null, this.data);\n            }\n            let args = keys[pos++];\n            if (!args[0] || !args[0][args[1]]) {\n                return resolveNext();\n            }\n            shared.resolveContent(...args, (err, value) => {\n                if (err) {\n                    return callback(err);\n                }\n\n                let node = {\n                    content: value\n                };\n                if (args[0][args[1]] && typeof args[0][args[1]] === 'object' && !Buffer.isBuffer(args[0][args[1]])) {\n                    Object.keys(args[0][args[1]]).forEach(key => {\n                        if (!(key in node) && !['content', 'path', 'href', 'raw'].includes(key)) {\n                            node[key] = args[0][args[1]][key];\n                        }\n                    });\n                }\n\n                args[0][args[1]] = node;\n                resolveNext();\n            });\n        };\n\n        setImmediate(() => resolveNext());\n    }\n\n    normalize(callback) {\n        let envelope = this.data.envelope || this.message.getEnvelope();\n        let messageId = this.message.messageId();\n\n        this.resolveAll((err, data) => {\n            if (err) {\n                return callback(err);\n            }\n\n            data.envelope = envelope;\n            data.messageId = messageId;\n\n            ['html', 'text', 'watchHtml', 'amp'].forEach(key => {\n                if (data[key] && data[key].content) {\n                    if (typeof data[key].content === 'string') {\n                        data[key] = data[key].content;\n                    } else if (Buffer.isBuffer(data[key].content)) {\n                        data[key] = data[key].content.toString();\n                    }\n                }\n            });\n\n            if (data.icalEvent && Buffer.isBuffer(data.icalEvent.content)) {\n                data.icalEvent.content = data.icalEvent.content.toString('base64');\n                data.icalEvent.encoding = 'base64';\n            }\n\n            if (data.alternatives && data.alternatives.length) {\n                data.alternatives.forEach(alternative => {\n                    if (alternative && alternative.content && Buffer.isBuffer(alternative.content)) {\n                        alternative.content = alternative.content.toString('base64');\n                        alternative.encoding = 'base64';\n                    }\n                });\n            }\n\n            if (data.attachments && data.attachments.length) {\n                data.attachments.forEach(attachment => {\n                    if (attachment && attachment.content && Buffer.isBuffer(attachment.content)) {\n                        attachment.content = attachment.content.toString('base64');\n                        attachment.encoding = 'base64';\n                    }\n                });\n            }\n\n            data.normalizedHeaders = {};\n            Object.keys(data.headers || {}).forEach(key => {\n                let value = [].concat(data.headers[key] || []).shift();\n                value = (value && value.value) || value;\n                if (value) {\n                    if (['references', 'in-reply-to', 'message-id', 'content-id'].includes(key)) {\n                        value = this.message._encodeHeaderValue(key, value);\n                    }\n                    data.normalizedHeaders[key] = value;\n                }\n            });\n\n            if (data.list && typeof data.list === 'object') {\n                let listHeaders = this._getListHeaders(data.list);\n                listHeaders.forEach(entry => {\n                    data.normalizedHeaders[entry.key] = entry.value.map(val => (val && val.value) || val).join(', ');\n                });\n            }\n\n            if (data.references) {\n                data.normalizedHeaders.references = this.message._encodeHeaderValue('references', data.references);\n            }\n\n            if (data.inReplyTo) {\n                data.normalizedHeaders['in-reply-to'] = this.message._encodeHeaderValue('in-reply-to', data.inReplyTo);\n            }\n\n            return callback(null, data);\n        });\n    }\n\n    setMailerHeader() {\n        if (!this.message || !this.data.xMailer) {\n            return;\n        }\n        this.message.setHeader('X-Mailer', this.data.xMailer);\n    }\n\n    setPriorityHeaders() {\n        if (!this.message || !this.data.priority) {\n            return;\n        }\n        switch ((this.data.priority || '').toString().toLowerCase()) {\n            case 'high':\n                this.message.setHeader('X-Priority', '1 (Highest)');\n                this.message.setHeader('X-MSMail-Priority', 'High');\n                this.message.setHeader('Importance', 'High');\n                break;\n            case 'low':\n                this.message.setHeader('X-Priority', '5 (Lowest)');\n                this.message.setHeader('X-MSMail-Priority', 'Low');\n                this.message.setHeader('Importance', 'Low');\n                break;\n            default:\n            // do not add anything, since all messages are 'Normal' by default\n        }\n    }\n\n    setListHeaders() {\n        if (!this.message || !this.data.list || typeof this.data.list !== 'object') {\n            return;\n        }\n        // add optional List-* headers\n        if (this.data.list && typeof this.data.list === 'object') {\n            this._getListHeaders(this.data.list).forEach(listHeader => {\n                listHeader.value.forEach(value => {\n                    this.message.addHeader(listHeader.key, value);\n                });\n            });\n        }\n    }\n\n    _getListHeaders(listData) {\n        // make sure an url looks like <protocol:url>\n        return Object.keys(listData).map(key => ({\n            key: 'list-' + key.toLowerCase().trim(),\n            value: [].concat(listData[key] || []).map(value => ({\n                prepared: true,\n                foldLines: true,\n                value: []\n                    .concat(value || [])\n                    .map(value => {\n                        if (typeof value === 'string') {\n                            value = {\n                                url: value\n                            };\n                        }\n\n                        if (value && value.url) {\n                            if (key.toLowerCase().trim() === 'id') {\n                                // List-ID: \"comment\" <domain>\n                                let comment = value.comment || '';\n                                if (mimeFuncs.isPlainText(comment)) {\n                                    comment = '\"' + comment + '\"';\n                                } else {\n                                    comment = mimeFuncs.encodeWord(comment);\n                                }\n\n                                return (value.comment ? comment + ' ' : '') + this._formatListUrl(value.url).replace(/^<[^:]+\\/{,2}/, '');\n                            }\n\n                            // List-*: <http://domain> (comment)\n                            let comment = value.comment || '';\n                            if (!mimeFuncs.isPlainText(comment)) {\n                                comment = mimeFuncs.encodeWord(comment);\n                            }\n\n                            return this._formatListUrl(value.url) + (value.comment ? ' (' + comment + ')' : '');\n                        }\n\n                        return '';\n                    })\n                    .filter(value => value)\n                    .join(', ')\n            }))\n        }));\n    }\n\n    _formatListUrl(url) {\n        url = url.replace(/[\\s<]+|[\\s>]+/g, '');\n        if (/^(https?|mailto|ftp):/.test(url)) {\n            return '<' + url + '>';\n        }\n        if (/^[^@]+@[^@]+$/.test(url)) {\n            return '<mailto:' + url + '>';\n        }\n\n        return '<http://' + url + '>';\n    }\n}\n\nmodule.exports = MailMessage;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mailer/mail-message.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-funcs/index.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("/* eslint no-control-regex:0 */\n\n\n\nconst base64 = __webpack_require__(/*! ../base64 */ \"(ssr)/./node_modules/nodemailer/lib/base64/index.js\");\nconst qp = __webpack_require__(/*! ../qp */ \"(ssr)/./node_modules/nodemailer/lib/qp/index.js\");\nconst mimeTypes = __webpack_require__(/*! ./mime-types */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/mime-types.js\");\n\nmodule.exports = {\n    /**\n     * Checks if a value is plaintext string (uses only printable 7bit chars)\n     *\n     * @param {String} value String to be tested\n     * @returns {Boolean} true if it is a plaintext string\n     */\n    isPlainText(value, isParam) {\n        const re = isParam ? /[\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f\"\\u0080-\\uFFFF]/ : /[\\x00-\\x08\\x0b\\x0c\\x0e-\\x1f\\u0080-\\uFFFF]/;\n        if (typeof value !== 'string' || re.test(value)) {\n            return false;\n        } else {\n            return true;\n        }\n    },\n\n    /**\n     * Checks if a multi line string containes lines longer than the selected value.\n     *\n     * Useful when detecting if a mail message needs any processing at all –\n     * if only plaintext characters are used and lines are short, then there is\n     * no need to encode the values in any way. If the value is plaintext but has\n     * longer lines then allowed, then use format=flowed\n     *\n     * @param {Number} lineLength Max line length to check for\n     * @returns {Boolean} Returns true if there is at least one line longer than lineLength chars\n     */\n    hasLongerLines(str, lineLength) {\n        if (str.length > 128 * 1024) {\n            // do not test strings longer than 128kB\n            return true;\n        }\n        return new RegExp('^.{' + (lineLength + 1) + ',}', 'm').test(str);\n    },\n\n    /**\n     * Encodes a string or an Buffer to an UTF-8 MIME Word (rfc2047)\n     *\n     * @param {String|Buffer} data String to be encoded\n     * @param {String} mimeWordEncoding='Q' Encoding for the mime word, either Q or B\n     * @param {Number} [maxLength=0] If set, split mime words into several chunks if needed\n     * @return {String} Single or several mime words joined together\n     */\n    encodeWord(data, mimeWordEncoding, maxLength) {\n        mimeWordEncoding = (mimeWordEncoding || 'Q').toString().toUpperCase().trim().charAt(0);\n        maxLength = maxLength || 0;\n\n        let encodedStr;\n        let toCharset = 'UTF-8';\n\n        if (maxLength && maxLength > 7 + toCharset.length) {\n            maxLength -= 7 + toCharset.length;\n        }\n\n        if (mimeWordEncoding === 'Q') {\n            // https://tools.ietf.org/html/rfc2047#section-5 rule (3)\n            encodedStr = qp.encode(data).replace(/[^a-z0-9!*+\\-/=]/gi, chr => {\n                let ord = chr.charCodeAt(0).toString(16).toUpperCase();\n                if (chr === ' ') {\n                    return '_';\n                } else {\n                    return '=' + (ord.length === 1 ? '0' + ord : ord);\n                }\n            });\n        } else if (mimeWordEncoding === 'B') {\n            encodedStr = typeof data === 'string' ? data : base64.encode(data);\n            maxLength = maxLength ? Math.max(3, ((maxLength - (maxLength % 4)) / 4) * 3) : 0;\n        }\n\n        if (maxLength && (mimeWordEncoding !== 'B' ? encodedStr : base64.encode(data)).length > maxLength) {\n            if (mimeWordEncoding === 'Q') {\n                encodedStr = this.splitMimeEncodedString(encodedStr, maxLength).join('?= =?' + toCharset + '?' + mimeWordEncoding + '?');\n            } else {\n                // RFC2047 6.3 (2) states that encoded-word must include an integral number of characters, so no chopping unicode sequences\n                let parts = [];\n                let lpart = '';\n                for (let i = 0, len = encodedStr.length; i < len; i++) {\n                    let chr = encodedStr.charAt(i);\n\n                    if (/[\\ud83c\\ud83d\\ud83e]/.test(chr) && i < len - 1) {\n                        // composite emoji byte, so add the next byte as well\n                        chr += encodedStr.charAt(++i);\n                    }\n\n                    // check if we can add this character to the existing string\n                    // without breaking byte length limit\n                    if (Buffer.byteLength(lpart + chr) <= maxLength || i === 0) {\n                        lpart += chr;\n                    } else {\n                        // we hit the length limit, so push the existing string and start over\n                        parts.push(base64.encode(lpart));\n                        lpart = chr;\n                    }\n                }\n                if (lpart) {\n                    parts.push(base64.encode(lpart));\n                }\n\n                if (parts.length > 1) {\n                    encodedStr = parts.join('?= =?' + toCharset + '?' + mimeWordEncoding + '?');\n                } else {\n                    encodedStr = parts.join('');\n                }\n            }\n        } else if (mimeWordEncoding === 'B') {\n            encodedStr = base64.encode(data);\n        }\n\n        return '=?' + toCharset + '?' + mimeWordEncoding + '?' + encodedStr + (encodedStr.substr(-2) === '?=' ? '' : '?=');\n    },\n\n    /**\n     * Finds word sequences with non ascii text and converts these to mime words\n     *\n     * @param {String} value String to be encoded\n     * @param {String} mimeWordEncoding='Q' Encoding for the mime word, either Q or B\n     * @param {Number} [maxLength=0] If set, split mime words into several chunks if needed\n     * @param {Boolean} [encodeAll=false] If true and the value needs encoding then encodes entire string, not just the smallest match\n     * @return {String} String with possible mime words\n     */\n    encodeWords(value, mimeWordEncoding, maxLength, encodeAll) {\n        maxLength = maxLength || 0;\n\n        let encodedValue;\n\n        // find first word with a non-printable ascii or special symbol in it\n        let firstMatch = value.match(/(?:^|\\s)([^\\s]*[\"\\u0080-\\uFFFF])/);\n        if (!firstMatch) {\n            return value;\n        }\n\n        if (encodeAll) {\n            // if it is requested to encode everything or the string contains something that resebles encoded word, then encode everything\n\n            return this.encodeWord(value, mimeWordEncoding, maxLength);\n        }\n\n        // find the last word with a non-printable ascii in it\n        let lastMatch = value.match(/([\"\\u0080-\\uFFFF][^\\s]*)[^\"\\u0080-\\uFFFF]*$/);\n        if (!lastMatch) {\n            // should not happen\n            return value;\n        }\n\n        let startIndex =\n            firstMatch.index +\n            (\n                firstMatch[0].match(/[^\\s]/) || {\n                    index: 0\n                }\n            ).index;\n        let endIndex = lastMatch.index + (lastMatch[1] || '').length;\n\n        encodedValue =\n            (startIndex ? value.substr(0, startIndex) : '') +\n            this.encodeWord(value.substring(startIndex, endIndex), mimeWordEncoding || 'Q', maxLength) +\n            (endIndex < value.length ? value.substr(endIndex) : '');\n\n        return encodedValue;\n    },\n\n    /**\n     * Joins parsed header value together as 'value; param1=value1; param2=value2'\n     * PS: We are following RFC 822 for the list of special characters that we need to keep in quotes.\n     *      Refer: https://www.w3.org/Protocols/rfc1341/4_Content-Type.html\n     * @param {Object} structured Parsed header value\n     * @return {String} joined header value\n     */\n    buildHeaderValue(structured) {\n        let paramsArray = [];\n\n        Object.keys(structured.params || {}).forEach(param => {\n            // filename might include unicode characters so it is a special case\n            // other values probably do not\n            let value = structured.params[param];\n            if (!this.isPlainText(value, true) || value.length >= 75) {\n                this.buildHeaderParam(param, value, 50).forEach(encodedParam => {\n                    if (!/[\\s\"\\\\;:/=(),<>@[\\]?]|^[-']|'$/.test(encodedParam.value) || encodedParam.key.substr(-1) === '*') {\n                        paramsArray.push(encodedParam.key + '=' + encodedParam.value);\n                    } else {\n                        paramsArray.push(encodedParam.key + '=' + JSON.stringify(encodedParam.value));\n                    }\n                });\n            } else if (/[\\s'\"\\\\;:/=(),<>@[\\]?]|^-/.test(value)) {\n                paramsArray.push(param + '=' + JSON.stringify(value));\n            } else {\n                paramsArray.push(param + '=' + value);\n            }\n        });\n\n        return structured.value + (paramsArray.length ? '; ' + paramsArray.join('; ') : '');\n    },\n\n    /**\n     * Encodes a string or an Buffer to an UTF-8 Parameter Value Continuation encoding (rfc2231)\n     * Useful for splitting long parameter values.\n     *\n     * For example\n     *      title=\"unicode string\"\n     * becomes\n     *     title*0*=utf-8''unicode\n     *     title*1*=%20string\n     *\n     * @param {String|Buffer} data String to be encoded\n     * @param {Number} [maxLength=50] Max length for generated chunks\n     * @param {String} [fromCharset='UTF-8'] Source sharacter set\n     * @return {Array} A list of encoded keys and headers\n     */\n    buildHeaderParam(key, data, maxLength) {\n        let list = [];\n        let encodedStr = typeof data === 'string' ? data : (data || '').toString();\n        let encodedStrArr;\n        let chr, ord;\n        let line;\n        let startPos = 0;\n        let i, len;\n\n        maxLength = maxLength || 50;\n\n        // process ascii only text\n        if (this.isPlainText(data, true)) {\n            // check if conversion is even needed\n            if (encodedStr.length <= maxLength) {\n                return [\n                    {\n                        key,\n                        value: encodedStr\n                    }\n                ];\n            }\n\n            encodedStr = encodedStr.replace(new RegExp('.{' + maxLength + '}', 'g'), str => {\n                list.push({\n                    line: str\n                });\n                return '';\n            });\n\n            if (encodedStr) {\n                list.push({\n                    line: encodedStr\n                });\n            }\n        } else {\n            if (/[\\uD800-\\uDBFF]/.test(encodedStr)) {\n                // string containts surrogate pairs, so normalize it to an array of bytes\n                encodedStrArr = [];\n                for (i = 0, len = encodedStr.length; i < len; i++) {\n                    chr = encodedStr.charAt(i);\n                    ord = chr.charCodeAt(0);\n                    if (ord >= 0xd800 && ord <= 0xdbff && i < len - 1) {\n                        chr += encodedStr.charAt(i + 1);\n                        encodedStrArr.push(chr);\n                        i++;\n                    } else {\n                        encodedStrArr.push(chr);\n                    }\n                }\n                encodedStr = encodedStrArr;\n            }\n\n            // first line includes the charset and language info and needs to be encoded\n            // even if it does not contain any unicode characters\n            line = \"utf-8''\";\n            let encoded = true;\n            startPos = 0;\n\n            // process text with unicode or special chars\n            for (i = 0, len = encodedStr.length; i < len; i++) {\n                chr = encodedStr[i];\n\n                if (encoded) {\n                    chr = this.safeEncodeURIComponent(chr);\n                } else {\n                    // try to urlencode current char\n                    chr = chr === ' ' ? chr : this.safeEncodeURIComponent(chr);\n                    // By default it is not required to encode a line, the need\n                    // only appears when the string contains unicode or special chars\n                    // in this case we start processing the line over and encode all chars\n                    if (chr !== encodedStr[i]) {\n                        // Check if it is even possible to add the encoded char to the line\n                        // If not, there is no reason to use this line, just push it to the list\n                        // and start a new line with the char that needs encoding\n                        if ((this.safeEncodeURIComponent(line) + chr).length >= maxLength) {\n                            list.push({\n                                line,\n                                encoded\n                            });\n                            line = '';\n                            startPos = i - 1;\n                        } else {\n                            encoded = true;\n                            i = startPos;\n                            line = '';\n                            continue;\n                        }\n                    }\n                }\n\n                // if the line is already too long, push it to the list and start a new one\n                if ((line + chr).length >= maxLength) {\n                    list.push({\n                        line,\n                        encoded\n                    });\n                    line = chr = encodedStr[i] === ' ' ? ' ' : this.safeEncodeURIComponent(encodedStr[i]);\n                    if (chr === encodedStr[i]) {\n                        encoded = false;\n                        startPos = i - 1;\n                    } else {\n                        encoded = true;\n                    }\n                } else {\n                    line += chr;\n                }\n            }\n\n            if (line) {\n                list.push({\n                    line,\n                    encoded\n                });\n            }\n        }\n\n        return list.map((item, i) => ({\n            // encoded lines: {name}*{part}*\n            // unencoded lines: {name}*{part}\n            // if any line needs to be encoded then the first line (part==0) is always encoded\n            key: key + '*' + i + (item.encoded ? '*' : ''),\n            value: item.line\n        }));\n    },\n\n    /**\n     * Parses a header value with key=value arguments into a structured\n     * object.\n     *\n     *   parseHeaderValue('content-type: text/plain; CHARSET='UTF-8'') ->\n     *   {\n     *     'value': 'text/plain',\n     *     'params': {\n     *       'charset': 'UTF-8'\n     *     }\n     *   }\n     *\n     * @param {String} str Header value\n     * @return {Object} Header value as a parsed structure\n     */\n    parseHeaderValue(str) {\n        let response = {\n            value: false,\n            params: {}\n        };\n        let key = false;\n        let value = '';\n        let type = 'value';\n        let quote = false;\n        let escaped = false;\n        let chr;\n\n        for (let i = 0, len = str.length; i < len; i++) {\n            chr = str.charAt(i);\n            if (type === 'key') {\n                if (chr === '=') {\n                    key = value.trim().toLowerCase();\n                    type = 'value';\n                    value = '';\n                    continue;\n                }\n                value += chr;\n            } else {\n                if (escaped) {\n                    value += chr;\n                } else if (chr === '\\\\') {\n                    escaped = true;\n                    continue;\n                } else if (quote && chr === quote) {\n                    quote = false;\n                } else if (!quote && chr === '\"') {\n                    quote = chr;\n                } else if (!quote && chr === ';') {\n                    if (key === false) {\n                        response.value = value.trim();\n                    } else {\n                        response.params[key] = value.trim();\n                    }\n                    type = 'key';\n                    value = '';\n                } else {\n                    value += chr;\n                }\n                escaped = false;\n            }\n        }\n\n        if (type === 'value') {\n            if (key === false) {\n                response.value = value.trim();\n            } else {\n                response.params[key] = value.trim();\n            }\n        } else if (value.trim()) {\n            response.params[value.trim().toLowerCase()] = '';\n        }\n\n        // handle parameter value continuations\n        // https://tools.ietf.org/html/rfc2231#section-3\n\n        // preprocess values\n        Object.keys(response.params).forEach(key => {\n            let actualKey, nr, match, value;\n            if ((match = key.match(/(\\*(\\d+)|\\*(\\d+)\\*|\\*)$/))) {\n                actualKey = key.substr(0, match.index);\n                nr = Number(match[2] || match[3]) || 0;\n\n                if (!response.params[actualKey] || typeof response.params[actualKey] !== 'object') {\n                    response.params[actualKey] = {\n                        charset: false,\n                        values: []\n                    };\n                }\n\n                value = response.params[key];\n\n                if (nr === 0 && match[0].substr(-1) === '*' && (match = value.match(/^([^']*)'[^']*'(.*)$/))) {\n                    response.params[actualKey].charset = match[1] || 'iso-8859-1';\n                    value = match[2];\n                }\n\n                response.params[actualKey].values[nr] = value;\n\n                // remove the old reference\n                delete response.params[key];\n            }\n        });\n\n        // concatenate split rfc2231 strings and convert encoded strings to mime encoded words\n        Object.keys(response.params).forEach(key => {\n            let value;\n            if (response.params[key] && Array.isArray(response.params[key].values)) {\n                value = response.params[key].values.map(val => val || '').join('');\n\n                if (response.params[key].charset) {\n                    // convert \"%AB\" to \"=?charset?Q?=AB?=\"\n                    response.params[key] =\n                        '=?' +\n                        response.params[key].charset +\n                        '?Q?' +\n                        value\n                            // fix invalidly encoded chars\n                            .replace(/[=?_\\s]/g, s => {\n                                let c = s.charCodeAt(0).toString(16);\n                                if (s === ' ') {\n                                    return '_';\n                                } else {\n                                    return '%' + (c.length < 2 ? '0' : '') + c;\n                                }\n                            })\n                            // change from urlencoding to percent encoding\n                            .replace(/%/g, '=') +\n                        '?=';\n                } else {\n                    response.params[key] = value;\n                }\n            }\n        });\n\n        return response;\n    },\n\n    /**\n     * Returns file extension for a content type string. If no suitable extensions\n     * are found, 'bin' is used as the default extension\n     *\n     * @param {String} mimeType Content type to be checked for\n     * @return {String} File extension\n     */\n    detectExtension: mimeType => mimeTypes.detectExtension(mimeType),\n\n    /**\n     * Returns content type for a file extension. If no suitable content types\n     * are found, 'application/octet-stream' is used as the default content type\n     *\n     * @param {String} extension Extension to be checked for\n     * @return {String} File extension\n     */\n    detectMimeType: extension => mimeTypes.detectMimeType(extension),\n\n    /**\n     * Folds long lines, useful for folding header lines (afterSpace=false) and\n     * flowed text (afterSpace=true)\n     *\n     * @param {String} str String to be folded\n     * @param {Number} [lineLength=76] Maximum length of a line\n     * @param {Boolean} afterSpace If true, leave a space in th end of a line\n     * @return {String} String with folded lines\n     */\n    foldLines(str, lineLength, afterSpace) {\n        str = (str || '').toString();\n        lineLength = lineLength || 76;\n\n        let pos = 0,\n            len = str.length,\n            result = '',\n            line,\n            match;\n\n        while (pos < len) {\n            line = str.substr(pos, lineLength);\n            if (line.length < lineLength) {\n                result += line;\n                break;\n            }\n            if ((match = line.match(/^[^\\n\\r]*(\\r?\\n|\\r)/))) {\n                line = match[0];\n                result += line;\n                pos += line.length;\n                continue;\n            } else if ((match = line.match(/(\\s+)[^\\s]*$/)) && match[0].length - (afterSpace ? (match[1] || '').length : 0) < line.length) {\n                line = line.substr(0, line.length - (match[0].length - (afterSpace ? (match[1] || '').length : 0)));\n            } else if ((match = str.substr(pos + line.length).match(/^[^\\s]+(\\s*)/))) {\n                line = line + match[0].substr(0, match[0].length - (!afterSpace ? (match[1] || '').length : 0));\n            }\n\n            result += line;\n            pos += line.length;\n            if (pos < len) {\n                result += '\\r\\n';\n            }\n        }\n\n        return result;\n    },\n\n    /**\n     * Splits a mime encoded string. Needed for dividing mime words into smaller chunks\n     *\n     * @param {String} str Mime encoded string to be split up\n     * @param {Number} maxlen Maximum length of characters for one part (minimum 12)\n     * @return {Array} Split string\n     */\n    splitMimeEncodedString: (str, maxlen) => {\n        let curLine,\n            match,\n            chr,\n            done,\n            lines = [];\n\n        // require at least 12 symbols to fit possible 4 octet UTF-8 sequences\n        maxlen = Math.max(maxlen || 0, 12);\n\n        while (str.length) {\n            curLine = str.substr(0, maxlen);\n\n            // move incomplete escaped char back to main\n            if ((match = curLine.match(/[=][0-9A-F]?$/i))) {\n                curLine = curLine.substr(0, match.index);\n            }\n\n            done = false;\n            while (!done) {\n                done = true;\n                // check if not middle of a unicode char sequence\n                if ((match = str.substr(curLine.length).match(/^[=]([0-9A-F]{2})/i))) {\n                    chr = parseInt(match[1], 16);\n                    // invalid sequence, move one char back anc recheck\n                    if (chr < 0xc2 && chr > 0x7f) {\n                        curLine = curLine.substr(0, curLine.length - 3);\n                        done = false;\n                    }\n                }\n            }\n\n            if (curLine.length) {\n                lines.push(curLine);\n            }\n            str = str.substr(curLine.length);\n        }\n\n        return lines;\n    },\n\n    encodeURICharComponent: chr => {\n        let res = '';\n        let ord = chr.charCodeAt(0).toString(16).toUpperCase();\n\n        if (ord.length % 2) {\n            ord = '0' + ord;\n        }\n\n        if (ord.length > 2) {\n            for (let i = 0, len = ord.length / 2; i < len; i++) {\n                res += '%' + ord.substr(i, 2);\n            }\n        } else {\n            res += '%' + ord;\n        }\n\n        return res;\n    },\n\n    safeEncodeURIComponent(str) {\n        str = (str || '').toString();\n\n        try {\n            // might throw if we try to encode invalid sequences, eg. partial emoji\n            str = encodeURIComponent(str);\n        } catch (_E) {\n            // should never run\n            return str.replace(/[^\\x00-\\x1F *'()<>@,;:\\\\\"[\\]?=\\u007F-\\uFFFF]+/g, '');\n        }\n\n        // ensure chars that are not handled by encodeURICompent are converted as well\n        return str.replace(/[\\x00-\\x1F *'()<>@,;:\\\\\"[\\]?=\\u007F-\\uFFFF]/g, chr => this.encodeURICharComponent(chr));\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-funcs/mime-types.js":
/*!**************************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-funcs/mime-types.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("/* eslint quote-props: 0 */\n\n\n\nconst path = __webpack_require__(/*! path */ \"path\");\n\nconst defaultMimeType = 'application/octet-stream';\nconst defaultExtension = 'bin';\n\nconst mimeTypes = new Map([\n    ['application/acad', 'dwg'],\n    ['application/applixware', 'aw'],\n    ['application/arj', 'arj'],\n    ['application/atom+xml', 'xml'],\n    ['application/atomcat+xml', 'atomcat'],\n    ['application/atomsvc+xml', 'atomsvc'],\n    ['application/base64', ['mm', 'mme']],\n    ['application/binhex', 'hqx'],\n    ['application/binhex4', 'hqx'],\n    ['application/book', ['book', 'boo']],\n    ['application/ccxml+xml,', 'ccxml'],\n    ['application/cdf', 'cdf'],\n    ['application/cdmi-capability', 'cdmia'],\n    ['application/cdmi-container', 'cdmic'],\n    ['application/cdmi-domain', 'cdmid'],\n    ['application/cdmi-object', 'cdmio'],\n    ['application/cdmi-queue', 'cdmiq'],\n    ['application/clariscad', 'ccad'],\n    ['application/commonground', 'dp'],\n    ['application/cu-seeme', 'cu'],\n    ['application/davmount+xml', 'davmount'],\n    ['application/drafting', 'drw'],\n    ['application/dsptype', 'tsp'],\n    ['application/dssc+der', 'dssc'],\n    ['application/dssc+xml', 'xdssc'],\n    ['application/dxf', 'dxf'],\n    ['application/ecmascript', ['js', 'es']],\n    ['application/emma+xml', 'emma'],\n    ['application/envoy', 'evy'],\n    ['application/epub+zip', 'epub'],\n    ['application/excel', ['xls', 'xl', 'xla', 'xlb', 'xlc', 'xld', 'xlk', 'xll', 'xlm', 'xlt', 'xlv', 'xlw']],\n    ['application/exi', 'exi'],\n    ['application/font-tdpfr', 'pfr'],\n    ['application/fractals', 'fif'],\n    ['application/freeloader', 'frl'],\n    ['application/futuresplash', 'spl'],\n    ['application/geo+json', 'geojson'],\n    ['application/gnutar', 'tgz'],\n    ['application/groupwise', 'vew'],\n    ['application/hlp', 'hlp'],\n    ['application/hta', 'hta'],\n    ['application/hyperstudio', 'stk'],\n    ['application/i-deas', 'unv'],\n    ['application/iges', ['iges', 'igs']],\n    ['application/inf', 'inf'],\n    ['application/internet-property-stream', 'acx'],\n    ['application/ipfix', 'ipfix'],\n    ['application/java', 'class'],\n    ['application/java-archive', 'jar'],\n    ['application/java-byte-code', 'class'],\n    ['application/java-serialized-object', 'ser'],\n    ['application/java-vm', 'class'],\n    ['application/javascript', 'js'],\n    ['application/json', 'json'],\n    ['application/lha', 'lha'],\n    ['application/lzx', 'lzx'],\n    ['application/mac-binary', 'bin'],\n    ['application/mac-binhex', 'hqx'],\n    ['application/mac-binhex40', 'hqx'],\n    ['application/mac-compactpro', 'cpt'],\n    ['application/macbinary', 'bin'],\n    ['application/mads+xml', 'mads'],\n    ['application/marc', 'mrc'],\n    ['application/marcxml+xml', 'mrcx'],\n    ['application/mathematica', 'ma'],\n    ['application/mathml+xml', 'mathml'],\n    ['application/mbedlet', 'mbd'],\n    ['application/mbox', 'mbox'],\n    ['application/mcad', 'mcd'],\n    ['application/mediaservercontrol+xml', 'mscml'],\n    ['application/metalink4+xml', 'meta4'],\n    ['application/mets+xml', 'mets'],\n    ['application/mime', 'aps'],\n    ['application/mods+xml', 'mods'],\n    ['application/mp21', 'm21'],\n    ['application/mp4', 'mp4'],\n    ['application/mspowerpoint', ['ppt', 'pot', 'pps', 'ppz']],\n    ['application/msword', ['doc', 'dot', 'w6w', 'wiz', 'word']],\n    ['application/mswrite', 'wri'],\n    ['application/mxf', 'mxf'],\n    ['application/netmc', 'mcp'],\n    ['application/octet-stream', ['*']],\n    ['application/oda', 'oda'],\n    ['application/oebps-package+xml', 'opf'],\n    ['application/ogg', 'ogx'],\n    ['application/olescript', 'axs'],\n    ['application/onenote', 'onetoc'],\n    ['application/patch-ops-error+xml', 'xer'],\n    ['application/pdf', 'pdf'],\n    ['application/pgp-encrypted', 'asc'],\n    ['application/pgp-signature', 'pgp'],\n    ['application/pics-rules', 'prf'],\n    ['application/pkcs-12', 'p12'],\n    ['application/pkcs-crl', 'crl'],\n    ['application/pkcs10', 'p10'],\n    ['application/pkcs7-mime', ['p7c', 'p7m']],\n    ['application/pkcs7-signature', 'p7s'],\n    ['application/pkcs8', 'p8'],\n    ['application/pkix-attr-cert', 'ac'],\n    ['application/pkix-cert', ['cer', 'crt']],\n    ['application/pkix-crl', 'crl'],\n    ['application/pkix-pkipath', 'pkipath'],\n    ['application/pkixcmp', 'pki'],\n    ['application/plain', 'text'],\n    ['application/pls+xml', 'pls'],\n    ['application/postscript', ['ps', 'ai', 'eps']],\n    ['application/powerpoint', 'ppt'],\n    ['application/pro_eng', ['part', 'prt']],\n    ['application/prs.cww', 'cww'],\n    ['application/pskc+xml', 'pskcxml'],\n    ['application/rdf+xml', 'rdf'],\n    ['application/reginfo+xml', 'rif'],\n    ['application/relax-ng-compact-syntax', 'rnc'],\n    ['application/resource-lists+xml', 'rl'],\n    ['application/resource-lists-diff+xml', 'rld'],\n    ['application/ringing-tones', 'rng'],\n    ['application/rls-services+xml', 'rs'],\n    ['application/rsd+xml', 'rsd'],\n    ['application/rss+xml', 'xml'],\n    ['application/rtf', ['rtf', 'rtx']],\n    ['application/sbml+xml', 'sbml'],\n    ['application/scvp-cv-request', 'scq'],\n    ['application/scvp-cv-response', 'scs'],\n    ['application/scvp-vp-request', 'spq'],\n    ['application/scvp-vp-response', 'spp'],\n    ['application/sdp', 'sdp'],\n    ['application/sea', 'sea'],\n    ['application/set', 'set'],\n    ['application/set-payment-initiation', 'setpay'],\n    ['application/set-registration-initiation', 'setreg'],\n    ['application/shf+xml', 'shf'],\n    ['application/sla', 'stl'],\n    ['application/smil', ['smi', 'smil']],\n    ['application/smil+xml', 'smi'],\n    ['application/solids', 'sol'],\n    ['application/sounder', 'sdr'],\n    ['application/sparql-query', 'rq'],\n    ['application/sparql-results+xml', 'srx'],\n    ['application/srgs', 'gram'],\n    ['application/srgs+xml', 'grxml'],\n    ['application/sru+xml', 'sru'],\n    ['application/ssml+xml', 'ssml'],\n    ['application/step', ['step', 'stp']],\n    ['application/streamingmedia', 'ssm'],\n    ['application/tei+xml', 'tei'],\n    ['application/thraud+xml', 'tfi'],\n    ['application/timestamped-data', 'tsd'],\n    ['application/toolbook', 'tbk'],\n    ['application/vda', 'vda'],\n    ['application/vnd.3gpp.pic-bw-large', 'plb'],\n    ['application/vnd.3gpp.pic-bw-small', 'psb'],\n    ['application/vnd.3gpp.pic-bw-var', 'pvb'],\n    ['application/vnd.3gpp2.tcap', 'tcap'],\n    ['application/vnd.3m.post-it-notes', 'pwn'],\n    ['application/vnd.accpac.simply.aso', 'aso'],\n    ['application/vnd.accpac.simply.imp', 'imp'],\n    ['application/vnd.acucobol', 'acu'],\n    ['application/vnd.acucorp', 'atc'],\n    ['application/vnd.adobe.air-application-installer-package+zip', 'air'],\n    ['application/vnd.adobe.fxp', 'fxp'],\n    ['application/vnd.adobe.xdp+xml', 'xdp'],\n    ['application/vnd.adobe.xfdf', 'xfdf'],\n    ['application/vnd.ahead.space', 'ahead'],\n    ['application/vnd.airzip.filesecure.azf', 'azf'],\n    ['application/vnd.airzip.filesecure.azs', 'azs'],\n    ['application/vnd.amazon.ebook', 'azw'],\n    ['application/vnd.americandynamics.acc', 'acc'],\n    ['application/vnd.amiga.ami', 'ami'],\n    ['application/vnd.android.package-archive', 'apk'],\n    ['application/vnd.anser-web-certificate-issue-initiation', 'cii'],\n    ['application/vnd.anser-web-funds-transfer-initiation', 'fti'],\n    ['application/vnd.antix.game-component', 'atx'],\n    ['application/vnd.apple.installer+xml', 'mpkg'],\n    ['application/vnd.apple.mpegurl', 'm3u8'],\n    ['application/vnd.aristanetworks.swi', 'swi'],\n    ['application/vnd.audiograph', 'aep'],\n    ['application/vnd.blueice.multipass', 'mpm'],\n    ['application/vnd.bmi', 'bmi'],\n    ['application/vnd.businessobjects', 'rep'],\n    ['application/vnd.chemdraw+xml', 'cdxml'],\n    ['application/vnd.chipnuts.karaoke-mmd', 'mmd'],\n    ['application/vnd.cinderella', 'cdy'],\n    ['application/vnd.claymore', 'cla'],\n    ['application/vnd.cloanto.rp9', 'rp9'],\n    ['application/vnd.clonk.c4group', 'c4g'],\n    ['application/vnd.cluetrust.cartomobile-config', 'c11amc'],\n    ['application/vnd.cluetrust.cartomobile-config-pkg', 'c11amz'],\n    ['application/vnd.commonspace', 'csp'],\n    ['application/vnd.contact.cmsg', 'cdbcmsg'],\n    ['application/vnd.cosmocaller', 'cmc'],\n    ['application/vnd.crick.clicker', 'clkx'],\n    ['application/vnd.crick.clicker.keyboard', 'clkk'],\n    ['application/vnd.crick.clicker.palette', 'clkp'],\n    ['application/vnd.crick.clicker.template', 'clkt'],\n    ['application/vnd.crick.clicker.wordbank', 'clkw'],\n    ['application/vnd.criticaltools.wbs+xml', 'wbs'],\n    ['application/vnd.ctc-posml', 'pml'],\n    ['application/vnd.cups-ppd', 'ppd'],\n    ['application/vnd.curl.car', 'car'],\n    ['application/vnd.curl.pcurl', 'pcurl'],\n    ['application/vnd.data-vision.rdz', 'rdz'],\n    ['application/vnd.denovo.fcselayout-link', 'fe_launch'],\n    ['application/vnd.dna', 'dna'],\n    ['application/vnd.dolby.mlp', 'mlp'],\n    ['application/vnd.dpgraph', 'dpg'],\n    ['application/vnd.dreamfactory', 'dfac'],\n    ['application/vnd.dvb.ait', 'ait'],\n    ['application/vnd.dvb.service', 'svc'],\n    ['application/vnd.dynageo', 'geo'],\n    ['application/vnd.ecowin.chart', 'mag'],\n    ['application/vnd.enliven', 'nml'],\n    ['application/vnd.epson.esf', 'esf'],\n    ['application/vnd.epson.msf', 'msf'],\n    ['application/vnd.epson.quickanime', 'qam'],\n    ['application/vnd.epson.salt', 'slt'],\n    ['application/vnd.epson.ssf', 'ssf'],\n    ['application/vnd.eszigno3+xml', 'es3'],\n    ['application/vnd.ezpix-album', 'ez2'],\n    ['application/vnd.ezpix-package', 'ez3'],\n    ['application/vnd.fdf', 'fdf'],\n    ['application/vnd.fdsn.seed', 'seed'],\n    ['application/vnd.flographit', 'gph'],\n    ['application/vnd.fluxtime.clip', 'ftc'],\n    ['application/vnd.framemaker', 'fm'],\n    ['application/vnd.frogans.fnc', 'fnc'],\n    ['application/vnd.frogans.ltf', 'ltf'],\n    ['application/vnd.fsc.weblaunch', 'fsc'],\n    ['application/vnd.fujitsu.oasys', 'oas'],\n    ['application/vnd.fujitsu.oasys2', 'oa2'],\n    ['application/vnd.fujitsu.oasys3', 'oa3'],\n    ['application/vnd.fujitsu.oasysgp', 'fg5'],\n    ['application/vnd.fujitsu.oasysprs', 'bh2'],\n    ['application/vnd.fujixerox.ddd', 'ddd'],\n    ['application/vnd.fujixerox.docuworks', 'xdw'],\n    ['application/vnd.fujixerox.docuworks.binder', 'xbd'],\n    ['application/vnd.fuzzysheet', 'fzs'],\n    ['application/vnd.genomatix.tuxedo', 'txd'],\n    ['application/vnd.geogebra.file', 'ggb'],\n    ['application/vnd.geogebra.tool', 'ggt'],\n    ['application/vnd.geometry-explorer', 'gex'],\n    ['application/vnd.geonext', 'gxt'],\n    ['application/vnd.geoplan', 'g2w'],\n    ['application/vnd.geospace', 'g3w'],\n    ['application/vnd.gmx', 'gmx'],\n    ['application/vnd.google-earth.kml+xml', 'kml'],\n    ['application/vnd.google-earth.kmz', 'kmz'],\n    ['application/vnd.grafeq', 'gqf'],\n    ['application/vnd.groove-account', 'gac'],\n    ['application/vnd.groove-help', 'ghf'],\n    ['application/vnd.groove-identity-message', 'gim'],\n    ['application/vnd.groove-injector', 'grv'],\n    ['application/vnd.groove-tool-message', 'gtm'],\n    ['application/vnd.groove-tool-template', 'tpl'],\n    ['application/vnd.groove-vcard', 'vcg'],\n    ['application/vnd.hal+xml', 'hal'],\n    ['application/vnd.handheld-entertainment+xml', 'zmm'],\n    ['application/vnd.hbci', 'hbci'],\n    ['application/vnd.hhe.lesson-player', 'les'],\n    ['application/vnd.hp-hpgl', ['hgl', 'hpg', 'hpgl']],\n    ['application/vnd.hp-hpid', 'hpid'],\n    ['application/vnd.hp-hps', 'hps'],\n    ['application/vnd.hp-jlyt', 'jlt'],\n    ['application/vnd.hp-pcl', 'pcl'],\n    ['application/vnd.hp-pclxl', 'pclxl'],\n    ['application/vnd.hydrostatix.sof-data', 'sfd-hdstx'],\n    ['application/vnd.hzn-3d-crossword', 'x3d'],\n    ['application/vnd.ibm.minipay', 'mpy'],\n    ['application/vnd.ibm.modcap', 'afp'],\n    ['application/vnd.ibm.rights-management', 'irm'],\n    ['application/vnd.ibm.secure-container', 'sc'],\n    ['application/vnd.iccprofile', 'icc'],\n    ['application/vnd.igloader', 'igl'],\n    ['application/vnd.immervision-ivp', 'ivp'],\n    ['application/vnd.immervision-ivu', 'ivu'],\n    ['application/vnd.insors.igm', 'igm'],\n    ['application/vnd.intercon.formnet', 'xpw'],\n    ['application/vnd.intergeo', 'i2g'],\n    ['application/vnd.intu.qbo', 'qbo'],\n    ['application/vnd.intu.qfx', 'qfx'],\n    ['application/vnd.ipunplugged.rcprofile', 'rcprofile'],\n    ['application/vnd.irepository.package+xml', 'irp'],\n    ['application/vnd.is-xpr', 'xpr'],\n    ['application/vnd.isac.fcs', 'fcs'],\n    ['application/vnd.jam', 'jam'],\n    ['application/vnd.jcp.javame.midlet-rms', 'rms'],\n    ['application/vnd.jisp', 'jisp'],\n    ['application/vnd.joost.joda-archive', 'joda'],\n    ['application/vnd.kahootz', 'ktz'],\n    ['application/vnd.kde.karbon', 'karbon'],\n    ['application/vnd.kde.kchart', 'chrt'],\n    ['application/vnd.kde.kformula', 'kfo'],\n    ['application/vnd.kde.kivio', 'flw'],\n    ['application/vnd.kde.kontour', 'kon'],\n    ['application/vnd.kde.kpresenter', 'kpr'],\n    ['application/vnd.kde.kspread', 'ksp'],\n    ['application/vnd.kde.kword', 'kwd'],\n    ['application/vnd.kenameaapp', 'htke'],\n    ['application/vnd.kidspiration', 'kia'],\n    ['application/vnd.kinar', 'kne'],\n    ['application/vnd.koan', 'skp'],\n    ['application/vnd.kodak-descriptor', 'sse'],\n    ['application/vnd.las.las+xml', 'lasxml'],\n    ['application/vnd.llamagraphics.life-balance.desktop', 'lbd'],\n    ['application/vnd.llamagraphics.life-balance.exchange+xml', 'lbe'],\n    ['application/vnd.lotus-1-2-3', '123'],\n    ['application/vnd.lotus-approach', 'apr'],\n    ['application/vnd.lotus-freelance', 'pre'],\n    ['application/vnd.lotus-notes', 'nsf'],\n    ['application/vnd.lotus-organizer', 'org'],\n    ['application/vnd.lotus-screencam', 'scm'],\n    ['application/vnd.lotus-wordpro', 'lwp'],\n    ['application/vnd.macports.portpkg', 'portpkg'],\n    ['application/vnd.mcd', 'mcd'],\n    ['application/vnd.medcalcdata', 'mc1'],\n    ['application/vnd.mediastation.cdkey', 'cdkey'],\n    ['application/vnd.mfer', 'mwf'],\n    ['application/vnd.mfmp', 'mfm'],\n    ['application/vnd.micrografx.flo', 'flo'],\n    ['application/vnd.micrografx.igx', 'igx'],\n    ['application/vnd.mif', 'mif'],\n    ['application/vnd.mobius.daf', 'daf'],\n    ['application/vnd.mobius.dis', 'dis'],\n    ['application/vnd.mobius.mbk', 'mbk'],\n    ['application/vnd.mobius.mqy', 'mqy'],\n    ['application/vnd.mobius.msl', 'msl'],\n    ['application/vnd.mobius.plc', 'plc'],\n    ['application/vnd.mobius.txf', 'txf'],\n    ['application/vnd.mophun.application', 'mpn'],\n    ['application/vnd.mophun.certificate', 'mpc'],\n    ['application/vnd.mozilla.xul+xml', 'xul'],\n    ['application/vnd.ms-artgalry', 'cil'],\n    ['application/vnd.ms-cab-compressed', 'cab'],\n    ['application/vnd.ms-excel', ['xls', 'xla', 'xlc', 'xlm', 'xlt', 'xlw', 'xlb', 'xll']],\n    ['application/vnd.ms-excel.addin.macroenabled.12', 'xlam'],\n    ['application/vnd.ms-excel.sheet.binary.macroenabled.12', 'xlsb'],\n    ['application/vnd.ms-excel.sheet.macroenabled.12', 'xlsm'],\n    ['application/vnd.ms-excel.template.macroenabled.12', 'xltm'],\n    ['application/vnd.ms-fontobject', 'eot'],\n    ['application/vnd.ms-htmlhelp', 'chm'],\n    ['application/vnd.ms-ims', 'ims'],\n    ['application/vnd.ms-lrm', 'lrm'],\n    ['application/vnd.ms-officetheme', 'thmx'],\n    ['application/vnd.ms-outlook', 'msg'],\n    ['application/vnd.ms-pki.certstore', 'sst'],\n    ['application/vnd.ms-pki.pko', 'pko'],\n    ['application/vnd.ms-pki.seccat', 'cat'],\n    ['application/vnd.ms-pki.stl', 'stl'],\n    ['application/vnd.ms-pkicertstore', 'sst'],\n    ['application/vnd.ms-pkiseccat', 'cat'],\n    ['application/vnd.ms-pkistl', 'stl'],\n    ['application/vnd.ms-powerpoint', ['ppt', 'pot', 'pps', 'ppa', 'pwz']],\n    ['application/vnd.ms-powerpoint.addin.macroenabled.12', 'ppam'],\n    ['application/vnd.ms-powerpoint.presentation.macroenabled.12', 'pptm'],\n    ['application/vnd.ms-powerpoint.slide.macroenabled.12', 'sldm'],\n    ['application/vnd.ms-powerpoint.slideshow.macroenabled.12', 'ppsm'],\n    ['application/vnd.ms-powerpoint.template.macroenabled.12', 'potm'],\n    ['application/vnd.ms-project', 'mpp'],\n    ['application/vnd.ms-word.document.macroenabled.12', 'docm'],\n    ['application/vnd.ms-word.template.macroenabled.12', 'dotm'],\n    ['application/vnd.ms-works', ['wks', 'wcm', 'wdb', 'wps']],\n    ['application/vnd.ms-wpl', 'wpl'],\n    ['application/vnd.ms-xpsdocument', 'xps'],\n    ['application/vnd.mseq', 'mseq'],\n    ['application/vnd.musician', 'mus'],\n    ['application/vnd.muvee.style', 'msty'],\n    ['application/vnd.neurolanguage.nlu', 'nlu'],\n    ['application/vnd.noblenet-directory', 'nnd'],\n    ['application/vnd.noblenet-sealer', 'nns'],\n    ['application/vnd.noblenet-web', 'nnw'],\n    ['application/vnd.nokia.configuration-message', 'ncm'],\n    ['application/vnd.nokia.n-gage.data', 'ngdat'],\n    ['application/vnd.nokia.n-gage.symbian.install', 'n-gage'],\n    ['application/vnd.nokia.radio-preset', 'rpst'],\n    ['application/vnd.nokia.radio-presets', 'rpss'],\n    ['application/vnd.nokia.ringing-tone', 'rng'],\n    ['application/vnd.novadigm.edm', 'edm'],\n    ['application/vnd.novadigm.edx', 'edx'],\n    ['application/vnd.novadigm.ext', 'ext'],\n    ['application/vnd.oasis.opendocument.chart', 'odc'],\n    ['application/vnd.oasis.opendocument.chart-template', 'otc'],\n    ['application/vnd.oasis.opendocument.database', 'odb'],\n    ['application/vnd.oasis.opendocument.formula', 'odf'],\n    ['application/vnd.oasis.opendocument.formula-template', 'odft'],\n    ['application/vnd.oasis.opendocument.graphics', 'odg'],\n    ['application/vnd.oasis.opendocument.graphics-template', 'otg'],\n    ['application/vnd.oasis.opendocument.image', 'odi'],\n    ['application/vnd.oasis.opendocument.image-template', 'oti'],\n    ['application/vnd.oasis.opendocument.presentation', 'odp'],\n    ['application/vnd.oasis.opendocument.presentation-template', 'otp'],\n    ['application/vnd.oasis.opendocument.spreadsheet', 'ods'],\n    ['application/vnd.oasis.opendocument.spreadsheet-template', 'ots'],\n    ['application/vnd.oasis.opendocument.text', 'odt'],\n    ['application/vnd.oasis.opendocument.text-master', 'odm'],\n    ['application/vnd.oasis.opendocument.text-template', 'ott'],\n    ['application/vnd.oasis.opendocument.text-web', 'oth'],\n    ['application/vnd.olpc-sugar', 'xo'],\n    ['application/vnd.oma.dd2+xml', 'dd2'],\n    ['application/vnd.openofficeorg.extension', 'oxt'],\n    ['application/vnd.openxmlformats-officedocument.presentationml.presentation', 'pptx'],\n    ['application/vnd.openxmlformats-officedocument.presentationml.slide', 'sldx'],\n    ['application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'ppsx'],\n    ['application/vnd.openxmlformats-officedocument.presentationml.template', 'potx'],\n    ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'xlsx'],\n    ['application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'xltx'],\n    ['application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'docx'],\n    ['application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'dotx'],\n    ['application/vnd.osgeo.mapguide.package', 'mgp'],\n    ['application/vnd.osgi.dp', 'dp'],\n    ['application/vnd.palm', 'pdb'],\n    ['application/vnd.pawaafile', 'paw'],\n    ['application/vnd.pg.format', 'str'],\n    ['application/vnd.pg.osasli', 'ei6'],\n    ['application/vnd.picsel', 'efif'],\n    ['application/vnd.pmi.widget', 'wg'],\n    ['application/vnd.pocketlearn', 'plf'],\n    ['application/vnd.powerbuilder6', 'pbd'],\n    ['application/vnd.previewsystems.box', 'box'],\n    ['application/vnd.proteus.magazine', 'mgz'],\n    ['application/vnd.publishare-delta-tree', 'qps'],\n    ['application/vnd.pvi.ptid1', 'ptid'],\n    ['application/vnd.quark.quarkxpress', 'qxd'],\n    ['application/vnd.realvnc.bed', 'bed'],\n    ['application/vnd.recordare.musicxml', 'mxl'],\n    ['application/vnd.recordare.musicxml+xml', 'musicxml'],\n    ['application/vnd.rig.cryptonote', 'cryptonote'],\n    ['application/vnd.rim.cod', 'cod'],\n    ['application/vnd.rn-realmedia', 'rm'],\n    ['application/vnd.rn-realplayer', 'rnx'],\n    ['application/vnd.route66.link66+xml', 'link66'],\n    ['application/vnd.sailingtracker.track', 'st'],\n    ['application/vnd.seemail', 'see'],\n    ['application/vnd.sema', 'sema'],\n    ['application/vnd.semd', 'semd'],\n    ['application/vnd.semf', 'semf'],\n    ['application/vnd.shana.informed.formdata', 'ifm'],\n    ['application/vnd.shana.informed.formtemplate', 'itp'],\n    ['application/vnd.shana.informed.interchange', 'iif'],\n    ['application/vnd.shana.informed.package', 'ipk'],\n    ['application/vnd.simtech-mindmapper', 'twd'],\n    ['application/vnd.smaf', 'mmf'],\n    ['application/vnd.smart.teacher', 'teacher'],\n    ['application/vnd.solent.sdkm+xml', 'sdkm'],\n    ['application/vnd.spotfire.dxp', 'dxp'],\n    ['application/vnd.spotfire.sfs', 'sfs'],\n    ['application/vnd.stardivision.calc', 'sdc'],\n    ['application/vnd.stardivision.draw', 'sda'],\n    ['application/vnd.stardivision.impress', 'sdd'],\n    ['application/vnd.stardivision.math', 'smf'],\n    ['application/vnd.stardivision.writer', 'sdw'],\n    ['application/vnd.stardivision.writer-global', 'sgl'],\n    ['application/vnd.stepmania.stepchart', 'sm'],\n    ['application/vnd.sun.xml.calc', 'sxc'],\n    ['application/vnd.sun.xml.calc.template', 'stc'],\n    ['application/vnd.sun.xml.draw', 'sxd'],\n    ['application/vnd.sun.xml.draw.template', 'std'],\n    ['application/vnd.sun.xml.impress', 'sxi'],\n    ['application/vnd.sun.xml.impress.template', 'sti'],\n    ['application/vnd.sun.xml.math', 'sxm'],\n    ['application/vnd.sun.xml.writer', 'sxw'],\n    ['application/vnd.sun.xml.writer.global', 'sxg'],\n    ['application/vnd.sun.xml.writer.template', 'stw'],\n    ['application/vnd.sus-calendar', 'sus'],\n    ['application/vnd.svd', 'svd'],\n    ['application/vnd.symbian.install', 'sis'],\n    ['application/vnd.syncml+xml', 'xsm'],\n    ['application/vnd.syncml.dm+wbxml', 'bdm'],\n    ['application/vnd.syncml.dm+xml', 'xdm'],\n    ['application/vnd.tao.intent-module-archive', 'tao'],\n    ['application/vnd.tmobile-livetv', 'tmo'],\n    ['application/vnd.trid.tpt', 'tpt'],\n    ['application/vnd.triscape.mxs', 'mxs'],\n    ['application/vnd.trueapp', 'tra'],\n    ['application/vnd.ufdl', 'ufd'],\n    ['application/vnd.uiq.theme', 'utz'],\n    ['application/vnd.umajin', 'umj'],\n    ['application/vnd.unity', 'unityweb'],\n    ['application/vnd.uoml+xml', 'uoml'],\n    ['application/vnd.vcx', 'vcx'],\n    ['application/vnd.visio', 'vsd'],\n    ['application/vnd.visionary', 'vis'],\n    ['application/vnd.vsf', 'vsf'],\n    ['application/vnd.wap.wbxml', 'wbxml'],\n    ['application/vnd.wap.wmlc', 'wmlc'],\n    ['application/vnd.wap.wmlscriptc', 'wmlsc'],\n    ['application/vnd.webturbo', 'wtb'],\n    ['application/vnd.wolfram.player', 'nbp'],\n    ['application/vnd.wordperfect', 'wpd'],\n    ['application/vnd.wqd', 'wqd'],\n    ['application/vnd.wt.stf', 'stf'],\n    ['application/vnd.xara', ['web', 'xar']],\n    ['application/vnd.xfdl', 'xfdl'],\n    ['application/vnd.yamaha.hv-dic', 'hvd'],\n    ['application/vnd.yamaha.hv-script', 'hvs'],\n    ['application/vnd.yamaha.hv-voice', 'hvp'],\n    ['application/vnd.yamaha.openscoreformat', 'osf'],\n    ['application/vnd.yamaha.openscoreformat.osfpvg+xml', 'osfpvg'],\n    ['application/vnd.yamaha.smaf-audio', 'saf'],\n    ['application/vnd.yamaha.smaf-phrase', 'spf'],\n    ['application/vnd.yellowriver-custom-menu', 'cmp'],\n    ['application/vnd.zul', 'zir'],\n    ['application/vnd.zzazz.deck+xml', 'zaz'],\n    ['application/vocaltec-media-desc', 'vmd'],\n    ['application/vocaltec-media-file', 'vmf'],\n    ['application/voicexml+xml', 'vxml'],\n    ['application/widget', 'wgt'],\n    ['application/winhlp', 'hlp'],\n    ['application/wordperfect', ['wp', 'wp5', 'wp6', 'wpd']],\n    ['application/wordperfect6.0', ['w60', 'wp5']],\n    ['application/wordperfect6.1', 'w61'],\n    ['application/wsdl+xml', 'wsdl'],\n    ['application/wspolicy+xml', 'wspolicy'],\n    ['application/x-123', 'wk1'],\n    ['application/x-7z-compressed', '7z'],\n    ['application/x-abiword', 'abw'],\n    ['application/x-ace-compressed', 'ace'],\n    ['application/x-aim', 'aim'],\n    ['application/x-authorware-bin', 'aab'],\n    ['application/x-authorware-map', 'aam'],\n    ['application/x-authorware-seg', 'aas'],\n    ['application/x-bcpio', 'bcpio'],\n    ['application/x-binary', 'bin'],\n    ['application/x-binhex40', 'hqx'],\n    ['application/x-bittorrent', 'torrent'],\n    ['application/x-bsh', ['bsh', 'sh', 'shar']],\n    ['application/x-bytecode.elisp', 'elc'],\n    ['application/x-bytecode.python', 'pyc'],\n    ['application/x-bzip', 'bz'],\n    ['application/x-bzip2', ['boz', 'bz2']],\n    ['application/x-cdf', 'cdf'],\n    ['application/x-cdlink', 'vcd'],\n    ['application/x-chat', ['cha', 'chat']],\n    ['application/x-chess-pgn', 'pgn'],\n    ['application/x-cmu-raster', 'ras'],\n    ['application/x-cocoa', 'cco'],\n    ['application/x-compactpro', 'cpt'],\n    ['application/x-compress', 'z'],\n    ['application/x-compressed', ['tgz', 'gz', 'z', 'zip']],\n    ['application/x-conference', 'nsc'],\n    ['application/x-cpio', 'cpio'],\n    ['application/x-cpt', 'cpt'],\n    ['application/x-csh', 'csh'],\n    ['application/x-debian-package', 'deb'],\n    ['application/x-deepv', 'deepv'],\n    ['application/x-director', ['dir', 'dcr', 'dxr']],\n    ['application/x-doom', 'wad'],\n    ['application/x-dtbncx+xml', 'ncx'],\n    ['application/x-dtbook+xml', 'dtb'],\n    ['application/x-dtbresource+xml', 'res'],\n    ['application/x-dvi', 'dvi'],\n    ['application/x-elc', 'elc'],\n    ['application/x-envoy', ['env', 'evy']],\n    ['application/x-esrehber', 'es'],\n    ['application/x-excel', ['xls', 'xla', 'xlb', 'xlc', 'xld', 'xlk', 'xll', 'xlm', 'xlt', 'xlv', 'xlw']],\n    ['application/x-font-bdf', 'bdf'],\n    ['application/x-font-ghostscript', 'gsf'],\n    ['application/x-font-linux-psf', 'psf'],\n    ['application/x-font-otf', 'otf'],\n    ['application/x-font-pcf', 'pcf'],\n    ['application/x-font-snf', 'snf'],\n    ['application/x-font-ttf', 'ttf'],\n    ['application/x-font-type1', 'pfa'],\n    ['application/x-font-woff', 'woff'],\n    ['application/x-frame', 'mif'],\n    ['application/x-freelance', 'pre'],\n    ['application/x-futuresplash', 'spl'],\n    ['application/x-gnumeric', 'gnumeric'],\n    ['application/x-gsp', 'gsp'],\n    ['application/x-gss', 'gss'],\n    ['application/x-gtar', 'gtar'],\n    ['application/x-gzip', ['gz', 'gzip']],\n    ['application/x-hdf', 'hdf'],\n    ['application/x-helpfile', ['help', 'hlp']],\n    ['application/x-httpd-imap', 'imap'],\n    ['application/x-ima', 'ima'],\n    ['application/x-internet-signup', ['ins', 'isp']],\n    ['application/x-internett-signup', 'ins'],\n    ['application/x-inventor', 'iv'],\n    ['application/x-ip2', 'ip'],\n    ['application/x-iphone', 'iii'],\n    ['application/x-java-class', 'class'],\n    ['application/x-java-commerce', 'jcm'],\n    ['application/x-java-jnlp-file', 'jnlp'],\n    ['application/x-javascript', 'js'],\n    ['application/x-koan', ['skd', 'skm', 'skp', 'skt']],\n    ['application/x-ksh', 'ksh'],\n    ['application/x-latex', ['latex', 'ltx']],\n    ['application/x-lha', 'lha'],\n    ['application/x-lisp', 'lsp'],\n    ['application/x-livescreen', 'ivy'],\n    ['application/x-lotus', 'wq1'],\n    ['application/x-lotusscreencam', 'scm'],\n    ['application/x-lzh', 'lzh'],\n    ['application/x-lzx', 'lzx'],\n    ['application/x-mac-binhex40', 'hqx'],\n    ['application/x-macbinary', 'bin'],\n    ['application/x-magic-cap-package-1.0', 'mc$'],\n    ['application/x-mathcad', 'mcd'],\n    ['application/x-meme', 'mm'],\n    ['application/x-midi', ['mid', 'midi']],\n    ['application/x-mif', 'mif'],\n    ['application/x-mix-transfer', 'nix'],\n    ['application/x-mobipocket-ebook', 'prc'],\n    ['application/x-mplayer2', 'asx'],\n    ['application/x-ms-application', 'application'],\n    ['application/x-ms-wmd', 'wmd'],\n    ['application/x-ms-wmz', 'wmz'],\n    ['application/x-ms-xbap', 'xbap'],\n    ['application/x-msaccess', 'mdb'],\n    ['application/x-msbinder', 'obd'],\n    ['application/x-mscardfile', 'crd'],\n    ['application/x-msclip', 'clp'],\n    ['application/x-msdownload', ['exe', 'dll']],\n    ['application/x-msexcel', ['xls', 'xla', 'xlw']],\n    ['application/x-msmediaview', ['mvb', 'm13', 'm14']],\n    ['application/x-msmetafile', 'wmf'],\n    ['application/x-msmoney', 'mny'],\n    ['application/x-mspowerpoint', 'ppt'],\n    ['application/x-mspublisher', 'pub'],\n    ['application/x-msschedule', 'scd'],\n    ['application/x-msterminal', 'trm'],\n    ['application/x-mswrite', 'wri'],\n    ['application/x-navi-animation', 'ani'],\n    ['application/x-navidoc', 'nvd'],\n    ['application/x-navimap', 'map'],\n    ['application/x-navistyle', 'stl'],\n    ['application/x-netcdf', ['cdf', 'nc']],\n    ['application/x-newton-compatible-pkg', 'pkg'],\n    ['application/x-nokia-9000-communicator-add-on-software', 'aos'],\n    ['application/x-omc', 'omc'],\n    ['application/x-omcdatamaker', 'omcd'],\n    ['application/x-omcregerator', 'omcr'],\n    ['application/x-pagemaker', ['pm4', 'pm5']],\n    ['application/x-pcl', 'pcl'],\n    ['application/x-perfmon', ['pma', 'pmc', 'pml', 'pmr', 'pmw']],\n    ['application/x-pixclscript', 'plx'],\n    ['application/x-pkcs10', 'p10'],\n    ['application/x-pkcs12', ['p12', 'pfx']],\n    ['application/x-pkcs7-certificates', ['p7b', 'spc']],\n    ['application/x-pkcs7-certreqresp', 'p7r'],\n    ['application/x-pkcs7-mime', ['p7m', 'p7c']],\n    ['application/x-pkcs7-signature', ['p7s', 'p7a']],\n    ['application/x-pointplus', 'css'],\n    ['application/x-portable-anymap', 'pnm'],\n    ['application/x-project', ['mpc', 'mpt', 'mpv', 'mpx']],\n    ['application/x-qpro', 'wb1'],\n    ['application/x-rar-compressed', 'rar'],\n    ['application/x-rtf', 'rtf'],\n    ['application/x-sdp', 'sdp'],\n    ['application/x-sea', 'sea'],\n    ['application/x-seelogo', 'sl'],\n    ['application/x-sh', 'sh'],\n    ['application/x-shar', ['shar', 'sh']],\n    ['application/x-shockwave-flash', 'swf'],\n    ['application/x-silverlight-app', 'xap'],\n    ['application/x-sit', 'sit'],\n    ['application/x-sprite', ['spr', 'sprite']],\n    ['application/x-stuffit', 'sit'],\n    ['application/x-stuffitx', 'sitx'],\n    ['application/x-sv4cpio', 'sv4cpio'],\n    ['application/x-sv4crc', 'sv4crc'],\n    ['application/x-tar', 'tar'],\n    ['application/x-tbook', ['sbk', 'tbk']],\n    ['application/x-tcl', 'tcl'],\n    ['application/x-tex', 'tex'],\n    ['application/x-tex-tfm', 'tfm'],\n    ['application/x-texinfo', ['texi', 'texinfo']],\n    ['application/x-troff', ['roff', 't', 'tr']],\n    ['application/x-troff-man', 'man'],\n    ['application/x-troff-me', 'me'],\n    ['application/x-troff-ms', 'ms'],\n    ['application/x-troff-msvideo', 'avi'],\n    ['application/x-ustar', 'ustar'],\n    ['application/x-visio', ['vsd', 'vst', 'vsw']],\n    ['application/x-vnd.audioexplosion.mzz', 'mzz'],\n    ['application/x-vnd.ls-xpix', 'xpix'],\n    ['application/x-vrml', 'vrml'],\n    ['application/x-wais-source', ['src', 'wsrc']],\n    ['application/x-winhelp', 'hlp'],\n    ['application/x-wintalk', 'wtk'],\n    ['application/x-world', ['wrl', 'svr']],\n    ['application/x-wpwin', 'wpd'],\n    ['application/x-wri', 'wri'],\n    ['application/x-x509-ca-cert', ['cer', 'crt', 'der']],\n    ['application/x-x509-user-cert', 'crt'],\n    ['application/x-xfig', 'fig'],\n    ['application/x-xpinstall', 'xpi'],\n    ['application/x-zip-compressed', 'zip'],\n    ['application/xcap-diff+xml', 'xdf'],\n    ['application/xenc+xml', 'xenc'],\n    ['application/xhtml+xml', 'xhtml'],\n    ['application/xml', 'xml'],\n    ['application/xml-dtd', 'dtd'],\n    ['application/xop+xml', 'xop'],\n    ['application/xslt+xml', 'xslt'],\n    ['application/xspf+xml', 'xspf'],\n    ['application/xv+xml', 'mxml'],\n    ['application/yang', 'yang'],\n    ['application/yin+xml', 'yin'],\n    ['application/ynd.ms-pkipko', 'pko'],\n    ['application/zip', 'zip'],\n    ['audio/adpcm', 'adp'],\n    ['audio/aiff', ['aiff', 'aif', 'aifc']],\n    ['audio/basic', ['snd', 'au']],\n    ['audio/it', 'it'],\n    ['audio/make', ['funk', 'my', 'pfunk']],\n    ['audio/make.my.funk', 'pfunk'],\n    ['audio/mid', ['mid', 'rmi']],\n    ['audio/midi', ['midi', 'kar', 'mid']],\n    ['audio/mod', 'mod'],\n    ['audio/mp4', 'mp4a'],\n    ['audio/mpeg', ['mpga', 'mp3', 'm2a', 'mp2', 'mpa', 'mpg']],\n    ['audio/mpeg3', 'mp3'],\n    ['audio/nspaudio', ['la', 'lma']],\n    ['audio/ogg', 'oga'],\n    ['audio/s3m', 's3m'],\n    ['audio/tsp-audio', 'tsi'],\n    ['audio/tsplayer', 'tsp'],\n    ['audio/vnd.dece.audio', 'uva'],\n    ['audio/vnd.digital-winds', 'eol'],\n    ['audio/vnd.dra', 'dra'],\n    ['audio/vnd.dts', 'dts'],\n    ['audio/vnd.dts.hd', 'dtshd'],\n    ['audio/vnd.lucent.voice', 'lvp'],\n    ['audio/vnd.ms-playready.media.pya', 'pya'],\n    ['audio/vnd.nuera.ecelp4800', 'ecelp4800'],\n    ['audio/vnd.nuera.ecelp7470', 'ecelp7470'],\n    ['audio/vnd.nuera.ecelp9600', 'ecelp9600'],\n    ['audio/vnd.qcelp', 'qcp'],\n    ['audio/vnd.rip', 'rip'],\n    ['audio/voc', 'voc'],\n    ['audio/voxware', 'vox'],\n    ['audio/wav', 'wav'],\n    ['audio/webm', 'weba'],\n    ['audio/x-aac', 'aac'],\n    ['audio/x-adpcm', 'snd'],\n    ['audio/x-aiff', ['aiff', 'aif', 'aifc']],\n    ['audio/x-au', 'au'],\n    ['audio/x-gsm', ['gsd', 'gsm']],\n    ['audio/x-jam', 'jam'],\n    ['audio/x-liveaudio', 'lam'],\n    ['audio/x-mid', ['mid', 'midi']],\n    ['audio/x-midi', ['midi', 'mid']],\n    ['audio/x-mod', 'mod'],\n    ['audio/x-mpeg', 'mp2'],\n    ['audio/x-mpeg-3', 'mp3'],\n    ['audio/x-mpegurl', 'm3u'],\n    ['audio/x-mpequrl', 'm3u'],\n    ['audio/x-ms-wax', 'wax'],\n    ['audio/x-ms-wma', 'wma'],\n    ['audio/x-nspaudio', ['la', 'lma']],\n    ['audio/x-pn-realaudio', ['ra', 'ram', 'rm', 'rmm', 'rmp']],\n    ['audio/x-pn-realaudio-plugin', ['ra', 'rmp', 'rpm']],\n    ['audio/x-psid', 'sid'],\n    ['audio/x-realaudio', 'ra'],\n    ['audio/x-twinvq', 'vqf'],\n    ['audio/x-twinvq-plugin', ['vqe', 'vql']],\n    ['audio/x-vnd.audioexplosion.mjuicemediafile', 'mjf'],\n    ['audio/x-voc', 'voc'],\n    ['audio/x-wav', 'wav'],\n    ['audio/xm', 'xm'],\n    ['chemical/x-cdx', 'cdx'],\n    ['chemical/x-cif', 'cif'],\n    ['chemical/x-cmdf', 'cmdf'],\n    ['chemical/x-cml', 'cml'],\n    ['chemical/x-csml', 'csml'],\n    ['chemical/x-pdb', ['pdb', 'xyz']],\n    ['chemical/x-xyz', 'xyz'],\n    ['drawing/x-dwf', 'dwf'],\n    ['i-world/i-vrml', 'ivr'],\n    ['image/bmp', ['bmp', 'bm']],\n    ['image/cgm', 'cgm'],\n    ['image/cis-cod', 'cod'],\n    ['image/cmu-raster', ['ras', 'rast']],\n    ['image/fif', 'fif'],\n    ['image/florian', ['flo', 'turbot']],\n    ['image/g3fax', 'g3'],\n    ['image/gif', 'gif'],\n    ['image/ief', ['ief', 'iefs']],\n    ['image/jpeg', ['jpeg', 'jpe', 'jpg', 'jfif', 'jfif-tbnl']],\n    ['image/jutvision', 'jut'],\n    ['image/ktx', 'ktx'],\n    ['image/naplps', ['nap', 'naplps']],\n    ['image/pict', ['pic', 'pict']],\n    ['image/pipeg', 'jfif'],\n    ['image/pjpeg', ['jfif', 'jpe', 'jpeg', 'jpg']],\n    ['image/png', ['png', 'x-png']],\n    ['image/prs.btif', 'btif'],\n    ['image/svg+xml', 'svg'],\n    ['image/tiff', ['tif', 'tiff']],\n    ['image/vasa', 'mcf'],\n    ['image/vnd.adobe.photoshop', 'psd'],\n    ['image/vnd.dece.graphic', 'uvi'],\n    ['image/vnd.djvu', 'djvu'],\n    ['image/vnd.dvb.subtitle', 'sub'],\n    ['image/vnd.dwg', ['dwg', 'dxf', 'svf']],\n    ['image/vnd.dxf', 'dxf'],\n    ['image/vnd.fastbidsheet', 'fbs'],\n    ['image/vnd.fpx', 'fpx'],\n    ['image/vnd.fst', 'fst'],\n    ['image/vnd.fujixerox.edmics-mmr', 'mmr'],\n    ['image/vnd.fujixerox.edmics-rlc', 'rlc'],\n    ['image/vnd.ms-modi', 'mdi'],\n    ['image/vnd.net-fpx', ['fpx', 'npx']],\n    ['image/vnd.rn-realflash', 'rf'],\n    ['image/vnd.rn-realpix', 'rp'],\n    ['image/vnd.wap.wbmp', 'wbmp'],\n    ['image/vnd.xiff', 'xif'],\n    ['image/webp', 'webp'],\n    ['image/x-cmu-raster', 'ras'],\n    ['image/x-cmx', 'cmx'],\n    ['image/x-dwg', ['dwg', 'dxf', 'svf']],\n    ['image/x-freehand', 'fh'],\n    ['image/x-icon', 'ico'],\n    ['image/x-jg', 'art'],\n    ['image/x-jps', 'jps'],\n    ['image/x-niff', ['niff', 'nif']],\n    ['image/x-pcx', 'pcx'],\n    ['image/x-pict', ['pct', 'pic']],\n    ['image/x-portable-anymap', 'pnm'],\n    ['image/x-portable-bitmap', 'pbm'],\n    ['image/x-portable-graymap', 'pgm'],\n    ['image/x-portable-greymap', 'pgm'],\n    ['image/x-portable-pixmap', 'ppm'],\n    ['image/x-quicktime', ['qif', 'qti', 'qtif']],\n    ['image/x-rgb', 'rgb'],\n    ['image/x-tiff', ['tif', 'tiff']],\n    ['image/x-windows-bmp', 'bmp'],\n    ['image/x-xbitmap', 'xbm'],\n    ['image/x-xbm', 'xbm'],\n    ['image/x-xpixmap', ['xpm', 'pm']],\n    ['image/x-xwd', 'xwd'],\n    ['image/x-xwindowdump', 'xwd'],\n    ['image/xbm', 'xbm'],\n    ['image/xpm', 'xpm'],\n    ['message/rfc822', ['eml', 'mht', 'mhtml', 'nws', 'mime']],\n    ['model/iges', ['iges', 'igs']],\n    ['model/mesh', 'msh'],\n    ['model/vnd.collada+xml', 'dae'],\n    ['model/vnd.dwf', 'dwf'],\n    ['model/vnd.gdl', 'gdl'],\n    ['model/vnd.gtw', 'gtw'],\n    ['model/vnd.mts', 'mts'],\n    ['model/vnd.vtu', 'vtu'],\n    ['model/vrml', ['vrml', 'wrl', 'wrz']],\n    ['model/x-pov', 'pov'],\n    ['multipart/x-gzip', 'gzip'],\n    ['multipart/x-ustar', 'ustar'],\n    ['multipart/x-zip', 'zip'],\n    ['music/crescendo', ['mid', 'midi']],\n    ['music/x-karaoke', 'kar'],\n    ['paleovu/x-pv', 'pvu'],\n    ['text/asp', 'asp'],\n    ['text/calendar', 'ics'],\n    ['text/css', 'css'],\n    ['text/csv', 'csv'],\n    ['text/ecmascript', 'js'],\n    ['text/h323', '323'],\n    ['text/html', ['html', 'htm', 'stm', 'acgi', 'htmls', 'htx', 'shtml']],\n    ['text/iuls', 'uls'],\n    ['text/javascript', 'js'],\n    ['text/mcf', 'mcf'],\n    ['text/n3', 'n3'],\n    ['text/pascal', 'pas'],\n    [\n        'text/plain',\n        [\n            'txt',\n            'bas',\n            'c',\n            'h',\n            'c++',\n            'cc',\n            'com',\n            'conf',\n            'cxx',\n            'def',\n            'f',\n            'f90',\n            'for',\n            'g',\n            'hh',\n            'idc',\n            'jav',\n            'java',\n            'list',\n            'log',\n            'lst',\n            'm',\n            'mar',\n            'pl',\n            'sdml',\n            'text'\n        ]\n    ],\n    ['text/plain-bas', 'par'],\n    ['text/prs.lines.tag', 'dsc'],\n    ['text/richtext', ['rtx', 'rt', 'rtf']],\n    ['text/scriplet', 'wsc'],\n    ['text/scriptlet', 'sct'],\n    ['text/sgml', ['sgm', 'sgml']],\n    ['text/tab-separated-values', 'tsv'],\n    ['text/troff', 't'],\n    ['text/turtle', 'ttl'],\n    ['text/uri-list', ['uni', 'unis', 'uri', 'uris']],\n    ['text/vnd.abc', 'abc'],\n    ['text/vnd.curl', 'curl'],\n    ['text/vnd.curl.dcurl', 'dcurl'],\n    ['text/vnd.curl.mcurl', 'mcurl'],\n    ['text/vnd.curl.scurl', 'scurl'],\n    ['text/vnd.fly', 'fly'],\n    ['text/vnd.fmi.flexstor', 'flx'],\n    ['text/vnd.graphviz', 'gv'],\n    ['text/vnd.in3d.3dml', '3dml'],\n    ['text/vnd.in3d.spot', 'spot'],\n    ['text/vnd.rn-realtext', 'rt'],\n    ['text/vnd.sun.j2me.app-descriptor', 'jad'],\n    ['text/vnd.wap.wml', 'wml'],\n    ['text/vnd.wap.wmlscript', 'wmls'],\n    ['text/webviewhtml', 'htt'],\n    ['text/x-asm', ['asm', 's']],\n    ['text/x-audiosoft-intra', 'aip'],\n    ['text/x-c', ['c', 'cc', 'cpp']],\n    ['text/x-component', 'htc'],\n    ['text/x-fortran', ['for', 'f', 'f77', 'f90']],\n    ['text/x-h', ['h', 'hh']],\n    ['text/x-java-source', ['java', 'jav']],\n    ['text/x-java-source,java', 'java'],\n    ['text/x-la-asf', 'lsx'],\n    ['text/x-m', 'm'],\n    ['text/x-pascal', 'p'],\n    ['text/x-script', 'hlb'],\n    ['text/x-script.csh', 'csh'],\n    ['text/x-script.elisp', 'el'],\n    ['text/x-script.guile', 'scm'],\n    ['text/x-script.ksh', 'ksh'],\n    ['text/x-script.lisp', 'lsp'],\n    ['text/x-script.perl', 'pl'],\n    ['text/x-script.perl-module', 'pm'],\n    ['text/x-script.phyton', 'py'],\n    ['text/x-script.rexx', 'rexx'],\n    ['text/x-script.scheme', 'scm'],\n    ['text/x-script.sh', 'sh'],\n    ['text/x-script.tcl', 'tcl'],\n    ['text/x-script.tcsh', 'tcsh'],\n    ['text/x-script.zsh', 'zsh'],\n    ['text/x-server-parsed-html', ['shtml', 'ssi']],\n    ['text/x-setext', 'etx'],\n    ['text/x-sgml', ['sgm', 'sgml']],\n    ['text/x-speech', ['spc', 'talk']],\n    ['text/x-uil', 'uil'],\n    ['text/x-uuencode', ['uu', 'uue']],\n    ['text/x-vcalendar', 'vcs'],\n    ['text/x-vcard', 'vcf'],\n    ['text/xml', 'xml'],\n    ['video/3gpp', '3gp'],\n    ['video/3gpp2', '3g2'],\n    ['video/animaflex', 'afl'],\n    ['video/avi', 'avi'],\n    ['video/avs-video', 'avs'],\n    ['video/dl', 'dl'],\n    ['video/fli', 'fli'],\n    ['video/gl', 'gl'],\n    ['video/h261', 'h261'],\n    ['video/h263', 'h263'],\n    ['video/h264', 'h264'],\n    ['video/jpeg', 'jpgv'],\n    ['video/jpm', 'jpm'],\n    ['video/mj2', 'mj2'],\n    ['video/mp4', 'mp4'],\n    ['video/mpeg', ['mpeg', 'mp2', 'mpa', 'mpe', 'mpg', 'mpv2', 'm1v', 'm2v', 'mp3']],\n    ['video/msvideo', 'avi'],\n    ['video/ogg', 'ogv'],\n    ['video/quicktime', ['mov', 'qt', 'moov']],\n    ['video/vdo', 'vdo'],\n    ['video/vivo', ['viv', 'vivo']],\n    ['video/vnd.dece.hd', 'uvh'],\n    ['video/vnd.dece.mobile', 'uvm'],\n    ['video/vnd.dece.pd', 'uvp'],\n    ['video/vnd.dece.sd', 'uvs'],\n    ['video/vnd.dece.video', 'uvv'],\n    ['video/vnd.fvt', 'fvt'],\n    ['video/vnd.mpegurl', 'mxu'],\n    ['video/vnd.ms-playready.media.pyv', 'pyv'],\n    ['video/vnd.rn-realvideo', 'rv'],\n    ['video/vnd.uvvu.mp4', 'uvu'],\n    ['video/vnd.vivo', ['viv', 'vivo']],\n    ['video/vosaic', 'vos'],\n    ['video/webm', 'webm'],\n    ['video/x-amt-demorun', 'xdr'],\n    ['video/x-amt-showrun', 'xsr'],\n    ['video/x-atomic3d-feature', 'fmf'],\n    ['video/x-dl', 'dl'],\n    ['video/x-dv', ['dif', 'dv']],\n    ['video/x-f4v', 'f4v'],\n    ['video/x-fli', 'fli'],\n    ['video/x-flv', 'flv'],\n    ['video/x-gl', 'gl'],\n    ['video/x-isvideo', 'isu'],\n    ['video/x-la-asf', ['lsf', 'lsx']],\n    ['video/x-m4v', 'm4v'],\n    ['video/x-motion-jpeg', 'mjpg'],\n    ['video/x-mpeg', ['mp3', 'mp2']],\n    ['video/x-mpeq2a', 'mp2'],\n    ['video/x-ms-asf', ['asf', 'asr', 'asx']],\n    ['video/x-ms-asf-plugin', 'asx'],\n    ['video/x-ms-wm', 'wm'],\n    ['video/x-ms-wmv', 'wmv'],\n    ['video/x-ms-wmx', 'wmx'],\n    ['video/x-ms-wvx', 'wvx'],\n    ['video/x-msvideo', 'avi'],\n    ['video/x-qtc', 'qtc'],\n    ['video/x-scm', 'scm'],\n    ['video/x-sgi-movie', ['movie', 'mv']],\n    ['windows/metafile', 'wmf'],\n    ['www/mime', 'mime'],\n    ['x-conference/x-cooltalk', 'ice'],\n    ['x-music/x-midi', ['mid', 'midi']],\n    ['x-world/x-3dmf', ['3dm', '3dmf', 'qd3', 'qd3d']],\n    ['x-world/x-svr', 'svr'],\n    ['x-world/x-vrml', ['flr', 'vrml', 'wrl', 'wrz', 'xaf', 'xof']],\n    ['x-world/x-vrt', 'vrt'],\n    ['xgl/drawing', 'xgz'],\n    ['xgl/movie', 'xmz']\n]);\nconst extensions = new Map([\n    ['123', 'application/vnd.lotus-1-2-3'],\n    ['323', 'text/h323'],\n    ['*', 'application/octet-stream'],\n    ['3dm', 'x-world/x-3dmf'],\n    ['3dmf', 'x-world/x-3dmf'],\n    ['3dml', 'text/vnd.in3d.3dml'],\n    ['3g2', 'video/3gpp2'],\n    ['3gp', 'video/3gpp'],\n    ['7z', 'application/x-7z-compressed'],\n    ['a', 'application/octet-stream'],\n    ['aab', 'application/x-authorware-bin'],\n    ['aac', 'audio/x-aac'],\n    ['aam', 'application/x-authorware-map'],\n    ['aas', 'application/x-authorware-seg'],\n    ['abc', 'text/vnd.abc'],\n    ['abw', 'application/x-abiword'],\n    ['ac', 'application/pkix-attr-cert'],\n    ['acc', 'application/vnd.americandynamics.acc'],\n    ['ace', 'application/x-ace-compressed'],\n    ['acgi', 'text/html'],\n    ['acu', 'application/vnd.acucobol'],\n    ['acx', 'application/internet-property-stream'],\n    ['adp', 'audio/adpcm'],\n    ['aep', 'application/vnd.audiograph'],\n    ['afl', 'video/animaflex'],\n    ['afp', 'application/vnd.ibm.modcap'],\n    ['ahead', 'application/vnd.ahead.space'],\n    ['ai', 'application/postscript'],\n    ['aif', ['audio/aiff', 'audio/x-aiff']],\n    ['aifc', ['audio/aiff', 'audio/x-aiff']],\n    ['aiff', ['audio/aiff', 'audio/x-aiff']],\n    ['aim', 'application/x-aim'],\n    ['aip', 'text/x-audiosoft-intra'],\n    ['air', 'application/vnd.adobe.air-application-installer-package+zip'],\n    ['ait', 'application/vnd.dvb.ait'],\n    ['ami', 'application/vnd.amiga.ami'],\n    ['ani', 'application/x-navi-animation'],\n    ['aos', 'application/x-nokia-9000-communicator-add-on-software'],\n    ['apk', 'application/vnd.android.package-archive'],\n    ['application', 'application/x-ms-application'],\n    ['apr', 'application/vnd.lotus-approach'],\n    ['aps', 'application/mime'],\n    ['arc', 'application/octet-stream'],\n    ['arj', ['application/arj', 'application/octet-stream']],\n    ['art', 'image/x-jg'],\n    ['asf', 'video/x-ms-asf'],\n    ['asm', 'text/x-asm'],\n    ['aso', 'application/vnd.accpac.simply.aso'],\n    ['asp', 'text/asp'],\n    ['asr', 'video/x-ms-asf'],\n    ['asx', ['video/x-ms-asf', 'application/x-mplayer2', 'video/x-ms-asf-plugin']],\n    ['atc', 'application/vnd.acucorp'],\n    ['atomcat', 'application/atomcat+xml'],\n    ['atomsvc', 'application/atomsvc+xml'],\n    ['atx', 'application/vnd.antix.game-component'],\n    ['au', ['audio/basic', 'audio/x-au']],\n    ['avi', ['video/avi', 'video/msvideo', 'application/x-troff-msvideo', 'video/x-msvideo']],\n    ['avs', 'video/avs-video'],\n    ['aw', 'application/applixware'],\n    ['axs', 'application/olescript'],\n    ['azf', 'application/vnd.airzip.filesecure.azf'],\n    ['azs', 'application/vnd.airzip.filesecure.azs'],\n    ['azw', 'application/vnd.amazon.ebook'],\n    ['bas', 'text/plain'],\n    ['bcpio', 'application/x-bcpio'],\n    ['bdf', 'application/x-font-bdf'],\n    ['bdm', 'application/vnd.syncml.dm+wbxml'],\n    ['bed', 'application/vnd.realvnc.bed'],\n    ['bh2', 'application/vnd.fujitsu.oasysprs'],\n    [\n        'bin',\n        ['application/octet-stream', 'application/mac-binary', 'application/macbinary', 'application/x-macbinary', 'application/x-binary']\n    ],\n    ['bm', 'image/bmp'],\n    ['bmi', 'application/vnd.bmi'],\n    ['bmp', ['image/bmp', 'image/x-windows-bmp']],\n    ['boo', 'application/book'],\n    ['book', 'application/book'],\n    ['box', 'application/vnd.previewsystems.box'],\n    ['boz', 'application/x-bzip2'],\n    ['bsh', 'application/x-bsh'],\n    ['btif', 'image/prs.btif'],\n    ['bz', 'application/x-bzip'],\n    ['bz2', 'application/x-bzip2'],\n    ['c', ['text/plain', 'text/x-c']],\n    ['c++', 'text/plain'],\n    ['c11amc', 'application/vnd.cluetrust.cartomobile-config'],\n    ['c11amz', 'application/vnd.cluetrust.cartomobile-config-pkg'],\n    ['c4g', 'application/vnd.clonk.c4group'],\n    ['cab', 'application/vnd.ms-cab-compressed'],\n    ['car', 'application/vnd.curl.car'],\n    ['cat', ['application/vnd.ms-pkiseccat', 'application/vnd.ms-pki.seccat']],\n    ['cc', ['text/plain', 'text/x-c']],\n    ['ccad', 'application/clariscad'],\n    ['cco', 'application/x-cocoa'],\n    ['ccxml', 'application/ccxml+xml,'],\n    ['cdbcmsg', 'application/vnd.contact.cmsg'],\n    ['cdf', ['application/cdf', 'application/x-cdf', 'application/x-netcdf']],\n    ['cdkey', 'application/vnd.mediastation.cdkey'],\n    ['cdmia', 'application/cdmi-capability'],\n    ['cdmic', 'application/cdmi-container'],\n    ['cdmid', 'application/cdmi-domain'],\n    ['cdmio', 'application/cdmi-object'],\n    ['cdmiq', 'application/cdmi-queue'],\n    ['cdx', 'chemical/x-cdx'],\n    ['cdxml', 'application/vnd.chemdraw+xml'],\n    ['cdy', 'application/vnd.cinderella'],\n    ['cer', ['application/pkix-cert', 'application/x-x509-ca-cert']],\n    ['cgm', 'image/cgm'],\n    ['cha', 'application/x-chat'],\n    ['chat', 'application/x-chat'],\n    ['chm', 'application/vnd.ms-htmlhelp'],\n    ['chrt', 'application/vnd.kde.kchart'],\n    ['cif', 'chemical/x-cif'],\n    ['cii', 'application/vnd.anser-web-certificate-issue-initiation'],\n    ['cil', 'application/vnd.ms-artgalry'],\n    ['cla', 'application/vnd.claymore'],\n    [\n        'class',\n        ['application/octet-stream', 'application/java', 'application/java-byte-code', 'application/java-vm', 'application/x-java-class']\n    ],\n    ['clkk', 'application/vnd.crick.clicker.keyboard'],\n    ['clkp', 'application/vnd.crick.clicker.palette'],\n    ['clkt', 'application/vnd.crick.clicker.template'],\n    ['clkw', 'application/vnd.crick.clicker.wordbank'],\n    ['clkx', 'application/vnd.crick.clicker'],\n    ['clp', 'application/x-msclip'],\n    ['cmc', 'application/vnd.cosmocaller'],\n    ['cmdf', 'chemical/x-cmdf'],\n    ['cml', 'chemical/x-cml'],\n    ['cmp', 'application/vnd.yellowriver-custom-menu'],\n    ['cmx', 'image/x-cmx'],\n    ['cod', ['image/cis-cod', 'application/vnd.rim.cod']],\n    ['com', ['application/octet-stream', 'text/plain']],\n    ['conf', 'text/plain'],\n    ['cpio', 'application/x-cpio'],\n    ['cpp', 'text/x-c'],\n    ['cpt', ['application/mac-compactpro', 'application/x-compactpro', 'application/x-cpt']],\n    ['crd', 'application/x-mscardfile'],\n    ['crl', ['application/pkix-crl', 'application/pkcs-crl']],\n    ['crt', ['application/pkix-cert', 'application/x-x509-user-cert', 'application/x-x509-ca-cert']],\n    ['cryptonote', 'application/vnd.rig.cryptonote'],\n    ['csh', ['text/x-script.csh', 'application/x-csh']],\n    ['csml', 'chemical/x-csml'],\n    ['csp', 'application/vnd.commonspace'],\n    ['css', ['text/css', 'application/x-pointplus']],\n    ['csv', 'text/csv'],\n    ['cu', 'application/cu-seeme'],\n    ['curl', 'text/vnd.curl'],\n    ['cww', 'application/prs.cww'],\n    ['cxx', 'text/plain'],\n    ['dae', 'model/vnd.collada+xml'],\n    ['daf', 'application/vnd.mobius.daf'],\n    ['davmount', 'application/davmount+xml'],\n    ['dcr', 'application/x-director'],\n    ['dcurl', 'text/vnd.curl.dcurl'],\n    ['dd2', 'application/vnd.oma.dd2+xml'],\n    ['ddd', 'application/vnd.fujixerox.ddd'],\n    ['deb', 'application/x-debian-package'],\n    ['deepv', 'application/x-deepv'],\n    ['def', 'text/plain'],\n    ['der', 'application/x-x509-ca-cert'],\n    ['dfac', 'application/vnd.dreamfactory'],\n    ['dif', 'video/x-dv'],\n    ['dir', 'application/x-director'],\n    ['dis', 'application/vnd.mobius.dis'],\n    ['djvu', 'image/vnd.djvu'],\n    ['dl', ['video/dl', 'video/x-dl']],\n    ['dll', 'application/x-msdownload'],\n    ['dms', 'application/octet-stream'],\n    ['dna', 'application/vnd.dna'],\n    ['doc', 'application/msword'],\n    ['docm', 'application/vnd.ms-word.document.macroenabled.12'],\n    ['docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'],\n    ['dot', 'application/msword'],\n    ['dotm', 'application/vnd.ms-word.template.macroenabled.12'],\n    ['dotx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'],\n    ['dp', ['application/commonground', 'application/vnd.osgi.dp']],\n    ['dpg', 'application/vnd.dpgraph'],\n    ['dra', 'audio/vnd.dra'],\n    ['drw', 'application/drafting'],\n    ['dsc', 'text/prs.lines.tag'],\n    ['dssc', 'application/dssc+der'],\n    ['dtb', 'application/x-dtbook+xml'],\n    ['dtd', 'application/xml-dtd'],\n    ['dts', 'audio/vnd.dts'],\n    ['dtshd', 'audio/vnd.dts.hd'],\n    ['dump', 'application/octet-stream'],\n    ['dv', 'video/x-dv'],\n    ['dvi', 'application/x-dvi'],\n    ['dwf', ['model/vnd.dwf', 'drawing/x-dwf']],\n    ['dwg', ['application/acad', 'image/vnd.dwg', 'image/x-dwg']],\n    ['dxf', ['application/dxf', 'image/vnd.dwg', 'image/vnd.dxf', 'image/x-dwg']],\n    ['dxp', 'application/vnd.spotfire.dxp'],\n    ['dxr', 'application/x-director'],\n    ['ecelp4800', 'audio/vnd.nuera.ecelp4800'],\n    ['ecelp7470', 'audio/vnd.nuera.ecelp7470'],\n    ['ecelp9600', 'audio/vnd.nuera.ecelp9600'],\n    ['edm', 'application/vnd.novadigm.edm'],\n    ['edx', 'application/vnd.novadigm.edx'],\n    ['efif', 'application/vnd.picsel'],\n    ['ei6', 'application/vnd.pg.osasli'],\n    ['el', 'text/x-script.elisp'],\n    ['elc', ['application/x-elc', 'application/x-bytecode.elisp']],\n    ['eml', 'message/rfc822'],\n    ['emma', 'application/emma+xml'],\n    ['env', 'application/x-envoy'],\n    ['eol', 'audio/vnd.digital-winds'],\n    ['eot', 'application/vnd.ms-fontobject'],\n    ['eps', 'application/postscript'],\n    ['epub', 'application/epub+zip'],\n    ['es', ['application/ecmascript', 'application/x-esrehber']],\n    ['es3', 'application/vnd.eszigno3+xml'],\n    ['esf', 'application/vnd.epson.esf'],\n    ['etx', 'text/x-setext'],\n    ['evy', ['application/envoy', 'application/x-envoy']],\n    ['exe', ['application/octet-stream', 'application/x-msdownload']],\n    ['exi', 'application/exi'],\n    ['ext', 'application/vnd.novadigm.ext'],\n    ['ez2', 'application/vnd.ezpix-album'],\n    ['ez3', 'application/vnd.ezpix-package'],\n    ['f', ['text/plain', 'text/x-fortran']],\n    ['f4v', 'video/x-f4v'],\n    ['f77', 'text/x-fortran'],\n    ['f90', ['text/plain', 'text/x-fortran']],\n    ['fbs', 'image/vnd.fastbidsheet'],\n    ['fcs', 'application/vnd.isac.fcs'],\n    ['fdf', 'application/vnd.fdf'],\n    ['fe_launch', 'application/vnd.denovo.fcselayout-link'],\n    ['fg5', 'application/vnd.fujitsu.oasysgp'],\n    ['fh', 'image/x-freehand'],\n    ['fif', ['application/fractals', 'image/fif']],\n    ['fig', 'application/x-xfig'],\n    ['fli', ['video/fli', 'video/x-fli']],\n    ['flo', ['image/florian', 'application/vnd.micrografx.flo']],\n    ['flr', 'x-world/x-vrml'],\n    ['flv', 'video/x-flv'],\n    ['flw', 'application/vnd.kde.kivio'],\n    ['flx', 'text/vnd.fmi.flexstor'],\n    ['fly', 'text/vnd.fly'],\n    ['fm', 'application/vnd.framemaker'],\n    ['fmf', 'video/x-atomic3d-feature'],\n    ['fnc', 'application/vnd.frogans.fnc'],\n    ['for', ['text/plain', 'text/x-fortran']],\n    ['fpx', ['image/vnd.fpx', 'image/vnd.net-fpx']],\n    ['frl', 'application/freeloader'],\n    ['fsc', 'application/vnd.fsc.weblaunch'],\n    ['fst', 'image/vnd.fst'],\n    ['ftc', 'application/vnd.fluxtime.clip'],\n    ['fti', 'application/vnd.anser-web-funds-transfer-initiation'],\n    ['funk', 'audio/make'],\n    ['fvt', 'video/vnd.fvt'],\n    ['fxp', 'application/vnd.adobe.fxp'],\n    ['fzs', 'application/vnd.fuzzysheet'],\n    ['g', 'text/plain'],\n    ['g2w', 'application/vnd.geoplan'],\n    ['g3', 'image/g3fax'],\n    ['g3w', 'application/vnd.geospace'],\n    ['gac', 'application/vnd.groove-account'],\n    ['gdl', 'model/vnd.gdl'],\n    ['geo', 'application/vnd.dynageo'],\n    ['geojson', 'application/geo+json'],\n    ['gex', 'application/vnd.geometry-explorer'],\n    ['ggb', 'application/vnd.geogebra.file'],\n    ['ggt', 'application/vnd.geogebra.tool'],\n    ['ghf', 'application/vnd.groove-help'],\n    ['gif', 'image/gif'],\n    ['gim', 'application/vnd.groove-identity-message'],\n    ['gl', ['video/gl', 'video/x-gl']],\n    ['gmx', 'application/vnd.gmx'],\n    ['gnumeric', 'application/x-gnumeric'],\n    ['gph', 'application/vnd.flographit'],\n    ['gqf', 'application/vnd.grafeq'],\n    ['gram', 'application/srgs'],\n    ['grv', 'application/vnd.groove-injector'],\n    ['grxml', 'application/srgs+xml'],\n    ['gsd', 'audio/x-gsm'],\n    ['gsf', 'application/x-font-ghostscript'],\n    ['gsm', 'audio/x-gsm'],\n    ['gsp', 'application/x-gsp'],\n    ['gss', 'application/x-gss'],\n    ['gtar', 'application/x-gtar'],\n    ['gtm', 'application/vnd.groove-tool-message'],\n    ['gtw', 'model/vnd.gtw'],\n    ['gv', 'text/vnd.graphviz'],\n    ['gxt', 'application/vnd.geonext'],\n    ['gz', ['application/x-gzip', 'application/x-compressed']],\n    ['gzip', ['multipart/x-gzip', 'application/x-gzip']],\n    ['h', ['text/plain', 'text/x-h']],\n    ['h261', 'video/h261'],\n    ['h263', 'video/h263'],\n    ['h264', 'video/h264'],\n    ['hal', 'application/vnd.hal+xml'],\n    ['hbci', 'application/vnd.hbci'],\n    ['hdf', 'application/x-hdf'],\n    ['help', 'application/x-helpfile'],\n    ['hgl', 'application/vnd.hp-hpgl'],\n    ['hh', ['text/plain', 'text/x-h']],\n    ['hlb', 'text/x-script'],\n    ['hlp', ['application/winhlp', 'application/hlp', 'application/x-helpfile', 'application/x-winhelp']],\n    ['hpg', 'application/vnd.hp-hpgl'],\n    ['hpgl', 'application/vnd.hp-hpgl'],\n    ['hpid', 'application/vnd.hp-hpid'],\n    ['hps', 'application/vnd.hp-hps'],\n    [\n        'hqx',\n        [\n            'application/mac-binhex40',\n            'application/binhex',\n            'application/binhex4',\n            'application/mac-binhex',\n            'application/x-binhex40',\n            'application/x-mac-binhex40'\n        ]\n    ],\n    ['hta', 'application/hta'],\n    ['htc', 'text/x-component'],\n    ['htke', 'application/vnd.kenameaapp'],\n    ['htm', 'text/html'],\n    ['html', 'text/html'],\n    ['htmls', 'text/html'],\n    ['htt', 'text/webviewhtml'],\n    ['htx', 'text/html'],\n    ['hvd', 'application/vnd.yamaha.hv-dic'],\n    ['hvp', 'application/vnd.yamaha.hv-voice'],\n    ['hvs', 'application/vnd.yamaha.hv-script'],\n    ['i2g', 'application/vnd.intergeo'],\n    ['icc', 'application/vnd.iccprofile'],\n    ['ice', 'x-conference/x-cooltalk'],\n    ['ico', 'image/x-icon'],\n    ['ics', 'text/calendar'],\n    ['idc', 'text/plain'],\n    ['ief', 'image/ief'],\n    ['iefs', 'image/ief'],\n    ['ifm', 'application/vnd.shana.informed.formdata'],\n    ['iges', ['application/iges', 'model/iges']],\n    ['igl', 'application/vnd.igloader'],\n    ['igm', 'application/vnd.insors.igm'],\n    ['igs', ['application/iges', 'model/iges']],\n    ['igx', 'application/vnd.micrografx.igx'],\n    ['iif', 'application/vnd.shana.informed.interchange'],\n    ['iii', 'application/x-iphone'],\n    ['ima', 'application/x-ima'],\n    ['imap', 'application/x-httpd-imap'],\n    ['imp', 'application/vnd.accpac.simply.imp'],\n    ['ims', 'application/vnd.ms-ims'],\n    ['inf', 'application/inf'],\n    ['ins', ['application/x-internet-signup', 'application/x-internett-signup']],\n    ['ip', 'application/x-ip2'],\n    ['ipfix', 'application/ipfix'],\n    ['ipk', 'application/vnd.shana.informed.package'],\n    ['irm', 'application/vnd.ibm.rights-management'],\n    ['irp', 'application/vnd.irepository.package+xml'],\n    ['isp', 'application/x-internet-signup'],\n    ['isu', 'video/x-isvideo'],\n    ['it', 'audio/it'],\n    ['itp', 'application/vnd.shana.informed.formtemplate'],\n    ['iv', 'application/x-inventor'],\n    ['ivp', 'application/vnd.immervision-ivp'],\n    ['ivr', 'i-world/i-vrml'],\n    ['ivu', 'application/vnd.immervision-ivu'],\n    ['ivy', 'application/x-livescreen'],\n    ['jad', 'text/vnd.sun.j2me.app-descriptor'],\n    ['jam', ['application/vnd.jam', 'audio/x-jam']],\n    ['jar', 'application/java-archive'],\n    ['jav', ['text/plain', 'text/x-java-source']],\n    ['java', ['text/plain', 'text/x-java-source,java', 'text/x-java-source']],\n    ['jcm', 'application/x-java-commerce'],\n    ['jfif', ['image/pipeg', 'image/jpeg', 'image/pjpeg']],\n    ['jfif-tbnl', 'image/jpeg'],\n    ['jisp', 'application/vnd.jisp'],\n    ['jlt', 'application/vnd.hp-jlyt'],\n    ['jnlp', 'application/x-java-jnlp-file'],\n    ['joda', 'application/vnd.joost.joda-archive'],\n    ['jpe', ['image/jpeg', 'image/pjpeg']],\n    ['jpeg', ['image/jpeg', 'image/pjpeg']],\n    ['jpg', ['image/jpeg', 'image/pjpeg']],\n    ['jpgv', 'video/jpeg'],\n    ['jpm', 'video/jpm'],\n    ['jps', 'image/x-jps'],\n    ['js', ['application/javascript', 'application/ecmascript', 'text/javascript', 'text/ecmascript', 'application/x-javascript']],\n    ['json', 'application/json'],\n    ['jut', 'image/jutvision'],\n    ['kar', ['audio/midi', 'music/x-karaoke']],\n    ['karbon', 'application/vnd.kde.karbon'],\n    ['kfo', 'application/vnd.kde.kformula'],\n    ['kia', 'application/vnd.kidspiration'],\n    ['kml', 'application/vnd.google-earth.kml+xml'],\n    ['kmz', 'application/vnd.google-earth.kmz'],\n    ['kne', 'application/vnd.kinar'],\n    ['kon', 'application/vnd.kde.kontour'],\n    ['kpr', 'application/vnd.kde.kpresenter'],\n    ['ksh', ['application/x-ksh', 'text/x-script.ksh']],\n    ['ksp', 'application/vnd.kde.kspread'],\n    ['ktx', 'image/ktx'],\n    ['ktz', 'application/vnd.kahootz'],\n    ['kwd', 'application/vnd.kde.kword'],\n    ['la', ['audio/nspaudio', 'audio/x-nspaudio']],\n    ['lam', 'audio/x-liveaudio'],\n    ['lasxml', 'application/vnd.las.las+xml'],\n    ['latex', 'application/x-latex'],\n    ['lbd', 'application/vnd.llamagraphics.life-balance.desktop'],\n    ['lbe', 'application/vnd.llamagraphics.life-balance.exchange+xml'],\n    ['les', 'application/vnd.hhe.lesson-player'],\n    ['lha', ['application/octet-stream', 'application/lha', 'application/x-lha']],\n    ['lhx', 'application/octet-stream'],\n    ['link66', 'application/vnd.route66.link66+xml'],\n    ['list', 'text/plain'],\n    ['lma', ['audio/nspaudio', 'audio/x-nspaudio']],\n    ['log', 'text/plain'],\n    ['lrm', 'application/vnd.ms-lrm'],\n    ['lsf', 'video/x-la-asf'],\n    ['lsp', ['application/x-lisp', 'text/x-script.lisp']],\n    ['lst', 'text/plain'],\n    ['lsx', ['video/x-la-asf', 'text/x-la-asf']],\n    ['ltf', 'application/vnd.frogans.ltf'],\n    ['ltx', 'application/x-latex'],\n    ['lvp', 'audio/vnd.lucent.voice'],\n    ['lwp', 'application/vnd.lotus-wordpro'],\n    ['lzh', ['application/octet-stream', 'application/x-lzh']],\n    ['lzx', ['application/lzx', 'application/octet-stream', 'application/x-lzx']],\n    ['m', ['text/plain', 'text/x-m']],\n    ['m13', 'application/x-msmediaview'],\n    ['m14', 'application/x-msmediaview'],\n    ['m1v', 'video/mpeg'],\n    ['m21', 'application/mp21'],\n    ['m2a', 'audio/mpeg'],\n    ['m2v', 'video/mpeg'],\n    ['m3u', ['audio/x-mpegurl', 'audio/x-mpequrl']],\n    ['m3u8', 'application/vnd.apple.mpegurl'],\n    ['m4v', 'video/x-m4v'],\n    ['ma', 'application/mathematica'],\n    ['mads', 'application/mads+xml'],\n    ['mag', 'application/vnd.ecowin.chart'],\n    ['man', 'application/x-troff-man'],\n    ['map', 'application/x-navimap'],\n    ['mar', 'text/plain'],\n    ['mathml', 'application/mathml+xml'],\n    ['mbd', 'application/mbedlet'],\n    ['mbk', 'application/vnd.mobius.mbk'],\n    ['mbox', 'application/mbox'],\n    ['mc$', 'application/x-magic-cap-package-1.0'],\n    ['mc1', 'application/vnd.medcalcdata'],\n    ['mcd', ['application/mcad', 'application/vnd.mcd', 'application/x-mathcad']],\n    ['mcf', ['image/vasa', 'text/mcf']],\n    ['mcp', 'application/netmc'],\n    ['mcurl', 'text/vnd.curl.mcurl'],\n    ['mdb', 'application/x-msaccess'],\n    ['mdi', 'image/vnd.ms-modi'],\n    ['me', 'application/x-troff-me'],\n    ['meta4', 'application/metalink4+xml'],\n    ['mets', 'application/mets+xml'],\n    ['mfm', 'application/vnd.mfmp'],\n    ['mgp', 'application/vnd.osgeo.mapguide.package'],\n    ['mgz', 'application/vnd.proteus.magazine'],\n    ['mht', 'message/rfc822'],\n    ['mhtml', 'message/rfc822'],\n    ['mid', ['audio/mid', 'audio/midi', 'music/crescendo', 'x-music/x-midi', 'audio/x-midi', 'application/x-midi', 'audio/x-mid']],\n    ['midi', ['audio/midi', 'music/crescendo', 'x-music/x-midi', 'audio/x-midi', 'application/x-midi', 'audio/x-mid']],\n    ['mif', ['application/vnd.mif', 'application/x-mif', 'application/x-frame']],\n    ['mime', ['message/rfc822', 'www/mime']],\n    ['mj2', 'video/mj2'],\n    ['mjf', 'audio/x-vnd.audioexplosion.mjuicemediafile'],\n    ['mjpg', 'video/x-motion-jpeg'],\n    ['mlp', 'application/vnd.dolby.mlp'],\n    ['mm', ['application/base64', 'application/x-meme']],\n    ['mmd', 'application/vnd.chipnuts.karaoke-mmd'],\n    ['mme', 'application/base64'],\n    ['mmf', 'application/vnd.smaf'],\n    ['mmr', 'image/vnd.fujixerox.edmics-mmr'],\n    ['mny', 'application/x-msmoney'],\n    ['mod', ['audio/mod', 'audio/x-mod']],\n    ['mods', 'application/mods+xml'],\n    ['moov', 'video/quicktime'],\n    ['mov', 'video/quicktime'],\n    ['movie', 'video/x-sgi-movie'],\n    ['mp2', ['video/mpeg', 'audio/mpeg', 'video/x-mpeg', 'audio/x-mpeg', 'video/x-mpeq2a']],\n    ['mp3', ['audio/mpeg', 'audio/mpeg3', 'video/mpeg', 'audio/x-mpeg-3', 'video/x-mpeg']],\n    ['mp4', ['video/mp4', 'application/mp4']],\n    ['mp4a', 'audio/mp4'],\n    ['mpa', ['video/mpeg', 'audio/mpeg']],\n    ['mpc', ['application/vnd.mophun.certificate', 'application/x-project']],\n    ['mpe', 'video/mpeg'],\n    ['mpeg', 'video/mpeg'],\n    ['mpg', ['video/mpeg', 'audio/mpeg']],\n    ['mpga', 'audio/mpeg'],\n    ['mpkg', 'application/vnd.apple.installer+xml'],\n    ['mpm', 'application/vnd.blueice.multipass'],\n    ['mpn', 'application/vnd.mophun.application'],\n    ['mpp', 'application/vnd.ms-project'],\n    ['mpt', 'application/x-project'],\n    ['mpv', 'application/x-project'],\n    ['mpv2', 'video/mpeg'],\n    ['mpx', 'application/x-project'],\n    ['mpy', 'application/vnd.ibm.minipay'],\n    ['mqy', 'application/vnd.mobius.mqy'],\n    ['mrc', 'application/marc'],\n    ['mrcx', 'application/marcxml+xml'],\n    ['ms', 'application/x-troff-ms'],\n    ['mscml', 'application/mediaservercontrol+xml'],\n    ['mseq', 'application/vnd.mseq'],\n    ['msf', 'application/vnd.epson.msf'],\n    ['msg', 'application/vnd.ms-outlook'],\n    ['msh', 'model/mesh'],\n    ['msl', 'application/vnd.mobius.msl'],\n    ['msty', 'application/vnd.muvee.style'],\n    ['mts', 'model/vnd.mts'],\n    ['mus', 'application/vnd.musician'],\n    ['musicxml', 'application/vnd.recordare.musicxml+xml'],\n    ['mv', 'video/x-sgi-movie'],\n    ['mvb', 'application/x-msmediaview'],\n    ['mwf', 'application/vnd.mfer'],\n    ['mxf', 'application/mxf'],\n    ['mxl', 'application/vnd.recordare.musicxml'],\n    ['mxml', 'application/xv+xml'],\n    ['mxs', 'application/vnd.triscape.mxs'],\n    ['mxu', 'video/vnd.mpegurl'],\n    ['my', 'audio/make'],\n    ['mzz', 'application/x-vnd.audioexplosion.mzz'],\n    ['n-gage', 'application/vnd.nokia.n-gage.symbian.install'],\n    ['n3', 'text/n3'],\n    ['nap', 'image/naplps'],\n    ['naplps', 'image/naplps'],\n    ['nbp', 'application/vnd.wolfram.player'],\n    ['nc', 'application/x-netcdf'],\n    ['ncm', 'application/vnd.nokia.configuration-message'],\n    ['ncx', 'application/x-dtbncx+xml'],\n    ['ngdat', 'application/vnd.nokia.n-gage.data'],\n    ['nif', 'image/x-niff'],\n    ['niff', 'image/x-niff'],\n    ['nix', 'application/x-mix-transfer'],\n    ['nlu', 'application/vnd.neurolanguage.nlu'],\n    ['nml', 'application/vnd.enliven'],\n    ['nnd', 'application/vnd.noblenet-directory'],\n    ['nns', 'application/vnd.noblenet-sealer'],\n    ['nnw', 'application/vnd.noblenet-web'],\n    ['npx', 'image/vnd.net-fpx'],\n    ['nsc', 'application/x-conference'],\n    ['nsf', 'application/vnd.lotus-notes'],\n    ['nvd', 'application/x-navidoc'],\n    ['nws', 'message/rfc822'],\n    ['o', 'application/octet-stream'],\n    ['oa2', 'application/vnd.fujitsu.oasys2'],\n    ['oa3', 'application/vnd.fujitsu.oasys3'],\n    ['oas', 'application/vnd.fujitsu.oasys'],\n    ['obd', 'application/x-msbinder'],\n    ['oda', 'application/oda'],\n    ['odb', 'application/vnd.oasis.opendocument.database'],\n    ['odc', 'application/vnd.oasis.opendocument.chart'],\n    ['odf', 'application/vnd.oasis.opendocument.formula'],\n    ['odft', 'application/vnd.oasis.opendocument.formula-template'],\n    ['odg', 'application/vnd.oasis.opendocument.graphics'],\n    ['odi', 'application/vnd.oasis.opendocument.image'],\n    ['odm', 'application/vnd.oasis.opendocument.text-master'],\n    ['odp', 'application/vnd.oasis.opendocument.presentation'],\n    ['ods', 'application/vnd.oasis.opendocument.spreadsheet'],\n    ['odt', 'application/vnd.oasis.opendocument.text'],\n    ['oga', 'audio/ogg'],\n    ['ogv', 'video/ogg'],\n    ['ogx', 'application/ogg'],\n    ['omc', 'application/x-omc'],\n    ['omcd', 'application/x-omcdatamaker'],\n    ['omcr', 'application/x-omcregerator'],\n    ['onetoc', 'application/onenote'],\n    ['opf', 'application/oebps-package+xml'],\n    ['org', 'application/vnd.lotus-organizer'],\n    ['osf', 'application/vnd.yamaha.openscoreformat'],\n    ['osfpvg', 'application/vnd.yamaha.openscoreformat.osfpvg+xml'],\n    ['otc', 'application/vnd.oasis.opendocument.chart-template'],\n    ['otf', 'application/x-font-otf'],\n    ['otg', 'application/vnd.oasis.opendocument.graphics-template'],\n    ['oth', 'application/vnd.oasis.opendocument.text-web'],\n    ['oti', 'application/vnd.oasis.opendocument.image-template'],\n    ['otp', 'application/vnd.oasis.opendocument.presentation-template'],\n    ['ots', 'application/vnd.oasis.opendocument.spreadsheet-template'],\n    ['ott', 'application/vnd.oasis.opendocument.text-template'],\n    ['oxt', 'application/vnd.openofficeorg.extension'],\n    ['p', 'text/x-pascal'],\n    ['p10', ['application/pkcs10', 'application/x-pkcs10']],\n    ['p12', ['application/pkcs-12', 'application/x-pkcs12']],\n    ['p7a', 'application/x-pkcs7-signature'],\n    ['p7b', 'application/x-pkcs7-certificates'],\n    ['p7c', ['application/pkcs7-mime', 'application/x-pkcs7-mime']],\n    ['p7m', ['application/pkcs7-mime', 'application/x-pkcs7-mime']],\n    ['p7r', 'application/x-pkcs7-certreqresp'],\n    ['p7s', ['application/pkcs7-signature', 'application/x-pkcs7-signature']],\n    ['p8', 'application/pkcs8'],\n    ['par', 'text/plain-bas'],\n    ['part', 'application/pro_eng'],\n    ['pas', 'text/pascal'],\n    ['paw', 'application/vnd.pawaafile'],\n    ['pbd', 'application/vnd.powerbuilder6'],\n    ['pbm', 'image/x-portable-bitmap'],\n    ['pcf', 'application/x-font-pcf'],\n    ['pcl', ['application/vnd.hp-pcl', 'application/x-pcl']],\n    ['pclxl', 'application/vnd.hp-pclxl'],\n    ['pct', 'image/x-pict'],\n    ['pcurl', 'application/vnd.curl.pcurl'],\n    ['pcx', 'image/x-pcx'],\n    ['pdb', ['application/vnd.palm', 'chemical/x-pdb']],\n    ['pdf', 'application/pdf'],\n    ['pfa', 'application/x-font-type1'],\n    ['pfr', 'application/font-tdpfr'],\n    ['pfunk', ['audio/make', 'audio/make.my.funk']],\n    ['pfx', 'application/x-pkcs12'],\n    ['pgm', ['image/x-portable-graymap', 'image/x-portable-greymap']],\n    ['pgn', 'application/x-chess-pgn'],\n    ['pgp', 'application/pgp-signature'],\n    ['pic', ['image/pict', 'image/x-pict']],\n    ['pict', 'image/pict'],\n    ['pkg', 'application/x-newton-compatible-pkg'],\n    ['pki', 'application/pkixcmp'],\n    ['pkipath', 'application/pkix-pkipath'],\n    ['pko', ['application/ynd.ms-pkipko', 'application/vnd.ms-pki.pko']],\n    ['pl', ['text/plain', 'text/x-script.perl']],\n    ['plb', 'application/vnd.3gpp.pic-bw-large'],\n    ['plc', 'application/vnd.mobius.plc'],\n    ['plf', 'application/vnd.pocketlearn'],\n    ['pls', 'application/pls+xml'],\n    ['plx', 'application/x-pixclscript'],\n    ['pm', ['text/x-script.perl-module', 'image/x-xpixmap']],\n    ['pm4', 'application/x-pagemaker'],\n    ['pm5', 'application/x-pagemaker'],\n    ['pma', 'application/x-perfmon'],\n    ['pmc', 'application/x-perfmon'],\n    ['pml', ['application/vnd.ctc-posml', 'application/x-perfmon']],\n    ['pmr', 'application/x-perfmon'],\n    ['pmw', 'application/x-perfmon'],\n    ['png', 'image/png'],\n    ['pnm', ['application/x-portable-anymap', 'image/x-portable-anymap']],\n    ['portpkg', 'application/vnd.macports.portpkg'],\n    ['pot', ['application/vnd.ms-powerpoint', 'application/mspowerpoint']],\n    ['potm', 'application/vnd.ms-powerpoint.template.macroenabled.12'],\n    ['potx', 'application/vnd.openxmlformats-officedocument.presentationml.template'],\n    ['pov', 'model/x-pov'],\n    ['ppa', 'application/vnd.ms-powerpoint'],\n    ['ppam', 'application/vnd.ms-powerpoint.addin.macroenabled.12'],\n    ['ppd', 'application/vnd.cups-ppd'],\n    ['ppm', 'image/x-portable-pixmap'],\n    ['pps', ['application/vnd.ms-powerpoint', 'application/mspowerpoint']],\n    ['ppsm', 'application/vnd.ms-powerpoint.slideshow.macroenabled.12'],\n    ['ppsx', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow'],\n    ['ppt', ['application/vnd.ms-powerpoint', 'application/mspowerpoint', 'application/powerpoint', 'application/x-mspowerpoint']],\n    ['pptm', 'application/vnd.ms-powerpoint.presentation.macroenabled.12'],\n    ['pptx', 'application/vnd.openxmlformats-officedocument.presentationml.presentation'],\n    ['ppz', 'application/mspowerpoint'],\n    ['prc', 'application/x-mobipocket-ebook'],\n    ['pre', ['application/vnd.lotus-freelance', 'application/x-freelance']],\n    ['prf', 'application/pics-rules'],\n    ['prt', 'application/pro_eng'],\n    ['ps', 'application/postscript'],\n    ['psb', 'application/vnd.3gpp.pic-bw-small'],\n    ['psd', ['application/octet-stream', 'image/vnd.adobe.photoshop']],\n    ['psf', 'application/x-font-linux-psf'],\n    ['pskcxml', 'application/pskc+xml'],\n    ['ptid', 'application/vnd.pvi.ptid1'],\n    ['pub', 'application/x-mspublisher'],\n    ['pvb', 'application/vnd.3gpp.pic-bw-var'],\n    ['pvu', 'paleovu/x-pv'],\n    ['pwn', 'application/vnd.3m.post-it-notes'],\n    ['pwz', 'application/vnd.ms-powerpoint'],\n    ['py', 'text/x-script.phyton'],\n    ['pya', 'audio/vnd.ms-playready.media.pya'],\n    ['pyc', 'application/x-bytecode.python'],\n    ['pyv', 'video/vnd.ms-playready.media.pyv'],\n    ['qam', 'application/vnd.epson.quickanime'],\n    ['qbo', 'application/vnd.intu.qbo'],\n    ['qcp', 'audio/vnd.qcelp'],\n    ['qd3', 'x-world/x-3dmf'],\n    ['qd3d', 'x-world/x-3dmf'],\n    ['qfx', 'application/vnd.intu.qfx'],\n    ['qif', 'image/x-quicktime'],\n    ['qps', 'application/vnd.publishare-delta-tree'],\n    ['qt', 'video/quicktime'],\n    ['qtc', 'video/x-qtc'],\n    ['qti', 'image/x-quicktime'],\n    ['qtif', 'image/x-quicktime'],\n    ['qxd', 'application/vnd.quark.quarkxpress'],\n    ['ra', ['audio/x-realaudio', 'audio/x-pn-realaudio', 'audio/x-pn-realaudio-plugin']],\n    ['ram', 'audio/x-pn-realaudio'],\n    ['rar', 'application/x-rar-compressed'],\n    ['ras', ['image/cmu-raster', 'application/x-cmu-raster', 'image/x-cmu-raster']],\n    ['rast', 'image/cmu-raster'],\n    ['rcprofile', 'application/vnd.ipunplugged.rcprofile'],\n    ['rdf', 'application/rdf+xml'],\n    ['rdz', 'application/vnd.data-vision.rdz'],\n    ['rep', 'application/vnd.businessobjects'],\n    ['res', 'application/x-dtbresource+xml'],\n    ['rexx', 'text/x-script.rexx'],\n    ['rf', 'image/vnd.rn-realflash'],\n    ['rgb', 'image/x-rgb'],\n    ['rif', 'application/reginfo+xml'],\n    ['rip', 'audio/vnd.rip'],\n    ['rl', 'application/resource-lists+xml'],\n    ['rlc', 'image/vnd.fujixerox.edmics-rlc'],\n    ['rld', 'application/resource-lists-diff+xml'],\n    ['rm', ['application/vnd.rn-realmedia', 'audio/x-pn-realaudio']],\n    ['rmi', 'audio/mid'],\n    ['rmm', 'audio/x-pn-realaudio'],\n    ['rmp', ['audio/x-pn-realaudio-plugin', 'audio/x-pn-realaudio']],\n    ['rms', 'application/vnd.jcp.javame.midlet-rms'],\n    ['rnc', 'application/relax-ng-compact-syntax'],\n    ['rng', ['application/ringing-tones', 'application/vnd.nokia.ringing-tone']],\n    ['rnx', 'application/vnd.rn-realplayer'],\n    ['roff', 'application/x-troff'],\n    ['rp', 'image/vnd.rn-realpix'],\n    ['rp9', 'application/vnd.cloanto.rp9'],\n    ['rpm', 'audio/x-pn-realaudio-plugin'],\n    ['rpss', 'application/vnd.nokia.radio-presets'],\n    ['rpst', 'application/vnd.nokia.radio-preset'],\n    ['rq', 'application/sparql-query'],\n    ['rs', 'application/rls-services+xml'],\n    ['rsd', 'application/rsd+xml'],\n    ['rt', ['text/richtext', 'text/vnd.rn-realtext']],\n    ['rtf', ['application/rtf', 'text/richtext', 'application/x-rtf']],\n    ['rtx', ['text/richtext', 'application/rtf']],\n    ['rv', 'video/vnd.rn-realvideo'],\n    ['s', 'text/x-asm'],\n    ['s3m', 'audio/s3m'],\n    ['saf', 'application/vnd.yamaha.smaf-audio'],\n    ['saveme', 'application/octet-stream'],\n    ['sbk', 'application/x-tbook'],\n    ['sbml', 'application/sbml+xml'],\n    ['sc', 'application/vnd.ibm.secure-container'],\n    ['scd', 'application/x-msschedule'],\n    [\n        'scm',\n        ['application/vnd.lotus-screencam', 'video/x-scm', 'text/x-script.guile', 'application/x-lotusscreencam', 'text/x-script.scheme']\n    ],\n    ['scq', 'application/scvp-cv-request'],\n    ['scs', 'application/scvp-cv-response'],\n    ['sct', 'text/scriptlet'],\n    ['scurl', 'text/vnd.curl.scurl'],\n    ['sda', 'application/vnd.stardivision.draw'],\n    ['sdc', 'application/vnd.stardivision.calc'],\n    ['sdd', 'application/vnd.stardivision.impress'],\n    ['sdkm', 'application/vnd.solent.sdkm+xml'],\n    ['sdml', 'text/plain'],\n    ['sdp', ['application/sdp', 'application/x-sdp']],\n    ['sdr', 'application/sounder'],\n    ['sdw', 'application/vnd.stardivision.writer'],\n    ['sea', ['application/sea', 'application/x-sea']],\n    ['see', 'application/vnd.seemail'],\n    ['seed', 'application/vnd.fdsn.seed'],\n    ['sema', 'application/vnd.sema'],\n    ['semd', 'application/vnd.semd'],\n    ['semf', 'application/vnd.semf'],\n    ['ser', 'application/java-serialized-object'],\n    ['set', 'application/set'],\n    ['setpay', 'application/set-payment-initiation'],\n    ['setreg', 'application/set-registration-initiation'],\n    ['sfd-hdstx', 'application/vnd.hydrostatix.sof-data'],\n    ['sfs', 'application/vnd.spotfire.sfs'],\n    ['sgl', 'application/vnd.stardivision.writer-global'],\n    ['sgm', ['text/sgml', 'text/x-sgml']],\n    ['sgml', ['text/sgml', 'text/x-sgml']],\n    ['sh', ['application/x-shar', 'application/x-bsh', 'application/x-sh', 'text/x-script.sh']],\n    ['shar', ['application/x-bsh', 'application/x-shar']],\n    ['shf', 'application/shf+xml'],\n    ['shtml', ['text/html', 'text/x-server-parsed-html']],\n    ['sid', 'audio/x-psid'],\n    ['sis', 'application/vnd.symbian.install'],\n    ['sit', ['application/x-stuffit', 'application/x-sit']],\n    ['sitx', 'application/x-stuffitx'],\n    ['skd', 'application/x-koan'],\n    ['skm', 'application/x-koan'],\n    ['skp', ['application/vnd.koan', 'application/x-koan']],\n    ['skt', 'application/x-koan'],\n    ['sl', 'application/x-seelogo'],\n    ['sldm', 'application/vnd.ms-powerpoint.slide.macroenabled.12'],\n    ['sldx', 'application/vnd.openxmlformats-officedocument.presentationml.slide'],\n    ['slt', 'application/vnd.epson.salt'],\n    ['sm', 'application/vnd.stepmania.stepchart'],\n    ['smf', 'application/vnd.stardivision.math'],\n    ['smi', ['application/smil', 'application/smil+xml']],\n    ['smil', 'application/smil'],\n    ['snd', ['audio/basic', 'audio/x-adpcm']],\n    ['snf', 'application/x-font-snf'],\n    ['sol', 'application/solids'],\n    ['spc', ['text/x-speech', 'application/x-pkcs7-certificates']],\n    ['spf', 'application/vnd.yamaha.smaf-phrase'],\n    ['spl', ['application/futuresplash', 'application/x-futuresplash']],\n    ['spot', 'text/vnd.in3d.spot'],\n    ['spp', 'application/scvp-vp-response'],\n    ['spq', 'application/scvp-vp-request'],\n    ['spr', 'application/x-sprite'],\n    ['sprite', 'application/x-sprite'],\n    ['src', 'application/x-wais-source'],\n    ['sru', 'application/sru+xml'],\n    ['srx', 'application/sparql-results+xml'],\n    ['sse', 'application/vnd.kodak-descriptor'],\n    ['ssf', 'application/vnd.epson.ssf'],\n    ['ssi', 'text/x-server-parsed-html'],\n    ['ssm', 'application/streamingmedia'],\n    ['ssml', 'application/ssml+xml'],\n    ['sst', ['application/vnd.ms-pkicertstore', 'application/vnd.ms-pki.certstore']],\n    ['st', 'application/vnd.sailingtracker.track'],\n    ['stc', 'application/vnd.sun.xml.calc.template'],\n    ['std', 'application/vnd.sun.xml.draw.template'],\n    ['step', 'application/step'],\n    ['stf', 'application/vnd.wt.stf'],\n    ['sti', 'application/vnd.sun.xml.impress.template'],\n    ['stk', 'application/hyperstudio'],\n    ['stl', ['application/vnd.ms-pkistl', 'application/sla', 'application/vnd.ms-pki.stl', 'application/x-navistyle']],\n    ['stm', 'text/html'],\n    ['stp', 'application/step'],\n    ['str', 'application/vnd.pg.format'],\n    ['stw', 'application/vnd.sun.xml.writer.template'],\n    ['sub', 'image/vnd.dvb.subtitle'],\n    ['sus', 'application/vnd.sus-calendar'],\n    ['sv4cpio', 'application/x-sv4cpio'],\n    ['sv4crc', 'application/x-sv4crc'],\n    ['svc', 'application/vnd.dvb.service'],\n    ['svd', 'application/vnd.svd'],\n    ['svf', ['image/vnd.dwg', 'image/x-dwg']],\n    ['svg', 'image/svg+xml'],\n    ['svr', ['x-world/x-svr', 'application/x-world']],\n    ['swf', 'application/x-shockwave-flash'],\n    ['swi', 'application/vnd.aristanetworks.swi'],\n    ['sxc', 'application/vnd.sun.xml.calc'],\n    ['sxd', 'application/vnd.sun.xml.draw'],\n    ['sxg', 'application/vnd.sun.xml.writer.global'],\n    ['sxi', 'application/vnd.sun.xml.impress'],\n    ['sxm', 'application/vnd.sun.xml.math'],\n    ['sxw', 'application/vnd.sun.xml.writer'],\n    ['t', ['text/troff', 'application/x-troff']],\n    ['talk', 'text/x-speech'],\n    ['tao', 'application/vnd.tao.intent-module-archive'],\n    ['tar', 'application/x-tar'],\n    ['tbk', ['application/toolbook', 'application/x-tbook']],\n    ['tcap', 'application/vnd.3gpp2.tcap'],\n    ['tcl', ['text/x-script.tcl', 'application/x-tcl']],\n    ['tcsh', 'text/x-script.tcsh'],\n    ['teacher', 'application/vnd.smart.teacher'],\n    ['tei', 'application/tei+xml'],\n    ['tex', 'application/x-tex'],\n    ['texi', 'application/x-texinfo'],\n    ['texinfo', 'application/x-texinfo'],\n    ['text', ['application/plain', 'text/plain']],\n    ['tfi', 'application/thraud+xml'],\n    ['tfm', 'application/x-tex-tfm'],\n    ['tgz', ['application/gnutar', 'application/x-compressed']],\n    ['thmx', 'application/vnd.ms-officetheme'],\n    ['tif', ['image/tiff', 'image/x-tiff']],\n    ['tiff', ['image/tiff', 'image/x-tiff']],\n    ['tmo', 'application/vnd.tmobile-livetv'],\n    ['torrent', 'application/x-bittorrent'],\n    ['tpl', 'application/vnd.groove-tool-template'],\n    ['tpt', 'application/vnd.trid.tpt'],\n    ['tr', 'application/x-troff'],\n    ['tra', 'application/vnd.trueapp'],\n    ['trm', 'application/x-msterminal'],\n    ['tsd', 'application/timestamped-data'],\n    ['tsi', 'audio/tsp-audio'],\n    ['tsp', ['application/dsptype', 'audio/tsplayer']],\n    ['tsv', 'text/tab-separated-values'],\n    ['ttf', 'application/x-font-ttf'],\n    ['ttl', 'text/turtle'],\n    ['turbot', 'image/florian'],\n    ['twd', 'application/vnd.simtech-mindmapper'],\n    ['txd', 'application/vnd.genomatix.tuxedo'],\n    ['txf', 'application/vnd.mobius.txf'],\n    ['txt', 'text/plain'],\n    ['ufd', 'application/vnd.ufdl'],\n    ['uil', 'text/x-uil'],\n    ['uls', 'text/iuls'],\n    ['umj', 'application/vnd.umajin'],\n    ['uni', 'text/uri-list'],\n    ['unis', 'text/uri-list'],\n    ['unityweb', 'application/vnd.unity'],\n    ['unv', 'application/i-deas'],\n    ['uoml', 'application/vnd.uoml+xml'],\n    ['uri', 'text/uri-list'],\n    ['uris', 'text/uri-list'],\n    ['ustar', ['application/x-ustar', 'multipart/x-ustar']],\n    ['utz', 'application/vnd.uiq.theme'],\n    ['uu', ['application/octet-stream', 'text/x-uuencode']],\n    ['uue', 'text/x-uuencode'],\n    ['uva', 'audio/vnd.dece.audio'],\n    ['uvh', 'video/vnd.dece.hd'],\n    ['uvi', 'image/vnd.dece.graphic'],\n    ['uvm', 'video/vnd.dece.mobile'],\n    ['uvp', 'video/vnd.dece.pd'],\n    ['uvs', 'video/vnd.dece.sd'],\n    ['uvu', 'video/vnd.uvvu.mp4'],\n    ['uvv', 'video/vnd.dece.video'],\n    ['vcd', 'application/x-cdlink'],\n    ['vcf', 'text/x-vcard'],\n    ['vcg', 'application/vnd.groove-vcard'],\n    ['vcs', 'text/x-vcalendar'],\n    ['vcx', 'application/vnd.vcx'],\n    ['vda', 'application/vda'],\n    ['vdo', 'video/vdo'],\n    ['vew', 'application/groupwise'],\n    ['vis', 'application/vnd.visionary'],\n    ['viv', ['video/vivo', 'video/vnd.vivo']],\n    ['vivo', ['video/vivo', 'video/vnd.vivo']],\n    ['vmd', 'application/vocaltec-media-desc'],\n    ['vmf', 'application/vocaltec-media-file'],\n    ['voc', ['audio/voc', 'audio/x-voc']],\n    ['vos', 'video/vosaic'],\n    ['vox', 'audio/voxware'],\n    ['vqe', 'audio/x-twinvq-plugin'],\n    ['vqf', 'audio/x-twinvq'],\n    ['vql', 'audio/x-twinvq-plugin'],\n    ['vrml', ['model/vrml', 'x-world/x-vrml', 'application/x-vrml']],\n    ['vrt', 'x-world/x-vrt'],\n    ['vsd', ['application/vnd.visio', 'application/x-visio']],\n    ['vsf', 'application/vnd.vsf'],\n    ['vst', 'application/x-visio'],\n    ['vsw', 'application/x-visio'],\n    ['vtu', 'model/vnd.vtu'],\n    ['vxml', 'application/voicexml+xml'],\n    ['w60', 'application/wordperfect6.0'],\n    ['w61', 'application/wordperfect6.1'],\n    ['w6w', 'application/msword'],\n    ['wad', 'application/x-doom'],\n    ['wav', ['audio/wav', 'audio/x-wav']],\n    ['wax', 'audio/x-ms-wax'],\n    ['wb1', 'application/x-qpro'],\n    ['wbmp', 'image/vnd.wap.wbmp'],\n    ['wbs', 'application/vnd.criticaltools.wbs+xml'],\n    ['wbxml', 'application/vnd.wap.wbxml'],\n    ['wcm', 'application/vnd.ms-works'],\n    ['wdb', 'application/vnd.ms-works'],\n    ['web', 'application/vnd.xara'],\n    ['weba', 'audio/webm'],\n    ['webm', 'video/webm'],\n    ['webp', 'image/webp'],\n    ['wg', 'application/vnd.pmi.widget'],\n    ['wgt', 'application/widget'],\n    ['wiz', 'application/msword'],\n    ['wk1', 'application/x-123'],\n    ['wks', 'application/vnd.ms-works'],\n    ['wm', 'video/x-ms-wm'],\n    ['wma', 'audio/x-ms-wma'],\n    ['wmd', 'application/x-ms-wmd'],\n    ['wmf', ['windows/metafile', 'application/x-msmetafile']],\n    ['wml', 'text/vnd.wap.wml'],\n    ['wmlc', 'application/vnd.wap.wmlc'],\n    ['wmls', 'text/vnd.wap.wmlscript'],\n    ['wmlsc', 'application/vnd.wap.wmlscriptc'],\n    ['wmv', 'video/x-ms-wmv'],\n    ['wmx', 'video/x-ms-wmx'],\n    ['wmz', 'application/x-ms-wmz'],\n    ['woff', 'application/x-font-woff'],\n    ['word', 'application/msword'],\n    ['wp', 'application/wordperfect'],\n    ['wp5', ['application/wordperfect', 'application/wordperfect6.0']],\n    ['wp6', 'application/wordperfect'],\n    ['wpd', ['application/wordperfect', 'application/vnd.wordperfect', 'application/x-wpwin']],\n    ['wpl', 'application/vnd.ms-wpl'],\n    ['wps', 'application/vnd.ms-works'],\n    ['wq1', 'application/x-lotus'],\n    ['wqd', 'application/vnd.wqd'],\n    ['wri', ['application/mswrite', 'application/x-wri', 'application/x-mswrite']],\n    ['wrl', ['model/vrml', 'x-world/x-vrml', 'application/x-world']],\n    ['wrz', ['model/vrml', 'x-world/x-vrml']],\n    ['wsc', 'text/scriplet'],\n    ['wsdl', 'application/wsdl+xml'],\n    ['wspolicy', 'application/wspolicy+xml'],\n    ['wsrc', 'application/x-wais-source'],\n    ['wtb', 'application/vnd.webturbo'],\n    ['wtk', 'application/x-wintalk'],\n    ['wvx', 'video/x-ms-wvx'],\n    ['x-png', 'image/png'],\n    ['x3d', 'application/vnd.hzn-3d-crossword'],\n    ['xaf', 'x-world/x-vrml'],\n    ['xap', 'application/x-silverlight-app'],\n    ['xar', 'application/vnd.xara'],\n    ['xbap', 'application/x-ms-xbap'],\n    ['xbd', 'application/vnd.fujixerox.docuworks.binder'],\n    ['xbm', ['image/xbm', 'image/x-xbm', 'image/x-xbitmap']],\n    ['xdf', 'application/xcap-diff+xml'],\n    ['xdm', 'application/vnd.syncml.dm+xml'],\n    ['xdp', 'application/vnd.adobe.xdp+xml'],\n    ['xdr', 'video/x-amt-demorun'],\n    ['xdssc', 'application/dssc+xml'],\n    ['xdw', 'application/vnd.fujixerox.docuworks'],\n    ['xenc', 'application/xenc+xml'],\n    ['xer', 'application/patch-ops-error+xml'],\n    ['xfdf', 'application/vnd.adobe.xfdf'],\n    ['xfdl', 'application/vnd.xfdl'],\n    ['xgz', 'xgl/drawing'],\n    ['xhtml', 'application/xhtml+xml'],\n    ['xif', 'image/vnd.xiff'],\n    ['xl', 'application/excel'],\n    ['xla', ['application/vnd.ms-excel', 'application/excel', 'application/x-msexcel', 'application/x-excel']],\n    ['xlam', 'application/vnd.ms-excel.addin.macroenabled.12'],\n    ['xlb', ['application/excel', 'application/vnd.ms-excel', 'application/x-excel']],\n    ['xlc', ['application/vnd.ms-excel', 'application/excel', 'application/x-excel']],\n    ['xld', ['application/excel', 'application/x-excel']],\n    ['xlk', ['application/excel', 'application/x-excel']],\n    ['xll', ['application/excel', 'application/vnd.ms-excel', 'application/x-excel']],\n    ['xlm', ['application/vnd.ms-excel', 'application/excel', 'application/x-excel']],\n    ['xls', ['application/vnd.ms-excel', 'application/excel', 'application/x-msexcel', 'application/x-excel']],\n    ['xlsb', 'application/vnd.ms-excel.sheet.binary.macroenabled.12'],\n    ['xlsm', 'application/vnd.ms-excel.sheet.macroenabled.12'],\n    ['xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'],\n    ['xlt', ['application/vnd.ms-excel', 'application/excel', 'application/x-excel']],\n    ['xltm', 'application/vnd.ms-excel.template.macroenabled.12'],\n    ['xltx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'],\n    ['xlv', ['application/excel', 'application/x-excel']],\n    ['xlw', ['application/vnd.ms-excel', 'application/excel', 'application/x-msexcel', 'application/x-excel']],\n    ['xm', 'audio/xm'],\n    ['xml', ['application/xml', 'text/xml', 'application/atom+xml', 'application/rss+xml']],\n    ['xmz', 'xgl/movie'],\n    ['xo', 'application/vnd.olpc-sugar'],\n    ['xof', 'x-world/x-vrml'],\n    ['xop', 'application/xop+xml'],\n    ['xpi', 'application/x-xpinstall'],\n    ['xpix', 'application/x-vnd.ls-xpix'],\n    ['xpm', ['image/xpm', 'image/x-xpixmap']],\n    ['xpr', 'application/vnd.is-xpr'],\n    ['xps', 'application/vnd.ms-xpsdocument'],\n    ['xpw', 'application/vnd.intercon.formnet'],\n    ['xslt', 'application/xslt+xml'],\n    ['xsm', 'application/vnd.syncml+xml'],\n    ['xspf', 'application/xspf+xml'],\n    ['xsr', 'video/x-amt-showrun'],\n    ['xul', 'application/vnd.mozilla.xul+xml'],\n    ['xwd', ['image/x-xwd', 'image/x-xwindowdump']],\n    ['xyz', ['chemical/x-xyz', 'chemical/x-pdb']],\n    ['yang', 'application/yang'],\n    ['yin', 'application/yin+xml'],\n    ['z', ['application/x-compressed', 'application/x-compress']],\n    ['zaz', 'application/vnd.zzazz.deck+xml'],\n    ['zip', ['application/zip', 'multipart/x-zip', 'application/x-zip-compressed', 'application/x-compressed']],\n    ['zir', 'application/vnd.zul'],\n    ['zmm', 'application/vnd.handheld-entertainment+xml'],\n    ['zoo', 'application/octet-stream'],\n    ['zsh', 'text/x-script.zsh']\n]);\n\nmodule.exports = {\n    detectMimeType(filename) {\n        if (!filename) {\n            return defaultMimeType;\n        }\n\n        let parsed = path.parse(filename);\n        let extension = (parsed.ext.substr(1) || parsed.name || '').split('?').shift().trim().toLowerCase();\n        let value = defaultMimeType;\n\n        if (extensions.has(extension)) {\n            value = extensions.get(extension);\n        }\n\n        if (Array.isArray(value)) {\n            return value[0];\n        }\n        return value;\n    },\n\n    detectExtension(mimeType) {\n        if (!mimeType) {\n            return defaultExtension;\n        }\n        let parts = (mimeType || '').toLowerCase().trim().split('/');\n        let rootType = parts.shift().trim();\n        let subType = parts.join('/').trim();\n\n        if (mimeTypes.has(rootType + '/' + subType)) {\n            let value = mimeTypes.get(rootType + '/' + subType);\n            if (Array.isArray(value)) {\n                return value[0];\n            }\n            return value;\n        }\n\n        switch (rootType) {\n            case 'text':\n                return 'txt';\n            default:\n                return 'bin';\n        }\n    }\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvbWltZS1mdW5jcy9taW1lLXR5cGVzLmpzIiwibWFwcGluZ3MiOiJBQUFBOztBQUVhOztBQUViLGFBQWEsbUJBQU8sQ0FBQyxrQkFBTTs7QUFFM0I7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLOztBQUVMO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL2h4Y2tlci9EZXNrdG9wL2JldC9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvbWltZS1mdW5jcy9taW1lLXR5cGVzLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludCBxdW90ZS1wcm9wczogMCAqL1xuXG4ndXNlIHN0cmljdCc7XG5cbmNvbnN0IHBhdGggPSByZXF1aXJlKCdwYXRoJyk7XG5cbmNvbnN0IGRlZmF1bHRNaW1lVHlwZSA9ICdhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nO1xuY29uc3QgZGVmYXVsdEV4dGVuc2lvbiA9ICdiaW4nO1xuXG5jb25zdCBtaW1lVHlwZXMgPSBuZXcgTWFwKFtcbiAgICBbJ2FwcGxpY2F0aW9uL2FjYWQnLCAnZHdnJ10sXG4gICAgWydhcHBsaWNhdGlvbi9hcHBsaXh3YXJlJywgJ2F3J10sXG4gICAgWydhcHBsaWNhdGlvbi9hcmonLCAnYXJqJ10sXG4gICAgWydhcHBsaWNhdGlvbi9hdG9tK3htbCcsICd4bWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2F0b21jYXQreG1sJywgJ2F0b21jYXQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2F0b21zdmMreG1sJywgJ2F0b21zdmMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2Jhc2U2NCcsIFsnbW0nLCAnbW1lJ11dLFxuICAgIFsnYXBwbGljYXRpb24vYmluaGV4JywgJ2hxeCddLFxuICAgIFsnYXBwbGljYXRpb24vYmluaGV4NCcsICdocXgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2Jvb2snLCBbJ2Jvb2snLCAnYm9vJ11dLFxuICAgIFsnYXBwbGljYXRpb24vY2N4bWwreG1sLCcsICdjY3htbCddLFxuICAgIFsnYXBwbGljYXRpb24vY2RmJywgJ2NkZiddLFxuICAgIFsnYXBwbGljYXRpb24vY2RtaS1jYXBhYmlsaXR5JywgJ2NkbWlhJ10sXG4gICAgWydhcHBsaWNhdGlvbi9jZG1pLWNvbnRhaW5lcicsICdjZG1pYyddLFxuICAgIFsnYXBwbGljYXRpb24vY2RtaS1kb21haW4nLCAnY2RtaWQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2NkbWktb2JqZWN0JywgJ2NkbWlvJ10sXG4gICAgWydhcHBsaWNhdGlvbi9jZG1pLXF1ZXVlJywgJ2NkbWlxJ10sXG4gICAgWydhcHBsaWNhdGlvbi9jbGFyaXNjYWQnLCAnY2NhZCddLFxuICAgIFsnYXBwbGljYXRpb24vY29tbW9uZ3JvdW5kJywgJ2RwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9jdS1zZWVtZScsICdjdSddLFxuICAgIFsnYXBwbGljYXRpb24vZGF2bW91bnQreG1sJywgJ2Rhdm1vdW50J10sXG4gICAgWydhcHBsaWNhdGlvbi9kcmFmdGluZycsICdkcncnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2RzcHR5cGUnLCAndHNwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9kc3NjK2RlcicsICdkc3NjJ10sXG4gICAgWydhcHBsaWNhdGlvbi9kc3NjK3htbCcsICd4ZHNzYyddLFxuICAgIFsnYXBwbGljYXRpb24vZHhmJywgJ2R4ZiddLFxuICAgIFsnYXBwbGljYXRpb24vZWNtYXNjcmlwdCcsIFsnanMnLCAnZXMnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9lbW1hK3htbCcsICdlbW1hJ10sXG4gICAgWydhcHBsaWNhdGlvbi9lbnZveScsICdldnknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2VwdWIremlwJywgJ2VwdWInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2V4Y2VsJywgWyd4bHMnLCAneGwnLCAneGxhJywgJ3hsYicsICd4bGMnLCAneGxkJywgJ3hsaycsICd4bGwnLCAneGxtJywgJ3hsdCcsICd4bHYnLCAneGx3J11dLFxuICAgIFsnYXBwbGljYXRpb24vZXhpJywgJ2V4aSddLFxuICAgIFsnYXBwbGljYXRpb24vZm9udC10ZHBmcicsICdwZnInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2ZyYWN0YWxzJywgJ2ZpZiddLFxuICAgIFsnYXBwbGljYXRpb24vZnJlZWxvYWRlcicsICdmcmwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2Z1dHVyZXNwbGFzaCcsICdzcGwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2dlbytqc29uJywgJ2dlb2pzb24nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2dudXRhcicsICd0Z3onXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2dyb3Vwd2lzZScsICd2ZXcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2hscCcsICdobHAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2h0YScsICdodGEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2h5cGVyc3R1ZGlvJywgJ3N0ayddLFxuICAgIFsnYXBwbGljYXRpb24vaS1kZWFzJywgJ3VudiddLFxuICAgIFsnYXBwbGljYXRpb24vaWdlcycsIFsnaWdlcycsICdpZ3MnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9pbmYnLCAnaW5mJ10sXG4gICAgWydhcHBsaWNhdGlvbi9pbnRlcm5ldC1wcm9wZXJ0eS1zdHJlYW0nLCAnYWN4J10sXG4gICAgWydhcHBsaWNhdGlvbi9pcGZpeCcsICdpcGZpeCddLFxuICAgIFsnYXBwbGljYXRpb24vamF2YScsICdjbGFzcyddLFxuICAgIFsnYXBwbGljYXRpb24vamF2YS1hcmNoaXZlJywgJ2phciddLFxuICAgIFsnYXBwbGljYXRpb24vamF2YS1ieXRlLWNvZGUnLCAnY2xhc3MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2phdmEtc2VyaWFsaXplZC1vYmplY3QnLCAnc2VyJ10sXG4gICAgWydhcHBsaWNhdGlvbi9qYXZhLXZtJywgJ2NsYXNzJ10sXG4gICAgWydhcHBsaWNhdGlvbi9qYXZhc2NyaXB0JywgJ2pzJ10sXG4gICAgWydhcHBsaWNhdGlvbi9qc29uJywgJ2pzb24nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2xoYScsICdsaGEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL2x6eCcsICdsengnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL21hYy1iaW5hcnknLCAnYmluJ10sXG4gICAgWydhcHBsaWNhdGlvbi9tYWMtYmluaGV4JywgJ2hxeCddLFxuICAgIFsnYXBwbGljYXRpb24vbWFjLWJpbmhleDQwJywgJ2hxeCddLFxuICAgIFsnYXBwbGljYXRpb24vbWFjLWNvbXBhY3Rwcm8nLCAnY3B0J10sXG4gICAgWydhcHBsaWNhdGlvbi9tYWNiaW5hcnknLCAnYmluJ10sXG4gICAgWydhcHBsaWNhdGlvbi9tYWRzK3htbCcsICdtYWRzJ10sXG4gICAgWydhcHBsaWNhdGlvbi9tYXJjJywgJ21yYyddLFxuICAgIFsnYXBwbGljYXRpb24vbWFyY3htbCt4bWwnLCAnbXJjeCddLFxuICAgIFsnYXBwbGljYXRpb24vbWF0aGVtYXRpY2EnLCAnbWEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL21hdGhtbCt4bWwnLCAnbWF0aG1sJ10sXG4gICAgWydhcHBsaWNhdGlvbi9tYmVkbGV0JywgJ21iZCddLFxuICAgIFsnYXBwbGljYXRpb24vbWJveCcsICdtYm94J10sXG4gICAgWydhcHBsaWNhdGlvbi9tY2FkJywgJ21jZCddLFxuICAgIFsnYXBwbGljYXRpb24vbWVkaWFzZXJ2ZXJjb250cm9sK3htbCcsICdtc2NtbCddLFxuICAgIFsnYXBwbGljYXRpb24vbWV0YWxpbms0K3htbCcsICdtZXRhNCddLFxuICAgIFsnYXBwbGljYXRpb24vbWV0cyt4bWwnLCAnbWV0cyddLFxuICAgIFsnYXBwbGljYXRpb24vbWltZScsICdhcHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL21vZHMreG1sJywgJ21vZHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL21wMjEnLCAnbTIxJ10sXG4gICAgWydhcHBsaWNhdGlvbi9tcDQnLCAnbXA0J10sXG4gICAgWydhcHBsaWNhdGlvbi9tc3Bvd2VycG9pbnQnLCBbJ3BwdCcsICdwb3QnLCAncHBzJywgJ3BweiddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL21zd29yZCcsIFsnZG9jJywgJ2RvdCcsICd3NncnLCAnd2l6JywgJ3dvcmQnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9tc3dyaXRlJywgJ3dyaSddLFxuICAgIFsnYXBwbGljYXRpb24vbXhmJywgJ214ZiddLFxuICAgIFsnYXBwbGljYXRpb24vbmV0bWMnLCAnbWNwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nLCBbJyonXV0sXG4gICAgWydhcHBsaWNhdGlvbi9vZGEnLCAnb2RhJ10sXG4gICAgWydhcHBsaWNhdGlvbi9vZWJwcy1wYWNrYWdlK3htbCcsICdvcGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL29nZycsICdvZ3gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL29sZXNjcmlwdCcsICdheHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL29uZW5vdGUnLCAnb25ldG9jJ10sXG4gICAgWydhcHBsaWNhdGlvbi9wYXRjaC1vcHMtZXJyb3IreG1sJywgJ3hlciddLFxuICAgIFsnYXBwbGljYXRpb24vcGRmJywgJ3BkZiddLFxuICAgIFsnYXBwbGljYXRpb24vcGdwLWVuY3J5cHRlZCcsICdhc2MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3BncC1zaWduYXR1cmUnLCAncGdwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9waWNzLXJ1bGVzJywgJ3ByZiddLFxuICAgIFsnYXBwbGljYXRpb24vcGtjcy0xMicsICdwMTInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3BrY3MtY3JsJywgJ2NybCddLFxuICAgIFsnYXBwbGljYXRpb24vcGtjczEwJywgJ3AxMCddLFxuICAgIFsnYXBwbGljYXRpb24vcGtjczctbWltZScsIFsncDdjJywgJ3A3bSddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3BrY3M3LXNpZ25hdHVyZScsICdwN3MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3BrY3M4JywgJ3A4J10sXG4gICAgWydhcHBsaWNhdGlvbi9wa2l4LWF0dHItY2VydCcsICdhYyddLFxuICAgIFsnYXBwbGljYXRpb24vcGtpeC1jZXJ0JywgWydjZXInLCAnY3J0J11dLFxuICAgIFsnYXBwbGljYXRpb24vcGtpeC1jcmwnLCAnY3JsJ10sXG4gICAgWydhcHBsaWNhdGlvbi9wa2l4LXBraXBhdGgnLCAncGtpcGF0aCddLFxuICAgIFsnYXBwbGljYXRpb24vcGtpeGNtcCcsICdwa2knXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3BsYWluJywgJ3RleHQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3Bscyt4bWwnLCAncGxzJ10sXG4gICAgWydhcHBsaWNhdGlvbi9wb3N0c2NyaXB0JywgWydwcycsICdhaScsICdlcHMnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9wb3dlcnBvaW50JywgJ3BwdCddLFxuICAgIFsnYXBwbGljYXRpb24vcHJvX2VuZycsIFsncGFydCcsICdwcnQnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9wcnMuY3d3JywgJ2N3dyddLFxuICAgIFsnYXBwbGljYXRpb24vcHNrYyt4bWwnLCAncHNrY3htbCddLFxuICAgIFsnYXBwbGljYXRpb24vcmRmK3htbCcsICdyZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3JlZ2luZm8reG1sJywgJ3JpZiddLFxuICAgIFsnYXBwbGljYXRpb24vcmVsYXgtbmctY29tcGFjdC1zeW50YXgnLCAncm5jJ10sXG4gICAgWydhcHBsaWNhdGlvbi9yZXNvdXJjZS1saXN0cyt4bWwnLCAncmwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3Jlc291cmNlLWxpc3RzLWRpZmYreG1sJywgJ3JsZCddLFxuICAgIFsnYXBwbGljYXRpb24vcmluZ2luZy10b25lcycsICdybmcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3Jscy1zZXJ2aWNlcyt4bWwnLCAncnMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3JzZCt4bWwnLCAncnNkJ10sXG4gICAgWydhcHBsaWNhdGlvbi9yc3MreG1sJywgJ3htbCddLFxuICAgIFsnYXBwbGljYXRpb24vcnRmJywgWydydGYnLCAncnR4J11dLFxuICAgIFsnYXBwbGljYXRpb24vc2JtbCt4bWwnLCAnc2JtbCddLFxuICAgIFsnYXBwbGljYXRpb24vc2N2cC1jdi1yZXF1ZXN0JywgJ3NjcSddLFxuICAgIFsnYXBwbGljYXRpb24vc2N2cC1jdi1yZXNwb25zZScsICdzY3MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3NjdnAtdnAtcmVxdWVzdCcsICdzcHEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3NjdnAtdnAtcmVzcG9uc2UnLCAnc3BwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zZHAnLCAnc2RwJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zZWEnLCAnc2VhJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zZXQnLCAnc2V0J10sXG4gICAgWydhcHBsaWNhdGlvbi9zZXQtcGF5bWVudC1pbml0aWF0aW9uJywgJ3NldHBheSddLFxuICAgIFsnYXBwbGljYXRpb24vc2V0LXJlZ2lzdHJhdGlvbi1pbml0aWF0aW9uJywgJ3NldHJlZyddLFxuICAgIFsnYXBwbGljYXRpb24vc2hmK3htbCcsICdzaGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3NsYScsICdzdGwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3NtaWwnLCBbJ3NtaScsICdzbWlsJ11dLFxuICAgIFsnYXBwbGljYXRpb24vc21pbCt4bWwnLCAnc21pJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zb2xpZHMnLCAnc29sJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zb3VuZGVyJywgJ3NkciddLFxuICAgIFsnYXBwbGljYXRpb24vc3BhcnFsLXF1ZXJ5JywgJ3JxJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zcGFycWwtcmVzdWx0cyt4bWwnLCAnc3J4J10sXG4gICAgWydhcHBsaWNhdGlvbi9zcmdzJywgJ2dyYW0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3NyZ3MreG1sJywgJ2dyeG1sJ10sXG4gICAgWydhcHBsaWNhdGlvbi9zcnUreG1sJywgJ3NydSddLFxuICAgIFsnYXBwbGljYXRpb24vc3NtbCt4bWwnLCAnc3NtbCddLFxuICAgIFsnYXBwbGljYXRpb24vc3RlcCcsIFsnc3RlcCcsICdzdHAnXV0sXG4gICAgWydhcHBsaWNhdGlvbi9zdHJlYW1pbmdtZWRpYScsICdzc20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3RlaSt4bWwnLCAndGVpJ10sXG4gICAgWydhcHBsaWNhdGlvbi90aHJhdWQreG1sJywgJ3RmaSddLFxuICAgIFsnYXBwbGljYXRpb24vdGltZXN0YW1wZWQtZGF0YScsICd0c2QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3Rvb2xib29rJywgJ3RiayddLFxuICAgIFsnYXBwbGljYXRpb24vdmRhJywgJ3ZkYSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLjNncHAucGljLWJ3LWxhcmdlJywgJ3BsYiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLjNncHAucGljLWJ3LXNtYWxsJywgJ3BzYiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLjNncHAucGljLWJ3LXZhcicsICdwdmInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC4zZ3BwMi50Y2FwJywgJ3RjYXAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC4zbS5wb3N0LWl0LW5vdGVzJywgJ3B3biddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFjY3BhYy5zaW1wbHkuYXNvJywgJ2FzbyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFjY3BhYy5zaW1wbHkuaW1wJywgJ2ltcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFjdWNvYm9sJywgJ2FjdSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFjdWNvcnAnLCAnYXRjJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuYWRvYmUuYWlyLWFwcGxpY2F0aW9uLWluc3RhbGxlci1wYWNrYWdlK3ppcCcsICdhaXInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hZG9iZS5meHAnLCAnZnhwJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuYWRvYmUueGRwK3htbCcsICd4ZHAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hZG9iZS54ZmRmJywgJ3hmZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5haGVhZC5zcGFjZScsICdhaGVhZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFpcnppcC5maWxlc2VjdXJlLmF6ZicsICdhemYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5haXJ6aXAuZmlsZXNlY3VyZS5henMnLCAnYXpzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuYW1hem9uLmVib29rJywgJ2F6dyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFtZXJpY2FuZHluYW1pY3MuYWNjJywgJ2FjYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmFtaWdhLmFtaScsICdhbWknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hbmRyb2lkLnBhY2thZ2UtYXJjaGl2ZScsICdhcGsnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hbnNlci13ZWItY2VydGlmaWNhdGUtaXNzdWUtaW5pdGlhdGlvbicsICdjaWknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hbnNlci13ZWItZnVuZHMtdHJhbnNmZXItaW5pdGlhdGlvbicsICdmdGknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hbnRpeC5nYW1lLWNvbXBvbmVudCcsICdhdHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hcHBsZS5pbnN0YWxsZXIreG1sJywgJ21wa2cnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hcHBsZS5tcGVndXJsJywgJ20zdTgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5hcmlzdGFuZXR3b3Jrcy5zd2knLCAnc3dpJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuYXVkaW9ncmFwaCcsICdhZXAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ibHVlaWNlLm11bHRpcGFzcycsICdtcG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ibWknLCAnYm1pJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuYnVzaW5lc3NvYmplY3RzJywgJ3JlcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNoZW1kcmF3K3htbCcsICdjZHhtbCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNoaXBudXRzLmthcmFva2UtbW1kJywgJ21tZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNpbmRlcmVsbGEnLCAnY2R5J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY2xheW1vcmUnLCAnY2xhJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY2xvYW50by5ycDknLCAncnA5J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY2xvbmsuYzRncm91cCcsICdjNGcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5jbHVldHJ1c3QuY2FydG9tb2JpbGUtY29uZmlnJywgJ2MxMWFtYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNsdWV0cnVzdC5jYXJ0b21vYmlsZS1jb25maWctcGtnJywgJ2MxMWFteiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNvbW1vbnNwYWNlJywgJ2NzcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmNvbnRhY3QuY21zZycsICdjZGJjbXNnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY29zbW9jYWxsZXInLCAnY21jJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlcicsICdjbGt4J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlci5rZXlib2FyZCcsICdjbGtrJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlci5wYWxldHRlJywgJ2Nsa3AnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5jcmljay5jbGlja2VyLnRlbXBsYXRlJywgJ2Nsa3QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5jcmljay5jbGlja2VyLndvcmRiYW5rJywgJ2Nsa3cnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5jcml0aWNhbHRvb2xzLndicyt4bWwnLCAnd2JzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuY3RjLXBvc21sJywgJ3BtbCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmN1cHMtcHBkJywgJ3BwZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmN1cmwuY2FyJywgJ2NhciddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmN1cmwucGN1cmwnLCAncGN1cmwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5kYXRhLXZpc2lvbi5yZHonLCAncmR6J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZGVub3ZvLmZjc2VsYXlvdXQtbGluaycsICdmZV9sYXVuY2gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5kbmEnLCAnZG5hJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZG9sYnkubWxwJywgJ21scCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmRwZ3JhcGgnLCAnZHBnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZHJlYW1mYWN0b3J5JywgJ2RmYWMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5kdmIuYWl0JywgJ2FpdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmR2Yi5zZXJ2aWNlJywgJ3N2YyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmR5bmFnZW8nLCAnZ2VvJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZWNvd2luLmNoYXJ0JywgJ21hZyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmVubGl2ZW4nLCAnbm1sJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZXBzb24uZXNmJywgJ2VzZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmVwc29uLm1zZicsICdtc2YnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5lcHNvbi5xdWlja2FuaW1lJywgJ3FhbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmVwc29uLnNhbHQnLCAnc2x0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZXBzb24uc3NmJywgJ3NzZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmVzemlnbm8zK3htbCcsICdlczMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5lenBpeC1hbGJ1bScsICdlejInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5lenBpeC1wYWNrYWdlJywgJ2V6MyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZkZicsICdmZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mZHNuLnNlZWQnLCAnc2VlZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZsb2dyYXBoaXQnLCAnZ3BoJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZmx1eHRpbWUuY2xpcCcsICdmdGMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mcmFtZW1ha2VyJywgJ2ZtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZnJvZ2Fucy5mbmMnLCAnZm5jJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZnJvZ2Fucy5sdGYnLCAnbHRmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZnNjLndlYmxhdW5jaCcsICdmc2MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzJywgJ29hcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZ1aml0c3Uub2FzeXMyJywgJ29hMiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZ1aml0c3Uub2FzeXMzJywgJ29hMyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZ1aml0c3Uub2FzeXNncCcsICdmZzUnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzcHJzJywgJ2JoMiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmZ1aml4ZXJveC5kZGQnLCAnZGRkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZnVqaXhlcm94LmRvY3V3b3JrcycsICd4ZHcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mdWppeGVyb3guZG9jdXdvcmtzLmJpbmRlcicsICd4YmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5mdXp6eXNoZWV0JywgJ2Z6cyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmdlbm9tYXRpeC50dXhlZG8nLCAndHhkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ2VvZ2VicmEuZmlsZScsICdnZ2InXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5nZW9nZWJyYS50b29sJywgJ2dndCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmdlb21ldHJ5LWV4cGxvcmVyJywgJ2dleCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmdlb25leHQnLCAnZ3h0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ2VvcGxhbicsICdnMncnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5nZW9zcGFjZScsICdnM3cnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5nbXgnLCAnZ214J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ29vZ2xlLWVhcnRoLmttbCt4bWwnLCAna21sJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ29vZ2xlLWVhcnRoLmtteicsICdrbXonXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ncmFmZXEnLCAnZ3FmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLWFjY291bnQnLCAnZ2FjJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLWhlbHAnLCAnZ2hmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLWlkZW50aXR5LW1lc3NhZ2UnLCAnZ2ltJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLWluamVjdG9yJywgJ2dydiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmdyb292ZS10b29sLW1lc3NhZ2UnLCAnZ3RtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLXRvb2wtdGVtcGxhdGUnLCAndHBsJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLXZjYXJkJywgJ3ZjZyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmhhbCt4bWwnLCAnaGFsJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaGFuZGhlbGQtZW50ZXJ0YWlubWVudCt4bWwnLCAnem1tJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaGJjaScsICdoYmNpJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaGhlLmxlc3Nvbi1wbGF5ZXInLCAnbGVzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaHAtaHBnbCcsIFsnaGdsJywgJ2hwZycsICdocGdsJ11dLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmhwLWhwaWQnLCAnaHBpZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmhwLWhwcycsICdocHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ocC1qbHl0JywgJ2psdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmhwLXBjbCcsICdwY2wnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ocC1wY2x4bCcsICdwY2x4bCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmh5ZHJvc3RhdGl4LnNvZi1kYXRhJywgJ3NmZC1oZHN0eCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmh6bi0zZC1jcm9zc3dvcmQnLCAneDNkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaWJtLm1pbmlwYXknLCAnbXB5J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaWJtLm1vZGNhcCcsICdhZnAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pYm0ucmlnaHRzLW1hbmFnZW1lbnQnLCAnaXJtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaWJtLnNlY3VyZS1jb250YWluZXInLCAnc2MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pY2Nwcm9maWxlJywgJ2ljYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmlnbG9hZGVyJywgJ2lnbCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmltbWVydmlzaW9uLWl2cCcsICdpdnAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pbW1lcnZpc2lvbi1pdnUnLCAnaXZ1J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaW5zb3JzLmlnbScsICdpZ20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pbnRlcmNvbi5mb3JtbmV0JywgJ3hwdyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmludGVyZ2VvJywgJ2kyZyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmludHUucWJvJywgJ3FibyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmludHUucWZ4JywgJ3FmeCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmlwdW5wbHVnZ2VkLnJjcHJvZmlsZScsICdyY3Byb2ZpbGUnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pcmVwb3NpdG9yeS5wYWNrYWdlK3htbCcsICdpcnAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5pcy14cHInLCAneHByJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuaXNhYy5mY3MnLCAnZmNzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuamFtJywgJ2phbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmpjcC5qYXZhbWUubWlkbGV0LXJtcycsICdybXMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5qaXNwJywgJ2ppc3AnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5qb29zdC5qb2RhLWFyY2hpdmUnLCAnam9kYSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmthaG9vdHonLCAna3R6J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQua2RlLmthcmJvbicsICdrYXJib24nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua2NoYXJ0JywgJ2NocnQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua2Zvcm11bGEnLCAna2ZvJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQua2RlLmtpdmlvJywgJ2ZsdyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmtkZS5rb250b3VyJywgJ2tvbiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmtkZS5rcHJlc2VudGVyJywgJ2twciddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmtkZS5rc3ByZWFkJywgJ2tzcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmtkZS5rd29yZCcsICdrd2QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5rZW5hbWVhYXBwJywgJ2h0a2UnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5raWRzcGlyYXRpb24nLCAna2lhJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQua2luYXInLCAna25lJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQua29hbicsICdza3AnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5rb2Rhay1kZXNjcmlwdG9yJywgJ3NzZSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxhcy5sYXMreG1sJywgJ2xhc3htbCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxsYW1hZ3JhcGhpY3MubGlmZS1iYWxhbmNlLmRlc2t0b3AnLCAnbGJkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubGxhbWFncmFwaGljcy5saWZlLWJhbGFuY2UuZXhjaGFuZ2UreG1sJywgJ2xiZSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLTEtMi0zJywgJzEyMyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLWFwcHJvYWNoJywgJ2FwciddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLWZyZWVsYW5jZScsICdwcmUnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5sb3R1cy1ub3RlcycsICduc2YnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5sb3R1cy1vcmdhbml6ZXInLCAnb3JnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubG90dXMtc2NyZWVuY2FtJywgJ3NjbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLXdvcmRwcm8nLCAnbHdwJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubWFjcG9ydHMucG9ydHBrZycsICdwb3J0cGtnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubWNkJywgJ21jZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1lZGNhbGNkYXRhJywgJ21jMSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1lZGlhc3RhdGlvbi5jZGtleScsICdjZGtleSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1mZXInLCAnbXdmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubWZtcCcsICdtZm0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5taWNyb2dyYWZ4LmZsbycsICdmbG8nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5taWNyb2dyYWZ4LmlneCcsICdpZ3gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5taWYnLCAnbWlmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubW9iaXVzLmRhZicsICdkYWYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tb2JpdXMuZGlzJywgJ2RpcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1vYml1cy5tYmsnLCAnbWJrJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubW9iaXVzLm1xeScsICdtcXknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tb2JpdXMubXNsJywgJ21zbCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1vYml1cy5wbGMnLCAncGxjJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubW9iaXVzLnR4ZicsICd0eGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tb3BodW4uYXBwbGljYXRpb24nLCAnbXBuJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubW9waHVuLmNlcnRpZmljYXRlJywgJ21wYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1vemlsbGEueHVsK3htbCcsICd4dWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1hcnRnYWxyeScsICdjaWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1jYWItY29tcHJlc3NlZCcsICdjYWInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsIFsneGxzJywgJ3hsYScsICd4bGMnLCAneGxtJywgJ3hsdCcsICd4bHcnLCAneGxiJywgJ3hsbCddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbC5hZGRpbi5tYWNyb2VuYWJsZWQuMTInLCAneGxhbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLWV4Y2VsLnNoZWV0LmJpbmFyeS5tYWNyb2VuYWJsZWQuMTInLCAneGxzYiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLWV4Y2VsLnNoZWV0Lm1hY3JvZW5hYmxlZC4xMicsICd4bHNtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwudGVtcGxhdGUubWFjcm9lbmFibGVkLjEyJywgJ3hsdG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1mb250b2JqZWN0JywgJ2VvdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLWh0bWxoZWxwJywgJ2NobSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLWltcycsICdpbXMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1scm0nLCAnbHJtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtb2ZmaWNldGhlbWUnLCAndGhteCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLW91dGxvb2snLCAnbXNnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtcGtpLmNlcnRzdG9yZScsICdzc3QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wa2kucGtvJywgJ3BrbyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXBraS5zZWNjYXQnLCAnY2F0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtcGtpLnN0bCcsICdzdGwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wa2ljZXJ0c3RvcmUnLCAnc3N0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtcGtpc2VjY2F0JywgJ2NhdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXBraXN0bCcsICdzdGwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50JywgWydwcHQnLCAncG90JywgJ3BwcycsICdwcGEnLCAncHd6J11dLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQuYWRkaW4ubWFjcm9lbmFibGVkLjEyJywgJ3BwYW0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50LnByZXNlbnRhdGlvbi5tYWNyb2VuYWJsZWQuMTInLCAncHB0bSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQuc2xpZGUubWFjcm9lbmFibGVkLjEyJywgJ3NsZG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50LnNsaWRlc2hvdy5tYWNyb2VuYWJsZWQuMTInLCAncHBzbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQudGVtcGxhdGUubWFjcm9lbmFibGVkLjEyJywgJ3BvdG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wcm9qZWN0JywgJ21wcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm1zLXdvcmQuZG9jdW1lbnQubWFjcm9lbmFibGVkLjEyJywgJ2RvY20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy13b3JkLnRlbXBsYXRlLm1hY3JvZW5hYmxlZC4xMicsICdkb3RtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMtd29ya3MnLCBbJ3drcycsICd3Y20nLCAnd2RiJywgJ3dwcyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy13cGwnLCAnd3BsJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXMteHBzZG9jdW1lbnQnLCAneHBzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXNlcScsICdtc2VxJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXVzaWNpYW4nLCAnbXVzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubXV2ZWUuc3R5bGUnLCAnbXN0eSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm5ldXJvbGFuZ3VhZ2Uubmx1JywgJ25sdSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm5vYmxlbmV0LWRpcmVjdG9yeScsICdubmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ub2JsZW5ldC1zZWFsZXInLCAnbm5zJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubm9ibGVuZXQtd2ViJywgJ25udyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm5va2lhLmNvbmZpZ3VyYXRpb24tbWVzc2FnZScsICduY20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ub2tpYS5uLWdhZ2UuZGF0YScsICduZ2RhdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm5va2lhLm4tZ2FnZS5zeW1iaWFuLmluc3RhbGwnLCAnbi1nYWdlJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubm9raWEucmFkaW8tcHJlc2V0JywgJ3Jwc3QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ub2tpYS5yYWRpby1wcmVzZXRzJywgJ3Jwc3MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ub2tpYS5yaW5naW5nLXRvbmUnLCAncm5nJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQubm92YWRpZ20uZWRtJywgJ2VkbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm5vdmFkaWdtLmVkeCcsICdlZHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ub3ZhZGlnbS5leHQnLCAnZXh0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmNoYXJ0JywgJ29kYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5jaGFydC10ZW1wbGF0ZScsICdvdGMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuZGF0YWJhc2UnLCAnb2RiJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmZvcm11bGEnLCAnb2RmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmZvcm11bGEtdGVtcGxhdGUnLCAnb2RmdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5ncmFwaGljcycsICdvZGcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuZ3JhcGhpY3MtdGVtcGxhdGUnLCAnb3RnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmltYWdlJywgJ29kaSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5pbWFnZS10ZW1wbGF0ZScsICdvdGknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQucHJlc2VudGF0aW9uJywgJ29kcCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5wcmVzZW50YXRpb24tdGVtcGxhdGUnLCAnb3RwJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LnNwcmVhZHNoZWV0JywgJ29kcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5zcHJlYWRzaGVldC10ZW1wbGF0ZScsICdvdHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQudGV4dCcsICdvZHQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQudGV4dC1tYXN0ZXInLCAnb2RtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LnRleHQtdGVtcGxhdGUnLCAnb3R0J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LnRleHQtd2ViJywgJ290aCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9scGMtc3VnYXInLCAneG8nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vbWEuZGQyK3htbCcsICdkZDInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVub2ZmaWNlb3JnLmV4dGVuc2lvbicsICdveHQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5wcmVzZW50YXRpb25tbC5wcmVzZW50YXRpb24nLCAncHB0eCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLW9mZmljZWRvY3VtZW50LnByZXNlbnRhdGlvbm1sLnNsaWRlJywgJ3NsZHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5wcmVzZW50YXRpb25tbC5zbGlkZXNob3cnLCAncHBzeCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLW9mZmljZWRvY3VtZW50LnByZXNlbnRhdGlvbm1sLnRlbXBsYXRlJywgJ3BvdHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnNoZWV0JywgJ3hsc3gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnRlbXBsYXRlJywgJ3hsdHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC53b3JkcHJvY2Vzc2luZ21sLmRvY3VtZW50JywgJ2RvY3gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC53b3JkcHJvY2Vzc2luZ21sLnRlbXBsYXRlJywgJ2RvdHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5vc2dlby5tYXBndWlkZS5wYWNrYWdlJywgJ21ncCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLm9zZ2kuZHAnLCAnZHAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5wYWxtJywgJ3BkYiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnBhd2FhZmlsZScsICdwYXcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5wZy5mb3JtYXQnLCAnc3RyJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucGcub3Nhc2xpJywgJ2VpNiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnBpY3NlbCcsICdlZmlmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucG1pLndpZGdldCcsICd3ZyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnBvY2tldGxlYXJuJywgJ3BsZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnBvd2VyYnVpbGRlcjYnLCAncGJkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucHJldmlld3N5c3RlbXMuYm94JywgJ2JveCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnByb3RldXMubWFnYXppbmUnLCAnbWd6J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucHVibGlzaGFyZS1kZWx0YS10cmVlJywgJ3FwcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnB2aS5wdGlkMScsICdwdGlkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucXVhcmsucXVhcmt4cHJlc3MnLCAncXhkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucmVhbHZuYy5iZWQnLCAnYmVkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucmVjb3JkYXJlLm11c2ljeG1sJywgJ214bCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnJlY29yZGFyZS5tdXNpY3htbCt4bWwnLCAnbXVzaWN4bWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5yaWcuY3J5cHRvbm90ZScsICdjcnlwdG9ub3RlJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQucmltLmNvZCcsICdjb2QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ybi1yZWFsbWVkaWEnLCAncm0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5ybi1yZWFscGxheWVyJywgJ3JueCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnJvdXRlNjYubGluazY2K3htbCcsICdsaW5rNjYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zYWlsaW5ndHJhY2tlci50cmFjaycsICdzdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnNlZW1haWwnLCAnc2VlJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2VtYScsICdzZW1hJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2VtZCcsICdzZW1kJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2VtZicsICdzZW1mJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2hhbmEuaW5mb3JtZWQuZm9ybWRhdGEnLCAnaWZtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2hhbmEuaW5mb3JtZWQuZm9ybXRlbXBsYXRlJywgJ2l0cCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnNoYW5hLmluZm9ybWVkLmludGVyY2hhbmdlJywgJ2lpZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnNoYW5hLmluZm9ybWVkLnBhY2thZ2UnLCAnaXBrJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc2ltdGVjaC1taW5kbWFwcGVyJywgJ3R3ZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnNtYWYnLCAnbW1mJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc21hcnQudGVhY2hlcicsICd0ZWFjaGVyJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc29sZW50LnNka20reG1sJywgJ3Nka20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zcG90ZmlyZS5keHAnLCAnZHhwJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3BvdGZpcmUuc2ZzJywgJ3NmcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5jYWxjJywgJ3NkYyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5kcmF3JywgJ3NkYSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5pbXByZXNzJywgJ3NkZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5tYXRoJywgJ3NtZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi53cml0ZXInLCAnc2R3J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3RhcmRpdmlzaW9uLndyaXRlci1nbG9iYWwnLCAnc2dsJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3RlcG1hbmlhLnN0ZXBjaGFydCcsICdzbSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN1bi54bWwuY2FsYycsICdzeGMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLmNhbGMudGVtcGxhdGUnLCAnc3RjJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC5kcmF3JywgJ3N4ZCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN1bi54bWwuZHJhdy50ZW1wbGF0ZScsICdzdGQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLmltcHJlc3MnLCAnc3hpJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC5pbXByZXNzLnRlbXBsYXRlJywgJ3N0aSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN1bi54bWwubWF0aCcsICdzeG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLndyaXRlcicsICdzeHcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLndyaXRlci5nbG9iYWwnLCAnc3hnJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC53cml0ZXIudGVtcGxhdGUnLCAnc3R3J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3VzLWNhbGVuZGFyJywgJ3N1cyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnN2ZCcsICdzdmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zeW1iaWFuLmluc3RhbGwnLCAnc2lzJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3luY21sK3htbCcsICd4c20nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC5zeW5jbWwuZG0rd2J4bWwnLCAnYmRtJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuc3luY21sLmRtK3htbCcsICd4ZG0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC50YW8uaW50ZW50LW1vZHVsZS1hcmNoaXZlJywgJ3RhbyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnRtb2JpbGUtbGl2ZXR2JywgJ3RtbyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnRyaWQudHB0JywgJ3RwdCddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnRyaXNjYXBlLm14cycsICdteHMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC50cnVlYXBwJywgJ3RyYSddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnVmZGwnLCAndWZkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQudWlxLnRoZW1lJywgJ3V0eiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnVtYWppbicsICd1bWonXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC51bml0eScsICd1bml0eXdlYiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnVvbWwreG1sJywgJ3VvbWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC52Y3gnLCAndmN4J10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQudmlzaW8nLCAndnNkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQudmlzaW9uYXJ5JywgJ3ZpcyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnZzZicsICd2c2YnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53YXAud2J4bWwnLCAnd2J4bWwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53YXAud21sYycsICd3bWxjJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQud2FwLndtbHNjcmlwdGMnLCAnd21sc2MnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53ZWJ0dXJibycsICd3dGInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53b2xmcmFtLnBsYXllcicsICduYnAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53b3JkcGVyZmVjdCcsICd3cGQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC53cWQnLCAnd3FkJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQud3Quc3RmJywgJ3N0ZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnhhcmEnLCBbJ3dlYicsICd4YXInXV0sXG4gICAgWydhcHBsaWNhdGlvbi92bmQueGZkbCcsICd4ZmRsJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQueWFtYWhhLmh2LWRpYycsICdodmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuaHYtc2NyaXB0JywgJ2h2cyddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnlhbWFoYS5odi12b2ljZScsICdodnAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEub3BlbnNjb3JlZm9ybWF0JywgJ29zZiddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnlhbWFoYS5vcGVuc2NvcmVmb3JtYXQub3NmcHZnK3htbCcsICdvc2ZwdmcnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuc21hZi1hdWRpbycsICdzYWYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuc21hZi1waHJhc2UnLCAnc3BmJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQueWVsbG93cml2ZXItY3VzdG9tLW1lbnUnLCAnY21wJ10sXG4gICAgWydhcHBsaWNhdGlvbi92bmQuenVsJywgJ3ppciddLFxuICAgIFsnYXBwbGljYXRpb24vdm5kLnp6YXp6LmRlY2sreG1sJywgJ3pheiddLFxuICAgIFsnYXBwbGljYXRpb24vdm9jYWx0ZWMtbWVkaWEtZGVzYycsICd2bWQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ZvY2FsdGVjLW1lZGlhLWZpbGUnLCAndm1mJ10sXG4gICAgWydhcHBsaWNhdGlvbi92b2ljZXhtbCt4bWwnLCAndnhtbCddLFxuICAgIFsnYXBwbGljYXRpb24vd2lkZ2V0JywgJ3dndCddLFxuICAgIFsnYXBwbGljYXRpb24vd2luaGxwJywgJ2hscCddLFxuICAgIFsnYXBwbGljYXRpb24vd29yZHBlcmZlY3QnLCBbJ3dwJywgJ3dwNScsICd3cDYnLCAnd3BkJ11dLFxuICAgIFsnYXBwbGljYXRpb24vd29yZHBlcmZlY3Q2LjAnLCBbJ3c2MCcsICd3cDUnXV0sXG4gICAgWydhcHBsaWNhdGlvbi93b3JkcGVyZmVjdDYuMScsICd3NjEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3dzZGwreG1sJywgJ3dzZGwnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3dzcG9saWN5K3htbCcsICd3c3BvbGljeSddLFxuICAgIFsnYXBwbGljYXRpb24veC0xMjMnLCAnd2sxJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LTd6LWNvbXByZXNzZWQnLCAnN3onXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYWJpd29yZCcsICdhYncnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYWNlLWNvbXByZXNzZWQnLCAnYWNlJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWFpbScsICdhaW0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYXV0aG9yd2FyZS1iaW4nLCAnYWFiJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWF1dGhvcndhcmUtbWFwJywgJ2FhbSddLFxuICAgIFsnYXBwbGljYXRpb24veC1hdXRob3J3YXJlLXNlZycsICdhYXMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYmNwaW8nLCAnYmNwaW8nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYmluYXJ5JywgJ2JpbiddLFxuICAgIFsnYXBwbGljYXRpb24veC1iaW5oZXg0MCcsICdocXgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYml0dG9ycmVudCcsICd0b3JyZW50J10sXG4gICAgWydhcHBsaWNhdGlvbi94LWJzaCcsIFsnYnNoJywgJ3NoJywgJ3NoYXInXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWJ5dGVjb2RlLmVsaXNwJywgJ2VsYyddLFxuICAgIFsnYXBwbGljYXRpb24veC1ieXRlY29kZS5weXRob24nLCAncHljJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWJ6aXAnLCAnYnonXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtYnppcDInLCBbJ2JveicsICdiejInXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWNkZicsICdjZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtY2RsaW5rJywgJ3ZjZCddLFxuICAgIFsnYXBwbGljYXRpb24veC1jaGF0JywgWydjaGEnLCAnY2hhdCddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtY2hlc3MtcGduJywgJ3BnbiddLFxuICAgIFsnYXBwbGljYXRpb24veC1jbXUtcmFzdGVyJywgJ3JhcyddLFxuICAgIFsnYXBwbGljYXRpb24veC1jb2NvYScsICdjY28nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtY29tcGFjdHBybycsICdjcHQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtY29tcHJlc3MnLCAneiddLFxuICAgIFsnYXBwbGljYXRpb24veC1jb21wcmVzc2VkJywgWyd0Z3onLCAnZ3onLCAneicsICd6aXAnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWNvbmZlcmVuY2UnLCAnbnNjJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWNwaW8nLCAnY3BpbyddLFxuICAgIFsnYXBwbGljYXRpb24veC1jcHQnLCAnY3B0J10sXG4gICAgWydhcHBsaWNhdGlvbi94LWNzaCcsICdjc2gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZGViaWFuLXBhY2thZ2UnLCAnZGViJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWRlZXB2JywgJ2RlZXB2J10sXG4gICAgWydhcHBsaWNhdGlvbi94LWRpcmVjdG9yJywgWydkaXInLCAnZGNyJywgJ2R4ciddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZG9vbScsICd3YWQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZHRibmN4K3htbCcsICduY3gnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZHRib29rK3htbCcsICdkdGInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZHRicmVzb3VyY2UreG1sJywgJ3JlcyddLFxuICAgIFsnYXBwbGljYXRpb24veC1kdmknLCAnZHZpJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWVsYycsICdlbGMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZW52b3knLCBbJ2VudicsICdldnknXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWVzcmVoYmVyJywgJ2VzJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWV4Y2VsJywgWyd4bHMnLCAneGxhJywgJ3hsYicsICd4bGMnLCAneGxkJywgJ3hsaycsICd4bGwnLCAneGxtJywgJ3hsdCcsICd4bHYnLCAneGx3J11dLFxuICAgIFsnYXBwbGljYXRpb24veC1mb250LWJkZicsICdiZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZm9udC1naG9zdHNjcmlwdCcsICdnc2YnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZm9udC1saW51eC1wc2YnLCAncHNmJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWZvbnQtb3RmJywgJ290ZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1mb250LXBjZicsICdwY2YnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZm9udC1zbmYnLCAnc25mJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWZvbnQtdHRmJywgJ3R0ZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1mb250LXR5cGUxJywgJ3BmYSddLFxuICAgIFsnYXBwbGljYXRpb24veC1mb250LXdvZmYnLCAnd29mZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1mcmFtZScsICdtaWYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZnJlZWxhbmNlJywgJ3ByZSddLFxuICAgIFsnYXBwbGljYXRpb24veC1mdXR1cmVzcGxhc2gnLCAnc3BsJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWdudW1lcmljJywgJ2dudW1lcmljJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWdzcCcsICdnc3AnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZ3NzJywgJ2dzcyddLFxuICAgIFsnYXBwbGljYXRpb24veC1ndGFyJywgJ2d0YXInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtZ3ppcCcsIFsnZ3onLCAnZ3ppcCddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtaGRmJywgJ2hkZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1oZWxwZmlsZScsIFsnaGVscCcsICdobHAnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWh0dHBkLWltYXAnLCAnaW1hcCddLFxuICAgIFsnYXBwbGljYXRpb24veC1pbWEnLCAnaW1hJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWludGVybmV0LXNpZ251cCcsIFsnaW5zJywgJ2lzcCddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtaW50ZXJuZXR0LXNpZ251cCcsICdpbnMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtaW52ZW50b3InLCAnaXYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtaXAyJywgJ2lwJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWlwaG9uZScsICdpaWknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtamF2YS1jbGFzcycsICdjbGFzcyddLFxuICAgIFsnYXBwbGljYXRpb24veC1qYXZhLWNvbW1lcmNlJywgJ2pjbSddLFxuICAgIFsnYXBwbGljYXRpb24veC1qYXZhLWpubHAtZmlsZScsICdqbmxwJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWphdmFzY3JpcHQnLCAnanMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gta29hbicsIFsnc2tkJywgJ3NrbScsICdza3AnLCAnc2t0J11dLFxuICAgIFsnYXBwbGljYXRpb24veC1rc2gnLCAna3NoJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWxhdGV4JywgWydsYXRleCcsICdsdHgnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LWxoYScsICdsaGEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbGlzcCcsICdsc3AnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbGl2ZXNjcmVlbicsICdpdnknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbG90dXMnLCAnd3ExJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWxvdHVzc2NyZWVuY2FtJywgJ3NjbSddLFxuICAgIFsnYXBwbGljYXRpb24veC1semgnLCAnbHpoJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LWx6eCcsICdsengnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbWFjLWJpbmhleDQwJywgJ2hxeCddLFxuICAgIFsnYXBwbGljYXRpb24veC1tYWNiaW5hcnknLCAnYmluJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1hZ2ljLWNhcC1wYWNrYWdlLTEuMCcsICdtYyQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbWF0aGNhZCcsICdtY2QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbWVtZScsICdtbSddLFxuICAgIFsnYXBwbGljYXRpb24veC1taWRpJywgWydtaWQnLCAnbWlkaSddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbWlmJywgJ21pZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1taXgtdHJhbnNmZXInLCAnbml4J10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1vYmlwb2NrZXQtZWJvb2snLCAncHJjJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1wbGF5ZXIyJywgJ2FzeCddLFxuICAgIFsnYXBwbGljYXRpb24veC1tcy1hcHBsaWNhdGlvbicsICdhcHBsaWNhdGlvbiddLFxuICAgIFsnYXBwbGljYXRpb24veC1tcy13bWQnLCAnd21kJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1zLXdteicsICd3bXonXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbXMteGJhcCcsICd4YmFwJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1zYWNjZXNzJywgJ21kYiddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc2JpbmRlcicsICdvYmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbXNjYXJkZmlsZScsICdjcmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbXNjbGlwJywgJ2NscCddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc2Rvd25sb2FkJywgWydleGUnLCAnZGxsJ11dLFxuICAgIFsnYXBwbGljYXRpb24veC1tc2V4Y2VsJywgWyd4bHMnLCAneGxhJywgJ3hsdyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbXNtZWRpYXZpZXcnLCBbJ212YicsICdtMTMnLCAnbTE0J11dLFxuICAgIFsnYXBwbGljYXRpb24veC1tc21ldGFmaWxlJywgJ3dtZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc21vbmV5JywgJ21ueSddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc3Bvd2VycG9pbnQnLCAncHB0J10sXG4gICAgWydhcHBsaWNhdGlvbi94LW1zcHVibGlzaGVyJywgJ3B1YiddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc3NjaGVkdWxlJywgJ3NjZCddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc3Rlcm1pbmFsJywgJ3RybSddLFxuICAgIFsnYXBwbGljYXRpb24veC1tc3dyaXRlJywgJ3dyaSddLFxuICAgIFsnYXBwbGljYXRpb24veC1uYXZpLWFuaW1hdGlvbicsICdhbmknXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbmF2aWRvYycsICdudmQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbmF2aW1hcCcsICdtYXAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbmF2aXN0eWxlJywgJ3N0bCddLFxuICAgIFsnYXBwbGljYXRpb24veC1uZXRjZGYnLCBbJ2NkZicsICduYyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtbmV3dG9uLWNvbXBhdGlibGUtcGtnJywgJ3BrZyddLFxuICAgIFsnYXBwbGljYXRpb24veC1ub2tpYS05MDAwLWNvbW11bmljYXRvci1hZGQtb24tc29mdHdhcmUnLCAnYW9zJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LW9tYycsICdvbWMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtb21jZGF0YW1ha2VyJywgJ29tY2QnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtb21jcmVnZXJhdG9yJywgJ29tY3InXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcGFnZW1ha2VyJywgWydwbTQnLCAncG01J11dLFxuICAgIFsnYXBwbGljYXRpb24veC1wY2wnLCAncGNsJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXBlcmZtb24nLCBbJ3BtYScsICdwbWMnLCAncG1sJywgJ3BtcicsICdwbXcnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LXBpeGNsc2NyaXB0JywgJ3BseCddLFxuICAgIFsnYXBwbGljYXRpb24veC1wa2NzMTAnLCAncDEwJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXBrY3MxMicsIFsncDEyJywgJ3BmeCddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcGtjczctY2VydGlmaWNhdGVzJywgWydwN2InLCAnc3BjJ11dLFxuICAgIFsnYXBwbGljYXRpb24veC1wa2NzNy1jZXJ0cmVxcmVzcCcsICdwN3InXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcGtjczctbWltZScsIFsncDdtJywgJ3A3YyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcGtjczctc2lnbmF0dXJlJywgWydwN3MnLCAncDdhJ11dLFxuICAgIFsnYXBwbGljYXRpb24veC1wb2ludHBsdXMnLCAnY3NzJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXBvcnRhYmxlLWFueW1hcCcsICdwbm0nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcHJvamVjdCcsIFsnbXBjJywgJ21wdCcsICdtcHYnLCAnbXB4J11dLFxuICAgIFsnYXBwbGljYXRpb24veC1xcHJvJywgJ3diMSddLFxuICAgIFsnYXBwbGljYXRpb24veC1yYXItY29tcHJlc3NlZCcsICdyYXInXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtcnRmJywgJ3J0ZiddLFxuICAgIFsnYXBwbGljYXRpb24veC1zZHAnLCAnc2RwJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXNlYScsICdzZWEnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtc2VlbG9nbycsICdzbCddLFxuICAgIFsnYXBwbGljYXRpb24veC1zaCcsICdzaCddLFxuICAgIFsnYXBwbGljYXRpb24veC1zaGFyJywgWydzaGFyJywgJ3NoJ11dLFxuICAgIFsnYXBwbGljYXRpb24veC1zaG9ja3dhdmUtZmxhc2gnLCAnc3dmJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXNpbHZlcmxpZ2h0LWFwcCcsICd4YXAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtc2l0JywgJ3NpdCddLFxuICAgIFsnYXBwbGljYXRpb24veC1zcHJpdGUnLCBbJ3NwcicsICdzcHJpdGUnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LXN0dWZmaXQnLCAnc2l0J10sXG4gICAgWydhcHBsaWNhdGlvbi94LXN0dWZmaXR4JywgJ3NpdHgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtc3Y0Y3BpbycsICdzdjRjcGlvJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXN2NGNyYycsICdzdjRjcmMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtdGFyJywgJ3RhciddLFxuICAgIFsnYXBwbGljYXRpb24veC10Ym9vaycsIFsnc2JrJywgJ3RiayddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtdGNsJywgJ3RjbCddLFxuICAgIFsnYXBwbGljYXRpb24veC10ZXgnLCAndGV4J10sXG4gICAgWydhcHBsaWNhdGlvbi94LXRleC10Zm0nLCAndGZtJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXRleGluZm8nLCBbJ3RleGknLCAndGV4aW5mbyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtdHJvZmYnLCBbJ3JvZmYnLCAndCcsICd0ciddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtdHJvZmYtbWFuJywgJ21hbiddLFxuICAgIFsnYXBwbGljYXRpb24veC10cm9mZi1tZScsICdtZSddLFxuICAgIFsnYXBwbGljYXRpb24veC10cm9mZi1tcycsICdtcyddLFxuICAgIFsnYXBwbGljYXRpb24veC10cm9mZi1tc3ZpZGVvJywgJ2F2aSddLFxuICAgIFsnYXBwbGljYXRpb24veC11c3RhcicsICd1c3RhciddLFxuICAgIFsnYXBwbGljYXRpb24veC12aXNpbycsIFsndnNkJywgJ3ZzdCcsICd2c3cnXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LXZuZC5hdWRpb2V4cGxvc2lvbi5tenonLCAnbXp6J10sXG4gICAgWydhcHBsaWNhdGlvbi94LXZuZC5scy14cGl4JywgJ3hwaXgnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtdnJtbCcsICd2cm1sJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXdhaXMtc291cmNlJywgWydzcmMnLCAnd3NyYyddXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtd2luaGVscCcsICdobHAnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtd2ludGFsaycsICd3dGsnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3gtd29ybGQnLCBbJ3dybCcsICdzdnInXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LXdwd2luJywgJ3dwZCddLFxuICAgIFsnYXBwbGljYXRpb24veC13cmknLCAnd3JpJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXg1MDktY2EtY2VydCcsIFsnY2VyJywgJ2NydCcsICdkZXInXV0sXG4gICAgWydhcHBsaWNhdGlvbi94LXg1MDktdXNlci1jZXJ0JywgJ2NydCddLFxuICAgIFsnYXBwbGljYXRpb24veC14ZmlnJywgJ2ZpZyddLFxuICAgIFsnYXBwbGljYXRpb24veC14cGluc3RhbGwnLCAneHBpJ10sXG4gICAgWydhcHBsaWNhdGlvbi94LXppcC1jb21wcmVzc2VkJywgJ3ppcCddLFxuICAgIFsnYXBwbGljYXRpb24veGNhcC1kaWZmK3htbCcsICd4ZGYnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3hlbmMreG1sJywgJ3hlbmMnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3hodG1sK3htbCcsICd4aHRtbCddLFxuICAgIFsnYXBwbGljYXRpb24veG1sJywgJ3htbCddLFxuICAgIFsnYXBwbGljYXRpb24veG1sLWR0ZCcsICdkdGQnXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3hvcCt4bWwnLCAneG9wJ10sXG4gICAgWydhcHBsaWNhdGlvbi94c2x0K3htbCcsICd4c2x0J10sXG4gICAgWydhcHBsaWNhdGlvbi94c3BmK3htbCcsICd4c3BmJ10sXG4gICAgWydhcHBsaWNhdGlvbi94dit4bWwnLCAnbXhtbCddLFxuICAgIFsnYXBwbGljYXRpb24veWFuZycsICd5YW5nJ10sXG4gICAgWydhcHBsaWNhdGlvbi95aW4reG1sJywgJ3lpbiddLFxuICAgIFsnYXBwbGljYXRpb24veW5kLm1zLXBraXBrbycsICdwa28nXSxcbiAgICBbJ2FwcGxpY2F0aW9uL3ppcCcsICd6aXAnXSxcbiAgICBbJ2F1ZGlvL2FkcGNtJywgJ2FkcCddLFxuICAgIFsnYXVkaW8vYWlmZicsIFsnYWlmZicsICdhaWYnLCAnYWlmYyddXSxcbiAgICBbJ2F1ZGlvL2Jhc2ljJywgWydzbmQnLCAnYXUnXV0sXG4gICAgWydhdWRpby9pdCcsICdpdCddLFxuICAgIFsnYXVkaW8vbWFrZScsIFsnZnVuaycsICdteScsICdwZnVuayddXSxcbiAgICBbJ2F1ZGlvL21ha2UubXkuZnVuaycsICdwZnVuayddLFxuICAgIFsnYXVkaW8vbWlkJywgWydtaWQnLCAncm1pJ11dLFxuICAgIFsnYXVkaW8vbWlkaScsIFsnbWlkaScsICdrYXInLCAnbWlkJ11dLFxuICAgIFsnYXVkaW8vbW9kJywgJ21vZCddLFxuICAgIFsnYXVkaW8vbXA0JywgJ21wNGEnXSxcbiAgICBbJ2F1ZGlvL21wZWcnLCBbJ21wZ2EnLCAnbXAzJywgJ20yYScsICdtcDInLCAnbXBhJywgJ21wZyddXSxcbiAgICBbJ2F1ZGlvL21wZWczJywgJ21wMyddLFxuICAgIFsnYXVkaW8vbnNwYXVkaW8nLCBbJ2xhJywgJ2xtYSddXSxcbiAgICBbJ2F1ZGlvL29nZycsICdvZ2EnXSxcbiAgICBbJ2F1ZGlvL3MzbScsICdzM20nXSxcbiAgICBbJ2F1ZGlvL3RzcC1hdWRpbycsICd0c2knXSxcbiAgICBbJ2F1ZGlvL3RzcGxheWVyJywgJ3RzcCddLFxuICAgIFsnYXVkaW8vdm5kLmRlY2UuYXVkaW8nLCAndXZhJ10sXG4gICAgWydhdWRpby92bmQuZGlnaXRhbC13aW5kcycsICdlb2wnXSxcbiAgICBbJ2F1ZGlvL3ZuZC5kcmEnLCAnZHJhJ10sXG4gICAgWydhdWRpby92bmQuZHRzJywgJ2R0cyddLFxuICAgIFsnYXVkaW8vdm5kLmR0cy5oZCcsICdkdHNoZCddLFxuICAgIFsnYXVkaW8vdm5kLmx1Y2VudC52b2ljZScsICdsdnAnXSxcbiAgICBbJ2F1ZGlvL3ZuZC5tcy1wbGF5cmVhZHkubWVkaWEucHlhJywgJ3B5YSddLFxuICAgIFsnYXVkaW8vdm5kLm51ZXJhLmVjZWxwNDgwMCcsICdlY2VscDQ4MDAnXSxcbiAgICBbJ2F1ZGlvL3ZuZC5udWVyYS5lY2VscDc0NzAnLCAnZWNlbHA3NDcwJ10sXG4gICAgWydhdWRpby92bmQubnVlcmEuZWNlbHA5NjAwJywgJ2VjZWxwOTYwMCddLFxuICAgIFsnYXVkaW8vdm5kLnFjZWxwJywgJ3FjcCddLFxuICAgIFsnYXVkaW8vdm5kLnJpcCcsICdyaXAnXSxcbiAgICBbJ2F1ZGlvL3ZvYycsICd2b2MnXSxcbiAgICBbJ2F1ZGlvL3ZveHdhcmUnLCAndm94J10sXG4gICAgWydhdWRpby93YXYnLCAnd2F2J10sXG4gICAgWydhdWRpby93ZWJtJywgJ3dlYmEnXSxcbiAgICBbJ2F1ZGlvL3gtYWFjJywgJ2FhYyddLFxuICAgIFsnYXVkaW8veC1hZHBjbScsICdzbmQnXSxcbiAgICBbJ2F1ZGlvL3gtYWlmZicsIFsnYWlmZicsICdhaWYnLCAnYWlmYyddXSxcbiAgICBbJ2F1ZGlvL3gtYXUnLCAnYXUnXSxcbiAgICBbJ2F1ZGlvL3gtZ3NtJywgWydnc2QnLCAnZ3NtJ11dLFxuICAgIFsnYXVkaW8veC1qYW0nLCAnamFtJ10sXG4gICAgWydhdWRpby94LWxpdmVhdWRpbycsICdsYW0nXSxcbiAgICBbJ2F1ZGlvL3gtbWlkJywgWydtaWQnLCAnbWlkaSddXSxcbiAgICBbJ2F1ZGlvL3gtbWlkaScsIFsnbWlkaScsICdtaWQnXV0sXG4gICAgWydhdWRpby94LW1vZCcsICdtb2QnXSxcbiAgICBbJ2F1ZGlvL3gtbXBlZycsICdtcDInXSxcbiAgICBbJ2F1ZGlvL3gtbXBlZy0zJywgJ21wMyddLFxuICAgIFsnYXVkaW8veC1tcGVndXJsJywgJ20zdSddLFxuICAgIFsnYXVkaW8veC1tcGVxdXJsJywgJ20zdSddLFxuICAgIFsnYXVkaW8veC1tcy13YXgnLCAnd2F4J10sXG4gICAgWydhdWRpby94LW1zLXdtYScsICd3bWEnXSxcbiAgICBbJ2F1ZGlvL3gtbnNwYXVkaW8nLCBbJ2xhJywgJ2xtYSddXSxcbiAgICBbJ2F1ZGlvL3gtcG4tcmVhbGF1ZGlvJywgWydyYScsICdyYW0nLCAncm0nLCAncm1tJywgJ3JtcCddXSxcbiAgICBbJ2F1ZGlvL3gtcG4tcmVhbGF1ZGlvLXBsdWdpbicsIFsncmEnLCAncm1wJywgJ3JwbSddXSxcbiAgICBbJ2F1ZGlvL3gtcHNpZCcsICdzaWQnXSxcbiAgICBbJ2F1ZGlvL3gtcmVhbGF1ZGlvJywgJ3JhJ10sXG4gICAgWydhdWRpby94LXR3aW52cScsICd2cWYnXSxcbiAgICBbJ2F1ZGlvL3gtdHdpbnZxLXBsdWdpbicsIFsndnFlJywgJ3ZxbCddXSxcbiAgICBbJ2F1ZGlvL3gtdm5kLmF1ZGlvZXhwbG9zaW9uLm1qdWljZW1lZGlhZmlsZScsICdtamYnXSxcbiAgICBbJ2F1ZGlvL3gtdm9jJywgJ3ZvYyddLFxuICAgIFsnYXVkaW8veC13YXYnLCAnd2F2J10sXG4gICAgWydhdWRpby94bScsICd4bSddLFxuICAgIFsnY2hlbWljYWwveC1jZHgnLCAnY2R4J10sXG4gICAgWydjaGVtaWNhbC94LWNpZicsICdjaWYnXSxcbiAgICBbJ2NoZW1pY2FsL3gtY21kZicsICdjbWRmJ10sXG4gICAgWydjaGVtaWNhbC94LWNtbCcsICdjbWwnXSxcbiAgICBbJ2NoZW1pY2FsL3gtY3NtbCcsICdjc21sJ10sXG4gICAgWydjaGVtaWNhbC94LXBkYicsIFsncGRiJywgJ3h5eiddXSxcbiAgICBbJ2NoZW1pY2FsL3gteHl6JywgJ3h5eiddLFxuICAgIFsnZHJhd2luZy94LWR3ZicsICdkd2YnXSxcbiAgICBbJ2ktd29ybGQvaS12cm1sJywgJ2l2ciddLFxuICAgIFsnaW1hZ2UvYm1wJywgWydibXAnLCAnYm0nXV0sXG4gICAgWydpbWFnZS9jZ20nLCAnY2dtJ10sXG4gICAgWydpbWFnZS9jaXMtY29kJywgJ2NvZCddLFxuICAgIFsnaW1hZ2UvY211LXJhc3RlcicsIFsncmFzJywgJ3Jhc3QnXV0sXG4gICAgWydpbWFnZS9maWYnLCAnZmlmJ10sXG4gICAgWydpbWFnZS9mbG9yaWFuJywgWydmbG8nLCAndHVyYm90J11dLFxuICAgIFsnaW1hZ2UvZzNmYXgnLCAnZzMnXSxcbiAgICBbJ2ltYWdlL2dpZicsICdnaWYnXSxcbiAgICBbJ2ltYWdlL2llZicsIFsnaWVmJywgJ2llZnMnXV0sXG4gICAgWydpbWFnZS9qcGVnJywgWydqcGVnJywgJ2pwZScsICdqcGcnLCAnamZpZicsICdqZmlmLXRibmwnXV0sXG4gICAgWydpbWFnZS9qdXR2aXNpb24nLCAnanV0J10sXG4gICAgWydpbWFnZS9rdHgnLCAna3R4J10sXG4gICAgWydpbWFnZS9uYXBscHMnLCBbJ25hcCcsICduYXBscHMnXV0sXG4gICAgWydpbWFnZS9waWN0JywgWydwaWMnLCAncGljdCddXSxcbiAgICBbJ2ltYWdlL3BpcGVnJywgJ2pmaWYnXSxcbiAgICBbJ2ltYWdlL3BqcGVnJywgWydqZmlmJywgJ2pwZScsICdqcGVnJywgJ2pwZyddXSxcbiAgICBbJ2ltYWdlL3BuZycsIFsncG5nJywgJ3gtcG5nJ11dLFxuICAgIFsnaW1hZ2UvcHJzLmJ0aWYnLCAnYnRpZiddLFxuICAgIFsnaW1hZ2Uvc3ZnK3htbCcsICdzdmcnXSxcbiAgICBbJ2ltYWdlL3RpZmYnLCBbJ3RpZicsICd0aWZmJ11dLFxuICAgIFsnaW1hZ2UvdmFzYScsICdtY2YnXSxcbiAgICBbJ2ltYWdlL3ZuZC5hZG9iZS5waG90b3Nob3AnLCAncHNkJ10sXG4gICAgWydpbWFnZS92bmQuZGVjZS5ncmFwaGljJywgJ3V2aSddLFxuICAgIFsnaW1hZ2Uvdm5kLmRqdnUnLCAnZGp2dSddLFxuICAgIFsnaW1hZ2Uvdm5kLmR2Yi5zdWJ0aXRsZScsICdzdWInXSxcbiAgICBbJ2ltYWdlL3ZuZC5kd2cnLCBbJ2R3ZycsICdkeGYnLCAnc3ZmJ11dLFxuICAgIFsnaW1hZ2Uvdm5kLmR4ZicsICdkeGYnXSxcbiAgICBbJ2ltYWdlL3ZuZC5mYXN0Ymlkc2hlZXQnLCAnZmJzJ10sXG4gICAgWydpbWFnZS92bmQuZnB4JywgJ2ZweCddLFxuICAgIFsnaW1hZ2Uvdm5kLmZzdCcsICdmc3QnXSxcbiAgICBbJ2ltYWdlL3ZuZC5mdWppeGVyb3guZWRtaWNzLW1tcicsICdtbXInXSxcbiAgICBbJ2ltYWdlL3ZuZC5mdWppeGVyb3guZWRtaWNzLXJsYycsICdybGMnXSxcbiAgICBbJ2ltYWdlL3ZuZC5tcy1tb2RpJywgJ21kaSddLFxuICAgIFsnaW1hZ2Uvdm5kLm5ldC1mcHgnLCBbJ2ZweCcsICducHgnXV0sXG4gICAgWydpbWFnZS92bmQucm4tcmVhbGZsYXNoJywgJ3JmJ10sXG4gICAgWydpbWFnZS92bmQucm4tcmVhbHBpeCcsICdycCddLFxuICAgIFsnaW1hZ2Uvdm5kLndhcC53Ym1wJywgJ3dibXAnXSxcbiAgICBbJ2ltYWdlL3ZuZC54aWZmJywgJ3hpZiddLFxuICAgIFsnaW1hZ2Uvd2VicCcsICd3ZWJwJ10sXG4gICAgWydpbWFnZS94LWNtdS1yYXN0ZXInLCAncmFzJ10sXG4gICAgWydpbWFnZS94LWNteCcsICdjbXgnXSxcbiAgICBbJ2ltYWdlL3gtZHdnJywgWydkd2cnLCAnZHhmJywgJ3N2ZiddXSxcbiAgICBbJ2ltYWdlL3gtZnJlZWhhbmQnLCAnZmgnXSxcbiAgICBbJ2ltYWdlL3gtaWNvbicsICdpY28nXSxcbiAgICBbJ2ltYWdlL3gtamcnLCAnYXJ0J10sXG4gICAgWydpbWFnZS94LWpwcycsICdqcHMnXSxcbiAgICBbJ2ltYWdlL3gtbmlmZicsIFsnbmlmZicsICduaWYnXV0sXG4gICAgWydpbWFnZS94LXBjeCcsICdwY3gnXSxcbiAgICBbJ2ltYWdlL3gtcGljdCcsIFsncGN0JywgJ3BpYyddXSxcbiAgICBbJ2ltYWdlL3gtcG9ydGFibGUtYW55bWFwJywgJ3BubSddLFxuICAgIFsnaW1hZ2UveC1wb3J0YWJsZS1iaXRtYXAnLCAncGJtJ10sXG4gICAgWydpbWFnZS94LXBvcnRhYmxlLWdyYXltYXAnLCAncGdtJ10sXG4gICAgWydpbWFnZS94LXBvcnRhYmxlLWdyZXltYXAnLCAncGdtJ10sXG4gICAgWydpbWFnZS94LXBvcnRhYmxlLXBpeG1hcCcsICdwcG0nXSxcbiAgICBbJ2ltYWdlL3gtcXVpY2t0aW1lJywgWydxaWYnLCAncXRpJywgJ3F0aWYnXV0sXG4gICAgWydpbWFnZS94LXJnYicsICdyZ2InXSxcbiAgICBbJ2ltYWdlL3gtdGlmZicsIFsndGlmJywgJ3RpZmYnXV0sXG4gICAgWydpbWFnZS94LXdpbmRvd3MtYm1wJywgJ2JtcCddLFxuICAgIFsnaW1hZ2UveC14Yml0bWFwJywgJ3hibSddLFxuICAgIFsnaW1hZ2UveC14Ym0nLCAneGJtJ10sXG4gICAgWydpbWFnZS94LXhwaXhtYXAnLCBbJ3hwbScsICdwbSddXSxcbiAgICBbJ2ltYWdlL3gteHdkJywgJ3h3ZCddLFxuICAgIFsnaW1hZ2UveC14d2luZG93ZHVtcCcsICd4d2QnXSxcbiAgICBbJ2ltYWdlL3hibScsICd4Ym0nXSxcbiAgICBbJ2ltYWdlL3hwbScsICd4cG0nXSxcbiAgICBbJ21lc3NhZ2UvcmZjODIyJywgWydlbWwnLCAnbWh0JywgJ21odG1sJywgJ253cycsICdtaW1lJ11dLFxuICAgIFsnbW9kZWwvaWdlcycsIFsnaWdlcycsICdpZ3MnXV0sXG4gICAgWydtb2RlbC9tZXNoJywgJ21zaCddLFxuICAgIFsnbW9kZWwvdm5kLmNvbGxhZGEreG1sJywgJ2RhZSddLFxuICAgIFsnbW9kZWwvdm5kLmR3ZicsICdkd2YnXSxcbiAgICBbJ21vZGVsL3ZuZC5nZGwnLCAnZ2RsJ10sXG4gICAgWydtb2RlbC92bmQuZ3R3JywgJ2d0dyddLFxuICAgIFsnbW9kZWwvdm5kLm10cycsICdtdHMnXSxcbiAgICBbJ21vZGVsL3ZuZC52dHUnLCAndnR1J10sXG4gICAgWydtb2RlbC92cm1sJywgWyd2cm1sJywgJ3dybCcsICd3cnonXV0sXG4gICAgWydtb2RlbC94LXBvdicsICdwb3YnXSxcbiAgICBbJ211bHRpcGFydC94LWd6aXAnLCAnZ3ppcCddLFxuICAgIFsnbXVsdGlwYXJ0L3gtdXN0YXInLCAndXN0YXInXSxcbiAgICBbJ211bHRpcGFydC94LXppcCcsICd6aXAnXSxcbiAgICBbJ211c2ljL2NyZXNjZW5kbycsIFsnbWlkJywgJ21pZGknXV0sXG4gICAgWydtdXNpYy94LWthcmFva2UnLCAna2FyJ10sXG4gICAgWydwYWxlb3Z1L3gtcHYnLCAncHZ1J10sXG4gICAgWyd0ZXh0L2FzcCcsICdhc3AnXSxcbiAgICBbJ3RleHQvY2FsZW5kYXInLCAnaWNzJ10sXG4gICAgWyd0ZXh0L2NzcycsICdjc3MnXSxcbiAgICBbJ3RleHQvY3N2JywgJ2NzdiddLFxuICAgIFsndGV4dC9lY21hc2NyaXB0JywgJ2pzJ10sXG4gICAgWyd0ZXh0L2gzMjMnLCAnMzIzJ10sXG4gICAgWyd0ZXh0L2h0bWwnLCBbJ2h0bWwnLCAnaHRtJywgJ3N0bScsICdhY2dpJywgJ2h0bWxzJywgJ2h0eCcsICdzaHRtbCddXSxcbiAgICBbJ3RleHQvaXVscycsICd1bHMnXSxcbiAgICBbJ3RleHQvamF2YXNjcmlwdCcsICdqcyddLFxuICAgIFsndGV4dC9tY2YnLCAnbWNmJ10sXG4gICAgWyd0ZXh0L24zJywgJ24zJ10sXG4gICAgWyd0ZXh0L3Bhc2NhbCcsICdwYXMnXSxcbiAgICBbXG4gICAgICAgICd0ZXh0L3BsYWluJyxcbiAgICAgICAgW1xuICAgICAgICAgICAgJ3R4dCcsXG4gICAgICAgICAgICAnYmFzJyxcbiAgICAgICAgICAgICdjJyxcbiAgICAgICAgICAgICdoJyxcbiAgICAgICAgICAgICdjKysnLFxuICAgICAgICAgICAgJ2NjJyxcbiAgICAgICAgICAgICdjb20nLFxuICAgICAgICAgICAgJ2NvbmYnLFxuICAgICAgICAgICAgJ2N4eCcsXG4gICAgICAgICAgICAnZGVmJyxcbiAgICAgICAgICAgICdmJyxcbiAgICAgICAgICAgICdmOTAnLFxuICAgICAgICAgICAgJ2ZvcicsXG4gICAgICAgICAgICAnZycsXG4gICAgICAgICAgICAnaGgnLFxuICAgICAgICAgICAgJ2lkYycsXG4gICAgICAgICAgICAnamF2JyxcbiAgICAgICAgICAgICdqYXZhJyxcbiAgICAgICAgICAgICdsaXN0JyxcbiAgICAgICAgICAgICdsb2cnLFxuICAgICAgICAgICAgJ2xzdCcsXG4gICAgICAgICAgICAnbScsXG4gICAgICAgICAgICAnbWFyJyxcbiAgICAgICAgICAgICdwbCcsXG4gICAgICAgICAgICAnc2RtbCcsXG4gICAgICAgICAgICAndGV4dCdcbiAgICAgICAgXVxuICAgIF0sXG4gICAgWyd0ZXh0L3BsYWluLWJhcycsICdwYXInXSxcbiAgICBbJ3RleHQvcHJzLmxpbmVzLnRhZycsICdkc2MnXSxcbiAgICBbJ3RleHQvcmljaHRleHQnLCBbJ3J0eCcsICdydCcsICdydGYnXV0sXG4gICAgWyd0ZXh0L3NjcmlwbGV0JywgJ3dzYyddLFxuICAgIFsndGV4dC9zY3JpcHRsZXQnLCAnc2N0J10sXG4gICAgWyd0ZXh0L3NnbWwnLCBbJ3NnbScsICdzZ21sJ11dLFxuICAgIFsndGV4dC90YWItc2VwYXJhdGVkLXZhbHVlcycsICd0c3YnXSxcbiAgICBbJ3RleHQvdHJvZmYnLCAndCddLFxuICAgIFsndGV4dC90dXJ0bGUnLCAndHRsJ10sXG4gICAgWyd0ZXh0L3VyaS1saXN0JywgWyd1bmknLCAndW5pcycsICd1cmknLCAndXJpcyddXSxcbiAgICBbJ3RleHQvdm5kLmFiYycsICdhYmMnXSxcbiAgICBbJ3RleHQvdm5kLmN1cmwnLCAnY3VybCddLFxuICAgIFsndGV4dC92bmQuY3VybC5kY3VybCcsICdkY3VybCddLFxuICAgIFsndGV4dC92bmQuY3VybC5tY3VybCcsICdtY3VybCddLFxuICAgIFsndGV4dC92bmQuY3VybC5zY3VybCcsICdzY3VybCddLFxuICAgIFsndGV4dC92bmQuZmx5JywgJ2ZseSddLFxuICAgIFsndGV4dC92bmQuZm1pLmZsZXhzdG9yJywgJ2ZseCddLFxuICAgIFsndGV4dC92bmQuZ3JhcGh2aXonLCAnZ3YnXSxcbiAgICBbJ3RleHQvdm5kLmluM2QuM2RtbCcsICczZG1sJ10sXG4gICAgWyd0ZXh0L3ZuZC5pbjNkLnNwb3QnLCAnc3BvdCddLFxuICAgIFsndGV4dC92bmQucm4tcmVhbHRleHQnLCAncnQnXSxcbiAgICBbJ3RleHQvdm5kLnN1bi5qMm1lLmFwcC1kZXNjcmlwdG9yJywgJ2phZCddLFxuICAgIFsndGV4dC92bmQud2FwLndtbCcsICd3bWwnXSxcbiAgICBbJ3RleHQvdm5kLndhcC53bWxzY3JpcHQnLCAnd21scyddLFxuICAgIFsndGV4dC93ZWJ2aWV3aHRtbCcsICdodHQnXSxcbiAgICBbJ3RleHQveC1hc20nLCBbJ2FzbScsICdzJ11dLFxuICAgIFsndGV4dC94LWF1ZGlvc29mdC1pbnRyYScsICdhaXAnXSxcbiAgICBbJ3RleHQveC1jJywgWydjJywgJ2NjJywgJ2NwcCddXSxcbiAgICBbJ3RleHQveC1jb21wb25lbnQnLCAnaHRjJ10sXG4gICAgWyd0ZXh0L3gtZm9ydHJhbicsIFsnZm9yJywgJ2YnLCAnZjc3JywgJ2Y5MCddXSxcbiAgICBbJ3RleHQveC1oJywgWydoJywgJ2hoJ11dLFxuICAgIFsndGV4dC94LWphdmEtc291cmNlJywgWydqYXZhJywgJ2phdiddXSxcbiAgICBbJ3RleHQveC1qYXZhLXNvdXJjZSxqYXZhJywgJ2phdmEnXSxcbiAgICBbJ3RleHQveC1sYS1hc2YnLCAnbHN4J10sXG4gICAgWyd0ZXh0L3gtbScsICdtJ10sXG4gICAgWyd0ZXh0L3gtcGFzY2FsJywgJ3AnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQnLCAnaGxiJ10sXG4gICAgWyd0ZXh0L3gtc2NyaXB0LmNzaCcsICdjc2gnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQuZWxpc3AnLCAnZWwnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQuZ3VpbGUnLCAnc2NtJ10sXG4gICAgWyd0ZXh0L3gtc2NyaXB0LmtzaCcsICdrc2gnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQubGlzcCcsICdsc3AnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQucGVybCcsICdwbCddLFxuICAgIFsndGV4dC94LXNjcmlwdC5wZXJsLW1vZHVsZScsICdwbSddLFxuICAgIFsndGV4dC94LXNjcmlwdC5waHl0b24nLCAncHknXSxcbiAgICBbJ3RleHQveC1zY3JpcHQucmV4eCcsICdyZXh4J10sXG4gICAgWyd0ZXh0L3gtc2NyaXB0LnNjaGVtZScsICdzY20nXSxcbiAgICBbJ3RleHQveC1zY3JpcHQuc2gnLCAnc2gnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQudGNsJywgJ3RjbCddLFxuICAgIFsndGV4dC94LXNjcmlwdC50Y3NoJywgJ3Rjc2gnXSxcbiAgICBbJ3RleHQveC1zY3JpcHQuenNoJywgJ3pzaCddLFxuICAgIFsndGV4dC94LXNlcnZlci1wYXJzZWQtaHRtbCcsIFsnc2h0bWwnLCAnc3NpJ11dLFxuICAgIFsndGV4dC94LXNldGV4dCcsICdldHgnXSxcbiAgICBbJ3RleHQveC1zZ21sJywgWydzZ20nLCAnc2dtbCddXSxcbiAgICBbJ3RleHQveC1zcGVlY2gnLCBbJ3NwYycsICd0YWxrJ11dLFxuICAgIFsndGV4dC94LXVpbCcsICd1aWwnXSxcbiAgICBbJ3RleHQveC11dWVuY29kZScsIFsndXUnLCAndXVlJ11dLFxuICAgIFsndGV4dC94LXZjYWxlbmRhcicsICd2Y3MnXSxcbiAgICBbJ3RleHQveC12Y2FyZCcsICd2Y2YnXSxcbiAgICBbJ3RleHQveG1sJywgJ3htbCddLFxuICAgIFsndmlkZW8vM2dwcCcsICczZ3AnXSxcbiAgICBbJ3ZpZGVvLzNncHAyJywgJzNnMiddLFxuICAgIFsndmlkZW8vYW5pbWFmbGV4JywgJ2FmbCddLFxuICAgIFsndmlkZW8vYXZpJywgJ2F2aSddLFxuICAgIFsndmlkZW8vYXZzLXZpZGVvJywgJ2F2cyddLFxuICAgIFsndmlkZW8vZGwnLCAnZGwnXSxcbiAgICBbJ3ZpZGVvL2ZsaScsICdmbGknXSxcbiAgICBbJ3ZpZGVvL2dsJywgJ2dsJ10sXG4gICAgWyd2aWRlby9oMjYxJywgJ2gyNjEnXSxcbiAgICBbJ3ZpZGVvL2gyNjMnLCAnaDI2MyddLFxuICAgIFsndmlkZW8vaDI2NCcsICdoMjY0J10sXG4gICAgWyd2aWRlby9qcGVnJywgJ2pwZ3YnXSxcbiAgICBbJ3ZpZGVvL2pwbScsICdqcG0nXSxcbiAgICBbJ3ZpZGVvL21qMicsICdtajInXSxcbiAgICBbJ3ZpZGVvL21wNCcsICdtcDQnXSxcbiAgICBbJ3ZpZGVvL21wZWcnLCBbJ21wZWcnLCAnbXAyJywgJ21wYScsICdtcGUnLCAnbXBnJywgJ21wdjInLCAnbTF2JywgJ20ydicsICdtcDMnXV0sXG4gICAgWyd2aWRlby9tc3ZpZGVvJywgJ2F2aSddLFxuICAgIFsndmlkZW8vb2dnJywgJ29ndiddLFxuICAgIFsndmlkZW8vcXVpY2t0aW1lJywgWydtb3YnLCAncXQnLCAnbW9vdiddXSxcbiAgICBbJ3ZpZGVvL3ZkbycsICd2ZG8nXSxcbiAgICBbJ3ZpZGVvL3Zpdm8nLCBbJ3ZpdicsICd2aXZvJ11dLFxuICAgIFsndmlkZW8vdm5kLmRlY2UuaGQnLCAndXZoJ10sXG4gICAgWyd2aWRlby92bmQuZGVjZS5tb2JpbGUnLCAndXZtJ10sXG4gICAgWyd2aWRlby92bmQuZGVjZS5wZCcsICd1dnAnXSxcbiAgICBbJ3ZpZGVvL3ZuZC5kZWNlLnNkJywgJ3V2cyddLFxuICAgIFsndmlkZW8vdm5kLmRlY2UudmlkZW8nLCAndXZ2J10sXG4gICAgWyd2aWRlby92bmQuZnZ0JywgJ2Z2dCddLFxuICAgIFsndmlkZW8vdm5kLm1wZWd1cmwnLCAnbXh1J10sXG4gICAgWyd2aWRlby92bmQubXMtcGxheXJlYWR5Lm1lZGlhLnB5dicsICdweXYnXSxcbiAgICBbJ3ZpZGVvL3ZuZC5ybi1yZWFsdmlkZW8nLCAncnYnXSxcbiAgICBbJ3ZpZGVvL3ZuZC51dnZ1Lm1wNCcsICd1dnUnXSxcbiAgICBbJ3ZpZGVvL3ZuZC52aXZvJywgWyd2aXYnLCAndml2byddXSxcbiAgICBbJ3ZpZGVvL3Zvc2FpYycsICd2b3MnXSxcbiAgICBbJ3ZpZGVvL3dlYm0nLCAnd2VibSddLFxuICAgIFsndmlkZW8veC1hbXQtZGVtb3J1bicsICd4ZHInXSxcbiAgICBbJ3ZpZGVvL3gtYW10LXNob3dydW4nLCAneHNyJ10sXG4gICAgWyd2aWRlby94LWF0b21pYzNkLWZlYXR1cmUnLCAnZm1mJ10sXG4gICAgWyd2aWRlby94LWRsJywgJ2RsJ10sXG4gICAgWyd2aWRlby94LWR2JywgWydkaWYnLCAnZHYnXV0sXG4gICAgWyd2aWRlby94LWY0dicsICdmNHYnXSxcbiAgICBbJ3ZpZGVvL3gtZmxpJywgJ2ZsaSddLFxuICAgIFsndmlkZW8veC1mbHYnLCAnZmx2J10sXG4gICAgWyd2aWRlby94LWdsJywgJ2dsJ10sXG4gICAgWyd2aWRlby94LWlzdmlkZW8nLCAnaXN1J10sXG4gICAgWyd2aWRlby94LWxhLWFzZicsIFsnbHNmJywgJ2xzeCddXSxcbiAgICBbJ3ZpZGVvL3gtbTR2JywgJ200diddLFxuICAgIFsndmlkZW8veC1tb3Rpb24tanBlZycsICdtanBnJ10sXG4gICAgWyd2aWRlby94LW1wZWcnLCBbJ21wMycsICdtcDInXV0sXG4gICAgWyd2aWRlby94LW1wZXEyYScsICdtcDInXSxcbiAgICBbJ3ZpZGVvL3gtbXMtYXNmJywgWydhc2YnLCAnYXNyJywgJ2FzeCddXSxcbiAgICBbJ3ZpZGVvL3gtbXMtYXNmLXBsdWdpbicsICdhc3gnXSxcbiAgICBbJ3ZpZGVvL3gtbXMtd20nLCAnd20nXSxcbiAgICBbJ3ZpZGVvL3gtbXMtd212JywgJ3dtdiddLFxuICAgIFsndmlkZW8veC1tcy13bXgnLCAnd214J10sXG4gICAgWyd2aWRlby94LW1zLXd2eCcsICd3dngnXSxcbiAgICBbJ3ZpZGVvL3gtbXN2aWRlbycsICdhdmknXSxcbiAgICBbJ3ZpZGVvL3gtcXRjJywgJ3F0YyddLFxuICAgIFsndmlkZW8veC1zY20nLCAnc2NtJ10sXG4gICAgWyd2aWRlby94LXNnaS1tb3ZpZScsIFsnbW92aWUnLCAnbXYnXV0sXG4gICAgWyd3aW5kb3dzL21ldGFmaWxlJywgJ3dtZiddLFxuICAgIFsnd3d3L21pbWUnLCAnbWltZSddLFxuICAgIFsneC1jb25mZXJlbmNlL3gtY29vbHRhbGsnLCAnaWNlJ10sXG4gICAgWyd4LW11c2ljL3gtbWlkaScsIFsnbWlkJywgJ21pZGknXV0sXG4gICAgWyd4LXdvcmxkL3gtM2RtZicsIFsnM2RtJywgJzNkbWYnLCAncWQzJywgJ3FkM2QnXV0sXG4gICAgWyd4LXdvcmxkL3gtc3ZyJywgJ3N2ciddLFxuICAgIFsneC13b3JsZC94LXZybWwnLCBbJ2ZscicsICd2cm1sJywgJ3dybCcsICd3cnonLCAneGFmJywgJ3hvZiddXSxcbiAgICBbJ3gtd29ybGQveC12cnQnLCAndnJ0J10sXG4gICAgWyd4Z2wvZHJhd2luZycsICd4Z3onXSxcbiAgICBbJ3hnbC9tb3ZpZScsICd4bXonXVxuXSk7XG5jb25zdCBleHRlbnNpb25zID0gbmV3IE1hcChbXG4gICAgWycxMjMnLCAnYXBwbGljYXRpb24vdm5kLmxvdHVzLTEtMi0zJ10sXG4gICAgWyczMjMnLCAndGV4dC9oMzIzJ10sXG4gICAgWycqJywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbSddLFxuICAgIFsnM2RtJywgJ3gtd29ybGQveC0zZG1mJ10sXG4gICAgWyczZG1mJywgJ3gtd29ybGQveC0zZG1mJ10sXG4gICAgWyczZG1sJywgJ3RleHQvdm5kLmluM2QuM2RtbCddLFxuICAgIFsnM2cyJywgJ3ZpZGVvLzNncHAyJ10sXG4gICAgWyczZ3AnLCAndmlkZW8vM2dwcCddLFxuICAgIFsnN3onLCAnYXBwbGljYXRpb24veC03ei1jb21wcmVzc2VkJ10sXG4gICAgWydhJywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbSddLFxuICAgIFsnYWFiJywgJ2FwcGxpY2F0aW9uL3gtYXV0aG9yd2FyZS1iaW4nXSxcbiAgICBbJ2FhYycsICdhdWRpby94LWFhYyddLFxuICAgIFsnYWFtJywgJ2FwcGxpY2F0aW9uL3gtYXV0aG9yd2FyZS1tYXAnXSxcbiAgICBbJ2FhcycsICdhcHBsaWNhdGlvbi94LWF1dGhvcndhcmUtc2VnJ10sXG4gICAgWydhYmMnLCAndGV4dC92bmQuYWJjJ10sXG4gICAgWydhYncnLCAnYXBwbGljYXRpb24veC1hYml3b3JkJ10sXG4gICAgWydhYycsICdhcHBsaWNhdGlvbi9wa2l4LWF0dHItY2VydCddLFxuICAgIFsnYWNjJywgJ2FwcGxpY2F0aW9uL3ZuZC5hbWVyaWNhbmR5bmFtaWNzLmFjYyddLFxuICAgIFsnYWNlJywgJ2FwcGxpY2F0aW9uL3gtYWNlLWNvbXByZXNzZWQnXSxcbiAgICBbJ2FjZ2knLCAndGV4dC9odG1sJ10sXG4gICAgWydhY3UnLCAnYXBwbGljYXRpb24vdm5kLmFjdWNvYm9sJ10sXG4gICAgWydhY3gnLCAnYXBwbGljYXRpb24vaW50ZXJuZXQtcHJvcGVydHktc3RyZWFtJ10sXG4gICAgWydhZHAnLCAnYXVkaW8vYWRwY20nXSxcbiAgICBbJ2FlcCcsICdhcHBsaWNhdGlvbi92bmQuYXVkaW9ncmFwaCddLFxuICAgIFsnYWZsJywgJ3ZpZGVvL2FuaW1hZmxleCddLFxuICAgIFsnYWZwJywgJ2FwcGxpY2F0aW9uL3ZuZC5pYm0ubW9kY2FwJ10sXG4gICAgWydhaGVhZCcsICdhcHBsaWNhdGlvbi92bmQuYWhlYWQuc3BhY2UnXSxcbiAgICBbJ2FpJywgJ2FwcGxpY2F0aW9uL3Bvc3RzY3JpcHQnXSxcbiAgICBbJ2FpZicsIFsnYXVkaW8vYWlmZicsICdhdWRpby94LWFpZmYnXV0sXG4gICAgWydhaWZjJywgWydhdWRpby9haWZmJywgJ2F1ZGlvL3gtYWlmZiddXSxcbiAgICBbJ2FpZmYnLCBbJ2F1ZGlvL2FpZmYnLCAnYXVkaW8veC1haWZmJ11dLFxuICAgIFsnYWltJywgJ2FwcGxpY2F0aW9uL3gtYWltJ10sXG4gICAgWydhaXAnLCAndGV4dC94LWF1ZGlvc29mdC1pbnRyYSddLFxuICAgIFsnYWlyJywgJ2FwcGxpY2F0aW9uL3ZuZC5hZG9iZS5haXItYXBwbGljYXRpb24taW5zdGFsbGVyLXBhY2thZ2UremlwJ10sXG4gICAgWydhaXQnLCAnYXBwbGljYXRpb24vdm5kLmR2Yi5haXQnXSxcbiAgICBbJ2FtaScsICdhcHBsaWNhdGlvbi92bmQuYW1pZ2EuYW1pJ10sXG4gICAgWydhbmknLCAnYXBwbGljYXRpb24veC1uYXZpLWFuaW1hdGlvbiddLFxuICAgIFsnYW9zJywgJ2FwcGxpY2F0aW9uL3gtbm9raWEtOTAwMC1jb21tdW5pY2F0b3ItYWRkLW9uLXNvZnR3YXJlJ10sXG4gICAgWydhcGsnLCAnYXBwbGljYXRpb24vdm5kLmFuZHJvaWQucGFja2FnZS1hcmNoaXZlJ10sXG4gICAgWydhcHBsaWNhdGlvbicsICdhcHBsaWNhdGlvbi94LW1zLWFwcGxpY2F0aW9uJ10sXG4gICAgWydhcHInLCAnYXBwbGljYXRpb24vdm5kLmxvdHVzLWFwcHJvYWNoJ10sXG4gICAgWydhcHMnLCAnYXBwbGljYXRpb24vbWltZSddLFxuICAgIFsnYXJjJywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbSddLFxuICAgIFsnYXJqJywgWydhcHBsaWNhdGlvbi9hcmonLCAnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJ11dLFxuICAgIFsnYXJ0JywgJ2ltYWdlL3gtamcnXSxcbiAgICBbJ2FzZicsICd2aWRlby94LW1zLWFzZiddLFxuICAgIFsnYXNtJywgJ3RleHQveC1hc20nXSxcbiAgICBbJ2FzbycsICdhcHBsaWNhdGlvbi92bmQuYWNjcGFjLnNpbXBseS5hc28nXSxcbiAgICBbJ2FzcCcsICd0ZXh0L2FzcCddLFxuICAgIFsnYXNyJywgJ3ZpZGVvL3gtbXMtYXNmJ10sXG4gICAgWydhc3gnLCBbJ3ZpZGVvL3gtbXMtYXNmJywgJ2FwcGxpY2F0aW9uL3gtbXBsYXllcjInLCAndmlkZW8veC1tcy1hc2YtcGx1Z2luJ11dLFxuICAgIFsnYXRjJywgJ2FwcGxpY2F0aW9uL3ZuZC5hY3Vjb3JwJ10sXG4gICAgWydhdG9tY2F0JywgJ2FwcGxpY2F0aW9uL2F0b21jYXQreG1sJ10sXG4gICAgWydhdG9tc3ZjJywgJ2FwcGxpY2F0aW9uL2F0b21zdmMreG1sJ10sXG4gICAgWydhdHgnLCAnYXBwbGljYXRpb24vdm5kLmFudGl4LmdhbWUtY29tcG9uZW50J10sXG4gICAgWydhdScsIFsnYXVkaW8vYmFzaWMnLCAnYXVkaW8veC1hdSddXSxcbiAgICBbJ2F2aScsIFsndmlkZW8vYXZpJywgJ3ZpZGVvL21zdmlkZW8nLCAnYXBwbGljYXRpb24veC10cm9mZi1tc3ZpZGVvJywgJ3ZpZGVvL3gtbXN2aWRlbyddXSxcbiAgICBbJ2F2cycsICd2aWRlby9hdnMtdmlkZW8nXSxcbiAgICBbJ2F3JywgJ2FwcGxpY2F0aW9uL2FwcGxpeHdhcmUnXSxcbiAgICBbJ2F4cycsICdhcHBsaWNhdGlvbi9vbGVzY3JpcHQnXSxcbiAgICBbJ2F6ZicsICdhcHBsaWNhdGlvbi92bmQuYWlyemlwLmZpbGVzZWN1cmUuYXpmJ10sXG4gICAgWydhenMnLCAnYXBwbGljYXRpb24vdm5kLmFpcnppcC5maWxlc2VjdXJlLmF6cyddLFxuICAgIFsnYXp3JywgJ2FwcGxpY2F0aW9uL3ZuZC5hbWF6b24uZWJvb2snXSxcbiAgICBbJ2JhcycsICd0ZXh0L3BsYWluJ10sXG4gICAgWydiY3BpbycsICdhcHBsaWNhdGlvbi94LWJjcGlvJ10sXG4gICAgWydiZGYnLCAnYXBwbGljYXRpb24veC1mb250LWJkZiddLFxuICAgIFsnYmRtJywgJ2FwcGxpY2F0aW9uL3ZuZC5zeW5jbWwuZG0rd2J4bWwnXSxcbiAgICBbJ2JlZCcsICdhcHBsaWNhdGlvbi92bmQucmVhbHZuYy5iZWQnXSxcbiAgICBbJ2JoMicsICdhcHBsaWNhdGlvbi92bmQuZnVqaXRzdS5vYXN5c3BycyddLFxuICAgIFtcbiAgICAgICAgJ2JpbicsXG4gICAgICAgIFsnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJywgJ2FwcGxpY2F0aW9uL21hYy1iaW5hcnknLCAnYXBwbGljYXRpb24vbWFjYmluYXJ5JywgJ2FwcGxpY2F0aW9uL3gtbWFjYmluYXJ5JywgJ2FwcGxpY2F0aW9uL3gtYmluYXJ5J11cbiAgICBdLFxuICAgIFsnYm0nLCAnaW1hZ2UvYm1wJ10sXG4gICAgWydibWknLCAnYXBwbGljYXRpb24vdm5kLmJtaSddLFxuICAgIFsnYm1wJywgWydpbWFnZS9ibXAnLCAnaW1hZ2UveC13aW5kb3dzLWJtcCddXSxcbiAgICBbJ2JvbycsICdhcHBsaWNhdGlvbi9ib29rJ10sXG4gICAgWydib29rJywgJ2FwcGxpY2F0aW9uL2Jvb2snXSxcbiAgICBbJ2JveCcsICdhcHBsaWNhdGlvbi92bmQucHJldmlld3N5c3RlbXMuYm94J10sXG4gICAgWydib3onLCAnYXBwbGljYXRpb24veC1iemlwMiddLFxuICAgIFsnYnNoJywgJ2FwcGxpY2F0aW9uL3gtYnNoJ10sXG4gICAgWydidGlmJywgJ2ltYWdlL3Bycy5idGlmJ10sXG4gICAgWydieicsICdhcHBsaWNhdGlvbi94LWJ6aXAnXSxcbiAgICBbJ2J6MicsICdhcHBsaWNhdGlvbi94LWJ6aXAyJ10sXG4gICAgWydjJywgWyd0ZXh0L3BsYWluJywgJ3RleHQveC1jJ11dLFxuICAgIFsnYysrJywgJ3RleHQvcGxhaW4nXSxcbiAgICBbJ2MxMWFtYycsICdhcHBsaWNhdGlvbi92bmQuY2x1ZXRydXN0LmNhcnRvbW9iaWxlLWNvbmZpZyddLFxuICAgIFsnYzExYW16JywgJ2FwcGxpY2F0aW9uL3ZuZC5jbHVldHJ1c3QuY2FydG9tb2JpbGUtY29uZmlnLXBrZyddLFxuICAgIFsnYzRnJywgJ2FwcGxpY2F0aW9uL3ZuZC5jbG9uay5jNGdyb3VwJ10sXG4gICAgWydjYWInLCAnYXBwbGljYXRpb24vdm5kLm1zLWNhYi1jb21wcmVzc2VkJ10sXG4gICAgWydjYXInLCAnYXBwbGljYXRpb24vdm5kLmN1cmwuY2FyJ10sXG4gICAgWydjYXQnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wa2lzZWNjYXQnLCAnYXBwbGljYXRpb24vdm5kLm1zLXBraS5zZWNjYXQnXV0sXG4gICAgWydjYycsIFsndGV4dC9wbGFpbicsICd0ZXh0L3gtYyddXSxcbiAgICBbJ2NjYWQnLCAnYXBwbGljYXRpb24vY2xhcmlzY2FkJ10sXG4gICAgWydjY28nLCAnYXBwbGljYXRpb24veC1jb2NvYSddLFxuICAgIFsnY2N4bWwnLCAnYXBwbGljYXRpb24vY2N4bWwreG1sLCddLFxuICAgIFsnY2RiY21zZycsICdhcHBsaWNhdGlvbi92bmQuY29udGFjdC5jbXNnJ10sXG4gICAgWydjZGYnLCBbJ2FwcGxpY2F0aW9uL2NkZicsICdhcHBsaWNhdGlvbi94LWNkZicsICdhcHBsaWNhdGlvbi94LW5ldGNkZiddXSxcbiAgICBbJ2Nka2V5JywgJ2FwcGxpY2F0aW9uL3ZuZC5tZWRpYXN0YXRpb24uY2RrZXknXSxcbiAgICBbJ2NkbWlhJywgJ2FwcGxpY2F0aW9uL2NkbWktY2FwYWJpbGl0eSddLFxuICAgIFsnY2RtaWMnLCAnYXBwbGljYXRpb24vY2RtaS1jb250YWluZXInXSxcbiAgICBbJ2NkbWlkJywgJ2FwcGxpY2F0aW9uL2NkbWktZG9tYWluJ10sXG4gICAgWydjZG1pbycsICdhcHBsaWNhdGlvbi9jZG1pLW9iamVjdCddLFxuICAgIFsnY2RtaXEnLCAnYXBwbGljYXRpb24vY2RtaS1xdWV1ZSddLFxuICAgIFsnY2R4JywgJ2NoZW1pY2FsL3gtY2R4J10sXG4gICAgWydjZHhtbCcsICdhcHBsaWNhdGlvbi92bmQuY2hlbWRyYXcreG1sJ10sXG4gICAgWydjZHknLCAnYXBwbGljYXRpb24vdm5kLmNpbmRlcmVsbGEnXSxcbiAgICBbJ2NlcicsIFsnYXBwbGljYXRpb24vcGtpeC1jZXJ0JywgJ2FwcGxpY2F0aW9uL3gteDUwOS1jYS1jZXJ0J11dLFxuICAgIFsnY2dtJywgJ2ltYWdlL2NnbSddLFxuICAgIFsnY2hhJywgJ2FwcGxpY2F0aW9uL3gtY2hhdCddLFxuICAgIFsnY2hhdCcsICdhcHBsaWNhdGlvbi94LWNoYXQnXSxcbiAgICBbJ2NobScsICdhcHBsaWNhdGlvbi92bmQubXMtaHRtbGhlbHAnXSxcbiAgICBbJ2NocnQnLCAnYXBwbGljYXRpb24vdm5kLmtkZS5rY2hhcnQnXSxcbiAgICBbJ2NpZicsICdjaGVtaWNhbC94LWNpZiddLFxuICAgIFsnY2lpJywgJ2FwcGxpY2F0aW9uL3ZuZC5hbnNlci13ZWItY2VydGlmaWNhdGUtaXNzdWUtaW5pdGlhdGlvbiddLFxuICAgIFsnY2lsJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1hcnRnYWxyeSddLFxuICAgIFsnY2xhJywgJ2FwcGxpY2F0aW9uL3ZuZC5jbGF5bW9yZSddLFxuICAgIFtcbiAgICAgICAgJ2NsYXNzJyxcbiAgICAgICAgWydhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nLCAnYXBwbGljYXRpb24vamF2YScsICdhcHBsaWNhdGlvbi9qYXZhLWJ5dGUtY29kZScsICdhcHBsaWNhdGlvbi9qYXZhLXZtJywgJ2FwcGxpY2F0aW9uL3gtamF2YS1jbGFzcyddXG4gICAgXSxcbiAgICBbJ2Nsa2snLCAnYXBwbGljYXRpb24vdm5kLmNyaWNrLmNsaWNrZXIua2V5Ym9hcmQnXSxcbiAgICBbJ2Nsa3AnLCAnYXBwbGljYXRpb24vdm5kLmNyaWNrLmNsaWNrZXIucGFsZXR0ZSddLFxuICAgIFsnY2xrdCcsICdhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlci50ZW1wbGF0ZSddLFxuICAgIFsnY2xrdycsICdhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlci53b3JkYmFuayddLFxuICAgIFsnY2xreCcsICdhcHBsaWNhdGlvbi92bmQuY3JpY2suY2xpY2tlciddLFxuICAgIFsnY2xwJywgJ2FwcGxpY2F0aW9uL3gtbXNjbGlwJ10sXG4gICAgWydjbWMnLCAnYXBwbGljYXRpb24vdm5kLmNvc21vY2FsbGVyJ10sXG4gICAgWydjbWRmJywgJ2NoZW1pY2FsL3gtY21kZiddLFxuICAgIFsnY21sJywgJ2NoZW1pY2FsL3gtY21sJ10sXG4gICAgWydjbXAnLCAnYXBwbGljYXRpb24vdm5kLnllbGxvd3JpdmVyLWN1c3RvbS1tZW51J10sXG4gICAgWydjbXgnLCAnaW1hZ2UveC1jbXgnXSxcbiAgICBbJ2NvZCcsIFsnaW1hZ2UvY2lzLWNvZCcsICdhcHBsaWNhdGlvbi92bmQucmltLmNvZCddXSxcbiAgICBbJ2NvbScsIFsnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJywgJ3RleHQvcGxhaW4nXV0sXG4gICAgWydjb25mJywgJ3RleHQvcGxhaW4nXSxcbiAgICBbJ2NwaW8nLCAnYXBwbGljYXRpb24veC1jcGlvJ10sXG4gICAgWydjcHAnLCAndGV4dC94LWMnXSxcbiAgICBbJ2NwdCcsIFsnYXBwbGljYXRpb24vbWFjLWNvbXBhY3Rwcm8nLCAnYXBwbGljYXRpb24veC1jb21wYWN0cHJvJywgJ2FwcGxpY2F0aW9uL3gtY3B0J11dLFxuICAgIFsnY3JkJywgJ2FwcGxpY2F0aW9uL3gtbXNjYXJkZmlsZSddLFxuICAgIFsnY3JsJywgWydhcHBsaWNhdGlvbi9wa2l4LWNybCcsICdhcHBsaWNhdGlvbi9wa2NzLWNybCddXSxcbiAgICBbJ2NydCcsIFsnYXBwbGljYXRpb24vcGtpeC1jZXJ0JywgJ2FwcGxpY2F0aW9uL3gteDUwOS11c2VyLWNlcnQnLCAnYXBwbGljYXRpb24veC14NTA5LWNhLWNlcnQnXV0sXG4gICAgWydjcnlwdG9ub3RlJywgJ2FwcGxpY2F0aW9uL3ZuZC5yaWcuY3J5cHRvbm90ZSddLFxuICAgIFsnY3NoJywgWyd0ZXh0L3gtc2NyaXB0LmNzaCcsICdhcHBsaWNhdGlvbi94LWNzaCddXSxcbiAgICBbJ2NzbWwnLCAnY2hlbWljYWwveC1jc21sJ10sXG4gICAgWydjc3AnLCAnYXBwbGljYXRpb24vdm5kLmNvbW1vbnNwYWNlJ10sXG4gICAgWydjc3MnLCBbJ3RleHQvY3NzJywgJ2FwcGxpY2F0aW9uL3gtcG9pbnRwbHVzJ11dLFxuICAgIFsnY3N2JywgJ3RleHQvY3N2J10sXG4gICAgWydjdScsICdhcHBsaWNhdGlvbi9jdS1zZWVtZSddLFxuICAgIFsnY3VybCcsICd0ZXh0L3ZuZC5jdXJsJ10sXG4gICAgWydjd3cnLCAnYXBwbGljYXRpb24vcHJzLmN3dyddLFxuICAgIFsnY3h4JywgJ3RleHQvcGxhaW4nXSxcbiAgICBbJ2RhZScsICdtb2RlbC92bmQuY29sbGFkYSt4bWwnXSxcbiAgICBbJ2RhZicsICdhcHBsaWNhdGlvbi92bmQubW9iaXVzLmRhZiddLFxuICAgIFsnZGF2bW91bnQnLCAnYXBwbGljYXRpb24vZGF2bW91bnQreG1sJ10sXG4gICAgWydkY3InLCAnYXBwbGljYXRpb24veC1kaXJlY3RvciddLFxuICAgIFsnZGN1cmwnLCAndGV4dC92bmQuY3VybC5kY3VybCddLFxuICAgIFsnZGQyJywgJ2FwcGxpY2F0aW9uL3ZuZC5vbWEuZGQyK3htbCddLFxuICAgIFsnZGRkJywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppeGVyb3guZGRkJ10sXG4gICAgWydkZWInLCAnYXBwbGljYXRpb24veC1kZWJpYW4tcGFja2FnZSddLFxuICAgIFsnZGVlcHYnLCAnYXBwbGljYXRpb24veC1kZWVwdiddLFxuICAgIFsnZGVmJywgJ3RleHQvcGxhaW4nXSxcbiAgICBbJ2RlcicsICdhcHBsaWNhdGlvbi94LXg1MDktY2EtY2VydCddLFxuICAgIFsnZGZhYycsICdhcHBsaWNhdGlvbi92bmQuZHJlYW1mYWN0b3J5J10sXG4gICAgWydkaWYnLCAndmlkZW8veC1kdiddLFxuICAgIFsnZGlyJywgJ2FwcGxpY2F0aW9uL3gtZGlyZWN0b3InXSxcbiAgICBbJ2RpcycsICdhcHBsaWNhdGlvbi92bmQubW9iaXVzLmRpcyddLFxuICAgIFsnZGp2dScsICdpbWFnZS92bmQuZGp2dSddLFxuICAgIFsnZGwnLCBbJ3ZpZGVvL2RsJywgJ3ZpZGVvL3gtZGwnXV0sXG4gICAgWydkbGwnLCAnYXBwbGljYXRpb24veC1tc2Rvd25sb2FkJ10sXG4gICAgWydkbXMnLCAnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJ10sXG4gICAgWydkbmEnLCAnYXBwbGljYXRpb24vdm5kLmRuYSddLFxuICAgIFsnZG9jJywgJ2FwcGxpY2F0aW9uL21zd29yZCddLFxuICAgIFsnZG9jbScsICdhcHBsaWNhdGlvbi92bmQubXMtd29yZC5kb2N1bWVudC5tYWNyb2VuYWJsZWQuMTInXSxcbiAgICBbJ2RvY3gnLCAnYXBwbGljYXRpb24vdm5kLm9wZW54bWxmb3JtYXRzLW9mZmljZWRvY3VtZW50LndvcmRwcm9jZXNzaW5nbWwuZG9jdW1lbnQnXSxcbiAgICBbJ2RvdCcsICdhcHBsaWNhdGlvbi9tc3dvcmQnXSxcbiAgICBbJ2RvdG0nLCAnYXBwbGljYXRpb24vdm5kLm1zLXdvcmQudGVtcGxhdGUubWFjcm9lbmFibGVkLjEyJ10sXG4gICAgWydkb3R4JywgJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC53b3JkcHJvY2Vzc2luZ21sLnRlbXBsYXRlJ10sXG4gICAgWydkcCcsIFsnYXBwbGljYXRpb24vY29tbW9uZ3JvdW5kJywgJ2FwcGxpY2F0aW9uL3ZuZC5vc2dpLmRwJ11dLFxuICAgIFsnZHBnJywgJ2FwcGxpY2F0aW9uL3ZuZC5kcGdyYXBoJ10sXG4gICAgWydkcmEnLCAnYXVkaW8vdm5kLmRyYSddLFxuICAgIFsnZHJ3JywgJ2FwcGxpY2F0aW9uL2RyYWZ0aW5nJ10sXG4gICAgWydkc2MnLCAndGV4dC9wcnMubGluZXMudGFnJ10sXG4gICAgWydkc3NjJywgJ2FwcGxpY2F0aW9uL2Rzc2MrZGVyJ10sXG4gICAgWydkdGInLCAnYXBwbGljYXRpb24veC1kdGJvb2sreG1sJ10sXG4gICAgWydkdGQnLCAnYXBwbGljYXRpb24veG1sLWR0ZCddLFxuICAgIFsnZHRzJywgJ2F1ZGlvL3ZuZC5kdHMnXSxcbiAgICBbJ2R0c2hkJywgJ2F1ZGlvL3ZuZC5kdHMuaGQnXSxcbiAgICBbJ2R1bXAnLCAnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJ10sXG4gICAgWydkdicsICd2aWRlby94LWR2J10sXG4gICAgWydkdmknLCAnYXBwbGljYXRpb24veC1kdmknXSxcbiAgICBbJ2R3ZicsIFsnbW9kZWwvdm5kLmR3ZicsICdkcmF3aW5nL3gtZHdmJ11dLFxuICAgIFsnZHdnJywgWydhcHBsaWNhdGlvbi9hY2FkJywgJ2ltYWdlL3ZuZC5kd2cnLCAnaW1hZ2UveC1kd2cnXV0sXG4gICAgWydkeGYnLCBbJ2FwcGxpY2F0aW9uL2R4ZicsICdpbWFnZS92bmQuZHdnJywgJ2ltYWdlL3ZuZC5keGYnLCAnaW1hZ2UveC1kd2cnXV0sXG4gICAgWydkeHAnLCAnYXBwbGljYXRpb24vdm5kLnNwb3RmaXJlLmR4cCddLFxuICAgIFsnZHhyJywgJ2FwcGxpY2F0aW9uL3gtZGlyZWN0b3InXSxcbiAgICBbJ2VjZWxwNDgwMCcsICdhdWRpby92bmQubnVlcmEuZWNlbHA0ODAwJ10sXG4gICAgWydlY2VscDc0NzAnLCAnYXVkaW8vdm5kLm51ZXJhLmVjZWxwNzQ3MCddLFxuICAgIFsnZWNlbHA5NjAwJywgJ2F1ZGlvL3ZuZC5udWVyYS5lY2VscDk2MDAnXSxcbiAgICBbJ2VkbScsICdhcHBsaWNhdGlvbi92bmQubm92YWRpZ20uZWRtJ10sXG4gICAgWydlZHgnLCAnYXBwbGljYXRpb24vdm5kLm5vdmFkaWdtLmVkeCddLFxuICAgIFsnZWZpZicsICdhcHBsaWNhdGlvbi92bmQucGljc2VsJ10sXG4gICAgWydlaTYnLCAnYXBwbGljYXRpb24vdm5kLnBnLm9zYXNsaSddLFxuICAgIFsnZWwnLCAndGV4dC94LXNjcmlwdC5lbGlzcCddLFxuICAgIFsnZWxjJywgWydhcHBsaWNhdGlvbi94LWVsYycsICdhcHBsaWNhdGlvbi94LWJ5dGVjb2RlLmVsaXNwJ11dLFxuICAgIFsnZW1sJywgJ21lc3NhZ2UvcmZjODIyJ10sXG4gICAgWydlbW1hJywgJ2FwcGxpY2F0aW9uL2VtbWEreG1sJ10sXG4gICAgWydlbnYnLCAnYXBwbGljYXRpb24veC1lbnZveSddLFxuICAgIFsnZW9sJywgJ2F1ZGlvL3ZuZC5kaWdpdGFsLXdpbmRzJ10sXG4gICAgWydlb3QnLCAnYXBwbGljYXRpb24vdm5kLm1zLWZvbnRvYmplY3QnXSxcbiAgICBbJ2VwcycsICdhcHBsaWNhdGlvbi9wb3N0c2NyaXB0J10sXG4gICAgWydlcHViJywgJ2FwcGxpY2F0aW9uL2VwdWIremlwJ10sXG4gICAgWydlcycsIFsnYXBwbGljYXRpb24vZWNtYXNjcmlwdCcsICdhcHBsaWNhdGlvbi94LWVzcmVoYmVyJ11dLFxuICAgIFsnZXMzJywgJ2FwcGxpY2F0aW9uL3ZuZC5lc3ppZ25vMyt4bWwnXSxcbiAgICBbJ2VzZicsICdhcHBsaWNhdGlvbi92bmQuZXBzb24uZXNmJ10sXG4gICAgWydldHgnLCAndGV4dC94LXNldGV4dCddLFxuICAgIFsnZXZ5JywgWydhcHBsaWNhdGlvbi9lbnZveScsICdhcHBsaWNhdGlvbi94LWVudm95J11dLFxuICAgIFsnZXhlJywgWydhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nLCAnYXBwbGljYXRpb24veC1tc2Rvd25sb2FkJ11dLFxuICAgIFsnZXhpJywgJ2FwcGxpY2F0aW9uL2V4aSddLFxuICAgIFsnZXh0JywgJ2FwcGxpY2F0aW9uL3ZuZC5ub3ZhZGlnbS5leHQnXSxcbiAgICBbJ2V6MicsICdhcHBsaWNhdGlvbi92bmQuZXpwaXgtYWxidW0nXSxcbiAgICBbJ2V6MycsICdhcHBsaWNhdGlvbi92bmQuZXpwaXgtcGFja2FnZSddLFxuICAgIFsnZicsIFsndGV4dC9wbGFpbicsICd0ZXh0L3gtZm9ydHJhbiddXSxcbiAgICBbJ2Y0dicsICd2aWRlby94LWY0diddLFxuICAgIFsnZjc3JywgJ3RleHQveC1mb3J0cmFuJ10sXG4gICAgWydmOTAnLCBbJ3RleHQvcGxhaW4nLCAndGV4dC94LWZvcnRyYW4nXV0sXG4gICAgWydmYnMnLCAnaW1hZ2Uvdm5kLmZhc3RiaWRzaGVldCddLFxuICAgIFsnZmNzJywgJ2FwcGxpY2F0aW9uL3ZuZC5pc2FjLmZjcyddLFxuICAgIFsnZmRmJywgJ2FwcGxpY2F0aW9uL3ZuZC5mZGYnXSxcbiAgICBbJ2ZlX2xhdW5jaCcsICdhcHBsaWNhdGlvbi92bmQuZGVub3ZvLmZjc2VsYXlvdXQtbGluayddLFxuICAgIFsnZmc1JywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzZ3AnXSxcbiAgICBbJ2ZoJywgJ2ltYWdlL3gtZnJlZWhhbmQnXSxcbiAgICBbJ2ZpZicsIFsnYXBwbGljYXRpb24vZnJhY3RhbHMnLCAnaW1hZ2UvZmlmJ11dLFxuICAgIFsnZmlnJywgJ2FwcGxpY2F0aW9uL3gteGZpZyddLFxuICAgIFsnZmxpJywgWyd2aWRlby9mbGknLCAndmlkZW8veC1mbGknXV0sXG4gICAgWydmbG8nLCBbJ2ltYWdlL2Zsb3JpYW4nLCAnYXBwbGljYXRpb24vdm5kLm1pY3JvZ3JhZnguZmxvJ11dLFxuICAgIFsnZmxyJywgJ3gtd29ybGQveC12cm1sJ10sXG4gICAgWydmbHYnLCAndmlkZW8veC1mbHYnXSxcbiAgICBbJ2ZsdycsICdhcHBsaWNhdGlvbi92bmQua2RlLmtpdmlvJ10sXG4gICAgWydmbHgnLCAndGV4dC92bmQuZm1pLmZsZXhzdG9yJ10sXG4gICAgWydmbHknLCAndGV4dC92bmQuZmx5J10sXG4gICAgWydmbScsICdhcHBsaWNhdGlvbi92bmQuZnJhbWVtYWtlciddLFxuICAgIFsnZm1mJywgJ3ZpZGVvL3gtYXRvbWljM2QtZmVhdHVyZSddLFxuICAgIFsnZm5jJywgJ2FwcGxpY2F0aW9uL3ZuZC5mcm9nYW5zLmZuYyddLFxuICAgIFsnZm9yJywgWyd0ZXh0L3BsYWluJywgJ3RleHQveC1mb3J0cmFuJ11dLFxuICAgIFsnZnB4JywgWydpbWFnZS92bmQuZnB4JywgJ2ltYWdlL3ZuZC5uZXQtZnB4J11dLFxuICAgIFsnZnJsJywgJ2FwcGxpY2F0aW9uL2ZyZWVsb2FkZXInXSxcbiAgICBbJ2ZzYycsICdhcHBsaWNhdGlvbi92bmQuZnNjLndlYmxhdW5jaCddLFxuICAgIFsnZnN0JywgJ2ltYWdlL3ZuZC5mc3QnXSxcbiAgICBbJ2Z0YycsICdhcHBsaWNhdGlvbi92bmQuZmx1eHRpbWUuY2xpcCddLFxuICAgIFsnZnRpJywgJ2FwcGxpY2F0aW9uL3ZuZC5hbnNlci13ZWItZnVuZHMtdHJhbnNmZXItaW5pdGlhdGlvbiddLFxuICAgIFsnZnVuaycsICdhdWRpby9tYWtlJ10sXG4gICAgWydmdnQnLCAndmlkZW8vdm5kLmZ2dCddLFxuICAgIFsnZnhwJywgJ2FwcGxpY2F0aW9uL3ZuZC5hZG9iZS5meHAnXSxcbiAgICBbJ2Z6cycsICdhcHBsaWNhdGlvbi92bmQuZnV6enlzaGVldCddLFxuICAgIFsnZycsICd0ZXh0L3BsYWluJ10sXG4gICAgWydnMncnLCAnYXBwbGljYXRpb24vdm5kLmdlb3BsYW4nXSxcbiAgICBbJ2czJywgJ2ltYWdlL2czZmF4J10sXG4gICAgWydnM3cnLCAnYXBwbGljYXRpb24vdm5kLmdlb3NwYWNlJ10sXG4gICAgWydnYWMnLCAnYXBwbGljYXRpb24vdm5kLmdyb292ZS1hY2NvdW50J10sXG4gICAgWydnZGwnLCAnbW9kZWwvdm5kLmdkbCddLFxuICAgIFsnZ2VvJywgJ2FwcGxpY2F0aW9uL3ZuZC5keW5hZ2VvJ10sXG4gICAgWydnZW9qc29uJywgJ2FwcGxpY2F0aW9uL2dlbytqc29uJ10sXG4gICAgWydnZXgnLCAnYXBwbGljYXRpb24vdm5kLmdlb21ldHJ5LWV4cGxvcmVyJ10sXG4gICAgWydnZ2InLCAnYXBwbGljYXRpb24vdm5kLmdlb2dlYnJhLmZpbGUnXSxcbiAgICBbJ2dndCcsICdhcHBsaWNhdGlvbi92bmQuZ2VvZ2VicmEudG9vbCddLFxuICAgIFsnZ2hmJywgJ2FwcGxpY2F0aW9uL3ZuZC5ncm9vdmUtaGVscCddLFxuICAgIFsnZ2lmJywgJ2ltYWdlL2dpZiddLFxuICAgIFsnZ2ltJywgJ2FwcGxpY2F0aW9uL3ZuZC5ncm9vdmUtaWRlbnRpdHktbWVzc2FnZSddLFxuICAgIFsnZ2wnLCBbJ3ZpZGVvL2dsJywgJ3ZpZGVvL3gtZ2wnXV0sXG4gICAgWydnbXgnLCAnYXBwbGljYXRpb24vdm5kLmdteCddLFxuICAgIFsnZ251bWVyaWMnLCAnYXBwbGljYXRpb24veC1nbnVtZXJpYyddLFxuICAgIFsnZ3BoJywgJ2FwcGxpY2F0aW9uL3ZuZC5mbG9ncmFwaGl0J10sXG4gICAgWydncWYnLCAnYXBwbGljYXRpb24vdm5kLmdyYWZlcSddLFxuICAgIFsnZ3JhbScsICdhcHBsaWNhdGlvbi9zcmdzJ10sXG4gICAgWydncnYnLCAnYXBwbGljYXRpb24vdm5kLmdyb292ZS1pbmplY3RvciddLFxuICAgIFsnZ3J4bWwnLCAnYXBwbGljYXRpb24vc3Jncyt4bWwnXSxcbiAgICBbJ2dzZCcsICdhdWRpby94LWdzbSddLFxuICAgIFsnZ3NmJywgJ2FwcGxpY2F0aW9uL3gtZm9udC1naG9zdHNjcmlwdCddLFxuICAgIFsnZ3NtJywgJ2F1ZGlvL3gtZ3NtJ10sXG4gICAgWydnc3AnLCAnYXBwbGljYXRpb24veC1nc3AnXSxcbiAgICBbJ2dzcycsICdhcHBsaWNhdGlvbi94LWdzcyddLFxuICAgIFsnZ3RhcicsICdhcHBsaWNhdGlvbi94LWd0YXInXSxcbiAgICBbJ2d0bScsICdhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLXRvb2wtbWVzc2FnZSddLFxuICAgIFsnZ3R3JywgJ21vZGVsL3ZuZC5ndHcnXSxcbiAgICBbJ2d2JywgJ3RleHQvdm5kLmdyYXBodml6J10sXG4gICAgWydneHQnLCAnYXBwbGljYXRpb24vdm5kLmdlb25leHQnXSxcbiAgICBbJ2d6JywgWydhcHBsaWNhdGlvbi94LWd6aXAnLCAnYXBwbGljYXRpb24veC1jb21wcmVzc2VkJ11dLFxuICAgIFsnZ3ppcCcsIFsnbXVsdGlwYXJ0L3gtZ3ppcCcsICdhcHBsaWNhdGlvbi94LWd6aXAnXV0sXG4gICAgWydoJywgWyd0ZXh0L3BsYWluJywgJ3RleHQveC1oJ11dLFxuICAgIFsnaDI2MScsICd2aWRlby9oMjYxJ10sXG4gICAgWydoMjYzJywgJ3ZpZGVvL2gyNjMnXSxcbiAgICBbJ2gyNjQnLCAndmlkZW8vaDI2NCddLFxuICAgIFsnaGFsJywgJ2FwcGxpY2F0aW9uL3ZuZC5oYWwreG1sJ10sXG4gICAgWydoYmNpJywgJ2FwcGxpY2F0aW9uL3ZuZC5oYmNpJ10sXG4gICAgWydoZGYnLCAnYXBwbGljYXRpb24veC1oZGYnXSxcbiAgICBbJ2hlbHAnLCAnYXBwbGljYXRpb24veC1oZWxwZmlsZSddLFxuICAgIFsnaGdsJywgJ2FwcGxpY2F0aW9uL3ZuZC5ocC1ocGdsJ10sXG4gICAgWydoaCcsIFsndGV4dC9wbGFpbicsICd0ZXh0L3gtaCddXSxcbiAgICBbJ2hsYicsICd0ZXh0L3gtc2NyaXB0J10sXG4gICAgWydobHAnLCBbJ2FwcGxpY2F0aW9uL3dpbmhscCcsICdhcHBsaWNhdGlvbi9obHAnLCAnYXBwbGljYXRpb24veC1oZWxwZmlsZScsICdhcHBsaWNhdGlvbi94LXdpbmhlbHAnXV0sXG4gICAgWydocGcnLCAnYXBwbGljYXRpb24vdm5kLmhwLWhwZ2wnXSxcbiAgICBbJ2hwZ2wnLCAnYXBwbGljYXRpb24vdm5kLmhwLWhwZ2wnXSxcbiAgICBbJ2hwaWQnLCAnYXBwbGljYXRpb24vdm5kLmhwLWhwaWQnXSxcbiAgICBbJ2hwcycsICdhcHBsaWNhdGlvbi92bmQuaHAtaHBzJ10sXG4gICAgW1xuICAgICAgICAnaHF4JyxcbiAgICAgICAgW1xuICAgICAgICAgICAgJ2FwcGxpY2F0aW9uL21hYy1iaW5oZXg0MCcsXG4gICAgICAgICAgICAnYXBwbGljYXRpb24vYmluaGV4JyxcbiAgICAgICAgICAgICdhcHBsaWNhdGlvbi9iaW5oZXg0JyxcbiAgICAgICAgICAgICdhcHBsaWNhdGlvbi9tYWMtYmluaGV4JyxcbiAgICAgICAgICAgICdhcHBsaWNhdGlvbi94LWJpbmhleDQwJyxcbiAgICAgICAgICAgICdhcHBsaWNhdGlvbi94LW1hYy1iaW5oZXg0MCdcbiAgICAgICAgXVxuICAgIF0sXG4gICAgWydodGEnLCAnYXBwbGljYXRpb24vaHRhJ10sXG4gICAgWydodGMnLCAndGV4dC94LWNvbXBvbmVudCddLFxuICAgIFsnaHRrZScsICdhcHBsaWNhdGlvbi92bmQua2VuYW1lYWFwcCddLFxuICAgIFsnaHRtJywgJ3RleHQvaHRtbCddLFxuICAgIFsnaHRtbCcsICd0ZXh0L2h0bWwnXSxcbiAgICBbJ2h0bWxzJywgJ3RleHQvaHRtbCddLFxuICAgIFsnaHR0JywgJ3RleHQvd2Vidmlld2h0bWwnXSxcbiAgICBbJ2h0eCcsICd0ZXh0L2h0bWwnXSxcbiAgICBbJ2h2ZCcsICdhcHBsaWNhdGlvbi92bmQueWFtYWhhLmh2LWRpYyddLFxuICAgIFsnaHZwJywgJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuaHYtdm9pY2UnXSxcbiAgICBbJ2h2cycsICdhcHBsaWNhdGlvbi92bmQueWFtYWhhLmh2LXNjcmlwdCddLFxuICAgIFsnaTJnJywgJ2FwcGxpY2F0aW9uL3ZuZC5pbnRlcmdlbyddLFxuICAgIFsnaWNjJywgJ2FwcGxpY2F0aW9uL3ZuZC5pY2Nwcm9maWxlJ10sXG4gICAgWydpY2UnLCAneC1jb25mZXJlbmNlL3gtY29vbHRhbGsnXSxcbiAgICBbJ2ljbycsICdpbWFnZS94LWljb24nXSxcbiAgICBbJ2ljcycsICd0ZXh0L2NhbGVuZGFyJ10sXG4gICAgWydpZGMnLCAndGV4dC9wbGFpbiddLFxuICAgIFsnaWVmJywgJ2ltYWdlL2llZiddLFxuICAgIFsnaWVmcycsICdpbWFnZS9pZWYnXSxcbiAgICBbJ2lmbScsICdhcHBsaWNhdGlvbi92bmQuc2hhbmEuaW5mb3JtZWQuZm9ybWRhdGEnXSxcbiAgICBbJ2lnZXMnLCBbJ2FwcGxpY2F0aW9uL2lnZXMnLCAnbW9kZWwvaWdlcyddXSxcbiAgICBbJ2lnbCcsICdhcHBsaWNhdGlvbi92bmQuaWdsb2FkZXInXSxcbiAgICBbJ2lnbScsICdhcHBsaWNhdGlvbi92bmQuaW5zb3JzLmlnbSddLFxuICAgIFsnaWdzJywgWydhcHBsaWNhdGlvbi9pZ2VzJywgJ21vZGVsL2lnZXMnXV0sXG4gICAgWydpZ3gnLCAnYXBwbGljYXRpb24vdm5kLm1pY3JvZ3JhZnguaWd4J10sXG4gICAgWydpaWYnLCAnYXBwbGljYXRpb24vdm5kLnNoYW5hLmluZm9ybWVkLmludGVyY2hhbmdlJ10sXG4gICAgWydpaWknLCAnYXBwbGljYXRpb24veC1pcGhvbmUnXSxcbiAgICBbJ2ltYScsICdhcHBsaWNhdGlvbi94LWltYSddLFxuICAgIFsnaW1hcCcsICdhcHBsaWNhdGlvbi94LWh0dHBkLWltYXAnXSxcbiAgICBbJ2ltcCcsICdhcHBsaWNhdGlvbi92bmQuYWNjcGFjLnNpbXBseS5pbXAnXSxcbiAgICBbJ2ltcycsICdhcHBsaWNhdGlvbi92bmQubXMtaW1zJ10sXG4gICAgWydpbmYnLCAnYXBwbGljYXRpb24vaW5mJ10sXG4gICAgWydpbnMnLCBbJ2FwcGxpY2F0aW9uL3gtaW50ZXJuZXQtc2lnbnVwJywgJ2FwcGxpY2F0aW9uL3gtaW50ZXJuZXR0LXNpZ251cCddXSxcbiAgICBbJ2lwJywgJ2FwcGxpY2F0aW9uL3gtaXAyJ10sXG4gICAgWydpcGZpeCcsICdhcHBsaWNhdGlvbi9pcGZpeCddLFxuICAgIFsnaXBrJywgJ2FwcGxpY2F0aW9uL3ZuZC5zaGFuYS5pbmZvcm1lZC5wYWNrYWdlJ10sXG4gICAgWydpcm0nLCAnYXBwbGljYXRpb24vdm5kLmlibS5yaWdodHMtbWFuYWdlbWVudCddLFxuICAgIFsnaXJwJywgJ2FwcGxpY2F0aW9uL3ZuZC5pcmVwb3NpdG9yeS5wYWNrYWdlK3htbCddLFxuICAgIFsnaXNwJywgJ2FwcGxpY2F0aW9uL3gtaW50ZXJuZXQtc2lnbnVwJ10sXG4gICAgWydpc3UnLCAndmlkZW8veC1pc3ZpZGVvJ10sXG4gICAgWydpdCcsICdhdWRpby9pdCddLFxuICAgIFsnaXRwJywgJ2FwcGxpY2F0aW9uL3ZuZC5zaGFuYS5pbmZvcm1lZC5mb3JtdGVtcGxhdGUnXSxcbiAgICBbJ2l2JywgJ2FwcGxpY2F0aW9uL3gtaW52ZW50b3InXSxcbiAgICBbJ2l2cCcsICdhcHBsaWNhdGlvbi92bmQuaW1tZXJ2aXNpb24taXZwJ10sXG4gICAgWydpdnInLCAnaS13b3JsZC9pLXZybWwnXSxcbiAgICBbJ2l2dScsICdhcHBsaWNhdGlvbi92bmQuaW1tZXJ2aXNpb24taXZ1J10sXG4gICAgWydpdnknLCAnYXBwbGljYXRpb24veC1saXZlc2NyZWVuJ10sXG4gICAgWydqYWQnLCAndGV4dC92bmQuc3VuLmoybWUuYXBwLWRlc2NyaXB0b3InXSxcbiAgICBbJ2phbScsIFsnYXBwbGljYXRpb24vdm5kLmphbScsICdhdWRpby94LWphbSddXSxcbiAgICBbJ2phcicsICdhcHBsaWNhdGlvbi9qYXZhLWFyY2hpdmUnXSxcbiAgICBbJ2phdicsIFsndGV4dC9wbGFpbicsICd0ZXh0L3gtamF2YS1zb3VyY2UnXV0sXG4gICAgWydqYXZhJywgWyd0ZXh0L3BsYWluJywgJ3RleHQveC1qYXZhLXNvdXJjZSxqYXZhJywgJ3RleHQveC1qYXZhLXNvdXJjZSddXSxcbiAgICBbJ2pjbScsICdhcHBsaWNhdGlvbi94LWphdmEtY29tbWVyY2UnXSxcbiAgICBbJ2pmaWYnLCBbJ2ltYWdlL3BpcGVnJywgJ2ltYWdlL2pwZWcnLCAnaW1hZ2UvcGpwZWcnXV0sXG4gICAgWydqZmlmLXRibmwnLCAnaW1hZ2UvanBlZyddLFxuICAgIFsnamlzcCcsICdhcHBsaWNhdGlvbi92bmQuamlzcCddLFxuICAgIFsnamx0JywgJ2FwcGxpY2F0aW9uL3ZuZC5ocC1qbHl0J10sXG4gICAgWydqbmxwJywgJ2FwcGxpY2F0aW9uL3gtamF2YS1qbmxwLWZpbGUnXSxcbiAgICBbJ2pvZGEnLCAnYXBwbGljYXRpb24vdm5kLmpvb3N0LmpvZGEtYXJjaGl2ZSddLFxuICAgIFsnanBlJywgWydpbWFnZS9qcGVnJywgJ2ltYWdlL3BqcGVnJ11dLFxuICAgIFsnanBlZycsIFsnaW1hZ2UvanBlZycsICdpbWFnZS9wanBlZyddXSxcbiAgICBbJ2pwZycsIFsnaW1hZ2UvanBlZycsICdpbWFnZS9wanBlZyddXSxcbiAgICBbJ2pwZ3YnLCAndmlkZW8vanBlZyddLFxuICAgIFsnanBtJywgJ3ZpZGVvL2pwbSddLFxuICAgIFsnanBzJywgJ2ltYWdlL3gtanBzJ10sXG4gICAgWydqcycsIFsnYXBwbGljYXRpb24vamF2YXNjcmlwdCcsICdhcHBsaWNhdGlvbi9lY21hc2NyaXB0JywgJ3RleHQvamF2YXNjcmlwdCcsICd0ZXh0L2VjbWFzY3JpcHQnLCAnYXBwbGljYXRpb24veC1qYXZhc2NyaXB0J11dLFxuICAgIFsnanNvbicsICdhcHBsaWNhdGlvbi9qc29uJ10sXG4gICAgWydqdXQnLCAnaW1hZ2UvanV0dmlzaW9uJ10sXG4gICAgWydrYXInLCBbJ2F1ZGlvL21pZGknLCAnbXVzaWMveC1rYXJhb2tlJ11dLFxuICAgIFsna2FyYm9uJywgJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua2FyYm9uJ10sXG4gICAgWydrZm8nLCAnYXBwbGljYXRpb24vdm5kLmtkZS5rZm9ybXVsYSddLFxuICAgIFsna2lhJywgJ2FwcGxpY2F0aW9uL3ZuZC5raWRzcGlyYXRpb24nXSxcbiAgICBbJ2ttbCcsICdhcHBsaWNhdGlvbi92bmQuZ29vZ2xlLWVhcnRoLmttbCt4bWwnXSxcbiAgICBbJ2tteicsICdhcHBsaWNhdGlvbi92bmQuZ29vZ2xlLWVhcnRoLmtteiddLFxuICAgIFsna25lJywgJ2FwcGxpY2F0aW9uL3ZuZC5raW5hciddLFxuICAgIFsna29uJywgJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua29udG91ciddLFxuICAgIFsna3ByJywgJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua3ByZXNlbnRlciddLFxuICAgIFsna3NoJywgWydhcHBsaWNhdGlvbi94LWtzaCcsICd0ZXh0L3gtc2NyaXB0LmtzaCddXSxcbiAgICBbJ2tzcCcsICdhcHBsaWNhdGlvbi92bmQua2RlLmtzcHJlYWQnXSxcbiAgICBbJ2t0eCcsICdpbWFnZS9rdHgnXSxcbiAgICBbJ2t0eicsICdhcHBsaWNhdGlvbi92bmQua2Fob290eiddLFxuICAgIFsna3dkJywgJ2FwcGxpY2F0aW9uL3ZuZC5rZGUua3dvcmQnXSxcbiAgICBbJ2xhJywgWydhdWRpby9uc3BhdWRpbycsICdhdWRpby94LW5zcGF1ZGlvJ11dLFxuICAgIFsnbGFtJywgJ2F1ZGlvL3gtbGl2ZWF1ZGlvJ10sXG4gICAgWydsYXN4bWwnLCAnYXBwbGljYXRpb24vdm5kLmxhcy5sYXMreG1sJ10sXG4gICAgWydsYXRleCcsICdhcHBsaWNhdGlvbi94LWxhdGV4J10sXG4gICAgWydsYmQnLCAnYXBwbGljYXRpb24vdm5kLmxsYW1hZ3JhcGhpY3MubGlmZS1iYWxhbmNlLmRlc2t0b3AnXSxcbiAgICBbJ2xiZScsICdhcHBsaWNhdGlvbi92bmQubGxhbWFncmFwaGljcy5saWZlLWJhbGFuY2UuZXhjaGFuZ2UreG1sJ10sXG4gICAgWydsZXMnLCAnYXBwbGljYXRpb24vdm5kLmhoZS5sZXNzb24tcGxheWVyJ10sXG4gICAgWydsaGEnLCBbJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbScsICdhcHBsaWNhdGlvbi9saGEnLCAnYXBwbGljYXRpb24veC1saGEnXV0sXG4gICAgWydsaHgnLCAnYXBwbGljYXRpb24vb2N0ZXQtc3RyZWFtJ10sXG4gICAgWydsaW5rNjYnLCAnYXBwbGljYXRpb24vdm5kLnJvdXRlNjYubGluazY2K3htbCddLFxuICAgIFsnbGlzdCcsICd0ZXh0L3BsYWluJ10sXG4gICAgWydsbWEnLCBbJ2F1ZGlvL25zcGF1ZGlvJywgJ2F1ZGlvL3gtbnNwYXVkaW8nXV0sXG4gICAgWydsb2cnLCAndGV4dC9wbGFpbiddLFxuICAgIFsnbHJtJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1scm0nXSxcbiAgICBbJ2xzZicsICd2aWRlby94LWxhLWFzZiddLFxuICAgIFsnbHNwJywgWydhcHBsaWNhdGlvbi94LWxpc3AnLCAndGV4dC94LXNjcmlwdC5saXNwJ11dLFxuICAgIFsnbHN0JywgJ3RleHQvcGxhaW4nXSxcbiAgICBbJ2xzeCcsIFsndmlkZW8veC1sYS1hc2YnLCAndGV4dC94LWxhLWFzZiddXSxcbiAgICBbJ2x0ZicsICdhcHBsaWNhdGlvbi92bmQuZnJvZ2Fucy5sdGYnXSxcbiAgICBbJ2x0eCcsICdhcHBsaWNhdGlvbi94LWxhdGV4J10sXG4gICAgWydsdnAnLCAnYXVkaW8vdm5kLmx1Y2VudC52b2ljZSddLFxuICAgIFsnbHdwJywgJ2FwcGxpY2F0aW9uL3ZuZC5sb3R1cy13b3JkcHJvJ10sXG4gICAgWydsemgnLCBbJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbScsICdhcHBsaWNhdGlvbi94LWx6aCddXSxcbiAgICBbJ2x6eCcsIFsnYXBwbGljYXRpb24vbHp4JywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbScsICdhcHBsaWNhdGlvbi94LWx6eCddXSxcbiAgICBbJ20nLCBbJ3RleHQvcGxhaW4nLCAndGV4dC94LW0nXV0sXG4gICAgWydtMTMnLCAnYXBwbGljYXRpb24veC1tc21lZGlhdmlldyddLFxuICAgIFsnbTE0JywgJ2FwcGxpY2F0aW9uL3gtbXNtZWRpYXZpZXcnXSxcbiAgICBbJ20xdicsICd2aWRlby9tcGVnJ10sXG4gICAgWydtMjEnLCAnYXBwbGljYXRpb24vbXAyMSddLFxuICAgIFsnbTJhJywgJ2F1ZGlvL21wZWcnXSxcbiAgICBbJ20ydicsICd2aWRlby9tcGVnJ10sXG4gICAgWydtM3UnLCBbJ2F1ZGlvL3gtbXBlZ3VybCcsICdhdWRpby94LW1wZXF1cmwnXV0sXG4gICAgWydtM3U4JywgJ2FwcGxpY2F0aW9uL3ZuZC5hcHBsZS5tcGVndXJsJ10sXG4gICAgWydtNHYnLCAndmlkZW8veC1tNHYnXSxcbiAgICBbJ21hJywgJ2FwcGxpY2F0aW9uL21hdGhlbWF0aWNhJ10sXG4gICAgWydtYWRzJywgJ2FwcGxpY2F0aW9uL21hZHMreG1sJ10sXG4gICAgWydtYWcnLCAnYXBwbGljYXRpb24vdm5kLmVjb3dpbi5jaGFydCddLFxuICAgIFsnbWFuJywgJ2FwcGxpY2F0aW9uL3gtdHJvZmYtbWFuJ10sXG4gICAgWydtYXAnLCAnYXBwbGljYXRpb24veC1uYXZpbWFwJ10sXG4gICAgWydtYXInLCAndGV4dC9wbGFpbiddLFxuICAgIFsnbWF0aG1sJywgJ2FwcGxpY2F0aW9uL21hdGhtbCt4bWwnXSxcbiAgICBbJ21iZCcsICdhcHBsaWNhdGlvbi9tYmVkbGV0J10sXG4gICAgWydtYmsnLCAnYXBwbGljYXRpb24vdm5kLm1vYml1cy5tYmsnXSxcbiAgICBbJ21ib3gnLCAnYXBwbGljYXRpb24vbWJveCddLFxuICAgIFsnbWMkJywgJ2FwcGxpY2F0aW9uL3gtbWFnaWMtY2FwLXBhY2thZ2UtMS4wJ10sXG4gICAgWydtYzEnLCAnYXBwbGljYXRpb24vdm5kLm1lZGNhbGNkYXRhJ10sXG4gICAgWydtY2QnLCBbJ2FwcGxpY2F0aW9uL21jYWQnLCAnYXBwbGljYXRpb24vdm5kLm1jZCcsICdhcHBsaWNhdGlvbi94LW1hdGhjYWQnXV0sXG4gICAgWydtY2YnLCBbJ2ltYWdlL3Zhc2EnLCAndGV4dC9tY2YnXV0sXG4gICAgWydtY3AnLCAnYXBwbGljYXRpb24vbmV0bWMnXSxcbiAgICBbJ21jdXJsJywgJ3RleHQvdm5kLmN1cmwubWN1cmwnXSxcbiAgICBbJ21kYicsICdhcHBsaWNhdGlvbi94LW1zYWNjZXNzJ10sXG4gICAgWydtZGknLCAnaW1hZ2Uvdm5kLm1zLW1vZGknXSxcbiAgICBbJ21lJywgJ2FwcGxpY2F0aW9uL3gtdHJvZmYtbWUnXSxcbiAgICBbJ21ldGE0JywgJ2FwcGxpY2F0aW9uL21ldGFsaW5rNCt4bWwnXSxcbiAgICBbJ21ldHMnLCAnYXBwbGljYXRpb24vbWV0cyt4bWwnXSxcbiAgICBbJ21mbScsICdhcHBsaWNhdGlvbi92bmQubWZtcCddLFxuICAgIFsnbWdwJywgJ2FwcGxpY2F0aW9uL3ZuZC5vc2dlby5tYXBndWlkZS5wYWNrYWdlJ10sXG4gICAgWydtZ3onLCAnYXBwbGljYXRpb24vdm5kLnByb3RldXMubWFnYXppbmUnXSxcbiAgICBbJ21odCcsICdtZXNzYWdlL3JmYzgyMiddLFxuICAgIFsnbWh0bWwnLCAnbWVzc2FnZS9yZmM4MjInXSxcbiAgICBbJ21pZCcsIFsnYXVkaW8vbWlkJywgJ2F1ZGlvL21pZGknLCAnbXVzaWMvY3Jlc2NlbmRvJywgJ3gtbXVzaWMveC1taWRpJywgJ2F1ZGlvL3gtbWlkaScsICdhcHBsaWNhdGlvbi94LW1pZGknLCAnYXVkaW8veC1taWQnXV0sXG4gICAgWydtaWRpJywgWydhdWRpby9taWRpJywgJ211c2ljL2NyZXNjZW5kbycsICd4LW11c2ljL3gtbWlkaScsICdhdWRpby94LW1pZGknLCAnYXBwbGljYXRpb24veC1taWRpJywgJ2F1ZGlvL3gtbWlkJ11dLFxuICAgIFsnbWlmJywgWydhcHBsaWNhdGlvbi92bmQubWlmJywgJ2FwcGxpY2F0aW9uL3gtbWlmJywgJ2FwcGxpY2F0aW9uL3gtZnJhbWUnXV0sXG4gICAgWydtaW1lJywgWydtZXNzYWdlL3JmYzgyMicsICd3d3cvbWltZSddXSxcbiAgICBbJ21qMicsICd2aWRlby9tajInXSxcbiAgICBbJ21qZicsICdhdWRpby94LXZuZC5hdWRpb2V4cGxvc2lvbi5tanVpY2VtZWRpYWZpbGUnXSxcbiAgICBbJ21qcGcnLCAndmlkZW8veC1tb3Rpb24tanBlZyddLFxuICAgIFsnbWxwJywgJ2FwcGxpY2F0aW9uL3ZuZC5kb2xieS5tbHAnXSxcbiAgICBbJ21tJywgWydhcHBsaWNhdGlvbi9iYXNlNjQnLCAnYXBwbGljYXRpb24veC1tZW1lJ11dLFxuICAgIFsnbW1kJywgJ2FwcGxpY2F0aW9uL3ZuZC5jaGlwbnV0cy5rYXJhb2tlLW1tZCddLFxuICAgIFsnbW1lJywgJ2FwcGxpY2F0aW9uL2Jhc2U2NCddLFxuICAgIFsnbW1mJywgJ2FwcGxpY2F0aW9uL3ZuZC5zbWFmJ10sXG4gICAgWydtbXInLCAnaW1hZ2Uvdm5kLmZ1aml4ZXJveC5lZG1pY3MtbW1yJ10sXG4gICAgWydtbnknLCAnYXBwbGljYXRpb24veC1tc21vbmV5J10sXG4gICAgWydtb2QnLCBbJ2F1ZGlvL21vZCcsICdhdWRpby94LW1vZCddXSxcbiAgICBbJ21vZHMnLCAnYXBwbGljYXRpb24vbW9kcyt4bWwnXSxcbiAgICBbJ21vb3YnLCAndmlkZW8vcXVpY2t0aW1lJ10sXG4gICAgWydtb3YnLCAndmlkZW8vcXVpY2t0aW1lJ10sXG4gICAgWydtb3ZpZScsICd2aWRlby94LXNnaS1tb3ZpZSddLFxuICAgIFsnbXAyJywgWyd2aWRlby9tcGVnJywgJ2F1ZGlvL21wZWcnLCAndmlkZW8veC1tcGVnJywgJ2F1ZGlvL3gtbXBlZycsICd2aWRlby94LW1wZXEyYSddXSxcbiAgICBbJ21wMycsIFsnYXVkaW8vbXBlZycsICdhdWRpby9tcGVnMycsICd2aWRlby9tcGVnJywgJ2F1ZGlvL3gtbXBlZy0zJywgJ3ZpZGVvL3gtbXBlZyddXSxcbiAgICBbJ21wNCcsIFsndmlkZW8vbXA0JywgJ2FwcGxpY2F0aW9uL21wNCddXSxcbiAgICBbJ21wNGEnLCAnYXVkaW8vbXA0J10sXG4gICAgWydtcGEnLCBbJ3ZpZGVvL21wZWcnLCAnYXVkaW8vbXBlZyddXSxcbiAgICBbJ21wYycsIFsnYXBwbGljYXRpb24vdm5kLm1vcGh1bi5jZXJ0aWZpY2F0ZScsICdhcHBsaWNhdGlvbi94LXByb2plY3QnXV0sXG4gICAgWydtcGUnLCAndmlkZW8vbXBlZyddLFxuICAgIFsnbXBlZycsICd2aWRlby9tcGVnJ10sXG4gICAgWydtcGcnLCBbJ3ZpZGVvL21wZWcnLCAnYXVkaW8vbXBlZyddXSxcbiAgICBbJ21wZ2EnLCAnYXVkaW8vbXBlZyddLFxuICAgIFsnbXBrZycsICdhcHBsaWNhdGlvbi92bmQuYXBwbGUuaW5zdGFsbGVyK3htbCddLFxuICAgIFsnbXBtJywgJ2FwcGxpY2F0aW9uL3ZuZC5ibHVlaWNlLm11bHRpcGFzcyddLFxuICAgIFsnbXBuJywgJ2FwcGxpY2F0aW9uL3ZuZC5tb3BodW4uYXBwbGljYXRpb24nXSxcbiAgICBbJ21wcCcsICdhcHBsaWNhdGlvbi92bmQubXMtcHJvamVjdCddLFxuICAgIFsnbXB0JywgJ2FwcGxpY2F0aW9uL3gtcHJvamVjdCddLFxuICAgIFsnbXB2JywgJ2FwcGxpY2F0aW9uL3gtcHJvamVjdCddLFxuICAgIFsnbXB2MicsICd2aWRlby9tcGVnJ10sXG4gICAgWydtcHgnLCAnYXBwbGljYXRpb24veC1wcm9qZWN0J10sXG4gICAgWydtcHknLCAnYXBwbGljYXRpb24vdm5kLmlibS5taW5pcGF5J10sXG4gICAgWydtcXknLCAnYXBwbGljYXRpb24vdm5kLm1vYml1cy5tcXknXSxcbiAgICBbJ21yYycsICdhcHBsaWNhdGlvbi9tYXJjJ10sXG4gICAgWydtcmN4JywgJ2FwcGxpY2F0aW9uL21hcmN4bWwreG1sJ10sXG4gICAgWydtcycsICdhcHBsaWNhdGlvbi94LXRyb2ZmLW1zJ10sXG4gICAgWydtc2NtbCcsICdhcHBsaWNhdGlvbi9tZWRpYXNlcnZlcmNvbnRyb2wreG1sJ10sXG4gICAgWydtc2VxJywgJ2FwcGxpY2F0aW9uL3ZuZC5tc2VxJ10sXG4gICAgWydtc2YnLCAnYXBwbGljYXRpb24vdm5kLmVwc29uLm1zZiddLFxuICAgIFsnbXNnJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1vdXRsb29rJ10sXG4gICAgWydtc2gnLCAnbW9kZWwvbWVzaCddLFxuICAgIFsnbXNsJywgJ2FwcGxpY2F0aW9uL3ZuZC5tb2JpdXMubXNsJ10sXG4gICAgWydtc3R5JywgJ2FwcGxpY2F0aW9uL3ZuZC5tdXZlZS5zdHlsZSddLFxuICAgIFsnbXRzJywgJ21vZGVsL3ZuZC5tdHMnXSxcbiAgICBbJ211cycsICdhcHBsaWNhdGlvbi92bmQubXVzaWNpYW4nXSxcbiAgICBbJ211c2ljeG1sJywgJ2FwcGxpY2F0aW9uL3ZuZC5yZWNvcmRhcmUubXVzaWN4bWwreG1sJ10sXG4gICAgWydtdicsICd2aWRlby94LXNnaS1tb3ZpZSddLFxuICAgIFsnbXZiJywgJ2FwcGxpY2F0aW9uL3gtbXNtZWRpYXZpZXcnXSxcbiAgICBbJ213ZicsICdhcHBsaWNhdGlvbi92bmQubWZlciddLFxuICAgIFsnbXhmJywgJ2FwcGxpY2F0aW9uL214ZiddLFxuICAgIFsnbXhsJywgJ2FwcGxpY2F0aW9uL3ZuZC5yZWNvcmRhcmUubXVzaWN4bWwnXSxcbiAgICBbJ214bWwnLCAnYXBwbGljYXRpb24veHYreG1sJ10sXG4gICAgWydteHMnLCAnYXBwbGljYXRpb24vdm5kLnRyaXNjYXBlLm14cyddLFxuICAgIFsnbXh1JywgJ3ZpZGVvL3ZuZC5tcGVndXJsJ10sXG4gICAgWydteScsICdhdWRpby9tYWtlJ10sXG4gICAgWydtenonLCAnYXBwbGljYXRpb24veC12bmQuYXVkaW9leHBsb3Npb24ubXp6J10sXG4gICAgWyduLWdhZ2UnLCAnYXBwbGljYXRpb24vdm5kLm5va2lhLm4tZ2FnZS5zeW1iaWFuLmluc3RhbGwnXSxcbiAgICBbJ24zJywgJ3RleHQvbjMnXSxcbiAgICBbJ25hcCcsICdpbWFnZS9uYXBscHMnXSxcbiAgICBbJ25hcGxwcycsICdpbWFnZS9uYXBscHMnXSxcbiAgICBbJ25icCcsICdhcHBsaWNhdGlvbi92bmQud29sZnJhbS5wbGF5ZXInXSxcbiAgICBbJ25jJywgJ2FwcGxpY2F0aW9uL3gtbmV0Y2RmJ10sXG4gICAgWyduY20nLCAnYXBwbGljYXRpb24vdm5kLm5va2lhLmNvbmZpZ3VyYXRpb24tbWVzc2FnZSddLFxuICAgIFsnbmN4JywgJ2FwcGxpY2F0aW9uL3gtZHRibmN4K3htbCddLFxuICAgIFsnbmdkYXQnLCAnYXBwbGljYXRpb24vdm5kLm5va2lhLm4tZ2FnZS5kYXRhJ10sXG4gICAgWyduaWYnLCAnaW1hZ2UveC1uaWZmJ10sXG4gICAgWyduaWZmJywgJ2ltYWdlL3gtbmlmZiddLFxuICAgIFsnbml4JywgJ2FwcGxpY2F0aW9uL3gtbWl4LXRyYW5zZmVyJ10sXG4gICAgWydubHUnLCAnYXBwbGljYXRpb24vdm5kLm5ldXJvbGFuZ3VhZ2Uubmx1J10sXG4gICAgWydubWwnLCAnYXBwbGljYXRpb24vdm5kLmVubGl2ZW4nXSxcbiAgICBbJ25uZCcsICdhcHBsaWNhdGlvbi92bmQubm9ibGVuZXQtZGlyZWN0b3J5J10sXG4gICAgWydubnMnLCAnYXBwbGljYXRpb24vdm5kLm5vYmxlbmV0LXNlYWxlciddLFxuICAgIFsnbm53JywgJ2FwcGxpY2F0aW9uL3ZuZC5ub2JsZW5ldC13ZWInXSxcbiAgICBbJ25weCcsICdpbWFnZS92bmQubmV0LWZweCddLFxuICAgIFsnbnNjJywgJ2FwcGxpY2F0aW9uL3gtY29uZmVyZW5jZSddLFxuICAgIFsnbnNmJywgJ2FwcGxpY2F0aW9uL3ZuZC5sb3R1cy1ub3RlcyddLFxuICAgIFsnbnZkJywgJ2FwcGxpY2F0aW9uL3gtbmF2aWRvYyddLFxuICAgIFsnbndzJywgJ21lc3NhZ2UvcmZjODIyJ10sXG4gICAgWydvJywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbSddLFxuICAgIFsnb2EyJywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzMiddLFxuICAgIFsnb2EzJywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzMyddLFxuICAgIFsnb2FzJywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppdHN1Lm9hc3lzJ10sXG4gICAgWydvYmQnLCAnYXBwbGljYXRpb24veC1tc2JpbmRlciddLFxuICAgIFsnb2RhJywgJ2FwcGxpY2F0aW9uL29kYSddLFxuICAgIFsnb2RiJywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuZGF0YWJhc2UnXSxcbiAgICBbJ29kYycsICdhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmNoYXJ0J10sXG4gICAgWydvZGYnLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5mb3JtdWxhJ10sXG4gICAgWydvZGZ0JywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuZm9ybXVsYS10ZW1wbGF0ZSddLFxuICAgIFsnb2RnJywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuZ3JhcGhpY3MnXSxcbiAgICBbJ29kaScsICdhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmltYWdlJ10sXG4gICAgWydvZG0nLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC50ZXh0LW1hc3RlciddLFxuICAgIFsnb2RwJywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQucHJlc2VudGF0aW9uJ10sXG4gICAgWydvZHMnLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5zcHJlYWRzaGVldCddLFxuICAgIFsnb2R0JywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQudGV4dCddLFxuICAgIFsnb2dhJywgJ2F1ZGlvL29nZyddLFxuICAgIFsnb2d2JywgJ3ZpZGVvL29nZyddLFxuICAgIFsnb2d4JywgJ2FwcGxpY2F0aW9uL29nZyddLFxuICAgIFsnb21jJywgJ2FwcGxpY2F0aW9uL3gtb21jJ10sXG4gICAgWydvbWNkJywgJ2FwcGxpY2F0aW9uL3gtb21jZGF0YW1ha2VyJ10sXG4gICAgWydvbWNyJywgJ2FwcGxpY2F0aW9uL3gtb21jcmVnZXJhdG9yJ10sXG4gICAgWydvbmV0b2MnLCAnYXBwbGljYXRpb24vb25lbm90ZSddLFxuICAgIFsnb3BmJywgJ2FwcGxpY2F0aW9uL29lYnBzLXBhY2thZ2UreG1sJ10sXG4gICAgWydvcmcnLCAnYXBwbGljYXRpb24vdm5kLmxvdHVzLW9yZ2FuaXplciddLFxuICAgIFsnb3NmJywgJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEub3BlbnNjb3JlZm9ybWF0J10sXG4gICAgWydvc2ZwdmcnLCAnYXBwbGljYXRpb24vdm5kLnlhbWFoYS5vcGVuc2NvcmVmb3JtYXQub3NmcHZnK3htbCddLFxuICAgIFsnb3RjJywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQuY2hhcnQtdGVtcGxhdGUnXSxcbiAgICBbJ290ZicsICdhcHBsaWNhdGlvbi94LWZvbnQtb3RmJ10sXG4gICAgWydvdGcnLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5ncmFwaGljcy10ZW1wbGF0ZSddLFxuICAgIFsnb3RoJywgJ2FwcGxpY2F0aW9uL3ZuZC5vYXNpcy5vcGVuZG9jdW1lbnQudGV4dC13ZWInXSxcbiAgICBbJ290aScsICdhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LmltYWdlLXRlbXBsYXRlJ10sXG4gICAgWydvdHAnLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC5wcmVzZW50YXRpb24tdGVtcGxhdGUnXSxcbiAgICBbJ290cycsICdhcHBsaWNhdGlvbi92bmQub2FzaXMub3BlbmRvY3VtZW50LnNwcmVhZHNoZWV0LXRlbXBsYXRlJ10sXG4gICAgWydvdHQnLCAnYXBwbGljYXRpb24vdm5kLm9hc2lzLm9wZW5kb2N1bWVudC50ZXh0LXRlbXBsYXRlJ10sXG4gICAgWydveHQnLCAnYXBwbGljYXRpb24vdm5kLm9wZW5vZmZpY2VvcmcuZXh0ZW5zaW9uJ10sXG4gICAgWydwJywgJ3RleHQveC1wYXNjYWwnXSxcbiAgICBbJ3AxMCcsIFsnYXBwbGljYXRpb24vcGtjczEwJywgJ2FwcGxpY2F0aW9uL3gtcGtjczEwJ11dLFxuICAgIFsncDEyJywgWydhcHBsaWNhdGlvbi9wa2NzLTEyJywgJ2FwcGxpY2F0aW9uL3gtcGtjczEyJ11dLFxuICAgIFsncDdhJywgJ2FwcGxpY2F0aW9uL3gtcGtjczctc2lnbmF0dXJlJ10sXG4gICAgWydwN2InLCAnYXBwbGljYXRpb24veC1wa2NzNy1jZXJ0aWZpY2F0ZXMnXSxcbiAgICBbJ3A3YycsIFsnYXBwbGljYXRpb24vcGtjczctbWltZScsICdhcHBsaWNhdGlvbi94LXBrY3M3LW1pbWUnXV0sXG4gICAgWydwN20nLCBbJ2FwcGxpY2F0aW9uL3BrY3M3LW1pbWUnLCAnYXBwbGljYXRpb24veC1wa2NzNy1taW1lJ11dLFxuICAgIFsncDdyJywgJ2FwcGxpY2F0aW9uL3gtcGtjczctY2VydHJlcXJlc3AnXSxcbiAgICBbJ3A3cycsIFsnYXBwbGljYXRpb24vcGtjczctc2lnbmF0dXJlJywgJ2FwcGxpY2F0aW9uL3gtcGtjczctc2lnbmF0dXJlJ11dLFxuICAgIFsncDgnLCAnYXBwbGljYXRpb24vcGtjczgnXSxcbiAgICBbJ3BhcicsICd0ZXh0L3BsYWluLWJhcyddLFxuICAgIFsncGFydCcsICdhcHBsaWNhdGlvbi9wcm9fZW5nJ10sXG4gICAgWydwYXMnLCAndGV4dC9wYXNjYWwnXSxcbiAgICBbJ3BhdycsICdhcHBsaWNhdGlvbi92bmQucGF3YWFmaWxlJ10sXG4gICAgWydwYmQnLCAnYXBwbGljYXRpb24vdm5kLnBvd2VyYnVpbGRlcjYnXSxcbiAgICBbJ3BibScsICdpbWFnZS94LXBvcnRhYmxlLWJpdG1hcCddLFxuICAgIFsncGNmJywgJ2FwcGxpY2F0aW9uL3gtZm9udC1wY2YnXSxcbiAgICBbJ3BjbCcsIFsnYXBwbGljYXRpb24vdm5kLmhwLXBjbCcsICdhcHBsaWNhdGlvbi94LXBjbCddXSxcbiAgICBbJ3BjbHhsJywgJ2FwcGxpY2F0aW9uL3ZuZC5ocC1wY2x4bCddLFxuICAgIFsncGN0JywgJ2ltYWdlL3gtcGljdCddLFxuICAgIFsncGN1cmwnLCAnYXBwbGljYXRpb24vdm5kLmN1cmwucGN1cmwnXSxcbiAgICBbJ3BjeCcsICdpbWFnZS94LXBjeCddLFxuICAgIFsncGRiJywgWydhcHBsaWNhdGlvbi92bmQucGFsbScsICdjaGVtaWNhbC94LXBkYiddXSxcbiAgICBbJ3BkZicsICdhcHBsaWNhdGlvbi9wZGYnXSxcbiAgICBbJ3BmYScsICdhcHBsaWNhdGlvbi94LWZvbnQtdHlwZTEnXSxcbiAgICBbJ3BmcicsICdhcHBsaWNhdGlvbi9mb250LXRkcGZyJ10sXG4gICAgWydwZnVuaycsIFsnYXVkaW8vbWFrZScsICdhdWRpby9tYWtlLm15LmZ1bmsnXV0sXG4gICAgWydwZngnLCAnYXBwbGljYXRpb24veC1wa2NzMTInXSxcbiAgICBbJ3BnbScsIFsnaW1hZ2UveC1wb3J0YWJsZS1ncmF5bWFwJywgJ2ltYWdlL3gtcG9ydGFibGUtZ3JleW1hcCddXSxcbiAgICBbJ3BnbicsICdhcHBsaWNhdGlvbi94LWNoZXNzLXBnbiddLFxuICAgIFsncGdwJywgJ2FwcGxpY2F0aW9uL3BncC1zaWduYXR1cmUnXSxcbiAgICBbJ3BpYycsIFsnaW1hZ2UvcGljdCcsICdpbWFnZS94LXBpY3QnXV0sXG4gICAgWydwaWN0JywgJ2ltYWdlL3BpY3QnXSxcbiAgICBbJ3BrZycsICdhcHBsaWNhdGlvbi94LW5ld3Rvbi1jb21wYXRpYmxlLXBrZyddLFxuICAgIFsncGtpJywgJ2FwcGxpY2F0aW9uL3BraXhjbXAnXSxcbiAgICBbJ3BraXBhdGgnLCAnYXBwbGljYXRpb24vcGtpeC1wa2lwYXRoJ10sXG4gICAgWydwa28nLCBbJ2FwcGxpY2F0aW9uL3luZC5tcy1wa2lwa28nLCAnYXBwbGljYXRpb24vdm5kLm1zLXBraS5wa28nXV0sXG4gICAgWydwbCcsIFsndGV4dC9wbGFpbicsICd0ZXh0L3gtc2NyaXB0LnBlcmwnXV0sXG4gICAgWydwbGInLCAnYXBwbGljYXRpb24vdm5kLjNncHAucGljLWJ3LWxhcmdlJ10sXG4gICAgWydwbGMnLCAnYXBwbGljYXRpb24vdm5kLm1vYml1cy5wbGMnXSxcbiAgICBbJ3BsZicsICdhcHBsaWNhdGlvbi92bmQucG9ja2V0bGVhcm4nXSxcbiAgICBbJ3BscycsICdhcHBsaWNhdGlvbi9wbHMreG1sJ10sXG4gICAgWydwbHgnLCAnYXBwbGljYXRpb24veC1waXhjbHNjcmlwdCddLFxuICAgIFsncG0nLCBbJ3RleHQveC1zY3JpcHQucGVybC1tb2R1bGUnLCAnaW1hZ2UveC14cGl4bWFwJ11dLFxuICAgIFsncG00JywgJ2FwcGxpY2F0aW9uL3gtcGFnZW1ha2VyJ10sXG4gICAgWydwbTUnLCAnYXBwbGljYXRpb24veC1wYWdlbWFrZXInXSxcbiAgICBbJ3BtYScsICdhcHBsaWNhdGlvbi94LXBlcmZtb24nXSxcbiAgICBbJ3BtYycsICdhcHBsaWNhdGlvbi94LXBlcmZtb24nXSxcbiAgICBbJ3BtbCcsIFsnYXBwbGljYXRpb24vdm5kLmN0Yy1wb3NtbCcsICdhcHBsaWNhdGlvbi94LXBlcmZtb24nXV0sXG4gICAgWydwbXInLCAnYXBwbGljYXRpb24veC1wZXJmbW9uJ10sXG4gICAgWydwbXcnLCAnYXBwbGljYXRpb24veC1wZXJmbW9uJ10sXG4gICAgWydwbmcnLCAnaW1hZ2UvcG5nJ10sXG4gICAgWydwbm0nLCBbJ2FwcGxpY2F0aW9uL3gtcG9ydGFibGUtYW55bWFwJywgJ2ltYWdlL3gtcG9ydGFibGUtYW55bWFwJ11dLFxuICAgIFsncG9ydHBrZycsICdhcHBsaWNhdGlvbi92bmQubWFjcG9ydHMucG9ydHBrZyddLFxuICAgIFsncG90JywgWydhcHBsaWNhdGlvbi92bmQubXMtcG93ZXJwb2ludCcsICdhcHBsaWNhdGlvbi9tc3Bvd2VycG9pbnQnXV0sXG4gICAgWydwb3RtJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50LnRlbXBsYXRlLm1hY3JvZW5hYmxlZC4xMiddLFxuICAgIFsncG90eCcsICdhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQucHJlc2VudGF0aW9ubWwudGVtcGxhdGUnXSxcbiAgICBbJ3BvdicsICdtb2RlbC94LXBvdiddLFxuICAgIFsncHBhJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50J10sXG4gICAgWydwcGFtJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50LmFkZGluLm1hY3JvZW5hYmxlZC4xMiddLFxuICAgIFsncHBkJywgJ2FwcGxpY2F0aW9uL3ZuZC5jdXBzLXBwZCddLFxuICAgIFsncHBtJywgJ2ltYWdlL3gtcG9ydGFibGUtcGl4bWFwJ10sXG4gICAgWydwcHMnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50JywgJ2FwcGxpY2F0aW9uL21zcG93ZXJwb2ludCddXSxcbiAgICBbJ3Bwc20nLCAnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQuc2xpZGVzaG93Lm1hY3JvZW5hYmxlZC4xMiddLFxuICAgIFsncHBzeCcsICdhcHBsaWNhdGlvbi92bmQub3BlbnhtbGZvcm1hdHMtb2ZmaWNlZG9jdW1lbnQucHJlc2VudGF0aW9ubWwuc2xpZGVzaG93J10sXG4gICAgWydwcHQnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wb3dlcnBvaW50JywgJ2FwcGxpY2F0aW9uL21zcG93ZXJwb2ludCcsICdhcHBsaWNhdGlvbi9wb3dlcnBvaW50JywgJ2FwcGxpY2F0aW9uL3gtbXNwb3dlcnBvaW50J11dLFxuICAgIFsncHB0bScsICdhcHBsaWNhdGlvbi92bmQubXMtcG93ZXJwb2ludC5wcmVzZW50YXRpb24ubWFjcm9lbmFibGVkLjEyJ10sXG4gICAgWydwcHR4JywgJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5wcmVzZW50YXRpb25tbC5wcmVzZW50YXRpb24nXSxcbiAgICBbJ3BweicsICdhcHBsaWNhdGlvbi9tc3Bvd2VycG9pbnQnXSxcbiAgICBbJ3ByYycsICdhcHBsaWNhdGlvbi94LW1vYmlwb2NrZXQtZWJvb2snXSxcbiAgICBbJ3ByZScsIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLWZyZWVsYW5jZScsICdhcHBsaWNhdGlvbi94LWZyZWVsYW5jZSddXSxcbiAgICBbJ3ByZicsICdhcHBsaWNhdGlvbi9waWNzLXJ1bGVzJ10sXG4gICAgWydwcnQnLCAnYXBwbGljYXRpb24vcHJvX2VuZyddLFxuICAgIFsncHMnLCAnYXBwbGljYXRpb24vcG9zdHNjcmlwdCddLFxuICAgIFsncHNiJywgJ2FwcGxpY2F0aW9uL3ZuZC4zZ3BwLnBpYy1idy1zbWFsbCddLFxuICAgIFsncHNkJywgWydhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nLCAnaW1hZ2Uvdm5kLmFkb2JlLnBob3Rvc2hvcCddXSxcbiAgICBbJ3BzZicsICdhcHBsaWNhdGlvbi94LWZvbnQtbGludXgtcHNmJ10sXG4gICAgWydwc2tjeG1sJywgJ2FwcGxpY2F0aW9uL3Bza2MreG1sJ10sXG4gICAgWydwdGlkJywgJ2FwcGxpY2F0aW9uL3ZuZC5wdmkucHRpZDEnXSxcbiAgICBbJ3B1YicsICdhcHBsaWNhdGlvbi94LW1zcHVibGlzaGVyJ10sXG4gICAgWydwdmInLCAnYXBwbGljYXRpb24vdm5kLjNncHAucGljLWJ3LXZhciddLFxuICAgIFsncHZ1JywgJ3BhbGVvdnUveC1wdiddLFxuICAgIFsncHduJywgJ2FwcGxpY2F0aW9uL3ZuZC4zbS5wb3N0LWl0LW5vdGVzJ10sXG4gICAgWydwd3onLCAnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQnXSxcbiAgICBbJ3B5JywgJ3RleHQveC1zY3JpcHQucGh5dG9uJ10sXG4gICAgWydweWEnLCAnYXVkaW8vdm5kLm1zLXBsYXlyZWFkeS5tZWRpYS5weWEnXSxcbiAgICBbJ3B5YycsICdhcHBsaWNhdGlvbi94LWJ5dGVjb2RlLnB5dGhvbiddLFxuICAgIFsncHl2JywgJ3ZpZGVvL3ZuZC5tcy1wbGF5cmVhZHkubWVkaWEucHl2J10sXG4gICAgWydxYW0nLCAnYXBwbGljYXRpb24vdm5kLmVwc29uLnF1aWNrYW5pbWUnXSxcbiAgICBbJ3FibycsICdhcHBsaWNhdGlvbi92bmQuaW50dS5xYm8nXSxcbiAgICBbJ3FjcCcsICdhdWRpby92bmQucWNlbHAnXSxcbiAgICBbJ3FkMycsICd4LXdvcmxkL3gtM2RtZiddLFxuICAgIFsncWQzZCcsICd4LXdvcmxkL3gtM2RtZiddLFxuICAgIFsncWZ4JywgJ2FwcGxpY2F0aW9uL3ZuZC5pbnR1LnFmeCddLFxuICAgIFsncWlmJywgJ2ltYWdlL3gtcXVpY2t0aW1lJ10sXG4gICAgWydxcHMnLCAnYXBwbGljYXRpb24vdm5kLnB1Ymxpc2hhcmUtZGVsdGEtdHJlZSddLFxuICAgIFsncXQnLCAndmlkZW8vcXVpY2t0aW1lJ10sXG4gICAgWydxdGMnLCAndmlkZW8veC1xdGMnXSxcbiAgICBbJ3F0aScsICdpbWFnZS94LXF1aWNrdGltZSddLFxuICAgIFsncXRpZicsICdpbWFnZS94LXF1aWNrdGltZSddLFxuICAgIFsncXhkJywgJ2FwcGxpY2F0aW9uL3ZuZC5xdWFyay5xdWFya3hwcmVzcyddLFxuICAgIFsncmEnLCBbJ2F1ZGlvL3gtcmVhbGF1ZGlvJywgJ2F1ZGlvL3gtcG4tcmVhbGF1ZGlvJywgJ2F1ZGlvL3gtcG4tcmVhbGF1ZGlvLXBsdWdpbiddXSxcbiAgICBbJ3JhbScsICdhdWRpby94LXBuLXJlYWxhdWRpbyddLFxuICAgIFsncmFyJywgJ2FwcGxpY2F0aW9uL3gtcmFyLWNvbXByZXNzZWQnXSxcbiAgICBbJ3JhcycsIFsnaW1hZ2UvY211LXJhc3RlcicsICdhcHBsaWNhdGlvbi94LWNtdS1yYXN0ZXInLCAnaW1hZ2UveC1jbXUtcmFzdGVyJ11dLFxuICAgIFsncmFzdCcsICdpbWFnZS9jbXUtcmFzdGVyJ10sXG4gICAgWydyY3Byb2ZpbGUnLCAnYXBwbGljYXRpb24vdm5kLmlwdW5wbHVnZ2VkLnJjcHJvZmlsZSddLFxuICAgIFsncmRmJywgJ2FwcGxpY2F0aW9uL3JkZit4bWwnXSxcbiAgICBbJ3JkeicsICdhcHBsaWNhdGlvbi92bmQuZGF0YS12aXNpb24ucmR6J10sXG4gICAgWydyZXAnLCAnYXBwbGljYXRpb24vdm5kLmJ1c2luZXNzb2JqZWN0cyddLFxuICAgIFsncmVzJywgJ2FwcGxpY2F0aW9uL3gtZHRicmVzb3VyY2UreG1sJ10sXG4gICAgWydyZXh4JywgJ3RleHQveC1zY3JpcHQucmV4eCddLFxuICAgIFsncmYnLCAnaW1hZ2Uvdm5kLnJuLXJlYWxmbGFzaCddLFxuICAgIFsncmdiJywgJ2ltYWdlL3gtcmdiJ10sXG4gICAgWydyaWYnLCAnYXBwbGljYXRpb24vcmVnaW5mbyt4bWwnXSxcbiAgICBbJ3JpcCcsICdhdWRpby92bmQucmlwJ10sXG4gICAgWydybCcsICdhcHBsaWNhdGlvbi9yZXNvdXJjZS1saXN0cyt4bWwnXSxcbiAgICBbJ3JsYycsICdpbWFnZS92bmQuZnVqaXhlcm94LmVkbWljcy1ybGMnXSxcbiAgICBbJ3JsZCcsICdhcHBsaWNhdGlvbi9yZXNvdXJjZS1saXN0cy1kaWZmK3htbCddLFxuICAgIFsncm0nLCBbJ2FwcGxpY2F0aW9uL3ZuZC5ybi1yZWFsbWVkaWEnLCAnYXVkaW8veC1wbi1yZWFsYXVkaW8nXV0sXG4gICAgWydybWknLCAnYXVkaW8vbWlkJ10sXG4gICAgWydybW0nLCAnYXVkaW8veC1wbi1yZWFsYXVkaW8nXSxcbiAgICBbJ3JtcCcsIFsnYXVkaW8veC1wbi1yZWFsYXVkaW8tcGx1Z2luJywgJ2F1ZGlvL3gtcG4tcmVhbGF1ZGlvJ11dLFxuICAgIFsncm1zJywgJ2FwcGxpY2F0aW9uL3ZuZC5qY3AuamF2YW1lLm1pZGxldC1ybXMnXSxcbiAgICBbJ3JuYycsICdhcHBsaWNhdGlvbi9yZWxheC1uZy1jb21wYWN0LXN5bnRheCddLFxuICAgIFsncm5nJywgWydhcHBsaWNhdGlvbi9yaW5naW5nLXRvbmVzJywgJ2FwcGxpY2F0aW9uL3ZuZC5ub2tpYS5yaW5naW5nLXRvbmUnXV0sXG4gICAgWydybngnLCAnYXBwbGljYXRpb24vdm5kLnJuLXJlYWxwbGF5ZXInXSxcbiAgICBbJ3JvZmYnLCAnYXBwbGljYXRpb24veC10cm9mZiddLFxuICAgIFsncnAnLCAnaW1hZ2Uvdm5kLnJuLXJlYWxwaXgnXSxcbiAgICBbJ3JwOScsICdhcHBsaWNhdGlvbi92bmQuY2xvYW50by5ycDknXSxcbiAgICBbJ3JwbScsICdhdWRpby94LXBuLXJlYWxhdWRpby1wbHVnaW4nXSxcbiAgICBbJ3Jwc3MnLCAnYXBwbGljYXRpb24vdm5kLm5va2lhLnJhZGlvLXByZXNldHMnXSxcbiAgICBbJ3Jwc3QnLCAnYXBwbGljYXRpb24vdm5kLm5va2lhLnJhZGlvLXByZXNldCddLFxuICAgIFsncnEnLCAnYXBwbGljYXRpb24vc3BhcnFsLXF1ZXJ5J10sXG4gICAgWydycycsICdhcHBsaWNhdGlvbi9ybHMtc2VydmljZXMreG1sJ10sXG4gICAgWydyc2QnLCAnYXBwbGljYXRpb24vcnNkK3htbCddLFxuICAgIFsncnQnLCBbJ3RleHQvcmljaHRleHQnLCAndGV4dC92bmQucm4tcmVhbHRleHQnXV0sXG4gICAgWydydGYnLCBbJ2FwcGxpY2F0aW9uL3J0ZicsICd0ZXh0L3JpY2h0ZXh0JywgJ2FwcGxpY2F0aW9uL3gtcnRmJ11dLFxuICAgIFsncnR4JywgWyd0ZXh0L3JpY2h0ZXh0JywgJ2FwcGxpY2F0aW9uL3J0ZiddXSxcbiAgICBbJ3J2JywgJ3ZpZGVvL3ZuZC5ybi1yZWFsdmlkZW8nXSxcbiAgICBbJ3MnLCAndGV4dC94LWFzbSddLFxuICAgIFsnczNtJywgJ2F1ZGlvL3MzbSddLFxuICAgIFsnc2FmJywgJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuc21hZi1hdWRpbyddLFxuICAgIFsnc2F2ZW1lJywgJ2FwcGxpY2F0aW9uL29jdGV0LXN0cmVhbSddLFxuICAgIFsnc2JrJywgJ2FwcGxpY2F0aW9uL3gtdGJvb2snXSxcbiAgICBbJ3NibWwnLCAnYXBwbGljYXRpb24vc2JtbCt4bWwnXSxcbiAgICBbJ3NjJywgJ2FwcGxpY2F0aW9uL3ZuZC5pYm0uc2VjdXJlLWNvbnRhaW5lciddLFxuICAgIFsnc2NkJywgJ2FwcGxpY2F0aW9uL3gtbXNzY2hlZHVsZSddLFxuICAgIFtcbiAgICAgICAgJ3NjbScsXG4gICAgICAgIFsnYXBwbGljYXRpb24vdm5kLmxvdHVzLXNjcmVlbmNhbScsICd2aWRlby94LXNjbScsICd0ZXh0L3gtc2NyaXB0Lmd1aWxlJywgJ2FwcGxpY2F0aW9uL3gtbG90dXNzY3JlZW5jYW0nLCAndGV4dC94LXNjcmlwdC5zY2hlbWUnXVxuICAgIF0sXG4gICAgWydzY3EnLCAnYXBwbGljYXRpb24vc2N2cC1jdi1yZXF1ZXN0J10sXG4gICAgWydzY3MnLCAnYXBwbGljYXRpb24vc2N2cC1jdi1yZXNwb25zZSddLFxuICAgIFsnc2N0JywgJ3RleHQvc2NyaXB0bGV0J10sXG4gICAgWydzY3VybCcsICd0ZXh0L3ZuZC5jdXJsLnNjdXJsJ10sXG4gICAgWydzZGEnLCAnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5kcmF3J10sXG4gICAgWydzZGMnLCAnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5jYWxjJ10sXG4gICAgWydzZGQnLCAnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi5pbXByZXNzJ10sXG4gICAgWydzZGttJywgJ2FwcGxpY2F0aW9uL3ZuZC5zb2xlbnQuc2RrbSt4bWwnXSxcbiAgICBbJ3NkbWwnLCAndGV4dC9wbGFpbiddLFxuICAgIFsnc2RwJywgWydhcHBsaWNhdGlvbi9zZHAnLCAnYXBwbGljYXRpb24veC1zZHAnXV0sXG4gICAgWydzZHInLCAnYXBwbGljYXRpb24vc291bmRlciddLFxuICAgIFsnc2R3JywgJ2FwcGxpY2F0aW9uL3ZuZC5zdGFyZGl2aXNpb24ud3JpdGVyJ10sXG4gICAgWydzZWEnLCBbJ2FwcGxpY2F0aW9uL3NlYScsICdhcHBsaWNhdGlvbi94LXNlYSddXSxcbiAgICBbJ3NlZScsICdhcHBsaWNhdGlvbi92bmQuc2VlbWFpbCddLFxuICAgIFsnc2VlZCcsICdhcHBsaWNhdGlvbi92bmQuZmRzbi5zZWVkJ10sXG4gICAgWydzZW1hJywgJ2FwcGxpY2F0aW9uL3ZuZC5zZW1hJ10sXG4gICAgWydzZW1kJywgJ2FwcGxpY2F0aW9uL3ZuZC5zZW1kJ10sXG4gICAgWydzZW1mJywgJ2FwcGxpY2F0aW9uL3ZuZC5zZW1mJ10sXG4gICAgWydzZXInLCAnYXBwbGljYXRpb24vamF2YS1zZXJpYWxpemVkLW9iamVjdCddLFxuICAgIFsnc2V0JywgJ2FwcGxpY2F0aW9uL3NldCddLFxuICAgIFsnc2V0cGF5JywgJ2FwcGxpY2F0aW9uL3NldC1wYXltZW50LWluaXRpYXRpb24nXSxcbiAgICBbJ3NldHJlZycsICdhcHBsaWNhdGlvbi9zZXQtcmVnaXN0cmF0aW9uLWluaXRpYXRpb24nXSxcbiAgICBbJ3NmZC1oZHN0eCcsICdhcHBsaWNhdGlvbi92bmQuaHlkcm9zdGF0aXguc29mLWRhdGEnXSxcbiAgICBbJ3NmcycsICdhcHBsaWNhdGlvbi92bmQuc3BvdGZpcmUuc2ZzJ10sXG4gICAgWydzZ2wnLCAnYXBwbGljYXRpb24vdm5kLnN0YXJkaXZpc2lvbi53cml0ZXItZ2xvYmFsJ10sXG4gICAgWydzZ20nLCBbJ3RleHQvc2dtbCcsICd0ZXh0L3gtc2dtbCddXSxcbiAgICBbJ3NnbWwnLCBbJ3RleHQvc2dtbCcsICd0ZXh0L3gtc2dtbCddXSxcbiAgICBbJ3NoJywgWydhcHBsaWNhdGlvbi94LXNoYXInLCAnYXBwbGljYXRpb24veC1ic2gnLCAnYXBwbGljYXRpb24veC1zaCcsICd0ZXh0L3gtc2NyaXB0LnNoJ11dLFxuICAgIFsnc2hhcicsIFsnYXBwbGljYXRpb24veC1ic2gnLCAnYXBwbGljYXRpb24veC1zaGFyJ11dLFxuICAgIFsnc2hmJywgJ2FwcGxpY2F0aW9uL3NoZit4bWwnXSxcbiAgICBbJ3NodG1sJywgWyd0ZXh0L2h0bWwnLCAndGV4dC94LXNlcnZlci1wYXJzZWQtaHRtbCddXSxcbiAgICBbJ3NpZCcsICdhdWRpby94LXBzaWQnXSxcbiAgICBbJ3NpcycsICdhcHBsaWNhdGlvbi92bmQuc3ltYmlhbi5pbnN0YWxsJ10sXG4gICAgWydzaXQnLCBbJ2FwcGxpY2F0aW9uL3gtc3R1ZmZpdCcsICdhcHBsaWNhdGlvbi94LXNpdCddXSxcbiAgICBbJ3NpdHgnLCAnYXBwbGljYXRpb24veC1zdHVmZml0eCddLFxuICAgIFsnc2tkJywgJ2FwcGxpY2F0aW9uL3gta29hbiddLFxuICAgIFsnc2ttJywgJ2FwcGxpY2F0aW9uL3gta29hbiddLFxuICAgIFsnc2twJywgWydhcHBsaWNhdGlvbi92bmQua29hbicsICdhcHBsaWNhdGlvbi94LWtvYW4nXV0sXG4gICAgWydza3QnLCAnYXBwbGljYXRpb24veC1rb2FuJ10sXG4gICAgWydzbCcsICdhcHBsaWNhdGlvbi94LXNlZWxvZ28nXSxcbiAgICBbJ3NsZG0nLCAnYXBwbGljYXRpb24vdm5kLm1zLXBvd2VycG9pbnQuc2xpZGUubWFjcm9lbmFibGVkLjEyJ10sXG4gICAgWydzbGR4JywgJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5wcmVzZW50YXRpb25tbC5zbGlkZSddLFxuICAgIFsnc2x0JywgJ2FwcGxpY2F0aW9uL3ZuZC5lcHNvbi5zYWx0J10sXG4gICAgWydzbScsICdhcHBsaWNhdGlvbi92bmQuc3RlcG1hbmlhLnN0ZXBjaGFydCddLFxuICAgIFsnc21mJywgJ2FwcGxpY2F0aW9uL3ZuZC5zdGFyZGl2aXNpb24ubWF0aCddLFxuICAgIFsnc21pJywgWydhcHBsaWNhdGlvbi9zbWlsJywgJ2FwcGxpY2F0aW9uL3NtaWwreG1sJ11dLFxuICAgIFsnc21pbCcsICdhcHBsaWNhdGlvbi9zbWlsJ10sXG4gICAgWydzbmQnLCBbJ2F1ZGlvL2Jhc2ljJywgJ2F1ZGlvL3gtYWRwY20nXV0sXG4gICAgWydzbmYnLCAnYXBwbGljYXRpb24veC1mb250LXNuZiddLFxuICAgIFsnc29sJywgJ2FwcGxpY2F0aW9uL3NvbGlkcyddLFxuICAgIFsnc3BjJywgWyd0ZXh0L3gtc3BlZWNoJywgJ2FwcGxpY2F0aW9uL3gtcGtjczctY2VydGlmaWNhdGVzJ11dLFxuICAgIFsnc3BmJywgJ2FwcGxpY2F0aW9uL3ZuZC55YW1haGEuc21hZi1waHJhc2UnXSxcbiAgICBbJ3NwbCcsIFsnYXBwbGljYXRpb24vZnV0dXJlc3BsYXNoJywgJ2FwcGxpY2F0aW9uL3gtZnV0dXJlc3BsYXNoJ11dLFxuICAgIFsnc3BvdCcsICd0ZXh0L3ZuZC5pbjNkLnNwb3QnXSxcbiAgICBbJ3NwcCcsICdhcHBsaWNhdGlvbi9zY3ZwLXZwLXJlc3BvbnNlJ10sXG4gICAgWydzcHEnLCAnYXBwbGljYXRpb24vc2N2cC12cC1yZXF1ZXN0J10sXG4gICAgWydzcHInLCAnYXBwbGljYXRpb24veC1zcHJpdGUnXSxcbiAgICBbJ3Nwcml0ZScsICdhcHBsaWNhdGlvbi94LXNwcml0ZSddLFxuICAgIFsnc3JjJywgJ2FwcGxpY2F0aW9uL3gtd2Fpcy1zb3VyY2UnXSxcbiAgICBbJ3NydScsICdhcHBsaWNhdGlvbi9zcnUreG1sJ10sXG4gICAgWydzcngnLCAnYXBwbGljYXRpb24vc3BhcnFsLXJlc3VsdHMreG1sJ10sXG4gICAgWydzc2UnLCAnYXBwbGljYXRpb24vdm5kLmtvZGFrLWRlc2NyaXB0b3InXSxcbiAgICBbJ3NzZicsICdhcHBsaWNhdGlvbi92bmQuZXBzb24uc3NmJ10sXG4gICAgWydzc2knLCAndGV4dC94LXNlcnZlci1wYXJzZWQtaHRtbCddLFxuICAgIFsnc3NtJywgJ2FwcGxpY2F0aW9uL3N0cmVhbWluZ21lZGlhJ10sXG4gICAgWydzc21sJywgJ2FwcGxpY2F0aW9uL3NzbWwreG1sJ10sXG4gICAgWydzc3QnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1wa2ljZXJ0c3RvcmUnLCAnYXBwbGljYXRpb24vdm5kLm1zLXBraS5jZXJ0c3RvcmUnXV0sXG4gICAgWydzdCcsICdhcHBsaWNhdGlvbi92bmQuc2FpbGluZ3RyYWNrZXIudHJhY2snXSxcbiAgICBbJ3N0YycsICdhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC5jYWxjLnRlbXBsYXRlJ10sXG4gICAgWydzdGQnLCAnYXBwbGljYXRpb24vdm5kLnN1bi54bWwuZHJhdy50ZW1wbGF0ZSddLFxuICAgIFsnc3RlcCcsICdhcHBsaWNhdGlvbi9zdGVwJ10sXG4gICAgWydzdGYnLCAnYXBwbGljYXRpb24vdm5kLnd0LnN0ZiddLFxuICAgIFsnc3RpJywgJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLmltcHJlc3MudGVtcGxhdGUnXSxcbiAgICBbJ3N0aycsICdhcHBsaWNhdGlvbi9oeXBlcnN0dWRpbyddLFxuICAgIFsnc3RsJywgWydhcHBsaWNhdGlvbi92bmQubXMtcGtpc3RsJywgJ2FwcGxpY2F0aW9uL3NsYScsICdhcHBsaWNhdGlvbi92bmQubXMtcGtpLnN0bCcsICdhcHBsaWNhdGlvbi94LW5hdmlzdHlsZSddXSxcbiAgICBbJ3N0bScsICd0ZXh0L2h0bWwnXSxcbiAgICBbJ3N0cCcsICdhcHBsaWNhdGlvbi9zdGVwJ10sXG4gICAgWydzdHInLCAnYXBwbGljYXRpb24vdm5kLnBnLmZvcm1hdCddLFxuICAgIFsnc3R3JywgJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLndyaXRlci50ZW1wbGF0ZSddLFxuICAgIFsnc3ViJywgJ2ltYWdlL3ZuZC5kdmIuc3VidGl0bGUnXSxcbiAgICBbJ3N1cycsICdhcHBsaWNhdGlvbi92bmQuc3VzLWNhbGVuZGFyJ10sXG4gICAgWydzdjRjcGlvJywgJ2FwcGxpY2F0aW9uL3gtc3Y0Y3BpbyddLFxuICAgIFsnc3Y0Y3JjJywgJ2FwcGxpY2F0aW9uL3gtc3Y0Y3JjJ10sXG4gICAgWydzdmMnLCAnYXBwbGljYXRpb24vdm5kLmR2Yi5zZXJ2aWNlJ10sXG4gICAgWydzdmQnLCAnYXBwbGljYXRpb24vdm5kLnN2ZCddLFxuICAgIFsnc3ZmJywgWydpbWFnZS92bmQuZHdnJywgJ2ltYWdlL3gtZHdnJ11dLFxuICAgIFsnc3ZnJywgJ2ltYWdlL3N2Zyt4bWwnXSxcbiAgICBbJ3N2cicsIFsneC13b3JsZC94LXN2cicsICdhcHBsaWNhdGlvbi94LXdvcmxkJ11dLFxuICAgIFsnc3dmJywgJ2FwcGxpY2F0aW9uL3gtc2hvY2t3YXZlLWZsYXNoJ10sXG4gICAgWydzd2knLCAnYXBwbGljYXRpb24vdm5kLmFyaXN0YW5ldHdvcmtzLnN3aSddLFxuICAgIFsnc3hjJywgJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLmNhbGMnXSxcbiAgICBbJ3N4ZCcsICdhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC5kcmF3J10sXG4gICAgWydzeGcnLCAnYXBwbGljYXRpb24vdm5kLnN1bi54bWwud3JpdGVyLmdsb2JhbCddLFxuICAgIFsnc3hpJywgJ2FwcGxpY2F0aW9uL3ZuZC5zdW4ueG1sLmltcHJlc3MnXSxcbiAgICBbJ3N4bScsICdhcHBsaWNhdGlvbi92bmQuc3VuLnhtbC5tYXRoJ10sXG4gICAgWydzeHcnLCAnYXBwbGljYXRpb24vdm5kLnN1bi54bWwud3JpdGVyJ10sXG4gICAgWyd0JywgWyd0ZXh0L3Ryb2ZmJywgJ2FwcGxpY2F0aW9uL3gtdHJvZmYnXV0sXG4gICAgWyd0YWxrJywgJ3RleHQveC1zcGVlY2gnXSxcbiAgICBbJ3RhbycsICdhcHBsaWNhdGlvbi92bmQudGFvLmludGVudC1tb2R1bGUtYXJjaGl2ZSddLFxuICAgIFsndGFyJywgJ2FwcGxpY2F0aW9uL3gtdGFyJ10sXG4gICAgWyd0YmsnLCBbJ2FwcGxpY2F0aW9uL3Rvb2xib29rJywgJ2FwcGxpY2F0aW9uL3gtdGJvb2snXV0sXG4gICAgWyd0Y2FwJywgJ2FwcGxpY2F0aW9uL3ZuZC4zZ3BwMi50Y2FwJ10sXG4gICAgWyd0Y2wnLCBbJ3RleHQveC1zY3JpcHQudGNsJywgJ2FwcGxpY2F0aW9uL3gtdGNsJ11dLFxuICAgIFsndGNzaCcsICd0ZXh0L3gtc2NyaXB0LnRjc2gnXSxcbiAgICBbJ3RlYWNoZXInLCAnYXBwbGljYXRpb24vdm5kLnNtYXJ0LnRlYWNoZXInXSxcbiAgICBbJ3RlaScsICdhcHBsaWNhdGlvbi90ZWkreG1sJ10sXG4gICAgWyd0ZXgnLCAnYXBwbGljYXRpb24veC10ZXgnXSxcbiAgICBbJ3RleGknLCAnYXBwbGljYXRpb24veC10ZXhpbmZvJ10sXG4gICAgWyd0ZXhpbmZvJywgJ2FwcGxpY2F0aW9uL3gtdGV4aW5mbyddLFxuICAgIFsndGV4dCcsIFsnYXBwbGljYXRpb24vcGxhaW4nLCAndGV4dC9wbGFpbiddXSxcbiAgICBbJ3RmaScsICdhcHBsaWNhdGlvbi90aHJhdWQreG1sJ10sXG4gICAgWyd0Zm0nLCAnYXBwbGljYXRpb24veC10ZXgtdGZtJ10sXG4gICAgWyd0Z3onLCBbJ2FwcGxpY2F0aW9uL2dudXRhcicsICdhcHBsaWNhdGlvbi94LWNvbXByZXNzZWQnXV0sXG4gICAgWyd0aG14JywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1vZmZpY2V0aGVtZSddLFxuICAgIFsndGlmJywgWydpbWFnZS90aWZmJywgJ2ltYWdlL3gtdGlmZiddXSxcbiAgICBbJ3RpZmYnLCBbJ2ltYWdlL3RpZmYnLCAnaW1hZ2UveC10aWZmJ11dLFxuICAgIFsndG1vJywgJ2FwcGxpY2F0aW9uL3ZuZC50bW9iaWxlLWxpdmV0diddLFxuICAgIFsndG9ycmVudCcsICdhcHBsaWNhdGlvbi94LWJpdHRvcnJlbnQnXSxcbiAgICBbJ3RwbCcsICdhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLXRvb2wtdGVtcGxhdGUnXSxcbiAgICBbJ3RwdCcsICdhcHBsaWNhdGlvbi92bmQudHJpZC50cHQnXSxcbiAgICBbJ3RyJywgJ2FwcGxpY2F0aW9uL3gtdHJvZmYnXSxcbiAgICBbJ3RyYScsICdhcHBsaWNhdGlvbi92bmQudHJ1ZWFwcCddLFxuICAgIFsndHJtJywgJ2FwcGxpY2F0aW9uL3gtbXN0ZXJtaW5hbCddLFxuICAgIFsndHNkJywgJ2FwcGxpY2F0aW9uL3RpbWVzdGFtcGVkLWRhdGEnXSxcbiAgICBbJ3RzaScsICdhdWRpby90c3AtYXVkaW8nXSxcbiAgICBbJ3RzcCcsIFsnYXBwbGljYXRpb24vZHNwdHlwZScsICdhdWRpby90c3BsYXllciddXSxcbiAgICBbJ3RzdicsICd0ZXh0L3RhYi1zZXBhcmF0ZWQtdmFsdWVzJ10sXG4gICAgWyd0dGYnLCAnYXBwbGljYXRpb24veC1mb250LXR0ZiddLFxuICAgIFsndHRsJywgJ3RleHQvdHVydGxlJ10sXG4gICAgWyd0dXJib3QnLCAnaW1hZ2UvZmxvcmlhbiddLFxuICAgIFsndHdkJywgJ2FwcGxpY2F0aW9uL3ZuZC5zaW10ZWNoLW1pbmRtYXBwZXInXSxcbiAgICBbJ3R4ZCcsICdhcHBsaWNhdGlvbi92bmQuZ2Vub21hdGl4LnR1eGVkbyddLFxuICAgIFsndHhmJywgJ2FwcGxpY2F0aW9uL3ZuZC5tb2JpdXMudHhmJ10sXG4gICAgWyd0eHQnLCAndGV4dC9wbGFpbiddLFxuICAgIFsndWZkJywgJ2FwcGxpY2F0aW9uL3ZuZC51ZmRsJ10sXG4gICAgWyd1aWwnLCAndGV4dC94LXVpbCddLFxuICAgIFsndWxzJywgJ3RleHQvaXVscyddLFxuICAgIFsndW1qJywgJ2FwcGxpY2F0aW9uL3ZuZC51bWFqaW4nXSxcbiAgICBbJ3VuaScsICd0ZXh0L3VyaS1saXN0J10sXG4gICAgWyd1bmlzJywgJ3RleHQvdXJpLWxpc3QnXSxcbiAgICBbJ3VuaXR5d2ViJywgJ2FwcGxpY2F0aW9uL3ZuZC51bml0eSddLFxuICAgIFsndW52JywgJ2FwcGxpY2F0aW9uL2ktZGVhcyddLFxuICAgIFsndW9tbCcsICdhcHBsaWNhdGlvbi92bmQudW9tbCt4bWwnXSxcbiAgICBbJ3VyaScsICd0ZXh0L3VyaS1saXN0J10sXG4gICAgWyd1cmlzJywgJ3RleHQvdXJpLWxpc3QnXSxcbiAgICBbJ3VzdGFyJywgWydhcHBsaWNhdGlvbi94LXVzdGFyJywgJ211bHRpcGFydC94LXVzdGFyJ11dLFxuICAgIFsndXR6JywgJ2FwcGxpY2F0aW9uL3ZuZC51aXEudGhlbWUnXSxcbiAgICBbJ3V1JywgWydhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nLCAndGV4dC94LXV1ZW5jb2RlJ11dLFxuICAgIFsndXVlJywgJ3RleHQveC11dWVuY29kZSddLFxuICAgIFsndXZhJywgJ2F1ZGlvL3ZuZC5kZWNlLmF1ZGlvJ10sXG4gICAgWyd1dmgnLCAndmlkZW8vdm5kLmRlY2UuaGQnXSxcbiAgICBbJ3V2aScsICdpbWFnZS92bmQuZGVjZS5ncmFwaGljJ10sXG4gICAgWyd1dm0nLCAndmlkZW8vdm5kLmRlY2UubW9iaWxlJ10sXG4gICAgWyd1dnAnLCAndmlkZW8vdm5kLmRlY2UucGQnXSxcbiAgICBbJ3V2cycsICd2aWRlby92bmQuZGVjZS5zZCddLFxuICAgIFsndXZ1JywgJ3ZpZGVvL3ZuZC51dnZ1Lm1wNCddLFxuICAgIFsndXZ2JywgJ3ZpZGVvL3ZuZC5kZWNlLnZpZGVvJ10sXG4gICAgWyd2Y2QnLCAnYXBwbGljYXRpb24veC1jZGxpbmsnXSxcbiAgICBbJ3ZjZicsICd0ZXh0L3gtdmNhcmQnXSxcbiAgICBbJ3ZjZycsICdhcHBsaWNhdGlvbi92bmQuZ3Jvb3ZlLXZjYXJkJ10sXG4gICAgWyd2Y3MnLCAndGV4dC94LXZjYWxlbmRhciddLFxuICAgIFsndmN4JywgJ2FwcGxpY2F0aW9uL3ZuZC52Y3gnXSxcbiAgICBbJ3ZkYScsICdhcHBsaWNhdGlvbi92ZGEnXSxcbiAgICBbJ3ZkbycsICd2aWRlby92ZG8nXSxcbiAgICBbJ3ZldycsICdhcHBsaWNhdGlvbi9ncm91cHdpc2UnXSxcbiAgICBbJ3ZpcycsICdhcHBsaWNhdGlvbi92bmQudmlzaW9uYXJ5J10sXG4gICAgWyd2aXYnLCBbJ3ZpZGVvL3Zpdm8nLCAndmlkZW8vdm5kLnZpdm8nXV0sXG4gICAgWyd2aXZvJywgWyd2aWRlby92aXZvJywgJ3ZpZGVvL3ZuZC52aXZvJ11dLFxuICAgIFsndm1kJywgJ2FwcGxpY2F0aW9uL3ZvY2FsdGVjLW1lZGlhLWRlc2MnXSxcbiAgICBbJ3ZtZicsICdhcHBsaWNhdGlvbi92b2NhbHRlYy1tZWRpYS1maWxlJ10sXG4gICAgWyd2b2MnLCBbJ2F1ZGlvL3ZvYycsICdhdWRpby94LXZvYyddXSxcbiAgICBbJ3ZvcycsICd2aWRlby92b3NhaWMnXSxcbiAgICBbJ3ZveCcsICdhdWRpby92b3h3YXJlJ10sXG4gICAgWyd2cWUnLCAnYXVkaW8veC10d2ludnEtcGx1Z2luJ10sXG4gICAgWyd2cWYnLCAnYXVkaW8veC10d2ludnEnXSxcbiAgICBbJ3ZxbCcsICdhdWRpby94LXR3aW52cS1wbHVnaW4nXSxcbiAgICBbJ3ZybWwnLCBbJ21vZGVsL3ZybWwnLCAneC13b3JsZC94LXZybWwnLCAnYXBwbGljYXRpb24veC12cm1sJ11dLFxuICAgIFsndnJ0JywgJ3gtd29ybGQveC12cnQnXSxcbiAgICBbJ3ZzZCcsIFsnYXBwbGljYXRpb24vdm5kLnZpc2lvJywgJ2FwcGxpY2F0aW9uL3gtdmlzaW8nXV0sXG4gICAgWyd2c2YnLCAnYXBwbGljYXRpb24vdm5kLnZzZiddLFxuICAgIFsndnN0JywgJ2FwcGxpY2F0aW9uL3gtdmlzaW8nXSxcbiAgICBbJ3ZzdycsICdhcHBsaWNhdGlvbi94LXZpc2lvJ10sXG4gICAgWyd2dHUnLCAnbW9kZWwvdm5kLnZ0dSddLFxuICAgIFsndnhtbCcsICdhcHBsaWNhdGlvbi92b2ljZXhtbCt4bWwnXSxcbiAgICBbJ3c2MCcsICdhcHBsaWNhdGlvbi93b3JkcGVyZmVjdDYuMCddLFxuICAgIFsndzYxJywgJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0Ni4xJ10sXG4gICAgWyd3NncnLCAnYXBwbGljYXRpb24vbXN3b3JkJ10sXG4gICAgWyd3YWQnLCAnYXBwbGljYXRpb24veC1kb29tJ10sXG4gICAgWyd3YXYnLCBbJ2F1ZGlvL3dhdicsICdhdWRpby94LXdhdiddXSxcbiAgICBbJ3dheCcsICdhdWRpby94LW1zLXdheCddLFxuICAgIFsnd2IxJywgJ2FwcGxpY2F0aW9uL3gtcXBybyddLFxuICAgIFsnd2JtcCcsICdpbWFnZS92bmQud2FwLndibXAnXSxcbiAgICBbJ3dicycsICdhcHBsaWNhdGlvbi92bmQuY3JpdGljYWx0b29scy53YnMreG1sJ10sXG4gICAgWyd3YnhtbCcsICdhcHBsaWNhdGlvbi92bmQud2FwLndieG1sJ10sXG4gICAgWyd3Y20nLCAnYXBwbGljYXRpb24vdm5kLm1zLXdvcmtzJ10sXG4gICAgWyd3ZGInLCAnYXBwbGljYXRpb24vdm5kLm1zLXdvcmtzJ10sXG4gICAgWyd3ZWInLCAnYXBwbGljYXRpb24vdm5kLnhhcmEnXSxcbiAgICBbJ3dlYmEnLCAnYXVkaW8vd2VibSddLFxuICAgIFsnd2VibScsICd2aWRlby93ZWJtJ10sXG4gICAgWyd3ZWJwJywgJ2ltYWdlL3dlYnAnXSxcbiAgICBbJ3dnJywgJ2FwcGxpY2F0aW9uL3ZuZC5wbWkud2lkZ2V0J10sXG4gICAgWyd3Z3QnLCAnYXBwbGljYXRpb24vd2lkZ2V0J10sXG4gICAgWyd3aXonLCAnYXBwbGljYXRpb24vbXN3b3JkJ10sXG4gICAgWyd3azEnLCAnYXBwbGljYXRpb24veC0xMjMnXSxcbiAgICBbJ3drcycsICdhcHBsaWNhdGlvbi92bmQubXMtd29ya3MnXSxcbiAgICBbJ3dtJywgJ3ZpZGVvL3gtbXMtd20nXSxcbiAgICBbJ3dtYScsICdhdWRpby94LW1zLXdtYSddLFxuICAgIFsnd21kJywgJ2FwcGxpY2F0aW9uL3gtbXMtd21kJ10sXG4gICAgWyd3bWYnLCBbJ3dpbmRvd3MvbWV0YWZpbGUnLCAnYXBwbGljYXRpb24veC1tc21ldGFmaWxlJ11dLFxuICAgIFsnd21sJywgJ3RleHQvdm5kLndhcC53bWwnXSxcbiAgICBbJ3dtbGMnLCAnYXBwbGljYXRpb24vdm5kLndhcC53bWxjJ10sXG4gICAgWyd3bWxzJywgJ3RleHQvdm5kLndhcC53bWxzY3JpcHQnXSxcbiAgICBbJ3dtbHNjJywgJ2FwcGxpY2F0aW9uL3ZuZC53YXAud21sc2NyaXB0YyddLFxuICAgIFsnd212JywgJ3ZpZGVvL3gtbXMtd212J10sXG4gICAgWyd3bXgnLCAndmlkZW8veC1tcy13bXgnXSxcbiAgICBbJ3dteicsICdhcHBsaWNhdGlvbi94LW1zLXdteiddLFxuICAgIFsnd29mZicsICdhcHBsaWNhdGlvbi94LWZvbnQtd29mZiddLFxuICAgIFsnd29yZCcsICdhcHBsaWNhdGlvbi9tc3dvcmQnXSxcbiAgICBbJ3dwJywgJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0J10sXG4gICAgWyd3cDUnLCBbJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0JywgJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0Ni4wJ11dLFxuICAgIFsnd3A2JywgJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0J10sXG4gICAgWyd3cGQnLCBbJ2FwcGxpY2F0aW9uL3dvcmRwZXJmZWN0JywgJ2FwcGxpY2F0aW9uL3ZuZC53b3JkcGVyZmVjdCcsICdhcHBsaWNhdGlvbi94LXdwd2luJ11dLFxuICAgIFsnd3BsJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy13cGwnXSxcbiAgICBbJ3dwcycsICdhcHBsaWNhdGlvbi92bmQubXMtd29ya3MnXSxcbiAgICBbJ3dxMScsICdhcHBsaWNhdGlvbi94LWxvdHVzJ10sXG4gICAgWyd3cWQnLCAnYXBwbGljYXRpb24vdm5kLndxZCddLFxuICAgIFsnd3JpJywgWydhcHBsaWNhdGlvbi9tc3dyaXRlJywgJ2FwcGxpY2F0aW9uL3gtd3JpJywgJ2FwcGxpY2F0aW9uL3gtbXN3cml0ZSddXSxcbiAgICBbJ3dybCcsIFsnbW9kZWwvdnJtbCcsICd4LXdvcmxkL3gtdnJtbCcsICdhcHBsaWNhdGlvbi94LXdvcmxkJ11dLFxuICAgIFsnd3J6JywgWydtb2RlbC92cm1sJywgJ3gtd29ybGQveC12cm1sJ11dLFxuICAgIFsnd3NjJywgJ3RleHQvc2NyaXBsZXQnXSxcbiAgICBbJ3dzZGwnLCAnYXBwbGljYXRpb24vd3NkbCt4bWwnXSxcbiAgICBbJ3dzcG9saWN5JywgJ2FwcGxpY2F0aW9uL3dzcG9saWN5K3htbCddLFxuICAgIFsnd3NyYycsICdhcHBsaWNhdGlvbi94LXdhaXMtc291cmNlJ10sXG4gICAgWyd3dGInLCAnYXBwbGljYXRpb24vdm5kLndlYnR1cmJvJ10sXG4gICAgWyd3dGsnLCAnYXBwbGljYXRpb24veC13aW50YWxrJ10sXG4gICAgWyd3dngnLCAndmlkZW8veC1tcy13dngnXSxcbiAgICBbJ3gtcG5nJywgJ2ltYWdlL3BuZyddLFxuICAgIFsneDNkJywgJ2FwcGxpY2F0aW9uL3ZuZC5oem4tM2QtY3Jvc3N3b3JkJ10sXG4gICAgWyd4YWYnLCAneC13b3JsZC94LXZybWwnXSxcbiAgICBbJ3hhcCcsICdhcHBsaWNhdGlvbi94LXNpbHZlcmxpZ2h0LWFwcCddLFxuICAgIFsneGFyJywgJ2FwcGxpY2F0aW9uL3ZuZC54YXJhJ10sXG4gICAgWyd4YmFwJywgJ2FwcGxpY2F0aW9uL3gtbXMteGJhcCddLFxuICAgIFsneGJkJywgJ2FwcGxpY2F0aW9uL3ZuZC5mdWppeGVyb3guZG9jdXdvcmtzLmJpbmRlciddLFxuICAgIFsneGJtJywgWydpbWFnZS94Ym0nLCAnaW1hZ2UveC14Ym0nLCAnaW1hZ2UveC14Yml0bWFwJ11dLFxuICAgIFsneGRmJywgJ2FwcGxpY2F0aW9uL3hjYXAtZGlmZit4bWwnXSxcbiAgICBbJ3hkbScsICdhcHBsaWNhdGlvbi92bmQuc3luY21sLmRtK3htbCddLFxuICAgIFsneGRwJywgJ2FwcGxpY2F0aW9uL3ZuZC5hZG9iZS54ZHAreG1sJ10sXG4gICAgWyd4ZHInLCAndmlkZW8veC1hbXQtZGVtb3J1biddLFxuICAgIFsneGRzc2MnLCAnYXBwbGljYXRpb24vZHNzYyt4bWwnXSxcbiAgICBbJ3hkdycsICdhcHBsaWNhdGlvbi92bmQuZnVqaXhlcm94LmRvY3V3b3JrcyddLFxuICAgIFsneGVuYycsICdhcHBsaWNhdGlvbi94ZW5jK3htbCddLFxuICAgIFsneGVyJywgJ2FwcGxpY2F0aW9uL3BhdGNoLW9wcy1lcnJvcit4bWwnXSxcbiAgICBbJ3hmZGYnLCAnYXBwbGljYXRpb24vdm5kLmFkb2JlLnhmZGYnXSxcbiAgICBbJ3hmZGwnLCAnYXBwbGljYXRpb24vdm5kLnhmZGwnXSxcbiAgICBbJ3hneicsICd4Z2wvZHJhd2luZyddLFxuICAgIFsneGh0bWwnLCAnYXBwbGljYXRpb24veGh0bWwreG1sJ10sXG4gICAgWyd4aWYnLCAnaW1hZ2Uvdm5kLnhpZmYnXSxcbiAgICBbJ3hsJywgJ2FwcGxpY2F0aW9uL2V4Y2VsJ10sXG4gICAgWyd4bGEnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsICdhcHBsaWNhdGlvbi9leGNlbCcsICdhcHBsaWNhdGlvbi94LW1zZXhjZWwnLCAnYXBwbGljYXRpb24veC1leGNlbCddXSxcbiAgICBbJ3hsYW0nLCAnYXBwbGljYXRpb24vdm5kLm1zLWV4Y2VsLmFkZGluLm1hY3JvZW5hYmxlZC4xMiddLFxuICAgIFsneGxiJywgWydhcHBsaWNhdGlvbi9leGNlbCcsICdhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwnLCAnYXBwbGljYXRpb24veC1leGNlbCddXSxcbiAgICBbJ3hsYycsIFsnYXBwbGljYXRpb24vdm5kLm1zLWV4Y2VsJywgJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3gtZXhjZWwnXV0sXG4gICAgWyd4bGQnLCBbJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3gtZXhjZWwnXV0sXG4gICAgWyd4bGsnLCBbJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3gtZXhjZWwnXV0sXG4gICAgWyd4bGwnLCBbJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsICdhcHBsaWNhdGlvbi94LWV4Y2VsJ11dLFxuICAgIFsneGxtJywgWydhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwnLCAnYXBwbGljYXRpb24vZXhjZWwnLCAnYXBwbGljYXRpb24veC1leGNlbCddXSxcbiAgICBbJ3hscycsIFsnYXBwbGljYXRpb24vdm5kLm1zLWV4Y2VsJywgJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3gtbXNleGNlbCcsICdhcHBsaWNhdGlvbi94LWV4Y2VsJ11dLFxuICAgIFsneGxzYicsICdhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwuc2hlZXQuYmluYXJ5Lm1hY3JvZW5hYmxlZC4xMiddLFxuICAgIFsneGxzbScsICdhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwuc2hlZXQubWFjcm9lbmFibGVkLjEyJ10sXG4gICAgWyd4bHN4JywgJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnNoZWV0J10sXG4gICAgWyd4bHQnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsICdhcHBsaWNhdGlvbi9leGNlbCcsICdhcHBsaWNhdGlvbi94LWV4Y2VsJ11dLFxuICAgIFsneGx0bScsICdhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwudGVtcGxhdGUubWFjcm9lbmFibGVkLjEyJ10sXG4gICAgWyd4bHR4JywgJ2FwcGxpY2F0aW9uL3ZuZC5vcGVueG1sZm9ybWF0cy1vZmZpY2Vkb2N1bWVudC5zcHJlYWRzaGVldG1sLnRlbXBsYXRlJ10sXG4gICAgWyd4bHYnLCBbJ2FwcGxpY2F0aW9uL2V4Y2VsJywgJ2FwcGxpY2F0aW9uL3gtZXhjZWwnXV0sXG4gICAgWyd4bHcnLCBbJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsICdhcHBsaWNhdGlvbi9leGNlbCcsICdhcHBsaWNhdGlvbi94LW1zZXhjZWwnLCAnYXBwbGljYXRpb24veC1leGNlbCddXSxcbiAgICBbJ3htJywgJ2F1ZGlvL3htJ10sXG4gICAgWyd4bWwnLCBbJ2FwcGxpY2F0aW9uL3htbCcsICd0ZXh0L3htbCcsICdhcHBsaWNhdGlvbi9hdG9tK3htbCcsICdhcHBsaWNhdGlvbi9yc3MreG1sJ11dLFxuICAgIFsneG16JywgJ3hnbC9tb3ZpZSddLFxuICAgIFsneG8nLCAnYXBwbGljYXRpb24vdm5kLm9scGMtc3VnYXInXSxcbiAgICBbJ3hvZicsICd4LXdvcmxkL3gtdnJtbCddLFxuICAgIFsneG9wJywgJ2FwcGxpY2F0aW9uL3hvcCt4bWwnXSxcbiAgICBbJ3hwaScsICdhcHBsaWNhdGlvbi94LXhwaW5zdGFsbCddLFxuICAgIFsneHBpeCcsICdhcHBsaWNhdGlvbi94LXZuZC5scy14cGl4J10sXG4gICAgWyd4cG0nLCBbJ2ltYWdlL3hwbScsICdpbWFnZS94LXhwaXhtYXAnXV0sXG4gICAgWyd4cHInLCAnYXBwbGljYXRpb24vdm5kLmlzLXhwciddLFxuICAgIFsneHBzJywgJ2FwcGxpY2F0aW9uL3ZuZC5tcy14cHNkb2N1bWVudCddLFxuICAgIFsneHB3JywgJ2FwcGxpY2F0aW9uL3ZuZC5pbnRlcmNvbi5mb3JtbmV0J10sXG4gICAgWyd4c2x0JywgJ2FwcGxpY2F0aW9uL3hzbHQreG1sJ10sXG4gICAgWyd4c20nLCAnYXBwbGljYXRpb24vdm5kLnN5bmNtbCt4bWwnXSxcbiAgICBbJ3hzcGYnLCAnYXBwbGljYXRpb24veHNwZit4bWwnXSxcbiAgICBbJ3hzcicsICd2aWRlby94LWFtdC1zaG93cnVuJ10sXG4gICAgWyd4dWwnLCAnYXBwbGljYXRpb24vdm5kLm1vemlsbGEueHVsK3htbCddLFxuICAgIFsneHdkJywgWydpbWFnZS94LXh3ZCcsICdpbWFnZS94LXh3aW5kb3dkdW1wJ11dLFxuICAgIFsneHl6JywgWydjaGVtaWNhbC94LXh5eicsICdjaGVtaWNhbC94LXBkYiddXSxcbiAgICBbJ3lhbmcnLCAnYXBwbGljYXRpb24veWFuZyddLFxuICAgIFsneWluJywgJ2FwcGxpY2F0aW9uL3lpbit4bWwnXSxcbiAgICBbJ3onLCBbJ2FwcGxpY2F0aW9uL3gtY29tcHJlc3NlZCcsICdhcHBsaWNhdGlvbi94LWNvbXByZXNzJ11dLFxuICAgIFsnemF6JywgJ2FwcGxpY2F0aW9uL3ZuZC56emF6ei5kZWNrK3htbCddLFxuICAgIFsnemlwJywgWydhcHBsaWNhdGlvbi96aXAnLCAnbXVsdGlwYXJ0L3gtemlwJywgJ2FwcGxpY2F0aW9uL3gtemlwLWNvbXByZXNzZWQnLCAnYXBwbGljYXRpb24veC1jb21wcmVzc2VkJ11dLFxuICAgIFsnemlyJywgJ2FwcGxpY2F0aW9uL3ZuZC56dWwnXSxcbiAgICBbJ3ptbScsICdhcHBsaWNhdGlvbi92bmQuaGFuZGhlbGQtZW50ZXJ0YWlubWVudCt4bWwnXSxcbiAgICBbJ3pvbycsICdhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nXSxcbiAgICBbJ3pzaCcsICd0ZXh0L3gtc2NyaXB0LnpzaCddXG5dKTtcblxubW9kdWxlLmV4cG9ydHMgPSB7XG4gICAgZGV0ZWN0TWltZVR5cGUoZmlsZW5hbWUpIHtcbiAgICAgICAgaWYgKCFmaWxlbmFtZSkge1xuICAgICAgICAgICAgcmV0dXJuIGRlZmF1bHRNaW1lVHlwZTtcbiAgICAgICAgfVxuXG4gICAgICAgIGxldCBwYXJzZWQgPSBwYXRoLnBhcnNlKGZpbGVuYW1lKTtcbiAgICAgICAgbGV0IGV4dGVuc2lvbiA9IChwYXJzZWQuZXh0LnN1YnN0cigxKSB8fCBwYXJzZWQubmFtZSB8fCAnJykuc3BsaXQoJz8nKS5zaGlmdCgpLnRyaW0oKS50b0xvd2VyQ2FzZSgpO1xuICAgICAgICBsZXQgdmFsdWUgPSBkZWZhdWx0TWltZVR5cGU7XG5cbiAgICAgICAgaWYgKGV4dGVuc2lvbnMuaGFzKGV4dGVuc2lvbikpIHtcbiAgICAgICAgICAgIHZhbHVlID0gZXh0ZW5zaW9ucy5nZXQoZXh0ZW5zaW9uKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmIChBcnJheS5pc0FycmF5KHZhbHVlKSkge1xuICAgICAgICAgICAgcmV0dXJuIHZhbHVlWzBdO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiB2YWx1ZTtcbiAgICB9LFxuXG4gICAgZGV0ZWN0RXh0ZW5zaW9uKG1pbWVUeXBlKSB7XG4gICAgICAgIGlmICghbWltZVR5cGUpIHtcbiAgICAgICAgICAgIHJldHVybiBkZWZhdWx0RXh0ZW5zaW9uO1xuICAgICAgICB9XG4gICAgICAgIGxldCBwYXJ0cyA9IChtaW1lVHlwZSB8fCAnJykudG9Mb3dlckNhc2UoKS50cmltKCkuc3BsaXQoJy8nKTtcbiAgICAgICAgbGV0IHJvb3RUeXBlID0gcGFydHMuc2hpZnQoKS50cmltKCk7XG4gICAgICAgIGxldCBzdWJUeXBlID0gcGFydHMuam9pbignLycpLnRyaW0oKTtcblxuICAgICAgICBpZiAobWltZVR5cGVzLmhhcyhyb290VHlwZSArICcvJyArIHN1YlR5cGUpKSB7XG4gICAgICAgICAgICBsZXQgdmFsdWUgPSBtaW1lVHlwZXMuZ2V0KHJvb3RUeXBlICsgJy8nICsgc3ViVHlwZSk7XG4gICAgICAgICAgICBpZiAoQXJyYXkuaXNBcnJheSh2YWx1ZSkpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdmFsdWVbMF07XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gdmFsdWU7XG4gICAgICAgIH1cblxuICAgICAgICBzd2l0Y2ggKHJvb3RUeXBlKSB7XG4gICAgICAgICAgICBjYXNlICd0ZXh0JzpcbiAgICAgICAgICAgICAgICByZXR1cm4gJ3R4dCc7XG4gICAgICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgICAgIHJldHVybiAnYmluJztcbiAgICAgICAgfVxuICAgIH1cbn07XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-funcs/mime-types.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-node/index.js":
/*!********************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-node/index.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("/* eslint no-undefined: 0, prefer-spread: 0, no-control-regex: 0 */\n\n\n\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst fs = __webpack_require__(/*! fs */ \"fs\");\nconst punycode = __webpack_require__(/*! ../punycode */ \"(ssr)/./node_modules/nodemailer/lib/punycode/index.js\");\nconst PassThrough = (__webpack_require__(/*! stream */ \"stream\").PassThrough);\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\n\nconst mimeFuncs = __webpack_require__(/*! ../mime-funcs */ \"(ssr)/./node_modules/nodemailer/lib/mime-funcs/index.js\");\nconst qp = __webpack_require__(/*! ../qp */ \"(ssr)/./node_modules/nodemailer/lib/qp/index.js\");\nconst base64 = __webpack_require__(/*! ../base64 */ \"(ssr)/./node_modules/nodemailer/lib/base64/index.js\");\nconst addressparser = __webpack_require__(/*! ../addressparser */ \"(ssr)/./node_modules/nodemailer/lib/addressparser/index.js\");\nconst nmfetch = __webpack_require__(/*! ../fetch */ \"(ssr)/./node_modules/nodemailer/lib/fetch/index.js\");\nconst LastNewline = __webpack_require__(/*! ./last-newline */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/last-newline.js\");\n\nconst LeWindows = __webpack_require__(/*! ./le-windows */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/le-windows.js\");\nconst LeUnix = __webpack_require__(/*! ./le-unix */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/le-unix.js\");\n\n/**\n * Creates a new mime tree node. Assumes 'multipart/*' as the content type\n * if it is a branch, anything else counts as leaf. If rootNode is missing from\n * the options, assumes this is the root.\n *\n * @param {String} contentType Define the content type for the node. Can be left blank for attachments (derived from filename)\n * @param {Object} [options] optional options\n * @param {Object} [options.rootNode] root node for this tree\n * @param {Object} [options.parentNode] immediate parent for this node\n * @param {Object} [options.filename] filename for an attachment node\n * @param {String} [options.baseBoundary] shared part of the unique multipart boundary\n * @param {Boolean} [options.keepBcc] If true, do not exclude Bcc from the generated headers\n * @param {Function} [options.normalizeHeaderKey] method to normalize header keys for custom caseing\n * @param {String} [options.textEncoding] either 'Q' (the default) or 'B'\n */\nclass MimeNode {\n    constructor(contentType, options) {\n        this.nodeCounter = 0;\n\n        options = options || {};\n\n        /**\n         * shared part of the unique multipart boundary\n         */\n        this.baseBoundary = options.baseBoundary || crypto.randomBytes(8).toString('hex');\n        this.boundaryPrefix = options.boundaryPrefix || '--_NmP';\n\n        this.disableFileAccess = !!options.disableFileAccess;\n        this.disableUrlAccess = !!options.disableUrlAccess;\n\n        this.normalizeHeaderKey = options.normalizeHeaderKey;\n\n        /**\n         * If date headers is missing and current node is the root, this value is used instead\n         */\n        this.date = new Date();\n\n        /**\n         * Root node for current mime tree\n         */\n        this.rootNode = options.rootNode || this;\n\n        /**\n         * If true include Bcc in generated headers (if available)\n         */\n        this.keepBcc = !!options.keepBcc;\n\n        /**\n         * If filename is specified but contentType is not (probably an attachment)\n         * detect the content type from filename extension\n         */\n        if (options.filename) {\n            /**\n             * Filename for this node. Useful with attachments\n             */\n            this.filename = options.filename;\n            if (!contentType) {\n                contentType = mimeFuncs.detectMimeType(this.filename.split('.').pop());\n            }\n        }\n\n        /**\n         * Indicates which encoding should be used for header strings: \"Q\" or \"B\"\n         */\n        this.textEncoding = (options.textEncoding || '').toString().trim().charAt(0).toUpperCase();\n\n        /**\n         * Immediate parent for this node (or undefined if not set)\n         */\n        this.parentNode = options.parentNode;\n\n        /**\n         * Hostname for default message-id values\n         */\n        this.hostname = options.hostname;\n\n        /**\n         * If set to 'win' then uses \\r\\n, if 'linux' then \\n. If not set (or `raw` is used) then newlines are kept as is.\n         */\n        this.newline = options.newline;\n\n        /**\n         * An array for possible child nodes\n         */\n        this.childNodes = [];\n\n        /**\n         * Used for generating unique boundaries (prepended to the shared base)\n         */\n        this._nodeId = ++this.rootNode.nodeCounter;\n\n        /**\n         * A list of header values for this node in the form of [{key:'', value:''}]\n         */\n        this._headers = [];\n\n        /**\n         * True if the content only uses ASCII printable characters\n         * @type {Boolean}\n         */\n        this._isPlainText = false;\n\n        /**\n         * True if the content is plain text but has longer lines than allowed\n         * @type {Boolean}\n         */\n        this._hasLongLines = false;\n\n        /**\n         * If set, use instead this value for envelopes instead of generating one\n         * @type {Boolean}\n         */\n        this._envelope = false;\n\n        /**\n         * If set then use this value as the stream content instead of building it\n         * @type {String|Buffer|Stream}\n         */\n        this._raw = false;\n\n        /**\n         * Additional transform streams that the message will be piped before\n         * exposing by createReadStream\n         * @type {Array}\n         */\n        this._transforms = [];\n\n        /**\n         * Additional process functions that the message will be piped through before\n         * exposing by createReadStream. These functions are run after transforms\n         * @type {Array}\n         */\n        this._processFuncs = [];\n\n        /**\n         * If content type is set (or derived from the filename) add it to headers\n         */\n        if (contentType) {\n            this.setHeader('Content-Type', contentType);\n        }\n    }\n\n    /////// PUBLIC METHODS\n\n    /**\n     * Creates and appends a child node.Arguments provided are passed to MimeNode constructor\n     *\n     * @param {String} [contentType] Optional content type\n     * @param {Object} [options] Optional options object\n     * @return {Object} Created node object\n     */\n    createChild(contentType, options) {\n        if (!options && typeof contentType === 'object') {\n            options = contentType;\n            contentType = undefined;\n        }\n        let node = new MimeNode(contentType, options);\n        this.appendChild(node);\n        return node;\n    }\n\n    /**\n     * Appends an existing node to the mime tree. Removes the node from an existing\n     * tree if needed\n     *\n     * @param {Object} childNode node to be appended\n     * @return {Object} Appended node object\n     */\n    appendChild(childNode) {\n        if (childNode.rootNode !== this.rootNode) {\n            childNode.rootNode = this.rootNode;\n            childNode._nodeId = ++this.rootNode.nodeCounter;\n        }\n\n        childNode.parentNode = this;\n\n        this.childNodes.push(childNode);\n        return childNode;\n    }\n\n    /**\n     * Replaces current node with another node\n     *\n     * @param {Object} node Replacement node\n     * @return {Object} Replacement node\n     */\n    replace(node) {\n        if (node === this) {\n            return this;\n        }\n\n        this.parentNode.childNodes.forEach((childNode, i) => {\n            if (childNode === this) {\n                node.rootNode = this.rootNode;\n                node.parentNode = this.parentNode;\n                node._nodeId = this._nodeId;\n\n                this.rootNode = this;\n                this.parentNode = undefined;\n\n                node.parentNode.childNodes[i] = node;\n            }\n        });\n\n        return node;\n    }\n\n    /**\n     * Removes current node from the mime tree\n     *\n     * @return {Object} removed node\n     */\n    remove() {\n        if (!this.parentNode) {\n            return this;\n        }\n\n        for (let i = this.parentNode.childNodes.length - 1; i >= 0; i--) {\n            if (this.parentNode.childNodes[i] === this) {\n                this.parentNode.childNodes.splice(i, 1);\n                this.parentNode = undefined;\n                this.rootNode = this;\n                return this;\n            }\n        }\n    }\n\n    /**\n     * Sets a header value. If the value for selected key exists, it is overwritten.\n     * You can set multiple values as well by using [{key:'', value:''}] or\n     * {key: 'value'} as the first argument.\n     *\n     * @param {String|Array|Object} key Header key or a list of key value pairs\n     * @param {String} value Header value\n     * @return {Object} current node\n     */\n    setHeader(key, value) {\n        let added = false,\n            headerValue;\n\n        // Allow setting multiple headers at once\n        if (!value && key && typeof key === 'object') {\n            // allow {key:'content-type', value: 'text/plain'}\n            if (key.key && 'value' in key) {\n                this.setHeader(key.key, key.value);\n            } else if (Array.isArray(key)) {\n                // allow [{key:'content-type', value: 'text/plain'}]\n                key.forEach(i => {\n                    this.setHeader(i.key, i.value);\n                });\n            } else {\n                // allow {'content-type': 'text/plain'}\n                Object.keys(key).forEach(i => {\n                    this.setHeader(i, key[i]);\n                });\n            }\n            return this;\n        }\n\n        key = this._normalizeHeaderKey(key);\n\n        headerValue = {\n            key,\n            value\n        };\n\n        // Check if the value exists and overwrite\n        for (let i = 0, len = this._headers.length; i < len; i++) {\n            if (this._headers[i].key === key) {\n                if (!added) {\n                    // replace the first match\n                    this._headers[i] = headerValue;\n                    added = true;\n                } else {\n                    // remove following matches\n                    this._headers.splice(i, 1);\n                    i--;\n                    len--;\n                }\n            }\n        }\n\n        // match not found, append the value\n        if (!added) {\n            this._headers.push(headerValue);\n        }\n\n        return this;\n    }\n\n    /**\n     * Adds a header value. If the value for selected key exists, the value is appended\n     * as a new field and old one is not touched.\n     * You can set multiple values as well by using [{key:'', value:''}] or\n     * {key: 'value'} as the first argument.\n     *\n     * @param {String|Array|Object} key Header key or a list of key value pairs\n     * @param {String} value Header value\n     * @return {Object} current node\n     */\n    addHeader(key, value) {\n        // Allow setting multiple headers at once\n        if (!value && key && typeof key === 'object') {\n            // allow {key:'content-type', value: 'text/plain'}\n            if (key.key && key.value) {\n                this.addHeader(key.key, key.value);\n            } else if (Array.isArray(key)) {\n                // allow [{key:'content-type', value: 'text/plain'}]\n                key.forEach(i => {\n                    this.addHeader(i.key, i.value);\n                });\n            } else {\n                // allow {'content-type': 'text/plain'}\n                Object.keys(key).forEach(i => {\n                    this.addHeader(i, key[i]);\n                });\n            }\n            return this;\n        } else if (Array.isArray(value)) {\n            value.forEach(val => {\n                this.addHeader(key, val);\n            });\n            return this;\n        }\n\n        this._headers.push({\n            key: this._normalizeHeaderKey(key),\n            value\n        });\n\n        return this;\n    }\n\n    /**\n     * Retrieves the first mathcing value of a selected key\n     *\n     * @param {String} key Key to search for\n     * @retun {String} Value for the key\n     */\n    getHeader(key) {\n        key = this._normalizeHeaderKey(key);\n        for (let i = 0, len = this._headers.length; i < len; i++) {\n            if (this._headers[i].key === key) {\n                return this._headers[i].value;\n            }\n        }\n    }\n\n    /**\n     * Sets body content for current node. If the value is a string, charset is added automatically\n     * to Content-Type (if it is text/*). If the value is a Buffer, you need to specify\n     * the charset yourself\n     *\n     * @param (String|Buffer) content Body content\n     * @return {Object} current node\n     */\n    setContent(content) {\n        this.content = content;\n        if (typeof this.content.pipe === 'function') {\n            // pre-stream handler. might be triggered if a stream is set as content\n            // and 'error' fires before anything is done with this stream\n            this._contentErrorHandler = err => {\n                this.content.removeListener('error', this._contentErrorHandler);\n                this.content = err;\n            };\n            this.content.once('error', this._contentErrorHandler);\n        } else if (typeof this.content === 'string') {\n            this._isPlainText = mimeFuncs.isPlainText(this.content);\n            if (this._isPlainText && mimeFuncs.hasLongerLines(this.content, 76)) {\n                // If there are lines longer than 76 symbols/bytes do not use 7bit\n                this._hasLongLines = true;\n            }\n        }\n        return this;\n    }\n\n    build(callback) {\n        let promise;\n\n        if (!callback) {\n            promise = new Promise((resolve, reject) => {\n                callback = shared.callbackPromise(resolve, reject);\n            });\n        }\n\n        let stream = this.createReadStream();\n        let buf = [];\n        let buflen = 0;\n        let returned = false;\n\n        stream.on('readable', () => {\n            let chunk;\n\n            while ((chunk = stream.read()) !== null) {\n                buf.push(chunk);\n                buflen += chunk.length;\n            }\n        });\n\n        stream.once('error', err => {\n            if (returned) {\n                return;\n            }\n            returned = true;\n\n            return callback(err);\n        });\n\n        stream.once('end', chunk => {\n            if (returned) {\n                return;\n            }\n            returned = true;\n\n            if (chunk && chunk.length) {\n                buf.push(chunk);\n                buflen += chunk.length;\n            }\n            return callback(null, Buffer.concat(buf, buflen));\n        });\n\n        return promise;\n    }\n\n    getTransferEncoding() {\n        let transferEncoding = false;\n        let contentType = (this.getHeader('Content-Type') || '').toString().toLowerCase().trim();\n\n        if (this.content) {\n            transferEncoding = (this.getHeader('Content-Transfer-Encoding') || '').toString().toLowerCase().trim();\n            if (!transferEncoding || !['base64', 'quoted-printable'].includes(transferEncoding)) {\n                if (/^text\\//i.test(contentType)) {\n                    // If there are no special symbols, no need to modify the text\n                    if (this._isPlainText && !this._hasLongLines) {\n                        transferEncoding = '7bit';\n                    } else if (typeof this.content === 'string' || this.content instanceof Buffer) {\n                        // detect preferred encoding for string value\n                        transferEncoding = this._getTextEncoding(this.content) === 'Q' ? 'quoted-printable' : 'base64';\n                    } else {\n                        // we can not check content for a stream, so either use preferred encoding or fallback to QP\n                        transferEncoding = this.textEncoding === 'B' ? 'base64' : 'quoted-printable';\n                    }\n                } else if (!/^(multipart|message)\\//i.test(contentType)) {\n                    transferEncoding = transferEncoding || 'base64';\n                }\n            }\n        }\n        return transferEncoding;\n    }\n\n    /**\n     * Builds the header block for the mime node. Append \\r\\n\\r\\n before writing the content\n     *\n     * @returns {String} Headers\n     */\n    buildHeaders() {\n        let transferEncoding = this.getTransferEncoding();\n        let headers = [];\n\n        if (transferEncoding) {\n            this.setHeader('Content-Transfer-Encoding', transferEncoding);\n        }\n\n        if (this.filename && !this.getHeader('Content-Disposition')) {\n            this.setHeader('Content-Disposition', 'attachment');\n        }\n\n        // Ensure mandatory header fields\n        if (this.rootNode === this) {\n            if (!this.getHeader('Date')) {\n                this.setHeader('Date', this.date.toUTCString().replace(/GMT/, '+0000'));\n            }\n\n            // ensure that Message-Id is present\n            this.messageId();\n\n            if (!this.getHeader('MIME-Version')) {\n                this.setHeader('MIME-Version', '1.0');\n            }\n\n            // Ensure that Content-Type is the last header for the root node\n            for (let i = this._headers.length - 2; i >= 0; i--) {\n                let header = this._headers[i];\n                if (header.key === 'Content-Type') {\n                    this._headers.splice(i, 1);\n                    this._headers.push(header);\n                }\n            }\n        }\n\n        this._headers.forEach(header => {\n            let key = header.key;\n            let value = header.value;\n            let structured;\n            let param;\n            let options = {};\n            let formattedHeaders = ['From', 'Sender', 'To', 'Cc', 'Bcc', 'Reply-To', 'Date', 'References'];\n\n            if (value && typeof value === 'object' && !formattedHeaders.includes(key)) {\n                Object.keys(value).forEach(key => {\n                    if (key !== 'value') {\n                        options[key] = value[key];\n                    }\n                });\n                value = (value.value || '').toString();\n                if (!value.trim()) {\n                    return;\n                }\n            }\n\n            if (options.prepared) {\n                // header value is\n                if (options.foldLines) {\n                    headers.push(mimeFuncs.foldLines(key + ': ' + value));\n                } else {\n                    headers.push(key + ': ' + value);\n                }\n                return;\n            }\n\n            switch (header.key) {\n                case 'Content-Disposition':\n                    structured = mimeFuncs.parseHeaderValue(value);\n                    if (this.filename) {\n                        structured.params.filename = this.filename;\n                    }\n                    value = mimeFuncs.buildHeaderValue(structured);\n                    break;\n\n                case 'Content-Type':\n                    structured = mimeFuncs.parseHeaderValue(value);\n\n                    this._handleContentType(structured);\n\n                    if (\n                        structured.value.match(/^text\\/plain\\b/) &&\n                        typeof this.content === 'string' &&\n                        /[\\u0080-\\uFFFF]/.test(this.content)\n                    ) {\n                        structured.params.charset = 'utf-8';\n                    }\n\n                    value = mimeFuncs.buildHeaderValue(structured);\n\n                    if (this.filename) {\n                        // add support for non-compliant clients like QQ webmail\n                        // we can't build the value with buildHeaderValue as the value is non standard and\n                        // would be converted to parameter continuation encoding that we do not want\n                        param = this._encodeWords(this.filename);\n\n                        if (param !== this.filename || /[\\s'\"\\\\;:/=(),<>@[\\]?]|^-/.test(param)) {\n                            // include value in quotes if needed\n                            param = '\"' + param + '\"';\n                        }\n                        value += '; name=' + param;\n                    }\n                    break;\n\n                case 'Bcc':\n                    if (!this.keepBcc) {\n                        // skip BCC values\n                        return;\n                    }\n                    break;\n            }\n\n            value = this._encodeHeaderValue(key, value);\n\n            // skip empty lines\n            if (!(value || '').toString().trim()) {\n                return;\n            }\n\n            if (typeof this.normalizeHeaderKey === 'function') {\n                let normalized = this.normalizeHeaderKey(key, value);\n                if (normalized && typeof normalized === 'string' && normalized.length) {\n                    key = normalized;\n                }\n            }\n\n            headers.push(mimeFuncs.foldLines(key + ': ' + value, 76));\n        });\n\n        return headers.join('\\r\\n');\n    }\n\n    /**\n     * Streams the rfc2822 message from the current node. If this is a root node,\n     * mandatory header fields are set if missing (Date, Message-Id, MIME-Version)\n     *\n     * @return {String} Compiled message\n     */\n    createReadStream(options) {\n        options = options || {};\n\n        let stream = new PassThrough(options);\n        let outputStream = stream;\n        let transform;\n\n        this.stream(stream, options, err => {\n            if (err) {\n                outputStream.emit('error', err);\n                return;\n            }\n            stream.end();\n        });\n\n        for (let i = 0, len = this._transforms.length; i < len; i++) {\n            transform = typeof this._transforms[i] === 'function' ? this._transforms[i]() : this._transforms[i];\n            outputStream.once('error', err => {\n                transform.emit('error', err);\n            });\n            outputStream = outputStream.pipe(transform);\n        }\n\n        // ensure terminating newline after possible user transforms\n        transform = new LastNewline();\n        outputStream.once('error', err => {\n            transform.emit('error', err);\n        });\n        outputStream = outputStream.pipe(transform);\n\n        // dkim and stuff\n        for (let i = 0, len = this._processFuncs.length; i < len; i++) {\n            transform = this._processFuncs[i];\n            outputStream = transform(outputStream);\n        }\n\n        if (this.newline) {\n            const winbreak = ['win', 'windows', 'dos', '\\r\\n'].includes(this.newline.toString().toLowerCase());\n            const newlineTransform = winbreak ? new LeWindows() : new LeUnix();\n\n            const stream = outputStream.pipe(newlineTransform);\n            outputStream.on('error', err => stream.emit('error', err));\n            return stream;\n        }\n\n        return outputStream;\n    }\n\n    /**\n     * Appends a transform stream object to the transforms list. Final output\n     * is passed through this stream before exposing\n     *\n     * @param {Object} transform Read-Write stream\n     */\n    transform(transform) {\n        this._transforms.push(transform);\n    }\n\n    /**\n     * Appends a post process function. The functon is run after transforms and\n     * uses the following syntax\n     *\n     *   processFunc(input) -> outputStream\n     *\n     * @param {Object} processFunc Read-Write stream\n     */\n    processFunc(processFunc) {\n        this._processFuncs.push(processFunc);\n    }\n\n    stream(outputStream, options, done) {\n        let transferEncoding = this.getTransferEncoding();\n        let contentStream;\n        let localStream;\n\n        // protect actual callback against multiple triggering\n        let returned = false;\n        let callback = err => {\n            if (returned) {\n                return;\n            }\n            returned = true;\n            done(err);\n        };\n\n        // for multipart nodes, push child nodes\n        // for content nodes end the stream\n        let finalize = () => {\n            let childId = 0;\n            let processChildNode = () => {\n                if (childId >= this.childNodes.length) {\n                    outputStream.write('\\r\\n--' + this.boundary + '--\\r\\n');\n                    return callback();\n                }\n                let child = this.childNodes[childId++];\n                outputStream.write((childId > 1 ? '\\r\\n' : '') + '--' + this.boundary + '\\r\\n');\n                child.stream(outputStream, options, err => {\n                    if (err) {\n                        return callback(err);\n                    }\n                    setImmediate(processChildNode);\n                });\n            };\n\n            if (this.multipart) {\n                setImmediate(processChildNode);\n            } else {\n                return callback();\n            }\n        };\n\n        // pushes node content\n        let sendContent = () => {\n            if (this.content) {\n                if (Object.prototype.toString.call(this.content) === '[object Error]') {\n                    // content is already errored\n                    return callback(this.content);\n                }\n\n                if (typeof this.content.pipe === 'function') {\n                    this.content.removeListener('error', this._contentErrorHandler);\n                    this._contentErrorHandler = err => callback(err);\n                    this.content.once('error', this._contentErrorHandler);\n                }\n\n                let createStream = () => {\n                    if (['quoted-printable', 'base64'].includes(transferEncoding)) {\n                        contentStream = new (transferEncoding === 'base64' ? base64 : qp).Encoder(options);\n\n                        contentStream.pipe(outputStream, {\n                            end: false\n                        });\n                        contentStream.once('end', finalize);\n                        contentStream.once('error', err => callback(err));\n\n                        localStream = this._getStream(this.content);\n                        localStream.pipe(contentStream);\n                    } else {\n                        // anything that is not QP or Base54 passes as-is\n                        localStream = this._getStream(this.content);\n                        localStream.pipe(outputStream, {\n                            end: false\n                        });\n                        localStream.once('end', finalize);\n                    }\n\n                    localStream.once('error', err => callback(err));\n                };\n\n                if (this.content._resolve) {\n                    let chunks = [];\n                    let chunklen = 0;\n                    let returned = false;\n                    let sourceStream = this._getStream(this.content);\n                    sourceStream.on('error', err => {\n                        if (returned) {\n                            return;\n                        }\n                        returned = true;\n                        callback(err);\n                    });\n                    sourceStream.on('readable', () => {\n                        let chunk;\n                        while ((chunk = sourceStream.read()) !== null) {\n                            chunks.push(chunk);\n                            chunklen += chunk.length;\n                        }\n                    });\n                    sourceStream.on('end', () => {\n                        if (returned) {\n                            return;\n                        }\n                        returned = true;\n                        this.content._resolve = false;\n                        this.content._resolvedValue = Buffer.concat(chunks, chunklen);\n                        setImmediate(createStream);\n                    });\n                } else {\n                    setImmediate(createStream);\n                }\n                return;\n            } else {\n                return setImmediate(finalize);\n            }\n        };\n\n        if (this._raw) {\n            setImmediate(() => {\n                if (Object.prototype.toString.call(this._raw) === '[object Error]') {\n                    // content is already errored\n                    return callback(this._raw);\n                }\n\n                // remove default error handler (if set)\n                if (typeof this._raw.pipe === 'function') {\n                    this._raw.removeListener('error', this._contentErrorHandler);\n                }\n\n                let raw = this._getStream(this._raw);\n                raw.pipe(outputStream, {\n                    end: false\n                });\n                raw.on('error', err => outputStream.emit('error', err));\n                raw.on('end', finalize);\n            });\n        } else {\n            outputStream.write(this.buildHeaders() + '\\r\\n\\r\\n');\n            setImmediate(sendContent);\n        }\n    }\n\n    /**\n     * Sets envelope to be used instead of the generated one\n     *\n     * @return {Object} SMTP envelope in the form of {from: 'from@example.com', to: ['to@example.com']}\n     */\n    setEnvelope(envelope) {\n        let list;\n\n        this._envelope = {\n            from: false,\n            to: []\n        };\n\n        if (envelope.from) {\n            list = [];\n            this._convertAddresses(this._parseAddresses(envelope.from), list);\n            list = list.filter(address => address && address.address);\n            if (list.length && list[0]) {\n                this._envelope.from = list[0].address;\n            }\n        }\n        ['to', 'cc', 'bcc'].forEach(key => {\n            if (envelope[key]) {\n                this._convertAddresses(this._parseAddresses(envelope[key]), this._envelope.to);\n            }\n        });\n\n        this._envelope.to = this._envelope.to.map(to => to.address).filter(address => address);\n\n        let standardFields = ['to', 'cc', 'bcc', 'from'];\n        Object.keys(envelope).forEach(key => {\n            if (!standardFields.includes(key)) {\n                this._envelope[key] = envelope[key];\n            }\n        });\n\n        return this;\n    }\n\n    /**\n     * Generates and returns an object with parsed address fields\n     *\n     * @return {Object} Address object\n     */\n    getAddresses() {\n        let addresses = {};\n\n        this._headers.forEach(header => {\n            let key = header.key.toLowerCase();\n            if (['from', 'sender', 'reply-to', 'to', 'cc', 'bcc'].includes(key)) {\n                if (!Array.isArray(addresses[key])) {\n                    addresses[key] = [];\n                }\n\n                this._convertAddresses(this._parseAddresses(header.value), addresses[key]);\n            }\n        });\n\n        return addresses;\n    }\n\n    /**\n     * Generates and returns SMTP envelope with the sender address and a list of recipients addresses\n     *\n     * @return {Object} SMTP envelope in the form of {from: 'from@example.com', to: ['to@example.com']}\n     */\n    getEnvelope() {\n        if (this._envelope) {\n            return this._envelope;\n        }\n\n        let envelope = {\n            from: false,\n            to: []\n        };\n        this._headers.forEach(header => {\n            let list = [];\n            if (header.key === 'From' || (!envelope.from && ['Reply-To', 'Sender'].includes(header.key))) {\n                this._convertAddresses(this._parseAddresses(header.value), list);\n                if (list.length && list[0]) {\n                    envelope.from = list[0].address;\n                }\n            } else if (['To', 'Cc', 'Bcc'].includes(header.key)) {\n                this._convertAddresses(this._parseAddresses(header.value), envelope.to);\n            }\n        });\n\n        envelope.to = envelope.to.map(to => to.address);\n\n        return envelope;\n    }\n\n    /**\n     * Returns Message-Id value. If it does not exist, then creates one\n     *\n     * @return {String} Message-Id value\n     */\n    messageId() {\n        let messageId = this.getHeader('Message-ID');\n        // You really should define your own Message-Id field!\n        if (!messageId) {\n            messageId = this._generateMessageId();\n            this.setHeader('Message-ID', messageId);\n        }\n        return messageId;\n    }\n\n    /**\n     * Sets pregenerated content that will be used as the output of this node\n     *\n     * @param {String|Buffer|Stream} Raw MIME contents\n     */\n    setRaw(raw) {\n        this._raw = raw;\n\n        if (this._raw && typeof this._raw.pipe === 'function') {\n            // pre-stream handler. might be triggered if a stream is set as content\n            // and 'error' fires before anything is done with this stream\n            this._contentErrorHandler = err => {\n                this._raw.removeListener('error', this._contentErrorHandler);\n                this._raw = err;\n            };\n            this._raw.once('error', this._contentErrorHandler);\n        }\n\n        return this;\n    }\n\n    /////// PRIVATE METHODS\n\n    /**\n     * Detects and returns handle to a stream related with the content.\n     *\n     * @param {Mixed} content Node content\n     * @returns {Object} Stream object\n     */\n    _getStream(content) {\n        let contentStream;\n\n        if (content._resolvedValue) {\n            // pass string or buffer content as a stream\n            contentStream = new PassThrough();\n\n            setImmediate(() => {\n                try {\n                    contentStream.end(content._resolvedValue);\n                } catch (_err) {\n                    contentStream.emit('error', _err);\n                }\n            });\n\n            return contentStream;\n        } else if (typeof content.pipe === 'function') {\n            // assume as stream\n            return content;\n        } else if (content && typeof content.path === 'string' && !content.href) {\n            if (this.disableFileAccess) {\n                contentStream = new PassThrough();\n                setImmediate(() => contentStream.emit('error', new Error('File access rejected for ' + content.path)));\n                return contentStream;\n            }\n            // read file\n            return fs.createReadStream(content.path);\n        } else if (content && typeof content.href === 'string') {\n            if (this.disableUrlAccess) {\n                contentStream = new PassThrough();\n                setImmediate(() => contentStream.emit('error', new Error('Url access rejected for ' + content.href)));\n                return contentStream;\n            }\n            // fetch URL\n            return nmfetch(content.href, { headers: content.httpHeaders });\n        } else {\n            // pass string or buffer content as a stream\n            contentStream = new PassThrough();\n\n            setImmediate(() => {\n                try {\n                    contentStream.end(content || '');\n                } catch (_err) {\n                    contentStream.emit('error', _err);\n                }\n            });\n            return contentStream;\n        }\n    }\n\n    /**\n     * Parses addresses. Takes in a single address or an array or an\n     * array of address arrays (eg. To: [[first group], [second group],...])\n     *\n     * @param {Mixed} addresses Addresses to be parsed\n     * @return {Array} An array of address objects\n     */\n    _parseAddresses(addresses) {\n        return [].concat.apply(\n            [],\n            [].concat(addresses).map(address => {\n                if (address && address.address) {\n                    address.address = this._normalizeAddress(address.address);\n                    address.name = address.name || '';\n                    return [address];\n                }\n                return addressparser(address);\n            })\n        );\n    }\n\n    /**\n     * Normalizes a header key, uses Camel-Case form, except for uppercase MIME-\n     *\n     * @param {String} key Key to be normalized\n     * @return {String} key in Camel-Case form\n     */\n    _normalizeHeaderKey(key) {\n        key = (key || '')\n            .toString()\n            // no newlines in keys\n            .replace(/\\r?\\n|\\r/g, ' ')\n            .trim()\n            .toLowerCase()\n            // use uppercase words, except MIME\n            .replace(/^X-SMTPAPI$|^(MIME|DKIM|ARC|BIMI)\\b|^[a-z]|-(SPF|FBL|ID|MD5)$|-[a-z]/gi, c => c.toUpperCase())\n            // special case\n            .replace(/^Content-Features$/i, 'Content-features');\n\n        return key;\n    }\n\n    /**\n     * Checks if the content type is multipart and defines boundary if needed.\n     * Doesn't return anything, modifies object argument instead.\n     *\n     * @param {Object} structured Parsed header value for 'Content-Type' key\n     */\n    _handleContentType(structured) {\n        this.contentType = structured.value.trim().toLowerCase();\n\n        this.multipart = /^multipart\\//i.test(this.contentType) ? this.contentType.substr(this.contentType.indexOf('/') + 1) : false;\n\n        if (this.multipart) {\n            this.boundary = structured.params.boundary = structured.params.boundary || this.boundary || this._generateBoundary();\n        } else {\n            this.boundary = false;\n        }\n    }\n\n    /**\n     * Generates a multipart boundary value\n     *\n     * @return {String} boundary value\n     */\n    _generateBoundary() {\n        return this.rootNode.boundaryPrefix + '-' + this.rootNode.baseBoundary + '-Part_' + this._nodeId;\n    }\n\n    /**\n     * Encodes a header value for use in the generated rfc2822 email.\n     *\n     * @param {String} key Header key\n     * @param {String} value Header value\n     */\n    _encodeHeaderValue(key, value) {\n        key = this._normalizeHeaderKey(key);\n\n        switch (key) {\n            // Structured headers\n            case 'From':\n            case 'Sender':\n            case 'To':\n            case 'Cc':\n            case 'Bcc':\n            case 'Reply-To':\n                return this._convertAddresses(this._parseAddresses(value));\n\n            // values enclosed in <>\n            case 'Message-ID':\n            case 'In-Reply-To':\n            case 'Content-Id':\n                value = (value || '').toString().replace(/\\r?\\n|\\r/g, ' ');\n\n                if (value.charAt(0) !== '<') {\n                    value = '<' + value;\n                }\n\n                if (value.charAt(value.length - 1) !== '>') {\n                    value = value + '>';\n                }\n                return value;\n\n            // space separated list of values enclosed in <>\n            case 'References':\n                value = [].concat\n                    .apply(\n                        [],\n                        [].concat(value || '').map(elm => {\n                            elm = (elm || '')\n                                .toString()\n                                .replace(/\\r?\\n|\\r/g, ' ')\n                                .trim();\n                            return elm.replace(/<[^>]*>/g, str => str.replace(/\\s/g, '')).split(/\\s+/);\n                        })\n                    )\n                    .map(elm => {\n                        if (elm.charAt(0) !== '<') {\n                            elm = '<' + elm;\n                        }\n                        if (elm.charAt(elm.length - 1) !== '>') {\n                            elm = elm + '>';\n                        }\n                        return elm;\n                    });\n\n                return value.join(' ').trim();\n\n            case 'Date':\n                if (Object.prototype.toString.call(value) === '[object Date]') {\n                    return value.toUTCString().replace(/GMT/, '+0000');\n                }\n\n                value = (value || '').toString().replace(/\\r?\\n|\\r/g, ' ');\n                return this._encodeWords(value);\n\n            case 'Content-Type':\n            case 'Content-Disposition':\n                // if it includes a filename then it is already encoded\n                return (value || '').toString().replace(/\\r?\\n|\\r/g, ' ');\n\n            default:\n                value = (value || '').toString().replace(/\\r?\\n|\\r/g, ' ');\n                // encodeWords only encodes if needed, otherwise the original string is returned\n                return this._encodeWords(value);\n        }\n    }\n\n    /**\n     * Rebuilds address object using punycode and other adjustments\n     *\n     * @param {Array} addresses An array of address objects\n     * @param {Array} [uniqueList] An array to be populated with addresses\n     * @return {String} address string\n     */\n    _convertAddresses(addresses, uniqueList) {\n        let values = [];\n\n        uniqueList = uniqueList || [];\n\n        [].concat(addresses || []).forEach(address => {\n            if (address.address) {\n                address.address = this._normalizeAddress(address.address);\n\n                if (!address.name) {\n                    values.push(address.address.indexOf(' ') >= 0 ? `<${address.address}>` : `${address.address}`);\n                } else if (address.name) {\n                    values.push(`${this._encodeAddressName(address.name)} <${address.address}>`);\n                }\n\n                if (address.address) {\n                    if (!uniqueList.filter(a => a.address === address.address).length) {\n                        uniqueList.push(address);\n                    }\n                }\n            } else if (address.group) {\n                let groupListAddresses = (address.group.length ? this._convertAddresses(address.group, uniqueList) : '').trim();\n                values.push(`${this._encodeAddressName(address.name)}:${groupListAddresses};`);\n            }\n        });\n\n        return values.join(', ');\n    }\n\n    /**\n     * Normalizes an email address\n     *\n     * @param {Array} address An array of address objects\n     * @return {String} address string\n     */\n    _normalizeAddress(address) {\n        address = (address || '')\n            .toString()\n            .replace(/[\\x00-\\x1F<>]+/g, ' ') // remove unallowed characters\n            .trim();\n\n        let lastAt = address.lastIndexOf('@');\n        if (lastAt < 0) {\n            // Bare username\n            return address;\n        }\n\n        let user = address.substr(0, lastAt);\n        let domain = address.substr(lastAt + 1);\n\n        // Usernames are not touched and are kept as is even if these include unicode\n        // Domains are punycoded by default\n        // 'jõgeva.ee' will be converted to 'xn--jgeva-dua.ee'\n        // non-unicode domains are left as is\n\n        let encodedDomain;\n\n        try {\n            encodedDomain = punycode.toASCII(domain.toLowerCase());\n        } catch (_err) {\n            // keep as is?\n        }\n\n        if (user.indexOf(' ') >= 0) {\n            if (user.charAt(0) !== '\"') {\n                user = '\"' + user;\n            }\n            if (user.substr(-1) !== '\"') {\n                user = user + '\"';\n            }\n        }\n\n        return `${user}@${encodedDomain}`;\n    }\n\n    /**\n     * If needed, mime encodes the name part\n     *\n     * @param {String} name Name part of an address\n     * @returns {String} Mime word encoded string if needed\n     */\n    _encodeAddressName(name) {\n        if (!/^[\\w ]*$/.test(name)) {\n            if (/^[\\x20-\\x7e]*$/.test(name)) {\n                return '\"' + name.replace(/([\\\\\"])/g, '\\\\$1') + '\"';\n            } else {\n                return mimeFuncs.encodeWord(name, this._getTextEncoding(name), 52);\n            }\n        }\n        return name;\n    }\n\n    /**\n     * If needed, mime encodes the name part\n     *\n     * @param {String} name Name part of an address\n     * @returns {String} Mime word encoded string if needed\n     */\n    _encodeWords(value) {\n        // set encodeAll parameter to true even though it is against the recommendation of RFC2047,\n        // by default only words that include non-ascii should be converted into encoded words\n        // but some clients (eg. Zimbra) do not handle it properly and remove surrounding whitespace\n        return mimeFuncs.encodeWords(value, this._getTextEncoding(value), 52, true);\n    }\n\n    /**\n     * Detects best mime encoding for a text value\n     *\n     * @param {String} value Value to check for\n     * @return {String} either 'Q' or 'B'\n     */\n    _getTextEncoding(value) {\n        value = (value || '').toString();\n\n        let encoding = this.textEncoding;\n        let latinLen;\n        let nonLatinLen;\n\n        if (!encoding) {\n            // count latin alphabet symbols and 8-bit range symbols + control symbols\n            // if there are more latin characters, then use quoted-printable\n            // encoding, otherwise use base64\n            nonLatinLen = (value.match(/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\u0080-\\uFFFF]/g) || []).length;\n            latinLen = (value.match(/[a-z]/gi) || []).length;\n            // if there are more latin symbols than binary/unicode, then prefer Q, otherwise B\n            encoding = nonLatinLen < latinLen ? 'Q' : 'B';\n        }\n        return encoding;\n    }\n\n    /**\n     * Generates a message id\n     *\n     * @return {String} Random Message-ID value\n     */\n    _generateMessageId() {\n        return (\n            '<' +\n            [2, 2, 2, 6].reduce(\n                // crux to generate UUID-like random strings\n                (prev, len) => prev + '-' + crypto.randomBytes(len).toString('hex'),\n                crypto.randomBytes(4).toString('hex')\n            ) +\n            '@' +\n            // try to use the domain of the FROM address or fallback to server hostname\n            (this.getEnvelope().from || this.hostname || 'localhost').split('@').pop() +\n            '>'\n        );\n    }\n}\n\nmodule.exports = MimeNode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-node/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-node/last-newline.js":
/*!***************************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-node/last-newline.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst Transform = (__webpack_require__(/*! stream */ \"stream\").Transform);\n\nclass LastNewline extends Transform {\n    constructor() {\n        super();\n        this.lastByte = false;\n    }\n\n    _transform(chunk, encoding, done) {\n        if (chunk.length) {\n            this.lastByte = chunk[chunk.length - 1];\n        }\n\n        this.push(chunk);\n        done();\n    }\n\n    _flush(done) {\n        if (this.lastByte === 0x0a) {\n            return done();\n        }\n        if (this.lastByte === 0x0d) {\n            this.push(Buffer.from('\\n'));\n            return done();\n        }\n        this.push(Buffer.from('\\r\\n'));\n        return done();\n    }\n}\n\nmodule.exports = LastNewline;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvbWltZS1ub2RlL2xhc3QtbmV3bGluZS5qcyIsIm1hcHBpbmdzIjoiQUFBYTs7QUFFYixrQkFBa0IsdURBQTJCOztBQUU3QztBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUEiLCJzb3VyY2VzIjpbIi9ob21lL2h4Y2tlci9EZXNrdG9wL2JldC9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvbWltZS1ub2RlL2xhc3QtbmV3bGluZS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbmNvbnN0IFRyYW5zZm9ybSA9IHJlcXVpcmUoJ3N0cmVhbScpLlRyYW5zZm9ybTtcblxuY2xhc3MgTGFzdE5ld2xpbmUgZXh0ZW5kcyBUcmFuc2Zvcm0ge1xuICAgIGNvbnN0cnVjdG9yKCkge1xuICAgICAgICBzdXBlcigpO1xuICAgICAgICB0aGlzLmxhc3RCeXRlID0gZmFsc2U7XG4gICAgfVxuXG4gICAgX3RyYW5zZm9ybShjaHVuaywgZW5jb2RpbmcsIGRvbmUpIHtcbiAgICAgICAgaWYgKGNodW5rLmxlbmd0aCkge1xuICAgICAgICAgICAgdGhpcy5sYXN0Qnl0ZSA9IGNodW5rW2NodW5rLmxlbmd0aCAtIDFdO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5wdXNoKGNodW5rKTtcbiAgICAgICAgZG9uZSgpO1xuICAgIH1cblxuICAgIF9mbHVzaChkb25lKSB7XG4gICAgICAgIGlmICh0aGlzLmxhc3RCeXRlID09PSAweDBhKSB7XG4gICAgICAgICAgICByZXR1cm4gZG9uZSgpO1xuICAgICAgICB9XG4gICAgICAgIGlmICh0aGlzLmxhc3RCeXRlID09PSAweDBkKSB7XG4gICAgICAgICAgICB0aGlzLnB1c2goQnVmZmVyLmZyb20oJ1xcbicpKTtcbiAgICAgICAgICAgIHJldHVybiBkb25lKCk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5wdXNoKEJ1ZmZlci5mcm9tKCdcXHJcXG4nKSk7XG4gICAgICAgIHJldHVybiBkb25lKCk7XG4gICAgfVxufVxuXG5tb2R1bGUuZXhwb3J0cyA9IExhc3ROZXdsaW5lO1xuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-node/last-newline.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-node/le-unix.js":
/*!**********************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-node/le-unix.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst stream = __webpack_require__(/*! stream */ \"stream\");\nconst Transform = stream.Transform;\n\n/**\n * Ensures that only <LF> is used for linebreaks\n *\n * @param {Object} options Stream options\n */\nclass LeWindows extends Transform {\n    constructor(options) {\n        super(options);\n        // init Transform\n        this.options = options || {};\n    }\n\n    /**\n     * Escapes dots\n     */\n    _transform(chunk, encoding, done) {\n        let buf;\n        let lastPos = 0;\n\n        for (let i = 0, len = chunk.length; i < len; i++) {\n            if (chunk[i] === 0x0d) {\n                // \\n\n                buf = chunk.slice(lastPos, i);\n                lastPos = i + 1;\n                this.push(buf);\n            }\n        }\n        if (lastPos && lastPos < chunk.length) {\n            buf = chunk.slice(lastPos);\n            this.push(buf);\n        } else if (!lastPos) {\n            this.push(chunk);\n        }\n        done();\n    }\n}\n\nmodule.exports = LeWindows;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-node/le-unix.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/mime-node/le-windows.js":
/*!*************************************************************!*\
  !*** ./node_modules/nodemailer/lib/mime-node/le-windows.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst stream = __webpack_require__(/*! stream */ \"stream\");\nconst Transform = stream.Transform;\n\n/**\n * Ensures that only <CR><LF> sequences are used for linebreaks\n *\n * @param {Object} options Stream options\n */\nclass LeWindows extends Transform {\n    constructor(options) {\n        super(options);\n        // init Transform\n        this.options = options || {};\n        this.lastByte = false;\n    }\n\n    /**\n     * Escapes dots\n     */\n    _transform(chunk, encoding, done) {\n        let buf;\n        let lastPos = 0;\n\n        for (let i = 0, len = chunk.length; i < len; i++) {\n            if (chunk[i] === 0x0a) {\n                // \\n\n                if ((i && chunk[i - 1] !== 0x0d) || (!i && this.lastByte !== 0x0d)) {\n                    if (i > lastPos) {\n                        buf = chunk.slice(lastPos, i);\n                        this.push(buf);\n                    }\n                    this.push(Buffer.from('\\r\\n'));\n                    lastPos = i + 1;\n                }\n            }\n        }\n\n        if (lastPos && lastPos < chunk.length) {\n            buf = chunk.slice(lastPos);\n            this.push(buf);\n        } else if (!lastPos) {\n            this.push(chunk);\n        }\n\n        this.lastByte = chunk[chunk.length - 1];\n        done();\n    }\n}\n\nmodule.exports = LeWindows;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/mime-node/le-windows.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/nodemailer.js":
/*!***************************************************!*\
  !*** ./node_modules/nodemailer/lib/nodemailer.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst Mailer = __webpack_require__(/*! ./mailer */ \"(ssr)/./node_modules/nodemailer/lib/mailer/index.js\");\nconst shared = __webpack_require__(/*! ./shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\nconst SMTPPool = __webpack_require__(/*! ./smtp-pool */ \"(ssr)/./node_modules/nodemailer/lib/smtp-pool/index.js\");\nconst SMTPTransport = __webpack_require__(/*! ./smtp-transport */ \"(ssr)/./node_modules/nodemailer/lib/smtp-transport/index.js\");\nconst SendmailTransport = __webpack_require__(/*! ./sendmail-transport */ \"(ssr)/./node_modules/nodemailer/lib/sendmail-transport/index.js\");\nconst StreamTransport = __webpack_require__(/*! ./stream-transport */ \"(ssr)/./node_modules/nodemailer/lib/stream-transport/index.js\");\nconst JSONTransport = __webpack_require__(/*! ./json-transport */ \"(ssr)/./node_modules/nodemailer/lib/json-transport/index.js\");\nconst SESTransport = __webpack_require__(/*! ./ses-transport */ \"(ssr)/./node_modules/nodemailer/lib/ses-transport/index.js\");\nconst nmfetch = __webpack_require__(/*! ./fetch */ \"(ssr)/./node_modules/nodemailer/lib/fetch/index.js\");\nconst packageData = __webpack_require__(/*! ../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\n\nconst ETHEREAL_API = (process.env.ETHEREAL_API || 'https://api.nodemailer.com').replace(/\\/+$/, '');\nconst ETHEREAL_WEB = (process.env.ETHEREAL_WEB || 'https://ethereal.email').replace(/\\/+$/, '');\nconst ETHEREAL_API_KEY = (process.env.ETHEREAL_API_KEY || '').replace(/\\s*/g, '') || null;\nconst ETHEREAL_CACHE = ['true', 'yes', 'y', '1'].includes((process.env.ETHEREAL_CACHE || 'yes').toString().trim().toLowerCase());\n\nlet testAccount = false;\n\nmodule.exports.createTransport = function (transporter, defaults) {\n    let urlConfig;\n    let options;\n    let mailer;\n\n    if (\n        // provided transporter is a configuration object, not transporter plugin\n        (typeof transporter === 'object' && typeof transporter.send !== 'function') ||\n        // provided transporter looks like a connection url\n        (typeof transporter === 'string' && /^(smtps?|direct):/i.test(transporter))\n    ) {\n        if ((urlConfig = typeof transporter === 'string' ? transporter : transporter.url)) {\n            // parse a configuration URL into configuration options\n            options = shared.parseConnectionUrl(urlConfig);\n        } else {\n            options = transporter;\n        }\n\n        if (options.pool) {\n            transporter = new SMTPPool(options);\n        } else if (options.sendmail) {\n            transporter = new SendmailTransport(options);\n        } else if (options.streamTransport) {\n            transporter = new StreamTransport(options);\n        } else if (options.jsonTransport) {\n            transporter = new JSONTransport(options);\n        } else if (options.SES) {\n            if (options.SES.ses && options.SES.aws) {\n                let error = new Error(\n                    'Using legacy SES configuration, expecting @aws-sdk/client-sesv2, see https://nodemailer.com/transports/ses/'\n                );\n                error.code = 'LegacyConfig';\n                throw error;\n            }\n            transporter = new SESTransport(options);\n        } else {\n            transporter = new SMTPTransport(options);\n        }\n    }\n\n    mailer = new Mailer(transporter, options, defaults);\n\n    return mailer;\n};\n\nmodule.exports.createTestAccount = function (apiUrl, callback) {\n    let promise;\n\n    if (!callback && typeof apiUrl === 'function') {\n        callback = apiUrl;\n        apiUrl = false;\n    }\n\n    if (!callback) {\n        promise = new Promise((resolve, reject) => {\n            callback = shared.callbackPromise(resolve, reject);\n        });\n    }\n\n    if (ETHEREAL_CACHE && testAccount) {\n        setImmediate(() => callback(null, testAccount));\n        return promise;\n    }\n\n    apiUrl = apiUrl || ETHEREAL_API;\n\n    let chunks = [];\n    let chunklen = 0;\n\n    let requestHeaders = {};\n    let requestBody = {\n        requestor: packageData.name,\n        version: packageData.version\n    };\n\n    if (ETHEREAL_API_KEY) {\n        requestHeaders.Authorization = 'Bearer ' + ETHEREAL_API_KEY;\n    }\n\n    let req = nmfetch(apiUrl + '/user', {\n        contentType: 'application/json',\n        method: 'POST',\n        headers: requestHeaders,\n        body: Buffer.from(JSON.stringify(requestBody))\n    });\n\n    req.on('readable', () => {\n        let chunk;\n        while ((chunk = req.read()) !== null) {\n            chunks.push(chunk);\n            chunklen += chunk.length;\n        }\n    });\n\n    req.once('error', err => callback(err));\n\n    req.once('end', () => {\n        let res = Buffer.concat(chunks, chunklen);\n        let data;\n        let err;\n        try {\n            data = JSON.parse(res.toString());\n        } catch (E) {\n            err = E;\n        }\n        if (err) {\n            return callback(err);\n        }\n        if (data.status !== 'success' || data.error) {\n            return callback(new Error(data.error || 'Request failed'));\n        }\n        delete data.status;\n        testAccount = data;\n        callback(null, testAccount);\n    });\n\n    return promise;\n};\n\nmodule.exports.getTestMessageUrl = function (info) {\n    if (!info || !info.response) {\n        return false;\n    }\n\n    let infoProps = new Map();\n    info.response.replace(/\\[([^\\]]+)\\]$/, (m, props) => {\n        props.replace(/\\b([A-Z0-9]+)=([^\\s]+)/g, (m, key, value) => {\n            infoProps.set(key, value);\n        });\n    });\n\n    if (infoProps.has('STATUS') && infoProps.has('MSGID')) {\n        return (testAccount.web || ETHEREAL_WEB) + '/message/' + infoProps.get('MSGID');\n    }\n\n    return false;\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/nodemailer.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/punycode/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/nodemailer/lib/punycode/index.js ***!
  \*******************************************************/
/***/ ((module) => {

eval("/*\n\nCopied from https://github.com/mathiasbynens/punycode.js/blob/ef3505c8abb5143a00d53ce59077c9f7f4b2ac47/punycode.js\n\nCopyright Mathias Bynens <https://mathiasbynens.be/>\n\nPermission is hereby granted, free of charge, to any person obtaining\na copy of this software and associated documentation files (the\n\"Software\"), to deal in the Software without restriction, including\nwithout limitation the rights to use, copy, modify, merge, publish,\ndistribute, sublicense, and/or sell copies of the Software, and to\npermit persons to whom the Software is furnished to do so, subject to\nthe following conditions:\n\nThe above copyright notice and this permission notice shall be\nincluded in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\nEXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\nMERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\nNONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\nLIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\nOF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\nWITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n*/\n/* eslint callback-return: 0, no-bitwise: 0, eqeqeq: 0, prefer-arrow-callback: 0, object-shorthand: 0 */\n\n\n\n/** Highest positive signed 32-bit float value */\nconst maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1\n\n/** Bootstring parameters */\nconst base = 36;\nconst tMin = 1;\nconst tMax = 26;\nconst skew = 38;\nconst damp = 700;\nconst initialBias = 72;\nconst initialN = 128; // 0x80\nconst delimiter = '-'; // '\\x2D'\n\n/** Regular expressions */\nconst regexPunycode = /^xn--/;\nconst regexNonASCII = /[^\\0-\\x7F]/; // Note: U+007F DEL is excluded too.\nconst regexSeparators = /[\\x2E\\u3002\\uFF0E\\uFF61]/g; // RFC 3490 separators\n\n/** Error messages */\nconst errors = {\n    overflow: 'Overflow: input needs wider integers to process',\n    'not-basic': 'Illegal input >= 0x80 (not a basic code point)',\n    'invalid-input': 'Invalid input'\n};\n\n/** Convenience shortcuts */\nconst baseMinusTMin = base - tMin;\nconst floor = Math.floor;\nconst stringFromCharCode = String.fromCharCode;\n\n/*--------------------------------------------------------------------------*/\n\n/**\n * A generic error utility function.\n * @private\n * @param {String} type The error type.\n * @returns {Error} Throws a `RangeError` with the applicable error message.\n */\nfunction error(type) {\n    throw new RangeError(errors[type]);\n}\n\n/**\n * A generic `Array#map` utility function.\n * @private\n * @param {Array} array The array to iterate over.\n * @param {Function} callback The function that gets called for every array\n * item.\n * @returns {Array} A new array of values returned by the callback function.\n */\nfunction map(array, callback) {\n    const result = [];\n    let length = array.length;\n    while (length--) {\n        result[length] = callback(array[length]);\n    }\n    return result;\n}\n\n/**\n * A simple `Array#map`-like wrapper to work with domain name strings or email\n * addresses.\n * @private\n * @param {String} domain The domain name or email address.\n * @param {Function} callback The function that gets called for every\n * character.\n * @returns {String} A new string of characters returned by the callback\n * function.\n */\nfunction mapDomain(domain, callback) {\n    const parts = domain.split('@');\n    let result = '';\n    if (parts.length > 1) {\n        // In email addresses, only the domain name should be punycoded. Leave\n        // the local part (i.e. everything up to `@`) intact.\n        result = parts[0] + '@';\n        domain = parts[1];\n    }\n    // Avoid `split(regex)` for IE8 compatibility. See #17.\n    domain = domain.replace(regexSeparators, '\\x2E');\n    const labels = domain.split('.');\n    const encoded = map(labels, callback).join('.');\n    return result + encoded;\n}\n\n/**\n * Creates an array containing the numeric code points of each Unicode\n * character in the string. While JavaScript uses UCS-2 internally,\n * this function will convert a pair of surrogate halves (each of which\n * UCS-2 exposes as separate characters) into a single code point,\n * matching UTF-16.\n * @see `punycode.ucs2.encode`\n * @see <https://mathiasbynens.be/notes/javascript-encoding>\n * @memberOf punycode.ucs2\n * @name decode\n * @param {String} string The Unicode input string (UCS-2).\n * @returns {Array} The new array of code points.\n */\nfunction ucs2decode(string) {\n    const output = [];\n    let counter = 0;\n    const length = string.length;\n    while (counter < length) {\n        const value = string.charCodeAt(counter++);\n        if (value >= 0xd800 && value <= 0xdbff && counter < length) {\n            // It's a high surrogate, and there is a next character.\n            const extra = string.charCodeAt(counter++);\n            if ((extra & 0xfc00) == 0xdc00) {\n                // Low surrogate.\n                output.push(((value & 0x3ff) << 10) + (extra & 0x3ff) + 0x10000);\n            } else {\n                // It's an unmatched surrogate; only append this code unit, in case the\n                // next code unit is the high surrogate of a surrogate pair.\n                output.push(value);\n                counter--;\n            }\n        } else {\n            output.push(value);\n        }\n    }\n    return output;\n}\n\n/**\n * Creates a string based on an array of numeric code points.\n * @see `punycode.ucs2.decode`\n * @memberOf punycode.ucs2\n * @name encode\n * @param {Array} codePoints The array of numeric code points.\n * @returns {String} The new Unicode string (UCS-2).\n */\nconst ucs2encode = codePoints => String.fromCodePoint(...codePoints);\n\n/**\n * Converts a basic code point into a digit/integer.\n * @see `digitToBasic()`\n * @private\n * @param {Number} codePoint The basic numeric code point value.\n * @returns {Number} The numeric value of a basic code point (for use in\n * representing integers) in the range `0` to `base - 1`, or `base` if\n * the code point does not represent a value.\n */\nconst basicToDigit = function (codePoint) {\n    if (codePoint >= 0x30 && codePoint < 0x3a) {\n        return 26 + (codePoint - 0x30);\n    }\n    if (codePoint >= 0x41 && codePoint < 0x5b) {\n        return codePoint - 0x41;\n    }\n    if (codePoint >= 0x61 && codePoint < 0x7b) {\n        return codePoint - 0x61;\n    }\n    return base;\n};\n\n/**\n * Converts a digit/integer into a basic code point.\n * @see `basicToDigit()`\n * @private\n * @param {Number} digit The numeric value of a basic code point.\n * @returns {Number} The basic code point whose value (when used for\n * representing integers) is `digit`, which needs to be in the range\n * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is\n * used; else, the lowercase form is used. The behavior is undefined\n * if `flag` is non-zero and `digit` has no uppercase form.\n */\nconst digitToBasic = function (digit, flag) {\n    //  0..25 map to ASCII a..z or A..Z\n    // 26..35 map to ASCII 0..9\n    return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);\n};\n\n/**\n * Bias adaptation function as per section 3.4 of RFC 3492.\n * https://tools.ietf.org/html/rfc3492#section-3.4\n * @private\n */\nconst adapt = function (delta, numPoints, firstTime) {\n    let k = 0;\n    delta = firstTime ? floor(delta / damp) : delta >> 1;\n    delta += floor(delta / numPoints);\n    for (; /* no initialization */ delta > (baseMinusTMin * tMax) >> 1; k += base) {\n        delta = floor(delta / baseMinusTMin);\n    }\n    return floor(k + ((baseMinusTMin + 1) * delta) / (delta + skew));\n};\n\n/**\n * Converts a Punycode string of ASCII-only symbols to a string of Unicode\n * symbols.\n * @memberOf punycode\n * @param {String} input The Punycode string of ASCII-only symbols.\n * @returns {String} The resulting string of Unicode symbols.\n */\nconst decode = function (input) {\n    // Don't use UCS-2.\n    const output = [];\n    const inputLength = input.length;\n    let i = 0;\n    let n = initialN;\n    let bias = initialBias;\n\n    // Handle the basic code points: let `basic` be the number of input code\n    // points before the last delimiter, or `0` if there is none, then copy\n    // the first basic code points to the output.\n\n    let basic = input.lastIndexOf(delimiter);\n    if (basic < 0) {\n        basic = 0;\n    }\n\n    for (let j = 0; j < basic; ++j) {\n        // if it's not a basic code point\n        if (input.charCodeAt(j) >= 0x80) {\n            error('not-basic');\n        }\n        output.push(input.charCodeAt(j));\n    }\n\n    // Main decoding loop: start just after the last delimiter if any basic code\n    // points were copied; start at the beginning otherwise.\n\n    for (let index = basic > 0 ? basic + 1 : 0; index < inputLength /* no final expression */; ) {\n        // `index` is the index of the next character to be consumed.\n        // Decode a generalized variable-length integer into `delta`,\n        // which gets added to `i`. The overflow checking is easier\n        // if we increase `i` as we go, then subtract off its starting\n        // value at the end to obtain `delta`.\n        const oldi = i;\n        for (let w = 1, k = base /* no condition */; ; k += base) {\n            if (index >= inputLength) {\n                error('invalid-input');\n            }\n\n            const digit = basicToDigit(input.charCodeAt(index++));\n\n            if (digit >= base) {\n                error('invalid-input');\n            }\n            if (digit > floor((maxInt - i) / w)) {\n                error('overflow');\n            }\n\n            i += digit * w;\n            const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;\n\n            if (digit < t) {\n                break;\n            }\n\n            const baseMinusT = base - t;\n            if (w > floor(maxInt / baseMinusT)) {\n                error('overflow');\n            }\n\n            w *= baseMinusT;\n        }\n\n        const out = output.length + 1;\n        bias = adapt(i - oldi, out, oldi == 0);\n\n        // `i` was supposed to wrap around from `out` to `0`,\n        // incrementing `n` each time, so we'll fix that now:\n        if (floor(i / out) > maxInt - n) {\n            error('overflow');\n        }\n\n        n += floor(i / out);\n        i %= out;\n\n        // Insert `n` at position `i` of the output.\n        output.splice(i++, 0, n);\n    }\n\n    return String.fromCodePoint(...output);\n};\n\n/**\n * Converts a string of Unicode symbols (e.g. a domain name label) to a\n * Punycode string of ASCII-only symbols.\n * @memberOf punycode\n * @param {String} input The string of Unicode symbols.\n * @returns {String} The resulting Punycode string of ASCII-only symbols.\n */\nconst encode = function (input) {\n    const output = [];\n\n    // Convert the input in UCS-2 to an array of Unicode code points.\n    input = ucs2decode(input);\n\n    // Cache the length.\n    const inputLength = input.length;\n\n    // Initialize the state.\n    let n = initialN;\n    let delta = 0;\n    let bias = initialBias;\n\n    // Handle the basic code points.\n    for (const currentValue of input) {\n        if (currentValue < 0x80) {\n            output.push(stringFromCharCode(currentValue));\n        }\n    }\n\n    const basicLength = output.length;\n    let handledCPCount = basicLength;\n\n    // `handledCPCount` is the number of code points that have been handled;\n    // `basicLength` is the number of basic code points.\n\n    // Finish the basic string with a delimiter unless it's empty.\n    if (basicLength) {\n        output.push(delimiter);\n    }\n\n    // Main encoding loop:\n    while (handledCPCount < inputLength) {\n        // All non-basic code points < n have been handled already. Find the next\n        // larger one:\n        let m = maxInt;\n        for (const currentValue of input) {\n            if (currentValue >= n && currentValue < m) {\n                m = currentValue;\n            }\n        }\n\n        // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,\n        // but guard against overflow.\n        const handledCPCountPlusOne = handledCPCount + 1;\n        if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {\n            error('overflow');\n        }\n\n        delta += (m - n) * handledCPCountPlusOne;\n        n = m;\n\n        for (const currentValue of input) {\n            if (currentValue < n && ++delta > maxInt) {\n                error('overflow');\n            }\n            if (currentValue === n) {\n                // Represent delta as a generalized variable-length integer.\n                let q = delta;\n                for (let k = base /* no condition */; ; k += base) {\n                    const t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;\n                    if (q < t) {\n                        break;\n                    }\n                    const qMinusT = q - t;\n                    const baseMinusT = base - t;\n                    output.push(stringFromCharCode(digitToBasic(t + (qMinusT % baseMinusT), 0)));\n                    q = floor(qMinusT / baseMinusT);\n                }\n\n                output.push(stringFromCharCode(digitToBasic(q, 0)));\n                bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength);\n                delta = 0;\n                ++handledCPCount;\n            }\n        }\n\n        ++delta;\n        ++n;\n    }\n    return output.join('');\n};\n\n/**\n * Converts a Punycode string representing a domain name or an email address\n * to Unicode. Only the Punycoded parts of the input will be converted, i.e.\n * it doesn't matter if you call it on a string that has already been\n * converted to Unicode.\n * @memberOf punycode\n * @param {String} input The Punycoded domain name or email address to\n * convert to Unicode.\n * @returns {String} The Unicode representation of the given Punycode\n * string.\n */\nconst toUnicode = function (input) {\n    return mapDomain(input, function (string) {\n        return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;\n    });\n};\n\n/**\n * Converts a Unicode string representing a domain name or an email address to\n * Punycode. Only the non-ASCII parts of the domain name will be converted,\n * i.e. it doesn't matter if you call it with a domain that's already in\n * ASCII.\n * @memberOf punycode\n * @param {String} input The domain name or email address to convert, as a\n * Unicode string.\n * @returns {String} The Punycode representation of the given domain name or\n * email address.\n */\nconst toASCII = function (input) {\n    return mapDomain(input, function (string) {\n        return regexNonASCII.test(string) ? 'xn--' + encode(string) : string;\n    });\n};\n\n/*--------------------------------------------------------------------------*/\n\n/** Define the public API */\nconst punycode = {\n    /**\n     * A string representing the current Punycode.js version number.\n     * @memberOf punycode\n     * @type String\n     */\n    version: '2.3.1',\n    /**\n     * An object of methods to convert from JavaScript's internal character\n     * representation (UCS-2) to Unicode code points, and back.\n     * @see <https://mathiasbynens.be/notes/javascript-encoding>\n     * @memberOf punycode\n     * @type Object\n     */\n    ucs2: {\n        decode: ucs2decode,\n        encode: ucs2encode\n    },\n    decode: decode,\n    encode: encode,\n    toASCII: toASCII,\n    toUnicode: toUnicode\n};\n\nmodule.exports = punycode;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvcHVueWNvZGUvaW5kZXguanMiLCJtYXBwaW5ncyI6IkFBQUE7O0FBRUE7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVhOztBQUViO0FBQ0EsMkJBQTJCOztBQUUzQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHNCQUFzQjtBQUN0Qix1QkFBdUI7O0FBRXZCO0FBQ0E7QUFDQSxvQ0FBb0M7QUFDcEMscURBQXFEOztBQUVyRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLGFBQWEsT0FBTztBQUNwQjtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLE9BQU87QUFDbEIsV0FBVyxVQUFVO0FBQ3JCO0FBQ0EsYUFBYSxPQUFPO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQixXQUFXLFVBQVU7QUFDckI7QUFDQSxhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQixhQUFhLE9BQU87QUFDcEI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxjQUFjO0FBQ2QsZ0RBQWdEO0FBQ2hEO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsT0FBTztBQUNsQixhQUFhLFFBQVE7QUFDckI7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQixhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLGFBQWEsUUFBUTtBQUNyQjtBQUNBO0FBQ0EsU0FBUztBQUNUO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsNkRBQTZEO0FBQ3hFO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLGFBQWEsUUFBUTtBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxvQkFBb0IsV0FBVztBQUMvQjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQSwyQkFBMkI7O0FBRTNCLGdEQUFnRCwrQ0FBK0M7QUFDL0Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsdURBQXVEO0FBQ3ZEO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQixhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esd0RBQXdEO0FBQ3hEO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxXQUFXLFFBQVE7QUFDbkI7QUFDQSxhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLEtBQUs7QUFDTDs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxLQUFLO0FBQ0w7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSIsInNvdXJjZXMiOlsiL2hvbWUvaHhja2VyL0Rlc2t0b3AvYmV0L25vZGVfbW9kdWxlcy9ub2RlbWFpbGVyL2xpYi9wdW55Y29kZS9pbmRleC5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuXG5Db3BpZWQgZnJvbSBodHRwczovL2dpdGh1Yi5jb20vbWF0aGlhc2J5bmVucy9wdW55Y29kZS5qcy9ibG9iL2VmMzUwNWM4YWJiNTE0M2EwMGQ1M2NlNTkwNzdjOWY3ZjRiMmFjNDcvcHVueWNvZGUuanNcblxuQ29weXJpZ2h0IE1hdGhpYXMgQnluZW5zIDxodHRwczovL21hdGhpYXNieW5lbnMuYmUvPlxuXG5QZXJtaXNzaW9uIGlzIGhlcmVieSBncmFudGVkLCBmcmVlIG9mIGNoYXJnZSwgdG8gYW55IHBlcnNvbiBvYnRhaW5pbmdcbmEgY29weSBvZiB0aGlzIHNvZnR3YXJlIGFuZCBhc3NvY2lhdGVkIGRvY3VtZW50YXRpb24gZmlsZXMgKHRoZVxuXCJTb2Z0d2FyZVwiKSwgdG8gZGVhbCBpbiB0aGUgU29mdHdhcmUgd2l0aG91dCByZXN0cmljdGlvbiwgaW5jbHVkaW5nXG53aXRob3V0IGxpbWl0YXRpb24gdGhlIHJpZ2h0cyB0byB1c2UsIGNvcHksIG1vZGlmeSwgbWVyZ2UsIHB1Ymxpc2gsXG5kaXN0cmlidXRlLCBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbCBjb3BpZXMgb2YgdGhlIFNvZnR3YXJlLCBhbmQgdG9cbnBlcm1pdCBwZXJzb25zIHRvIHdob20gdGhlIFNvZnR3YXJlIGlzIGZ1cm5pc2hlZCB0byBkbyBzbywgc3ViamVjdCB0b1xudGhlIGZvbGxvd2luZyBjb25kaXRpb25zOlxuXG5UaGUgYWJvdmUgY29weXJpZ2h0IG5vdGljZSBhbmQgdGhpcyBwZXJtaXNzaW9uIG5vdGljZSBzaGFsbCBiZVxuaW5jbHVkZWQgaW4gYWxsIGNvcGllcyBvciBzdWJzdGFudGlhbCBwb3J0aW9ucyBvZiB0aGUgU29mdHdhcmUuXG5cblRIRSBTT0ZUV0FSRSBJUyBQUk9WSURFRCBcIkFTIElTXCIsIFdJVEhPVVQgV0FSUkFOVFkgT0YgQU5ZIEtJTkQsXG5FWFBSRVNTIE9SIElNUExJRUQsIElOQ0xVRElORyBCVVQgTk9UIExJTUlURUQgVE8gVEhFIFdBUlJBTlRJRVMgT0Zcbk1FUkNIQU5UQUJJTElUWSwgRklUTkVTUyBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UgQU5EXG5OT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRSBBVVRIT1JTIE9SIENPUFlSSUdIVCBIT0xERVJTIEJFXG5MSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUiBMSUFCSUxJVFksIFdIRVRIRVIgSU4gQU4gQUNUSU9OXG5PRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSwgT1VUIE9GIE9SIElOIENPTk5FQ1RJT05cbldJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU4gVEhFIFNPRlRXQVJFLlxuXG4qL1xuLyogZXNsaW50IGNhbGxiYWNrLXJldHVybjogMCwgbm8tYml0d2lzZTogMCwgZXFlcWVxOiAwLCBwcmVmZXItYXJyb3ctY2FsbGJhY2s6IDAsIG9iamVjdC1zaG9ydGhhbmQ6IDAgKi9cblxuJ3VzZSBzdHJpY3QnO1xuXG4vKiogSGlnaGVzdCBwb3NpdGl2ZSBzaWduZWQgMzItYml0IGZsb2F0IHZhbHVlICovXG5jb25zdCBtYXhJbnQgPSAyMTQ3NDgzNjQ3OyAvLyBha2EuIDB4N0ZGRkZGRkYgb3IgMl4zMS0xXG5cbi8qKiBCb290c3RyaW5nIHBhcmFtZXRlcnMgKi9cbmNvbnN0IGJhc2UgPSAzNjtcbmNvbnN0IHRNaW4gPSAxO1xuY29uc3QgdE1heCA9IDI2O1xuY29uc3Qgc2tldyA9IDM4O1xuY29uc3QgZGFtcCA9IDcwMDtcbmNvbnN0IGluaXRpYWxCaWFzID0gNzI7XG5jb25zdCBpbml0aWFsTiA9IDEyODsgLy8gMHg4MFxuY29uc3QgZGVsaW1pdGVyID0gJy0nOyAvLyAnXFx4MkQnXG5cbi8qKiBSZWd1bGFyIGV4cHJlc3Npb25zICovXG5jb25zdCByZWdleFB1bnljb2RlID0gL154bi0tLztcbmNvbnN0IHJlZ2V4Tm9uQVNDSUkgPSAvW15cXDAtXFx4N0ZdLzsgLy8gTm90ZTogVSswMDdGIERFTCBpcyBleGNsdWRlZCB0b28uXG5jb25zdCByZWdleFNlcGFyYXRvcnMgPSAvW1xceDJFXFx1MzAwMlxcdUZGMEVcXHVGRjYxXS9nOyAvLyBSRkMgMzQ5MCBzZXBhcmF0b3JzXG5cbi8qKiBFcnJvciBtZXNzYWdlcyAqL1xuY29uc3QgZXJyb3JzID0ge1xuICAgIG92ZXJmbG93OiAnT3ZlcmZsb3c6IGlucHV0IG5lZWRzIHdpZGVyIGludGVnZXJzIHRvIHByb2Nlc3MnLFxuICAgICdub3QtYmFzaWMnOiAnSWxsZWdhbCBpbnB1dCA+PSAweDgwIChub3QgYSBiYXNpYyBjb2RlIHBvaW50KScsXG4gICAgJ2ludmFsaWQtaW5wdXQnOiAnSW52YWxpZCBpbnB1dCdcbn07XG5cbi8qKiBDb252ZW5pZW5jZSBzaG9ydGN1dHMgKi9cbmNvbnN0IGJhc2VNaW51c1RNaW4gPSBiYXNlIC0gdE1pbjtcbmNvbnN0IGZsb29yID0gTWF0aC5mbG9vcjtcbmNvbnN0IHN0cmluZ0Zyb21DaGFyQ29kZSA9IFN0cmluZy5mcm9tQ2hhckNvZGU7XG5cbi8qLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0qL1xuXG4vKipcbiAqIEEgZ2VuZXJpYyBlcnJvciB1dGlsaXR5IGZ1bmN0aW9uLlxuICogQHByaXZhdGVcbiAqIEBwYXJhbSB7U3RyaW5nfSB0eXBlIFRoZSBlcnJvciB0eXBlLlxuICogQHJldHVybnMge0Vycm9yfSBUaHJvd3MgYSBgUmFuZ2VFcnJvcmAgd2l0aCB0aGUgYXBwbGljYWJsZSBlcnJvciBtZXNzYWdlLlxuICovXG5mdW5jdGlvbiBlcnJvcih0eXBlKSB7XG4gICAgdGhyb3cgbmV3IFJhbmdlRXJyb3IoZXJyb3JzW3R5cGVdKTtcbn1cblxuLyoqXG4gKiBBIGdlbmVyaWMgYEFycmF5I21hcGAgdXRpbGl0eSBmdW5jdGlvbi5cbiAqIEBwcml2YXRlXG4gKiBAcGFyYW0ge0FycmF5fSBhcnJheSBUaGUgYXJyYXkgdG8gaXRlcmF0ZSBvdmVyLlxuICogQHBhcmFtIHtGdW5jdGlvbn0gY2FsbGJhY2sgVGhlIGZ1bmN0aW9uIHRoYXQgZ2V0cyBjYWxsZWQgZm9yIGV2ZXJ5IGFycmF5XG4gKiBpdGVtLlxuICogQHJldHVybnMge0FycmF5fSBBIG5ldyBhcnJheSBvZiB2YWx1ZXMgcmV0dXJuZWQgYnkgdGhlIGNhbGxiYWNrIGZ1bmN0aW9uLlxuICovXG5mdW5jdGlvbiBtYXAoYXJyYXksIGNhbGxiYWNrKSB7XG4gICAgY29uc3QgcmVzdWx0ID0gW107XG4gICAgbGV0IGxlbmd0aCA9IGFycmF5Lmxlbmd0aDtcbiAgICB3aGlsZSAobGVuZ3RoLS0pIHtcbiAgICAgICAgcmVzdWx0W2xlbmd0aF0gPSBjYWxsYmFjayhhcnJheVtsZW5ndGhdKTtcbiAgICB9XG4gICAgcmV0dXJuIHJlc3VsdDtcbn1cblxuLyoqXG4gKiBBIHNpbXBsZSBgQXJyYXkjbWFwYC1saWtlIHdyYXBwZXIgdG8gd29yayB3aXRoIGRvbWFpbiBuYW1lIHN0cmluZ3Mgb3IgZW1haWxcbiAqIGFkZHJlc3Nlcy5cbiAqIEBwcml2YXRlXG4gKiBAcGFyYW0ge1N0cmluZ30gZG9tYWluIFRoZSBkb21haW4gbmFtZSBvciBlbWFpbCBhZGRyZXNzLlxuICogQHBhcmFtIHtGdW5jdGlvbn0gY2FsbGJhY2sgVGhlIGZ1bmN0aW9uIHRoYXQgZ2V0cyBjYWxsZWQgZm9yIGV2ZXJ5XG4gKiBjaGFyYWN0ZXIuXG4gKiBAcmV0dXJucyB7U3RyaW5nfSBBIG5ldyBzdHJpbmcgb2YgY2hhcmFjdGVycyByZXR1cm5lZCBieSB0aGUgY2FsbGJhY2tcbiAqIGZ1bmN0aW9uLlxuICovXG5mdW5jdGlvbiBtYXBEb21haW4oZG9tYWluLCBjYWxsYmFjaykge1xuICAgIGNvbnN0IHBhcnRzID0gZG9tYWluLnNwbGl0KCdAJyk7XG4gICAgbGV0IHJlc3VsdCA9ICcnO1xuICAgIGlmIChwYXJ0cy5sZW5ndGggPiAxKSB7XG4gICAgICAgIC8vIEluIGVtYWlsIGFkZHJlc3Nlcywgb25seSB0aGUgZG9tYWluIG5hbWUgc2hvdWxkIGJlIHB1bnljb2RlZC4gTGVhdmVcbiAgICAgICAgLy8gdGhlIGxvY2FsIHBhcnQgKGkuZS4gZXZlcnl0aGluZyB1cCB0byBgQGApIGludGFjdC5cbiAgICAgICAgcmVzdWx0ID0gcGFydHNbMF0gKyAnQCc7XG4gICAgICAgIGRvbWFpbiA9IHBhcnRzWzFdO1xuICAgIH1cbiAgICAvLyBBdm9pZCBgc3BsaXQocmVnZXgpYCBmb3IgSUU4IGNvbXBhdGliaWxpdHkuIFNlZSAjMTcuXG4gICAgZG9tYWluID0gZG9tYWluLnJlcGxhY2UocmVnZXhTZXBhcmF0b3JzLCAnXFx4MkUnKTtcbiAgICBjb25zdCBsYWJlbHMgPSBkb21haW4uc3BsaXQoJy4nKTtcbiAgICBjb25zdCBlbmNvZGVkID0gbWFwKGxhYmVscywgY2FsbGJhY2spLmpvaW4oJy4nKTtcbiAgICByZXR1cm4gcmVzdWx0ICsgZW5jb2RlZDtcbn1cblxuLyoqXG4gKiBDcmVhdGVzIGFuIGFycmF5IGNvbnRhaW5pbmcgdGhlIG51bWVyaWMgY29kZSBwb2ludHMgb2YgZWFjaCBVbmljb2RlXG4gKiBjaGFyYWN0ZXIgaW4gdGhlIHN0cmluZy4gV2hpbGUgSmF2YVNjcmlwdCB1c2VzIFVDUy0yIGludGVybmFsbHksXG4gKiB0aGlzIGZ1bmN0aW9uIHdpbGwgY29udmVydCBhIHBhaXIgb2Ygc3Vycm9nYXRlIGhhbHZlcyAoZWFjaCBvZiB3aGljaFxuICogVUNTLTIgZXhwb3NlcyBhcyBzZXBhcmF0ZSBjaGFyYWN0ZXJzKSBpbnRvIGEgc2luZ2xlIGNvZGUgcG9pbnQsXG4gKiBtYXRjaGluZyBVVEYtMTYuXG4gKiBAc2VlIGBwdW55Y29kZS51Y3MyLmVuY29kZWBcbiAqIEBzZWUgPGh0dHBzOi8vbWF0aGlhc2J5bmVucy5iZS9ub3Rlcy9qYXZhc2NyaXB0LWVuY29kaW5nPlxuICogQG1lbWJlck9mIHB1bnljb2RlLnVjczJcbiAqIEBuYW1lIGRlY29kZVxuICogQHBhcmFtIHtTdHJpbmd9IHN0cmluZyBUaGUgVW5pY29kZSBpbnB1dCBzdHJpbmcgKFVDUy0yKS5cbiAqIEByZXR1cm5zIHtBcnJheX0gVGhlIG5ldyBhcnJheSBvZiBjb2RlIHBvaW50cy5cbiAqL1xuZnVuY3Rpb24gdWNzMmRlY29kZShzdHJpbmcpIHtcbiAgICBjb25zdCBvdXRwdXQgPSBbXTtcbiAgICBsZXQgY291bnRlciA9IDA7XG4gICAgY29uc3QgbGVuZ3RoID0gc3RyaW5nLmxlbmd0aDtcbiAgICB3aGlsZSAoY291bnRlciA8IGxlbmd0aCkge1xuICAgICAgICBjb25zdCB2YWx1ZSA9IHN0cmluZy5jaGFyQ29kZUF0KGNvdW50ZXIrKyk7XG4gICAgICAgIGlmICh2YWx1ZSA+PSAweGQ4MDAgJiYgdmFsdWUgPD0gMHhkYmZmICYmIGNvdW50ZXIgPCBsZW5ndGgpIHtcbiAgICAgICAgICAgIC8vIEl0J3MgYSBoaWdoIHN1cnJvZ2F0ZSwgYW5kIHRoZXJlIGlzIGEgbmV4dCBjaGFyYWN0ZXIuXG4gICAgICAgICAgICBjb25zdCBleHRyYSA9IHN0cmluZy5jaGFyQ29kZUF0KGNvdW50ZXIrKyk7XG4gICAgICAgICAgICBpZiAoKGV4dHJhICYgMHhmYzAwKSA9PSAweGRjMDApIHtcbiAgICAgICAgICAgICAgICAvLyBMb3cgc3Vycm9nYXRlLlxuICAgICAgICAgICAgICAgIG91dHB1dC5wdXNoKCgodmFsdWUgJiAweDNmZikgPDwgMTApICsgKGV4dHJhICYgMHgzZmYpICsgMHgxMDAwMCk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIEl0J3MgYW4gdW5tYXRjaGVkIHN1cnJvZ2F0ZTsgb25seSBhcHBlbmQgdGhpcyBjb2RlIHVuaXQsIGluIGNhc2UgdGhlXG4gICAgICAgICAgICAgICAgLy8gbmV4dCBjb2RlIHVuaXQgaXMgdGhlIGhpZ2ggc3Vycm9nYXRlIG9mIGEgc3Vycm9nYXRlIHBhaXIuXG4gICAgICAgICAgICAgICAgb3V0cHV0LnB1c2godmFsdWUpO1xuICAgICAgICAgICAgICAgIGNvdW50ZXItLTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIG91dHB1dC5wdXNoKHZhbHVlKTtcbiAgICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gb3V0cHV0O1xufVxuXG4vKipcbiAqIENyZWF0ZXMgYSBzdHJpbmcgYmFzZWQgb24gYW4gYXJyYXkgb2YgbnVtZXJpYyBjb2RlIHBvaW50cy5cbiAqIEBzZWUgYHB1bnljb2RlLnVjczIuZGVjb2RlYFxuICogQG1lbWJlck9mIHB1bnljb2RlLnVjczJcbiAqIEBuYW1lIGVuY29kZVxuICogQHBhcmFtIHtBcnJheX0gY29kZVBvaW50cyBUaGUgYXJyYXkgb2YgbnVtZXJpYyBjb2RlIHBvaW50cy5cbiAqIEByZXR1cm5zIHtTdHJpbmd9IFRoZSBuZXcgVW5pY29kZSBzdHJpbmcgKFVDUy0yKS5cbiAqL1xuY29uc3QgdWNzMmVuY29kZSA9IGNvZGVQb2ludHMgPT4gU3RyaW5nLmZyb21Db2RlUG9pbnQoLi4uY29kZVBvaW50cyk7XG5cbi8qKlxuICogQ29udmVydHMgYSBiYXNpYyBjb2RlIHBvaW50IGludG8gYSBkaWdpdC9pbnRlZ2VyLlxuICogQHNlZSBgZGlnaXRUb0Jhc2ljKClgXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtOdW1iZXJ9IGNvZGVQb2ludCBUaGUgYmFzaWMgbnVtZXJpYyBjb2RlIHBvaW50IHZhbHVlLlxuICogQHJldHVybnMge051bWJlcn0gVGhlIG51bWVyaWMgdmFsdWUgb2YgYSBiYXNpYyBjb2RlIHBvaW50IChmb3IgdXNlIGluXG4gKiByZXByZXNlbnRpbmcgaW50ZWdlcnMpIGluIHRoZSByYW5nZSBgMGAgdG8gYGJhc2UgLSAxYCwgb3IgYGJhc2VgIGlmXG4gKiB0aGUgY29kZSBwb2ludCBkb2VzIG5vdCByZXByZXNlbnQgYSB2YWx1ZS5cbiAqL1xuY29uc3QgYmFzaWNUb0RpZ2l0ID0gZnVuY3Rpb24gKGNvZGVQb2ludCkge1xuICAgIGlmIChjb2RlUG9pbnQgPj0gMHgzMCAmJiBjb2RlUG9pbnQgPCAweDNhKSB7XG4gICAgICAgIHJldHVybiAyNiArIChjb2RlUG9pbnQgLSAweDMwKTtcbiAgICB9XG4gICAgaWYgKGNvZGVQb2ludCA+PSAweDQxICYmIGNvZGVQb2ludCA8IDB4NWIpIHtcbiAgICAgICAgcmV0dXJuIGNvZGVQb2ludCAtIDB4NDE7XG4gICAgfVxuICAgIGlmIChjb2RlUG9pbnQgPj0gMHg2MSAmJiBjb2RlUG9pbnQgPCAweDdiKSB7XG4gICAgICAgIHJldHVybiBjb2RlUG9pbnQgLSAweDYxO1xuICAgIH1cbiAgICByZXR1cm4gYmFzZTtcbn07XG5cbi8qKlxuICogQ29udmVydHMgYSBkaWdpdC9pbnRlZ2VyIGludG8gYSBiYXNpYyBjb2RlIHBvaW50LlxuICogQHNlZSBgYmFzaWNUb0RpZ2l0KClgXG4gKiBAcHJpdmF0ZVxuICogQHBhcmFtIHtOdW1iZXJ9IGRpZ2l0IFRoZSBudW1lcmljIHZhbHVlIG9mIGEgYmFzaWMgY29kZSBwb2ludC5cbiAqIEByZXR1cm5zIHtOdW1iZXJ9IFRoZSBiYXNpYyBjb2RlIHBvaW50IHdob3NlIHZhbHVlICh3aGVuIHVzZWQgZm9yXG4gKiByZXByZXNlbnRpbmcgaW50ZWdlcnMpIGlzIGBkaWdpdGAsIHdoaWNoIG5lZWRzIHRvIGJlIGluIHRoZSByYW5nZVxuICogYDBgIHRvIGBiYXNlIC0gMWAuIElmIGBmbGFnYCBpcyBub24temVybywgdGhlIHVwcGVyY2FzZSBmb3JtIGlzXG4gKiB1c2VkOyBlbHNlLCB0aGUgbG93ZXJjYXNlIGZvcm0gaXMgdXNlZC4gVGhlIGJlaGF2aW9yIGlzIHVuZGVmaW5lZFxuICogaWYgYGZsYWdgIGlzIG5vbi16ZXJvIGFuZCBgZGlnaXRgIGhhcyBubyB1cHBlcmNhc2UgZm9ybS5cbiAqL1xuY29uc3QgZGlnaXRUb0Jhc2ljID0gZnVuY3Rpb24gKGRpZ2l0LCBmbGFnKSB7XG4gICAgLy8gIDAuLjI1IG1hcCB0byBBU0NJSSBhLi56IG9yIEEuLlpcbiAgICAvLyAyNi4uMzUgbWFwIHRvIEFTQ0lJIDAuLjlcbiAgICByZXR1cm4gZGlnaXQgKyAyMiArIDc1ICogKGRpZ2l0IDwgMjYpIC0gKChmbGFnICE9IDApIDw8IDUpO1xufTtcblxuLyoqXG4gKiBCaWFzIGFkYXB0YXRpb24gZnVuY3Rpb24gYXMgcGVyIHNlY3Rpb24gMy40IG9mIFJGQyAzNDkyLlxuICogaHR0cHM6Ly90b29scy5pZXRmLm9yZy9odG1sL3JmYzM0OTIjc2VjdGlvbi0zLjRcbiAqIEBwcml2YXRlXG4gKi9cbmNvbnN0IGFkYXB0ID0gZnVuY3Rpb24gKGRlbHRhLCBudW1Qb2ludHMsIGZpcnN0VGltZSkge1xuICAgIGxldCBrID0gMDtcbiAgICBkZWx0YSA9IGZpcnN0VGltZSA/IGZsb29yKGRlbHRhIC8gZGFtcCkgOiBkZWx0YSA+PiAxO1xuICAgIGRlbHRhICs9IGZsb29yKGRlbHRhIC8gbnVtUG9pbnRzKTtcbiAgICBmb3IgKDsgLyogbm8gaW5pdGlhbGl6YXRpb24gKi8gZGVsdGEgPiAoYmFzZU1pbnVzVE1pbiAqIHRNYXgpID4+IDE7IGsgKz0gYmFzZSkge1xuICAgICAgICBkZWx0YSA9IGZsb29yKGRlbHRhIC8gYmFzZU1pbnVzVE1pbik7XG4gICAgfVxuICAgIHJldHVybiBmbG9vcihrICsgKChiYXNlTWludXNUTWluICsgMSkgKiBkZWx0YSkgLyAoZGVsdGEgKyBza2V3KSk7XG59O1xuXG4vKipcbiAqIENvbnZlcnRzIGEgUHVueWNvZGUgc3RyaW5nIG9mIEFTQ0lJLW9ubHkgc3ltYm9scyB0byBhIHN0cmluZyBvZiBVbmljb2RlXG4gKiBzeW1ib2xzLlxuICogQG1lbWJlck9mIHB1bnljb2RlXG4gKiBAcGFyYW0ge1N0cmluZ30gaW5wdXQgVGhlIFB1bnljb2RlIHN0cmluZyBvZiBBU0NJSS1vbmx5IHN5bWJvbHMuXG4gKiBAcmV0dXJucyB7U3RyaW5nfSBUaGUgcmVzdWx0aW5nIHN0cmluZyBvZiBVbmljb2RlIHN5bWJvbHMuXG4gKi9cbmNvbnN0IGRlY29kZSA9IGZ1bmN0aW9uIChpbnB1dCkge1xuICAgIC8vIERvbid0IHVzZSBVQ1MtMi5cbiAgICBjb25zdCBvdXRwdXQgPSBbXTtcbiAgICBjb25zdCBpbnB1dExlbmd0aCA9IGlucHV0Lmxlbmd0aDtcbiAgICBsZXQgaSA9IDA7XG4gICAgbGV0IG4gPSBpbml0aWFsTjtcbiAgICBsZXQgYmlhcyA9IGluaXRpYWxCaWFzO1xuXG4gICAgLy8gSGFuZGxlIHRoZSBiYXNpYyBjb2RlIHBvaW50czogbGV0IGBiYXNpY2AgYmUgdGhlIG51bWJlciBvZiBpbnB1dCBjb2RlXG4gICAgLy8gcG9pbnRzIGJlZm9yZSB0aGUgbGFzdCBkZWxpbWl0ZXIsIG9yIGAwYCBpZiB0aGVyZSBpcyBub25lLCB0aGVuIGNvcHlcbiAgICAvLyB0aGUgZmlyc3QgYmFzaWMgY29kZSBwb2ludHMgdG8gdGhlIG91dHB1dC5cblxuICAgIGxldCBiYXNpYyA9IGlucHV0Lmxhc3RJbmRleE9mKGRlbGltaXRlcik7XG4gICAgaWYgKGJhc2ljIDwgMCkge1xuICAgICAgICBiYXNpYyA9IDA7XG4gICAgfVxuXG4gICAgZm9yIChsZXQgaiA9IDA7IGogPCBiYXNpYzsgKytqKSB7XG4gICAgICAgIC8vIGlmIGl0J3Mgbm90IGEgYmFzaWMgY29kZSBwb2ludFxuICAgICAgICBpZiAoaW5wdXQuY2hhckNvZGVBdChqKSA+PSAweDgwKSB7XG4gICAgICAgICAgICBlcnJvcignbm90LWJhc2ljJyk7XG4gICAgICAgIH1cbiAgICAgICAgb3V0cHV0LnB1c2goaW5wdXQuY2hhckNvZGVBdChqKSk7XG4gICAgfVxuXG4gICAgLy8gTWFpbiBkZWNvZGluZyBsb29wOiBzdGFydCBqdXN0IGFmdGVyIHRoZSBsYXN0IGRlbGltaXRlciBpZiBhbnkgYmFzaWMgY29kZVxuICAgIC8vIHBvaW50cyB3ZXJlIGNvcGllZDsgc3RhcnQgYXQgdGhlIGJlZ2lubmluZyBvdGhlcndpc2UuXG5cbiAgICBmb3IgKGxldCBpbmRleCA9IGJhc2ljID4gMCA/IGJhc2ljICsgMSA6IDA7IGluZGV4IDwgaW5wdXRMZW5ndGggLyogbm8gZmluYWwgZXhwcmVzc2lvbiAqLzsgKSB7XG4gICAgICAgIC8vIGBpbmRleGAgaXMgdGhlIGluZGV4IG9mIHRoZSBuZXh0IGNoYXJhY3RlciB0byBiZSBjb25zdW1lZC5cbiAgICAgICAgLy8gRGVjb2RlIGEgZ2VuZXJhbGl6ZWQgdmFyaWFibGUtbGVuZ3RoIGludGVnZXIgaW50byBgZGVsdGFgLFxuICAgICAgICAvLyB3aGljaCBnZXRzIGFkZGVkIHRvIGBpYC4gVGhlIG92ZXJmbG93IGNoZWNraW5nIGlzIGVhc2llclxuICAgICAgICAvLyBpZiB3ZSBpbmNyZWFzZSBgaWAgYXMgd2UgZ28sIHRoZW4gc3VidHJhY3Qgb2ZmIGl0cyBzdGFydGluZ1xuICAgICAgICAvLyB2YWx1ZSBhdCB0aGUgZW5kIHRvIG9idGFpbiBgZGVsdGFgLlxuICAgICAgICBjb25zdCBvbGRpID0gaTtcbiAgICAgICAgZm9yIChsZXQgdyA9IDEsIGsgPSBiYXNlIC8qIG5vIGNvbmRpdGlvbiAqLzsgOyBrICs9IGJhc2UpIHtcbiAgICAgICAgICAgIGlmIChpbmRleCA+PSBpbnB1dExlbmd0aCkge1xuICAgICAgICAgICAgICAgIGVycm9yKCdpbnZhbGlkLWlucHV0Jyk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIGNvbnN0IGRpZ2l0ID0gYmFzaWNUb0RpZ2l0KGlucHV0LmNoYXJDb2RlQXQoaW5kZXgrKykpO1xuXG4gICAgICAgICAgICBpZiAoZGlnaXQgPj0gYmFzZSkge1xuICAgICAgICAgICAgICAgIGVycm9yKCdpbnZhbGlkLWlucHV0Jyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBpZiAoZGlnaXQgPiBmbG9vcigobWF4SW50IC0gaSkgLyB3KSkge1xuICAgICAgICAgICAgICAgIGVycm9yKCdvdmVyZmxvdycpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpICs9IGRpZ2l0ICogdztcbiAgICAgICAgICAgIGNvbnN0IHQgPSBrIDw9IGJpYXMgPyB0TWluIDogayA+PSBiaWFzICsgdE1heCA/IHRNYXggOiBrIC0gYmlhcztcblxuICAgICAgICAgICAgaWYgKGRpZ2l0IDwgdCkge1xuICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjb25zdCBiYXNlTWludXNUID0gYmFzZSAtIHQ7XG4gICAgICAgICAgICBpZiAodyA+IGZsb29yKG1heEludCAvIGJhc2VNaW51c1QpKSB7XG4gICAgICAgICAgICAgICAgZXJyb3IoJ292ZXJmbG93Jyk7XG4gICAgICAgICAgICB9XG5cbiAgICAgICAgICAgIHcgKj0gYmFzZU1pbnVzVDtcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IG91dCA9IG91dHB1dC5sZW5ndGggKyAxO1xuICAgICAgICBiaWFzID0gYWRhcHQoaSAtIG9sZGksIG91dCwgb2xkaSA9PSAwKTtcblxuICAgICAgICAvLyBgaWAgd2FzIHN1cHBvc2VkIHRvIHdyYXAgYXJvdW5kIGZyb20gYG91dGAgdG8gYDBgLFxuICAgICAgICAvLyBpbmNyZW1lbnRpbmcgYG5gIGVhY2ggdGltZSwgc28gd2UnbGwgZml4IHRoYXQgbm93OlxuICAgICAgICBpZiAoZmxvb3IoaSAvIG91dCkgPiBtYXhJbnQgLSBuKSB7XG4gICAgICAgICAgICBlcnJvcignb3ZlcmZsb3cnKTtcbiAgICAgICAgfVxuXG4gICAgICAgIG4gKz0gZmxvb3IoaSAvIG91dCk7XG4gICAgICAgIGkgJT0gb3V0O1xuXG4gICAgICAgIC8vIEluc2VydCBgbmAgYXQgcG9zaXRpb24gYGlgIG9mIHRoZSBvdXRwdXQuXG4gICAgICAgIG91dHB1dC5zcGxpY2UoaSsrLCAwLCBuKTtcbiAgICB9XG5cbiAgICByZXR1cm4gU3RyaW5nLmZyb21Db2RlUG9pbnQoLi4ub3V0cHV0KTtcbn07XG5cbi8qKlxuICogQ29udmVydHMgYSBzdHJpbmcgb2YgVW5pY29kZSBzeW1ib2xzIChlLmcuIGEgZG9tYWluIG5hbWUgbGFiZWwpIHRvIGFcbiAqIFB1bnljb2RlIHN0cmluZyBvZiBBU0NJSS1vbmx5IHN5bWJvbHMuXG4gKiBAbWVtYmVyT2YgcHVueWNvZGVcbiAqIEBwYXJhbSB7U3RyaW5nfSBpbnB1dCBUaGUgc3RyaW5nIG9mIFVuaWNvZGUgc3ltYm9scy5cbiAqIEByZXR1cm5zIHtTdHJpbmd9IFRoZSByZXN1bHRpbmcgUHVueWNvZGUgc3RyaW5nIG9mIEFTQ0lJLW9ubHkgc3ltYm9scy5cbiAqL1xuY29uc3QgZW5jb2RlID0gZnVuY3Rpb24gKGlucHV0KSB7XG4gICAgY29uc3Qgb3V0cHV0ID0gW107XG5cbiAgICAvLyBDb252ZXJ0IHRoZSBpbnB1dCBpbiBVQ1MtMiB0byBhbiBhcnJheSBvZiBVbmljb2RlIGNvZGUgcG9pbnRzLlxuICAgIGlucHV0ID0gdWNzMmRlY29kZShpbnB1dCk7XG5cbiAgICAvLyBDYWNoZSB0aGUgbGVuZ3RoLlxuICAgIGNvbnN0IGlucHV0TGVuZ3RoID0gaW5wdXQubGVuZ3RoO1xuXG4gICAgLy8gSW5pdGlhbGl6ZSB0aGUgc3RhdGUuXG4gICAgbGV0IG4gPSBpbml0aWFsTjtcbiAgICBsZXQgZGVsdGEgPSAwO1xuICAgIGxldCBiaWFzID0gaW5pdGlhbEJpYXM7XG5cbiAgICAvLyBIYW5kbGUgdGhlIGJhc2ljIGNvZGUgcG9pbnRzLlxuICAgIGZvciAoY29uc3QgY3VycmVudFZhbHVlIG9mIGlucHV0KSB7XG4gICAgICAgIGlmIChjdXJyZW50VmFsdWUgPCAweDgwKSB7XG4gICAgICAgICAgICBvdXRwdXQucHVzaChzdHJpbmdGcm9tQ2hhckNvZGUoY3VycmVudFZhbHVlKSk7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICBjb25zdCBiYXNpY0xlbmd0aCA9IG91dHB1dC5sZW5ndGg7XG4gICAgbGV0IGhhbmRsZWRDUENvdW50ID0gYmFzaWNMZW5ndGg7XG5cbiAgICAvLyBgaGFuZGxlZENQQ291bnRgIGlzIHRoZSBudW1iZXIgb2YgY29kZSBwb2ludHMgdGhhdCBoYXZlIGJlZW4gaGFuZGxlZDtcbiAgICAvLyBgYmFzaWNMZW5ndGhgIGlzIHRoZSBudW1iZXIgb2YgYmFzaWMgY29kZSBwb2ludHMuXG5cbiAgICAvLyBGaW5pc2ggdGhlIGJhc2ljIHN0cmluZyB3aXRoIGEgZGVsaW1pdGVyIHVubGVzcyBpdCdzIGVtcHR5LlxuICAgIGlmIChiYXNpY0xlbmd0aCkge1xuICAgICAgICBvdXRwdXQucHVzaChkZWxpbWl0ZXIpO1xuICAgIH1cblxuICAgIC8vIE1haW4gZW5jb2RpbmcgbG9vcDpcbiAgICB3aGlsZSAoaGFuZGxlZENQQ291bnQgPCBpbnB1dExlbmd0aCkge1xuICAgICAgICAvLyBBbGwgbm9uLWJhc2ljIGNvZGUgcG9pbnRzIDwgbiBoYXZlIGJlZW4gaGFuZGxlZCBhbHJlYWR5LiBGaW5kIHRoZSBuZXh0XG4gICAgICAgIC8vIGxhcmdlciBvbmU6XG4gICAgICAgIGxldCBtID0gbWF4SW50O1xuICAgICAgICBmb3IgKGNvbnN0IGN1cnJlbnRWYWx1ZSBvZiBpbnB1dCkge1xuICAgICAgICAgICAgaWYgKGN1cnJlbnRWYWx1ZSA+PSBuICYmIGN1cnJlbnRWYWx1ZSA8IG0pIHtcbiAgICAgICAgICAgICAgICBtID0gY3VycmVudFZhbHVlO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgLy8gSW5jcmVhc2UgYGRlbHRhYCBlbm91Z2ggdG8gYWR2YW5jZSB0aGUgZGVjb2RlcidzIDxuLGk+IHN0YXRlIHRvIDxtLDA+LFxuICAgICAgICAvLyBidXQgZ3VhcmQgYWdhaW5zdCBvdmVyZmxvdy5cbiAgICAgICAgY29uc3QgaGFuZGxlZENQQ291bnRQbHVzT25lID0gaGFuZGxlZENQQ291bnQgKyAxO1xuICAgICAgICBpZiAobSAtIG4gPiBmbG9vcigobWF4SW50IC0gZGVsdGEpIC8gaGFuZGxlZENQQ291bnRQbHVzT25lKSkge1xuICAgICAgICAgICAgZXJyb3IoJ292ZXJmbG93Jyk7XG4gICAgICAgIH1cblxuICAgICAgICBkZWx0YSArPSAobSAtIG4pICogaGFuZGxlZENQQ291bnRQbHVzT25lO1xuICAgICAgICBuID0gbTtcblxuICAgICAgICBmb3IgKGNvbnN0IGN1cnJlbnRWYWx1ZSBvZiBpbnB1dCkge1xuICAgICAgICAgICAgaWYgKGN1cnJlbnRWYWx1ZSA8IG4gJiYgKytkZWx0YSA+IG1heEludCkge1xuICAgICAgICAgICAgICAgIGVycm9yKCdvdmVyZmxvdycpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGN1cnJlbnRWYWx1ZSA9PT0gbikge1xuICAgICAgICAgICAgICAgIC8vIFJlcHJlc2VudCBkZWx0YSBhcyBhIGdlbmVyYWxpemVkIHZhcmlhYmxlLWxlbmd0aCBpbnRlZ2VyLlxuICAgICAgICAgICAgICAgIGxldCBxID0gZGVsdGE7XG4gICAgICAgICAgICAgICAgZm9yIChsZXQgayA9IGJhc2UgLyogbm8gY29uZGl0aW9uICovOyA7IGsgKz0gYmFzZSkge1xuICAgICAgICAgICAgICAgICAgICBjb25zdCB0ID0gayA8PSBiaWFzID8gdE1pbiA6IGsgPj0gYmlhcyArIHRNYXggPyB0TWF4IDogayAtIGJpYXM7XG4gICAgICAgICAgICAgICAgICAgIGlmIChxIDwgdCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgY29uc3QgcU1pbnVzVCA9IHEgLSB0O1xuICAgICAgICAgICAgICAgICAgICBjb25zdCBiYXNlTWludXNUID0gYmFzZSAtIHQ7XG4gICAgICAgICAgICAgICAgICAgIG91dHB1dC5wdXNoKHN0cmluZ0Zyb21DaGFyQ29kZShkaWdpdFRvQmFzaWModCArIChxTWludXNUICUgYmFzZU1pbnVzVCksIDApKSk7XG4gICAgICAgICAgICAgICAgICAgIHEgPSBmbG9vcihxTWludXNUIC8gYmFzZU1pbnVzVCk7XG4gICAgICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAgICAgb3V0cHV0LnB1c2goc3RyaW5nRnJvbUNoYXJDb2RlKGRpZ2l0VG9CYXNpYyhxLCAwKSkpO1xuICAgICAgICAgICAgICAgIGJpYXMgPSBhZGFwdChkZWx0YSwgaGFuZGxlZENQQ291bnRQbHVzT25lLCBoYW5kbGVkQ1BDb3VudCA9PT0gYmFzaWNMZW5ndGgpO1xuICAgICAgICAgICAgICAgIGRlbHRhID0gMDtcbiAgICAgICAgICAgICAgICArK2hhbmRsZWRDUENvdW50O1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgKytkZWx0YTtcbiAgICAgICAgKytuO1xuICAgIH1cbiAgICByZXR1cm4gb3V0cHV0LmpvaW4oJycpO1xufTtcblxuLyoqXG4gKiBDb252ZXJ0cyBhIFB1bnljb2RlIHN0cmluZyByZXByZXNlbnRpbmcgYSBkb21haW4gbmFtZSBvciBhbiBlbWFpbCBhZGRyZXNzXG4gKiB0byBVbmljb2RlLiBPbmx5IHRoZSBQdW55Y29kZWQgcGFydHMgb2YgdGhlIGlucHV0IHdpbGwgYmUgY29udmVydGVkLCBpLmUuXG4gKiBpdCBkb2Vzbid0IG1hdHRlciBpZiB5b3UgY2FsbCBpdCBvbiBhIHN0cmluZyB0aGF0IGhhcyBhbHJlYWR5IGJlZW5cbiAqIGNvbnZlcnRlZCB0byBVbmljb2RlLlxuICogQG1lbWJlck9mIHB1bnljb2RlXG4gKiBAcGFyYW0ge1N0cmluZ30gaW5wdXQgVGhlIFB1bnljb2RlZCBkb21haW4gbmFtZSBvciBlbWFpbCBhZGRyZXNzIHRvXG4gKiBjb252ZXJ0IHRvIFVuaWNvZGUuXG4gKiBAcmV0dXJucyB7U3RyaW5nfSBUaGUgVW5pY29kZSByZXByZXNlbnRhdGlvbiBvZiB0aGUgZ2l2ZW4gUHVueWNvZGVcbiAqIHN0cmluZy5cbiAqL1xuY29uc3QgdG9Vbmljb2RlID0gZnVuY3Rpb24gKGlucHV0KSB7XG4gICAgcmV0dXJuIG1hcERvbWFpbihpbnB1dCwgZnVuY3Rpb24gKHN0cmluZykge1xuICAgICAgICByZXR1cm4gcmVnZXhQdW55Y29kZS50ZXN0KHN0cmluZykgPyBkZWNvZGUoc3RyaW5nLnNsaWNlKDQpLnRvTG93ZXJDYXNlKCkpIDogc3RyaW5nO1xuICAgIH0pO1xufTtcblxuLyoqXG4gKiBDb252ZXJ0cyBhIFVuaWNvZGUgc3RyaW5nIHJlcHJlc2VudGluZyBhIGRvbWFpbiBuYW1lIG9yIGFuIGVtYWlsIGFkZHJlc3MgdG9cbiAqIFB1bnljb2RlLiBPbmx5IHRoZSBub24tQVNDSUkgcGFydHMgb2YgdGhlIGRvbWFpbiBuYW1lIHdpbGwgYmUgY29udmVydGVkLFxuICogaS5lLiBpdCBkb2Vzbid0IG1hdHRlciBpZiB5b3UgY2FsbCBpdCB3aXRoIGEgZG9tYWluIHRoYXQncyBhbHJlYWR5IGluXG4gKiBBU0NJSS5cbiAqIEBtZW1iZXJPZiBwdW55Y29kZVxuICogQHBhcmFtIHtTdHJpbmd9IGlucHV0IFRoZSBkb21haW4gbmFtZSBvciBlbWFpbCBhZGRyZXNzIHRvIGNvbnZlcnQsIGFzIGFcbiAqIFVuaWNvZGUgc3RyaW5nLlxuICogQHJldHVybnMge1N0cmluZ30gVGhlIFB1bnljb2RlIHJlcHJlc2VudGF0aW9uIG9mIHRoZSBnaXZlbiBkb21haW4gbmFtZSBvclxuICogZW1haWwgYWRkcmVzcy5cbiAqL1xuY29uc3QgdG9BU0NJSSA9IGZ1bmN0aW9uIChpbnB1dCkge1xuICAgIHJldHVybiBtYXBEb21haW4oaW5wdXQsIGZ1bmN0aW9uIChzdHJpbmcpIHtcbiAgICAgICAgcmV0dXJuIHJlZ2V4Tm9uQVNDSUkudGVzdChzdHJpbmcpID8gJ3huLS0nICsgZW5jb2RlKHN0cmluZykgOiBzdHJpbmc7XG4gICAgfSk7XG59O1xuXG4vKi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tKi9cblxuLyoqIERlZmluZSB0aGUgcHVibGljIEFQSSAqL1xuY29uc3QgcHVueWNvZGUgPSB7XG4gICAgLyoqXG4gICAgICogQSBzdHJpbmcgcmVwcmVzZW50aW5nIHRoZSBjdXJyZW50IFB1bnljb2RlLmpzIHZlcnNpb24gbnVtYmVyLlxuICAgICAqIEBtZW1iZXJPZiBwdW55Y29kZVxuICAgICAqIEB0eXBlIFN0cmluZ1xuICAgICAqL1xuICAgIHZlcnNpb246ICcyLjMuMScsXG4gICAgLyoqXG4gICAgICogQW4gb2JqZWN0IG9mIG1ldGhvZHMgdG8gY29udmVydCBmcm9tIEphdmFTY3JpcHQncyBpbnRlcm5hbCBjaGFyYWN0ZXJcbiAgICAgKiByZXByZXNlbnRhdGlvbiAoVUNTLTIpIHRvIFVuaWNvZGUgY29kZSBwb2ludHMsIGFuZCBiYWNrLlxuICAgICAqIEBzZWUgPGh0dHBzOi8vbWF0aGlhc2J5bmVucy5iZS9ub3Rlcy9qYXZhc2NyaXB0LWVuY29kaW5nPlxuICAgICAqIEBtZW1iZXJPZiBwdW55Y29kZVxuICAgICAqIEB0eXBlIE9iamVjdFxuICAgICAqL1xuICAgIHVjczI6IHtcbiAgICAgICAgZGVjb2RlOiB1Y3MyZGVjb2RlLFxuICAgICAgICBlbmNvZGU6IHVjczJlbmNvZGVcbiAgICB9LFxuICAgIGRlY29kZTogZGVjb2RlLFxuICAgIGVuY29kZTogZW5jb2RlLFxuICAgIHRvQVNDSUk6IHRvQVNDSUksXG4gICAgdG9Vbmljb2RlOiB0b1VuaWNvZGVcbn07XG5cbm1vZHVsZS5leHBvcnRzID0gcHVueWNvZGU7XG4iXSwibmFtZXMiOltdLCJpZ25vcmVMaXN0IjpbMF0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/punycode/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/qp/index.js":
/*!*************************************************!*\
  !*** ./node_modules/nodemailer/lib/qp/index.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst Transform = (__webpack_require__(/*! stream */ \"stream\").Transform);\n\n/**\n * Encodes a Buffer into a Quoted-Printable encoded string\n *\n * @param {Buffer} buffer Buffer to convert\n * @returns {String} Quoted-Printable encoded string\n */\nfunction encode(buffer) {\n    if (typeof buffer === 'string') {\n        buffer = Buffer.from(buffer, 'utf-8');\n    }\n\n    // usable characters that do not need encoding\n    let ranges = [\n        // https://tools.ietf.org/html/rfc2045#section-6.7\n        [0x09], // <TAB>\n        [0x0a], // <LF>\n        [0x0d], // <CR>\n        [0x20, 0x3c], // <SP>!\"#$%&'()*+,-./0123456789:;\n        [0x3e, 0x7e] // >?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}\n    ];\n    let result = '';\n    let ord;\n\n    for (let i = 0, len = buffer.length; i < len; i++) {\n        ord = buffer[i];\n        // if the char is in allowed range, then keep as is, unless it is a WS in the end of a line\n        if (\n            checkRanges(ord, ranges) &&\n            !((ord === 0x20 || ord === 0x09) && (i === len - 1 || buffer[i + 1] === 0x0a || buffer[i + 1] === 0x0d))\n        ) {\n            result += String.fromCharCode(ord);\n            continue;\n        }\n        result += '=' + (ord < 0x10 ? '0' : '') + ord.toString(16).toUpperCase();\n    }\n\n    return result;\n}\n\n/**\n * Adds soft line breaks to a Quoted-Printable string\n *\n * @param {String} str Quoted-Printable encoded string that might need line wrapping\n * @param {Number} [lineLength=76] Maximum allowed length for a line\n * @returns {String} Soft-wrapped Quoted-Printable encoded string\n */\nfunction wrap(str, lineLength) {\n    str = (str || '').toString();\n    lineLength = lineLength || 76;\n\n    if (str.length <= lineLength) {\n        return str;\n    }\n\n    let pos = 0;\n    let len = str.length;\n    let match, code, line;\n    let lineMargin = Math.floor(lineLength / 3);\n    let result = '';\n\n    // insert soft linebreaks where needed\n    while (pos < len) {\n        line = str.substr(pos, lineLength);\n        if ((match = line.match(/\\r\\n/))) {\n            line = line.substr(0, match.index + match[0].length);\n            result += line;\n            pos += line.length;\n            continue;\n        }\n\n        if (line.substr(-1) === '\\n') {\n            // nothing to change here\n            result += line;\n            pos += line.length;\n            continue;\n        } else if ((match = line.substr(-lineMargin).match(/\\n.*?$/))) {\n            // truncate to nearest line break\n            line = line.substr(0, line.length - (match[0].length - 1));\n            result += line;\n            pos += line.length;\n            continue;\n        } else if (line.length > lineLength - lineMargin && (match = line.substr(-lineMargin).match(/[ \\t.,!?][^ \\t.,!?]*$/))) {\n            // truncate to nearest space\n            line = line.substr(0, line.length - (match[0].length - 1));\n        } else if (line.match(/[=][\\da-f]{0,2}$/i)) {\n            // push incomplete encoding sequences to the next line\n            if ((match = line.match(/[=][\\da-f]{0,1}$/i))) {\n                line = line.substr(0, line.length - match[0].length);\n            }\n\n            // ensure that utf-8 sequences are not split\n            while (\n                line.length > 3 &&\n                line.length < len - pos &&\n                !line.match(/^(?:=[\\da-f]{2}){1,4}$/i) &&\n                (match = line.match(/[=][\\da-f]{2}$/gi))\n            ) {\n                code = parseInt(match[0].substr(1, 2), 16);\n                if (code < 128) {\n                    break;\n                }\n\n                line = line.substr(0, line.length - 3);\n\n                if (code >= 0xc0) {\n                    break;\n                }\n            }\n        }\n\n        if (pos + line.length < len && line.substr(-1) !== '\\n') {\n            if (line.length === lineLength && line.match(/[=][\\da-f]{2}$/i)) {\n                line = line.substr(0, line.length - 3);\n            } else if (line.length === lineLength) {\n                line = line.substr(0, line.length - 1);\n            }\n            pos += line.length;\n            line += '=\\r\\n';\n        } else {\n            pos += line.length;\n        }\n\n        result += line;\n    }\n\n    return result;\n}\n\n/**\n * Helper function to check if a number is inside provided ranges\n *\n * @param {Number} nr Number to check for\n * @param {Array} ranges An Array of allowed values\n * @returns {Boolean} True if the value was found inside allowed ranges, false otherwise\n */\nfunction checkRanges(nr, ranges) {\n    for (let i = ranges.length - 1; i >= 0; i--) {\n        if (!ranges[i].length) {\n            continue;\n        }\n        if (ranges[i].length === 1 && nr === ranges[i][0]) {\n            return true;\n        }\n        if (ranges[i].length === 2 && nr >= ranges[i][0] && nr <= ranges[i][1]) {\n            return true;\n        }\n    }\n    return false;\n}\n\n/**\n * Creates a transform stream for encoding data to Quoted-Printable encoding\n *\n * @constructor\n * @param {Object} options Stream options\n * @param {Number} [options.lineLength=76] Maximum length for lines, set to false to disable wrapping\n */\nclass Encoder extends Transform {\n    constructor(options) {\n        super();\n\n        // init Transform\n        this.options = options || {};\n\n        if (this.options.lineLength !== false) {\n            this.options.lineLength = this.options.lineLength || 76;\n        }\n\n        this._curLine = '';\n\n        this.inputBytes = 0;\n        this.outputBytes = 0;\n    }\n\n    _transform(chunk, encoding, done) {\n        let qp;\n\n        if (encoding !== 'buffer') {\n            chunk = Buffer.from(chunk, encoding);\n        }\n\n        if (!chunk || !chunk.length) {\n            return done();\n        }\n\n        this.inputBytes += chunk.length;\n\n        if (this.options.lineLength) {\n            qp = this._curLine + encode(chunk);\n            qp = wrap(qp, this.options.lineLength);\n            qp = qp.replace(/(^|\\n)([^\\n]*)$/, (match, lineBreak, lastLine) => {\n                this._curLine = lastLine;\n                return lineBreak;\n            });\n\n            if (qp) {\n                this.outputBytes += qp.length;\n                this.push(qp);\n            }\n        } else {\n            qp = encode(chunk);\n            this.outputBytes += qp.length;\n            this.push(qp, 'ascii');\n        }\n\n        done();\n    }\n\n    _flush(done) {\n        if (this._curLine) {\n            this.outputBytes += this._curLine.length;\n            this.push(this._curLine, 'ascii');\n        }\n        done();\n    }\n}\n\n// expose to the world\nmodule.exports = {\n    encode,\n    wrap,\n    Encoder\n};\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiKHNzcikvLi9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvcXAvaW5kZXguanMiLCJtYXBwaW5ncyI6IkFBQWE7O0FBRWIsa0JBQWtCLHVEQUEyQjs7QUFFN0M7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLGFBQWEsUUFBUTtBQUNyQjtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0Esc0ZBQXNGO0FBQ3RGO0FBQ0E7QUFDQTs7QUFFQSx5Q0FBeUMsU0FBUztBQUNsRDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLFdBQVcsUUFBUTtBQUNuQixhQUFhLFFBQVE7QUFDckI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFVBQVU7QUFDVjtBQUNBO0FBQ0EsVUFBVSxnQ0FBZ0MsSUFBSTtBQUM5QztBQUNBLGdEQUFnRCxJQUFJO0FBQ3BEO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQSwwQ0FBMEMsRUFBRSxFQUFFLElBQUk7QUFDbEQsZ0RBQWdELEVBQUU7QUFDbEQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0EscUVBQXFFLEVBQUU7QUFDdkU7QUFDQSxjQUFjO0FBQ2Q7QUFDQTtBQUNBO0FBQ0E7QUFDQSxVQUFVO0FBQ1Y7QUFDQTs7QUFFQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0EsV0FBVyxRQUFRO0FBQ25CLFdBQVcsT0FBTztBQUNsQixhQUFhLFNBQVM7QUFDdEI7QUFDQTtBQUNBLG9DQUFvQyxRQUFRO0FBQzVDO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFdBQVcsUUFBUTtBQUNuQixXQUFXLFFBQVE7QUFDbkI7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7O0FBRUE7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBOztBQUVBO0FBQ0E7QUFDQTs7QUFFQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxhQUFhOztBQUViO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsVUFBVTtBQUNWO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIi9ob21lL2h4Y2tlci9EZXNrdG9wL2JldC9ub2RlX21vZHVsZXMvbm9kZW1haWxlci9saWIvcXAvaW5kZXguanMiXSwic291cmNlc0NvbnRlbnQiOlsiJ3VzZSBzdHJpY3QnO1xuXG5jb25zdCBUcmFuc2Zvcm0gPSByZXF1aXJlKCdzdHJlYW0nKS5UcmFuc2Zvcm07XG5cbi8qKlxuICogRW5jb2RlcyBhIEJ1ZmZlciBpbnRvIGEgUXVvdGVkLVByaW50YWJsZSBlbmNvZGVkIHN0cmluZ1xuICpcbiAqIEBwYXJhbSB7QnVmZmVyfSBidWZmZXIgQnVmZmVyIHRvIGNvbnZlcnRcbiAqIEByZXR1cm5zIHtTdHJpbmd9IFF1b3RlZC1QcmludGFibGUgZW5jb2RlZCBzdHJpbmdcbiAqL1xuZnVuY3Rpb24gZW5jb2RlKGJ1ZmZlcikge1xuICAgIGlmICh0eXBlb2YgYnVmZmVyID09PSAnc3RyaW5nJykge1xuICAgICAgICBidWZmZXIgPSBCdWZmZXIuZnJvbShidWZmZXIsICd1dGYtOCcpO1xuICAgIH1cblxuICAgIC8vIHVzYWJsZSBjaGFyYWN0ZXJzIHRoYXQgZG8gbm90IG5lZWQgZW5jb2RpbmdcbiAgICBsZXQgcmFuZ2VzID0gW1xuICAgICAgICAvLyBodHRwczovL3Rvb2xzLmlldGYub3JnL2h0bWwvcmZjMjA0NSNzZWN0aW9uLTYuN1xuICAgICAgICBbMHgwOV0sIC8vIDxUQUI+XG4gICAgICAgIFsweDBhXSwgLy8gPExGPlxuICAgICAgICBbMHgwZF0sIC8vIDxDUj5cbiAgICAgICAgWzB4MjAsIDB4M2NdLCAvLyA8U1A+IVwiIyQlJicoKSorLC0uLzAxMjM0NTY3ODk6O1xuICAgICAgICBbMHgzZSwgMHg3ZV0gLy8gPj9AQUJDREVGR0hJSktMTU5PUFFSU1RVVldYWVpbXFxdXl9gYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXp7fH1cbiAgICBdO1xuICAgIGxldCByZXN1bHQgPSAnJztcbiAgICBsZXQgb3JkO1xuXG4gICAgZm9yIChsZXQgaSA9IDAsIGxlbiA9IGJ1ZmZlci5sZW5ndGg7IGkgPCBsZW47IGkrKykge1xuICAgICAgICBvcmQgPSBidWZmZXJbaV07XG4gICAgICAgIC8vIGlmIHRoZSBjaGFyIGlzIGluIGFsbG93ZWQgcmFuZ2UsIHRoZW4ga2VlcCBhcyBpcywgdW5sZXNzIGl0IGlzIGEgV1MgaW4gdGhlIGVuZCBvZiBhIGxpbmVcbiAgICAgICAgaWYgKFxuICAgICAgICAgICAgY2hlY2tSYW5nZXMob3JkLCByYW5nZXMpICYmXG4gICAgICAgICAgICAhKChvcmQgPT09IDB4MjAgfHwgb3JkID09PSAweDA5KSAmJiAoaSA9PT0gbGVuIC0gMSB8fCBidWZmZXJbaSArIDFdID09PSAweDBhIHx8IGJ1ZmZlcltpICsgMV0gPT09IDB4MGQpKVxuICAgICAgICApIHtcbiAgICAgICAgICAgIHJlc3VsdCArPSBTdHJpbmcuZnJvbUNoYXJDb2RlKG9yZCk7XG4gICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgfVxuICAgICAgICByZXN1bHQgKz0gJz0nICsgKG9yZCA8IDB4MTAgPyAnMCcgOiAnJykgKyBvcmQudG9TdHJpbmcoMTYpLnRvVXBwZXJDYXNlKCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHJlc3VsdDtcbn1cblxuLyoqXG4gKiBBZGRzIHNvZnQgbGluZSBicmVha3MgdG8gYSBRdW90ZWQtUHJpbnRhYmxlIHN0cmluZ1xuICpcbiAqIEBwYXJhbSB7U3RyaW5nfSBzdHIgUXVvdGVkLVByaW50YWJsZSBlbmNvZGVkIHN0cmluZyB0aGF0IG1pZ2h0IG5lZWQgbGluZSB3cmFwcGluZ1xuICogQHBhcmFtIHtOdW1iZXJ9IFtsaW5lTGVuZ3RoPTc2XSBNYXhpbXVtIGFsbG93ZWQgbGVuZ3RoIGZvciBhIGxpbmVcbiAqIEByZXR1cm5zIHtTdHJpbmd9IFNvZnQtd3JhcHBlZCBRdW90ZWQtUHJpbnRhYmxlIGVuY29kZWQgc3RyaW5nXG4gKi9cbmZ1bmN0aW9uIHdyYXAoc3RyLCBsaW5lTGVuZ3RoKSB7XG4gICAgc3RyID0gKHN0ciB8fCAnJykudG9TdHJpbmcoKTtcbiAgICBsaW5lTGVuZ3RoID0gbGluZUxlbmd0aCB8fCA3NjtcblxuICAgIGlmIChzdHIubGVuZ3RoIDw9IGxpbmVMZW5ndGgpIHtcbiAgICAgICAgcmV0dXJuIHN0cjtcbiAgICB9XG5cbiAgICBsZXQgcG9zID0gMDtcbiAgICBsZXQgbGVuID0gc3RyLmxlbmd0aDtcbiAgICBsZXQgbWF0Y2gsIGNvZGUsIGxpbmU7XG4gICAgbGV0IGxpbmVNYXJnaW4gPSBNYXRoLmZsb29yKGxpbmVMZW5ndGggLyAzKTtcbiAgICBsZXQgcmVzdWx0ID0gJyc7XG5cbiAgICAvLyBpbnNlcnQgc29mdCBsaW5lYnJlYWtzIHdoZXJlIG5lZWRlZFxuICAgIHdoaWxlIChwb3MgPCBsZW4pIHtcbiAgICAgICAgbGluZSA9IHN0ci5zdWJzdHIocG9zLCBsaW5lTGVuZ3RoKTtcbiAgICAgICAgaWYgKChtYXRjaCA9IGxpbmUubWF0Y2goL1xcclxcbi8pKSkge1xuICAgICAgICAgICAgbGluZSA9IGxpbmUuc3Vic3RyKDAsIG1hdGNoLmluZGV4ICsgbWF0Y2hbMF0ubGVuZ3RoKTtcbiAgICAgICAgICAgIHJlc3VsdCArPSBsaW5lO1xuICAgICAgICAgICAgcG9zICs9IGxpbmUubGVuZ3RoO1xuICAgICAgICAgICAgY29udGludWU7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAobGluZS5zdWJzdHIoLTEpID09PSAnXFxuJykge1xuICAgICAgICAgICAgLy8gbm90aGluZyB0byBjaGFuZ2UgaGVyZVxuICAgICAgICAgICAgcmVzdWx0ICs9IGxpbmU7XG4gICAgICAgICAgICBwb3MgKz0gbGluZS5sZW5ndGg7XG4gICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgfSBlbHNlIGlmICgobWF0Y2ggPSBsaW5lLnN1YnN0cigtbGluZU1hcmdpbikubWF0Y2goL1xcbi4qPyQvKSkpIHtcbiAgICAgICAgICAgIC8vIHRydW5jYXRlIHRvIG5lYXJlc3QgbGluZSBicmVha1xuICAgICAgICAgICAgbGluZSA9IGxpbmUuc3Vic3RyKDAsIGxpbmUubGVuZ3RoIC0gKG1hdGNoWzBdLmxlbmd0aCAtIDEpKTtcbiAgICAgICAgICAgIHJlc3VsdCArPSBsaW5lO1xuICAgICAgICAgICAgcG9zICs9IGxpbmUubGVuZ3RoO1xuICAgICAgICAgICAgY29udGludWU7XG4gICAgICAgIH0gZWxzZSBpZiAobGluZS5sZW5ndGggPiBsaW5lTGVuZ3RoIC0gbGluZU1hcmdpbiAmJiAobWF0Y2ggPSBsaW5lLnN1YnN0cigtbGluZU1hcmdpbikubWF0Y2goL1sgXFx0LiwhP11bXiBcXHQuLCE/XSokLykpKSB7XG4gICAgICAgICAgICAvLyB0cnVuY2F0ZSB0byBuZWFyZXN0IHNwYWNlXG4gICAgICAgICAgICBsaW5lID0gbGluZS5zdWJzdHIoMCwgbGluZS5sZW5ndGggLSAobWF0Y2hbMF0ubGVuZ3RoIC0gMSkpO1xuICAgICAgICB9IGVsc2UgaWYgKGxpbmUubWF0Y2goL1s9XVtcXGRhLWZdezAsMn0kL2kpKSB7XG4gICAgICAgICAgICAvLyBwdXNoIGluY29tcGxldGUgZW5jb2Rpbmcgc2VxdWVuY2VzIHRvIHRoZSBuZXh0IGxpbmVcbiAgICAgICAgICAgIGlmICgobWF0Y2ggPSBsaW5lLm1hdGNoKC9bPV1bXFxkYS1mXXswLDF9JC9pKSkpIHtcbiAgICAgICAgICAgICAgICBsaW5lID0gbGluZS5zdWJzdHIoMCwgbGluZS5sZW5ndGggLSBtYXRjaFswXS5sZW5ndGgpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICAvLyBlbnN1cmUgdGhhdCB1dGYtOCBzZXF1ZW5jZXMgYXJlIG5vdCBzcGxpdFxuICAgICAgICAgICAgd2hpbGUgKFxuICAgICAgICAgICAgICAgIGxpbmUubGVuZ3RoID4gMyAmJlxuICAgICAgICAgICAgICAgIGxpbmUubGVuZ3RoIDwgbGVuIC0gcG9zICYmXG4gICAgICAgICAgICAgICAgIWxpbmUubWF0Y2goL14oPzo9W1xcZGEtZl17Mn0pezEsNH0kL2kpICYmXG4gICAgICAgICAgICAgICAgKG1hdGNoID0gbGluZS5tYXRjaCgvWz1dW1xcZGEtZl17Mn0kL2dpKSlcbiAgICAgICAgICAgICkge1xuICAgICAgICAgICAgICAgIGNvZGUgPSBwYXJzZUludChtYXRjaFswXS5zdWJzdHIoMSwgMiksIDE2KTtcbiAgICAgICAgICAgICAgICBpZiAoY29kZSA8IDEyOCkge1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgICAgICB9XG5cbiAgICAgICAgICAgICAgICBsaW5lID0gbGluZS5zdWJzdHIoMCwgbGluZS5sZW5ndGggLSAzKTtcblxuICAgICAgICAgICAgICAgIGlmIChjb2RlID49IDB4YzApIHtcbiAgICAgICAgICAgICAgICAgICAgYnJlYWs7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgaWYgKHBvcyArIGxpbmUubGVuZ3RoIDwgbGVuICYmIGxpbmUuc3Vic3RyKC0xKSAhPT0gJ1xcbicpIHtcbiAgICAgICAgICAgIGlmIChsaW5lLmxlbmd0aCA9PT0gbGluZUxlbmd0aCAmJiBsaW5lLm1hdGNoKC9bPV1bXFxkYS1mXXsyfSQvaSkpIHtcbiAgICAgICAgICAgICAgICBsaW5lID0gbGluZS5zdWJzdHIoMCwgbGluZS5sZW5ndGggLSAzKTtcbiAgICAgICAgICAgIH0gZWxzZSBpZiAobGluZS5sZW5ndGggPT09IGxpbmVMZW5ndGgpIHtcbiAgICAgICAgICAgICAgICBsaW5lID0gbGluZS5zdWJzdHIoMCwgbGluZS5sZW5ndGggLSAxKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHBvcyArPSBsaW5lLmxlbmd0aDtcbiAgICAgICAgICAgIGxpbmUgKz0gJz1cXHJcXG4nO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgcG9zICs9IGxpbmUubGVuZ3RoO1xuICAgICAgICB9XG5cbiAgICAgICAgcmVzdWx0ICs9IGxpbmU7XG4gICAgfVxuXG4gICAgcmV0dXJuIHJlc3VsdDtcbn1cblxuLyoqXG4gKiBIZWxwZXIgZnVuY3Rpb24gdG8gY2hlY2sgaWYgYSBudW1iZXIgaXMgaW5zaWRlIHByb3ZpZGVkIHJhbmdlc1xuICpcbiAqIEBwYXJhbSB7TnVtYmVyfSBuciBOdW1iZXIgdG8gY2hlY2sgZm9yXG4gKiBAcGFyYW0ge0FycmF5fSByYW5nZXMgQW4gQXJyYXkgb2YgYWxsb3dlZCB2YWx1ZXNcbiAqIEByZXR1cm5zIHtCb29sZWFufSBUcnVlIGlmIHRoZSB2YWx1ZSB3YXMgZm91bmQgaW5zaWRlIGFsbG93ZWQgcmFuZ2VzLCBmYWxzZSBvdGhlcndpc2VcbiAqL1xuZnVuY3Rpb24gY2hlY2tSYW5nZXMobnIsIHJhbmdlcykge1xuICAgIGZvciAobGV0IGkgPSByYW5nZXMubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcbiAgICAgICAgaWYgKCFyYW5nZXNbaV0ubGVuZ3RoKSB7XG4gICAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgfVxuICAgICAgICBpZiAocmFuZ2VzW2ldLmxlbmd0aCA9PT0gMSAmJiBuciA9PT0gcmFuZ2VzW2ldWzBdKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICBpZiAocmFuZ2VzW2ldLmxlbmd0aCA9PT0gMiAmJiBuciA+PSByYW5nZXNbaV1bMF0gJiYgbnIgPD0gcmFuZ2VzW2ldWzFdKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gZmFsc2U7XG59XG5cbi8qKlxuICogQ3JlYXRlcyBhIHRyYW5zZm9ybSBzdHJlYW0gZm9yIGVuY29kaW5nIGRhdGEgdG8gUXVvdGVkLVByaW50YWJsZSBlbmNvZGluZ1xuICpcbiAqIEBjb25zdHJ1Y3RvclxuICogQHBhcmFtIHtPYmplY3R9IG9wdGlvbnMgU3RyZWFtIG9wdGlvbnNcbiAqIEBwYXJhbSB7TnVtYmVyfSBbb3B0aW9ucy5saW5lTGVuZ3RoPTc2XSBNYXhpbXVtIGxlbmd0aCBmb3IgbGluZXMsIHNldCB0byBmYWxzZSB0byBkaXNhYmxlIHdyYXBwaW5nXG4gKi9cbmNsYXNzIEVuY29kZXIgZXh0ZW5kcyBUcmFuc2Zvcm0ge1xuICAgIGNvbnN0cnVjdG9yKG9wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIoKTtcblxuICAgICAgICAvLyBpbml0IFRyYW5zZm9ybVxuICAgICAgICB0aGlzLm9wdGlvbnMgPSBvcHRpb25zIHx8IHt9O1xuXG4gICAgICAgIGlmICh0aGlzLm9wdGlvbnMubGluZUxlbmd0aCAhPT0gZmFsc2UpIHtcbiAgICAgICAgICAgIHRoaXMub3B0aW9ucy5saW5lTGVuZ3RoID0gdGhpcy5vcHRpb25zLmxpbmVMZW5ndGggfHwgNzY7XG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLl9jdXJMaW5lID0gJyc7XG5cbiAgICAgICAgdGhpcy5pbnB1dEJ5dGVzID0gMDtcbiAgICAgICAgdGhpcy5vdXRwdXRCeXRlcyA9IDA7XG4gICAgfVxuXG4gICAgX3RyYW5zZm9ybShjaHVuaywgZW5jb2RpbmcsIGRvbmUpIHtcbiAgICAgICAgbGV0IHFwO1xuXG4gICAgICAgIGlmIChlbmNvZGluZyAhPT0gJ2J1ZmZlcicpIHtcbiAgICAgICAgICAgIGNodW5rID0gQnVmZmVyLmZyb20oY2h1bmssIGVuY29kaW5nKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghY2h1bmsgfHwgIWNodW5rLmxlbmd0aCkge1xuICAgICAgICAgICAgcmV0dXJuIGRvbmUoKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuaW5wdXRCeXRlcyArPSBjaHVuay5sZW5ndGg7XG5cbiAgICAgICAgaWYgKHRoaXMub3B0aW9ucy5saW5lTGVuZ3RoKSB7XG4gICAgICAgICAgICBxcCA9IHRoaXMuX2N1ckxpbmUgKyBlbmNvZGUoY2h1bmspO1xuICAgICAgICAgICAgcXAgPSB3cmFwKHFwLCB0aGlzLm9wdGlvbnMubGluZUxlbmd0aCk7XG4gICAgICAgICAgICBxcCA9IHFwLnJlcGxhY2UoLyhefFxcbikoW15cXG5dKikkLywgKG1hdGNoLCBsaW5lQnJlYWssIGxhc3RMaW5lKSA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy5fY3VyTGluZSA9IGxhc3RMaW5lO1xuICAgICAgICAgICAgICAgIHJldHVybiBsaW5lQnJlYWs7XG4gICAgICAgICAgICB9KTtcblxuICAgICAgICAgICAgaWYgKHFwKSB7XG4gICAgICAgICAgICAgICAgdGhpcy5vdXRwdXRCeXRlcyArPSBxcC5sZW5ndGg7XG4gICAgICAgICAgICAgICAgdGhpcy5wdXNoKHFwKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHFwID0gZW5jb2RlKGNodW5rKTtcbiAgICAgICAgICAgIHRoaXMub3V0cHV0Qnl0ZXMgKz0gcXAubGVuZ3RoO1xuICAgICAgICAgICAgdGhpcy5wdXNoKHFwLCAnYXNjaWknKTtcbiAgICAgICAgfVxuXG4gICAgICAgIGRvbmUoKTtcbiAgICB9XG5cbiAgICBfZmx1c2goZG9uZSkge1xuICAgICAgICBpZiAodGhpcy5fY3VyTGluZSkge1xuICAgICAgICAgICAgdGhpcy5vdXRwdXRCeXRlcyArPSB0aGlzLl9jdXJMaW5lLmxlbmd0aDtcbiAgICAgICAgICAgIHRoaXMucHVzaCh0aGlzLl9jdXJMaW5lLCAnYXNjaWknKTtcbiAgICAgICAgfVxuICAgICAgICBkb25lKCk7XG4gICAgfVxufVxuXG4vLyBleHBvc2UgdG8gdGhlIHdvcmxkXG5tb2R1bGUuZXhwb3J0cyA9IHtcbiAgICBlbmNvZGUsXG4gICAgd3JhcCxcbiAgICBFbmNvZGVyXG59O1xuIl0sIm5hbWVzIjpbXSwiaWdub3JlTGlzdCI6WzBdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/qp/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/sendmail-transport/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/nodemailer/lib/sendmail-transport/index.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst spawn = (__webpack_require__(/*! child_process */ \"child_process\").spawn);\nconst packageData = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\n\n/**\n * Generates a Transport object for Sendmail\n *\n * Possible options can be the following:\n *\n *  * **path** optional path to sendmail binary\n *  * **newline** either 'windows' or 'unix'\n *  * **args** an array of arguments for the sendmail binary\n *\n * @constructor\n * @param {Object} optional config parameter for Sendmail\n */\nclass SendmailTransport {\n    constructor(options) {\n        options = options || {};\n\n        // use a reference to spawn for mocking purposes\n        this._spawn = spawn;\n\n        this.options = options || {};\n\n        this.name = 'Sendmail';\n        this.version = packageData.version;\n\n        this.path = 'sendmail';\n        this.args = false;\n        this.winbreak = false;\n\n        this.logger = shared.getLogger(this.options, {\n            component: this.options.component || 'sendmail'\n        });\n\n        if (options) {\n            if (typeof options === 'string') {\n                this.path = options;\n            } else if (typeof options === 'object') {\n                if (options.path) {\n                    this.path = options.path;\n                }\n                if (Array.isArray(options.args)) {\n                    this.args = options.args;\n                }\n                this.winbreak = ['win', 'windows', 'dos', '\\r\\n'].includes((options.newline || '').toString().toLowerCase());\n            }\n        }\n    }\n\n    /**\n     * <p>Compiles a mailcomposer message and forwards it to handler that sends it.</p>\n     *\n     * @param {Object} emailMessage MailComposer object\n     * @param {Function} callback Callback function to run when the sending is completed\n     */\n    send(mail, done) {\n        // Sendmail strips this header line by itself\n        mail.message.keepBcc = true;\n\n        let envelope = mail.data.envelope || mail.message.getEnvelope();\n        let messageId = mail.message.messageId();\n        let args;\n        let sendmail;\n        let returned;\n\n        const hasInvalidAddresses = []\n            .concat(envelope.from || [])\n            .concat(envelope.to || [])\n            .some(addr => /^-/.test(addr));\n        if (hasInvalidAddresses) {\n            return done(new Error('Can not send mail. Invalid envelope addresses.'));\n        }\n\n        if (this.args) {\n            // force -i to keep single dots\n            args = ['-i'].concat(this.args).concat(envelope.to);\n        } else {\n            args = ['-i'].concat(envelope.from ? ['-f', envelope.from] : []).concat(envelope.to);\n        }\n\n        let callback = err => {\n            if (returned) {\n                // ignore any additional responses, already done\n                return;\n            }\n            returned = true;\n            if (typeof done === 'function') {\n                if (err) {\n                    return done(err);\n                } else {\n                    return done(null, {\n                        envelope: mail.data.envelope || mail.message.getEnvelope(),\n                        messageId,\n                        response: 'Messages queued for delivery'\n                    });\n                }\n            }\n        };\n\n        try {\n            sendmail = this._spawn(this.path, args);\n        } catch (E) {\n            this.logger.error(\n                {\n                    err: E,\n                    tnx: 'spawn',\n                    messageId\n                },\n                'Error occurred while spawning sendmail. %s',\n                E.message\n            );\n            return callback(E);\n        }\n\n        if (sendmail) {\n            sendmail.on('error', err => {\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'spawn',\n                        messageId\n                    },\n                    'Error occurred when sending message %s. %s',\n                    messageId,\n                    err.message\n                );\n                callback(err);\n            });\n\n            sendmail.once('exit', code => {\n                if (!code) {\n                    return callback();\n                }\n                let err;\n                if (code === 127) {\n                    err = new Error('Sendmail command not found, process exited with code ' + code);\n                } else {\n                    err = new Error('Sendmail exited with code ' + code);\n                }\n\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'stdin',\n                        messageId\n                    },\n                    'Error sending message %s to sendmail. %s',\n                    messageId,\n                    err.message\n                );\n                callback(err);\n            });\n            sendmail.once('close', callback);\n\n            sendmail.stdin.on('error', err => {\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'stdin',\n                        messageId\n                    },\n                    'Error occurred when piping message %s to sendmail. %s',\n                    messageId,\n                    err.message\n                );\n                callback(err);\n            });\n\n            let recipients = [].concat(envelope.to || []);\n            if (recipients.length > 3) {\n                recipients.push('...and ' + recipients.splice(2).length + ' more');\n            }\n            this.logger.info(\n                {\n                    tnx: 'send',\n                    messageId\n                },\n                'Sending message %s to <%s>',\n                messageId,\n                recipients.join(', ')\n            );\n\n            let sourceStream = mail.message.createReadStream();\n            sourceStream.once('error', err => {\n                this.logger.error(\n                    {\n                        err,\n                        tnx: 'stdin',\n                        messageId\n                    },\n                    'Error occurred when generating message %s. %s',\n                    messageId,\n                    err.message\n                );\n                sendmail.kill('SIGINT'); // do not deliver the message\n                callback(err);\n            });\n\n            sourceStream.pipe(sendmail.stdin);\n        } else {\n            return callback(new Error('sendmail was not found'));\n        }\n    }\n}\n\nmodule.exports = SendmailTransport;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/sendmail-transport/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/ses-transport/index.js":
/*!************************************************************!*\
  !*** ./node_modules/nodemailer/lib/ses-transport/index.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst EventEmitter = __webpack_require__(/*! events */ \"events\");\nconst packageData = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\nconst LeWindows = __webpack_require__(/*! ../mime-node/le-windows */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/le-windows.js\");\nconst MimeNode = __webpack_require__(/*! ../mime-node */ \"(ssr)/./node_modules/nodemailer/lib/mime-node/index.js\");\n\n/**\n * Generates a Transport object for AWS SES\n *\n * @constructor\n * @param {Object} optional config parameter\n */\nclass SESTransport extends EventEmitter {\n    constructor(options) {\n        super();\n        options = options || {};\n\n        this.options = options || {};\n        this.ses = this.options.SES;\n\n        this.name = 'SESTransport';\n        this.version = packageData.version;\n\n        this.logger = shared.getLogger(this.options, {\n            component: this.options.component || 'ses-transport'\n        });\n    }\n\n    getRegion(cb) {\n        if (this.ses.sesClient.config && typeof this.ses.sesClient.config.region === 'function') {\n            // promise\n            return this.ses.sesClient.config\n                .region()\n                .then(region => cb(null, region))\n                .catch(err => cb(err));\n        }\n        return cb(null, false);\n    }\n\n    /**\n     * Compiles a mailcomposer message and forwards it to SES\n     *\n     * @param {Object} emailMessage MailComposer object\n     * @param {Function} callback Callback function to run when the sending is completed\n     */\n    send(mail, callback) {\n        let statObject = {\n            ts: Date.now(),\n            pending: true\n        };\n\n        let fromHeader = mail.message._headers.find(header => /^from$/i.test(header.key));\n        if (fromHeader) {\n            let mimeNode = new MimeNode('text/plain');\n            fromHeader = mimeNode._convertAddresses(mimeNode._parseAddresses(fromHeader.value));\n        }\n\n        let envelope = mail.data.envelope || mail.message.getEnvelope();\n        let messageId = mail.message.messageId();\n\n        let recipients = [].concat(envelope.to || []);\n        if (recipients.length > 3) {\n            recipients.push('...and ' + recipients.splice(2).length + ' more');\n        }\n        this.logger.info(\n            {\n                tnx: 'send',\n                messageId\n            },\n            'Sending message %s to <%s>',\n            messageId,\n            recipients.join(', ')\n        );\n\n        let getRawMessage = next => {\n            // do not use Message-ID and Date in DKIM signature\n            if (!mail.data._dkim) {\n                mail.data._dkim = {};\n            }\n            if (mail.data._dkim.skipFields && typeof mail.data._dkim.skipFields === 'string') {\n                mail.data._dkim.skipFields += ':date:message-id';\n            } else {\n                mail.data._dkim.skipFields = 'date:message-id';\n            }\n\n            let sourceStream = mail.message.createReadStream();\n            let stream = sourceStream.pipe(new LeWindows());\n            let chunks = [];\n            let chunklen = 0;\n\n            stream.on('readable', () => {\n                let chunk;\n                while ((chunk = stream.read()) !== null) {\n                    chunks.push(chunk);\n                    chunklen += chunk.length;\n                }\n            });\n\n            sourceStream.once('error', err => stream.emit('error', err));\n\n            stream.once('error', err => {\n                next(err);\n            });\n\n            stream.once('end', () => next(null, Buffer.concat(chunks, chunklen)));\n        };\n\n        setImmediate(() =>\n            getRawMessage((err, raw) => {\n                if (err) {\n                    this.logger.error(\n                        {\n                            err,\n                            tnx: 'send',\n                            messageId\n                        },\n                        'Failed creating message for %s. %s',\n                        messageId,\n                        err.message\n                    );\n                    statObject.pending = false;\n                    return callback(err);\n                }\n\n                let sesMessage = {\n                    Content: {\n                        Raw: {\n                            // required\n                            Data: raw // required\n                        }\n                    },\n                    FromEmailAddress: fromHeader ? fromHeader : envelope.from,\n                    Destination: {\n                        ToAddresses: envelope.to\n                    }\n                };\n\n                Object.keys(mail.data.ses || {}).forEach(key => {\n                    sesMessage[key] = mail.data.ses[key];\n                });\n\n                this.getRegion((err, region) => {\n                    if (err || !region) {\n                        region = 'us-east-1';\n                    }\n\n                    const command = new this.ses.SendEmailCommand(sesMessage);\n                    const sendPromise = this.ses.sesClient.send(command);\n\n                    sendPromise\n                        .then(data => {\n                            if (region === 'us-east-1') {\n                                region = 'email';\n                            }\n\n                            statObject.pending = true;\n                            callback(null, {\n                                envelope: {\n                                    from: envelope.from,\n                                    to: envelope.to\n                                },\n                                messageId: '<' + data.MessageId + (!/@/.test(data.MessageId) ? '@' + region + '.amazonses.com' : '') + '>',\n                                response: data.MessageId,\n                                raw\n                            });\n                        })\n                        .catch(err => {\n                            this.logger.error(\n                                {\n                                    err,\n                                    tnx: 'send'\n                                },\n                                'Send error for %s: %s',\n                                messageId,\n                                err.message\n                            );\n                            statObject.pending = false;\n                            callback(err);\n                        });\n                });\n            })\n        );\n    }\n\n    /**\n     * Verifies SES configuration\n     *\n     * @param {Function} callback Callback function\n     */\n    verify(callback) {\n        let promise;\n        if (!callback) {\n            promise = new Promise((resolve, reject) => {\n                callback = shared.callbackPromise(resolve, reject);\n            });\n        }\n\n        const cb = err => {\n            if (err && !['InvalidParameterValue', 'MessageRejected'].includes(err.code || err.Code || err.name)) {\n                return callback(err);\n            }\n            return callback(null, true);\n        };\n\n        const sesMessage = {\n            Content: {\n                Raw: {\n                    Data: Buffer.from('From: <invalid@invalid>\\r\\nTo: <invalid@invalid>\\r\\n Subject: Invalid\\r\\n\\r\\nInvalid')\n                }\n            },\n            FromEmailAddress: 'invalid@invalid',\n            Destination: {\n                ToAddresses: ['invalid@invalid']\n            }\n        };\n\n        this.getRegion((err, region) => {\n            if (err || !region) {\n                region = 'us-east-1';\n            }\n\n            const command = new this.ses.SendEmailCommand(sesMessage);\n            const sendPromise = this.ses.sesClient.send(command);\n\n            sendPromise.then(data => cb(null, data)).catch(err => cb(err));\n        });\n\n        return promise;\n    }\n}\n\nmodule.exports = SESTransport;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/ses-transport/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/shared/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/nodemailer/lib/shared/index.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("/* eslint no-console: 0 */\n\n\n\nconst urllib = __webpack_require__(/*! url */ \"url\");\nconst util = __webpack_require__(/*! util */ \"util\");\nconst fs = __webpack_require__(/*! fs */ \"fs\");\nconst nmfetch = __webpack_require__(/*! ../fetch */ \"(ssr)/./node_modules/nodemailer/lib/fetch/index.js\");\nconst dns = __webpack_require__(/*! dns */ \"dns\");\nconst net = __webpack_require__(/*! net */ \"net\");\nconst os = __webpack_require__(/*! os */ \"os\");\n\nconst DNS_TTL = 5 * 60 * 1000;\nconst CACHE_CLEANUP_INTERVAL = 30 * 1000; // Minimum 30 seconds between cleanups\nconst MAX_CACHE_SIZE = 1000; // Maximum number of entries in cache\n\nlet lastCacheCleanup = 0;\nmodule.exports._lastCacheCleanup = () => lastCacheCleanup;\nmodule.exports._resetCacheCleanup = () => {\n    lastCacheCleanup = 0;\n};\n\nlet networkInterfaces;\ntry {\n    networkInterfaces = os.networkInterfaces();\n} catch (_err) {\n    // fails on some systems\n}\n\nmodule.exports.networkInterfaces = networkInterfaces;\n\nconst isFamilySupported = (family, allowInternal) => {\n    let networkInterfaces = module.exports.networkInterfaces;\n    if (!networkInterfaces) {\n        // hope for the best\n        return true;\n    }\n\n    const familySupported =\n        // crux that replaces Object.values(networkInterfaces) as Object.values is not supported in nodejs v6\n        Object.keys(networkInterfaces)\n            .map(key => networkInterfaces[key])\n            // crux that replaces .flat() as it is not supported in older Node versions (v10 and older)\n            .reduce((acc, val) => acc.concat(val), [])\n            .filter(i => !i.internal || allowInternal)\n            .filter(i => i.family === 'IPv' + family || i.family === family).length > 0;\n\n    return familySupported;\n};\n\nconst resolver = (family, hostname, options, callback) => {\n    options = options || {};\n    const familySupported = isFamilySupported(family, options.allowInternalNetworkInterfaces);\n\n    if (!familySupported) {\n        return callback(null, []);\n    }\n\n    const resolver = dns.Resolver ? new dns.Resolver(options) : dns;\n    resolver['resolve' + family](hostname, (err, addresses) => {\n        if (err) {\n            switch (err.code) {\n                case dns.NODATA:\n                case dns.NOTFOUND:\n                case dns.NOTIMP:\n                case dns.SERVFAIL:\n                case dns.CONNREFUSED:\n                case dns.REFUSED:\n                case 'EAI_AGAIN':\n                    return callback(null, []);\n            }\n            return callback(err);\n        }\n        return callback(null, Array.isArray(addresses) ? addresses : [].concat(addresses || []));\n    });\n};\n\nconst dnsCache = (module.exports.dnsCache = new Map());\n\nconst formatDNSValue = (value, extra) => {\n    if (!value) {\n        return Object.assign({}, extra || {});\n    }\n\n    return Object.assign(\n        {\n            servername: value.servername,\n            host:\n                !value.addresses || !value.addresses.length\n                    ? null\n                    : value.addresses.length === 1\n                      ? value.addresses[0]\n                      : value.addresses[Math.floor(Math.random() * value.addresses.length)]\n        },\n        extra || {}\n    );\n};\n\nmodule.exports.resolveHostname = (options, callback) => {\n    options = options || {};\n\n    if (!options.host && options.servername) {\n        options.host = options.servername;\n    }\n\n    if (!options.host || net.isIP(options.host)) {\n        // nothing to do here\n        let value = {\n            addresses: [options.host],\n            servername: options.servername || false\n        };\n        return callback(\n            null,\n            formatDNSValue(value, {\n                cached: false\n            })\n        );\n    }\n\n    let cached;\n    if (dnsCache.has(options.host)) {\n        cached = dnsCache.get(options.host);\n\n        // Lazy cleanup with time throttling\n        const now = Date.now();\n        if (now - lastCacheCleanup > CACHE_CLEANUP_INTERVAL) {\n            lastCacheCleanup = now;\n\n            // Clean up expired entries\n            for (const [host, entry] of dnsCache.entries()) {\n                if (entry.expires && entry.expires < now) {\n                    dnsCache.delete(host);\n                }\n            }\n\n            // If cache is still too large, remove oldest entries\n            if (dnsCache.size > MAX_CACHE_SIZE) {\n                const toDelete = Math.floor(MAX_CACHE_SIZE * 0.1); // Remove 10% of entries\n                const keys = Array.from(dnsCache.keys()).slice(0, toDelete);\n                keys.forEach(key => dnsCache.delete(key));\n            }\n        }\n\n        if (!cached.expires || cached.expires >= now) {\n            return callback(\n                null,\n                formatDNSValue(cached.value, {\n                    cached: true\n                })\n            );\n        }\n    }\n\n    resolver(4, options.host, options, (err, addresses) => {\n        if (err) {\n            if (cached) {\n                dnsCache.set(options.host, {\n                    value: cached.value,\n                    expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                });\n\n                return callback(\n                    null,\n                    formatDNSValue(cached.value, {\n                        cached: true,\n                        error: err\n                    })\n                );\n            }\n            return callback(err);\n        }\n\n        if (addresses && addresses.length) {\n            let value = {\n                addresses,\n                servername: options.servername || options.host\n            };\n\n            dnsCache.set(options.host, {\n                value,\n                expires: Date.now() + (options.dnsTtl || DNS_TTL)\n            });\n\n            return callback(\n                null,\n                formatDNSValue(value, {\n                    cached: false\n                })\n            );\n        }\n\n        resolver(6, options.host, options, (err, addresses) => {\n            if (err) {\n                if (cached) {\n                    dnsCache.set(options.host, {\n                        value: cached.value,\n                        expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                    });\n\n                    return callback(\n                        null,\n                        formatDNSValue(cached.value, {\n                            cached: true,\n                            error: err\n                        })\n                    );\n                }\n                return callback(err);\n            }\n\n            if (addresses && addresses.length) {\n                let value = {\n                    addresses,\n                    servername: options.servername || options.host\n                };\n\n                dnsCache.set(options.host, {\n                    value,\n                    expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                });\n\n                return callback(\n                    null,\n                    formatDNSValue(value, {\n                        cached: false\n                    })\n                );\n            }\n\n            try {\n                dns.lookup(options.host, { all: true }, (err, addresses) => {\n                    if (err) {\n                        if (cached) {\n                            dnsCache.set(options.host, {\n                                value: cached.value,\n                                expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                            });\n\n                            return callback(\n                                null,\n                                formatDNSValue(cached.value, {\n                                    cached: true,\n                                    error: err\n                                })\n                            );\n                        }\n                        return callback(err);\n                    }\n\n                    let address = addresses\n                        ? addresses\n                              .filter(addr => isFamilySupported(addr.family))\n                              .map(addr => addr.address)\n                              .shift()\n                        : false;\n\n                    if (addresses && addresses.length && !address) {\n                        // there are addresses but none can be used\n                        console.warn(`Failed to resolve IPv${addresses[0].family} addresses with current network`);\n                    }\n\n                    if (!address && cached) {\n                        // nothing was found, fallback to cached value\n                        return callback(\n                            null,\n                            formatDNSValue(cached.value, {\n                                cached: true\n                            })\n                        );\n                    }\n\n                    let value = {\n                        addresses: address ? [address] : [options.host],\n                        servername: options.servername || options.host\n                    };\n\n                    dnsCache.set(options.host, {\n                        value,\n                        expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                    });\n\n                    return callback(\n                        null,\n                        formatDNSValue(value, {\n                            cached: false\n                        })\n                    );\n                });\n            } catch (_err) {\n                if (cached) {\n                    dnsCache.set(options.host, {\n                        value: cached.value,\n                        expires: Date.now() + (options.dnsTtl || DNS_TTL)\n                    });\n\n                    return callback(\n                        null,\n                        formatDNSValue(cached.value, {\n                            cached: true,\n                            error: err\n                        })\n                    );\n                }\n                return callback(err);\n            }\n        });\n    });\n};\n/**\n * Parses connection url to a structured configuration object\n *\n * @param {String} str Connection url\n * @return {Object} Configuration object\n */\nmodule.exports.parseConnectionUrl = str => {\n    str = str || '';\n    let options = {};\n\n    [urllib.parse(str, true)].forEach(url => {\n        let auth;\n\n        switch (url.protocol) {\n            case 'smtp:':\n                options.secure = false;\n                break;\n            case 'smtps:':\n                options.secure = true;\n                break;\n            case 'direct:':\n                options.direct = true;\n                break;\n        }\n\n        if (!isNaN(url.port) && Number(url.port)) {\n            options.port = Number(url.port);\n        }\n\n        if (url.hostname) {\n            options.host = url.hostname;\n        }\n\n        if (url.auth) {\n            auth = url.auth.split(':');\n\n            if (!options.auth) {\n                options.auth = {};\n            }\n\n            options.auth.user = auth.shift();\n            options.auth.pass = auth.join(':');\n        }\n\n        Object.keys(url.query || {}).forEach(key => {\n            let obj = options;\n            let lKey = key;\n            let value = url.query[key];\n\n            if (!isNaN(value)) {\n                value = Number(value);\n            }\n\n            switch (value) {\n                case 'true':\n                    value = true;\n                    break;\n                case 'false':\n                    value = false;\n                    break;\n            }\n\n            // tls is nested object\n            if (key.indexOf('tls.') === 0) {\n                lKey = key.substr(4);\n                if (!options.tls) {\n                    options.tls = {};\n                }\n                obj = options.tls;\n            } else if (key.indexOf('.') >= 0) {\n                // ignore nested properties besides tls\n                return;\n            }\n\n            if (!(lKey in obj)) {\n                obj[lKey] = value;\n            }\n        });\n    });\n\n    return options;\n};\n\nmodule.exports._logFunc = (logger, level, defaults, data, message, ...args) => {\n    let entry = {};\n\n    Object.keys(defaults || {}).forEach(key => {\n        if (key !== 'level') {\n            entry[key] = defaults[key];\n        }\n    });\n\n    Object.keys(data || {}).forEach(key => {\n        if (key !== 'level') {\n            entry[key] = data[key];\n        }\n    });\n\n    logger[level](entry, message, ...args);\n};\n\n/**\n * Returns a bunyan-compatible logger interface. Uses either provided logger or\n * creates a default console logger\n *\n * @param {Object} [options] Options object that might include 'logger' value\n * @return {Object} bunyan compatible logger\n */\nmodule.exports.getLogger = (options, defaults) => {\n    options = options || {};\n\n    let response = {};\n    let levels = ['trace', 'debug', 'info', 'warn', 'error', 'fatal'];\n\n    if (!options.logger) {\n        // use vanity logger\n        levels.forEach(level => {\n            response[level] = () => false;\n        });\n        return response;\n    }\n\n    let logger = options.logger;\n\n    if (options.logger === true) {\n        // create console logger\n        logger = createDefaultLogger(levels);\n    }\n\n    levels.forEach(level => {\n        response[level] = (data, message, ...args) => {\n            module.exports._logFunc(logger, level, defaults, data, message, ...args);\n        };\n    });\n\n    return response;\n};\n\n/**\n * Wrapper for creating a callback that either resolves or rejects a promise\n * based on input\n *\n * @param {Function} resolve Function to run if callback is called\n * @param {Function} reject Function to run if callback ends with an error\n */\nmodule.exports.callbackPromise = (resolve, reject) =>\n    function () {\n        let args = Array.from(arguments);\n        let err = args.shift();\n        if (err) {\n            reject(err);\n        } else {\n            resolve(...args);\n        }\n    };\n\nmodule.exports.parseDataURI = uri => {\n    if (typeof uri !== 'string') {\n        return null;\n    }\n\n    // Early return for non-data URIs to avoid unnecessary processing\n    if (!uri.startsWith('data:')) {\n        return null;\n    }\n\n    // Find the first comma safely - this prevents ReDoS\n    const commaPos = uri.indexOf(',');\n    if (commaPos === -1) {\n        return null;\n    }\n\n    const data = uri.substring(commaPos + 1);\n    const metaStr = uri.substring('data:'.length, commaPos);\n\n    let encoding;\n    const metaEntries = metaStr.split(';');\n\n    if (metaEntries.length > 0) {\n        const lastEntry = metaEntries[metaEntries.length - 1].toLowerCase().trim();\n        // Only recognize valid encoding types to prevent manipulation\n        if (['base64', 'utf8', 'utf-8'].includes(lastEntry) && lastEntry.indexOf('=') === -1) {\n            encoding = lastEntry;\n            metaEntries.pop();\n        }\n    }\n\n    const contentType = metaEntries.length > 0 ? metaEntries.shift() : 'application/octet-stream';\n    const params = {};\n\n    for (let i = 0; i < metaEntries.length; i++) {\n        const entry = metaEntries[i];\n        const sepPos = entry.indexOf('=');\n        if (sepPos > 0) {\n            // Ensure there's a key before the '='\n            const key = entry.substring(0, sepPos).trim();\n            const value = entry.substring(sepPos + 1).trim();\n            if (key) {\n                params[key] = value;\n            }\n        }\n    }\n\n    // Decode data based on encoding with proper error handling\n    let bufferData;\n    try {\n        if (encoding === 'base64') {\n            bufferData = Buffer.from(data, 'base64');\n        } else {\n            try {\n                bufferData = Buffer.from(decodeURIComponent(data));\n            } catch (_decodeError) {\n                bufferData = Buffer.from(data);\n            }\n        }\n    } catch (_bufferError) {\n        bufferData = Buffer.alloc(0);\n    }\n\n    return {\n        data: bufferData,\n        encoding: encoding || null,\n        contentType: contentType || 'application/octet-stream',\n        params\n    };\n};\n\n/**\n * Resolves a String or a Buffer value for content value. Useful if the value\n * is a Stream or a file or an URL. If the value is a Stream, overwrites\n * the stream object with the resolved value (you can't stream a value twice).\n *\n * This is useful when you want to create a plugin that needs a content value,\n * for example the `html` or `text` value as a String or a Buffer but not as\n * a file path or an URL.\n *\n * @param {Object} data An object or an Array you want to resolve an element for\n * @param {String|Number} key Property name or an Array index\n * @param {Function} callback Callback function with (err, value)\n */\nmodule.exports.resolveContent = (data, key, callback) => {\n    let promise;\n\n    if (!callback) {\n        promise = new Promise((resolve, reject) => {\n            callback = module.exports.callbackPromise(resolve, reject);\n        });\n    }\n\n    let content = (data && data[key] && data[key].content) || data[key];\n    let contentStream;\n    let encoding = ((typeof data[key] === 'object' && data[key].encoding) || 'utf8')\n        .toString()\n        .toLowerCase()\n        .replace(/[-_\\s]/g, '');\n\n    if (!content) {\n        return callback(null, content);\n    }\n\n    if (typeof content === 'object') {\n        if (typeof content.pipe === 'function') {\n            return resolveStream(content, (err, value) => {\n                if (err) {\n                    return callback(err);\n                }\n                // we can't stream twice the same content, so we need\n                // to replace the stream object with the streaming result\n                if (data[key].content) {\n                    data[key].content = value;\n                } else {\n                    data[key] = value;\n                }\n                callback(null, value);\n            });\n        } else if (/^https?:\\/\\//i.test(content.path || content.href)) {\n            contentStream = nmfetch(content.path || content.href);\n            return resolveStream(contentStream, callback);\n        } else if (/^data:/i.test(content.path || content.href)) {\n            let parsedDataUri = module.exports.parseDataURI(content.path || content.href);\n\n            if (!parsedDataUri || !parsedDataUri.data) {\n                return callback(null, Buffer.from(0));\n            }\n            return callback(null, parsedDataUri.data);\n        } else if (content.path) {\n            return resolveStream(fs.createReadStream(content.path), callback);\n        }\n    }\n\n    if (typeof data[key].content === 'string' && !['utf8', 'usascii', 'ascii'].includes(encoding)) {\n        content = Buffer.from(data[key].content, encoding);\n    }\n\n    // default action, return as is\n    setImmediate(() => callback(null, content));\n\n    return promise;\n};\n\n/**\n * Copies properties from source objects to target objects\n */\nmodule.exports.assign = function (/* target, ... sources */) {\n    let args = Array.from(arguments);\n    let target = args.shift() || {};\n\n    args.forEach(source => {\n        Object.keys(source || {}).forEach(key => {\n            if (['tls', 'auth'].includes(key) && source[key] && typeof source[key] === 'object') {\n                // tls and auth are special keys that need to be enumerated separately\n                // other objects are passed as is\n                if (!target[key]) {\n                    // ensure that target has this key\n                    target[key] = {};\n                }\n                Object.keys(source[key]).forEach(subKey => {\n                    target[key][subKey] = source[key][subKey];\n                });\n            } else {\n                target[key] = source[key];\n            }\n        });\n    });\n    return target;\n};\n\nmodule.exports.encodeXText = str => {\n    // ! 0x21\n    // + 0x2B\n    // = 0x3D\n    // ~ 0x7E\n    if (!/[^\\x21-\\x2A\\x2C-\\x3C\\x3E-\\x7E]/.test(str)) {\n        return str;\n    }\n    let buf = Buffer.from(str);\n    let result = '';\n    for (let i = 0, len = buf.length; i < len; i++) {\n        let c = buf[i];\n        if (c < 0x21 || c > 0x7e || c === 0x2b || c === 0x3d) {\n            result += '+' + (c < 0x10 ? '0' : '') + c.toString(16).toUpperCase();\n        } else {\n            result += String.fromCharCode(c);\n        }\n    }\n    return result;\n};\n\n/**\n * Streams a stream value into a Buffer\n *\n * @param {Object} stream Readable stream\n * @param {Function} callback Callback function with (err, value)\n */\nfunction resolveStream(stream, callback) {\n    let responded = false;\n    let chunks = [];\n    let chunklen = 0;\n\n    stream.on('error', err => {\n        if (responded) {\n            return;\n        }\n\n        responded = true;\n        callback(err);\n    });\n\n    stream.on('readable', () => {\n        let chunk;\n        while ((chunk = stream.read()) !== null) {\n            chunks.push(chunk);\n            chunklen += chunk.length;\n        }\n    });\n\n    stream.on('end', () => {\n        if (responded) {\n            return;\n        }\n        responded = true;\n\n        let value;\n\n        try {\n            value = Buffer.concat(chunks, chunklen);\n        } catch (E) {\n            return callback(E);\n        }\n        callback(null, value);\n    });\n}\n\n/**\n * Generates a bunyan-like logger that prints to console\n *\n * @returns {Object} Bunyan logger instance\n */\nfunction createDefaultLogger(levels) {\n    let levelMaxLen = 0;\n    let levelNames = new Map();\n    levels.forEach(level => {\n        if (level.length > levelMaxLen) {\n            levelMaxLen = level.length;\n        }\n    });\n\n    levels.forEach(level => {\n        let levelName = level.toUpperCase();\n        if (levelName.length < levelMaxLen) {\n            levelName += ' '.repeat(levelMaxLen - levelName.length);\n        }\n        levelNames.set(level, levelName);\n    });\n\n    let print = (level, entry, message, ...args) => {\n        let prefix = '';\n        if (entry) {\n            if (entry.tnx === 'server') {\n                prefix = 'S: ';\n            } else if (entry.tnx === 'client') {\n                prefix = 'C: ';\n            }\n\n            if (entry.sid) {\n                prefix = '[' + entry.sid + '] ' + prefix;\n            }\n\n            if (entry.cid) {\n                prefix = '[#' + entry.cid + '] ' + prefix;\n            }\n        }\n\n        message = util.format(message, ...args);\n        message.split(/\\r?\\n/).forEach(line => {\n            console.log('[%s] %s %s', new Date().toISOString().substr(0, 19).replace(/T/, ' '), levelNames.get(level), prefix + line);\n        });\n    };\n\n    let logger = {};\n    levels.forEach(level => {\n        logger[level] = print.bind(null, level);\n    });\n\n    return logger;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/shared/index.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/smtp-connection/data-stream.js":
/*!********************************************************************!*\
  !*** ./node_modules/nodemailer/lib/smtp-connection/data-stream.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst stream = __webpack_require__(/*! stream */ \"stream\");\nconst Transform = stream.Transform;\n\n/**\n * Escapes dots in the beginning of lines. Ends the stream with <CR><LF>.<CR><LF>\n * Also makes sure that only <CR><LF> sequences are used for linebreaks\n *\n * @param {Object} options Stream options\n */\nclass DataStream extends Transform {\n    constructor(options) {\n        super(options);\n        // init Transform\n        this.options = options || {};\n        this._curLine = '';\n\n        this.inByteCount = 0;\n        this.outByteCount = 0;\n        this.lastByte = false;\n    }\n\n    /**\n     * Escapes dots\n     */\n    _transform(chunk, encoding, done) {\n        let chunks = [];\n        let chunklen = 0;\n        let i,\n            len,\n            lastPos = 0;\n        let buf;\n\n        if (!chunk || !chunk.length) {\n            return done();\n        }\n\n        if (typeof chunk === 'string') {\n            chunk = Buffer.from(chunk);\n        }\n\n        this.inByteCount += chunk.length;\n\n        for (i = 0, len = chunk.length; i < len; i++) {\n            if (chunk[i] === 0x2e) {\n                // .\n                if ((i && chunk[i - 1] === 0x0a) || (!i && (!this.lastByte || this.lastByte === 0x0a))) {\n                    buf = chunk.slice(lastPos, i + 1);\n                    chunks.push(buf);\n                    chunks.push(Buffer.from('.'));\n                    chunklen += buf.length + 1;\n                    lastPos = i + 1;\n                }\n            } else if (chunk[i] === 0x0a) {\n                // .\n                if ((i && chunk[i - 1] !== 0x0d) || (!i && this.lastByte !== 0x0d)) {\n                    if (i > lastPos) {\n                        buf = chunk.slice(lastPos, i);\n                        chunks.push(buf);\n                        chunklen += buf.length + 2;\n                    } else {\n                        chunklen += 2;\n                    }\n                    chunks.push(Buffer.from('\\r\\n'));\n                    lastPos = i + 1;\n                }\n            }\n        }\n\n        if (chunklen) {\n            // add last piece\n            if (lastPos < chunk.length) {\n                buf = chunk.slice(lastPos);\n                chunks.push(buf);\n                chunklen += buf.length;\n            }\n\n            this.outByteCount += chunklen;\n            this.push(Buffer.concat(chunks, chunklen));\n        } else {\n            this.outByteCount += chunk.length;\n            this.push(chunk);\n        }\n\n        this.lastByte = chunk[chunk.length - 1];\n        done();\n    }\n\n    /**\n     * Finalizes the stream with a dot on a single line\n     */\n    _flush(done) {\n        let buf;\n        if (this.lastByte === 0x0a) {\n            buf = Buffer.from('.\\r\\n');\n        } else if (this.lastByte === 0x0d) {\n            buf = Buffer.from('\\n.\\r\\n');\n        } else {\n            buf = Buffer.from('\\r\\n.\\r\\n');\n        }\n        this.outByteCount += buf.length;\n        this.push(buf);\n        done();\n    }\n}\n\nmodule.exports = DataStream;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/smtp-connection/data-stream.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/smtp-connection/http-proxy-client.js":
/*!**************************************************************************!*\
  !*** ./node_modules/nodemailer/lib/smtp-connection/http-proxy-client.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\n/**\n * Minimal HTTP/S proxy client\n */\n\nconst net = __webpack_require__(/*! net */ \"net\");\nconst tls = __webpack_require__(/*! tls */ \"tls\");\nconst urllib = __webpack_require__(/*! url */ \"url\");\n\n/**\n * Establishes proxied connection to destinationPort\n *\n * httpProxyClient(\"http://localhost:3128/\", 80, \"google.com\", function(err, socket){\n *     socket.write(\"GET / HTTP/1.0\\r\\n\\r\\n\");\n * });\n *\n * @param {String} proxyUrl proxy configuration, etg \"http://proxy.host:3128/\"\n * @param {Number} destinationPort Port to open in destination host\n * @param {String} destinationHost Destination hostname\n * @param {Function} callback Callback to run with the rocket object once connection is established\n */\nfunction httpProxyClient(proxyUrl, destinationPort, destinationHost, callback) {\n    let proxy = urllib.parse(proxyUrl);\n\n    // create a socket connection to the proxy server\n    let options;\n    let connect;\n    let socket;\n\n    options = {\n        host: proxy.hostname,\n        port: Number(proxy.port) ? Number(proxy.port) : proxy.protocol === 'https:' ? 443 : 80\n    };\n\n    if (proxy.protocol === 'https:') {\n        // we can use untrusted proxies as long as we verify actual SMTP certificates\n        options.rejectUnauthorized = false;\n        connect = tls.connect.bind(tls);\n    } else {\n        connect = net.connect.bind(net);\n    }\n\n    // Error harness for initial connection. Once connection is established, the responsibility\n    // to handle errors is passed to whoever uses this socket\n    let finished = false;\n    let tempSocketErr = err => {\n        if (finished) {\n            return;\n        }\n        finished = true;\n        try {\n            socket.destroy();\n        } catch (_E) {\n            // ignore\n        }\n        callback(err);\n    };\n\n    let timeoutErr = () => {\n        let err = new Error('Proxy socket timed out');\n        err.code = 'ETIMEDOUT';\n        tempSocketErr(err);\n    };\n\n    socket = connect(options, () => {\n        if (finished) {\n            return;\n        }\n\n        let reqHeaders = {\n            Host: destinationHost + ':' + destinationPort,\n            Connection: 'close'\n        };\n        if (proxy.auth) {\n            reqHeaders['Proxy-Authorization'] = 'Basic ' + Buffer.from(proxy.auth).toString('base64');\n        }\n\n        socket.write(\n            // HTTP method\n            'CONNECT ' +\n                destinationHost +\n                ':' +\n                destinationPort +\n                ' HTTP/1.1\\r\\n' +\n                // HTTP request headers\n                Object.keys(reqHeaders)\n                    .map(key => key + ': ' + reqHeaders[key])\n                    .join('\\r\\n') +\n                // End request\n                '\\r\\n\\r\\n'\n        );\n\n        let headers = '';\n        let onSocketData = chunk => {\n            let match;\n            let remainder;\n\n            if (finished) {\n                return;\n            }\n\n            headers += chunk.toString('binary');\n            if ((match = headers.match(/\\r\\n\\r\\n/))) {\n                socket.removeListener('data', onSocketData);\n\n                remainder = headers.substr(match.index + match[0].length);\n                headers = headers.substr(0, match.index);\n                if (remainder) {\n                    socket.unshift(Buffer.from(remainder, 'binary'));\n                }\n\n                // proxy connection is now established\n                finished = true;\n\n                // check response code\n                match = headers.match(/^HTTP\\/\\d+\\.\\d+ (\\d+)/i);\n                if (!match || (match[1] || '').charAt(0) !== '2') {\n                    try {\n                        socket.destroy();\n                    } catch (_E) {\n                        // ignore\n                    }\n                    return callback(new Error('Invalid response from proxy' + ((match && ': ' + match[1]) || '')));\n                }\n\n                socket.removeListener('error', tempSocketErr);\n                socket.removeListener('timeout', timeoutErr);\n                socket.setTimeout(0);\n\n                return callback(null, socket);\n            }\n        };\n        socket.on('data', onSocketData);\n    });\n\n    socket.setTimeout(httpProxyClient.timeout || 30 * 1000);\n    socket.on('timeout', timeoutErr);\n\n    socket.once('error', tempSocketErr);\n}\n\nmodule.exports = httpProxyClient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/nodemailer/lib/smtp-connection/http-proxy-client.js\n");

/***/ }),

/***/ "(ssr)/./node_modules/nodemailer/lib/smtp-connection/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/nodemailer/lib/smtp-connection/index.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("\n\nconst packageInfo = __webpack_require__(/*! ../../package.json */ \"(ssr)/./node_modules/nodemailer/package.json\");\nconst EventEmitter = (__webpack_require__(/*! events */ \"events\").EventEmitter);\nconst net = __webpack_require__(/*! net */ \"net\");\nconst tls = __webpack_require__(/*! tls */ \"tls\");\nconst os = __webpack_require__(/*! os */ \"os\");\nconst crypto = __webpack_require__(/*! crypto */ \"crypto\");\nconst DataStream = __webpack_require__(/*! ./data-stream */ \"(ssr)/./node_modules/nodemailer/lib/smtp-connection/data-stream.js\");\nconst PassThrough = (__webpack_require__(/*! stream */ \"stream\").PassThrough);\nconst shared = __webpack_require__(/*! ../shared */ \"(ssr)/./node_modules/nodemailer/lib/shared/index.js\");\n\n// default timeout values in ms\nconst CONNECTION_TIMEOUT = 2 * 60 * 1000; // how much to wait for the connection to be established\nconst SOCKET_TIMEOUT = 10 * 60 * 1000; // how much to wait for socket inactivity before disconnecting the client\nconst GREETING_TIMEOUT = 30 * 1000; // how much to wait after connection is established but SMTP greeting is not receieved\nconst DNS_TIMEOUT = 30 * 1000; // how much to wait for resolveHostname\n\n/**\n * Generates a SMTP connection object\n *\n * Optional options object takes the following possible properties:\n *\n *  * **port** - is the port to connect to (defaults to 587 or 465)\n *  * **host** - is the hostname or IP address to connect to (defaults to 'localhost')\n *  * **secure** - use SSL\n *  * **ignoreTLS** - ignore server support for STARTTLS\n *  * **requireTLS** - forces the client to use STARTTLS\n *  * **name** - the name of the client server\n *  * **localAddress** - outbound address to bind to (see: http://nodejs.org/api/net.html#net_net_connect_options_connectionlistener)\n *  * **greetingTimeout** - Time to wait in ms until greeting message is received from the server (defaults to 10000)\n *  * **connectionTimeout** - how many milliseconds to wait for the connection to establish\n *  * **socketTimeout** - Time of inactivity until the connection is closed (defaults to 1 hour)\n *  * **dnsTimeout** - Time to wait in ms for the DNS requests to be resolved (defaults to 30 seconds)\n *  * **lmtp** - if true, uses LMTP instead of SMTP protocol\n *  * **logger** - bunyan compatible logger interface\n *  * **debug** - if true pass SMTP traffic to the logger\n *  * **tls** - options for createCredentials\n *  * **socket** - existing socket to use instead of creating a new one (see: http://nodejs.org/api/net.html#net_class_net_socket)\n *  * **secured** - boolean indicates that the provided socket has already been upgraded to tls\n *\n * @constructor\n * @namespace SMTP Client module\n * @param {Object} [options] Option properties\n */\nclass SMTPConnection extends EventEmitter {\n    constructor(options) {\n        super(options);\n\n        this.id = crypto.randomBytes(8).toString('base64').replace(/\\W/g, '');\n        this.stage = 'init';\n\n        this.options = options || {};\n\n        this.secureConnection = !!this.options.secure;\n        this.alreadySecured = !!this.options.secured;\n\n        this.port = Number(this.options.port) || (this.secureConnection ? 465 : 587);\n        this.host = this.options.host || 'localhost';\n\n        this.servername = this.options.servername ? this.options.servername : !net.isIP(this.host) ? this.host : false;\n\n        this.allowInternalNetworkInterfaces = this.options.allowInternalNetworkInterfaces || false;\n\n        if (typeof this.options.secure === 'undefined' && this.port === 465) {\n            // if secure option is not set but port is 465, then default to secure\n            this.secureConnection = true;\n        }\n\n        this.name = this.options.name || this._getHostname();\n\n        this.logger = shared.getLogger(this.options, {\n            component: this.options.component || 'smtp-connection',\n            sid: this.id\n        });\n\n        this.customAuth = new Map();\n        Object.keys(this.options.customAuth || {}).forEach(key => {\n            let mapKey = (key || '').toString().trim().toUpperCase();\n            if (!mapKey) {\n                return;\n            }\n            this.customAuth.set(mapKey, this.options.customAuth[key]);\n        });\n\n        /**\n         * Expose version nr, just for the reference\n         * @type {String}\n         */\n        this.version = packageInfo.version;\n\n        /**\n         * If true, then the user is authenticated\n         * @type {Boolean}\n         */\n        this.authenticated = false;\n\n        /**\n         * If set to true, this instance is no longer active\n         * @private\n         */\n        this.destroyed = false;\n\n        /**\n         * Defines if the current connection is secure or not. If not,\n         * STARTTLS can be used if available\n         * @private\n         */\n        this.secure = !!this.secureConnection;\n\n        /**\n         * Store incomplete messages coming from the server\n         * @private\n         */\n        this._remainder = '';\n\n        /**\n         * Unprocessed responses from the server\n         * @type {Array}\n         */\n        this._responseQueue = [];\n\n        this.lastServerResponse = false;\n\n        /**\n         * The socket connecting to the server\n         * @public\n         */\n        this._socket = false;\n\n        /**\n         * Lists supported auth mechanisms\n         * @private\n         */\n        this._supportedAuth = [];\n\n        /**\n         * Set to true, if EHLO response includes \"AUTH\".\n         * If false then authentication is not tried\n         */\n        this.allowsAuth = false;\n\n        /**\n         * Includes current envelope (from, to)\n         * @private\n         */\n        this._envelope = false;\n\n        /**\n         * Lists supported extensions\n         * @private\n         */\n        this._supportedExtensions = [];\n\n        /**\n         * Defines the maximum allowed size for a single message\n         * @private\n         */\n        this._maxAllowedSize = 0;\n\n        /**\n         * Function queue to run if a data chunk comes from the server\n         * @private\n         */\n        this._responseActions = [];\n        this._recipientQueue = [];\n\n        /**\n         * Timeout variable for waiting the greeting\n         * @private\n         */\n        this._greetingTimeout = false;\n\n        /**\n         * Timeout variable for waiting the connection to start\n         * @private\n         */\n        this._connectionTimeout = false;\n\n        /**\n         * If the socket is deemed already closed\n         * @private\n         */\n        this._destroyed = false;\n\n        /**\n         * If the socket is already being closed\n         * @private\n         */\n        this._closing = false;\n\n        /**\n         * Callbacks for socket's listeners\n         */\n        this._onSocketData = chunk => this._onData(chunk);\n        this._onSocketError = error => this._onError(error, 'ESOCKET', false, 'CONN');\n        this._onSocketClose = () => this._onClose();\n        this._onSocketEnd = () => this._onEnd();\n        this._onSocketTimeout = () => this._onTimeout();\n    }\n\n    /**\n     * Creates a connection to a SMTP server and sets up connection\n     * listener\n     */\n    connect(connectCallback) {\n        if (typeof connectCallback === 'function') {\n            this.once('connect', () => {\n                this.logger.debug(\n                    {\n                        tnx: 'smtp'\n                    },\n                    'SMTP handshake finished'\n                );\n                connectCallback();\n            });\n\n            const isDestroyedMessage = this._isDestroyedMessage('connect');\n            if (isDestroyedMessage) {\n                return connectCallback(this._formatError(isDestroyedMessage, 'ECONNECTION', false, 'CONN'));\n            }\n        }\n\n        let opts = {\n            port: this.port,\n            host: this.host,\n            allowInternalNetworkInterfaces: this.allowInternalNetworkInterfaces,\n            timeout: this.options.dnsTimeout || DNS_TIMEOUT\n        };\n\n        if (this.options.localAddress) {\n            opts.localAddress = this.options.localAddress;\n        }\n\n        let setupConnectionHandlers = () => {\n            this._connectionTimeout = setTimeout(() => {\n                this._onError('Connection timeout', 'ETIMEDOUT', false, 'CONN');\n            }, this.options.connectionTimeout || CONNECTION_TIMEOUT);\n\n            this._socket.on('error', this._onSocketError);\n        };\n\n        if (this.options.connection) {\n            // connection is already opened\n            this._socket = this.options.connection;\n            setupConnectionHandlers();\n\n            if (this.secureConnection && !this.alreadySecured) {\n                setImmediate(() =>\n                    this._upgradeConnection(err => {\n                        if (err) {\n                            this._onError(new Error('Error initiating TLS - ' + (err.message || err)), 'ETLS', false, 'CONN');\n                            return;\n                        }\n                        this._onConnect();\n                    })\n                );\n            } else {\n                setImmediate(() => this._onConnect());\n            }\n            return;\n        } else if (this.options.socket) {\n            // socket object is set up but not yet connected\n            this._socket = this.options.socket;\n            return shared.resolveHostname(opts, (err, resolved) => {\n                if (err) {\n                    return setImmediate(() => this._onError(err, 'EDNS', false, 'CONN'));\n                }\n                this.logger.debug(\n                    {\n                        tnx: 'dns',\n                        source: opts.host,\n                        resolved: resolved.host,\n                        cached: !!resolved.cached\n                    },\n                    'Resolved %s as %s [cache %s]',\n                    opts.host,\n                    resolved.host,\n                    resolved.cached ? 'hit' : 'miss'\n                );\n                Object.keys(resolved).forEach(key => {\n                    if (key.charAt(0) !== '_' && resolved[key]) {\n                        opts[key] = resolved[key];\n                    }\n                });\n                try {\n                    this._socket.connect(this.port, this.host, () => {\n                        this._socket.setKeepAlive(true);\n                        this._onConnect();\n                    });\n                    setupConnectionHandlers();\n                } catch (E) {\n                    return setImmediate(() => this._onError(E, 'ECONNECTION', false, 'CONN'));\n                }\n            });\n        } else if (this.secureConnection) {\n            // connect using tls\n            if (this.options.tls) {\n                Object.keys(this.options.tls).forEach(key => {\n                    opts[key] = this.options.tls[key];\n                });\n            }\n\n            // ensure servername for SNI\n            if (this.servername && !opts.servername) {\n                opts.servername = this.servername;\n            }\n\n            return shared.resolveHostname(opts, (err, resolved) => {\n                if (err) {\n                    return setImmediate(() => this._onError(err, 'EDNS', false, 'CONN'));\n                }\n                this.logger.debug(\n                    {\n                        tnx: 'dns',\n                        source: opts.host,\n                        resolved: resolved.host,\n                        cached: !!resolved.cached\n                    },\n                    'Resolved %s as %s [cache %s]',\n                    opts.host,\n                    resolved.host,\n                    resolved.cached ? 'hit' : 'miss'\n                );\n                Object.keys(resolved).forEach(key => {\n                    if (key.charAt(0) !== '_' && resolved[key]) {\n                        opts[key] = resolved[key];\n                    }\n                });\n                try {\n                    this._socket = tls.connect(opts, () => {\n                        this._socket.setKeepAlive(true);\n                        this._onConnect();\n                    });\n                    setupConnectionHandlers();\n                } catch (E) {\n                    return setImmediate(() => this._onError(E, 'ECONNECTION', false, 'CONN'));\n                }\n            });\n        } else {\n            // connect using plaintext\n            return shared.resolveHostname(opts, (err, resolved) => {\n                if (err) {\n                    return setImmediate(() => this._onError(err, 'EDNS', false, 'CONN'));\n                }\n                this.logger.debug(\n                    {\n                        tnx: 'dns',\n                        source: opts.host,\n                        resolved: resolved.host,\n                        cached: !!resolved.cached\n                    },\n                    'Resolved %s as %s [cache %s]',\n                    opts.host,\n                    resolved.host,\n                    resolved.cached ? 'hit' : 'miss'\n                );\n                Object.keys(resolved).forEach(key => {\n                    if (key.charAt(0) !== '_' && resolved[key]) {\n                        opts[key] = resolved[key];\n                    }\n                });\n                try {\n                    this._socket = net.connect(opts, () => {\n                        this._socket.setKeepAlive(true);\n                        this._onConnect();\n                    });\n                    setupConnectionHandlers();\n                } catch (E) {\n                    return setImmediate(() => this._onError(E, 'ECONNECTION', false, 'CONN'));\n                }\n            });\n        }\n    }\n\n    /**\n     * Sends QUIT\n     */\n    quit() {\n        this._sendCommand('QUIT');\n        this._responseActions.push(this.close);\n    }\n\n    /**\n     * Closes the connection to the server\n     */\n    close() {\n        clearTimeout(this._connectionTimeout);\n        clearTimeout(this._greetingTimeout);\n        this._responseActions = [];\n\n        // allow to run this function only once\n        if (this._closing) {\n            return;\n        }\n        this._closing = true;\n\n        let closeMethod = 'end';\n\n        if (this.stage === 'init') {\n            // Close the socket immediately when connection timed out\n            closeMethod = 'destroy';\n        }\n\n        this.logger.debug(\n            {\n                tnx: 'smtp'\n            },\n            'Closing connection to the server using \"%s\"',\n            closeMethod\n        );\n\n        let socket = (this._socket && this._socket.socket) || this._socket;\n\n        if (socket && !socket.destroyed) {\n            try {\n                socket[closeMethod]();\n            } catch (_E) {\n                // just ignore\n            }\n        }\n\n        this._destroy();\n    }\n\n    /**\n     * Authenticate user\n     */\n    login(authData, callback) {\n        const isDestroyedMessage = this._isDestroyedMessage('login');\n        if (isDestroyedMessage) {\n            return callback(this._formatError(isDestroyedMessage, 'ECONNECTION', false, 'API'));\n        }\n\n        this._auth = authData || {};\n        // Select SASL authentication method\n        this._authMethod = (this._auth.method || '').toString().trim().toUpperCase() || false;\n\n        if (!this._authMethod && this._auth.oauth2 && !this._auth.credentials) {\n            this._authMethod = 'XOAUTH2';\n        } else if (!this._authMethod || (this._authMethod === 'XOAUTH2' && !this._auth.oauth2)) {\n            // use first supported\n            this._authMethod = (this._supportedAuth[0] || 'PLAIN').toUpperCase().trim();\n        }\n\n        if (this._authMethod !== 'XOAUTH2' && (!this._auth.credentials || !this._auth.credentials.user || !this._auth.credentials.pass)) {\n            if ((this._auth.user && this._auth.pass) || this.customAuth.has(this._authMethod)) {\n                this._auth.credentials = {\n                    user: this._auth.user,\n                    pass: this._auth.pass,\n                    options: this._auth.options\n                };\n            } else {\n                return callback(this._formatError('Missing credentials for \"' + this._authMethod + '\"', 'EAUTH', false, 'API'));\n            }\n        }\n\n        if (this.customAuth.has(this._authMethod)) {\n            let handler = this.customAuth.get(this._authMethod);\n            let lastResponse;\n            let returned = false;\n\n            let resolve = () => {\n                if (returned) {\n                    return;\n                }\n                returned = true;\n                this.logger.info(\n                    {\n                        tnx: 'smtp',\n                        username: this._auth.user,\n                        action: 'authenticated',\n                        method: this._authMethod\n                    },\n                    'User %s authenticated',\n                    JSON.stringify(this._auth.user)\n                );\n                this.authenticated = true;\n                callback(null, true);\n            };\n\n            let reject = err => {\n                if (returned) {\n                    return;\n                }\n                returned = true;\n                callback(this._formatError(err, 'EAUTH', lastResponse, 'AUTH ' + this._authMethod));\n            };\n\n            let handlerResponse = handler({\n                auth: this._auth,\n                method: this._authMethod,\n\n                extensions: [].concat(this._supportedExtensions),\n                authMethods: [].concat(this._supportedAuth),\n                maxAllowedSize: this._maxAllowedSize || false,\n\n                sendCommand: (cmd, done) => {\n                    let promise;\n\n                    if (!done) {\n                        promise = new Promise((resolve, reject) => {\n                            done = shared.callbackPromise(resolve, reject);\n                        });\n                    }\n\n                    this._responseActions.push(str => {\n                        lastResponse = str;\n\n                        let codes = str.match(/^(\\d+)(?:\\s(\\d+\\.\\d+\\.\\d+))?\\s/);\n                        let data = {\n                            command: cmd,\n                            response: str\n                        };\n                        if (codes) {\n                            data.status = Number(codes[1]) || 0;\n                            if (codes[2]) {\n                                data.code = codes[2];\n                            }\n                            data.text = str.substr(codes[0].length);\n                        } else {\n                            data.text = str;\n                            data.status = 0; // just in case we need to perform numeric comparisons\n                        }\n                        done(null, data);\n                    });\n                    setImmediate(() => this._sendCommand(cmd));\n\n                    return promise;\n                },\n\n                resolve,\n                reject\n            });\n\n            if (handlerResponse && typeof handlerResponse.catch === 'function') {\n                // a promise was returned\n                handlerResponse.then(resolve).catch(reject);\n            }\n\n            return;\n        }\n\n        switch (this._authMethod) {\n            case 'XOAUTH2':\n                this._handleXOauth2Token(false, callback);\n                return;\n            case 'LOGIN':\n                this._responseActions.push(str => {\n                    this._actionAUTH_LOGIN_USER(str, callback);\n                });\n                this._sendCommand('AUTH LOGIN');\n                return;\n            case 'PLAIN':\n                this._responseActions.push(str => {\n                    this._actionAUTHComplete(str, callback);\n                });\n                this._sendCommand(\n                    'AUTH PLAIN ' +\n                        Buffer.from(\n                            //this._auth.user+'\\u0000'+\n                            '\\u0000' + // skip authorization identity as it causes problems with some servers\n                                this._auth.credentials.user +\n                                '\\u0000' +\n                                this._auth.credentials.pass,\n                            'utf-8'\n                        ).toString('base64'),\n                    // log entry without passwords\n                    'AUTH PLAIN ' +\n                        Buffer.from(\n                            //this._auth.user+'\\u0000'+\n                            '\\u0000' + // skip authorization identity as it causes problems with some servers\n                                this._auth.credentials.user +\n                                '\\u0000' +\n                                '/* secret */',\n                            'utf-8'\n                        ).toString('base64')\n                );\n                return;\n            case 'CRAM-MD5':\n                this._responseActions.push(str => {\n                    this._actionAUTH_CRAM_MD5(str, callback);\n                });\n                this._sendCommand('AUTH CRAM-MD5');\n                return;\n        }\n\n        return callback(this._formatError('Unknown authentication method \"' + this._authMethod + '\"', 'EAUTH', false, 'API'));\n    }\n\n    /**\n     * Sends a message\n     *\n     * @param {Object} envelope Envelope object, {from: addr, to: [addr]}\n     * @param {Object} message String, Buffer or a Stream\n     * @param {Function} callback Callback to return once sending is completed\n     */\n    send(envelope, message, done) {\n        if (!message) {\n            return done(this._formatError('Empty message', 'EMESSAGE', false, 'API'));\n        }\n\n        const isDestroyedMessage = this._isDestroyedMessage('send message');\n        if (isDestroyedMessage) {\n            return done(this._formatError(isDestroyedMessage, 'ECONNECTION', false, 'API'));\n        }\n\n        // reject larger messages than allowed\n        if (this._maxAllowedSize && envelope.size > this._maxAllowedSize) {\n            return setImmediate(() => {\n                done(this._formatError('Message size larger than allowed ' + this._maxAllowedSize, 'EMESSAGE', false, 'MAIL FROM'));\n            });\n        }\n\n        // ensure that callback is only called once\n        let returned = false;\n        let callback = function () {\n            if (returned) {\n                return;\n            }\n            returned = true;\n\n            done(...arguments);\n        };\n\n        if (typeof message.on === 'function') {\n            message.on('error', err => callback(this._formatError(err, 'ESTREAM', false, 'API')));\n        }\n\n        let startTime = Date.now();\n        this._setEnvelope(envelope, (err, info) => {\n            if (err) {\n                // create passthrough stream to consume to prevent OOM\n                let stream = new PassThrough();\n                if (typeof message.pipe === 'function') {\n                    message.pipe(stream);\n                } else {\n                    stream.write(message);\n                    stream.end();\n                }\n\n                return callback(err);\n            }\n            let envelopeTime = Date.now();\n            let stream = this._createSendStream((err, str) => {\n                if (err) {\n                    return callback(err);\n                }\n\n                info.envelopeTime = envelopeTime - startTime;\n                info.messageTime = Date.now() - envelopeTime;\n                info.messageSize = stream.outByteCount;\n                info.response = str;\n\n                return callback(null, info);\n            });\n            if (typeof message.pipe === 'function') {\n                message.pipe(stream);\n            } else {\n                stream.write(message);\n                stream.end();\n            }\n        });\n    }\n\n    /**\n     * Resets connection state\n     *\n     * @param {Function} callback Callback to return once connection is reset\n     */\n    reset(callback) {\n        this._sendCommand('RSET');\n        this._responseActions.push(str => {\n            if (str.charAt(0) !== '2') {\n                return callback(this._formatError('Could not reset session state. response=' + str, 'EPROTOCOL', str, 'RSET'));\n            }\n            this._envelope = false;\n            return callback(null, true);\n        });\n    }\n\n    /**\n     * Connection listener that is run when the connection to\n     * the server is opened\n     *\n     * @event\n     */\n    _onConnect() {\n        clearTimeout(this._connectionTimeout);\n\n        this.logger.info(\n            {\n                tnx: 'network',\n                localAddress: this._socket.localAddress,\n                localPort: this._socket.localPort,\n                remoteAddress: this._socket.remoteAddress,\n                remotePort: this._socket.remotePort\n            },\n            '%s established to %s:%s',\n            this.secure ? 'Secure connection' : 'Connection',\n            this._socket.remoteAddress,\n            this._socket.remotePort\n        );\n\n        if (this._destroyed) {\n            // Connection was established after we already had canceled it\n            this.close();\n            return;\n        }\n\n        this.stage = 'connected';\n\n        // clear existing listeners for the socket\n        this._socket.removeListener('data', this._onSocketData);\n        this._socket.removeListener('timeout', this._onSocketTimeout);\n        this._socket.removeListener('close', this._onSocketClose);\n        this._socket.removeListener('end', this._onSocketEnd);\n\n        this._socket.on('data', this._onSocketData);\n        this._socket.once('close', this._onSocketClose);\n        this._socket.once('end', this._onSocketEnd);\n\n        this._socket.setTimeout(this.options.socketTimeout || SOCKET_TIMEOUT);\n        this._socket.on('timeout', this._onSocketTimeout);\n\n        this._greetingTimeout = setTimeout(() => {\n            // if still waiting for greeting, give up\n            if (this._socket && !this._destroyed && this._responseActions[0] === this._actionGreeting) {\n                this._onError('Greeting never received', 'ETIMEDOUT', false, 'CONN');\n            }\n        }, this.options.greetingTimeout || GREETING_TIMEOUT);\n\n        this._responseActions.push(this._actionGreeting);\n\n        // we have a 'data' listener set up so resume socket if it was paused\n        this._socket.resume();\n    }\n\n    /**\n     * 'data' listener for data coming from the server\n     *\n     * @event\n     * @param {Buffer} chunk Data chunk coming from the server\n     */\n    _onData(chunk) {\n        if (this._destroyed || !chunk || !chunk.length) {\n            return;\n        }\n\n        let data = (chunk || '').toString('binary');\n        let lines = (this._remainder + data).split(/\\r?\\n/);\n        let lastline;\n\n        this._remainder = lines.pop();\n\n        for (let i = 0, len = lines.length; i < len; i++) {\n            if (this._responseQueue.length) {\n                lastline = this._responseQueue[this._responseQueue.length - 1];\n                if (/^\\d+-/.test(lastline.split('\\n').pop())) {\n                    this._responseQueue[this._responseQueue.length - 1] += '\\n' + lines[i];\n                    continue;\n                }\n            }\n            this._responseQueue.push(lines[i]);\n        }\n\n        if (this._responseQueue.length) {\n            lastline = this._responseQueue[this._responseQueue.length - 1];\n            if (/^\\d+-/.test(lastline.split('\\n').pop())) {\n                return;\n            }\n        }\n\n        this._processResponse();\n    }\n\n    /**\n     * 'error' listener for the socket\n     *\n     * @event\n     * @param {Error} err Error object\n     * @param {String} type Error name\n     */\n    _onError(err, type, data, command) {\n        clearTimeout(this._connectionTimeout);\n        clearTimeout(this._greetingTimeout);\n\n        if (this._destroyed) {\n            // just ignore, already closed\n            // this might happen when a socket is canceled because of reached timeout\n            // but the socket timeout error itself receives only after\n            return;\n        }\n\n        err = this._formatError(err, type, data, command);\n\n        this.logger.error(data, err.message);\n\n        this.emit('error', err);\n        this.close();\n    }\n\n    _formatError(message, type, response, command) {\n        let err;\n\n        if (/Error\\]$/i.test(Object.prototype.toString.call(message))) {\n            err = message;\n        } else {\n            err = new Error(message);\n        }\n\n        if (type && type !== 'Error') {\n            err.code = type;\n        }\n\n        if (response) {\n            err.response = response;\n            err.message += ': ' + response;\n        }\n\n        let responseCode = (typeof response === 'string' && Number((response.match(/^\\d+/) || [])[0])) || false;\n        if (responseCode) {\n            err.responseCode = responseCode;\n        }\n\n        if (command) {\n            err.command = command;\n        }\n\n        return err;\n    }\n\n    /**\n     * 'close' listener for the socket\n     *\n     * @event\n     */\n    _onClose() {\n        let serverResponse = false;\n\n        if (this._remainder && this._remainder.trim()) {\n            if (this.options.debug || this.options.transactionLog) {\n                this.logger.debug(\n                    {\n                        tnx: 'server'\n                    },\n                    this._remainder.replace(/\\r?\\n$/, '')\n                );\n            }\n            this.lastServerResponse = serverResponse = this._remainder.trim();\n        }\n\n        this.logger.info(\n            {\n                tnx: 'network'\n            },\n            'Connection closed'\n        );\n\n        if (this.upgrading && !this._destroyed) {\n            return this._onError(new Error('Connection closed unexpectedly'), 'ETLS', serverResponse, 'CONN');\n        } else if (![this._actionGreeting, this.close].includes(this._responseActions[0]) && !this._destroyed) {\n            return this._onError(new Error('Connection closed unexpectedly'), 'ECONNECTION', serverResponse, 'CONN');\n        } else if (/^[45]\\d{2}\\b/.test(serverResponse)) {\n            return this._onError(new Error('Connection closed unexpectedly'), 'ECONNECTION', serverResponse, 'CONN');\n        }\n\n        this._destroy();\n    }\n\n    /**\n     * 'end' listener for the socket\n     *\n     * @event\n     */\n    _onEnd() {\n        if (this._socket && !this._socket.destroyed) {\n            this._socket.destroy();\n        }\n    }\n\n    /**\n     * 'timeout' listener for the socket\n     *\n     * @event\n     */\n    _onTimeout() {\n        return this._onError(new Error('Timeout'), 'ETIMEDOUT', false, 'CONN');\n    }\n\n    /**\n     * Destroys the client, emits 'end'\n     */\n    _destroy() {\n        if (this._destroyed) {\n            return;\n        }\n        this._destroyed = true;\n        this.emit('end');\n    }\n\n    /**\n     * Upgrades the connection to TLS\n     *\n     * @param {Function} callback Callback function to run when the connection\n     *        has been secured\n     */\n    _upgradeConnection(callback) {\n        // do not remove all listeners or it breaks node v0.10 as there's\n        // apparently a 'finish' event set that would be cleared as well\n\n        // we can safely keep 'error', 'end', 'close' etc. events\n        this._socket.removeListener('data', this._onSocketData); // incoming data is going to be gibberish from this point onwards\n        this._socket.removeListener('timeout', this._onSocketTimeout); // timeout will be re-set for the new socket object\n\n        let socketPlain = this._socket;\n        let opts = {\n            socket: this._socket,\n            host: this.host\n        };\n\n        Object.keys(this.options.tls || {}).forEach(key => {\n            opts[key] = this.options.tls[key];\n        });\n\n        // ensure servername for SNI\n        if (this.servername && !opts.servername) {\n            opts.servername = this.servername;\n        }\n\n        this.upgrading = true;\n        // tls.connect is not an asynchronous function however it may still throw errors and requires to be wrapped with try/catch\n        try {\n            this._socket = tls.connect(opts, () => {\n                this.secure = true;\n                this.upgrading = false;\n                this._socket.on('data', this._onSocketData);\n\n                socketPlain.removeListener('close', this._onSocketClose);\n                socketPlain.removeListener('end', this._onSocketEnd);\n\n                return callback(null, true);\n            });\n        } catch (err) {\n            return callback(err);\n        }\n\n        this._socket.on('error', this._onSocketError);\n        this._socket.once('close', this._onSocketClose);\n        this._socket.once('end', this._onSocketEnd);\n\n        this._socket.setTimeout(this.options.socketTimeout || SOCKET_TIMEOUT); // 10 min.\n        this._socket.on('timeout', this._onSocketTimeout);\n\n        // resume in case the socket was paused\n        socketPlain.resume();\n    }\n\n    /**\n     * Processes queued responses from the server\n     *\n     * @param {Boolean} force If true, ignores _processing flag\n     */\n    _processResponse() {\n        if (!this._responseQueue.length) {\n            return false;\n        }\n\n        let str = (this.lastServerResponse = (this._responseQueue.shift() || '').toString());\n\n        if (/^\\d+-/.test(str.split('\\n').pop())) {\n            // keep waiting for the final part of multiline response\n            return;\n        }\n\n        if (this.options.debug || this.options.transactionLog) {\n            this.logger.debug(\n                {\n                    tnx: 'server'\n                },\n                str.replace(/\\r?\\n$/, '')\n            );\n        }\n\n        if (!str.trim()) {\n            // skip unexpected empty lines\n            setImmediate(() => this._processResponse());\n        }\n\n        let action = this._responseActions.shift();\n\n        if (typeof action === 'function') {\n            action.call(this, str);\n            setImmediate(() => this._processResponse());\n        } else {\n            return this._onError(new Error('Unexpected Response'), 'EPROTOCOL', str, 'CONN');\n        }\n    }\n\n    /**\n     * Send a command to the server, append \\r\\n\n     *\n     * @param {String} str String to be sent to the server\n     * @param {String} logStr Optional string to be used for logging instead of the actual string\n     */\n    _sendCommand(str, logStr) {\n        if (this._destroyed) {\n            // Connection already closed, can't send any more data\n            return;\n        }\n\n        if (this._socket.destroyed) {\n            return this.close();\n        }\n\n        if (this.options.debug || this.options.transactionLog) {\n            this.logger.debug(\n                {\n                    tnx: 'client'\n                },\n                (logStr || str || '').toString().replace(/\\r?\\n$/, '')\n            );\n        }\n\n        this._socket.write(Buffer.from(str + '\\r\\n', 'utf-8'));\n    }\n\n    /**\n     * Initiates a new message by submitting envelope data, starting with\n     * MAIL FROM: command\n     *\n     * @param {Object} envelope Envelope object in the form of\n     *        {from:'...', to:['...']}\n     *        or\n     *        {from:{address:'...',name:'...'}, to:[address:'...',name:'...']}\n     */\n    _setEnvelope(envelope, callback) {\n        let args = [];\n        let useSmtpUtf8 = false;\n\n        this._envelope = envelope || {};\n        this._envelope.from = ((this._envelope.from && this._envelope.from.address) || this._envelope.from || '').toString().trim();\n\n        this._envelope.to = [].concat(this._envelope.to || []).map(to => ((to && to.address) || to || '').toString().trim());\n\n        if (!this._envelope.to.length) {\n            return callback(this._formatError('No recipients defined', 'EENVELOPE', false, 'API'));\n        }\n\n        if (this._envelope.from && /[\\r\\n<>]/.test(this._envelope.from)) {\n            return callback(this._formatError('Invalid sender ' + JSON.stringify(this._envelope.from), 'EENVELOPE', false, 'API'));\n        }\n\n        // check if the sender address uses only ASCII characters,\n        // otherwise require usage of SMTPUTF8 extension\n        if (/[\\x80-\\uFFFF]/.test(this._envelope.from)) {\n            useSmtpUtf8 = true;\n        }\n\n        for (let i = 0, len = this._envelope.to.length; i < len; i++) {\n            if (!this._envelope.to[i] || /[\\r\\n<>]/.test(this._envelope.to[i])) {\n                return callback(this._formatError('Invalid recipient ' + JSON.stringify(this._envelope.to[i]), 'EENVELOPE', false, 'API'));\n            }\n\n            // check if the recipients addresses use only ASCII characters,\n            // otherwise require usage of SMTPUTF8 extension\n            if (/[\\x80-\\uFFFF]/.test(this._envelope.to[i])) {\n                useSmtpUtf8 = true;\n            }\n        }\n\n        // clone the recipients array for latter manipulation\n        this._envelope.rcptQueue = JSON.parse(JSON.stringify(this._envelope.to || []));\n        this._envelope.rejected = [];\n        this._envelope.rejectedErrors = [];\n        this._envelope.accepted = [];\n\n        if (this._envelope.dsn) {\n            try {\n                this._envelope.dsn = this._setDsnEnvelope(this._envelope.dsn);\n            } catch (err) {\n                return callback(this._formatError('Invalid DSN ' + err.message, 'EENVELOPE', false, 'API'));\n            }\n        }\n\n        this._responseActions.push(str => {\n            this._actionMAIL(str, callback);\n        });\n\n        // If the server supports SMTPUTF8 and the envelope includes an internationalized\n        // email address then append SMTPUTF8 keyword to the MAIL FROM command\n        if (useSmtpUtf8 && this._supportedExtensions.includes('SMTPUTF8')) {\n            args.push('SMTPUTF8');\n            this._usingSmtpUtf8 = true;\n        }\n\n        // If the server supports 8BITMIME and the message might contain non-ascii bytes\n        // then append the 8BITMIME keyword to the MAIL FROM command\n        if (this._envelope.use8BitMime && this._supportedExtensions.includes('8BITMIME')) {\n            args.push('BODY=8BITMIME');\n            this._using8BitMime = true;\n        }\n\n        if (this._envelope.size && this._supportedExtensions.includes('SIZE')) {\n            args.push('SIZE=' + this._envelope.size);\n        }\n\n        // If the server supports DSN and the envelope includes an DSN prop\n        // then append DSN params to the MAIL FROM command\n        if (this._envelope.dsn && this._supportedExtensions.includes('DSN')) {\n            if (this._envelope.dsn.ret) {\n                args.push('RET=' + shared.encodeXText(this._envelope.dsn.ret));\n            }\n            if (this._envelope.dsn.envid) {\n                args.push('ENVID=' + shared.encodeXText(this._envelope.dsn.envid));\n            }\n        }\n\n        this._sendCommand('MAIL FROM:<' + this._envelope.from + '>' + (args.length ? ' ' + args.join(' ') : ''));\n    }\n\n    _setDsnEnvelope(params) {\n        let ret = (params.ret || params.return || '').toString().toUpperCase() || null;\n        if (ret) {\n            switch (ret) {\n                case 'HDRS':\n                case 'HEADERS':\n                    ret = 'HDRS';\n                    break;\n                case 'FULL':\n                case 'BODY':\n                    ret = 'FULL';\n                    break;\n            }\n        }\n\n        if (ret && !['FULL', 'HDRS'].includes(ret)) {\n            throw new Error('ret: ' + JSON.stringify(ret));\n        }\n\n        let envid = (params.envid || params.id || '').toString() || null;\n\n        let notify = params.notify || null;\n        if (notify) {\n            if (typeof notify === 'string') {\n                notify = notify.split(',');\n            }\n            notify = notify.map(n => n.trim().toUpperCase());\n            let validNotify = ['NEVER', 'SUCCESS', 'FAILURE', 'DELAY'];\n            let invalidNotify = notify.filter(n => !validNotify.includes(n));\n            if (invalidNotify.length || (notify.length > 1 && notify.includes('NEVER'))) {\n                throw new Error('notify: ' + JSON.stringify(notify.join(',')));\n            }\n            notify = notify.join(',');\n        }\n\n        let orcpt = (params.recipient || params.orcpt || '').toString() || null;\n        if (orcpt && orcpt.indexOf(';') < 0) {\n            orcpt = 'rfc822;' + orcpt;\n        }\n\n        return {\n            ret,\n            envid,\n            notify,\n            orcpt\n        };\n    }\n\n    _getDsnRcptToArgs() {\n        let args = [];\n        // If the server supports DSN and the envelope includes an DSN prop\n        // then append DSN params to the RCPT TO command\n        if (this._envelope.dsn && this._supportedExtensions.includes('DSN')) {\n            if (this._envelope.dsn.notify) {\n                args.push('NOTIFY=' + shared.encodeXText(this._envelope.dsn.notify));\n            }\n            if (this._envelope.dsn.orcpt) {\n                args.push('ORCPT=' + shared.encodeXText(this._envelope.dsn.orcpt));\n            }\n        }\n        return args.length ? ' ' + args.join(' ') : '';\n    }\n\n    _createSendStream(callback) {\n        let dataStream = new DataStream();\n        let logStream;\n\n        if (this.options.lmtp) {\n            this._envelope.accepted.forEach((recipient, i) => {\n                let final = i === this._envelope.accepted.length - 1;\n                this._responseActions.push(str => {\n                    this._actionLMTPStream(recipient, final, str, callback);\n                });\n            });\n        } else {\n            this._responseActions.push(str => {\n                this._actionSMTPStream(str, callback);\n            });\n        }\n\n        dataStream.pipe(this._socket, {\n            end: false\n        });\n\n        if (this.options.debug) {\n            logStream = new PassThrough();\n            logStream.on('readable', () => {\n                let chunk;\n                while ((chunk = logStream.read())) {\n                    this.logger.debug(\n                        {\n                            tnx: 'message'\n                        },\n                        chunk.toString('binary').replace(/\\r?\\n$/, '')\n                    );\n                }\n            });\n            dataStream.pipe(logStream);\n        }\n\n        dataStream.once('end', () => {\n            this.logger.info(\n                {\n                    tnx: 'message',\n                    inByteCount: dataStream.inByteCount,\n                    outByteCount: dataStream.outByteCount\n                },\n                '<%s bytes encoded mime message (source size %s bytes)>',\n                dataStream.outByteCount,\n                dataStream.inByteCount\n            );\n        });\n\n        return dataStream;\n    }\n\n    /** ACTIONS **/\n\n    /**\n     * Will be run after the connection is created and the server sends\n     * a greeting. If the incoming message starts with 220 initiate\n     * SMTP session by sending EHLO command\n     *\n     * @param {String} str Message from the server\n     */\n    _actionGreeting(str) {\n        clearTimeout(this._greetingTimeout);\n\n        if (str.substr(0, 3) !== '220') {\n            this._onError(new Error('Invalid greeting. response=' + str), 'EPROTOCOL', str, 'CONN');\n            return;\n        }\n\n        if (this.options.lmtp) {\n            this._responseActions.push(this._actionLHLO);\n            this._sendCommand('LHLO ' + this.name);\n        } else {\n            this._responseActions.push(this._actionEHLO);\n            this._sendCommand('EHLO ' + this.name);\n        }\n    }\n\n    /**\n     * Handles server response for LHLO command. If it yielded in\n     * error, emit 'error', otherwise treat this as an EHLO response\n     *\n     * @param {String} str Message from the server\n     */\n    _actionLHLO(str) {\n        if (str.charAt(0) !== '2') {\n            this._onError(new Error('Invalid LHLO. response=' + str), 'EPROTOCOL', str, 'LHLO');\n            return;\n        }\n\n        this._actionEHLO(str);\n    }\n\n    /**\n     * Handles server response for EHLO command. If it yielded in\n     * error, try HELO instead, otherwise initiate TLS negotiation\n     * if STARTTLS is supported by the server or move into the\n     * authentication phase.\n     *\n     * @param {String} str Message from the server\n     */\n    _actionEHLO(str) {\n        let match;\n\n        if (str.substr(0, 3) === '421') {\n            this._onError(new Error('Server terminates connection. response=' + str), 'ECONNECTION', str, 'EHLO');\n            return;\n        }\n\n        if (str.charAt(0) !== '2') {\n            if (this.options.requireTLS) {\n                this._onError(\n                    new Error('EHLO failed but HELO does not support required STARTTLS. response=' + str),\n                    'ECONNECTION',\n                    str,\n                    'EHLO'\n                );\n                return;\n            }\n\n            // Try HELO instead\n            this._responseActions.push(this._actionHELO);\n            this._sendCommand('HELO ' + this.name);\n            return;\n        }\n\n        this._ehloLines = str\n            .split(/\\r?\\n/)\n            .map(line => line.replace(/^\\d+[ -]/, '').trim())\n            .filter(line => line)\n            .slice(1);\n\n        // Detect if the server supports STARTTLS\n        if (!this.secure && !this.options.ignoreTLS && (/[ -]STARTTLS\\b/im.test(str) || this.options.requireTLS)) {\n            this._sendCommand('STARTTLS');\n            this._responseActions.push(this._actionSTARTTLS);\n            return;\n        }\n\n        // Detect if the server supports SMTPUTF8\n        if (/[ -]SMTPUTF8\\b/im.test(str)) {\n            this._supportedExtensions.push('SMTPUTF8');\n        }\n\n        // Detect if the server supports DSN\n        if (/[ -]DSN\\b/im.test(str)) {\n            this._supportedExtensions.push('DSN');\n        }\n\n        // Detect if the server supports 8BITMIME\n        if (/[ -]8BITMIME\\b/im.test(str)) {\n            this._supportedExtensions.push('8BITMIME');\n        }\n\n        // Detect if the server supports PIPELINING\n        if (/[ -]PIPELINING\\b/im.test(str)) {\n            this._supportedExtensions.push('PIPELINING');\n        }\n\n        // Detect if the server supports AUTH\n        if (/[ -]AUTH\\b/i.test(str)) {\n            this.allowsAuth = true;\n        }\n\n        // Detect if the server supports PLAIN auth\n        if (/[ -]AUTH(?:(\\s+|=)[^\\n]*\\s+|\\s+|=)PLAIN/i.test(str)) {\n            this._supportedAuth.push('PLAIN');\n        }\n\n        // Detect if the server supports LOGIN auth\n        if (/[ -]AUTH(?:(\\s+|=)[^\\n]*\\s+|\\s+|=)LOGIN/i.test(str)) {\n            this._supportedAuth.push('LOGIN');\n        }\n\n        // Detect if the server supports CRAM-MD5 auth\n        if (/[ -]AUTH(?:(\\s+|=)[^\\n]*\\s+|\\s+|=)CRAM-MD5/i.test(str)) {\n            this._supportedAuth.push('CRAM-MD5');\n        }\n\n        // Detect if the server supports XOAUTH2 auth\n        if (/[ -]AUTH(?:(\\s+|=)[^\\n]*\\s+|\\s+|=)XOAUTH2/i.test(str)) {\n            this._supportedAuth.push('XOAUTH2');\n        }\n\n        // Detect if the server supports SIZE extensions (and the max allowed size)\n        if ((match = str.match(/[ -]SIZE(?:[ \\t]+(\\d+))?/im))) {\n            this._supportedExtensions.push('SIZE');\n            this._maxAllowedSize = Number(match[1]) || 0;\n        }\n\n        this.emit('connect');\n    }\n\n    /**\n     * Handles server response for HELO command. If it yielded in\n     * error, emit 'error', otherwise move into the authentication phase.\n     *\n     * @param {String} str Message from the server\n     */\n    _actionHELO(str) {\n        if (str.charAt(0) !== '2') {\n            this._onError(new Error('Invalid HELO. response=' + str), 'EPROTOCOL', str, 'HELO');\n            return;\n        }\n\n        // assume that authentication is enabled (most probably is not though)\n        this.allowsAuth = true;\n\n        this.emit('connect');\n    }\n\n    /**\n     * Handles server response for STARTTLS command. If there's an error\n     * try HELO instead, otherwise initiate TLS upgrade. If the upgrade\n     * succeedes restart the EHLO\n     *\n     * @param {String} str Message from the server\n     */\n    _actionSTARTTLS(str) {\n        if (str.charAt(0) !== '2') {\n            if (this.options.opportunisticTLS) {\n                this.logger.info(\n                    {\n                        tnx: 'smtp'\n                    },\n                    'Failed STARTTLS upgrade, continuing unencrypted'\n                );\n                return this.emit('connect');\n            }\n            this._onError(new Error('Error upgrading connection with STARTTLS'), 'ETLS', str, 'STARTTLS');\n            return;\n        }\n\n        this._upgradeConnection((err, secured) => {\n            if (err) {\n                this._onError(new Error('Error initiating TLS - ' + (err.message || err)), 'ETLS', false, 'STARTTLS');\n                return;\n            }\n\n            this.logger.info(\n                {\n                    tnx: 'smtp'\n                },\n                'Connection upgraded with STARTTLS'\n            );\n\n            if (secured) {\n                // restart session\n                if (this.options.lmtp) {\n                    this._responseActions.push(this._actionLHLO);\n                    this._sendCommand('LHLO ' + this.name);\n                } else {\n                    this._responseActions.push(this._actionEHLO);\n                    this._sendCommand('EHLO ' + this.name);\n                }\n            } else {\n                this.emit('connect');\n            }\n        });\n    }\n\n    /**\n     * Handle the response for AUTH LOGIN command. We are expecting\n     * '334 VXNlcm5hbWU6' (base64 for 'Username:'). Data to be sent as\n     * response needs to be base64 encoded username. We do not need\n     * exact match but settle with 334 response in general as some\n     * hosts invalidly use a longer message than VXNlcm5hbWU6\n     *\n     * @param {String} str Message from the server\n     */\n    _actionAUTH_LOGIN_USER(str, callback) {\n        if (!/^334[ -]/.test(str)) {\n            // expecting '334 VXNlcm5hbWU6'\n            callback(this._formatError('Invalid login sequence while waiting for \"334 VXNlcm5hbWU6\"', 'EAUTH', str, 'AUTH LOGIN'));\n            return;\n        }\n\n        this._responseActions.push(str => {\n            this._actionAUTH_LOGIN_PASS(str, callback);\n        });\n\n        this._sendCommand(Buffer.from(this._auth.credentials.user + '', 'utf-8').toString('base64'));\n    }\n\n    /**\n     * Handle the response for AUTH CRAM-MD5 command. We are expecting\n     * '334 <challenge string>'. Data to be sent as response needs to be\n     * base64 decoded challenge string, MD5 hashed using the password as\n     * a HMAC key, prefixed by the username and a space, and finally all\n     * base64 encoded again.\n     *\n     * @param {String} str Message from the server\n     */\n    _actionAUTH_CRAM_MD5(str, callback) {\n        let challengeMatch = str.match(/^334\\s+(.+)$/);\n        let challengeString = '';\n\n        if (!challengeMatch) {\n            return callback(\n                this._formatError('Invalid login sequence while waiting for server challenge string', 'EAUTH', str, 'AUTH CRAM-MD5')\n            );\n        } else {\n            challengeString = challengeMatch[1];\n        }\n\n        // Decode from base64\n        let base64decoded = Buffer.from(challengeString, 'base64').toString('ascii'),\n            hmacMD5 = crypto.createHmac('md5', this._auth.credentials.pass);\n\n        hmacMD5.update(base64decoded);\n\n        let prepended = this._auth.credentials.user + ' ' + hmacMD5.digest('hex');\n\n        this._responseActions.push(str => {\n            this._actionAUTH_CRAM_MD5_PASS(str, callback);\n        });\n\n        this._sendCommand(\n            Buffer.from(prepended).toString('base64'),\n            // hidden hash for logs\n            Buffer.from(this._auth.credentials.user + ' /* secret */').toString('base64')\n        );\n    }\n\n    /**\n     * Handles the response to CRAM-MD5 authentication, if there's no error,\n     * the user can be considered logged in. Start waiting for a message to send\n     *\n     * @param {String} str Message from the server\n     */\n    _actionAUTH_CRAM_MD5_PASS(str, callback) {\n        if (!str.match(/^235\\s+/)) {\n            return callback(this._formatError('Invalid login sequence while waiting for \"235\"', 'EAUTH', str, 'AUTH CRAM-MD5'));\n        }\n\n        this.logger.info(\n            {\n                tnx: 'smtp',\n                username: this._auth.user,\n                action: 'authenticated',\n                method: this._authMethod\n            },\n            'User %s authenticated',\n            JSON.stringify(this._auth.user)\n        );\n        this.authenticated = true;\n        callback(null, true);\n    }\n\n    /**\n     * Handle the response for AUTH LOGIN command. We are expecting\n     * '334 UGFzc3dvcmQ6' (base64 for 'Password:'). Data to be sent as\n     * response needs to be base64 encoded password.\n     *\n     * @param {String} str Message from the server\n     */\n    _actionAUTH_LOGIN_PASS(str, callback) {\n        if (!/^334[ -]/.test(str)) {\n            // expecting '334 UGFzc3dvcmQ6'\n            return callback(this._formatError('Invalid login sequence while waiting for \"334 UGFzc3dvcmQ6\"', 'EAUTH', str, 'AUTH LOGIN'));\n        }\n\n        this._responseActions.push(str => {\n            this._actionAUTHComplete(str, callback);\n        });\n\n        this._sendCommand(\n            Buffer.from((this._auth.credentials.pass || '').toString(), 'utf-8').toString('base64'),\n            // Hidden pass for logs\n            Buffer.from('/* secret */', 'utf-8').toString('base64')\n        );\n    }\n\n    /**\n     * Handles the response for authentication, if there's no error,\n     * the user can be considered logged in. Start waiting for a message to send\n     *\n     * @param {String} str Message from the server\n     */\n    _actionAUTHComplete(str, isRetry, callback) {\n        if (!callback && typeof isRetry === 'function') {\n            callback = isRetry;\n            isRetry = false;\n        }\n\n        if (str.substr(0, 3) === '334') {\n            this._responseActions.push(str => {\n                if (isRetry || this._authMethod !== 'XOAUTH2') {\n                    this._actionAUTHComplete(str, true, callback);\n                } else {\n                    // fetch a new OAuth2 access token\n                    setImmediate(() => this._handleXOauth2Token(true, callback));\n                }\n            });\n            this._sendCommand('');\n            return;\n        }\n\n        if (str.charAt(0) !== '2') {\n            this.logger.info(\n                {\n                    tnx: 'smtp',\n                    username: this._auth.user,\n                    action: 'authfail',\n                    method: this._authMethod\n                },\n                'User %s failed to authenticate',\n                JSON.stringify(this._auth.user)\n            );\n            return callback(this._formatError('Invalid login', 'EAUTH', str, 'AUTH ' + this._authMethod));\n        }\n\n        this.logger.info(\n            {\n                tnx: 'smtp',\n                username: this._auth.user,\n                action: 'authenticated',\n                method: this._authMethod\n            },\n            'User %s authenticated',\n            JSON.stringify(this._auth.user)\n        );\n        this.authenticated = true;\n        callback(null, true);\n    }\n\n    /**\n     * Handle response for a MAIL FROM: command\n     *\n     * @param {String} str Message from the server\n     */\n    _actionMAIL(str, callback) {\n        let message, curRecipient;\n        if (Number(str.charAt(0)) !== 2) {\n            if (this._usingSmtpUtf8 && /^550 /.test(str) && /[\\x80-\\uFFFF]/.test(this._envelope.from)) {\n                message = 'Internationalized mailbox name not allowed';\n            } else {\n                message = 'Mail command failed';\n            }\n            return callback(this._formatError(message, 'EENVELOPE', str, 'MAIL FROM'));\n        }\n\n        if (!this._envelope.rcptQueue.length) {\n            return callback(this._formatError(\"Can't send mail - no recipients defined\", 'EENVELOPE', false, 'API'));\n        } else {\n            this._recipientQueue = [];\n\n            if (this._supportedExtensions.includes('PIPELINING')) {\n                while (this._envelope.rcptQueue.length) {\n                    curRecipient = this._envelope.rcptQueue.shift();\n                    this._recipientQueue.push(curRecipient);\n                    this._responseActions.push(str => {\n                        this._actionRCPT(str, callback);\n                    });\n                    this._sendCommand('RCPT TO:<' + curRecipient + '>' + this._getDsnRcptToArgs());\n                }\n            } else {\n                curRecipient = this._envelope.rcptQueue.shift();\n                this._recipientQueue.push(curRecipient);\n                this._responseActions.push(str => {\n                    this._actionRCPT(str, callback);\n                });\n                this._sendCommand('RCPT TO:<' + curRecipient + '>' + this._getDsnRcptToArgs());\n            }\n        }\n    }\n\n    /**\n     * Handle response for a RCPT TO: command\n     *\n     * @param {String} str Message from the server\n     */\n    _actionRCPT(str, callback) {\n        let message,\n            err,\n            curRecipient = this._recipientQueue.shift();\n        if (Number(str.charAt(0)) !== 2) {\n            // this is a soft error\n            if (this._usingSmtpUtf8 && /^553 /.test(str) && /[\\x80-\\uFFFF]/.test(curRecipient)) {\n                message = 'Internationalized mailbox name not allowed';\n            } else {\n                message = 'Recipient command failed';\n            }\n            this._envelope.rejected.push(curRecipient);\n            // store error for the failed recipient\n            err = this._formatError(message, 'EENVELOPE', str, 'RCPT TO');\n            err.recipient = curRecipient;\n            this._envelope.rejectedErrors.push(err);\n        } else {\n            this._envelope.accepted.push(curRecipient);\n        }\n\n        if (!this._envelope.rcptQueue.length && !this._recipientQueue.length) {\n            if (this._envelope.rejected.length < this._envelope.to.length) {\n                this._responseActions.push(str => {\n                    this._actionDATA(str, callback);\n                });\n                this._sendCommand('DATA');\n            } else {\n                err = this._formatError(\"Can't send mail - all recipients were rejected\", 'EENVELOPE', str, 'RCPT TO');\n                err.rejected = this._envelope.rejected;\n                err.rejectedErrors = this._envelope.rejectedErrors;\n                return callback(err);\n            }\n        } else if (this._envelope.rcptQueue.length) {\n            curRecipient = this._envelope.rcptQueue.shift();\n            this._recipientQueue.push(curRecipient);\n            this._responseActions.push(str => {\n                this._actionRCPT(str, callback);\n            });\n            this._sendCommand('RCPT TO:<' + curRecipient + '>' + this._getDsnRcptToArgs());\n        }\n    }\n\n    /**\n     * Handle response for a DATA command\n     *\n     * @param {String} str Message from the server\n     */\n    _actionDATA(str, callback) {\n        // response should be 354 but according to this issue https://github.com/eleith/emailjs/issues/24\n        // some servers might use 250 instead, so lets check for 2 or 3 as the first digit\n        if (!/^[23]/.test(str)) {\n            return callback(this._formatError('Data command failed', 'EENVELOPE', str, 'DATA'));\n        }\n\n        let response = {\n            accepted: this._envelope.accepted,\n            rejected: this._envelope.rejected\n        };\n\n        if (this._ehloLines && this._ehloLines.length) {\n            response.ehlo = this._ehloLines;\n        }\n\n        if (this._envelope.rejectedErrors.length) {\n            response.rejectedErrors = this._envelope.rejectedErrors;\n        }\n\n        callback(null, response);\n    }\n\n    /**\n     * Handle response for a DATA stream when using SMTP\n     * We expect a single response that defines if the sending succeeded or failed\n     *\n     * @param {String} str Message from the server\n     */\n    _actionSMTPStream(str, callback) {\n        if (Number(str.charAt(0)) !== 2) {\n            // Message failed\n            return callback(this._formatError('Message failed', 'EMESSAGE', str, 'DATA'));\n        } else {\n            // Message sent succesfully\n            return callback(null, str);\n        }\n    }\n\n    /**\n     * Handle response for a DATA stream\n     * We expect a separate response for every recipient. All recipients can either\n     * succeed or fail separately\n     *\n     * @param {String} recipient The recipient this response applies to\n     * @param {Boolean} final Is this the final recipient?\n     * @param {String} str Message from the server\n     */\n    _actionLMTPStream(recipient, final, str, callback) {\n        let err;\n        if (Number(str.charAt(0)) !== 2) {\n            // Message failed\n            err = this._formatError('Message failed for recipient ' + recipient, 'EMESSAGE', str, 'DATA');\n            err.recipient = recipient;\n            this._envelope.rejected.push(recipient);\n            this._envelope.rejectedErrors.push(err);\n            for (let i = 0, len = this._envelope.accepted.length; i < len; i++) {\n                if (this._envelope.accepted[i] === recipient) {\n                    this._envelope.accepted.splice(i, 1);\n                }\n            }\n        }\n        if (final) {\n            return callback(null, str);\n        }\n    }\n\n    _handleXOauth2Token(isRetry, callback) {\n        this._auth.oauth2.getToken(isRetry, (err, accessToken) => {\n            if (err) {\n                this.logger.info(\n                    {\n                        tnx: 'smtp',\n                        username: this._auth.user,\n                        action: 'authfail',\n                        method: this._authMethod\n                    },\n                    'User %s failed to authenticate',\n                    JSON.stringify(this._auth.user)\n                );\n                return callback(this._formatError(err, 'EAUTH', false, 'AUTH XOAUTH2'));\n            }\n            this._responseActions.push(str => {\n                this._actionAUTHComplete(str, isRetry, callback);\n            });\n            this._sendCommand(\n                'AUTH XOAUTH2 ' + this._auth.oauth2.buildXOAuth2Token(accessToken),\n                //  Hidden for logs\n                'AUTH XOAUTH2 ' + this._auth.oauth2.buildXOAuth2Token('/* secret */')\n            );\n        });\n    }\n\n    /**\n     *\n     * @param {string} command\n     * @private\n     */\n    _isDestroyedMessage(command) {\n        if (this._destroyed) {\n            return 'Cannot ' + command + ' - smtp connection is already destroyed.';\n        }\n\n        if (this._socket) {\n            if (this._socket.destroyed) {\n                return 'Cannot ' + command + ' - smtp connection socket is already destroyed.';\n            }\n\n            if (!this._socket.writable) {\n                return 'Cannot ' + command + ' - smtp connection socket is already half-closed.';\n            }\n        }\n    }\n\n    _getHostname() {\n        // defaul hostname is machine hostname or [IP]\n        let defaultHostname;\n        try {\n            defaultHostname = os.hostname() || '';\n        } catch (_err) {\n            // fails on windows 7\n            defaultHostname = 'localhost';\n        }\n\n        // ignore if not FQDN\n        if (!defaultHostname || defaultHostname.indexOf('.') < 0) {\n            defaultHostname = '[127.0.0.1]';\n        }\n\n        // IP should be enclosed in []\n        if (defaultHostname.match(/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$/)) {\n            defaultHostname = '[' + defaultHostname + ']';\n        }\n\n        return defaultHostname;\n    }\n}\n\nmodule.exports = SMTPConnection;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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