"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([["_app-pages-browser_src_lib_betting_ts"],{

/***/ "(app-pages-browser)/./src/lib/betting.ts":
/*!****************************!*\
  !*** ./src/lib/betting.ts ***!
  \****************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BettingEngine: () => (/* binding */ BettingEngine),\n/* harmony export */   recordPriceHistory: () => (/* binding */ recordPriceHistory)\n/* harmony export */ });\n/* harmony import */ var _supabase_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./supabase-client */ \"(app-pages-browser)/./src/lib/supabase-client.ts\");\n\n// Function to record price history\nasync function recordPriceHistory(marketId, yesPrice, noPrice, yesPool, noPool, totalVolume) {\n    try {\n        await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('price_history').insert({\n            market_id: marketId,\n            yes_price: yesPrice,\n            no_price: noPrice,\n            yes_pool: yesPool,\n            no_pool: noPool,\n            total_volume: totalVolume\n        });\n    } catch (error) {\n        // Silently fail if price_history table doesn't exist yet\n        console.warn('Failed to record price history:', error);\n    }\n}\nclass BettingEngine {\n    /**\n   * Calculate liquidity-adjusted price using constant product formula\n   * This ensures there's always liquidity available for trading\n   */ static calculateLiquidityAdjustedPrice(currentPool, liquidity, betAmount, outcome) {\n        // Constant product formula: x * y = k\n        // Where x = outcome pool, y = opposite pool, k = constant\n        const oppositePool = liquidity - currentPool;\n        // Calculate new pools after bet\n        const newOutcomePool = currentPool + betAmount;\n        const newOppositePool = currentPool * oppositePool / newOutcomePool;\n        // Calculate price based on new pools\n        const totalNewPool = newOutcomePool + newOppositePool;\n        return newOutcomePool / totalNewPool;\n    }\n    /**\n   * Calculate market prices for multiple outcomes with liquidity\n   */ static calculateMultiOutcomePrices(outcomes, totalLiquidity) {\n        return outcomes.map((outcome)=>({\n                ...outcome,\n                price: outcome.pool / totalLiquidity\n            }));\n    }\n    /**\n   * Add liquidity to a market\n   */ static async addLiquidity(userId, marketId, amount, outcomeId// For multi-outcome markets\n    ) {\n        try {\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is active\n            if (market.status !== 'active') {\n                return {\n                    success: false,\n                    error: 'Market is no longer accepting liquidity'\n                };\n            }\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Update user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - amount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Add liquidity to market\n            const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                total_liquidity: (market.total_liquidity || 0) + amount,\n                updated_at: new Date().toISOString()\n            }).eq('id', marketId);\n            if (marketUpdateError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to add liquidity'\n                };\n            }\n            // Create liquidity transaction record\n            const { data: liquidityRecord, error: liquidityError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('liquidity_providers').insert({\n                user_id: userId,\n                market_id: marketId,\n                amount: amount,\n                outcome_id: outcomeId,\n                created_at: new Date().toISOString()\n            }).select().single();\n            if (liquidityError) {\n                return {\n                    success: false,\n                    error: 'Failed to record liquidity provision'\n                };\n            }\n            return {\n                success: true,\n                liquidityId: liquidityRecord.id\n            };\n        } catch (error) {\n            console.error('Error adding liquidity:', error);\n            return {\n                success: false,\n                error: 'Internal server error'\n            };\n        }\n    }\n    /**\n   * Place bet on multiple outcome market\n   */ static async placeMultiOutcomeBet(userId, marketId, outcomeId, amount) {\n        try {\n            var _market_outcomes;\n            // Get market and outcome details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(\"\\n          *,\\n          outcomes:market_outcomes(*)\\n        \").eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is multi-outcome\n            if (market.market_type !== 'multi_outcome') {\n                return {\n                    success: false,\n                    error: 'This is not a multi-outcome market'\n                };\n            }\n            // Find the specific outcome\n            const outcome = (_market_outcomes = market.outcomes) === null || _market_outcomes === void 0 ? void 0 : _market_outcomes.find((o)=>o.id === outcomeId);\n            if (!outcome) {\n                return {\n                    success: false,\n                    error: 'Outcome not found'\n                };\n            }\n            // Calculate liquidity-adjusted price\n            const newPrice = this.calculateLiquidityAdjustedPrice(outcome.pool, market.total_liquidity || 0, amount, outcome.name);\n            // Calculate shares user will receive\n            const shares = amount / newPrice;\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Update user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - amount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Update outcome pool\n            const { error: outcomeError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('market_outcomes').update({\n                pool: outcome.pool + amount,\n                volume: outcome.volume + amount,\n                updated_at: new Date().toISOString()\n            }).eq('id', outcomeId);\n            if (outcomeError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to update outcome pool'\n                };\n            }\n            // Create bet record\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                user_id: userId,\n                market_id: marketId,\n                outcome: outcome.name,\n                outcome_id: outcomeId,\n                amount: amount,\n                price: newPrice,\n                shares: shares,\n                status: 'matched',\n                liquidity_contribution: amount,\n                created_at: new Date().toISOString()\n            }).select().single();\n            if (betError) {\n                return {\n                    success: false,\n                    error: 'Failed to create bet record'\n                };\n            }\n            return {\n                success: true,\n                betId: bet.id\n            };\n        } catch (error) {\n            console.error('Error placing multi-outcome bet:', error);\n            return {\n                success: false,\n                error: 'Internal server error'\n            };\n        }\n    }\n    /**\n   * Seed a bet (pre-fund before making live)\n   */ static async seedBet(userId, marketId, outcome, seededAmount, price) {\n        try {\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is pending (scheduled) - seeding only allowed on scheduled markets\n            if (market.status !== 'pending') {\n                return {\n                    success: false,\n                    error: 'Seeding is only allowed on scheduled markets. This market is not in pending status.'\n                };\n            }\n            // Check if market has ended\n            const now = new Date();\n            const endDate = new Date(market.end_date);\n            if (now >= endDate) {\n                return {\n                    success: false,\n                    error: 'Market has ended'\n                };\n            }\n            // Check if market already has live volume (seeding only allowed before live trading)\n            if ((market.live_volume || 0) > 0) {\n                return {\n                    success: false,\n                    error: 'Market is already live. Seeding is only allowed before live trading begins.'\n                };\n            }\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < seededAmount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Use current market price if not specified\n            const currentPrice = price || (outcome === 'yes' ? market.yes_price : market.no_price);\n            // Create seeded bet\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                user_id: userId,\n                market_id: marketId,\n                outcome,\n                amount: 0,\n                price: currentPrice,\n                shares: 0,\n                status: 'seeded',\n                seeded_amount: seededAmount,\n                live_amount: 0\n            }).select().single();\n            if (betError) {\n                return {\n                    success: false,\n                    error: betError.message\n                };\n            }\n            // Deduct seeded amount from user balance\n            const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: profile.balance - seededAmount\n            }).eq('id', userId);\n            if (balanceError) {\n                return {\n                    success: false,\n                    error: 'Failed to update balance'\n                };\n            }\n            // Update market seeded volume\n            const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                seeded_volume: (market.seeded_volume || 0) + seededAmount,\n                total_volume: (market.total_volume || 0) + seededAmount\n            }).eq('id', marketId);\n            if (marketUpdateError) {\n                // Rollback balance update\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance\n                }).eq('id', userId);\n                return {\n                    success: false,\n                    error: 'Failed to update market volume'\n                };\n            }\n            // Create transaction record\n            await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').insert({\n                user_id: userId,\n                type: 'bet',\n                amount: -seededAmount,\n                description: \"Seeded bet on market (\".concat(outcome.toUpperCase(), \")\"),\n                market_id: marketId,\n                bet_id: bet.id\n            });\n            return {\n                success: true,\n                betId: bet.id\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Make a seeded bet live (activate it)\n   */ static async makeBetLive(betId, additionalAmount) {\n        try {\n            // Get the seeded bet\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('id', betId).single();\n            if (betError || !bet) {\n                return {\n                    success: false,\n                    error: 'Bet not found'\n                };\n            }\n            if (bet.status !== 'seeded') {\n                return {\n                    success: false,\n                    error: 'Bet is not in seeded status'\n                };\n            }\n            const totalAmount = bet.seeded_amount + (additionalAmount || 0);\n            const liveAmount = additionalAmount || 0;\n            // If additional amount is provided, check balance\n            if (additionalAmount && additionalAmount > 0) {\n                const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', bet.user_id).single();\n                if (profileError || !profile) {\n                    return {\n                        success: false,\n                        error: 'User profile not found'\n                    };\n                }\n                if (profile.balance < additionalAmount) {\n                    return {\n                        success: false,\n                        error: 'Insufficient balance for additional amount'\n                    };\n                }\n                // Deduct additional amount from user balance\n                const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance - additionalAmount\n                }).eq('id', bet.user_id);\n                if (balanceError) {\n                    return {\n                        success: false,\n                        error: 'Failed to update balance'\n                    };\n                }\n                // Create transaction for additional amount\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').insert({\n                    user_id: bet.user_id,\n                    type: 'bet',\n                    amount: -additionalAmount,\n                    description: \"Additional amount for live bet\",\n                    market_id: bet.market_id,\n                    bet_id: bet.id\n                });\n            }\n            // Update bet to live status\n            const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'live',\n                amount: totalAmount,\n                shares: totalAmount / bet.price,\n                live_amount: liveAmount\n            }).eq('id', betId);\n            if (updateError) {\n                return {\n                    success: false,\n                    error: updateError.message\n                };\n            }\n            // Update market pools for live bet\n            if (liveAmount > 0) {\n                const { data: market } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', bet.market_id).single();\n                if (market) {\n                    const updateData = {\n                        live_volume: (market.live_volume || 0) + liveAmount\n                    };\n                    if (bet.outcome === 'yes') {\n                        updateData.yes_pool = (market.yes_pool || 0) + liveAmount;\n                    } else {\n                        updateData.no_pool = (market.no_pool || 0) + liveAmount;\n                    }\n                    // Calculate new prices\n                    const totalYesPool = updateData.yes_pool || market.yes_pool || 0;\n                    const totalNoPool = updateData.no_pool || market.no_pool || 0;\n                    const totalPool = totalYesPool + totalNoPool;\n                    if (totalPool > 0) {\n                        updateData.yes_price = totalYesPool / totalPool;\n                        updateData.no_price = totalNoPool / totalPool;\n                    }\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update(updateData).eq('id', bet.market_id);\n                }\n            }\n            // Try to match with existing bets\n            await this.matchBets(bet.market_id);\n            return {\n                success: true\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Check if market shares are exhausted\n   */ static async checkShareExhaustion(marketId) {\n        try {\n            const { data: market, error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('total_shares, shares_sold, status, market_type, outcomes').eq('id', marketId).single();\n            if (error || !market) {\n                return {\n                    exhausted: false,\n                    reason: 'Market not found'\n                };\n            }\n            // Check if market is already closed/resolved\n            if ([\n                'closed',\n                'resolved',\n                'refunded'\n            ].includes(market.status)) {\n                return {\n                    exhausted: true,\n                    reason: 'Market is closed'\n                };\n            }\n            // For binary markets\n            if (market.market_type === 'binary') {\n                const totalShares = market.total_shares || 1000;\n                const sharesSold = market.shares_sold || 0;\n                const remainingShares = totalShares - sharesSold;\n                if (remainingShares <= 0) {\n                    return {\n                        exhausted: true,\n                        reason: 'All shares have been sold'\n                    };\n                }\n            }\n            // For multi-outcome markets\n            if (market.market_type === 'multi_outcome' && market.outcomes) {\n                for (const outcome of market.outcomes){\n                    const outcomeShares = outcome.pool || 0;\n                    const maxSharesPerOutcome = (market.total_shares || 1000) / market.outcomes.length;\n                    if (outcomeShares >= maxSharesPerOutcome) {\n                        return {\n                            exhausted: true,\n                            reason: 'Outcome \"'.concat(outcome.name, '\" shares exhausted')\n                        };\n                    }\n                }\n            }\n            return {\n                exhausted: false\n            };\n        } catch (error) {\n            console.error('Error checking share exhaustion:', error);\n            return {\n                exhausted: false,\n                reason: 'Error checking shares'\n            };\n        }\n    }\n    /**\n   * Update market status when shares are exhausted\n   */ static async updateMarketForExhaustion(marketId) {\n        try {\n            const { error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                status: 'closed',\n                admin_notes: 'Market closed - shares exhausted',\n                updated_at: new Date().toISOString()\n            }).eq('id', marketId);\n            if (error) {\n                console.error('Failed to update market for exhaustion:', error);\n                return false;\n            }\n            // Send notification to market creator\n            try {\n                const { data: market } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('creator_id, title').eq('id', marketId).single();\n                if (market) {\n                    const { NotificationService } = await __webpack_require__.e(/*! import() */ \"_app-pages-browser_src_lib_services_notificationService_ts\").then(__webpack_require__.bind(__webpack_require__, /*! @/lib/services/notificationService */ \"(app-pages-browser)/./src/lib/services/notificationService.ts\"));\n                    await NotificationService.createEventNotification(market.creator_id, 'market_shares_exhausted', 'Market Shares Exhausted', 'Your market \"'.concat(market.title, '\" has been closed due to share exhaustion.'), {\n                        market: {\n                            id: marketId,\n                            title: market.title,\n                            reason: 'shares_exhausted'\n                        }\n                    }, true // Send email\n                    );\n                }\n            } catch (notificationError) {\n                console.error('Failed to send exhaustion notification:', notificationError);\n            }\n            return true;\n        } catch (error) {\n            console.error('Error updating market for exhaustion:', error);\n            return false;\n        }\n    }\n    /**\n   * Place a share-based bet on a market\n   */ static async placeBet(userId, marketId, outcome, amount, shares) {\n        try {\n            // Check if shares are exhausted before placing bet\n            const exhaustionCheck = await this.checkShareExhaustion(marketId);\n            if (exhaustionCheck.exhausted) {\n                return {\n                    success: false,\n                    error: \"Cannot place bet: \".concat(exhaustionCheck.reason)\n                };\n            }\n            // Get market details\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('*').eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            // Check if market is active\n            if (market.status !== 'active') {\n                return {\n                    success: false,\n                    error: 'Market is no longer accepting bets'\n                };\n            }\n            // Check if market has ended\n            const now = new Date();\n            const endDate = new Date(market.end_date);\n            if (now >= endDate) {\n                return {\n                    success: false,\n                    error: 'Market has ended'\n                };\n            }\n            // Note: shares_remaining column has been removed - prediction markets typically have unlimited shares\n            // Get user balance\n            const { data: profile, error: profileError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('balance').eq('id', userId).single();\n            if (profileError || !profile) {\n                return {\n                    success: false,\n                    error: 'User not found'\n                };\n            }\n            // Check if user has sufficient balance\n            if (profile.balance < amount) {\n                return {\n                    success: false,\n                    error: 'Insufficient balance'\n                };\n            }\n            // Try the new share-based betting function first\n            try {\n                const { data: result, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('place_share_bet', {\n                    p_user_id: userId,\n                    p_market_id: marketId,\n                    p_outcome: outcome,\n                    p_amount: amount,\n                    p_shares: shares || null\n                }).single();\n                if (betError) {\n                    throw betError;\n                }\n                const betResult = result;\n                if (!betResult.success) {\n                    throw new Error(betResult.message);\n                }\n                // Return success with share information\n                return {\n                    success: true,\n                    betId: betResult.bet_id,\n                    sharesPurchased: betResult.shares_purchased,\n                    sharePrice: betResult.share_price,\n                    potentialPayout: betResult.potential_payout\n                };\n            } catch (shareBetError) {\n                // Fallback to old betting system if share-based functions don't exist\n                console.warn('Share-based betting not available, falling back to old system:', shareBetError);\n                // Use current market price if not specified\n                const betPrice = market.yes_price || market.no_price || 0.5;\n                const calculatedShares = shares || amount / betPrice;\n                // Check if purchase would exceed total shares available\n                const currentSharesSold = market.shares_sold || 0;\n                const totalShares = market.total_shares || 1000;\n                if (currentSharesSold + calculatedShares > totalShares) {\n                    const remainingShares = totalShares - currentSharesSold;\n                    throw new Error(\"Purchase would exceed total shares available. Only \".concat(remainingShares.toFixed(2), \" shares remaining.\"));\n                }\n                // Create live bet using old system\n                const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').insert({\n                    user_id: userId,\n                    market_id: marketId,\n                    outcome,\n                    amount,\n                    price: betPrice,\n                    shares: calculatedShares,\n                    status: 'matched',\n                    seeded_amount: 0,\n                    live_amount: amount\n                }).select().single();\n                if (betError) {\n                    throw new Error(betError.message);\n                }\n                // Deduct amount from user balance\n                const { error: balanceError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                    balance: profile.balance - amount\n                }).eq('id', userId);\n                if (balanceError) {\n                    throw new Error('Failed to update balance');\n                }\n                // Update market pools, volumes, and shares sold\n                const updateData = {\n                    live_volume: (market.live_volume || 0) + amount,\n                    total_volume: (market.total_volume || 0) + amount,\n                    shares_sold: (market.shares_sold || 0) + calculatedShares\n                };\n                if (outcome === 'yes') {\n                    updateData.yes_pool = (market.yes_pool || 0) + amount;\n                    updateData.current_yes_share_price = betPrice;\n                } else {\n                    updateData.no_pool = (market.no_pool || 0) + amount;\n                    updateData.current_no_share_price = betPrice;\n                }\n                // Calculate new prices based on updated pools\n                const totalYesPool = updateData.yes_pool || market.yes_pool || 0;\n                const totalNoPool = updateData.no_pool || market.no_pool || 0;\n                const totalPool = totalYesPool + totalNoPool;\n                if (totalPool > 0) {\n                    updateData.yes_price = totalYesPool / totalPool;\n                    updateData.no_price = totalNoPool / totalPool;\n                }\n                const { error: marketUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update(updateData).eq('id', marketId);\n                if (marketUpdateError) {\n                    // Rollback balance update\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                        balance: profile.balance\n                    }).eq('id', userId);\n                    throw new Error('Failed to update market pools');\n                }\n                // Create unified transaction record\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('unified_transactions').insert({\n                    user_id: userId,\n                    type: 'bet',\n                    status: 'completed',\n                    amount: -amount,\n                    currency: 'USD',\n                    description: \"Live bet placed on market (\".concat(outcome.toUpperCase(), \")\"),\n                    market_id: marketId,\n                    bet_id: bet.id,\n                    fee_amount: 0,\n                    net_amount: -amount,\n                    processed_at: new Date().toISOString(),\n                    metadata: {\n                        outcome: outcome,\n                        price: betPrice,\n                        shares: calculatedShares\n                    }\n                });\n                // Check if shares are now exhausted after this bet\n                const postBetExhaustion = await this.checkShareExhaustion(marketId);\n                if (postBetExhaustion.exhausted) {\n                    console.log('Shares exhausted after bet, updating market status');\n                    await this.updateMarketForExhaustion(marketId);\n                }\n                return {\n                    success: true,\n                    betId: bet.id,\n                    sharesPurchased: calculatedShares,\n                    sharePrice: betPrice,\n                    potentialPayout: calculatedShares * 1.00 // Estimate $1 per share\n                };\n            }\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Match pending bets for a market\n   */ static async matchBets(marketId) {\n        try {\n            // Get all pending bets for this market\n            const { data: pendingBets, error: fetchError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('market_id', marketId).eq('status', 'live').order('created_at', {\n                ascending: true\n            });\n            if (fetchError) {\n                console.error('Error fetching pending bets:', fetchError);\n                return;\n            }\n            if (!pendingBets || pendingBets.length === 0) {\n                return;\n            }\n            // Simple matching logic - match opposite outcome bets\n            const yesBets = pendingBets.filter((bet)=>bet.outcome === 'yes');\n            const noBets = pendingBets.filter((bet)=>bet.outcome === 'no');\n            // Match bets with similar amounts\n            const minMatches = Math.min(yesBets.length, noBets.length);\n            for(let i = 0; i < minMatches; i++){\n                const yesBet = yesBets[i];\n                const noBet = noBets[i];\n                // Update both bets to matched status\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                    status: 'matched'\n                }).eq('id', yesBet.id);\n                await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                    status: 'matched'\n                }).eq('id', noBet.id);\n            }\n        } catch (error) {\n            console.error('Error matching bets:', error);\n        }\n    }\n    /**\n   * Automatically determine the winning outcome based on market data\n   * This can be extended with various algorithms (price-based, volume-based, etc.)\n   */ static async determineWinningOutcome(marketId) {\n        try {\n            // Get market data\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(\"\\n          id,\\n          title,\\n          description,\\n          category,\\n          end_date,\\n          yes_price,\\n          no_price,\\n          total_volume,\\n          total_liquidity,\\n          status\\n        \").eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'Market not found'\n                };\n            }\n            // Get bet data for analysis\n            const { data: bets, error: betsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('outcome, amount, seeded_amount, live_amount, status').eq('market_id', marketId).eq('status', 'matched');\n            if (betsError) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'Failed to fetch bet data'\n                };\n            }\n            if (!bets || bets.length === 0) {\n                return {\n                    outcome: null,\n                    confidence: 0,\n                    reasoning: 'No matched bets found'\n                };\n            }\n            // Calculate metrics for each outcome\n            const yesBets = bets.filter((bet)=>bet.outcome === 'yes');\n            const noBets = bets.filter((bet)=>bet.outcome === 'no');\n            const yesMetrics = {\n                count: yesBets.length,\n                totalAmount: yesBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0),\n                seededAmount: yesBets.reduce((sum, bet)=>sum + (bet.seeded_amount || 0), 0),\n                liveAmount: yesBets.reduce((sum, bet)=>sum + (bet.live_amount || 0), 0),\n                avgAmount: yesBets.length > 0 ? yesBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0) / yesBets.length : 0\n            };\n            const noMetrics = {\n                count: noBets.length,\n                totalAmount: noBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0),\n                seededAmount: noBets.reduce((sum, bet)=>sum + (bet.seeded_amount || 0), 0),\n                liveAmount: noBets.reduce((sum, bet)=>sum + (bet.live_amount || 0), 0),\n                avgAmount: noBets.length > 0 ? noBets.reduce((sum, bet)=>sum + (bet.amount || 0), 0) / noBets.length : 0\n            };\n            // Algorithm 1: Price-based determination (most reliable for prediction markets)\n            let priceBasedOutcome = null;\n            let priceConfidence = 0;\n            if (market.yes_price && market.no_price) {\n                const priceDiff = Math.abs(market.yes_price - market.no_price);\n                const threshold = 0.1 // 10% price difference threshold for high confidence\n                ;\n                if (market.yes_price > market.no_price + threshold) {\n                    priceBasedOutcome = 'yes';\n                    priceConfidence = Math.min(priceDiff * 100, 95); // Cap at 95% confidence\n                } else if (market.no_price > market.yes_price + threshold) {\n                    priceBasedOutcome = 'no';\n                    priceConfidence = Math.min(priceDiff * 100, 95);\n                } else {\n                    priceConfidence = 50; // Low confidence when prices are close\n                }\n            }\n            // Algorithm 2: Volume-based determination\n            let volumeBasedOutcome = null;\n            let volumeConfidence = 0;\n            const totalVolume = yesMetrics.totalAmount + noMetrics.totalAmount;\n            if (totalVolume > 0) {\n                const yesVolumeRatio = yesMetrics.totalAmount / totalVolume;\n                const noVolumeRatio = noMetrics.totalAmount / totalVolume;\n                const volumeDiff = Math.abs(yesVolumeRatio - noVolumeRatio);\n                if (yesVolumeRatio > noVolumeRatio + 0.2) {\n                    volumeBasedOutcome = 'yes';\n                    volumeConfidence = Math.min(volumeDiff * 100, 80);\n                } else if (noVolumeRatio > yesVolumeRatio + 0.2) {\n                    volumeBasedOutcome = 'no';\n                    volumeConfidence = Math.min(volumeDiff * 100, 80);\n                } else {\n                    volumeConfidence = 50;\n                }\n            }\n            // Algorithm 3: Seeded amount analysis (early money)\n            let seededBasedOutcome = null;\n            let seededConfidence = 0;\n            const totalSeeded = yesMetrics.seededAmount + noMetrics.seededAmount;\n            if (totalSeeded > 0) {\n                const yesSeededRatio = yesMetrics.seededAmount / totalSeeded;\n                const noSeededRatio = noMetrics.seededAmount / totalSeeded;\n                const seededDiff = Math.abs(yesSeededRatio - noSeededRatio);\n                if (yesSeededRatio > noSeededRatio + 0.3) {\n                    seededBasedOutcome = 'yes';\n                    seededConfidence = Math.min(seededDiff * 100, 70);\n                } else if (noSeededRatio > yesSeededRatio + 0.3) {\n                    seededBasedOutcome = 'no';\n                    seededConfidence = Math.min(seededDiff * 100, 70);\n                } else {\n                    seededConfidence = 50;\n                }\n            }\n            // Combine algorithms with weighted scoring\n            const algorithms = [\n                {\n                    outcome: priceBasedOutcome,\n                    confidence: priceConfidence,\n                    weight: 0.5,\n                    name: 'price'\n                },\n                {\n                    outcome: volumeBasedOutcome,\n                    confidence: volumeConfidence,\n                    weight: 0.3,\n                    name: 'volume'\n                },\n                {\n                    outcome: seededBasedOutcome,\n                    confidence: seededConfidence,\n                    weight: 0.2,\n                    name: 'seeded'\n                }\n            ];\n            // Calculate weighted scores for each outcome\n            const yesScore = algorithms.reduce((score, algo)=>{\n                return score + (algo.outcome === 'yes' ? algo.confidence * algo.weight : 0);\n            }, 0);\n            const noScore = algorithms.reduce((score, algo)=>{\n                return score + (algo.outcome === 'no' ? algo.confidence * algo.weight : 0);\n            }, 0);\n            // Determine final outcome\n            let finalOutcome = null;\n            let finalConfidence = 0;\n            let reasoning = '';\n            if (yesScore > noScore + 10) {\n                finalOutcome = 'yes';\n                finalConfidence = Math.min(yesScore, 95);\n                reasoning = \"YES selected based on: \".concat(algorithms.filter((a)=>a.outcome === 'yes').map((a)=>\"\".concat(a.name, \"(\").concat(a.confidence.toFixed(1), \"%)\")).join(', '));\n            } else if (noScore > yesScore + 10) {\n                finalOutcome = 'no';\n                finalConfidence = Math.min(noScore, 95);\n                reasoning = \"NO selected based on: \".concat(algorithms.filter((a)=>a.outcome === 'no').map((a)=>\"\".concat(a.name, \"(\").concat(a.confidence.toFixed(1), \"%)\")).join(', '));\n            } else {\n                finalOutcome = null;\n                finalConfidence = Math.max(yesScore, noScore);\n                reasoning = \"Insufficient confidence for automatic resolution. YES: \".concat(yesScore.toFixed(1), \"%, NO: \").concat(noScore.toFixed(1), \"%\");\n            }\n            return {\n                outcome: finalOutcome,\n                confidence: finalConfidence,\n                reasoning: reasoning\n            };\n        } catch (error) {\n            console.error('Error determining winning outcome:', error);\n            return {\n                outcome: null,\n                confidence: 0,\n                reasoning: \"Error in automatic determination: \".concat(error.message)\n            };\n        }\n    }\n    /**\n   * Resolve a market with comprehensive payout system\n   * Uses the new payout system to handle all stakeholders: winners, creators, and admin\n   * Can automatically determine winners if outcome is not provided\n   */ static async resolveMarket(marketId, outcome) {\n        try {\n            // Check if market exists and has bets\n            const { data: market, error: marketError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select(\"\\n          id, \\n          status, \\n          market_type,\\n          outcomes:market_outcomes (\\n            id,\\n            name,\\n            price,\\n            pool\\n          )\\n        \").eq('id', marketId).single();\n            if (marketError || !market) {\n                return {\n                    success: false,\n                    error: 'Market not found'\n                };\n            }\n            if (market.status !== 'active' && market.status !== 'closed') {\n                return {\n                    success: false,\n                    error: 'Market is not in a resolvable state'\n                };\n            }\n            // If no outcome provided, try to determine it automatically\n            let finalOutcome = outcome;\n            let autoDetermined = false;\n            let confidence = 0;\n            if (!outcome) {\n                const determination = await this.determineWinningOutcome(marketId);\n                if (determination.outcome) {\n                    finalOutcome = determination.outcome;\n                    autoDetermined = true;\n                    confidence = determination.confidence;\n                    console.log(\"Auto-determined outcome: \".concat(determination.outcome, \" (\").concat(determination.confidence.toFixed(1), \"% confidence)\"));\n                    console.log(\"Reasoning: \".concat(determination.reasoning));\n                } else {\n                    return {\n                        success: false,\n                        error: \"Cannot automatically determine winner: \".concat(determination.reasoning),\n                        confidence: determination.confidence\n                    };\n                }\n            } else {\n                // Validate the provided outcome\n                if (market.market_type === 'binary') {\n                    if (outcome !== 'yes' && outcome !== 'no') {\n                        return {\n                            success: false,\n                            error: 'Invalid outcome for binary market. Must be \"yes\" or \"no\".'\n                        };\n                    }\n                } else if (market.market_type === 'multi_outcome') {\n                    var _market_outcomes;\n                    const validOutcomes = ((_market_outcomes = market.outcomes) === null || _market_outcomes === void 0 ? void 0 : _market_outcomes.map((o)=>o.name)) || [];\n                    if (!validOutcomes.includes(outcome)) {\n                        return {\n                            success: false,\n                            error: \"Invalid outcome for multi-outcome market. Valid outcomes: \".concat(validOutcomes.join(', '))\n                        };\n                    }\n                }\n            }\n            // Check if there are any matched bets\n            const { data: bets, error: betsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('id').eq('market_id', marketId).eq('status', 'matched').limit(1);\n            if (betsError) {\n                return {\n                    success: false,\n                    error: betsError.message\n                };\n            }\n            // If no bets, just update market status\n            if (!bets || bets.length === 0) {\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'resolved',\n                    outcome: finalOutcome,\n                    resolution_date: new Date().toISOString()\n                }).eq('id', marketId);\n                if (updateError) {\n                    return {\n                        success: false,\n                        error: updateError.message\n                    };\n                }\n                return {\n                    success: true,\n                    payoutSummary: {\n                        totalPayouts: 0,\n                        totalAmount: 0\n                    },\n                    autoDetermined,\n                    confidence\n                };\n            }\n            // Try to use the comprehensive payout system, fallback to basic resolution if not available\n            let payoutProcessed = false;\n            let payoutSummary = null;\n            try {\n                const { data: payoutResult, error: payoutError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('process_market_payouts', {\n                    p_market_id: marketId,\n                    p_outcome: finalOutcome\n                });\n                if (payoutError) {\n                    console.error('Error processing payouts:', payoutError);\n                    // Check if it's because the payout system isn't set up\n                    if (payoutError.message && (payoutError.message.includes('function process_market_payouts') || payoutError.message.includes('does not exist'))) {\n                        console.log('Payout system not set up, using basic resolution');\n                    } else {\n                        console.error('Payout error:', payoutError.message || 'Unknown payout error');\n                    }\n                } else {\n                    const result = payoutResult === null || payoutResult === void 0 ? void 0 : payoutResult[0];\n                    if (result && result.success) {\n                        payoutProcessed = true;\n                        payoutSummary = result;\n                    }\n                }\n            } catch (rpcError) {\n                console.error('RPC call failed:', rpcError);\n            }\n            // If payout system failed, do basic market resolution\n            if (!payoutProcessed) {\n                console.log('Using basic market resolution');\n                // Update market status\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'resolved',\n                    outcome: finalOutcome,\n                    resolved_at: new Date().toISOString()\n                }).eq('id', marketId);\n                if (updateError) {\n                    console.error('Error updating market status:', updateError);\n                    return {\n                        success: false,\n                        error: 'Failed to update market status'\n                    };\n                }\n                payoutSummary = {\n                    total_payouts: 0,\n                    total_amount: 0,\n                    winner_count: 0,\n                    message: 'Market resolved (basic resolution - payout system not available)'\n                };\n            }\n            // Update bet statuses to reflect resolution\n            // First get all matched bets for this market\n            const { data: matchedBets, error: fetchError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('id, outcome').eq('market_id', marketId).eq('status', 'matched');\n            if (fetchError) {\n                console.error('Error fetching matched bets:', fetchError);\n            } else if (matchedBets) {\n                // Update each bet individually based on outcome\n                for (const bet of matchedBets){\n                    const newStatus = bet.outcome === finalOutcome ? 'won' : 'lost';\n                    await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                        status: newStatus\n                    }).eq('id', bet.id);\n                }\n            }\n            return {\n                success: true,\n                payoutSummary: payoutSummary ? {\n                    totalPayouts: payoutSummary.total_payouts || 0,\n                    totalAmount: payoutSummary.total_amount || 0,\n                    message: payoutSummary.message || 'Market resolved successfully'\n                } : {\n                    totalPayouts: 0,\n                    totalAmount: 0,\n                    message: 'Market resolved (basic resolution)'\n                },\n                autoDetermined,\n                confidence\n            };\n        } catch (error) {\n            console.error('Error in resolveMarket:', error);\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Automatically resolve markets that have ended and have sufficient confidence\n   * This method can be called by a cron job or scheduled task\n   */ static async autoResolveExpiredMarkets() {\n        let minConfidence = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 70;\n        try {\n            console.log('Starting automatic market resolution...');\n            // Get all expired markets that are still active or closed\n            const { data: expiredMarkets, error: marketsError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').select('id, title, end_date, status').in('status', [\n                'active',\n                'closed'\n            ]).lt('end_date', new Date().toISOString()).order('end_date', {\n                ascending: true\n            });\n            if (marketsError) {\n                return {\n                    success: false,\n                    error: marketsError.message,\n                    processed: 0,\n                    resolved: 0,\n                    failed: 0,\n                    results: []\n                };\n            }\n            if (!expiredMarkets || expiredMarkets.length === 0) {\n                console.log('No expired markets found for auto-resolution');\n                return {\n                    success: true,\n                    processed: 0,\n                    resolved: 0,\n                    failed: 0,\n                    results: []\n                };\n            }\n            console.log(\"Found \".concat(expiredMarkets.length, \" expired markets to process\"));\n            const results = [];\n            let resolvedCount = 0;\n            let failedCount = 0;\n            // Process each expired market\n            for (const market of expiredMarkets){\n                console.log(\"Processing market: \".concat(market.title, \" (\").concat(market.id, \")\"));\n                try {\n                    // Determine the winning outcome\n                    const determination = await this.determineWinningOutcome(market.id);\n                    if (determination.outcome && determination.confidence >= minConfidence) {\n                        // Auto-resolve the market\n                        const resolveResult = await this.resolveMarket(market.id, determination.outcome);\n                        if (resolveResult.success) {\n                            resolvedCount++;\n                            console.log('✅ Auto-resolved market \"'.concat(market.title, '\": ').concat(determination.outcome, \" (\").concat(determination.confidence.toFixed(1), \"% confidence)\"));\n                            results.push({\n                                marketId: market.id,\n                                marketTitle: market.title,\n                                outcome: determination.outcome,\n                                confidence: determination.confidence,\n                                reasoning: determination.reasoning,\n                                success: true\n                            });\n                        } else {\n                            failedCount++;\n                            console.log('❌ Failed to resolve market \"'.concat(market.title, '\": ').concat(resolveResult.error));\n                            results.push({\n                                marketId: market.id,\n                                marketTitle: market.title,\n                                outcome: determination.outcome,\n                                confidence: determination.confidence,\n                                reasoning: determination.reasoning,\n                                success: false,\n                                error: resolveResult.error\n                            });\n                        }\n                    } else {\n                        // Insufficient confidence for auto-resolution\n                        console.log('⚠️ Insufficient confidence for market \"'.concat(market.title, '\": ').concat(determination.confidence.toFixed(1), \"% (min: \").concat(minConfidence, \"%)\"));\n                        results.push({\n                            marketId: market.id,\n                            marketTitle: market.title,\n                            outcome: determination.outcome,\n                            confidence: determination.confidence,\n                            reasoning: determination.reasoning,\n                            success: false,\n                            error: \"Insufficient confidence: \".concat(determination.confidence.toFixed(1), \"% < \").concat(minConfidence, \"%\")\n                        });\n                    }\n                } catch (error) {\n                    failedCount++;\n                    console.error('Error processing market \"'.concat(market.title, '\":'), error);\n                    results.push({\n                        marketId: market.id,\n                        marketTitle: market.title,\n                        outcome: null,\n                        confidence: 0,\n                        reasoning: 'Error during processing',\n                        success: false,\n                        error: error.message\n                    });\n                }\n            }\n            console.log(\"Auto-resolution completed: \".concat(resolvedCount, \" resolved, \").concat(failedCount, \" failed\"));\n            return {\n                success: true,\n                processed: expiredMarkets.length,\n                resolved: resolvedCount,\n                failed: failedCount,\n                results\n            };\n        } catch (error) {\n            console.error('Error in autoResolveExpiredMarkets:', error);\n            return {\n                success: false,\n                error: error.message,\n                processed: 0,\n                resolved: 0,\n                failed: 0,\n                results: []\n            };\n        }\n    }\n    /**\n   * Cancel a market and process refunds\n   */ static async cancelMarket(marketId) {\n        let reason = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 'Market cancelled by admin';\n        try {\n            // Try to use the refund processing system, fallback to basic cancellation if not available\n            let refundProcessed = false;\n            let refundSummary = null;\n            try {\n                const { data: refundResult, error: refundError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.rpc('process_market_refunds', {\n                    p_market_id: marketId\n                });\n                if (refundError) {\n                    console.error('Error processing refunds:', refundError);\n                    // Check if it's because the refund system isn't set up\n                    if (refundError.message && (refundError.message.includes('function process_market_refunds') || refundError.message.includes('does not exist'))) {\n                        console.log('Refund system not set up, using basic cancellation');\n                    } else {\n                        console.error('Refund error:', refundError.message || 'Unknown refund error');\n                    }\n                } else {\n                    const result = refundResult === null || refundResult === void 0 ? void 0 : refundResult[0];\n                    if (result && result.success) {\n                        refundProcessed = true;\n                        refundSummary = result;\n                    }\n                }\n            } catch (rpcError) {\n                console.error('Refund RPC call failed:', rpcError);\n            }\n            // If refund system failed, do basic market cancellation\n            if (!refundProcessed) {\n                console.log('Using basic market cancellation');\n                // Update market status to cancelled\n                const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('markets').update({\n                    status: 'cancelled',\n                    cancelled_at: new Date().toISOString(),\n                    cancellation_reason: reason\n                }).eq('id', marketId);\n                if (updateError) {\n                    console.error('Error updating market status:', updateError);\n                    return {\n                        success: false,\n                        error: 'Failed to update market status'\n                    };\n                }\n                refundSummary = {\n                    total_refunds: 0,\n                    refunded_bets: 0,\n                    message: 'Market cancelled (basic cancellation - refund system not available)'\n                };\n            }\n            // Update bet statuses to cancelled\n            const { error: betUpdateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'cancelled'\n            }).eq('market_id', marketId).in('status', [\n                'seeded',\n                'live',\n                'matched'\n            ]);\n            if (betUpdateError) {\n                console.error('Error updating bet statuses:', betUpdateError);\n            // Don't fail the entire operation for this\n            }\n            return {\n                success: true,\n                refundSummary: refundSummary ? {\n                    totalRefunds: refundSummary.total_refunds || 0,\n                    totalAmount: refundSummary.total_amount || 0,\n                    message: refundSummary.message || 'Market cancelled successfully'\n                } : {\n                    totalRefunds: 0,\n                    totalAmount: 0,\n                    message: 'Market cancelled (basic cancellation)'\n                }\n            };\n        } catch (error) {\n            console.error('Error in cancelMarket:', error);\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n    /**\n   * Calculate market prices based on seeded and live betting system\n   * Prices reflect the distribution of both seeded and live money\n   */ static async calculateMarketPrices(marketId) {\n        try {\n            // Get all matched bets for this market\n            const { data: bets, error } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('seeded_amount, live_amount, outcome').eq('market_id', marketId).eq('status', 'matched');\n            if (error) {\n                console.error('Error fetching bets:', error);\n                return {\n                    yes_price: 0.5,\n                    no_price: 0.5,\n                    total_volume: 0,\n                    yes_pool: 0,\n                    no_pool: 0,\n                    seeded_volume: 0,\n                    live_volume: 0\n                };\n            }\n            // Calculate pools for each outcome and type\n            let yesSeededPool = 0;\n            let noSeededPool = 0;\n            let yesLivePool = 0;\n            let noLivePool = 0;\n            let totalSeededVolume = 0;\n            let totalLiveVolume = 0;\n            bets === null || bets === void 0 ? void 0 : bets.forEach((bet)=>{\n                const seededAmount = bet.seeded_amount || 0;\n                const liveAmount = bet.live_amount || 0;\n                totalSeededVolume += seededAmount;\n                totalLiveVolume += liveAmount;\n                if (bet.outcome === 'yes') {\n                    yesSeededPool += seededAmount;\n                    yesLivePool += liveAmount;\n                } else {\n                    noSeededPool += seededAmount;\n                    noLivePool += liveAmount;\n                }\n            });\n            const totalVolume = totalSeededVolume + totalLiveVolume;\n            const yesPool = yesSeededPool + yesLivePool;\n            const noPool = noSeededPool + noLivePool;\n            // Calculate prices based on total pool sizes\n            let yesPrice = 0.5 // Default to 50/50 if no bets\n            ;\n            let noPrice = 0.5;\n            if (totalVolume > 0) {\n                yesPrice = yesPool / totalVolume;\n                noPrice = noPool / totalVolume;\n            }\n            return {\n                yes_price: yesPrice,\n                no_price: noPrice,\n                total_volume: totalVolume,\n                yes_pool: yesPool,\n                no_pool: noPool,\n                seeded_volume: totalSeededVolume,\n                live_volume: totalLiveVolume\n            };\n        } catch (error) {\n            console.error('Error calculating market prices:', error);\n            return {\n                yes_price: 0.5,\n                no_price: 0.5,\n                total_volume: 0,\n                yes_pool: 0,\n                no_pool: 0,\n                seeded_volume: 0,\n                live_volume: 0\n            };\n        }\n    }\n    /**\n   * Get user's portfolio\n   */ static async getUserPortfolio(userId) {\n        try {\n            // Get user profile\n            const { data: profile } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('*').eq('id', userId).single();\n            // Get user's active bets\n            const { data: activeBets } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select(\"\\n          *,\\n          markets (\\n            title,\\n            status,\\n            outcome\\n          )\\n        \").eq('user_id', userId).eq('status', 'matched');\n            // Get user's transaction history for winnings calculation\n            const { data: transactions } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('transactions').select('*').eq('user_id', userId).eq('type', 'win');\n            const totalWinnings = (transactions === null || transactions === void 0 ? void 0 : transactions.reduce((sum, tx)=>sum + tx.amount, 0)) || 0;\n            const totalBets = (activeBets === null || activeBets === void 0 ? void 0 : activeBets.length) || 0;\n            return {\n                profile,\n                activeBets: activeBets || [],\n                totalWinnings,\n                totalBets\n            };\n        } catch (error) {\n            console.error('Error getting user portfolio:', error);\n            return {\n                profile: null,\n                activeBets: [],\n                totalWinnings: 0,\n                totalBets: 0\n            };\n        }\n    }\n    /**\n   * Get market analytics\n   */ static async getMarketAnalytics(marketId) {\n        try {\n            // Get all bets for this market\n            const { data: bets } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('market_id', marketId).eq('status', 'matched');\n            const totalBets = (bets === null || bets === void 0 ? void 0 : bets.length) || 0;\n            const totalVolume = (bets === null || bets === void 0 ? void 0 : bets.reduce((sum, bet)=>sum + bet.amount, 0)) || 0;\n            const yesBets = (bets === null || bets === void 0 ? void 0 : bets.filter((bet)=>bet.outcome === 'yes').length) || 0;\n            const noBets = (bets === null || bets === void 0 ? void 0 : bets.filter((bet)=>bet.outcome === 'no').length) || 0;\n            // Get unique users\n            const uniqueUsers = new Set(bets === null || bets === void 0 ? void 0 : bets.map((bet)=>bet.user_id)).size;\n            // No mock data - return empty price history\n            const priceHistory = [];\n            return {\n                totalBets,\n                totalVolume,\n                yesBets,\n                noBets,\n                uniqueUsers,\n                priceHistory\n            };\n        } catch (error) {\n            console.error('Error getting market analytics:', error);\n            return {\n                totalBets: 0,\n                totalVolume: 0,\n                yesBets: 0,\n                noBets: 0,\n                uniqueUsers: 0,\n                priceHistory: []\n            };\n        }\n    }\n    /**\n   * Cancel a pending bet\n   */ static async cancelBet(betId, userId) {\n        try {\n            // Check if bet exists and belongs to user\n            const { data: bet, error: betError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').select('*').eq('id', betId).eq('user_id', userId).single();\n            if (betError || !bet) {\n                return {\n                    success: false,\n                    error: 'Bet not found'\n                };\n            }\n            // Check if bet is pending\n            if (bet.status !== 'pending') {\n                return {\n                    success: false,\n                    error: 'Cannot cancel matched bet'\n                };\n            }\n            // Update bet status\n            const { error: updateError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('bets').update({\n                status: 'cancelled'\n            }).eq('id', betId);\n            if (updateError) {\n                return {\n                    success: false,\n                    error: updateError.message\n                };\n            }\n            // Refund the user\n            const { error: refundError } = await _supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').update({\n                balance: bet.amount\n            }).eq('id', userId);\n            if (refundError) {\n                return {\n                    success: false,\n                    error: refundError.message\n                };\n            }\n            return {\n                success: true\n            };\n        } catch (error) {\n            return {\n                success: false,\n                error: error.message\n            };\n        }\n    }\n}\n\n\n;\n    // Wrapped in an IIFE to avoid polluting the global scope\n    ;\n    (function () {\n        var _a, _b;\n        // Legacy CSS implementations will `eval` browser code in a Node.js context\n        // to extract CSS. For backwards compatibility, we need to check we're in a\n        // browser context before continuing.\n        if (typeof self !== 'undefined' &&\n            // AMP / No-JS mode does not inject these helpers:\n            '$RefreshHelpers$' in self) {\n            // @ts-ignore __webpack_module__ is global\n            var currentExports = module.exports;\n            // @ts-ignore __webpack_module__ is global\n            var prevSignature = (_b = (_a = module.hot.data) === null || _a === void 0 ? void 0 : _a.prevSignature) !== null && _b !== void 0 ? _b : null;\n            // This cannot happen in MainTemplate because the exports mismatch between\n            // templating and execution.\n            self.$RefreshHelpers$.registerExportsForReactRefresh(currentExports, module.id);\n            // A module can be accepted automatically based on its exports, e.g. when\n            // it is a Refresh Boundary.\n            if (self.$RefreshHelpers$.isReactRefreshBoundary(currentExports)) {\n                // Save the previous exports signature on update so we can compare the boundary\n                // signatures. We avoid saving exports themselves since it causes memory leaks (https://github.com/vercel/next.js/pull/53797)\n                module.hot.dispose(function (data) {\n                    data.prevSignature =\n                        self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports);\n                });\n                // Unconditionally accept an update to this module, we'll check if it's\n                // still a Refresh Boundary later.\n                // @ts-ignore importMeta is replaced in the loader\n                module.hot.accept();\n                // This field is set when the previous version of this module was a\n                // Refresh Boundary, letting us know we need to check for invalidation or\n                // enqueue an update.\n                if (prevSignature !== null) {\n                    // A boundary can become ineligible if its exports are incompatible\n                    // with the previous exports.\n                    //\n                    // For example, if you add/remove/change exports, we'll want to\n                    // re-execute the importing modules, and force those components to\n                    // re-render. Similarly, if you convert a class component to a\n                    // function, we want to invalidate the boundary.\n                    if (self.$RefreshHelpers$.shouldInvalidateReactRefreshBoundary(prevSignature, self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports))) {\n                        module.hot.invalidate();\n                    }\n                    else {\n                        self.$RefreshHelpers$.scheduleUpdate();\n                    }\n                }\n            }\n            else {\n                // Since we just executed the code for the module, it's possible that the\n                // new exports made it ineligible for being a boundary.\n                // We only care about the case when we were _previously_ a boundary,\n                // because we already accepted this update (accidental side effect).\n                var isNoLongerABoundary = prevSignature !== null;\n                if (isNoLongerABoundary) {\n                    module.hot.invalidate();\n                }\n            }\n        }\n    })();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./src/lib/betting.ts\n"));

/***/ })

}]);