"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_N_E"] = self["webpackChunk_N_E"] || []).push([["_app-pages-browser_src_lib_services_notificationService_ts"],{

/***/ "(app-pages-browser)/./src/lib/services/emailService.ts":
/*!******************************************!*\
  !*** ./src/lib/services/emailService.ts ***!
  \******************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EmailService: () => (/* binding */ EmailService),\n/* harmony export */   defaultEmailConfig: () => (/* binding */ defaultEmailConfig),\n/* harmony export */   emailService: () => (/* binding */ emailService)\n/* harmony export */ });\n/* provided dependency */ var process = __webpack_require__(/*! process */ \"(app-pages-browser)/./node_modules/next/dist/build/polyfills/process.js\");\n// Dynamic import for server-side only\nlet nodemailer = null;\nclass EmailService {\n    async initializeTransporter() {\n        if (true) return; // Skip on client side\n        try {\n            nodemailer = await Promise.all(/*! import() */[__webpack_require__.e(\"vendors-_app-pages-browser_node_modules_nodemailer_lib_nodemailer_js\"), __webpack_require__.e(\"_e7a3-_c799-_0340-_81c3-_2590-_121f-_f01f-_eaa8-_43f3-_5595-_b608\")]).then(__webpack_require__.t.bind(__webpack_require__, /*! nodemailer */ \"(app-pages-browser)/./node_modules/nodemailer/lib/nodemailer.js\", 19));\n            this.transporter = nodemailer.createTransporter({\n                host: this.config.host,\n                port: this.config.port,\n                secure: this.config.secure,\n                auth: {\n                    user: this.config.auth.user,\n                    pass: this.config.auth.pass\n                }\n            });\n        } catch (error) {\n            console.error('Failed to initialize email transporter:', error);\n        }\n    }\n    /**\n   * Send an email\n   */ async sendEmail(emailData) {\n        try {\n            // Ensure transporter is initialized\n            if (!this.transporter) {\n                await this.initializeTransporter();\n            }\n            if (!this.transporter) {\n                console.error('Email transporter not available');\n                return false;\n            }\n            const mailOptions = {\n                from: emailData.from || this.config.auth.user,\n                to: emailData.to,\n                subject: emailData.subject,\n                html: emailData.html,\n                text: emailData.text\n            };\n            const result = await this.transporter.sendMail(mailOptions);\n            console.log('Email sent successfully:', result.messageId);\n            return true;\n        } catch (error) {\n            console.error('Error sending email:', error);\n            return false;\n        }\n    }\n    /**\n   * Send welcome email to new user\n   */ async sendWelcomeEmail(userEmail1, userName) {\n        const template = this.getWelcomeEmailTemplate(userName);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send bet result email\n   */ async sendBetResultEmail(userEmail1, userName, outcome, amount, marketTitle) {\n        const template = this.getBetResultEmailTemplate(userName, outcome, amount, marketTitle);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send deposit confirmation email\n   */ async sendDepositConfirmationEmail(userEmail1, userName, amount, transactionId) {\n        const template = this.getDepositConfirmationTemplate(userName, amount, transactionId);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send withdrawal confirmation email\n   */ async sendWithdrawalConfirmationEmail(userEmail1, userName, amount, transactionId) {\n        const template = this.getWithdrawalConfirmationTemplate(userName, amount, transactionId);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send market resolution email\n   */ async sendMarketResolutionEmail(userEmail1, userName, marketTitle, winningOutcome, userOutcome, won, amount) {\n        const template = this.getMarketResolutionTemplate(userName, marketTitle, winningOutcome, userOutcome, won, amount);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Send KYC status email\n   */ async sendKYCStatusEmail(userEmail1, userName, status, reason) {\n        const template = this.getKYCStatusTemplate(userName, status, reason);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    async sendRefundEmail(userEmail1, userName, amount, betId, outcome, marketTitle) {\n        const template = this.getRefundEmailTemplate(userName, amount, betId, outcome, marketTitle);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    async sendMarketRefundEmail(userEmail1, userName, amount, marketId, betCount) {\n        const template = this.getMarketRefundEmailTemplate(userName, amount, marketId, betCount);\n        return this.sendEmail({\n            to: userEmail1,\n            subject: template.subject,\n            html: template.html,\n            text: template.text\n        });\n    }\n    /**\n   * Get welcome email template\n   */ getWelcomeEmailTemplate(userName) {\n        const subject = 'Welcome to BetFusion Zim! 🎉';\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Welcome to BetFusion Zim</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83C\\uDF89 Welcome to BetFusion Zim!</h1>\\n            <p>Your prediction market journey starts here</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello '.concat(userName, \"!</h2>\\n            <p>Welcome to BetFusion Zim, Zimbabwe's premier prediction market platform! We're excited to have you join our community of smart bettors and market predictors.</p>\\n            \\n            <h3>\\uD83D\\uDE80 What you can do:</h3>\\n            <ul>\\n              <li><strong>Bet on Markets:</strong> Predict outcomes on various events and earn rewards</li>\\n              <li><strong>Create Markets:</strong> Start your own prediction markets</li>\\n              <li><strong>Track Performance:</strong> Monitor your betting history and performance</li>\\n              <li><strong>Join Community:</strong> Connect with other predictors and share insights</li>\\n            </ul>\\n            \\n            <p>Ready to start? Your account is all set up and ready to go!</p>\\n            \\n            <a href=\\\"\").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '\" class=\"button\">Start Betting Now</a>\\n            \\n            <h3>\\uD83D\\uDCA1 Quick Tips:</h3>\\n            <ul>\\n              <li>Start with small bets to get familiar with the platform</li>\\n              <li>Read market descriptions carefully before placing bets</li>\\n              <li>Check your email regularly for important updates</li>\\n              <li>Join our community discussions for market insights</li>\\n            </ul>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n            <p>This email was sent to ').concat(userEmail, \". If you didn't create an account, please ignore this email.</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    \");\n        const text = \"\\nWelcome to BetFusion Zim!\\n\\nHello \".concat(userName, \"!\\n\\nWelcome to BetFusion Zim, Zimbabwe's premier prediction market platform! We're excited to have you join our community of smart bettors and market predictors.\\n\\nWhat you can do:\\n- Bet on Markets: Predict outcomes on various events and earn rewards\\n- Create Markets: Start your own prediction markets  \\n- Track Performance: Monitor your betting history and performance\\n- Join Community: Connect with other predictors and share insights\\n\\nReady to start? Your account is all set up and ready to go!\\n\\nVisit: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"\\n\\nQuick Tips:\\n- Start with small bets to get familiar with the platform\\n- Read market descriptions carefully before placing bets\\n- Check your email regularly for important updates\\n- Join our community discussions for market insights\\n\\nBest regards,\\nThe BetFusion Zim Team\\n\\nThis email was sent to \").concat(userEmail, \". If you didn't create an account, please ignore this email.\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get bet result email template\n   */ getBetResultEmailTemplate(userName, outcome, amount, marketTitle) {\n        const isWin = outcome === 'won';\n        const subject = isWin ? \"\\uD83C\\uDF89 You Won $\".concat(amount.toFixed(2), \" on \").concat(marketTitle, \"!\") : \"\\uD83D\\uDCC9 Bet Result: \".concat(marketTitle);\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Bet Result - '.concat(marketTitle, \"</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: \").concat(isWin ? 'linear-gradient(135deg, #10b981 0%, #059669 100%)' : 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)', \"; color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .result-box { background: \").concat(isWin ? '#d1fae5' : '#fee2e2', \"; border: 2px solid \").concat(isWin ? '#10b981' : '#ef4444', '; padding: 20px; border-radius: 8px; margin: 20px 0; text-align: center; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>').concat(isWin ? '🎉 Congratulations!' : '📉 Bet Result', \"</h1>\\n            <p>\").concat(isWin ? 'You won your bet!' : 'Your bet result is in', '</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello ').concat(userName, '!</h2>\\n            \\n            <div class=\"result-box\">\\n              <h3>').concat(isWin ? '🎉 You Won!' : '📉 You Lost', \"</h3>\\n              <p><strong>Market:</strong> \").concat(marketTitle, \"</p>\\n              <p><strong>Amount:</strong> $\").concat(amount.toFixed(2), \"</p>\\n              <p><strong>Result:</strong> \").concat(isWin ? 'Won' : 'Lost', \"</p>\\n            </div>\\n            \\n            \").concat(isWin ? \"\\n              <p>Congratulations! Your prediction was correct and you've won $\".concat(amount.toFixed(2), \"! The funds have been added to your account balance.</p>\\n              <p>Keep up the great work and continue making smart predictions!</p>\\n            \") : \"\\n              <p>Unfortunately, your prediction didn't work out this time. Don't worry - every great predictor has ups and downs!</p>\\n              <p>Keep analyzing the markets and trust your instincts for the next bet.</p>\\n            \", '\\n            \\n            <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '/portfolio\" class=\"button\">View Your Portfolio</a>\\n            \\n            <h3>\\uD83D\\uDCA1 What\\'s Next?</h3>\\n            <ul>\\n              <li>Check out new markets and opportunities</li>\\n              <li>Review your betting strategy</li>\\n              <li>Join community discussions for insights</li>\\n              <li>Create your own prediction markets</li>\\n            </ul>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n\".concat(isWin ? '🎉 Congratulations! You Won!' : '📉 Bet Result', \"\\n\\nHello \").concat(userName, \"!\\n\\n\").concat(isWin ? 'Congratulations! Your prediction was correct and you\\'ve won $' + amount.toFixed(2) + '! The funds have been added to your account balance.' : 'Unfortunately, your prediction didn\\'t work out this time. Don\\'t worry - every great predictor has ups and downs!', \"\\n\\nMarket: \").concat(marketTitle, \"\\nAmount: $\").concat(amount.toFixed(2), \"\\nResult: \").concat(isWin ? 'Won' : 'Lost', \"\\n\\n\").concat(isWin ? 'Keep up the great work and continue making smart predictions!' : 'Keep analyzing the markets and trust your instincts for the next bet.', \"\\n\\nWhat's Next?\\n- Check out new markets and opportunities\\n- Review your betting strategy  \\n- Join community discussions for insights\\n- Create your own prediction markets\\n\\nVisit your portfolio: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"/portfolio\\n\\nBest regards,\\nThe BetFusion Zim Team\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get deposit confirmation template\n   */ getDepositConfirmationTemplate(userName, amount, transactionId) {\n        const subject = \"\\uD83D\\uDCB0 Deposit Confirmation - $\".concat(amount.toFixed(2));\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Deposit Confirmation</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .transaction-box { background: #d1fae5; border: 2px solid #10b981; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83D\\uDCB0 Deposit Confirmed!</h1>\\n            <p>Your funds have been added to your account</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello '.concat(userName, '!</h2>\\n            \\n            <div class=\"transaction-box\">\\n              <h3>\\uD83D\\uDCB0 Deposit Details</h3>\\n              <p><strong>Amount:</strong> $').concat(amount.toFixed(2), \"</p>\\n              <p><strong>Transaction ID:</strong> \").concat(transactionId, \"</p>\\n              <p><strong>Status:</strong> Completed</p>\\n              <p><strong>Date:</strong> \").concat(new Date().toLocaleDateString(), '</p>\\n            </div>\\n            \\n            <p>Your deposit has been successfully processed and the funds are now available in your account. You can start betting immediately!</p>\\n            \\n            <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '/wallet\" class=\"button\">View Your Wallet</a>\\n            \\n            <h3>\\uD83D\\uDE80 Ready to Bet?</h3>\\n            <ul>\\n              <li>Browse available markets</li>\\n              <li>Place your first bet</li>\\n              <li>Create your own markets</li>\\n              <li>Join community discussions</li>\\n            </ul>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n\\uD83D\\uDCB0 Deposit Confirmation\\n\\nHello \".concat(userName, \"!\\n\\nYour deposit has been successfully processed and the funds are now available in your account.\\n\\nDeposit Details:\\n- Amount: $\").concat(amount.toFixed(2), \"\\n- Transaction ID: \").concat(transactionId, \"\\n- Status: Completed\\n- Date: \").concat(new Date().toLocaleDateString(), \"\\n\\nYou can start betting immediately!\\n\\nReady to Bet?\\n- Browse available markets\\n- Place your first bet\\n- Create your own markets\\n- Join community discussions\\n\\nView your wallet: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"/wallet\\n\\nBest regards,\\nThe BetFusion Zim Team\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get withdrawal confirmation template\n   */ getWithdrawalConfirmationTemplate(userName, amount, transactionId) {\n        const subject = \"\\uD83D\\uDCB8 Withdrawal Confirmation - $\".concat(amount.toFixed(2));\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Withdrawal Confirmation</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .transaction-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83D\\uDCB8 Withdrawal Confirmed!</h1>\\n            <p>Your withdrawal request has been processed</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello '.concat(userName, '!</h2>\\n            \\n            <div class=\"transaction-box\">\\n              <h3>\\uD83D\\uDCB8 Withdrawal Details</h3>\\n              <p><strong>Amount:</strong> $').concat(amount.toFixed(2), \"</p>\\n              <p><strong>Transaction ID:</strong> \").concat(transactionId, \"</p>\\n              <p><strong>Status:</strong> Processing</p>\\n              <p><strong>Date:</strong> \").concat(new Date().toLocaleDateString(), '</p>\\n            </div>\\n            \\n            <p>Your withdrawal request has been submitted and is being processed. Funds will be transferred to your account within 1-3 business days.</p>\\n            \\n            <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '/wallet\" class=\"button\">View Your Wallet</a>\\n            \\n            <h3>\\uD83D\\uDCCB Important Notes:</h3>\\n            <ul>\\n              <li>Processing time: 1-3 business days</li>\\n              <li>You\\'ll receive another email when the transfer is complete</li>\\n              <li>Contact support if you have any questions</li>\\n            </ul>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n\\uD83D\\uDCB8 Withdrawal Confirmation\\n\\nHello \".concat(userName, \"!\\n\\nYour withdrawal request has been submitted and is being processed.\\n\\nWithdrawal Details:\\n- Amount: $\").concat(amount.toFixed(2), \"\\n- Transaction ID: \").concat(transactionId, \"\\n- Status: Processing\\n- Date: \").concat(new Date().toLocaleDateString(), \"\\n\\nFunds will be transferred to your account within 1-3 business days.\\n\\nImportant Notes:\\n- Processing time: 1-3 business days\\n- You'll receive another email when the transfer is complete\\n- Contact support if you have any questions\\n\\nView your wallet: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"/wallet\\n\\nBest regards,\\nThe BetFusion Zim Team\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get market resolution template\n   */ getMarketResolutionTemplate(userName, marketTitle, winningOutcome, userOutcome, won, amount) {\n        const subject = \"\\uD83C\\uDFC1 Market Resolved: \".concat(marketTitle);\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Market Resolution - '.concat(marketTitle, \"</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .result-box { background: \").concat(won ? '#d1fae5' : '#fee2e2', \"; border: 2px solid \").concat(won ? '#10b981' : '#ef4444', '; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83C\\uDFC1 Market Resolved!</h1>\\n            <p>The market has been closed and results are in</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello ').concat(userName, '!</h2>\\n            \\n            <div class=\"result-box\">\\n              <h3>\\uD83C\\uDFC1 Market Results</h3>\\n              <p><strong>Market:</strong> ').concat(marketTitle, \"</p>\\n              <p><strong>Winning Outcome:</strong> \").concat(winningOutcome, \"</p>\\n              <p><strong>Your Prediction:</strong> \").concat(userOutcome, \"</p>\\n              <p><strong>Result:</strong> \").concat(won ? '🎉 You Won!' : '📉 You Lost', \"</p>\\n              \").concat(won ? \"<p><strong>Winnings:</strong> $\".concat(amount.toFixed(2), \"</p>\") : '', '\\n            </div>\\n            \\n            <p>The market \"').concat(marketTitle, '\" has been resolved. ').concat(won ? 'Congratulations on your winning prediction!' : 'Better luck next time!', '</p>\\n            \\n            <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '/portfolio\" class=\"button\">View Your Portfolio</a>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n\\uD83C\\uDFC1 Market Resolved!\\n\\nHello \".concat(userName, '!\\n\\nThe market \"').concat(marketTitle, '\" has been resolved.\\n\\nMarket Results:\\n- Market: ').concat(marketTitle, \"\\n- Winning Outcome: \").concat(winningOutcome, \"\\n- Your Prediction: \").concat(userOutcome, \"\\n- Result: \").concat(won ? '🎉 You Won!' : '📉 You Lost', \"\\n\").concat(won ? \"- Winnings: $\".concat(amount.toFixed(2)) : '', \"\\n\\n\").concat(won ? 'Congratulations on your winning prediction!' : 'Better luck next time!', \"\\n\\nView your portfolio: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"/portfolio\\n\\nBest regards,\\nThe BetFusion Zim Team\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get KYC status template\n   */ getKYCStatusTemplate(userName, status, reason) {\n        const isApproved = status === 'approved';\n        const subject = isApproved ? '✅ KYC Verification Approved!' : '❌ KYC Verification Update';\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>KYC '.concat(isApproved ? 'Approved' : 'Update', \"</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: \").concat(isApproved ? 'linear-gradient(135deg, #10b981 0%, #059669 100%)' : 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)', \"; color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .status-box { background: \").concat(isApproved ? '#d1fae5' : '#fee2e2', \"; border: 2px solid \").concat(isApproved ? '#10b981' : '#ef4444', '; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>').concat(isApproved ? '✅ KYC Approved!' : '❌ KYC Update', \"</h1>\\n            <p>\").concat(isApproved ? 'Your identity has been verified' : 'Your KYC status has been updated', '</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello ').concat(userName, '!</h2>\\n            \\n            <div class=\"status-box\">\\n              <h3>').concat(isApproved ? '✅ Verification Approved' : '❌ Verification Update', \"</h3>\\n              <p><strong>Status:</strong> \").concat(isApproved ? 'Approved' : 'Rejected', \"</p>\\n              \").concat(!isApproved && reason ? \"<p><strong>Reason:</strong> \".concat(reason, \"</p>\") : '', \"\\n              <p><strong>Date:</strong> \").concat(new Date().toLocaleDateString(), \"</p>\\n            </div>\\n            \\n            \").concat(isApproved ? \"\\n              <p>Congratulations! Your identity has been successfully verified. You now have full access to all platform features including higher withdrawal limits and enhanced security.</p>\\n              <p>You can now enjoy all the benefits of a verified account!</p>\\n            \" : \"\\n              <p>We were unable to verify your identity at this time. \".concat(reason ? \"Reason: \".concat(reason) : 'Please ensure all documents are clear and valid.', \"</p>\\n              <p>You can resubmit your KYC documents for review.</p>\\n            \"), '\\n            \\n            <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', '/kyc\" class=\"button\">').concat(isApproved ? 'View Your Profile' : 'Resubmit KYC', '</a>\\n          </div>\\n          <div class=\"footer\">\\n            <p>Best regards,<br>The BetFusion Zim Team</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n\".concat(isApproved ? '✅ KYC Approved!' : '❌ KYC Update', \"\\n\\nHello \").concat(userName, \"!\\n\\n\").concat(isApproved ? 'Congratulations! Your identity has been successfully verified. You now have full access to all platform features including higher withdrawal limits and enhanced security.' : 'We were unable to verify your identity at this time. ' + (reason ? \"Reason: \".concat(reason) : 'Please ensure all documents are clear and valid.'), \"\\n\\nStatus: \").concat(isApproved ? 'Approved' : 'Rejected', \"\\n\").concat(!isApproved && reason ? \"Reason: \".concat(reason) : '', \"\\nDate: \").concat(new Date().toLocaleDateString(), \"\\n\\n\").concat(isApproved ? 'You can now enjoy all the benefits of a verified account!' : 'You can resubmit your KYC documents for review.', \"\\n\\n\").concat(isApproved ? 'View your profile' : 'Resubmit KYC', \": \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'http://localhost:3000', \"/kyc\\n\\nBest regards,\\nThe BetFusion Zim Team\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get refund email template\n   */ getRefundEmailTemplate(userName, amount, betId, outcome, marketTitle) {\n        const subject = \"\\uD83D\\uDCB0 Bet Refund Processed - $\".concat(amount.toFixed(2));\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Bet Refund Processed</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .refund-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83D\\uDCB0 Bet Refund Processed</h1>\\n            <p>Your bet has been refunded successfully</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello '.concat(userName, '!</h2>\\n            <p>Your bet has been refunded and the amount has been added back to your account balance.</p>\\n            \\n            <div class=\"refund-box\">\\n              <h3>Refund Details</h3>\\n              <p><strong>Refund Amount:</strong> $').concat(amount.toFixed(2), \"</p>\\n              <p><strong>Bet ID:</strong> \").concat(betId, \"</p>\\n              <p><strong>Outcome:</strong> \").concat(outcome, \"</p>\\n              <p><strong>Market:</strong> \").concat(marketTitle, '</p>\\n            </div>\\n            \\n            <div style=\"background: #d1fae5; border: 2px solid #10b981; padding: 15px; border-radius: 8px; margin: 20px 0;\">\\n              <p style=\"margin: 0; color: #166534;\"><strong>✅ Refund Complete</strong><br>\\n              The refunded amount is now available in your account balance and can be used for new bets or withdrawals.</p>\\n            </div>\\n            \\n            <div style=\"text-align: center;\">\\n              <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com', '/wallet\" class=\"button\">View Your Wallet</a>\\n            </div>\\n            \\n            <p>If you have any questions about this refund, please contact our support team.</p>\\n          </div>\\n          <div class=\"footer\">\\n            <p>\\xa9 2024 BetFusion Zim. All rights reserved.</p>\\n            <p>This is an automated message. Please do not reply to this email.</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n      Bet Refund Processed - BetFusion Zim\\n      \\n      Hello \".concat(userName, \"!\\n      \\n      Your bet has been refunded and the amount has been added back to your account balance.\\n      \\n      Refund Details:\\n      - Refund Amount: $\").concat(amount.toFixed(2), \"\\n      - Bet ID: \").concat(betId, \"\\n      - Outcome: \").concat(outcome, \"\\n      - Market: \").concat(marketTitle, \"\\n      \\n      The refunded amount is now available in your account balance and can be used for new bets or withdrawals.\\n      \\n      View Your Wallet: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com', \"/wallet\\n      \\n      If you have any questions about this refund, please contact our support team.\\n      \\n      \\xa9 2024 BetFusion Zim. All rights reserved.\\n      This is an automated message. Please do not reply to this email.\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    /**\n   * Get market refund email template\n   */ getMarketRefundEmailTemplate(userName, amount, marketId, betCount) {\n        const subject = \"\\uD83D\\uDCB0 Market Refund Processed - $\".concat(amount.toFixed(2));\n        const html = '\\n      <!DOCTYPE html>\\n      <html>\\n      <head>\\n        <meta charset=\"utf-8\">\\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\\n        <title>Market Refund Processed</title>\\n        <style>\\n          body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }\\n          .container { max-width: 600px; margin: 0 auto; padding: 20px; }\\n          .header { background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }\\n          .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }\\n          .refund-box { background: #fef3c7; border: 2px solid #f59e0b; padding: 20px; border-radius: 8px; margin: 20px 0; }\\n          .button { display: inline-block; background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }\\n          .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }\\n        </style>\\n      </head>\\n      <body>\\n        <div class=\"container\">\\n          <div class=\"header\">\\n            <h1>\\uD83D\\uDCB0 Market Refund Processed</h1>\\n            <p>Your market bets have been refunded successfully</p>\\n          </div>\\n          <div class=\"content\">\\n            <h2>Hello '.concat(userName, '!</h2>\\n            <p>All your bets in this market have been refunded and the total amount has been added back to your account balance.</p>\\n            \\n            <div class=\"refund-box\">\\n              <h3>Market Refund Details</h3>\\n              <p><strong>Total Refund Amount:</strong> $').concat(amount.toFixed(2), \"</p>\\n              <p><strong>Market ID:</strong> \").concat(marketId, \"</p>\\n              <p><strong>Number of Bets Refunded:</strong> \").concat(betCount, '</p>\\n            </div>\\n            \\n            <div style=\"background: #d1fae5; border: 2px solid #10b981; padding: 15px; border-radius: 8px; margin: 20px 0;\">\\n              <p style=\"margin: 0; color: #166534;\"><strong>✅ Market Refund Complete</strong><br>\\n              All your bets in this market have been refunded. The total amount is now available in your account balance and can be used for new bets or withdrawals.</p>\\n            </div>\\n            \\n            <div style=\"text-align: center;\">\\n              <a href=\"').concat(process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com', '/wallet\" class=\"button\">View Your Wallet</a>\\n            </div>\\n            \\n            <p>If you have any questions about this market refund, please contact our support team.</p>\\n          </div>\\n          <div class=\"footer\">\\n            <p>\\xa9 2024 BetFusion Zim. All rights reserved.</p>\\n            <p>This is an automated message. Please do not reply to this email.</p>\\n          </div>\\n        </div>\\n      </body>\\n      </html>\\n    ');\n        const text = \"\\n      Market Refund Processed - BetFusion Zim\\n      \\n      Hello \".concat(userName, \"!\\n      \\n      All your bets in this market have been refunded and the total amount has been added back to your account balance.\\n      \\n      Market Refund Details:\\n      - Total Refund Amount: $\").concat(amount.toFixed(2), \"\\n      - Market ID: \").concat(marketId, \"\\n      - Number of Bets Refunded: \").concat(betCount, \"\\n      \\n      All your bets in this market have been refunded. The total amount is now available in your account balance and can be used for new bets or withdrawals.\\n      \\n      View Your Wallet: \").concat(process.env.NEXT_PUBLIC_SITE_URL || 'https://betfusionzim.com', \"/wallet\\n      \\n      If you have any questions about this market refund, please contact our support team.\\n      \\n      \\xa9 2024 BetFusion Zim. All rights reserved.\\n      This is an automated message. Please do not reply to this email.\\n    \");\n        return {\n            subject,\n            html,\n            text\n        };\n    }\n    constructor(config){\n        this.transporter = null;\n        this.config = config;\n        // Initialize transporter only on server side\n        if (false) {}\n    }\n}\n// Default email configuration\nconst defaultEmailConfig = {\n    host: process.env.SMTP_HOST || 'smtp.gmail.com',\n    port: parseInt(process.env.SMTP_PORT || '587'),\n    secure: process.env.SMTP_SECURE === 'true',\n    auth: {\n        user: process.env.SMTP_USER || '',\n        pass: process.env.SMTP_PASS || ''\n    }\n};\n// Create default email service instance\nconst emailService = new EmailService(defaultEmailConfig);\n\n\n;\n    // Wrapped in an IIFE to avoid polluting the global scope\n    ;\n    (function () {\n        var _a, _b;\n        // Legacy CSS implementations will `eval` browser code in a Node.js context\n        // to extract CSS. For backwards compatibility, we need to check we're in a\n        // browser context before continuing.\n        if (typeof self !== 'undefined' &&\n            // AMP / No-JS mode does not inject these helpers:\n            '$RefreshHelpers$' in self) {\n            // @ts-ignore __webpack_module__ is global\n            var currentExports = module.exports;\n            // @ts-ignore __webpack_module__ is global\n            var prevSignature = (_b = (_a = module.hot.data) === null || _a === void 0 ? void 0 : _a.prevSignature) !== null && _b !== void 0 ? _b : null;\n            // This cannot happen in MainTemplate because the exports mismatch between\n            // templating and execution.\n            self.$RefreshHelpers$.registerExportsForReactRefresh(currentExports, module.id);\n            // A module can be accepted automatically based on its exports, e.g. when\n            // it is a Refresh Boundary.\n            if (self.$RefreshHelpers$.isReactRefreshBoundary(currentExports)) {\n                // Save the previous exports signature on update so we can compare the boundary\n                // signatures. We avoid saving exports themselves since it causes memory leaks (https://github.com/vercel/next.js/pull/53797)\n                module.hot.dispose(function (data) {\n                    data.prevSignature =\n                        self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports);\n                });\n                // Unconditionally accept an update to this module, we'll check if it's\n                // still a Refresh Boundary later.\n                // @ts-ignore importMeta is replaced in the loader\n                module.hot.accept();\n                // This field is set when the previous version of this module was a\n                // Refresh Boundary, letting us know we need to check for invalidation or\n                // enqueue an update.\n                if (prevSignature !== null) {\n                    // A boundary can become ineligible if its exports are incompatible\n                    // with the previous exports.\n                    //\n                    // For example, if you add/remove/change exports, we'll want to\n                    // re-execute the importing modules, and force those components to\n                    // re-render. Similarly, if you convert a class component to a\n                    // function, we want to invalidate the boundary.\n                    if (self.$RefreshHelpers$.shouldInvalidateReactRefreshBoundary(prevSignature, self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports))) {\n                        module.hot.invalidate();\n                    }\n                    else {\n                        self.$RefreshHelpers$.scheduleUpdate();\n                    }\n                }\n            }\n            else {\n                // Since we just executed the code for the module, it's possible that the\n                // new exports made it ineligible for being a boundary.\n                // We only care about the case when we were _previously_ a boundary,\n                // because we already accepted this update (accidental side effect).\n                var isNoLongerABoundary = prevSignature !== null;\n                if (isNoLongerABoundary) {\n                    module.hot.invalidate();\n                }\n            }\n        }\n    })();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./src/lib/services/emailService.ts\n"));

/***/ }),

/***/ "(app-pages-browser)/./src/lib/services/notificationService.ts":
/*!*************************************************!*\
  !*** ./src/lib/services/notificationService.ts ***!
  \*************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

eval(__webpack_require__.ts("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NotificationService: () => (/* binding */ NotificationService),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @/lib/supabase-client */ \"(app-pages-browser)/./src/lib/supabase-client.ts\");\n/* harmony import */ var _emailService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emailService */ \"(app-pages-browser)/./src/lib/services/emailService.ts\");\n// Notification Service for BetFusion Zim\n// Handles real-time notifications for various events\n\n\nclass NotificationService {\n    /**\n   * Create a new notification\n   */ static async createNotification(userId, title, message) {\n        let type = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : 'info', data = arguments.length > 4 ? arguments[4] : void 0, sendEmail = arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : false;\n        try {\n            const { data: notification, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').insert({\n                user_id: userId,\n                title,\n                message,\n                type,\n                data,\n                is_read: false\n            }).select().single();\n            if (error) {\n                console.error('Error creating notification:', error);\n                return null;\n            }\n            // Send email if requested\n            if (sendEmail) {\n                await this.sendNotificationEmail(userId, title, message, type, data);\n            }\n            return notification;\n        } catch (error) {\n            console.error('Error in createNotification:', error);\n            return null;\n        }\n    }\n    /**\n   * Get user notifications\n   */ static async getUserNotifications(userId) {\n        let limit = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : 20, unreadOnly = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;\n        try {\n            let query = _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').select('*').eq('user_id', userId).order('created_at', {\n                ascending: false\n            }).limit(limit);\n            if (unreadOnly) {\n                query = query.eq('is_read', false);\n            }\n            const { data, error } = await query;\n            if (error) {\n                console.error('Error fetching notifications:', error);\n                return [];\n            }\n            return data || [];\n        } catch (error) {\n            console.error('Error in getUserNotifications:', error);\n            return [];\n        }\n    }\n    /**\n   * Mark notification as read\n   */ static async markAsRead(notificationId) {\n        try {\n            const { error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').update({\n                is_read: true,\n                updated_at: new Date().toISOString()\n            }).eq('id', notificationId);\n            if (error) {\n                console.error('Error marking notification as read:', error);\n                return false;\n            }\n            return true;\n        } catch (error) {\n            console.error('Error in markAsRead:', error);\n            return false;\n        }\n    }\n    /**\n   * Mark all notifications as read for a user\n   */ static async markAllAsRead(userId) {\n        try {\n            const { error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').update({\n                is_read: true,\n                updated_at: new Date().toISOString()\n            }).eq('user_id', userId).eq('is_read', false);\n            if (error) {\n                console.error('Error marking all notifications as read:', error);\n                return false;\n            }\n            return true;\n        } catch (error) {\n            console.error('Error in markAllAsRead:', error);\n            return false;\n        }\n    }\n    /**\n   * Get unread notification count\n   */ static async getUnreadCount(userId) {\n        try {\n            const { count, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('notifications').select('*', {\n                count: 'exact',\n                head: true\n            }).eq('user_id', userId).eq('is_read', false);\n            if (error) {\n                console.error('Error getting unread count:', error);\n                return 0;\n            }\n            return count || 0;\n        } catch (error) {\n            console.error('Error in getUnreadCount:', error);\n            return 0;\n        }\n    }\n    /**\n   * Notification templates for different events\n   */ static getNotificationTemplate(type, data) {\n        switch(type){\n            case 'bet_won':\n                var _data_amount;\n                return {\n                    title: '🎉 Bet Won!',\n                    message: \"Congratulations! You won $\".concat((data === null || data === void 0 ? void 0 : (_data_amount = data.amount) === null || _data_amount === void 0 ? void 0 : _data_amount.toFixed(2)) || '0.00', ' on \"').concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'your bet', '\"'),\n                    notificationType: 'success'\n                };\n            case 'bet_lost':\n                return {\n                    title: 'Bet Result',\n                    message: 'Your bet on \"'.concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'the market', \"\\\" didn't win this time. Better luck next time!\"),\n                    notificationType: 'info'\n                };\n            case 'new_market_available':\n                return {\n                    title: '🆕 New Market Available',\n                    message: '\"'.concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'New market', '\" is now live for betting!'),\n                    notificationType: 'info'\n                };\n            case 'market_resolved':\n                return {\n                    title: 'Market Resolved',\n                    message: '\"'.concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'Market', '\" has been resolved. Check your results!'),\n                    notificationType: 'info'\n                };\n            case 'deposit_received':\n                var _data_amount1;\n                return {\n                    title: '💰 Deposit Received',\n                    message: \"Your deposit of $\".concat((data === null || data === void 0 ? void 0 : (_data_amount1 = data.amount) === null || _data_amount1 === void 0 ? void 0 : _data_amount1.toFixed(2)) || '0.00', \" has been processed successfully.\"),\n                    notificationType: 'success'\n                };\n            case 'withdrawal_processed':\n                var _data_amount2;\n                return {\n                    title: '💸 Withdrawal Processed',\n                    message: \"Your withdrawal of $\".concat((data === null || data === void 0 ? void 0 : (_data_amount2 = data.amount) === null || _data_amount2 === void 0 ? void 0 : _data_amount2.toFixed(2)) || '0.00', \" has been processed.\"),\n                    notificationType: 'success'\n                };\n            case 'referral_bonus':\n                var _data_amount3;\n                return {\n                    title: '🎁 Referral Bonus',\n                    message: \"You received a $\".concat((data === null || data === void 0 ? void 0 : (_data_amount3 = data.amount) === null || _data_amount3 === void 0 ? void 0 : _data_amount3.toFixed(2)) || '0.00', \" bonus for referring a friend!\"),\n                    notificationType: 'success'\n                };\n            case 'achievement_unlocked':\n                return {\n                    title: '🏆 Achievement Unlocked',\n                    message: \"You've unlocked the \\\"\".concat((data === null || data === void 0 ? void 0 : data.achievementName) || 'Achievement', '\" achievement!'),\n                    notificationType: 'success'\n                };\n            case 'price_alert':\n                return {\n                    title: '📈 Price Alert',\n                    message: '\"'.concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'Market', '\" price has reached your alert level of ').concat((data === null || data === void 0 ? void 0 : data.price) || '0', \"%\"),\n                    notificationType: 'warning'\n                };\n            case 'liquidity_reward':\n                var _data_amount4;\n                return {\n                    title: '💧 Liquidity Reward',\n                    message: \"You earned $\".concat((data === null || data === void 0 ? void 0 : (_data_amount4 = data.amount) === null || _data_amount4 === void 0 ? void 0 : _data_amount4.toFixed(2)) || '0.00', ' for providing liquidity to \"').concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'market', '\"'),\n                    notificationType: 'success'\n                };\n            case 'market_seeded':\n                var _data_amount5;\n                return {\n                    title: '🌱 Market Seeded',\n                    message: 'Your market \"'.concat((data === null || data === void 0 ? void 0 : data.marketTitle) || 'Market', '\" has been successfully seeded with $').concat((data === null || data === void 0 ? void 0 : (_data_amount5 = data.amount) === null || _data_amount5 === void 0 ? void 0 : _data_amount5.toFixed(2)) || '0.00'),\n                    notificationType: 'success'\n                };\n            case 'kyc_approved':\n                return {\n                    title: '✅ KYC Approved',\n                    message: 'Your identity verification has been approved. You now have full access to all features.',\n                    notificationType: 'success'\n                };\n            case 'kyc_rejected':\n                return {\n                    title: '❌ KYC Rejected',\n                    message: \"Your identity verification was rejected. Reason: \".concat((data === null || data === void 0 ? void 0 : data.reason) || 'Please try again'),\n                    notificationType: 'error'\n                };\n            default:\n                return {\n                    title: 'Notification',\n                    message: 'You have a new notification',\n                    notificationType: 'info'\n                };\n        }\n    }\n    /**\n   * Create notification for specific event type\n   */ static async createEventNotification(userId, eventType, eventData) {\n        let sendEmail = arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : false;\n        const template = this.getNotificationTemplate(eventType, eventData);\n        return this.createNotification(userId, template.title, template.message, template.notificationType, eventData, sendEmail);\n    }\n    /**\n   * Bulk create notifications for multiple users\n   */ static async createBulkNotifications(userIds, eventType, eventData) {\n        const template = this.getNotificationTemplate(eventType, eventData);\n        const notifications = [];\n        for (const userId of userIds){\n            const notification = await this.createNotification(userId, template.title, template.message, template.notificationType, eventData);\n            if (notification) {\n                notifications.push(notification);\n            }\n        }\n        return notifications;\n    }\n    /**\n   * Send notification email to user\n   */ static async sendNotificationEmail(userId, title, message, type, data) {\n        try {\n            // Get user profile to get email and name\n            const { data: profile, error: profileError } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('email, first_name, last_name').eq('id', userId).single();\n            if (profileError || !(profile === null || profile === void 0 ? void 0 : profile.email)) {\n                console.error('Error fetching user profile for email:', profileError);\n                return;\n            }\n            const userName = profile.first_name || 'User';\n            const userEmail = profile.email;\n            // Send appropriate email based on notification type\n            switch(type){\n                case 'success':\n                    if (data === null || data === void 0 ? void 0 : data.betResult) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendBetResultEmail(userEmail, userName, data.betResult.outcome, data.betResult.amount, data.betResult.marketTitle);\n                    } else if (data === null || data === void 0 ? void 0 : data.deposit) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendDepositConfirmationEmail(userEmail, userName, data.deposit.amount, data.deposit.transactionId);\n                    } else if (data === null || data === void 0 ? void 0 : data.withdrawal) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendWithdrawalConfirmationEmail(userEmail, userName, data.withdrawal.amount, data.withdrawal.transactionId);\n                    } else if (data === null || data === void 0 ? void 0 : data.kycStatus) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendKYCStatusEmail(userEmail, userName, data.kycStatus.status, data.kycStatus.reason);\n                    }\n                    break;\n                case 'info':\n                    if (data === null || data === void 0 ? void 0 : data.marketResolution) {\n                        await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendMarketResolutionEmail(userEmail, userName, data.marketResolution.marketTitle, data.marketResolution.winningOutcome, data.marketResolution.userOutcome, data.marketResolution.won, data.marketResolution.amount);\n                    }\n                    break;\n                default:\n                    // Send generic notification email\n                    await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendEmail({\n                        to: userEmail,\n                        subject: title,\n                        html: '\\n              <div style=\"font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;\">\\n                <h2>'.concat(title, \"</h2>\\n                <p>\").concat(message, \"</p>\\n                <p>Best regards,<br>The BetFusion Zim Team</p>\\n              </div>\\n            \"),\n                        text: \"\".concat(title, \"\\n\\n\").concat(message, \"\\n\\nBest regards,\\nThe BetFusion Zim Team\")\n                    });\n                    break;\n            }\n        } catch (error) {\n            console.error('Error sending notification email:', error);\n        }\n    }\n    /**\n   * Send welcome email to new user\n   */ static async sendWelcomeEmail(userId) {\n        try {\n            const { data: profile, error } = await _lib_supabase_client__WEBPACK_IMPORTED_MODULE_0__.supabase.from('profiles').select('email, first_name').eq('id', userId).single();\n            if (error || !(profile === null || profile === void 0 ? void 0 : profile.email)) {\n                console.error('Error fetching user profile for welcome email:', error);\n                return false;\n            }\n            return await _emailService__WEBPACK_IMPORTED_MODULE_1__.emailService.sendWelcomeEmail(profile.email, profile.first_name || 'User');\n        } catch (error) {\n            console.error('Error sending welcome email:', error);\n            return false;\n        }\n    }\n}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationService);\n\n\n;\n    // Wrapped in an IIFE to avoid polluting the global scope\n    ;\n    (function () {\n        var _a, _b;\n        // Legacy CSS implementations will `eval` browser code in a Node.js context\n        // to extract CSS. For backwards compatibility, we need to check we're in a\n        // browser context before continuing.\n        if (typeof self !== 'undefined' &&\n            // AMP / No-JS mode does not inject these helpers:\n            '$RefreshHelpers$' in self) {\n            // @ts-ignore __webpack_module__ is global\n            var currentExports = module.exports;\n            // @ts-ignore __webpack_module__ is global\n            var prevSignature = (_b = (_a = module.hot.data) === null || _a === void 0 ? void 0 : _a.prevSignature) !== null && _b !== void 0 ? _b : null;\n            // This cannot happen in MainTemplate because the exports mismatch between\n            // templating and execution.\n            self.$RefreshHelpers$.registerExportsForReactRefresh(currentExports, module.id);\n            // A module can be accepted automatically based on its exports, e.g. when\n            // it is a Refresh Boundary.\n            if (self.$RefreshHelpers$.isReactRefreshBoundary(currentExports)) {\n                // Save the previous exports signature on update so we can compare the boundary\n                // signatures. We avoid saving exports themselves since it causes memory leaks (https://github.com/vercel/next.js/pull/53797)\n                module.hot.dispose(function (data) {\n                    data.prevSignature =\n                        self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports);\n                });\n                // Unconditionally accept an update to this module, we'll check if it's\n                // still a Refresh Boundary later.\n                // @ts-ignore importMeta is replaced in the loader\n                module.hot.accept();\n                // This field is set when the previous version of this module was a\n                // Refresh Boundary, letting us know we need to check for invalidation or\n                // enqueue an update.\n                if (prevSignature !== null) {\n                    // A boundary can become ineligible if its exports are incompatible\n                    // with the previous exports.\n                    //\n                    // For example, if you add/remove/change exports, we'll want to\n                    // re-execute the importing modules, and force those components to\n                    // re-render. Similarly, if you convert a class component to a\n                    // function, we want to invalidate the boundary.\n                    if (self.$RefreshHelpers$.shouldInvalidateReactRefreshBoundary(prevSignature, self.$RefreshHelpers$.getRefreshBoundarySignature(currentExports))) {\n                        module.hot.invalidate();\n                    }\n                    else {\n                        self.$RefreshHelpers$.scheduleUpdate();\n                    }\n                }\n            }\n            else {\n                // Since we just executed the code for the module, it's possible that the\n                // new exports made it ineligible for being a boundary.\n                // We only care about the case when we were _previously_ a boundary,\n                // because we already accepted this update (accidental side effect).\n                var isNoLongerABoundary = prevSignature !== null;\n                if (isNoLongerABoundary) {\n                    module.hot.invalidate();\n                }\n            }\n        }\n    })();\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(app-pages-browser)/./src/lib/services/notificationService.ts\n"));

/***/ })

}]);