# Create Zimbabwe Markets

This script creates 25 Zimbabwe-related prediction markets using the admin account.

## Prerequisites

1. **Admin Account**: You need an admin user account in your database
2. **Environment Variables**: Set up your Supabase credentials
3. **Database Access**: Ensure your Supabase database is accessible

## Setup

### 1. Set Environment Variables

Create a `.env.local` file in your project root:

```env
NEXT_PUBLIC_SUPABASE_URL=your_supabase_project_url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_supabase_anon_key
```

### 2. Install Dependencies

```bash
npm install @supabase/supabase-js
```

### 3. Run the Script

```bash
node seed-zimbabwe-markets.js
```

## What This Creates

The script creates 25 markets covering:

- **Economics**: Inflation, GDP growth, currency, unemployment, FDI
- **Politics**: Elections, opposition performance, corruption
- **Sectors**: Mining, agriculture, tourism, manufacturing
- **Social**: Education, healthcare, demographics
- **Technology**: Internet penetration, mobile money
- **Environment**: Climate funding, renewable energy

## Market Features

Each market includes:

- ✅ **Realistic Prices**: Based on current Zimbabwe economic conditions
- ✅ **Volume**: Random trading volume between $6,000-$25,000
- ✅ **Liquidity**: Initial liquidity provided by admin
- ✅ **Categories**: Proper categorization for filtering
- ✅ **End Dates**: All markets end on December 31, 2024

## Sample Markets

1. "Will Zimbabwe's inflation rate drop below 50% by end of 2024?"
2. "Will Zimbabwe introduce a new currency in 2024?"
3. "Will Zimbabwe hold free and fair elections in 2024?"
4. "Will Zimbabwe receive IMF funding in 2024?"
5. "Will Zimbabwe's tourism arrivals exceed 2 million in 2024?"

## Troubleshooting

### No Admin User Found
```bash
# Create an admin user first
# You can do this through your Supabase dashboard or create a user and update their profile
```

### Environment Variables Not Set
```bash
# Make sure your .env.local file exists and has the correct values
echo $NEXT_PUBLIC_SUPABASE_URL
echo $NEXT_PUBLIC_SUPABASE_ANON_KEY
```

### Database Connection Issues
- Check your Supabase project is active
- Verify your API keys are correct
- Ensure RLS policies allow market creation

## Expected Output

```
🚀 Starting to create Zimbabwe markets...
🔍 Looking for admin user...
✅ Admin user found: admin@example.com
📝 Creating market 1/25: Will Zimbabwe's inflation rate drop below 50%...
✅ Market 1 created: 12345678-1234-1234-1234-123456789012
💰 Added liquidity to market 1
...
🎉 Market creation completed!
✅ Successfully created: 25 markets
❌ Failed to create: 0 markets

🌍 Your Zimbabwe markets are now live!
Visit your homepage to see them in action.
```

## After Creation

1. **Visit Homepage**: See all markets on the main page
2. **Filter by Category**: Use the category filters to browse
3. **Search Markets**: Use the search functionality
4. **Admin Panel**: Manage markets from the admin dashboard
5. **Trading**: Users can now bet on these markets

## Market Categories Created

- **Economics** (8 markets): Inflation, GDP, currency, unemployment, FDI, debt, exports, manufacturing
- **Politics** (3 markets): Elections, opposition, corruption
- **Sectors** (4 markets): Mining, agriculture, tourism, manufacturing
- **Social** (4 markets): Education, healthcare, demographics, literacy
- **Technology** (2 markets): Internet, mobile money
- **Finance** (1 market): Stock market
- **Environment** (1 market): Climate funding
- **Energy** (1 market): Renewable energy
- **Demographics** (1 market): Urbanization

Total: **25 Zimbabwe-focused prediction markets**

