# Fix Bet Management Issues

You're having issues with managing, approving, and scheduling bets. Here's how to fix these problems.

## 🚀 **Quick Fix - Run This SQL Script**

Copy and paste the entire content of `fix-bet-management.sql` into your Supabase SQL Editor and run it. This will fix all bet management issues.

## 📋 **What the Fix Does**

### **1. Fixes Bets Table Structure**
- ✅ **Adds missing columns** (`seeded_amount`, `live_amount`, `potential_payout`)
- ✅ **Updates existing bets** with calculated values
- ✅ **Creates performance indexes** for better queries
- ✅ **Ensures foreign key constraints** exist

### **2. Fixes Bet Status Management**
- ✅ **Updates bet statuses** to match expected values
- ✅ **Creates proper indexes** for status filtering
- ✅ **Ensures data consistency** across all bets

### **3. Fixes Admin Interface**
- ✅ **Removes problematic foreign key references** in queries
- ✅ **Simplifies data fetching** to avoid errors
- ✅ **Creates admin view** for better performance

## 🧪 **Test the Fix**

### **Step 1: Run the SQL Script**
1. **Open Supabase SQL Editor**
2. **Copy the entire content** of `fix-bet-management.sql`
3. **Paste and run** the script
4. **Verify success** with the output messages

### **Step 2: Test Admin Bet Management**
1. **Visit `/admin/bets`** in your application
2. **Verify bets load** without errors
3. **Test bet actions** (match, cancel, refund, resolve)
4. **Check filtering** by status works

### **Step 3: Test Bet Scheduling**
1. **Create a new market** with pending status
2. **Place seeded bets** on the market
3. **Test market activation** to move bets to live
4. **Verify bet status changes** work properly

## 📊 **Expected Results**

### **Before Fix**
```
❌ Cannot manage bets - database errors
❌ Cannot approve bets - missing columns
❌ Cannot schedule bets - status issues
❌ Admin interface fails to load
```

### **After Fix**
```
✅ Admin bet management works
✅ Bet approval system functions
✅ Bet scheduling works properly
✅ All bet actions available
```

## 🔧 **What You'll Be Able to Do**

### **✅ Manage Bets**
- **View all bets** with detailed information
- **Filter by status** (seeded, live, matched, won, lost)
- **Search by user** or market
- **View algorithm metrics** for each bet

### **✅ Approve Bets**
- **Match seeded bets** to make them live
- **Cancel pending bets** if needed
- **Refund bets** when appropriate
- **Resolve bets** as winners or losers

### **✅ Schedule Bets**
- **Create pending markets** for future betting
- **Allow seeded betting** before market goes live
- **Activate markets** to start live trading
- **Manage bet lifecycle** from seed to resolution

## 🎯 **Bet Management Features**

### **📈 Bet Actions Available**
- **Match**: Convert seeded bets to live
- **Cancel**: Cancel pending or live bets
- **Refund**: Refund bets to users
- **Resolve Win**: Mark bets as winners
- **Resolve Loss**: Mark bets as losers

### **🔍 Filtering Options**
- **All Bets**: View all bets regardless of status
- **Seeded Bets**: Pre-funded bets waiting for activation
- **Live Bets**: Active bets in live markets
- **Matched Bets**: Bets that have been matched
- **Won Bets**: Successfully resolved winning bets
- **Lost Bets**: Successfully resolved losing bets
- **Cancelled Bets**: Cancelled bets

### **📊 Algorithm Metrics**
- **Price Impact**: How much the bet affects market prices
- **Liquidity Utilization**: How much liquidity the bet uses
- **Market Efficiency**: Overall market efficiency score
- **Risk Score**: Risk assessment for the bet

## 🛠️ **Troubleshooting**

### **If You Still Can't Manage Bets**

#### **1. Check Database Structure**
```sql
SELECT column_name, data_type 
FROM information_schema.columns 
WHERE table_name = 'bets' 
ORDER BY ordinal_position;
```

#### **2. Check Foreign Keys**
```sql
SELECT constraint_name, table_name, column_name
FROM information_schema.key_column_usage 
WHERE table_name = 'bets';
```

#### **3. Test Bet Queries**
```sql
SELECT COUNT(*) FROM bets;
SELECT status, COUNT(*) FROM bets GROUP BY status;
```

#### **4. Check Admin Access**
- Ensure you're logged in as an admin user
- Check that your profile has `is_admin = true`
- Verify you can access `/admin/bets` page

### **If Bet Actions Don't Work**

#### **1. Check Bet Status**
Make sure bets have the correct status for the action:
- **Match**: Only works on 'seeded' bets
- **Cancel**: Works on 'seeded' or 'live' bets
- **Resolve**: Only works on 'matched' bets

#### **2. Check Market Status**
Ensure markets are in the correct status:
- **Seeded betting**: Only on 'pending' markets
- **Live betting**: Only on 'active' markets
- **Resolution**: Only on 'active' markets

#### **3. Check User Permissions**
Verify you have admin permissions:
```sql
SELECT is_admin FROM profiles WHERE id = 'your-user-id';
```

## 🎉 **After the Fix**

### **✅ Full Bet Management**
- **View all bets** with complete information
- **Filter and search** bets effectively
- **Perform all bet actions** (match, cancel, refund, resolve)
- **Monitor bet performance** with algorithm metrics

### **✅ Bet Scheduling Works**
- **Create scheduled markets** for future betting
- **Allow pre-funding** with seeded bets
- **Activate markets** when ready
- **Manage bet lifecycle** from start to finish

### **✅ Admin Interface Functions**
- **Admin dashboard** shows bet statistics
- **Bet management page** loads without errors
- **All bet actions** work properly
- **Real-time updates** when actions are performed

The fix addresses all bet management issues and ensures you can fully manage, approve, and schedule bets in your application!
