# Fix Zimbabwe Markets Creation

The RLS (Row Level Security) policies are blocking market creation. Here are several solutions:

## Solution 1: Use Service Role Key (Recommended)

### Get Your Service Role Key

1. Go to your Supabase dashboard
2. Navigate to Settings → API
3. Copy the `service_role` key (not the `anon` key)

### Update the Script

Replace the service role key in `create-zimbabwe-simple.js`:

```javascript
const serviceRoleKey = 'your_actual_service_role_key_here'
```

### Run the Script

```bash
node create-zimbabwe-simple.js
```

## Solution 2: Use SQL Directly

### Run the SQL Script

```bash
# Connect to your Supabase database and run:
psql -h your-db-host -U postgres -d postgres -f create-zimbabwe-markets-sql.sql
```

Or copy the SQL from `create-zimbabwe-markets-sql.sql` and run it in your Supabase SQL editor.

## Solution 3: Temporarily Disable RLS

### Disable RLS for markets table

```sql
ALTER TABLE markets DISABLE ROW LEVEL SECURITY;
```

### Run the original script

```bash
node seed-zimbabwe-markets.js
```

### Re-enable RLS

```sql
ALTER TABLE markets ENABLE ROW LEVEL SECURITY;
```

## Solution 4: Update RLS Policies

### Add admin bypass policy

```sql
-- Allow admins to create markets
CREATE POLICY "Admins can create markets" ON markets
FOR INSERT TO authenticated
WITH CHECK (
  EXISTS (
    SELECT 1 FROM profiles 
    WHERE profiles.id = auth.uid() 
    AND profiles.is_admin = true
  )
);

-- Allow admins to insert liquidity
CREATE POLICY "Admins can add liquidity" ON liquidity_providers
FOR INSERT TO authenticated
WITH CHECK (
  EXISTS (
    SELECT 1 FROM profiles 
    WHERE profiles.id = auth.uid() 
    AND profiles.is_admin = true
  )
);
```

## Solution 5: Use Supabase CLI

### Install Supabase CLI

```bash
npm install -g supabase
```

### Login and link project

```bash
supabase login
supabase link --project-ref your-project-ref
```

### Run SQL

```bash
supabase db reset --linked
```

## Recommended Approach

**Use Solution 1 (Service Role Key)** as it's the cleanest approach:

1. Get your service role key from Supabase dashboard
2. Update `create-zimbabwe-simple.js` with the real key
3. Run: `node create-zimbabwe-simple.js`

This bypasses RLS policies completely and is the most reliable method.

## Expected Output

```
🚀 Creating Zimbabwe markets with service role...
🔍 Setting up admin user...
✅ Admin user ready: 12345678-1234-1234-1234-123456789012
📝 Creating market 1/25: Will Zimbabwe's inflation rate drop below 50%...
✅ Market 1 created: 87654321-4321-4321-4321-210987654321
💰 Added liquidity to market 1
...
🎉 Market creation completed!
✅ Successfully created: 25 markets
❌ Failed to create: 0 markets

🌍 Your Zimbabwe markets are now live!
```

## Troubleshooting

### "Invalid API key"
- Make sure you're using the `service_role` key, not the `anon` key
- Check that the key is copied correctly (no extra spaces)

### "Permission denied"
- The service role key should have full database access
- If not, use the SQL approach instead

### "User already exists"
- This is normal - the script will use the existing admin user

## After Success

1. **Check Homepage**: Visit your app to see the new markets
2. **Admin Panel**: Use the admin dashboard to manage markets
3. **Trading**: Users can now bet on Zimbabwe-related events
4. **Categories**: Filter by economics, politics, healthcare, etc.

## Market Categories Created

- **Economics** (8 markets): Inflation, GDP, currency, unemployment, FDI, debt, exports, manufacturing
- **Politics** (3 markets): Elections, opposition, corruption
- **Sectors** (4 markets): Mining, agriculture, tourism, manufacturing  
- **Social** (4 markets): Education, healthcare, demographics, literacy
- **Technology** (2 markets): Internet, mobile money
- **Finance** (1 market): Stock market
- **Environment** (1 market): Climate funding
- **Energy** (1 market): Renewable energy
- **Demographics** (1 market): Urbanization

Total: **25 Zimbabwe-focused prediction markets**
