# Login Tracking Setup Guide

## Issue
The login tracking is failing with the error: "Failed to track login session - check if login_sessions table exists and environment variables are set"

## Solution

### 1. Create the login_sessions table

Run the SQL script in your Supabase database:

```sql
-- Copy and paste the contents of create-login-sessions-table.sql into your Supabase SQL editor
```

Or use the Supabase CLI:
```bash
supabase db reset
# or
psql -h your-db-host -U postgres -d postgres -f create-login-sessions-table.sql
```

### 2. Set up environment variables

Create a `.env.local` file in your project root with your Supabase credentials:

```env
NEXT_PUBLIC_SUPABASE_URL=your_supabase_project_url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_supabase_anon_key
```

### 3. Get your Supabase credentials

1. Go to your Supabase project dashboard
2. Navigate to Settings > API
3. Copy the Project URL and anon/public key
4. Paste them into your `.env.local` file

### 4. Restart your development server

```bash
npm run dev
# or
yarn dev
```

### 5. Test the setup

1. Open your browser's developer console
2. Try logging in/out
3. Check the console for login tracking messages
4. Visit `/settings/security` to see login activity

## What this enables

- ✅ **Login Activity Tracking**: See when and where users log in
- ✅ **IP Address Capture**: Track user IP addresses and locations
- ✅ **Device Detection**: Know what devices users are using
- ✅ **Session Management**: Track active sessions and sign out all devices
- ✅ **Security Monitoring**: Monitor for suspicious login activity

## Troubleshooting

If you still see errors:

1. **Check environment variables**: Make sure `.env.local` exists and has correct values
2. **Verify table exists**: Run `SELECT * FROM login_sessions LIMIT 1;` in Supabase SQL editor
3. **Check RLS policies**: Ensure Row Level Security policies are properly set up
4. **Check console logs**: Look for detailed error messages in browser console

## Files involved

- `create-login-sessions-table.sql` - Database schema
- `src/lib/services/loginTracking.ts` - Login tracking service
- `src/components/auth/LoginTrackingWrapper.tsx` - Wrapper component
- `src/app/api/track-login/route.ts` - API endpoint for IP capture
- `src/app/settings/security/page.tsx` - Security settings page

