#!/bin/bash

# Script to apply the outcome constraint fix
# This fixes the "Invalid outcome name" error for multi-outcome betting

echo "🔧 Applying outcome constraint fix..."
echo "======================================"

# Check if we can connect to the database
echo "📡 Checking database connection..."

# Try to apply the fix
echo "🚀 Applying constraint fix..."
psql -h localhost -U postgres -d postgres -f fix-outcome-constraint-simple.sql

if [ $? -eq 0 ]; then
    echo "✅ Outcome constraint fix applied successfully!"
    echo ""
    echo "🎉 Multi-outcome betting should now work properly!"
    echo "   - Outcome names like 'Emmerson Mnangagwa' are now allowed"
    echo "   - Binary outcomes 'yes'/'no' still work"
    echo "   - Any outcome name up to 100 characters is supported"
    echo ""
    echo "🔄 Please refresh your browser and try placing a bet again."
else
    echo "❌ Failed to apply constraint fix."
    echo "   This might be because:"
    echo "   - Database is not running"
    echo "   - Connection credentials are incorrect"
    echo "   - Database doesn't exist"
    echo ""
    echo "💡 To fix manually:"
    echo "   1. Connect to your database"
    echo "   2. Run the SQL commands in fix-outcome-constraint-final.sql"
    echo "   3. Or contact your database administrator"
fi
