// Check what columns actually exist in the market_outcomes table
const { createClient } = require('@supabase/supabase-js')

const supabaseUrl = process.env.NEXT_PUBLIC_SUPABASE_URL || 'your-supabase-url'
const supabaseKey = process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY || 'your-supabase-key'

const supabase = createClient(supabaseUrl, supabaseKey)

async function checkTableSchema() {
  console.log('🔍 Checking market_outcomes table schema...')
  
  try {
    // Try to select all columns to see what exists
    const { data, error } = await supabase
      .from('market_outcomes')
      .select('*')
      .limit(1)
    
    if (error) {
      console.error('❌ Error fetching market_outcomes:', error)
      console.error('Error details:', {
        message: error.message,
        details: error.details,
        hint: error.hint,
        code: error.code
      })
      return
    }
    
    console.log('✅ market_outcomes table accessible')
    console.log('Available columns:', data?.[0] ? Object.keys(data[0]) : 'No data')
    
    if (data?.[0]) {
      console.log('\nSample record:')
      console.log(JSON.stringify(data[0], null, 2))
    }
    
  } catch (error) {
    console.error('❌ Unexpected error:', error)
  }
}

checkTableSchema()
