-- Manual SQL script to create admin_settings table
-- Run this in your Supabase SQL editor or database client

-- Create the admin_settings table
CREATE TABLE IF NOT EXISTS admin_settings (
  id TEXT PRIMARY KEY,
  settings JSONB NOT NULL DEFAULT '{}',
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
  updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Add RLS policies
ALTER TABLE admin_settings ENABLE ROW LEVEL SECURITY;

-- Only admins can read and write admin settings
CREATE POLICY "Only admins can manage admin settings" ON admin_settings
  FOR ALL USING (
    EXISTS (
      SELECT 1 FROM profiles 
      WHERE profiles.id = auth.uid() 
      AND profiles.is_admin = TRUE
    )
  );

-- Create function to create table if not exists (for compatibility)
CREATE OR REPLACE FUNCTION create_admin_settings_table_if_not_exists()
RETURNS void AS $$
BEGIN
  -- This function is just a placeholder since the table is created above
  -- It's here for compatibility with the code that calls it
  RETURN;
END;
$$ LANGUAGE plpgsql;

-- Insert default settings if they don't exist
INSERT INTO admin_settings (id, settings) VALUES 
('algorithm_settings', '{}'),
('platform_settings', '{}')
ON CONFLICT (id) DO NOTHING;
