# Multi-Outcome Market Example: "Who will be president?"

## Overview
This example demonstrates how to create a multi-outcome market for "Who will be president?" with up to 10 competing candidates.

## Market Setup

### 1. Market Details
- **Title**: "Who will be the next President of Zimbabwe in 2024?"
- **Description**: "Predict which candidate will win the 2024 Zimbabwe presidential election"
- **Category**: Politics
- **Market Type**: Multiple Outcomes
- **End Date**: 2024-12-31T23:59:59Z

### 2. Outcomes (Up to 10 candidates)
1. **Emmerson Mnangagwa** 🏛️ (Blue)
   - Description: "Current President, ZANU-PF candidate"
   - Color: #3B82F6
   - Icon: 🏛️

2. **Nelson Chamisa** 👤 (Green)
   - Description: "Opposition leader, CCC candidate"
   - Color: #10B981
   - Icon: 👤

3. **Douglas Mwonzora** 🎯 (Purple)
   - Description: "MDC-T leader"
   - Color: #8B5CF6
   - Icon: 🎯

4. **Thokozani Khupe** ⭐ (Pink)
   - Description: "Former MDC-T vice president"
   - Color: #EC4899
   - Icon: ⭐

5. **Other Candidate** 🔥 (Orange)
   - Description: "Any other candidate not listed"
   - Color: #F97316
   - Icon: 🔥

## How It Works

### For Market Creators:
1. **Select "Multiple Outcomes"** when creating a market
2. **Add up to 10 outcomes** using the MultiOutcomeCreator component
3. **Customize each outcome** with:
   - Name (e.g., "Emmerson Mnangagwa")
   - Description (optional)
   - Color (for visual distinction)
   - Icon (emoji representation)
4. **Set seeding amount** to provide initial liquidity
5. **Configure betting limits** (min/max bet amounts)

### For Bettors:
1. **View all outcomes** with their current prices
2. **Select preferred outcome** (e.g., "Nelson Chamisa")
3. **Enter bet amount** (e.g., $100)
4. **See estimated shares** you'll receive
5. **Place bet** on your chosen candidate

### Price Dynamics:
- **Initial prices** are equal (e.g., 5 outcomes = 20% each)
- **Prices change** based on betting activity
- **More bets on a candidate** = higher price
- **Less popular candidates** = lower price (better odds)

## Example Betting Scenarios

### Scenario 1: Early Betting
- All candidates start at 20% (equal odds)
- User bets $100 on "Nelson Chamisa"
- Receives ~500 shares at $0.20 per share
- If Nelson wins, user gets $500 payout

### Scenario 2: Popular Candidate
- Nelson's price rises to 60% due to heavy betting
- User bets $100 on "Nelson Chamisa"
- Receives ~167 shares at $0.60 per share
- If Nelson wins, user gets $167 payout

### Scenario 3: Underdog Betting
- Emmerson's price drops to 10% (unpopular)
- User bets $100 on "Emmerson Mnangagwa"
- Receives ~1000 shares at $0.10 per share
- If Emmerson wins, user gets $1000 payout (10x return!)

## Technical Implementation

### Database Schema
```sql
-- Market outcomes table with enhanced fields
CREATE TABLE market_outcomes (
  id UUID PRIMARY KEY,
  market_id UUID REFERENCES markets(id),
  name TEXT NOT NULL,
  description TEXT,
  price DECIMAL(4,3) DEFAULT 0.0,
  pool DECIMAL(15,2) DEFAULT 0.00,
  volume DECIMAL(15,2) DEFAULT 0.00,
  color TEXT DEFAULT '#3B82F6',
  icon TEXT DEFAULT '👤',
  sort_order INTEGER DEFAULT 0,
  is_resolved BOOLEAN DEFAULT FALSE,
  created_at TIMESTAMPTZ DEFAULT NOW(),
  updated_at TIMESTAMPTZ DEFAULT NOW()
);
```

### React Components
- **MultiOutcomeCreator**: Drag-and-drop interface for adding outcomes
- **MultiOutcomeBetForm**: Enhanced betting form with visual outcomes
- **MarketDisplay**: Shows all outcomes with prices and colors

## Benefits of Multi-Outcome Markets

1. **More Engaging**: Users can bet on specific candidates, not just yes/no
2. **Better Odds**: Underdog candidates offer higher potential returns
3. **Realistic Scenarios**: Matches real-world multi-candidate elections
4. **Visual Appeal**: Colors and icons make outcomes easy to distinguish
5. **Flexible**: Supports 2-10 outcomes for any type of prediction

## Use Cases Beyond Politics

- **Sports**: "Who will win the World Cup?" (32 teams)
- **Entertainment**: "Who will win Best Actor?" (5 nominees)
- **Business**: "Which company will be acquired next?" (10 companies)
- **Technology**: "Which AI model will be most popular?" (5 models)
- **Science**: "Which discovery will win the Nobel Prize?" (3 discoveries)

This system makes prediction markets much more engaging and realistic for complex scenarios with multiple possible outcomes!
