# Enhanced Homepage Multi-Outcome Display

## Overview
The homepage now supports enhanced display of multi-outcome markets with circular images/icons for each outcome choice.

## Features

### 1. **Circular Outcome Display**
- Each outcome is shown as a circular indicator with:
  - **Custom color** (e.g., blue for candidate 1, green for candidate 2)
  - **Custom icon/emoji** (e.g., 🏛️ for president, 👤 for candidate)
  - **Current price percentage** (e.g., 25.5%)
  - **Outcome name** (truncated if too long)

### 2. **Compact View (Default)**
```
[🏛️] [👤] [🎯] [+2]
Emmerson Nelson Douglas +2 More
25.5%  30.2%  20.1%
```

### 3. **Expanded View (On Click)**
- Shows all outcomes in a detailed list
- Includes descriptions and pool amounts
- Easy to collapse back to compact view

### 4. **Visual Hierarchy**
- **Most popular outcomes** shown first
- **Color-coded** for easy identification
- **Hover effects** for better UX
- **Responsive design** for mobile/desktop

## Example: Presidential Election Market

### Market Card Display:
```
┌─────────────────────────────────────┐
│ Who will be the next President?     │
│                                     │
│ [🏛️] [👤] [🎯] [⭐] [+1]           │
│ Emmerson Nelson Douglas Thokozani +1 │
│ 25.5%  30.2%  20.1%  15.2%         │
│                                     │
│ [Bet Now] [View Details]            │
└─────────────────────────────────────┘
```

### When Expanded:
```
┌─────────────────────────────────────┐
│ Who will be the next President?     │
│                                     │
│ [🏛️] [👤] [🎯] [⭐] [🔥] [Less]    │
│ Emmerson Nelson Douglas Thokozani   │
│ 25.5%  30.2%  20.1%  15.2%         │
│                                     │
│ ─────────────────────────────────── │
│ 🏛️ Emmerson Mnangagwa - Current     │
│    President, ZANU-PF - 25.5%       │
│ 👤 Nelson Chamisa - Opposition      │
│    leader, CCC - 30.2%             │
│ 🎯 Douglas Mwonzora - MDC-T leader  │
│    - 20.1%                         │
│ ⭐ Thokozani Khupe - Former MDC-T   │
│    vice president - 15.2%          │
│ 🔥 Other Candidate - Any other      │
│    candidate - 9.0%                 │
│                                     │
│ [Bet Now] [View Details]            │
└─────────────────────────────────────┘
```

## Technical Implementation

### 1. **MultiOutcomeDisplay Component**
- **Props:**
  - `outcomes`: Array of outcome objects with color, icon, price
  - `maxVisible`: Number of outcomes to show in compact view (default: 3)
  - `compact`: Whether to use compact layout (default: false)
  - `showAll`: Whether to show all outcomes (default: false)

### 2. **Database Integration**
- Fetches outcomes with `color`, `icon`, `sort_order` fields
- Orders by `sort_order` for consistent display
- Includes price and pool information

### 3. **Responsive Design**
- **Mobile**: Stacked circular indicators
- **Desktop**: Horizontal row of indicators
- **Tablet**: Adaptive layout based on screen size

## Benefits

### 1. **Visual Appeal**
- **Color-coded outcomes** make it easy to distinguish options
- **Circular design** is modern and engaging
- **Icons/emojis** add personality and context

### 2. **Better UX**
- **Quick scanning** of all available options
- **Expandable details** for users who want more info
- **Hover effects** provide feedback

### 3. **Information Density**
- **Compact view** shows key info without clutter
- **Expanded view** provides full details when needed
- **Smart truncation** handles long outcome names

## Use Cases

### 1. **Political Markets**
- "Who will be president?" with candidate photos/colors
- "Which party will win?" with party colors/logos

### 2. **Sports Markets**
- "Who will win the World Cup?" with team flags/colors
- "Which player will score first?" with player photos

### 3. **Entertainment Markets**
- "Who will win Best Actor?" with nominee photos
- "Which movie will win Best Picture?" with movie posters

### 4. **Business Markets**
- "Which company will be acquired next?" with company logos
- "Which stock will perform best?" with stock symbols

## Configuration Options

### 1. **Display Modes**
```typescript
// Compact mode (default for homepage)
<MultiOutcomeDisplay 
  outcomes={outcomes} 
  maxVisible={3}
  compact={true}
/>

// Full mode (for market detail pages)
<MultiOutcomeDisplay 
  outcomes={outcomes} 
  showAll={true}
  compact={false}
/>
```

### 2. **Customization**
- **Max visible outcomes**: Control how many show in compact view
- **Color schemes**: Automatic or custom color assignment
- **Icon sets**: Preset or custom icon selection
- **Layout options**: Horizontal, vertical, or grid layouts

The enhanced homepage now provides a much more engaging and informative display for multi-outcome markets, making it easy for users to quickly understand all available options and their current prices!
