/**
 * **Accordion anatomy**
 * - Root: the root container of the accordion
 * - Container: the accordion item contains the button and panel
 * - Button: the button is the trigger for the panel
 * - Panel: the panel is the content of the accordion item
 * - Icon: the expanded/collapsed icon
 */
export declare const accordionAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"root" | "container" | "button" | "panel" | "icon">, "parts">;
/**
 * **Alert anatomy**
 * - Title: the alert's title
 * - Description: the alert's description
 * - Icon: the alert's icon
 */
export declare const alertAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "icon" | "title" | "description">, "parts">;
/**
 * **Avatar anatomy**
 * - Container: the container for the avatar
 * - Label: the avatar initials text
 * - Excess Label: the label or text that represents excess avatar count.
 * Typically used in avatar groups.
 * - Group: the container for the avatar group
 */
export declare const avatarAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "label" | "badge" | "excessLabel" | "group">, "parts">;
/**
 * **Breadcrumb anatomy**
 * - Item: the container for a breadcrumb item
 * - Link: the element that represents the breadcrumb link
 * - Container: the container for the breadcrumb items
 * - Separator: the separator between breadcrumb items
 */
export declare const breadcrumbAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "link" | "item" | "separator">, "parts">;
export declare const buttonAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<string>, "parts">;
export declare const checkboxAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "icon" | "label" | "control">, "parts">;
export declare const circularProgressAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"label" | "track" | "filledTrack">, "parts">;
export declare const drawerAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"overlay" | "dialogContainer" | "dialog" | "header" | "closeButton" | "body" | "footer">, "parts">;
export declare const editableAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"preview" | "input" | "textarea">, "parts">;
export declare const formAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "requiredIndicator" | "helperText">, "parts">;
export declare const formErrorAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"icon" | "text">, "parts">;
export declare const inputAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"addon" | "field" | "element">, "parts">;
export declare const listAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "icon" | "item">, "parts">;
export declare const menuAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"button" | "item" | "list" | "groupTitle" | "command" | "divider">, "parts">;
export declare const modalAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"overlay" | "dialogContainer" | "dialog" | "header" | "closeButton" | "body" | "footer">, "parts">;
export declare const numberInputAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"root" | "field" | "stepperGroup" | "stepper">, "parts">;
export declare const pinInputAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"field">, "parts">;
export declare const popoverAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"header" | "closeButton" | "body" | "footer" | "content" | "popper" | "arrow">, "parts">;
export declare const progressAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"label" | "track" | "filledTrack">, "parts">;
export declare const radioAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "label" | "control">, "parts">;
export declare const selectAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"icon" | "field">, "parts">;
export declare const sliderAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "track" | "filledTrack" | "thumb">, "parts">;
export declare const statAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"number" | "container" | "icon" | "label" | "helpText">, "parts">;
export declare const switchAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "track" | "thumb">, "parts">;
export declare const tableAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"table" | "thead" | "tbody" | "tr" | "th" | "td" | "tfoot" | "caption">, "parts">;
export declare const tabsAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"root" | "tab" | "tablist" | "tabpanel" | "tabpanels" | "indicator">, "parts">;
/**
 * **Tag anatomy**
 * - Container: the container for the tag
 * - Label: the text content of the tag
 * - closeButton: the close button for the tag
 */
export declare const tagAnatomy: Omit<import("@chakra-ui/theme-tools").Anatomy<"container" | "label" | "closeButton">, "parts">;
//# sourceMappingURL=index.d.ts.map