import { ResponsiveValue, SystemProps, HTMLChakraProps } from "@chakra-ui/system";
import { BoxProps } from "./box";
export interface GridProps extends Omit<HTMLChakraProps<"div">, keyof GridOptions>, GridOptions {
}
/**
 * React component used to create grid layouts.
 *
 * It renders a `div` with `display: grid` and
 * comes with helpful style shorthand.
 *
 * @see Docs https://chakra-ui.com/grid
 */
export declare const Grid: import("@chakra-ui/system").ComponentWithAs<"div", GridProps>;
export interface GridOptions {
    /**
     * Shorthand prop for `gridTemplateColumns`
     * @type SystemProps["gridTemplateColumns"]
     */
    templateColumns?: SystemProps["gridTemplateColumns"];
    /**
     * Shorthand prop for `gridGap`
     * @type SystemProps["gridGap"]
     */
    gap?: SystemProps["gridGap"];
    /**
     * Shorthand prop for `gridRowGap`
     * @type SystemProps["gridRowGap"]
     */
    rowGap?: SystemProps["gridRowGap"];
    /**
     * Shorthand prop for `gridColumnGap`
     * @type SystemProps["gridColumnGap"]
     */
    columnGap?: SystemProps["gridColumnGap"];
    /**
     * Shorthand prop for `gridAutoFlow`
     * @type SystemProps["gridAutoFlow"]
     */
    autoFlow?: SystemProps["gridAutoFlow"];
    /**
     * Shorthand prop for `gridAutoRows`
     * @type SystemProps["gridAutoRows"]
     */
    autoRows?: SystemProps["gridAutoRows"];
    /**
     * Shorthand prop for `gridAutoColumns`
     * @type SystemProps["gridAutoColumns"]
     */
    autoColumns?: SystemProps["gridAutoColumns"];
    /**
     * Shorthand prop for `gridTemplateRows`
     * @type SystemProps["gridTemplateRows"]
     */
    templateRows?: SystemProps["gridTemplateRows"];
    /**
     * Shorthand prop for `gridTemplateAreas`
     * @type SystemProps["gridTemplateAreas"]
     */
    templateAreas?: SystemProps["gridTemplateAreas"];
    /**
     * Shorthand prop for `gridArea`
     * @type SystemProps["gridArea"]
     * @deprecated
     * Use `GridItem` with the `area` prop instead. Will be removed in a future
     * version.
     */
    area?: SystemProps["gridArea"];
    /**
     * Shorthand prop for `gridColumn`
     * @type SystemProps["gridColumn"]
     */
    column?: SystemProps["gridColumn"];
    /**
     * Shorthand prop for `gridRow`
     * @type SystemProps["gridRow"]
     */
    row?: SystemProps["gridRow"];
}
export interface GridItemProps extends BoxProps {
    /**
     * Shorthand prop for `gridArea`
     * @type SystemProps["gridArea"]
     */
    area?: SystemProps["gridArea"];
    /**
     * The number of columns the grid item should `span`.
     * @type ResponsiveValue<number | "auto">
     */
    colSpan?: ResponsiveValue<number | "auto">;
    /**
     * The column number the grid item should start.
     * @type ResponsiveValue<number | "auto">
     */
    colStart?: ResponsiveValue<number | "auto">;
    /**
     * @type ResponsiveValue<number | "auto">
     */
    colEnd?: ResponsiveValue<number | "auto">;
    /**
     * @type ResponsiveValue<number | "auto">
     */
    rowStart?: ResponsiveValue<number | "auto">;
    /**
     * @type ResponsiveValue<number | "auto">
     */
    rowEnd?: ResponsiveValue<number | "auto">;
    /**
     * @type ResponsiveValue<number | "auto">
     */
    rowSpan?: ResponsiveValue<number | "auto">;
}
export declare const GridItem: import("@chakra-ui/system").ComponentWithAs<"div", GridItemProps>;
//# sourceMappingURL=grid.d.ts.map