import { ThemingProps, HTMLChakraProps } from "@chakra-ui/system";
export interface KbdProps extends HTMLChakraProps<"kbd">, ThemingProps<"Kbd"> {
}
/**
 * Semantic component to render a keyboard shortcut
 * within an application.
 *
 * @example
 *
 * ```jsx
 * <Kbd>⌘ + T</Kbd>
 * ```
 *
 * @see Docs https://chakra-ui.com/kbd
 */
export declare const Kbd: import("@chakra-ui/system").ComponentWithAs<"kbd", KbdProps>;
//# sourceMappingURL=kbd.d.ts.map