import * as React from "react";
export declare type HideProps = ShowProps;
export declare const Hide: React.FC<HideProps>;
export interface ShowProps {
    /**
     * A custom css media query that determines when the `children` are rendered.
     * Will render `children` if that query resolves to `true`.
     */
    breakpoint?: string;
    /**
     * A value from the `breakpoints` section in the theme. Will render `children`
     * from that breakpoint and below. Default breakpoint values: `sm`, `md`, `lg`, `xl`, `2xl`.
     */
    below?: string;
    /**
     * A value from the `breakpoints` section in the theme. Will render `children`
     * from that breakpoint and above. Default breakpoint values: `sm`, `md`, `lg`, `xl`, `2xl`.
     */
    above?: string;
    children?: React.ReactNode;
}
export declare const Show: React.FC<ShowProps>;
export interface UseQueryProps {
    breakpoint?: string;
    below?: string;
    above?: string;
}
export declare function useQuery(props: UseQueryProps): string;
//# sourceMappingURL=media-query.d.ts.map