import { UseDisclosureProps } from "@chakra-ui/hooks";
import { UsePopperProps } from "@chakra-ui/popper";
import { LazyBehavior } from "@chakra-ui/utils";
import * as React from "react";
export declare const MenuDescendantsProvider: React.Provider<import("@chakra-ui/descendant").DescendantsManager<HTMLElement, {}>>, useMenuDescendantsContext: () => import("@chakra-ui/descendant").DescendantsManager<HTMLElement, {}>, useMenuDescendants: () => import("@chakra-ui/descendant").DescendantsManager<HTMLElement, {}>, useMenuDescendant: (options?: {
    disabled?: boolean | undefined;
    id?: string | undefined;
} | undefined) => {
    descendants: import("@chakra-ui/descendant/src/use-descendant").UseDescendantsReturn;
    index: number;
    enabledIndex: number;
    register: (node: HTMLElement | null) => void;
};
export declare const MenuProvider: React.Provider<Omit<UseMenuReturn, "descendants">>, useMenuContext: () => Omit<UseMenuReturn, "descendants">;
export interface UseMenuProps extends Omit<UsePopperProps, "enabled">, UseDisclosureProps {
    /**
     * If `true`, the menu will close when a menu item is
     * clicked
     *
     * @default true
     */
    closeOnSelect?: boolean;
    /**
     * If `true`, the menu will close when you click outside
     * the menu list
     *
     * @default true
     */
    closeOnBlur?: boolean;
    /**
     * If `true`, the first enabled menu item will receive focus and be selected
     * when the menu opens.
     *
     * @default true
     */
    autoSelect?: boolean;
    /**
     * Performance 🚀:
     * If `true`, the MenuItem rendering will be deferred
     * until the menu is open.
     */
    isLazy?: boolean;
    /**
     * Performance 🚀:
     * The lazy behavior of menu's content when not visible.
     * Only works when `isLazy={true}`
     *
     * - "unmount": The menu's content is always unmounted when not open.
     * - "keepMounted": The menu's content initially unmounted,
     * but stays mounted when menu is open.
     *
     * @default "unmount"
     */
    lazyBehavior?: LazyBehavior;
    /**
     * If `rtl`, poper placement positions will be flipped i.e. 'top-right' will
     * become 'top-left' and vice-verse
     */
    direction?: "ltr" | "rtl";
    computePositionOnMount?: boolean;
}
/**
 * React Hook to manage a menu
 *
 * It provides the logic and will be used with react context
 * to propagate its return value to all children
 */
export declare function useMenu(props?: UseMenuProps): {
    openAndFocusMenu: () => void;
    openAndFocusFirstItem: () => void;
    openAndFocusLastItem: () => void;
    onTransitionEnd: () => void;
    unstable__animationState: {
        present: boolean;
        onComplete(): void;
    };
    descendants: import("@chakra-ui/descendant").DescendantsManager<HTMLElement, {}>;
    popper: {
        update(): void;
        forceUpdate(): void;
        transformOrigin: string;
        referenceRef: <T extends Element | import("@popperjs/core").VirtualElement>(node: T | null) => void;
        popperRef: <T_1 extends HTMLElement>(node: T_1 | null) => void;
        getPopperProps: import("@chakra-ui/react-utils").PropGetterV2<"div", {}>;
        getArrowProps: import("@chakra-ui/react-utils").PropGetterV2<"div", import("@chakra-ui/popper").ArrowCSSVarProps>;
        getArrowInnerProps: import("@chakra-ui/react-utils").PropGetterV2<"div", {}>;
        getReferenceProps: import("@chakra-ui/react-utils").PropGetterV2<"button", {}>;
    };
    buttonId: string;
    menuId: string;
    forceUpdate: () => void;
    orientation: string;
    isOpen: boolean;
    onToggle: () => void;
    onOpen: () => void;
    onClose: () => void;
    menuRef: React.RefObject<HTMLDivElement>;
    buttonRef: React.RefObject<HTMLButtonElement>;
    focusedIndex: number;
    closeOnSelect: boolean;
    closeOnBlur: boolean;
    autoSelect: boolean;
    setFocusedIndex: React.Dispatch<React.SetStateAction<number>>;
    isLazy: boolean | undefined;
    lazyBehavior: LazyBehavior;
};
export interface UseMenuReturn extends ReturnType<typeof useMenu> {
}
export interface UseMenuButtonProps extends Omit<React.HTMLAttributes<Element>, "color"> {
}
/**
 * React Hook to manage a menu button.
 *
 * The assumption here is that the `useMenu` hook is used
 * in a component higher up the tree, and its return value
 * is passed as `context` to this hook.
 */
export declare function useMenuButton(props?: UseMenuButtonProps, externalRef?: React.Ref<any>): {
    ref: (node: any) => void;
    id: string;
    "data-active": import("@chakra-ui/utils").Booleanish;
    "aria-expanded": boolean;
    "aria-haspopup": boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    "aria-controls": string;
    onClick: (event: React.MouseEvent<Element, MouseEvent>) => void;
    onKeyDown: (event: React.KeyboardEvent<Element>) => void;
    children?: React.ReactNode;
    slot?: string | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    dir?: string | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    tabIndex?: number | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    role?: React.AriaRole | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-disabled'?: (boolean | "false" | "true") | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUp?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<Element> | undefined;
    onMouseDown?: React.MouseEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<Element> | undefined;
    onMouseLeave?: React.MouseEventHandler<Element> | undefined;
    onMouseMove?: React.MouseEventHandler<Element> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOver?: React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseUp?: React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<Element> | undefined;
};
export interface UseMenuListProps extends Omit<React.HTMLAttributes<Element>, "color"> {
}
/**
 * React Hook to manage a menu list.
 *
 * The assumption here is that the `useMenu` hook is used
 * in a component higher up the tree, and its return value
 * is passed as `context` to this hook.
 */
export declare function useMenuList(props?: UseMenuListProps, ref?: React.Ref<any>): {
    ref: (node: any) => void;
    children: React.ReactNode;
    tabIndex: number;
    role: string;
    id: string;
    style: {
        transformOrigin: string;
        accentColor?: import("csstype").Property.AccentColor | undefined;
        alignContent?: import("csstype").Property.AlignContent | undefined;
        alignItems?: import("csstype").Property.AlignItems | undefined;
        alignSelf?: import("csstype").Property.AlignSelf | undefined;
        alignTracks?: import("csstype").Property.AlignTracks | undefined;
        animationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
        animationDirection?: import("csstype").Property.AnimationDirection | undefined;
        animationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
        animationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
        animationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
        animationName?: import("csstype").Property.AnimationName | undefined;
        animationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
        animationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
        appearance?: import("csstype").Property.Appearance | undefined;
        aspectRatio?: import("csstype").Property.AspectRatio | undefined;
        backdropFilter?: import("csstype").Property.BackdropFilter | undefined;
        backfaceVisibility?: import("csstype").Property.BackfaceVisibility | undefined;
        backgroundAttachment?: import("csstype").Property.BackgroundAttachment | undefined;
        backgroundBlendMode?: import("csstype").Property.BackgroundBlendMode | undefined;
        backgroundClip?: import("csstype").Property.BackgroundClip | undefined;
        backgroundColor?: import("csstype").Property.BackgroundColor | undefined;
        backgroundImage?: import("csstype").Property.BackgroundImage | undefined;
        backgroundOrigin?: import("csstype").Property.BackgroundOrigin | undefined;
        backgroundPositionX?: import("csstype").Property.BackgroundPositionX<string | number> | undefined;
        backgroundPositionY?: import("csstype").Property.BackgroundPositionY<string | number> | undefined;
        backgroundRepeat?: import("csstype").Property.BackgroundRepeat | undefined;
        backgroundSize?: import("csstype").Property.BackgroundSize<string | number> | undefined;
        blockOverflow?: import("csstype").Property.BlockOverflow | undefined;
        blockSize?: import("csstype").Property.BlockSize<string | number> | undefined;
        borderBlockColor?: import("csstype").Property.BorderBlockColor | undefined;
        borderBlockEndColor?: import("csstype").Property.BorderBlockEndColor | undefined;
        borderBlockEndStyle?: import("csstype").Property.BorderBlockEndStyle | undefined;
        borderBlockEndWidth?: import("csstype").Property.BorderBlockEndWidth<string | number> | undefined;
        borderBlockStartColor?: import("csstype").Property.BorderBlockStartColor | undefined;
        borderBlockStartStyle?: import("csstype").Property.BorderBlockStartStyle | undefined;
        borderBlockStartWidth?: import("csstype").Property.BorderBlockStartWidth<string | number> | undefined;
        borderBlockStyle?: import("csstype").Property.BorderBlockStyle | undefined;
        borderBlockWidth?: import("csstype").Property.BorderBlockWidth<string | number> | undefined;
        borderBottomColor?: import("csstype").Property.BorderBottomColor | undefined;
        borderBottomLeftRadius?: import("csstype").Property.BorderBottomLeftRadius<string | number> | undefined;
        borderBottomRightRadius?: import("csstype").Property.BorderBottomRightRadius<string | number> | undefined;
        borderBottomStyle?: import("csstype").Property.BorderBottomStyle | undefined;
        borderBottomWidth?: import("csstype").Property.BorderBottomWidth<string | number> | undefined;
        borderCollapse?: import("csstype").Property.BorderCollapse | undefined;
        borderEndEndRadius?: import("csstype").Property.BorderEndEndRadius<string | number> | undefined;
        borderEndStartRadius?: import("csstype").Property.BorderEndStartRadius<string | number> | undefined;
        borderImageOutset?: import("csstype").Property.BorderImageOutset<string | number> | undefined;
        borderImageRepeat?: import("csstype").Property.BorderImageRepeat | undefined;
        borderImageSlice?: import("csstype").Property.BorderImageSlice | undefined;
        borderImageSource?: import("csstype").Property.BorderImageSource | undefined;
        borderImageWidth?: import("csstype").Property.BorderImageWidth<string | number> | undefined;
        borderInlineColor?: import("csstype").Property.BorderInlineColor | undefined;
        borderInlineEndColor?: import("csstype").Property.BorderInlineEndColor | undefined;
        borderInlineEndStyle?: import("csstype").Property.BorderInlineEndStyle | undefined;
        borderInlineEndWidth?: import("csstype").Property.BorderInlineEndWidth<string | number> | undefined;
        borderInlineStartColor?: import("csstype").Property.BorderInlineStartColor | undefined;
        borderInlineStartStyle?: import("csstype").Property.BorderInlineStartStyle | undefined;
        borderInlineStartWidth?: import("csstype").Property.BorderInlineStartWidth<string | number> | undefined;
        borderInlineStyle?: import("csstype").Property.BorderInlineStyle | undefined;
        borderInlineWidth?: import("csstype").Property.BorderInlineWidth<string | number> | undefined;
        borderLeftColor?: import("csstype").Property.BorderLeftColor | undefined;
        borderLeftStyle?: import("csstype").Property.BorderLeftStyle | undefined;
        borderLeftWidth?: import("csstype").Property.BorderLeftWidth<string | number> | undefined;
        borderRightColor?: import("csstype").Property.BorderRightColor | undefined;
        borderRightStyle?: import("csstype").Property.BorderRightStyle | undefined;
        borderRightWidth?: import("csstype").Property.BorderRightWidth<string | number> | undefined;
        borderSpacing?: import("csstype").Property.BorderSpacing<string | number> | undefined;
        borderStartEndRadius?: import("csstype").Property.BorderStartEndRadius<string | number> | undefined;
        borderStartStartRadius?: import("csstype").Property.BorderStartStartRadius<string | number> | undefined;
        borderTopColor?: import("csstype").Property.BorderTopColor | undefined;
        borderTopLeftRadius?: import("csstype").Property.BorderTopLeftRadius<string | number> | undefined;
        borderTopRightRadius?: import("csstype").Property.BorderTopRightRadius<string | number> | undefined;
        borderTopStyle?: import("csstype").Property.BorderTopStyle | undefined;
        borderTopWidth?: import("csstype").Property.BorderTopWidth<string | number> | undefined;
        bottom?: import("csstype").Property.Bottom<string | number> | undefined;
        boxDecorationBreak?: import("csstype").Property.BoxDecorationBreak | undefined;
        boxShadow?: import("csstype").Property.BoxShadow | undefined;
        boxSizing?: import("csstype").Property.BoxSizing | undefined;
        breakAfter?: import("csstype").Property.BreakAfter | undefined;
        breakBefore?: import("csstype").Property.BreakBefore | undefined;
        breakInside?: import("csstype").Property.BreakInside | undefined;
        captionSide?: import("csstype").Property.CaptionSide | undefined;
        caretColor?: import("csstype").Property.CaretColor | undefined;
        clear?: import("csstype").Property.Clear | undefined;
        clipPath?: import("csstype").Property.ClipPath | undefined;
        color?: import("csstype").Property.Color | undefined;
        colorAdjust?: import("csstype").Property.ColorAdjust | undefined;
        colorScheme?: import("csstype").Property.ColorScheme | undefined;
        columnCount?: import("csstype").Property.ColumnCount | undefined;
        columnFill?: import("csstype").Property.ColumnFill | undefined;
        columnGap?: import("csstype").Property.ColumnGap<string | number> | undefined;
        columnRuleColor?: import("csstype").Property.ColumnRuleColor | undefined;
        columnRuleStyle?: import("csstype").Property.ColumnRuleStyle | undefined;
        columnRuleWidth?: import("csstype").Property.ColumnRuleWidth<string | number> | undefined;
        columnSpan?: import("csstype").Property.ColumnSpan | undefined;
        columnWidth?: import("csstype").Property.ColumnWidth<string | number> | undefined;
        contain?: import("csstype").Property.Contain | undefined;
        content?: import("csstype").Property.Content | undefined;
        contentVisibility?: import("csstype").Property.ContentVisibility | undefined;
        counterIncrement?: import("csstype").Property.CounterIncrement | undefined;
        counterReset?: import("csstype").Property.CounterReset | undefined;
        counterSet?: import("csstype").Property.CounterSet | undefined;
        cursor?: import("csstype").Property.Cursor | undefined;
        direction?: import("csstype").Property.Direction | undefined;
        display?: import("csstype").Property.Display | undefined;
        emptyCells?: import("csstype").Property.EmptyCells | undefined;
        filter?: import("csstype").Property.Filter | undefined;
        flexBasis?: import("csstype").Property.FlexBasis<string | number> | undefined;
        flexDirection?: import("csstype").Property.FlexDirection | undefined;
        flexGrow?: import("csstype").Property.FlexGrow | undefined;
        flexShrink?: import("csstype").Property.FlexShrink | undefined;
        flexWrap?: import("csstype").Property.FlexWrap | undefined;
        float?: import("csstype").Property.Float | undefined;
        fontFamily?: import("csstype").Property.FontFamily | undefined;
        fontFeatureSettings?: import("csstype").Property.FontFeatureSettings | undefined;
        fontKerning?: import("csstype").Property.FontKerning | undefined;
        fontLanguageOverride?: import("csstype").Property.FontLanguageOverride | undefined;
        fontOpticalSizing?: import("csstype").Property.FontOpticalSizing | undefined;
        fontSize?: import("csstype").Property.FontSize<string | number> | undefined;
        fontSizeAdjust?: import("csstype").Property.FontSizeAdjust | undefined;
        fontSmooth?: import("csstype").Property.FontSmooth<string | number> | undefined;
        fontStretch?: import("csstype").Property.FontStretch | undefined;
        fontStyle?: import("csstype").Property.FontStyle | undefined;
        fontSynthesis?: import("csstype").Property.FontSynthesis | undefined;
        fontVariant?: import("csstype").Property.FontVariant | undefined;
        fontVariantCaps?: import("csstype").Property.FontVariantCaps | undefined;
        fontVariantEastAsian?: import("csstype").Property.FontVariantEastAsian | undefined;
        fontVariantLigatures?: import("csstype").Property.FontVariantLigatures | undefined;
        fontVariantNumeric?: import("csstype").Property.FontVariantNumeric | undefined;
        fontVariantPosition?: import("csstype").Property.FontVariantPosition | undefined;
        fontVariationSettings?: import("csstype").Property.FontVariationSettings | undefined;
        fontWeight?: import("csstype").Property.FontWeight | undefined;
        forcedColorAdjust?: import("csstype").Property.ForcedColorAdjust | undefined;
        gridAutoColumns?: import("csstype").Property.GridAutoColumns<string | number> | undefined;
        gridAutoFlow?: import("csstype").Property.GridAutoFlow | undefined;
        gridAutoRows?: import("csstype").Property.GridAutoRows<string | number> | undefined;
        gridColumnEnd?: import("csstype").Property.GridColumnEnd | undefined;
        gridColumnStart?: import("csstype").Property.GridColumnStart | undefined;
        gridRowEnd?: import("csstype").Property.GridRowEnd | undefined;
        gridRowStart?: import("csstype").Property.GridRowStart | undefined;
        gridTemplateAreas?: import("csstype").Property.GridTemplateAreas | undefined;
        gridTemplateColumns?: import("csstype").Property.GridTemplateColumns<string | number> | undefined;
        gridTemplateRows?: import("csstype").Property.GridTemplateRows<string | number> | undefined;
        hangingPunctuation?: import("csstype").Property.HangingPunctuation | undefined;
        height?: import("csstype").Property.Height<string | number> | undefined;
        hyphens?: import("csstype").Property.Hyphens | undefined;
        imageOrientation?: import("csstype").Property.ImageOrientation | undefined;
        imageRendering?: import("csstype").Property.ImageRendering | undefined;
        imageResolution?: import("csstype").Property.ImageResolution | undefined;
        initialLetter?: import("csstype").Property.InitialLetter | undefined;
        inlineSize?: import("csstype").Property.InlineSize<string | number> | undefined;
        inset?: import("csstype").Property.Inset<string | number> | undefined;
        insetBlock?: import("csstype").Property.InsetBlock<string | number> | undefined;
        insetBlockEnd?: import("csstype").Property.InsetBlockEnd<string | number> | undefined;
        insetBlockStart?: import("csstype").Property.InsetBlockStart<string | number> | undefined;
        insetInline?: import("csstype").Property.InsetInline<string | number> | undefined;
        insetInlineEnd?: import("csstype").Property.InsetInlineEnd<string | number> | undefined;
        insetInlineStart?: import("csstype").Property.InsetInlineStart<string | number> | undefined;
        isolation?: import("csstype").Property.Isolation | undefined;
        justifyContent?: import("csstype").Property.JustifyContent | undefined;
        justifyItems?: import("csstype").Property.JustifyItems | undefined;
        justifySelf?: import("csstype").Property.JustifySelf | undefined;
        justifyTracks?: import("csstype").Property.JustifyTracks | undefined;
        left?: import("csstype").Property.Left<string | number> | undefined;
        letterSpacing?: import("csstype").Property.LetterSpacing<string | number> | undefined;
        lineBreak?: import("csstype").Property.LineBreak | undefined;
        lineHeight?: import("csstype").Property.LineHeight<string | number> | undefined;
        lineHeightStep?: import("csstype").Property.LineHeightStep<string | number> | undefined;
        listStyleImage?: import("csstype").Property.ListStyleImage | undefined;
        listStylePosition?: import("csstype").Property.ListStylePosition | undefined;
        listStyleType?: import("csstype").Property.ListStyleType | undefined;
        marginBlock?: import("csstype").Property.MarginBlock<string | number> | undefined;
        marginBlockEnd?: import("csstype").Property.MarginBlockEnd<string | number> | undefined;
        marginBlockStart?: import("csstype").Property.MarginBlockStart<string | number> | undefined;
        marginBottom?: import("csstype").Property.MarginBottom<string | number> | undefined;
        marginInline?: import("csstype").Property.MarginInline<string | number> | undefined;
        marginInlineEnd?: import("csstype").Property.MarginInlineEnd<string | number> | undefined;
        marginInlineStart?: import("csstype").Property.MarginInlineStart<string | number> | undefined;
        marginLeft?: import("csstype").Property.MarginLeft<string | number> | undefined;
        marginRight?: import("csstype").Property.MarginRight<string | number> | undefined;
        marginTop?: import("csstype").Property.MarginTop<string | number> | undefined;
        maskBorderMode?: import("csstype").Property.MaskBorderMode | undefined;
        maskBorderOutset?: import("csstype").Property.MaskBorderOutset<string | number> | undefined;
        maskBorderRepeat?: import("csstype").Property.MaskBorderRepeat | undefined;
        maskBorderSlice?: import("csstype").Property.MaskBorderSlice | undefined;
        maskBorderSource?: import("csstype").Property.MaskBorderSource | undefined;
        maskBorderWidth?: import("csstype").Property.MaskBorderWidth<string | number> | undefined;
        maskClip?: import("csstype").Property.MaskClip | undefined;
        maskComposite?: import("csstype").Property.MaskComposite | undefined;
        maskImage?: import("csstype").Property.MaskImage | undefined;
        maskMode?: import("csstype").Property.MaskMode | undefined;
        maskOrigin?: import("csstype").Property.MaskOrigin | undefined;
        maskPosition?: import("csstype").Property.MaskPosition<string | number> | undefined;
        maskRepeat?: import("csstype").Property.MaskRepeat | undefined;
        maskSize?: import("csstype").Property.MaskSize<string | number> | undefined;
        maskType?: import("csstype").Property.MaskType | undefined;
        mathStyle?: import("csstype").Property.MathStyle | undefined;
        maxBlockSize?: import("csstype").Property.MaxBlockSize<string | number> | undefined;
        maxHeight?: import("csstype").Property.MaxHeight<string | number> | undefined;
        maxInlineSize?: import("csstype").Property.MaxInlineSize<string | number> | undefined;
        maxLines?: import("csstype").Property.MaxLines | undefined;
        maxWidth?: import("csstype").Property.MaxWidth<string | number> | undefined;
        minBlockSize?: import("csstype").Property.MinBlockSize<string | number> | undefined;
        minHeight?: import("csstype").Property.MinHeight<string | number> | undefined;
        minInlineSize?: import("csstype").Property.MinInlineSize<string | number> | undefined;
        minWidth?: import("csstype").Property.MinWidth<string | number> | undefined;
        mixBlendMode?: import("csstype").Property.MixBlendMode | undefined;
        motionDistance?: import("csstype").Property.OffsetDistance<string | number> | undefined;
        motionPath?: import("csstype").Property.OffsetPath | undefined;
        motionRotation?: import("csstype").Property.OffsetRotate | undefined;
        objectFit?: import("csstype").Property.ObjectFit | undefined;
        objectPosition?: import("csstype").Property.ObjectPosition<string | number> | undefined;
        offsetAnchor?: import("csstype").Property.OffsetAnchor<string | number> | undefined;
        offsetDistance?: import("csstype").Property.OffsetDistance<string | number> | undefined;
        offsetPath?: import("csstype").Property.OffsetPath | undefined;
        offsetRotate?: import("csstype").Property.OffsetRotate | undefined;
        offsetRotation?: import("csstype").Property.OffsetRotate | undefined;
        opacity?: import("csstype").Property.Opacity | undefined;
        order?: import("csstype").Property.Order | undefined;
        orphans?: import("csstype").Property.Orphans | undefined;
        outlineColor?: import("csstype").Property.OutlineColor | undefined;
        outlineOffset?: import("csstype").Property.OutlineOffset<string | number> | undefined;
        outlineStyle?: import("csstype").Property.OutlineStyle | undefined;
        outlineWidth?: import("csstype").Property.OutlineWidth<string | number> | undefined;
        overflowAnchor?: import("csstype").Property.OverflowAnchor | undefined;
        overflowBlock?: import("csstype").Property.OverflowBlock | undefined;
        overflowClipBox?: import("csstype").Property.OverflowClipBox | undefined;
        overflowClipMargin?: import("csstype").Property.OverflowClipMargin<string | number> | undefined;
        overflowInline?: import("csstype").Property.OverflowInline | undefined;
        overflowWrap?: import("csstype").Property.OverflowWrap | undefined;
        overflowX?: import("csstype").Property.OverflowX | undefined;
        overflowY?: import("csstype").Property.OverflowY | undefined;
        overscrollBehaviorBlock?: import("csstype").Property.OverscrollBehaviorBlock | undefined;
        overscrollBehaviorInline?: import("csstype").Property.OverscrollBehaviorInline | undefined;
        overscrollBehaviorX?: import("csstype").Property.OverscrollBehaviorX | undefined;
        overscrollBehaviorY?: import("csstype").Property.OverscrollBehaviorY | undefined;
        paddingBlock?: import("csstype").Property.PaddingBlock<string | number> | undefined;
        paddingBlockEnd?: import("csstype").Property.PaddingBlockEnd<string | number> | undefined;
        paddingBlockStart?: import("csstype").Property.PaddingBlockStart<string | number> | undefined;
        paddingBottom?: import("csstype").Property.PaddingBottom<string | number> | undefined;
        paddingInline?: import("csstype").Property.PaddingInline<string | number> | undefined;
        paddingInlineEnd?: import("csstype").Property.PaddingInlineEnd<string | number> | undefined;
        paddingInlineStart?: import("csstype").Property.PaddingInlineStart<string | number> | undefined;
        paddingLeft?: import("csstype").Property.PaddingLeft<string | number> | undefined;
        paddingRight?: import("csstype").Property.PaddingRight<string | number> | undefined;
        paddingTop?: import("csstype").Property.PaddingTop<string | number> | undefined;
        pageBreakAfter?: import("csstype").Property.PageBreakAfter | undefined;
        pageBreakBefore?: import("csstype").Property.PageBreakBefore | undefined;
        pageBreakInside?: import("csstype").Property.PageBreakInside | undefined;
        paintOrder?: import("csstype").Property.PaintOrder | undefined;
        perspective?: import("csstype").Property.Perspective<string | number> | undefined;
        perspectiveOrigin?: import("csstype").Property.PerspectiveOrigin<string | number> | undefined;
        placeContent?: import("csstype").Property.PlaceContent | undefined;
        pointerEvents?: import("csstype").Property.PointerEvents | undefined;
        position?: import("csstype").Property.Position | undefined;
        quotes?: import("csstype").Property.Quotes | undefined;
        resize?: import("csstype").Property.Resize | undefined;
        right?: import("csstype").Property.Right<string | number> | undefined;
        rotate?: import("csstype").Property.Rotate | undefined;
        rowGap?: import("csstype").Property.RowGap<string | number> | undefined;
        rubyAlign?: import("csstype").Property.RubyAlign | undefined;
        rubyMerge?: import("csstype").Property.RubyMerge | undefined;
        rubyPosition?: import("csstype").Property.RubyPosition | undefined;
        scale?: import("csstype").Property.Scale | undefined;
        scrollBehavior?: import("csstype").Property.ScrollBehavior | undefined;
        scrollMargin?: import("csstype").Property.ScrollMargin<string | number> | undefined;
        scrollMarginBlock?: import("csstype").Property.ScrollMarginBlock<string | number> | undefined;
        scrollMarginBlockEnd?: import("csstype").Property.ScrollMarginBlockEnd<string | number> | undefined;
        scrollMarginBlockStart?: import("csstype").Property.ScrollMarginBlockStart<string | number> | undefined;
        scrollMarginBottom?: import("csstype").Property.ScrollMarginBottom<string | number> | undefined;
        scrollMarginInline?: import("csstype").Property.ScrollMarginInline<string | number> | undefined;
        scrollMarginInlineEnd?: import("csstype").Property.ScrollMarginInlineEnd<string | number> | undefined;
        scrollMarginInlineStart?: import("csstype").Property.ScrollMarginInlineStart<string | number> | undefined;
        scrollMarginLeft?: import("csstype").Property.ScrollMarginLeft<string | number> | undefined;
        scrollMarginRight?: import("csstype").Property.ScrollMarginRight<string | number> | undefined;
        scrollMarginTop?: import("csstype").Property.ScrollMarginTop<string | number> | undefined;
        scrollPadding?: import("csstype").Property.ScrollPadding<string | number> | undefined;
        scrollPaddingBlock?: import("csstype").Property.ScrollPaddingBlock<string | number> | undefined;
        scrollPaddingBlockEnd?: import("csstype").Property.ScrollPaddingBlockEnd<string | number> | undefined;
        scrollPaddingBlockStart?: import("csstype").Property.ScrollPaddingBlockStart<string | number> | undefined;
        scrollPaddingBottom?: import("csstype").Property.ScrollPaddingBottom<string | number> | undefined;
        scrollPaddingInline?: import("csstype").Property.ScrollPaddingInline<string | number> | undefined;
        scrollPaddingInlineEnd?: import("csstype").Property.ScrollPaddingInlineEnd<string | number> | undefined;
        scrollPaddingInlineStart?: import("csstype").Property.ScrollPaddingInlineStart<string | number> | undefined;
        scrollPaddingLeft?: import("csstype").Property.ScrollPaddingLeft<string | number> | undefined;
        scrollPaddingRight?: import("csstype").Property.ScrollPaddingRight<string | number> | undefined;
        scrollPaddingTop?: import("csstype").Property.ScrollPaddingTop<string | number> | undefined;
        scrollSnapAlign?: import("csstype").Property.ScrollSnapAlign | undefined;
        scrollSnapMargin?: import("csstype").Property.ScrollMargin<string | number> | undefined;
        scrollSnapMarginBottom?: import("csstype").Property.ScrollMarginBottom<string | number> | undefined;
        scrollSnapMarginLeft?: import("csstype").Property.ScrollMarginLeft<string | number> | undefined;
        scrollSnapMarginRight?: import("csstype").Property.ScrollMarginRight<string | number> | undefined;
        scrollSnapMarginTop?: import("csstype").Property.ScrollMarginTop<string | number> | undefined;
        scrollSnapStop?: import("csstype").Property.ScrollSnapStop | undefined;
        scrollSnapType?: import("csstype").Property.ScrollSnapType | undefined;
        scrollbarColor?: import("csstype").Property.ScrollbarColor | undefined;
        scrollbarGutter?: import("csstype").Property.ScrollbarGutter | undefined;
        scrollbarWidth?: import("csstype").Property.ScrollbarWidth | undefined;
        shapeImageThreshold?: import("csstype").Property.ShapeImageThreshold | undefined;
        shapeMargin?: import("csstype").Property.ShapeMargin<string | number> | undefined;
        shapeOutside?: import("csstype").Property.ShapeOutside | undefined;
        tabSize?: import("csstype").Property.TabSize<string | number> | undefined;
        tableLayout?: import("csstype").Property.TableLayout | undefined;
        textAlign?: import("csstype").Property.TextAlign | undefined;
        textAlignLast?: import("csstype").Property.TextAlignLast | undefined;
        textCombineUpright?: import("csstype").Property.TextCombineUpright | undefined;
        textDecorationColor?: import("csstype").Property.TextDecorationColor | undefined;
        textDecorationLine?: import("csstype").Property.TextDecorationLine | undefined;
        textDecorationSkip?: import("csstype").Property.TextDecorationSkip | undefined;
        textDecorationSkipInk?: import("csstype").Property.TextDecorationSkipInk | undefined;
        textDecorationStyle?: import("csstype").Property.TextDecorationStyle | undefined;
        textDecorationThickness?: import("csstype").Property.TextDecorationThickness<string | number> | undefined;
        textDecorationWidth?: import("csstype").Property.TextDecorationThickness<string | number> | undefined;
        textEmphasisColor?: import("csstype").Property.TextEmphasisColor | undefined;
        textEmphasisPosition?: import("csstype").Property.TextEmphasisPosition | undefined;
        textEmphasisStyle?: import("csstype").Property.TextEmphasisStyle | undefined;
        textIndent?: import("csstype").Property.TextIndent<string | number> | undefined;
        textJustify?: import("csstype").Property.TextJustify | undefined;
        textOrientation?: import("csstype").Property.TextOrientation | undefined;
        textOverflow?: import("csstype").Property.TextOverflow | undefined;
        textRendering?: import("csstype").Property.TextRendering | undefined;
        textShadow?: import("csstype").Property.TextShadow | undefined;
        textSizeAdjust?: import("csstype").Property.TextSizeAdjust | undefined;
        textTransform?: import("csstype").Property.TextTransform | undefined;
        textUnderlineOffset?: import("csstype").Property.TextUnderlineOffset<string | number> | undefined;
        textUnderlinePosition?: import("csstype").Property.TextUnderlinePosition | undefined;
        top?: import("csstype").Property.Top<string | number> | undefined;
        touchAction?: import("csstype").Property.TouchAction | undefined;
        transform?: import("csstype").Property.Transform | undefined;
        transformBox?: import("csstype").Property.TransformBox | undefined;
        transformStyle?: import("csstype").Property.TransformStyle | undefined;
        transitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
        transitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
        transitionProperty?: import("csstype").Property.TransitionProperty | undefined;
        transitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
        translate?: import("csstype").Property.Translate<string | number> | undefined;
        unicodeBidi?: import("csstype").Property.UnicodeBidi | undefined;
        userSelect?: import("csstype").Property.UserSelect | undefined;
        verticalAlign?: import("csstype").Property.VerticalAlign<string | number> | undefined;
        visibility?: import("csstype").Property.Visibility | undefined;
        whiteSpace?: import("csstype").Property.WhiteSpace | undefined;
        widows?: import("csstype").Property.Widows | undefined;
        width?: import("csstype").Property.Width<string | number> | undefined;
        willChange?: import("csstype").Property.WillChange | undefined;
        wordBreak?: import("csstype").Property.WordBreak | undefined;
        wordSpacing?: import("csstype").Property.WordSpacing<string | number> | undefined;
        wordWrap?: import("csstype").Property.WordWrap | undefined;
        writingMode?: import("csstype").Property.WritingMode | undefined;
        zIndex?: import("csstype").Property.ZIndex | undefined;
        zoom?: import("csstype").Property.Zoom | undefined;
        all?: import("csstype").Globals | undefined;
        animation?: import("csstype").Property.Animation<string & {}> | undefined;
        background?: import("csstype").Property.Background<string | number> | undefined;
        backgroundPosition?: import("csstype").Property.BackgroundPosition<string | number> | undefined;
        border?: import("csstype").Property.Border<string | number> | undefined;
        borderBlock?: import("csstype").Property.BorderBlock<string | number> | undefined;
        borderBlockEnd?: import("csstype").Property.BorderBlockEnd<string | number> | undefined;
        borderBlockStart?: import("csstype").Property.BorderBlockStart<string | number> | undefined;
        borderBottom?: import("csstype").Property.BorderBottom<string | number> | undefined;
        borderColor?: import("csstype").Property.BorderColor | undefined;
        borderImage?: import("csstype").Property.BorderImage | undefined;
        borderInline?: import("csstype").Property.BorderInline<string | number> | undefined;
        borderInlineEnd?: import("csstype").Property.BorderInlineEnd<string | number> | undefined;
        borderInlineStart?: import("csstype").Property.BorderInlineStart<string | number> | undefined;
        borderLeft?: import("csstype").Property.BorderLeft<string | number> | undefined;
        borderRadius?: import("csstype").Property.BorderRadius<string | number> | undefined;
        borderRight?: import("csstype").Property.BorderRight<string | number> | undefined;
        borderStyle?: import("csstype").Property.BorderStyle | undefined;
        borderTop?: import("csstype").Property.BorderTop<string | number> | undefined;
        borderWidth?: import("csstype").Property.BorderWidth<string | number> | undefined;
        columnRule?: import("csstype").Property.ColumnRule<string | number> | undefined;
        columns?: import("csstype").Property.Columns<string | number> | undefined;
        flex?: import("csstype").Property.Flex<string | number> | undefined;
        flexFlow?: import("csstype").Property.FlexFlow | undefined;
        font?: import("csstype").Property.Font | undefined;
        gap?: import("csstype").Property.Gap<string | number> | undefined;
        grid?: import("csstype").Property.Grid | undefined;
        gridArea?: import("csstype").Property.GridArea | undefined;
        gridColumn?: import("csstype").Property.GridColumn | undefined;
        gridRow?: import("csstype").Property.GridRow | undefined;
        gridTemplate?: import("csstype").Property.GridTemplate | undefined;
        lineClamp?: import("csstype").Property.LineClamp | undefined;
        listStyle?: import("csstype").Property.ListStyle | undefined;
        margin?: import("csstype").Property.Margin<string | number> | undefined;
        mask?: import("csstype").Property.Mask<string | number> | undefined;
        maskBorder?: import("csstype").Property.MaskBorder | undefined;
        motion?: import("csstype").Property.Offset<string | number> | undefined;
        offset?: import("csstype").Property.Offset<string | number> | undefined;
        outline?: import("csstype").Property.Outline<string | number> | undefined;
        overflow?: import("csstype").Property.Overflow | undefined;
        overscrollBehavior?: import("csstype").Property.OverscrollBehavior | undefined;
        padding?: import("csstype").Property.Padding<string | number> | undefined;
        placeItems?: import("csstype").Property.PlaceItems | undefined;
        placeSelf?: import("csstype").Property.PlaceSelf | undefined;
        textDecoration?: import("csstype").Property.TextDecoration<string | number> | undefined;
        textEmphasis?: import("csstype").Property.TextEmphasis | undefined;
        transition?: import("csstype").Property.Transition<string & {}> | undefined;
        MozAnimationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
        MozAnimationDirection?: import("csstype").Property.AnimationDirection | undefined;
        MozAnimationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
        MozAnimationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
        MozAnimationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
        MozAnimationName?: import("csstype").Property.AnimationName | undefined;
        MozAnimationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
        MozAnimationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
        MozAppearance?: import("csstype").Property.MozAppearance | undefined;
        MozBackfaceVisibility?: import("csstype").Property.BackfaceVisibility | undefined;
        MozBorderBottomColors?: import("csstype").Property.MozBorderBottomColors | undefined;
        MozBorderEndColor?: import("csstype").Property.BorderInlineEndColor | undefined;
        MozBorderEndStyle?: import("csstype").Property.BorderInlineEndStyle | undefined;
        MozBorderEndWidth?: import("csstype").Property.BorderInlineEndWidth<string | number> | undefined;
        MozBorderLeftColors?: import("csstype").Property.MozBorderLeftColors | undefined;
        MozBorderRightColors?: import("csstype").Property.MozBorderRightColors | undefined;
        MozBorderStartColor?: import("csstype").Property.BorderInlineStartColor | undefined;
        MozBorderStartStyle?: import("csstype").Property.BorderInlineStartStyle | undefined;
        MozBorderTopColors?: import("csstype").Property.MozBorderTopColors | undefined;
        MozBoxSizing?: import("csstype").Property.BoxSizing | undefined;
        MozColumnCount?: import("csstype").Property.ColumnCount | undefined;
        MozColumnFill?: import("csstype").Property.ColumnFill | undefined;
        MozColumnGap?: import("csstype").Property.ColumnGap<string | number> | undefined;
        MozColumnRuleColor?: import("csstype").Property.ColumnRuleColor | undefined;
        MozColumnRuleStyle?: import("csstype").Property.ColumnRuleStyle | undefined;
        MozColumnRuleWidth?: import("csstype").Property.ColumnRuleWidth<string | number> | undefined;
        MozColumnWidth?: import("csstype").Property.ColumnWidth<string | number> | undefined;
        MozContextProperties?: import("csstype").Property.MozContextProperties | undefined;
        MozFontFeatureSettings?: import("csstype").Property.FontFeatureSettings | undefined;
        MozFontLanguageOverride?: import("csstype").Property.FontLanguageOverride | undefined;
        MozHyphens?: import("csstype").Property.Hyphens | undefined;
        MozImageRegion?: import("csstype").Property.MozImageRegion | undefined;
        MozMarginEnd?: import("csstype").Property.MarginInlineEnd<string | number> | undefined;
        MozMarginStart?: import("csstype").Property.MarginInlineStart<string | number> | undefined;
        MozOrient?: import("csstype").Property.MozOrient | undefined;
        MozOsxFontSmoothing?: import("csstype").Property.FontSmooth<string | number> | undefined;
        MozPaddingEnd?: import("csstype").Property.PaddingInlineEnd<string | number> | undefined;
        MozPaddingStart?: import("csstype").Property.PaddingInlineStart<string | number> | undefined;
        MozPerspective?: import("csstype").Property.Perspective<string | number> | undefined;
        MozPerspectiveOrigin?: import("csstype").Property.PerspectiveOrigin<string | number> | undefined;
        MozStackSizing?: import("csstype").Property.MozStackSizing | undefined;
        MozTabSize?: import("csstype").Property.TabSize<string | number> | undefined;
        MozTextBlink?: import("csstype").Property.MozTextBlink | undefined;
        MozTextSizeAdjust?: import("csstype").Property.TextSizeAdjust | undefined;
        MozTransformOrigin?: import("csstype").Property.TransformOrigin<string | number> | undefined;
        MozTransformStyle?: import("csstype").Property.TransformStyle | undefined;
        MozTransitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
        MozTransitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
        MozTransitionProperty?: import("csstype").Property.TransitionProperty | undefined;
        MozTransitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
        MozUserFocus?: import("csstype").Property.MozUserFocus | undefined;
        MozUserModify?: import("csstype").Property.MozUserModify | undefined;
        MozUserSelect?: import("csstype").Property.UserSelect | undefined;
        MozWindowDragging?: import("csstype").Property.MozWindowDragging | undefined;
        MozWindowShadow?: import("csstype").Property.MozWindowShadow | undefined;
        msAccelerator?: import("csstype").Property.MsAccelerator | undefined;
        msAlignSelf?: import("csstype").Property.AlignSelf | undefined;
        msBlockProgression?: import("csstype").Property.MsBlockProgression | undefined;
        msContentZoomChaining?: import("csstype").Property.MsContentZoomChaining | undefined;
        msContentZoomLimitMax?: import("csstype").Property.MsContentZoomLimitMax | undefined;
        msContentZoomLimitMin?: import("csstype").Property.MsContentZoomLimitMin | undefined;
        msContentZoomSnapPoints?: import("csstype").Property.MsContentZoomSnapPoints | undefined;
        msContentZoomSnapType?: import("csstype").Property.MsContentZoomSnapType | undefined;
        msContentZooming?: import("csstype").Property.MsContentZooming | undefined;
        msFilter?: import("csstype").Property.MsFilter | undefined;
        msFlexDirection?: import("csstype").Property.FlexDirection | undefined;
        msFlexPositive?: import("csstype").Property.FlexGrow | undefined;
        msFlowFrom?: import("csstype").Property.MsFlowFrom | undefined;
        msFlowInto?: import("csstype").Property.MsFlowInto | undefined;
        msGridColumns?: import("csstype").Property.MsGridColumns<string | number> | undefined;
        msGridRows?: import("csstype").Property.MsGridRows<string | number> | undefined;
        msHighContrastAdjust?: import("csstype").Property.MsHighContrastAdjust | undefined;
        msHyphenateLimitChars?: import("csstype").Property.MsHyphenateLimitChars | undefined;
        msHyphenateLimitLines?: import("csstype").Property.MsHyphenateLimitLines | undefined;
        msHyphenateLimitZone?: import("csstype").Property.MsHyphenateLimitZone<string | number> | undefined;
        msHyphens?: import("csstype").Property.Hyphens | undefined;
        msImeAlign?: import("csstype").Property.MsImeAlign | undefined;
        msJustifySelf?: import("csstype").Property.JustifySelf | undefined;
        msLineBreak?: import("csstype").Property.LineBreak | undefined;
        msOrder?: import("csstype").Property.Order | undefined;
        msOverflowStyle?: import("csstype").Property.MsOverflowStyle | undefined;
        msOverflowX?: import("csstype").Property.OverflowX | undefined;
        msOverflowY?: import("csstype").Property.OverflowY | undefined;
        msScrollChaining?: import("csstype").Property.MsScrollChaining | undefined;
        msScrollLimitXMax?: import("csstype").Property.MsScrollLimitXMax<string | number> | undefined;
        msScrollLimitXMin?: import("csstype").Property.MsScrollLimitXMin<string | number> | undefined;
        msScrollLimitYMax?: import("csstype").Property.MsScrollLimitYMax<string | number> | undefined;
        msScrollLimitYMin?: import("csstype").Property.MsScrollLimitYMin<string | number> | undefined;
        msScrollRails?: import("csstype").Property.MsScrollRails | undefined;
        msScrollSnapPointsX?: import("csstype").Property.MsScrollSnapPointsX | undefined;
        msScrollSnapPointsY?: import("csstype").Property.MsScrollSnapPointsY | undefined;
        msScrollSnapType?: import("csstype").Property.MsScrollSnapType | undefined;
        msScrollTranslation?: import("csstype").Property.MsScrollTranslation | undefined;
        msScrollbar3dlightColor?: import("csstype").Property.MsScrollbar3dlightColor | undefined;
        msScrollbarArrowColor?: import("csstype").Property.MsScrollbarArrowColor | undefined;
        msScrollbarBaseColor?: import("csstype").Property.MsScrollbarBaseColor | undefined;
        msScrollbarDarkshadowColor?: import("csstype").Property.MsScrollbarDarkshadowColor | undefined;
        msScrollbarFaceColor?: import("csstype").Property.MsScrollbarFaceColor | undefined;
        msScrollbarHighlightColor?: import("csstype").Property.MsScrollbarHighlightColor | undefined;
        msScrollbarShadowColor?: import("csstype").Property.MsScrollbarShadowColor | undefined;
        msTextAutospace?: import("csstype").Property.MsTextAutospace | undefined;
        msTextCombineHorizontal?: import("csstype").Property.TextCombineUpright | undefined;
        msTextOverflow?: import("csstype").Property.TextOverflow | undefined;
        msTouchAction?: import("csstype").Property.TouchAction | undefined;
        msTouchSelect?: import("csstype").Property.MsTouchSelect | undefined;
        msTransform?: import("csstype").Property.Transform | undefined;
        msTransformOrigin?: import("csstype").Property.TransformOrigin<string | number> | undefined;
        msTransitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
        msTransitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
        msTransitionProperty?: import("csstype").Property.TransitionProperty | undefined;
        msTransitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
        msUserSelect?: import("csstype").Property.MsUserSelect | undefined;
        msWordBreak?: import("csstype").Property.WordBreak | undefined;
        msWrapFlow?: import("csstype").Property.MsWrapFlow | undefined;
        msWrapMargin?: import("csstype").Property.MsWrapMargin<string | number> | undefined;
        msWrapThrough?: import("csstype").Property.MsWrapThrough | undefined;
        msWritingMode?: import("csstype").Property.WritingMode | undefined;
        WebkitAlignContent?: import("csstype").Property.AlignContent | undefined;
        WebkitAlignItems?: import("csstype").Property.AlignItems | undefined;
        WebkitAlignSelf?: import("csstype").Property.AlignSelf | undefined;
        WebkitAnimationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
        WebkitAnimationDirection?: import("csstype").Property.AnimationDirection | undefined;
        WebkitAnimationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
        WebkitAnimationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
        WebkitAnimationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
        WebkitAnimationName?: import("csstype").Property.AnimationName | undefined;
        WebkitAnimationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
        WebkitAnimationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
        WebkitAppearance?: import("csstype").Property.WebkitAppearance | undefined;
        WebkitBackdropFilter?: import("csstype").Property.BackdropFilter | undefined;
        WebkitBackfaceVisibility?: import("csstype").Property.BackfaceVisibility | undefined;
        WebkitBackgroundClip?: import("csstype").Property.BackgroundClip | undefined;
        WebkitBackgroundOrigin?: import("csstype").Property.BackgroundOrigin | undefined;
        WebkitBackgroundSize?: import("csstype").Property.BackgroundSize<string | number> | undefined;
        WebkitBorderBeforeColor?: import("csstype").Property.WebkitBorderBeforeColor | undefined;
        WebkitBorderBeforeStyle?: import("csstype").Property.WebkitBorderBeforeStyle | undefined;
        WebkitBorderBeforeWidth?: import("csstype").Property.WebkitBorderBeforeWidth<string | number> | undefined;
        WebkitBorderBottomLeftRadius?: import("csstype").Property.BorderBottomLeftRadius<string | number> | undefined;
        WebkitBorderBottomRightRadius?: import("csstype").Property.BorderBottomRightRadius<string | number> | undefined;
        WebkitBorderImageSlice?: import("csstype").Property.BorderImageSlice | undefined;
        WebkitBorderTopLeftRadius?: import("csstype").Property.BorderTopLeftRadius<string | number> | undefined;
        WebkitBorderTopRightRadius?: import("csstype").Property.BorderTopRightRadius<string | number> | undefined;
        WebkitBoxDecorationBreak?: import("csstype").Property.BoxDecorationBreak | undefined;
        WebkitBoxReflect?: import("csstype").Property.WebkitBoxReflect<string | number> | undefined;
        WebkitBoxShadow?: import("csstype").Property.BoxShadow | undefined;
        WebkitBoxSizing?: import("csstype").Property.BoxSizing | undefined;
        WebkitClipPath?: import("csstype").Property.ClipPath | undefined;
        WebkitColumnCount?: import("csstype").Property.ColumnCount | undefined;
        WebkitColumnFill?: import("csstype").Property.ColumnFill | undefined;
        WebkitColumnGap?: import("csstype").Property.ColumnGap<string | number> | undefined;
        WebkitColumnRuleColor?: import("csstype").Property.ColumnRuleColor | undefined;
        WebkitColumnRuleStyle?: import("csstype").Property.ColumnRuleStyle | undefined;
        WebkitColumnRuleWidth?: import("csstype").Property.ColumnRuleWidth<string | number> | undefined;
        WebkitColumnSpan?: import("csstype").Property.ColumnSpan | undefined;
        WebkitColumnWidth?: import("csstype").Property.ColumnWidth<string | number> | undefined;
        WebkitFilter?: import("csstype").Property.Filter | undefined;
        WebkitFlexBasis?: import("csstype").Property.FlexBasis<string | number> | undefined;
        WebkitFlexDirection?: import("csstype").Property.FlexDirection | undefined;
        WebkitFlexGrow?: import("csstype").Property.FlexGrow | undefined;
        WebkitFlexShrink?: import("csstype").Property.FlexShrink | undefined;
        WebkitFlexWrap?: import("csstype").Property.FlexWrap | undefined;
        WebkitFontFeatureSettings?: import("csstype").Property.FontFeatureSettings | undefined;
        WebkitFontKerning?: import("csstype").Property.FontKerning | undefined;
        WebkitFontSmoothing?: import("csstype").Property.FontSmooth<string | number> | undefined;
        WebkitFontVariantLigatures?: import("csstype").Property.FontVariantLigatures | undefined;
        WebkitHyphens?: import("csstype").Property.Hyphens | undefined;
        WebkitJustifyContent?: import("csstype").Property.JustifyContent | undefined;
        WebkitLineBreak?: import("csstype").Property.LineBreak | undefined;
        WebkitLineClamp?: import("csstype").Property.WebkitLineClamp | undefined;
        WebkitMarginEnd?: import("csstype").Property.MarginInlineEnd<string | number> | undefined;
        WebkitMarginStart?: import("csstype").Property.MarginInlineStart<string | number> | undefined;
        WebkitMaskAttachment?: import("csstype").Property.WebkitMaskAttachment | undefined;
        WebkitMaskBoxImageOutset?: import("csstype").Property.MaskBorderOutset<string | number> | undefined;
        WebkitMaskBoxImageRepeat?: import("csstype").Property.MaskBorderRepeat | undefined;
        WebkitMaskBoxImageSlice?: import("csstype").Property.MaskBorderSlice | undefined;
        WebkitMaskBoxImageSource?: import("csstype").Property.MaskBorderSource | undefined;
        WebkitMaskBoxImageWidth?: import("csstype").Property.MaskBorderWidth<string | number> | undefined;
        WebkitMaskClip?: import("csstype").Property.WebkitMaskClip | undefined;
        WebkitMaskComposite?: import("csstype").Property.WebkitMaskComposite | undefined;
        WebkitMaskImage?: import("csstype").Property.WebkitMaskImage | undefined;
        WebkitMaskOrigin?: import("csstype").Property.WebkitMaskOrigin | undefined;
        WebkitMaskPosition?: import("csstype").Property.WebkitMaskPosition<string | number> | undefined;
        WebkitMaskPositionX?: import("csstype").Property.WebkitMaskPositionX<string | number> | undefined;
        WebkitMaskPositionY?: import("csstype").Property.WebkitMaskPositionY<string | number> | undefined;
        WebkitMaskRepeat?: import("csstype").Property.WebkitMaskRepeat | undefined;
        WebkitMaskRepeatX?: import("csstype").Property.WebkitMaskRepeatX | undefined;
        WebkitMaskRepeatY?: import("csstype").Property.WebkitMaskRepeatY | undefined;
        WebkitMaskSize?: import("csstype").Property.WebkitMaskSize<string | number> | undefined;
        WebkitMaxInlineSize?: import("csstype").Property.MaxInlineSize<string | number> | undefined;
        WebkitOrder?: import("csstype").Property.Order | undefined;
        WebkitOverflowScrolling?: import("csstype").Property.WebkitOverflowScrolling | undefined;
        WebkitPaddingEnd?: import("csstype").Property.PaddingInlineEnd<string | number> | undefined;
        WebkitPaddingStart?: import("csstype").Property.PaddingInlineStart<string | number> | undefined;
        WebkitPerspective?: import("csstype").Property.Perspective<string | number> | undefined;
        WebkitPerspectiveOrigin?: import("csstype").Property.PerspectiveOrigin<string | number> | undefined;
        WebkitPrintColorAdjust?: import("csstype").Property.ColorAdjust | undefined;
        WebkitRubyPosition?: import("csstype").Property.RubyPosition | undefined;
        WebkitScrollSnapType?: import("csstype").Property.ScrollSnapType | undefined;
        WebkitShapeMargin?: import("csstype").Property.ShapeMargin<string | number> | undefined;
        WebkitTapHighlightColor?: import("csstype").Property.WebkitTapHighlightColor | undefined;
        WebkitTextCombine?: import("csstype").Property.TextCombineUpright | undefined;
        WebkitTextDecorationColor?: import("csstype").Property.TextDecorationColor | undefined;
        WebkitTextDecorationLine?: import("csstype").Property.TextDecorationLine | undefined;
        WebkitTextDecorationSkip?: import("csstype").Property.TextDecorationSkip | undefined;
        WebkitTextDecorationStyle?: import("csstype").Property.TextDecorationStyle | undefined;
        WebkitTextEmphasisColor?: import("csstype").Property.TextEmphasisColor | undefined;
        WebkitTextEmphasisPosition?: import("csstype").Property.TextEmphasisPosition | undefined;
        WebkitTextEmphasisStyle?: import("csstype").Property.TextEmphasisStyle | undefined;
        WebkitTextFillColor?: import("csstype").Property.WebkitTextFillColor | undefined;
        WebkitTextOrientation?: import("csstype").Property.TextOrientation | undefined;
        WebkitTextSizeAdjust?: import("csstype").Property.TextSizeAdjust | undefined;
        WebkitTextStrokeColor?: import("csstype").Property.WebkitTextStrokeColor | undefined;
        WebkitTextStrokeWidth?: import("csstype").Property.WebkitTextStrokeWidth<string | number> | undefined;
        WebkitTextUnderlinePosition?: import("csstype").Property.TextUnderlinePosition | undefined;
        WebkitTouchCallout?: import("csstype").Property.WebkitTouchCallout | undefined;
        WebkitTransform?: import("csstype").Property.Transform | undefined;
        WebkitTransformOrigin?: import("csstype").Property.TransformOrigin<string | number> | undefined;
        WebkitTransformStyle?: import("csstype").Property.TransformStyle | undefined;
        WebkitTransitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
        WebkitTransitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
        WebkitTransitionProperty?: import("csstype").Property.TransitionProperty | undefined;
        WebkitTransitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
        WebkitUserModify?: import("csstype").Property.WebkitUserModify | undefined;
        WebkitUserSelect?: import("csstype").Property.UserSelect | undefined;
        WebkitWritingMode?: import("csstype").Property.WritingMode | undefined;
        MozAnimation?: import("csstype").Property.Animation<string & {}> | undefined;
        MozBorderImage?: import("csstype").Property.BorderImage | undefined;
        MozColumnRule?: import("csstype").Property.ColumnRule<string | number> | undefined;
        MozColumns?: import("csstype").Property.Columns<string | number> | undefined;
        MozTransition?: import("csstype").Property.Transition<string & {}> | undefined;
        msContentZoomLimit?: import("csstype").Property.MsContentZoomLimit | undefined;
        msContentZoomSnap?: import("csstype").Property.MsContentZoomSnap | undefined;
        msFlex?: import("csstype").Property.Flex<string | number> | undefined;
        msScrollLimit?: import("csstype").Property.MsScrollLimit | undefined;
        msScrollSnapX?: import("csstype").Property.MsScrollSnapX | undefined;
        msScrollSnapY?: import("csstype").Property.MsScrollSnapY | undefined;
        msTransition?: import("csstype").Property.Transition<string & {}> | undefined;
        WebkitAnimation?: import("csstype").Property.Animation<string & {}> | undefined;
        WebkitBorderBefore?: import("csstype").Property.WebkitBorderBefore<string | number> | undefined;
        WebkitBorderImage?: import("csstype").Property.BorderImage | undefined;
        WebkitBorderRadius?: import("csstype").Property.BorderRadius<string | number> | undefined;
        WebkitColumnRule?: import("csstype").Property.ColumnRule<string | number> | undefined;
        WebkitColumns?: import("csstype").Property.Columns<string | number> | undefined;
        WebkitFlex?: import("csstype").Property.Flex<string | number> | undefined;
        WebkitFlexFlow?: import("csstype").Property.FlexFlow | undefined;
        WebkitMask?: import("csstype").Property.WebkitMask<string | number> | undefined;
        WebkitMaskBoxImage?: import("csstype").Property.MaskBorder | undefined;
        WebkitTextEmphasis?: import("csstype").Property.TextEmphasis | undefined;
        WebkitTextStroke?: import("csstype").Property.WebkitTextStroke<string | number> | undefined;
        WebkitTransition?: import("csstype").Property.Transition<string & {}> | undefined;
        azimuth?: import("csstype").Property.Azimuth | undefined;
        boxAlign?: import("csstype").Property.BoxAlign | undefined;
        boxDirection?: import("csstype").Property.BoxDirection | undefined;
        boxFlex?: import("csstype").Property.BoxFlex | undefined;
        boxFlexGroup?: import("csstype").Property.BoxFlexGroup | undefined;
        boxLines?: import("csstype").Property.BoxLines | undefined;
        boxOrdinalGroup?: import("csstype").Property.BoxOrdinalGroup | undefined;
        boxOrient?: import("csstype").Property.BoxOrient | undefined;
        boxPack?: import("csstype").Property.BoxPack | undefined;
        clip?: import("csstype").Property.Clip | undefined;
        fontVariantAlternates?: import("csstype").Property.FontVariantAlternates | undefined;
        gridColumnGap?: import("csstype").Property.GridColumnGap<string | number> | undefined;
        gridGap?: import("csstype").Property.GridGap<string | number> | undefined;
        gridRowGap?: import("csstype").Property.GridRowGap<string | number> | undefined;
        imeMode?: import("csstype").Property.ImeMode | undefined;
        offsetBlock?: import("csstype").Property.InsetBlock<string | number> | undefined;
        offsetBlockEnd?: import("csstype").Property.InsetBlockEnd<string | number> | undefined;
        offsetBlockStart?: import("csstype").Property.InsetBlockStart<string | number> | undefined;
        offsetInline?: import("csstype").Property.InsetInline<string | number> | undefined;
        offsetInlineEnd?: import("csstype").Property.InsetInlineEnd<string | number> | undefined;
        offsetInlineStart?: import("csstype").Property.InsetInlineStart<string | number> | undefined;
        scrollSnapCoordinate?: import("csstype").Property.ScrollSnapCoordinate<string | number> | undefined;
        scrollSnapDestination?: import("csstype").Property.ScrollSnapDestination<string | number> | undefined;
        scrollSnapPointsX?: import("csstype").Property.ScrollSnapPointsX | undefined;
        scrollSnapPointsY?: import("csstype").Property.ScrollSnapPointsY | undefined;
        scrollSnapTypeX?: import("csstype").Property.ScrollSnapTypeX | undefined;
        scrollSnapTypeY?: import("csstype").Property.ScrollSnapTypeY | undefined;
        scrollbarTrackColor?: import("csstype").Property.MsScrollbarTrackColor | undefined;
        KhtmlBoxAlign?: import("csstype").Property.BoxAlign | undefined;
        KhtmlBoxDirection?: import("csstype").Property.BoxDirection | undefined;
        KhtmlBoxFlex?: import("csstype").Property.BoxFlex | undefined;
        KhtmlBoxFlexGroup?: import("csstype").Property.BoxFlexGroup | undefined;
        KhtmlBoxLines?: import("csstype").Property.BoxLines | undefined;
        KhtmlBoxOrdinalGroup?: import("csstype").Property.BoxOrdinalGroup | undefined;
        KhtmlBoxOrient?: import("csstype").Property.BoxOrient | undefined;
        KhtmlBoxPack?: import("csstype").Property.BoxPack | undefined;
        KhtmlLineBreak?: import("csstype").Property.LineBreak | undefined;
        KhtmlOpacity?: import("csstype").Property.Opacity | undefined;
        KhtmlUserSelect?: import("csstype").Property.UserSelect | undefined;
        MozBackgroundClip?: import("csstype").Property.BackgroundClip | undefined;
        MozBackgroundInlinePolicy?: import("csstype").Property.BoxDecorationBreak | undefined;
        MozBackgroundOrigin?: import("csstype").Property.BackgroundOrigin | undefined;
        MozBackgroundSize?: import("csstype").Property.BackgroundSize<string | number> | undefined;
        MozBinding?: import("csstype").Property.MozBinding | undefined;
        MozBorderRadius?: import("csstype").Property.BorderRadius<string | number> | undefined;
        MozBorderRadiusBottomleft?: import("csstype").Property.BorderBottomLeftRadius<string | number> | undefined;
        MozBorderRadiusBottomright?: import("csstype").Property.BorderBottomRightRadius<string | number> | undefined;
        MozBorderRadiusTopleft?: import("csstype").Property.BorderTopLeftRadius<string | number> | undefined;
        MozBorderRadiusTopright?: import("csstype").Property.BorderTopRightRadius<string | number> | undefined;
        MozBoxAlign?: import("csstype").Property.BoxAlign | undefined;
        MozBoxDirection?: import("csstype").Property.BoxDirection | undefined;
        MozBoxFlex?: import("csstype").Property.BoxFlex | undefined;
        MozBoxOrdinalGroup?: import("csstype").Property.BoxOrdinalGroup | undefined;
        MozBoxOrient?: import("csstype").Property.BoxOrient | undefined;
        MozBoxPack?: import("csstype").Property.BoxPack | undefined;
        MozBoxShadow?: import("csstype").Property.BoxShadow | undefined;
        MozFloatEdge?: import("csstype").Property.MozFloatEdge | undefined;
        MozForceBrokenImageIcon?: import("csstype").Property.MozForceBrokenImageIcon | undefined;
        MozOpacity?: import("csstype").Property.Opacity | undefined;
        MozOutline?: import("csstype").Property.Outline<string | number> | undefined;
        MozOutlineColor?: import("csstype").Property.OutlineColor | undefined;
        MozOutlineRadius?: import("csstype").Property.MozOutlineRadius<string | number> | undefined;
        MozOutlineRadiusBottomleft?: import("csstype").Property.MozOutlineRadiusBottomleft<string | number> | undefined;
        MozOutlineRadiusBottomright?: import("csstype").Property.MozOutlineRadiusBottomright<string | number> | undefined;
        MozOutlineRadiusTopleft?: import("csstype").Property.MozOutlineRadiusTopleft<string | number> | undefined;
        MozOutlineRadiusTopright?: import("csstype").Property.MozOutlineRadiusTopright<string | number> | undefined;
        MozOutlineStyle?: import("csstype").Property.OutlineStyle | undefined;
        MozOutlineWidth?: import("csstype").Property.OutlineWidth<string | number> | undefined;
        MozTextAlignLast?: import("csstype").Property.TextAlignLast | undefined;
        MozTextDecorationColor?: import("csstype").Property.TextDecorationColor | undefined;
        MozTextDecorationLine?: import("csstype").Property.TextDecorationLine | undefined;
        MozTextDecorationStyle?: import("csstype").Property.TextDecorationStyle | undefined;
        MozUserInput?: import("csstype").Property.MozUserInput | undefined;
        msImeMode?: import("csstype").Property.ImeMode | undefined;
        msScrollbarTrackColor?: import("csstype").Property.MsScrollbarTrackColor | undefined;
        OAnimation?: import("csstype").Property.Animation<string & {}> | undefined;
        OAnimationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
        OAnimationDirection?: import("csstype").Property.AnimationDirection | undefined;
        OAnimationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
        OAnimationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
        OAnimationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
        OAnimationName?: import("csstype").Property.AnimationName | undefined;
        OAnimationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
        OAnimationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
        OBackgroundSize?: import("csstype").Property.BackgroundSize<string | number> | undefined;
        OBorderImage?: import("csstype").Property.BorderImage | undefined;
        OObjectFit?: import("csstype").Property.ObjectFit | undefined;
        OObjectPosition?: import("csstype").Property.ObjectPosition<string | number> | undefined;
        OTabSize?: import("csstype").Property.TabSize<string | number> | undefined;
        OTextOverflow?: import("csstype").Property.TextOverflow | undefined;
        OTransform?: import("csstype").Property.Transform | undefined;
        OTransformOrigin?: import("csstype").Property.TransformOrigin<string | number> | undefined;
        OTransition?: import("csstype").Property.Transition<string & {}> | undefined;
        OTransitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
        OTransitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
        OTransitionProperty?: import("csstype").Property.TransitionProperty | undefined;
        OTransitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
        WebkitBoxAlign?: import("csstype").Property.BoxAlign | undefined;
        WebkitBoxDirection?: import("csstype").Property.BoxDirection | undefined;
        WebkitBoxFlex?: import("csstype").Property.BoxFlex | undefined;
        WebkitBoxFlexGroup?: import("csstype").Property.BoxFlexGroup | undefined;
        WebkitBoxLines?: import("csstype").Property.BoxLines | undefined;
        WebkitBoxOrdinalGroup?: import("csstype").Property.BoxOrdinalGroup | undefined;
        WebkitBoxOrient?: import("csstype").Property.BoxOrient | undefined;
        WebkitBoxPack?: import("csstype").Property.BoxPack | undefined;
        WebkitScrollSnapPointsX?: import("csstype").Property.ScrollSnapPointsX | undefined;
        WebkitScrollSnapPointsY?: import("csstype").Property.ScrollSnapPointsY | undefined;
        alignmentBaseline?: import("csstype").Property.AlignmentBaseline | undefined;
        baselineShift?: import("csstype").Property.BaselineShift<string | number> | undefined;
        clipRule?: import("csstype").Property.ClipRule | undefined;
        colorInterpolation?: import("csstype").Property.ColorInterpolation | undefined;
        colorRendering?: import("csstype").Property.ColorRendering | undefined;
        dominantBaseline?: import("csstype").Property.DominantBaseline | undefined;
        fill?: import("csstype").Property.Fill | undefined;
        fillOpacity?: import("csstype").Property.FillOpacity | undefined;
        fillRule?: import("csstype").Property.FillRule | undefined;
        floodColor?: import("csstype").Property.FloodColor | undefined;
        floodOpacity?: import("csstype").Property.FloodOpacity | undefined;
        glyphOrientationVertical?: import("csstype").Property.GlyphOrientationVertical | undefined;
        lightingColor?: import("csstype").Property.LightingColor | undefined;
        marker?: import("csstype").Property.Marker | undefined;
        markerEnd?: import("csstype").Property.MarkerEnd | undefined;
        markerMid?: import("csstype").Property.MarkerMid | undefined;
        markerStart?: import("csstype").Property.MarkerStart | undefined;
        shapeRendering?: import("csstype").Property.ShapeRendering | undefined;
        stopColor?: import("csstype").Property.StopColor | undefined;
        stopOpacity?: import("csstype").Property.StopOpacity | undefined;
        stroke?: import("csstype").Property.Stroke | undefined;
        strokeDasharray?: import("csstype").Property.StrokeDasharray<string | number> | undefined;
        strokeDashoffset?: import("csstype").Property.StrokeDashoffset<string | number> | undefined;
        strokeLinecap?: import("csstype").Property.StrokeLinecap | undefined;
        strokeLinejoin?: import("csstype").Property.StrokeLinejoin | undefined;
        strokeMiterlimit?: import("csstype").Property.StrokeMiterlimit | undefined;
        strokeOpacity?: import("csstype").Property.StrokeOpacity | undefined;
        strokeWidth?: import("csstype").Property.StrokeWidth<string | number> | undefined;
        textAnchor?: import("csstype").Property.TextAnchor | undefined;
        vectorEffect?: import("csstype").Property.VectorEffect | undefined;
    };
    "aria-orientation": "vertical" | "horizontal" | undefined;
    onKeyDown: (event: React.KeyboardEvent<Element>) => void;
    slot?: string | undefined;
    title?: string | undefined;
    dir?: string | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-disabled'?: (boolean | "false" | "true") | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUp?: React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<Element> | undefined;
    onClick?: React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<Element> | undefined;
    onMouseDown?: React.MouseEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<Element> | undefined;
    onMouseLeave?: React.MouseEventHandler<Element> | undefined;
    onMouseMove?: React.MouseEventHandler<Element> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseOver?: React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<Element> | undefined;
    onMouseUp?: React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<Element> | undefined;
};
export declare function useMenuPositioner(props?: any): {
    children?: React.ReactNode;
    ref?: ((instance: HTMLDivElement | null) => void) | React.RefObject<HTMLDivElement> | null | undefined;
    slot?: string | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    dir?: string | undefined;
    key?: React.Key | null | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    id?: string | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    tabIndex?: number | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    role?: React.AriaRole | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-disabled'?: (boolean | "false" | "true") | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLDivElement> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLDivElement> | undefined;
    onFocus?: React.FocusEventHandler<HTMLDivElement> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLDivElement> | undefined;
    onBlur?: React.FocusEventHandler<HTMLDivElement> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLDivElement> | undefined;
    onChange?: React.FormEventHandler<HTMLDivElement> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLDivElement> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onInput?: React.FormEventHandler<HTMLDivElement> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onReset?: React.FormEventHandler<HTMLDivElement> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onSubmit?: React.FormEventHandler<HTMLDivElement> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onInvalid?: React.FormEventHandler<HTMLDivElement> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLDivElement> | undefined;
    onLoad?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onError?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onKeyDown?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onKeyPress?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onKeyUp?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<HTMLDivElement> | undefined;
    onAbort?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEnded?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPause?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPlay?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onProgress?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onStalled?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onDrag?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragExit?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragOver?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragStart?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDrop?: React.DragEventHandler<HTMLDivElement> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLDivElement> | undefined;
    onMouseDown?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseLeave?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseOver?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseUp?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLDivElement> | undefined;
    onSelect?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLDivElement> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLDivElement> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLDivElement> | undefined;
    onScroll?: React.UIEventHandler<HTMLDivElement> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLDivElement> | undefined;
    onWheel?: React.WheelEventHandler<HTMLDivElement> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLDivElement> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLDivElement> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLDivElement> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLDivElement> | undefined;
};
export interface UseMenuItemProps extends Omit<React.HTMLAttributes<Element>, "color" | "disabled"> {
    /**
     * If `true`, the menuitem will be disabled
     */
    isDisabled?: boolean;
    /**
     * If `true` and the menuitem is disabled, it'll
     * remain keyboard-focusable
     */
    isFocusable?: boolean;
    /**
     * Overrides the parent menu's `closeOnSelect` prop.
     */
    closeOnSelect?: boolean;
    /**
     * The type of the menuitem.
     */
    type?: React.ButtonHTMLAttributes<HTMLButtonElement>["type"];
}
export declare function useMenuItem(props?: UseMenuItemProps, externalRef?: React.Ref<any>): {
    type: any;
    id: string;
    role: string;
    tabIndex: number;
    ref: (node: any) => void;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: React.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: React.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: React.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: React.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: string | number | boolean | {} | React.ReactElement<any, string | React.JSXElementConstructor<any>> | Iterable<React.ReactNode> | React.ReactPortal | null | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
} | {
    type: any;
    id: string;
    role: string;
    tabIndex: number;
    ref: (node: any) => void;
    "data-active": import("@chakra-ui/utils").Booleanish;
    "aria-disabled": "true" | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseUp: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onKeyUp: (event: React.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseLeave: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-checked'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: string | number | boolean | {} | React.ReactElement<any, string | React.JSXElementConstructor<any>> | Iterable<React.ReactNode> | React.ReactPortal | null | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
};
export interface UseMenuOptionOptions {
    value?: string;
    isChecked?: boolean;
    type?: "radio" | "checkbox";
    children?: React.ReactNode;
}
export interface UseMenuOptionProps extends Omit<UseMenuItemProps, "type">, UseMenuOptionOptions {
}
export declare function useMenuOption(props?: UseMenuOptionProps, ref?: React.Ref<any>): {
    role: string;
    "aria-checked": boolean | "mixed" | "false" | "true" | undefined;
    type: any;
    id: string;
    tabIndex: number;
    ref: (node: any) => void;
    "aria-disabled": boolean | undefined;
    disabled: boolean | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseUp: React.MouseEventHandler<HTMLElement> | undefined;
    onKeyUp: React.KeyboardEventHandler<HTMLElement> | undefined;
    onKeyDown: React.KeyboardEventHandler<HTMLElement> | undefined;
    onMouseOver: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseLeave: React.MouseEventHandler<HTMLElement> | undefined;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: string | number | boolean | {} | React.ReactElement<any, string | React.JSXElementConstructor<any>> | Iterable<React.ReactNode> | React.ReactPortal | null | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
} | {
    role: string;
    "aria-checked": boolean | "mixed" | "false" | "true" | undefined;
    type: any;
    id: string;
    tabIndex: number;
    ref: (node: any) => void;
    "data-active": import("@chakra-ui/utils").Booleanish;
    "aria-disabled": "true" | undefined;
    onClick: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseDown: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseUp: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onKeyUp: (event: React.KeyboardEvent<HTMLElement>) => void;
    onKeyDown: (event: React.KeyboardEvent<HTMLElement>) => void;
    onMouseOver: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    onMouseLeave: (event: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    defaultChecked?: boolean | undefined;
    defaultValue?: string | number | readonly string[] | undefined;
    suppressContentEditableWarning?: boolean | undefined;
    suppressHydrationWarning?: boolean | undefined;
    accessKey?: string | undefined;
    className?: string | undefined;
    contentEditable?: "inherit" | (boolean | "false" | "true") | undefined;
    contextMenu?: string | undefined;
    dir?: string | undefined;
    draggable?: (boolean | "false" | "true") | undefined;
    hidden?: boolean | undefined;
    lang?: string | undefined;
    placeholder?: string | undefined;
    slot?: string | undefined;
    spellCheck?: (boolean | "false" | "true") | undefined;
    style?: React.CSSProperties | undefined;
    title?: string | undefined;
    translate?: "yes" | "no" | undefined;
    radioGroup?: string | undefined;
    about?: string | undefined;
    datatype?: string | undefined;
    inlist?: any;
    prefix?: string | undefined;
    property?: string | undefined;
    resource?: string | undefined;
    typeof?: string | undefined;
    vocab?: string | undefined;
    autoCapitalize?: string | undefined;
    autoCorrect?: string | undefined;
    autoSave?: string | undefined;
    color?: string | undefined;
    itemProp?: string | undefined;
    itemScope?: boolean | undefined;
    itemType?: string | undefined;
    itemID?: string | undefined;
    itemRef?: string | undefined;
    results?: number | undefined;
    security?: string | undefined;
    unselectable?: "on" | "off" | undefined;
    inputMode?: "search" | "text" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
    is?: string | undefined;
    'aria-activedescendant'?: string | undefined;
    'aria-atomic'?: (boolean | "false" | "true") | undefined;
    'aria-autocomplete'?: "none" | "list" | "both" | "inline" | undefined;
    'aria-busy'?: (boolean | "false" | "true") | undefined;
    'aria-colcount'?: number | undefined;
    'aria-colindex'?: number | undefined;
    'aria-colspan'?: number | undefined;
    'aria-controls'?: string | undefined;
    'aria-current'?: boolean | "time" | "step" | "page" | "false" | "true" | "location" | "date" | undefined;
    'aria-describedby'?: string | undefined;
    'aria-details'?: string | undefined;
    'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "execute" | "popup" | undefined;
    'aria-errormessage'?: string | undefined;
    'aria-expanded'?: (boolean | "false" | "true") | undefined;
    'aria-flowto'?: string | undefined;
    'aria-grabbed'?: (boolean | "false" | "true") | undefined;
    'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "listbox" | "false" | "true" | "tree" | undefined;
    'aria-hidden'?: (boolean | "false" | "true") | undefined;
    'aria-invalid'?: boolean | "false" | "true" | "grammar" | "spelling" | undefined;
    'aria-keyshortcuts'?: string | undefined;
    'aria-label'?: string | undefined;
    'aria-labelledby'?: string | undefined;
    'aria-level'?: number | undefined;
    'aria-live'?: "off" | "assertive" | "polite" | undefined;
    'aria-modal'?: (boolean | "false" | "true") | undefined;
    'aria-multiline'?: (boolean | "false" | "true") | undefined;
    'aria-multiselectable'?: (boolean | "false" | "true") | undefined;
    'aria-orientation'?: "vertical" | "horizontal" | undefined;
    'aria-owns'?: string | undefined;
    'aria-placeholder'?: string | undefined;
    'aria-posinset'?: number | undefined;
    'aria-pressed'?: boolean | "mixed" | "false" | "true" | undefined;
    'aria-readonly'?: (boolean | "false" | "true") | undefined;
    'aria-relevant'?: "text" | "all" | "additions" | "additions removals" | "additions text" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
    'aria-required'?: (boolean | "false" | "true") | undefined;
    'aria-roledescription'?: string | undefined;
    'aria-rowcount'?: number | undefined;
    'aria-rowindex'?: number | undefined;
    'aria-rowspan'?: number | undefined;
    'aria-selected'?: (boolean | "false" | "true") | undefined;
    'aria-setsize'?: number | undefined;
    'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
    'aria-valuemax'?: number | undefined;
    'aria-valuemin'?: number | undefined;
    'aria-valuenow'?: number | undefined;
    'aria-valuetext'?: string | undefined;
    children?: string | number | boolean | {} | React.ReactElement<any, string | React.JSXElementConstructor<any>> | Iterable<React.ReactNode> | React.ReactPortal | null | undefined;
    dangerouslySetInnerHTML?: {
        __html: string;
    } | undefined;
    onCopy?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCopyCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCut?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCutCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPaste?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onPasteCapture?: React.ClipboardEventHandler<HTMLElement> | React.ClipboardEventHandler<Element> | undefined;
    onCompositionEnd?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionEndCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStart?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionStartCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdate?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onCompositionUpdateCapture?: React.CompositionEventHandler<HTMLElement> | React.CompositionEventHandler<Element> | undefined;
    onFocus?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onFocusCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlur?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onBlurCapture?: React.FocusEventHandler<HTMLElement> | React.FocusEventHandler<Element> | undefined;
    onChange?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onChangeCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onBeforeInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInput?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInputCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onReset?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onResetCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmit?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onSubmitCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalid?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onInvalidCapture?: React.FormEventHandler<HTMLElement> | React.FormEventHandler<Element> | undefined;
    onLoad?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onError?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onErrorCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onKeyDownCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPress?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyPressCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onKeyUpCapture?: React.KeyboardEventHandler<HTMLElement> | React.KeyboardEventHandler<Element> | undefined;
    onAbort?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAbortCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThrough?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onCanPlayThroughCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onDurationChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptied?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEmptiedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncrypted?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEncryptedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEnded?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onEndedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedData?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedDataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadata?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadedMetadataCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStart?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onLoadStartCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPause?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPauseCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlay?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlaying?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onPlayingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgress?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onProgressCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onRateChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeked?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekedCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeeking?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSeekingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalled?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onStalledCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspend?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSuspendCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdate?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTimeUpdateCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChange?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onVolumeChangeCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaiting?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onWaitingCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onAuxClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onAuxClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenu?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onContextMenuCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClick?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDoubleClickCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onDrag?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnd?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEndCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnter?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragEnterCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExit?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragExitCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeave?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragLeaveCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOver?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragOverCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStart?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDragStartCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDrop?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onDropCapture?: React.DragEventHandler<HTMLElement> | React.DragEventHandler<Element> | undefined;
    onMouseDownCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseEnter?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMove?: React.MouseEventHandler<HTMLElement> | undefined;
    onMouseMoveCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOut?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOutCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseOverCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onMouseUpCapture?: React.MouseEventHandler<HTMLElement> | React.MouseEventHandler<Element> | undefined;
    onSelect?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onSelectCapture?: React.ReactEventHandler<HTMLElement> | React.ReactEventHandler<Element> | undefined;
    onTouchCancel?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchCancelCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEnd?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchEndCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMove?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchMoveCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStart?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onTouchStartCapture?: React.TouchEventHandler<HTMLElement> | React.TouchEventHandler<Element> | undefined;
    onPointerDown?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerDownCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMove?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerMoveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUp?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerUpCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancel?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerCancelCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnter?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerEnterCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeave?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerLeaveCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOver?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOverCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOut?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onPointerOutCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onGotPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onLostPointerCaptureCapture?: React.PointerEventHandler<HTMLElement> | React.PointerEventHandler<Element> | undefined;
    onScroll?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onScrollCapture?: React.UIEventHandler<HTMLElement> | React.UIEventHandler<Element> | undefined;
    onWheel?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onWheelCapture?: React.WheelEventHandler<HTMLElement> | React.WheelEventHandler<Element> | undefined;
    onAnimationStart?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationStartCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEnd?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationEndCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIteration?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onAnimationIterationCapture?: React.AnimationEventHandler<HTMLElement> | React.AnimationEventHandler<Element> | undefined;
    onTransitionEnd?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
    onTransitionEndCapture?: React.TransitionEventHandler<HTMLElement> | React.TransitionEventHandler<Element> | undefined;
};
export interface UseMenuOptionGroupProps {
    value?: string | string[];
    defaultValue?: string | string[];
    type?: "radio" | "checkbox";
    onChange?: (value: string | string[]) => void;
    children?: React.ReactNode;
}
export declare function useMenuOptionGroup(props?: UseMenuOptionGroupProps): {
    children: React.ReactElement<any, string | React.JSXElementConstructor<any>>[];
};
export declare function useMenuState(): {
    isOpen: boolean;
    onClose: () => void;
};
//# sourceMappingURL=use-menu.d.ts.map