'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var foundations_sizes_dist_chakraUiThemeFoundationsSizes = require('./sizes-db4377aa.cjs.prod.js');
var components_dist_chakraUiThemeComponents = require('./index-4cb288f3.cjs.prod.js');
var foundations_dist_chakraUiThemeFoundations = require('../foundations/dist/chakra-ui-theme-foundations.cjs.prod.js');
var themeTools = require('@chakra-ui/theme-tools');
var utils = require('@chakra-ui/utils');
require('../foundations/spacing/dist/chakra-ui-theme-foundations-spacing.cjs.prod.js');
require('@chakra-ui/anatomy');
require('../foundations/typography/dist/chakra-ui-theme-foundations-typography.cjs.prod.js');
require('@chakra-ui/system');
require('../foundations/borders/dist/chakra-ui-theme-foundations-borders.cjs.prod.js');
require('../foundations/breakpoints/dist/chakra-ui-theme-foundations-breakpoints.cjs.prod.js');
require('../foundations/colors/dist/chakra-ui-theme-foundations-colors.cjs.prod.js');
require('../foundations/radius/dist/chakra-ui-theme-foundations-radius.cjs.prod.js');
require('../foundations/shadows/dist/chakra-ui-theme-foundations-shadows.cjs.prod.js');
require('../foundations/transition/dist/chakra-ui-theme-foundations-transition.cjs.prod.js');
require('../foundations/z-index/dist/chakra-ui-theme-foundations-z-index.cjs.prod.js');
require('../foundations/blur/dist/chakra-ui-theme-foundations-blur.cjs.prod.js');

var styles = {
  global: function global(props) {
    return {
      body: {
        fontFamily: "body",
        color: themeTools.mode("gray.800", "whiteAlpha.900")(props),
        bg: themeTools.mode("white", "gray.800")(props),
        transitionProperty: "background-color",
        transitionDuration: "normal",
        lineHeight: "base"
      },
      "*::placeholder": {
        color: themeTools.mode("gray.400", "whiteAlpha.400")(props)
      },
      "*, *::before, &::after": {
        borderColor: themeTools.mode("gray.200", "whiteAlpha.300")(props),
        wordWrap: "break-word"
      }
    };
  }
};
var styles$1 = styles;

var requiredChakraThemeKeys = ["borders", "breakpoints", "colors", "components", "config", "direction", "fonts", "fontSizes", "fontWeights", "letterSpacings", "lineHeights", "radii", "shadows", "sizes", "space", "styles", "transition", "zIndices"];
function isChakraTheme(unit) {
  if (!utils.isObject(unit)) {
    return false;
  }

  return requiredChakraThemeKeys.every(function (propertyName) {
    return Object.prototype.hasOwnProperty.call(unit, propertyName);
  });
}

var direction = "ltr";
var config = {
  useSystemColorMode: false,
  initialColorMode: "light",
  cssVarPrefix: "chakra"
};
var theme = foundations_sizes_dist_chakraUiThemeFoundationsSizes._extends({
  direction: direction
}, foundations_dist_chakraUiThemeFoundations["default"], {
  components: components_dist_chakraUiThemeComponents.components,
  styles: styles$1,
  config: config
});

exports["default"] = theme;
exports.isChakraTheme = isChakraTheme;
exports.requiredChakraThemeKeys = requiredChakraThemeKeys;
exports.theme = theme;
