import * as React from "react";
/**
 * Styles to visually hide an element
 * but make it accessible to screen-readers
 */
export declare const visuallyHiddenStyle: React.CSSProperties;
/**
 * Visually hidden component used to hide
 * elements on screen
 */
export declare const VisuallyHidden: import("@chakra-ui/system").ChakraComponent<"span", {}>;
/**
 * Visually hidden input component for designing
 * custom input components using the html `input`
 * as a proxy
 */
export declare const VisuallyHiddenInput: import("@chakra-ui/system").ChakraComponent<"input", {}>;
export default VisuallyHidden;
//# sourceMappingURL=visually-hidden.d.ts.map