import { CookieOptions } from "../types";

export const DEFAULT_COOKIE_OPTIONS: CookieOptions = {
  path: "/",
  sameSite: "lax",
  httpOnly: false,
  // https://developer.chrome.com/blog/cookie-max-age-expires
  // https://httpwg.org/http-extensions/draft-ietf-httpbis-rfc6265bis.html#name-cookie-lifetime-limits
  maxAge: 400 * 24 * 60 * 60,
};
