"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateVectorDimension = exports.normalizeToFloat32 = exports.isPlainObject = exports.resolveResponse = exports.resolveFetch = exports.isStorageVectorsError = exports.StorageVectorsErrorCode = exports.StorageVectorsUnknownError = exports.StorageVectorsApiError = exports.StorageVectorsError = exports.VectorDataApi = exports.VectorIndexApi = exports.VectorBucketApi = exports.VectorIndexScope = exports.VectorBucketScope = exports.StorageVectorsClient = void 0;
const tslib_1 = require("tslib");
// Main client
var StorageVectorsClient_1 = require("./StorageVectorsClient");
Object.defineProperty(exports, "StorageVectorsClient", { enumerable: true, get: function () { return StorageVectorsClient_1.StorageVectorsClient; } });
Object.defineProperty(exports, "VectorBucketScope", { enumerable: true, get: function () { return StorageVectorsClient_1.VectorBucketScope; } });
Object.defineProperty(exports, "VectorIndexScope", { enumerable: true, get: function () { return StorageVectorsClient_1.VectorIndexScope; } });
// API classes (for advanced usage)
var VectorBucketApi_1 = require("./VectorBucketApi");
Object.defineProperty(exports, "VectorBucketApi", { enumerable: true, get: function () { return tslib_1.__importDefault(VectorBucketApi_1).default; } });
var VectorIndexApi_1 = require("./VectorIndexApi");
Object.defineProperty(exports, "VectorIndexApi", { enumerable: true, get: function () { return tslib_1.__importDefault(VectorIndexApi_1).default; } });
var VectorDataApi_1 = require("./VectorDataApi");
Object.defineProperty(exports, "VectorDataApi", { enumerable: true, get: function () { return tslib_1.__importDefault(VectorDataApi_1).default; } });
// Errors
var errors_1 = require("./errors");
Object.defineProperty(exports, "StorageVectorsError", { enumerable: true, get: function () { return errors_1.StorageVectorsError; } });
Object.defineProperty(exports, "StorageVectorsApiError", { enumerable: true, get: function () { return errors_1.StorageVectorsApiError; } });
Object.defineProperty(exports, "StorageVectorsUnknownError", { enumerable: true, get: function () { return errors_1.StorageVectorsUnknownError; } });
Object.defineProperty(exports, "StorageVectorsErrorCode", { enumerable: true, get: function () { return errors_1.StorageVectorsErrorCode; } });
Object.defineProperty(exports, "isStorageVectorsError", { enumerable: true, get: function () { return errors_1.isStorageVectorsError; } });
// Helper utilities
var helpers_1 = require("./helpers");
Object.defineProperty(exports, "resolveFetch", { enumerable: true, get: function () { return helpers_1.resolveFetch; } });
Object.defineProperty(exports, "resolveResponse", { enumerable: true, get: function () { return helpers_1.resolveResponse; } });
Object.defineProperty(exports, "isPlainObject", { enumerable: true, get: function () { return helpers_1.isPlainObject; } });
Object.defineProperty(exports, "normalizeToFloat32", { enumerable: true, get: function () { return helpers_1.normalizeToFloat32; } });
Object.defineProperty(exports, "validateVectorDimension", { enumerable: true, get: function () { return helpers_1.validateVectorDimension; } });
//# sourceMappingURL=index.js.map