import sync, { cancelSync } from "../";
import { onNextFrame } from "../on-next-frame";
describe("onNextFrame", function () {
    it("fires callback on following frame", function () {
        return new Promise(function (resolve) { return onNextFrame(resolve); });
    });
});
describe("sync", function () {
    it("fires callbacks in the correct order", function () {
        return new Promise(function (resolve, reject) {
            var order = [];
            sync.read(function () { return order.push(0); });
            sync.update(function () { return order.push(1); });
            sync.preRender(function () { return order.push(2); });
            sync.render(function () { return order.push(3); });
            sync.postRender(function () {
                order.push(4);
                if (order[0] === 0 &&
                    order[1] === 1 &&
                    order[2] === 2 &&
                    order[3] === 3 &&
                    order[4] === 4) {
                    resolve();
                }
                else {
                    reject(order);
                }
            });
        });
    });
    it("cancels callbacks", function () {
        return new Promise(function (resolve, reject) {
            var hasFired = false;
            var process = sync.render(function () { return (hasFired = true); });
            sync.update(function () { return cancelSync.render(process); });
            sync.postRender(function () { return (hasFired ? reject(hasFired) : resolve()); });
        });
    });
    it("fires callback on current frame if scheduled with `true` within the same step", function () {
        return new Promise(function (resolve, reject) {
            var v = 0;
            sync.update(function (_a) {
                var prevTimestamp = _a.timestamp;
                v++;
                sync.update(function (_a) {
                    var timestamp = _a.timestamp;
                    v++;
                    if (timestamp !== prevTimestamp) {
                        reject(timestamp + " " + prevTimestamp);
                    }
                }, false, true);
            });
            sync.render(function () { return (v === 2 ? resolve() : reject(v)); });
        });
    });
    it("fires callback on next frame if scheduled with `true` outside the same step", function () {
        return new Promise(function (resolve, reject) {
            var v = 0;
            sync.update(function () { return v++; });
            sync.update(function () { return v++; }, false, true);
            sync.render(function () { return (v === 2 ? resolve() : reject()); });
        });
    });
    it("uses default elapsed time if first fire", function () {
        return new Promise(function (resolve, reject) {
            sync.update(function (_a) {
                var defaultElapsed = _a.delta;
                setTimeout(function () {
                    return sync.update(function (_a) {
                        var delta = _a.delta;
                        return delta === defaultElapsed
                            ? resolve()
                            : reject(defaultElapsed, delta);
                    });
                }, 50);
            });
        });
    });
    it("correctly cancels", function () {
        return new Promise(function (resolve, reject) {
            var callback = function () { return reject(); };
            sync.read(function () { return cancelSync.update(callback); });
            sync.update(callback);
            sync.render(function () { return resolve(); });
        });
    });
    it("correctly keeps alive", function () {
        return new Promise(function (resolve) {
            var v = 0;
            sync.update(function () { return v++; }, true);
            sync.render(function () { return v === 2 && resolve(); }, true);
        });
    });
    it("correctly cancels a keepAlive process", function () {
        return new Promise(function (resolve, reject) {
            var updateCount = 0;
            var renderCount = 0;
            var update = sync.update(function () {
                updateCount++;
                if (updateCount === 4)
                    cancelSync.update(update);
            }, true);
            sync.render(function () {
                renderCount++;
                if (renderCount === 6) {
                    if (renderCount !== updateCount) {
                        resolve();
                    }
                    else {
                        reject([renderCount, updateCount]);
                    }
                }
            }, true);
        });
    });
});
//# sourceMappingURL=test.js.map