/**
 * @param reference  unique identifier for the transaction.
 * @param authEmail customer's email address.
 * @param items items inthe user's Cart
 */
import Cart from './cart';
export default class Payment {
    reference: string;
    authEmail?: string | undefined;
    items: Cart;
    constructor(reference: string, authEmail?: string | undefined, items?: Cart);
    /**
     * Adds an item to the 'shopping cart'
     * @param title
     * @param amount
     */
    add(title: string, amount: number, quantity?: number): Payment;
    info(): string;
    /**
     * Get the total of the items in the cart
     * @returns {*|number}
     */
    total(): number;
}
