import { __assign } from 'tslib';
import { useContext, useEffect } from 'react';
import { MotionConfigContext } from '../../context/MotionConfigContext.js';
import { VisualElementDragControls } from './VisualElementDragControls.js';
import { useConstant } from '../../utils/use-constant.js';

/**
 * A hook that allows an element to be dragged.
 *
 * @internal
 */
function useDrag(props) {
    var groupDragControls = props.dragControls, visualElement = props.visualElement;
    var transformPagePoint = useContext(MotionConfigContext).transformPagePoint;
    var dragControls = useConstant(function () {
        return new VisualElementDragControls({
            visualElement: visualElement,
        });
    });
    dragControls.setProps(__assign(__assign({}, props), { transformPagePoint: transformPagePoint }));
    // If we've been provided a DragControls for manual control over the drag gesture,
    // subscribe this component to it on mount.
    useEffect(function () { return groupDragControls && groupDragControls.subscribe(dragControls); }, [dragControls]);
    // Mount the drag controls with the visualElement
    useEffect(function () { return dragControls.mount(visualElement); }, []);
}

export { useDrag };
