export { createDomMotionComponent, motion } from './render/dom/motion.js';
export { m } from './render/dom/motion-minimal.js';
export { AnimatePresence } from './components/AnimatePresence/index.js';
export { AnimateSharedLayout } from './components/AnimateSharedLayout/index.js';
export { MotionConfig } from './components/MotionConfig/index.js';
export { LazyMotion } from './components/LazyMotion/index.js';
export { domAnimation } from './render/dom/features-animation.js';
export { domMax } from './render/dom/features-max.js';
export { useMotionValue } from './value/use-motion-value.js';
export { useMotionTemplate } from './value/use-motion-template.js';
export { MotionValue, motionValue } from './value/index.js';
export { resolveMotionValue } from './value/utils/resolve-motion-value.js';
export { useTransform } from './value/use-transform.js';
export { useSpring } from './value/use-spring.js';
export { useVelocity } from './value/use-velocity.js';
export { useElementScroll } from './value/scroll/use-element-scroll.js';
export { useViewportScroll } from './value/scroll/use-viewport-scroll.js';
export { useReducedMotion } from './utils/use-reduced-motion.js';
export { animationControls } from './animation/animation-controls.js';
export { useAnimation } from './animation/use-animation.js';
export { animate } from './animation/animate.js';
export { animateVisualElement } from './render/utils/animation.js';
export { useCycle } from './utils/use-cycle.js';
export { transform } from './utils/transform.js';
export { isValidMotionProp } from './motion/utils/valid-prop.js';
export { useIsPresent, usePresence } from './components/AnimatePresence/use-presence.js';
export { DragControls, useDragControls } from './gestures/drag/use-drag-controls.js';
export { useDomEvent } from './events/use-dom-event.js';
export { createMotionComponent } from './motion/index.js';
export { addScaleCorrection } from './render/dom/projection/scale-correction.js';
export { snapshotViewportBox } from './render/dom/projection/utils.js';
export { createCrossfader } from './components/AnimateSharedLayout/utils/crossfader.js';
export { visualElement } from './render/index.js';
export { batchLayout, flushLayout } from './render/dom/utils/batch-layout.js';
export { MotionConfigContext } from './context/MotionConfigContext.js';
export { PresenceContext } from './context/PresenceContext.js';
export { LayoutGroupContext } from './context/LayoutGroupContext.js';
export { VisibilityAction } from './components/AnimateSharedLayout/types.js';
export { FramerTreeLayoutContext, SharedLayoutContext } from './context/SharedLayoutContext.js';
export { createBatcher } from './components/AnimateSharedLayout/utils/batcher.js';
export { FlatTree } from './render/utils/flat-tree.js';
export { useAnimatedState as useDeprecatedAnimatedState } from './animation/use-animated-state.js';
export { useInvertedScale as useDeprecatedInvertedScale } from './value/use-inverted-scale.js';
