import { htmlVisualElement } from '../html/visual-element.js';
import { svgVisualElement } from '../svg/visual-element.js';
import { isSVGComponent } from './utils/is-svg-component.js';

var createDomVisualElement = function (Component, options) {
    return isSVGComponent(Component)
        ? svgVisualElement(options, { enableHardwareAcceleration: false })
        : htmlVisualElement(options, { enableHardwareAcceleration: true });
};

export { createDomVisualElement };
