import { __assign } from 'tslib';
import { createMotionComponent } from '../../motion/index.js';
import { createMotionProxy } from './motion-proxy.js';
import { createDomMotionConfig } from './utils/create-config.js';
import { gestureAnimations } from '../../motion/features/gestures.js';
import { animations } from '../../motion/features/animations.js';
import { drag } from '../../motion/features/drag.js';
import { layoutAnimations } from '../../motion/features/layout/index.js';
import { createDomVisualElement } from './create-visual-element.js';

var featureBundle = __assign(__assign(__assign(__assign({}, animations), gestureAnimations), drag), layoutAnimations);
/**
 * HTML & SVG components, optimised for use with gestures and animation. These can be used as
 * drop-in replacements for any HTML & SVG component, all CSS & SVG properties are supported.
 *
 * @public
 */
var motion = /*@__PURE__*/ createMotionProxy(function (Component, config) {
    return createDomMotionConfig(Component, config, featureBundle, createDomVisualElement);
});
/**
 * Create a DOM `motion` component with the provided string. This is primarily intended
 * as a full alternative to `motion` for consumers who have to support environments that don't
 * support `Proxy`.
 *
 * ```javascript
 * import { createDomMotionComponent } from "framer-motion"
 *
 * const motion = {
 *   div: createDomMotionComponent('div')
 * }
 * ```
 *
 * @public
 */
function createDomMotionComponent(key) {
    return createMotionComponent(createDomMotionConfig(key, { forwardMotionProps: false }, featureBundle, createDomVisualElement));
}

export { createDomMotionComponent, motion };
