var transforms = [
    {
        name: 'translate',
        syntax: 'length-percentage',
        initial: '0px'
    },
    {
        name: 'scale',
        syntax: 'number',
        initial: 1
    },
    {
        name: 'rotate',
        syntax: 'angle',
        initial: '0deg'
    }
];
var axes = ['x', 'y', 'z'];
var customProperties = [];
transforms.forEach(function (_a) {
    var name = _a.name, syntax = _a.syntax, initial = _a.initial;
    customProperties.push({ name: name, syntax: syntax, initial: initial });
    axes.forEach(function (axis) {
        return customProperties.push({
            name: name + "-" + axis,
            syntax: syntax,
            initial: initial
        });
    });
});
export function namespace(name) {
    return "--pm-" + name;
}
export function registerCustomProperties() {
    customProperties.forEach(function (_a) {
        var name = _a.name, syntax = _a.syntax, initial = _a.initial;
        CSS.registerProperty({
            name: namespace(name),
            syntax: "<" + syntax + ">",
            inherits: false,
            initialValue: initial
        });
    });
}
//# sourceMappingURL=custom-properties.js.map