import { alpha as alphaType } from '../numbers';
import { percent } from '../numbers/units';
import { sanitize } from '../utils';
import { isColorString, splitColor } from './utils';
export var hsla = {
    test: isColorString('hsl', 'hue'),
    parse: splitColor('hue', 'saturation', 'lightness'),
    transform: function (_a) {
        var hue = _a.hue, saturation = _a.saturation, lightness = _a.lightness, _b = _a.alpha, alpha = _b === void 0 ? 1 : _b;
        return ('hsla(' +
            Math.round(hue) +
            ', ' +
            percent.transform(sanitize(saturation)) +
            ', ' +
            percent.transform(sanitize(lightness)) +
            ', ' +
            sanitize(alphaType.transform(alpha)) +
            ')');
    },
};
//# sourceMappingURL=hsla.js.map