import { __assign } from "tslib";
import { alpha as alphaType, number } from '../numbers';
import { clamp, sanitize } from '../utils';
import { isColorString, splitColor } from './utils';
var clampRgbUnit = clamp(0, 255);
export var rgbUnit = __assign(__assign({}, number), { transform: function (v) { return Math.round(clampRgbUnit(v)); } });
export var rgba = {
    test: isColorString('rgb', 'red'),
    parse: splitColor('red', 'green', 'blue'),
    transform: function (_a) {
        var red = _a.red, green = _a.green, blue = _a.blue, _b = _a.alpha, alpha = _b === void 0 ? 1 : _b;
        return 'rgba(' +
            rgbUnit.transform(red) +
            ', ' +
            rgbUnit.transform(green) +
            ', ' +
            rgbUnit.transform(blue) +
            ', ' +
            sanitize(alphaType.transform(alpha)) +
            ')';
    },
};
//# sourceMappingURL=rgba.js.map