import { __assign } from "tslib";
import { isString } from '../utils';
var createUnitType = function (unit) { return ({
    test: function (v) {
        return isString(v) && v.endsWith(unit) && v.split(' ').length === 1;
    },
    parse: parseFloat,
    transform: function (v) { return "" + v + unit; },
}); };
export var degrees = createUnitType('deg');
export var percent = createUnitType('%');
export var px = createUnitType('px');
export var vh = createUnitType('vh');
export var vw = createUnitType('vw');
export var progressPercentage = __assign(__assign({}, percent), { parse: function (v) { return percent.parse(v) / 100; }, transform: function (v) { return percent.transform(v * 100); } });
//# sourceMappingURL=units.js.map