import { NextRequest, NextResponse } from 'next/server'
import { supabase } from '@/lib/supabase-client'

export async function GET(request: NextRequest) {
  try {
    console.log('Testing login_sessions table...')
    
    // Test if login_sessions table exists and is accessible
    const { data, error } = await supabase
      .from('login_sessions')
      .select('id')
      .limit(1)
    
    if (error) {
      console.error('Login sessions table test failed:', error)
      return NextResponse.json({
        success: false,
        error: error.message,
        details: error.details,
        hint: error.hint,
        code: error.code,
        message: 'login_sessions table does not exist or is not accessible'
      })
    }
    
    return NextResponse.json({
      success: true,
      message: 'login_sessions table is accessible',
      data: data
    })
    
  } catch (error) {
    console.error('Test login sessions API error:', error)
    return NextResponse.json({
      success: false,
      error: error instanceof Error ? error.message : 'Unknown error'
    })
  }
}

