export default function DocsPage() {
  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-4xl mx-auto px-4 py-8">
        {/* Page Header */}
        <div className="mb-8">
          <h1 className="text-3xl font-bold text-black mb-2">Documentation</h1>
          <p className="text-black">Learn how to use our prediction market platform</p>
        </div>

        {/* Getting Started */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
          <div className="p-6">
            <h2 className="text-2xl font-semibold text-black mb-4">Getting Started</h2>
            <div className="prose prose-gray max-w-none">
              <p className="text-black mb-4">
                Welcome to our prediction market platform! This guide will help you understand how to trade on future events and make predictions.
              </p>
              
              <h3 className="text-lg font-semibold text-black mb-3">What are Prediction Markets?</h3>
              <p className="text-black mb-4">
                Prediction markets allow you to trade on the outcome of future events. You can buy shares that represent your belief about whether an event will happen (YES) or not happen (NO).
              </p>

              <h3 className="text-lg font-semibold text-black mb-3">How Trading Works</h3>
              <ul className="list-disc list-inside text-black mb-4 space-y-2">
                <li>Each market has two outcomes: YES and NO</li>
                <li>Prices reflect the market's belief about the probability</li>
                <li>If you're right, you win money from the pool</li>
                <li>If you're wrong, you lose your bet</li>
              </ul>

              <h3 className="text-lg font-semibold text-black mb-3">Seeded Betting System</h3>
              <p className="text-black mb-4">
                Our platform uses a unique seeded betting system:
              </p>
              <ul className="list-disc list-inside text-black mb-4 space-y-2">
                <li><strong>Seed your bet:</strong> Pre-fund a bet before it goes live</li>
                <li><strong>Make it live:</strong> Add more funds to your seeded bet</li>
                <li><strong>Creator rewards:</strong> Market creators earn 20% of live bets</li>
                <li><strong>Admin fee:</strong> Platform takes 1% of all bets</li>
                <li><strong>Winner pool:</strong> Remaining money is shared among winners</li>
              </ul>
            </div>
          </div>
        </div>

        {/* Trading Guide */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
          <div className="p-6">
            <h2 className="text-2xl font-semibold text-black mb-4">Trading Guide</h2>
            
            <div className="space-y-6">
              <div>
                <h3 className="text-lg font-semibold text-black mb-2">1. Choose a Market</h3>
                <p className="text-black mb-2">
                  Browse available markets and find one you want to trade on. Consider:
                </p>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>Your knowledge of the topic</li>
                  <li>Market liquidity (trading volume)</li>
                  <li>Time remaining until resolution</li>
                  <li>Current prices and your disagreement</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">2. Place Your Bet</h3>
                <p className="text-black mb-2">
                  Decide whether to bet YES or NO and how much to risk:
                </p>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>Higher prices = lower expected returns</li>
                  <li>Lower prices = higher expected returns</li>
                  <li>Only bet what you can afford to lose</li>
                  <li>Consider diversifying across multiple markets</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">3. Monitor Your Position</h3>
                <p className="text-black mb-2">
                  Track your bets in your portfolio:
                </p>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>View active positions and P&L</li>
                  <li>Watch for market updates and news</li>
                  <li>Consider hedging or closing positions early</li>
                  <li>Check resolution dates and criteria</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">4. Market Resolution</h3>
                <p className="text-black mb-2">
                  When markets resolve:
                </p>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>Winning bets receive payouts from the pool</li>
                  <li>Losing bets forfeit their stake</li>
                  <li>Creator and admin fees are deducted first</li>
                  <li>Remaining pool is distributed proportionally</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* Wallet & Payments */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
          <div className="p-6">
            <h2 className="text-2xl font-semibold text-black mb-4">Wallet & Payments</h2>
            
            <div className="space-y-6">
              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Deposits</h3>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>No fees on deposits</li>
                  <li>Instant processing</li>
                  <li>Daily and monthly limits apply</li>
                  <li>KYC verification required for higher limits</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Withdrawals</h3>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>2% processing fee</li>
                  <li>1-3 business day processing time</li>
                  <li>Admin approval required</li>
                  <li>Daily and monthly limits apply</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Security</h3>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li>All funds held in secure escrow</li>
                  <li>Two-factor authentication available</li>
                  <li>Regular security audits</li>
                  <li>Insurance coverage for user funds</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* Rewards System */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
          <div className="p-6">
            <h2 className="text-2xl font-semibold text-black mb-4">Rewards & Achievements</h2>
            
            <div className="space-y-6">
              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Earning Points</h3>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li><strong>Trading:</strong> Earn points for successful bets</li>
                  <li><strong>Referrals:</strong> Get points for inviting friends</li>
                  <li><strong>Achievements:</strong> Unlock milestone rewards</li>
                  <li><strong>Daily login:</strong> Bonus points for activity</li>
                </ul>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Achievements</h3>
                <ul className="list-disc list-inside text-black space-y-1">
                  <li><strong>First Bet:</strong> Place your first prediction</li>
                  <li><strong>Lucky Streak:</strong> Win multiple bets in a row</li>
                  <li><strong>High Roller:</strong> Trade large volumes</li>
                  <li><strong>Market Master:</strong> Trade on many different markets</li>
                  <li><strong>Sharp Shooter:</strong> Achieve high win rate</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* FAQ */}
        <div className="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
          <div className="p-6">
            <h2 className="text-2xl font-semibold text-black mb-4">Frequently Asked Questions</h2>
            
            <div className="space-y-6">
              <div>
                <h3 className="text-lg font-semibold text-black mb-2">How are markets resolved?</h3>
                <p className="text-black">
                  Markets are resolved based on objective, verifiable outcomes. Our team reviews each resolution to ensure accuracy and fairness.
                </p>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Can I cancel my bets?</h3>
                <p className="text-black">
                  Once matched, bets cannot be cancelled. However, you can hedge your position by betting the opposite outcome on the same market.
                </p>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">What happens if I disagree with a resolution?</h3>
                <p className="text-black">
                  You can appeal resolutions within 7 days. Our dispute resolution team will review the case and make a final decision.
                </p>
              </div>

              <div>
                <h3 className="text-lg font-semibold text-black mb-2">Are there any restrictions on what I can trade?</h3>
                <p className="text-black">
                  We prohibit trading on markets involving illegal activities, personal information, or events you can directly influence.
                </p>
              </div>
            </div>
          </div>
        </div>

        {/* Support */}
        <div className="bg-blue-50 border border-blue-200 rounded-xl p-6">
          <div className="flex">
            <svg className="w-5 h-5 text-blue-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192L5.636 18.364M12 2.25a9.75 9.75 0 100 19.5 9.75 9.75 0 000-19.5z" />
            </svg>
            <div className="ml-3">
              <h3 className="text-sm font-medium text-blue-800">Need Help?</h3>
              <div className="mt-2 text-sm text-blue-700">
                <p>If you have questions or need assistance, please contact our support team:</p>
                <ul className="mt-2 list-disc list-inside space-y-1">
                  <li>Email: support@betfusionzim.com</li>
                  <li>Discord: Join our community server</li>
                  <li>Twitter: @BetFusionZim</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
