import type { Metadata } from 'next'
import { Inter } from 'next/font/google'
import './globals.css'
import Navigation from '@/components/layout/Navigation'
import { FastAuthProvider } from '@/components/auth/FastAuthProvider'
import { ToastProvider } from '@/components/ui/Toast'
import ErrorBoundary from '@/components/ui/ErrorBoundary'
import LoginTrackingWrapper from '@/components/auth/LoginTrackingWrapper'

const inter = Inter({ subsets: ['latin'] })

export const metadata: Metadata = {
  title: 'BetFusion Zim - Prediction Markets',
  description: 'A decentralized prediction market platform built with Next.js and Supabase',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body className={inter.className}>
        <ErrorBoundary>
          <ToastProvider>
            <FastAuthProvider>
              <LoginTrackingWrapper>
                <Navigation />
                <main>{children}</main>
              </LoginTrackingWrapper>
            </FastAuthProvider>
          </ToastProvider>
        </ErrorBoundary>
      </body>
    </html>
  )
}