export default function TermsPage() {
  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-4xl mx-auto px-4 py-8">
        {/* Page Header */}
        <div className="mb-8">
          <h1 className="text-3xl font-bold text-black mb-2">Terms of Use</h1>
          <p className="text-black">Last updated: January 1, 2024</p>
        </div>

        <div className="bg-white rounded-xl shadow-sm border border-gray-200">
          <div className="p-8">
            <div className="prose prose-gray max-w-none">
              
              <h2 className="text-2xl font-semibold text-black mb-4">1. Acceptance of Terms</h2>
              <p className="text-black mb-6">
                By accessing and using this prediction market platform ("Service"), you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to abide by the above, please do not use this service.
              </p>

              <h2 className="text-2xl font-semibold text-black mb-4">2. Description of Service</h2>
              <p className="text-black mb-4">
                Our platform provides a marketplace for trading prediction contracts on future events. Users can:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Create and participate in prediction markets</li>
                <li>Trade YES/NO contracts on future events</li>
                <li>Earn rewards and achievements</li>
                <li>Manage their wallet and transactions</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">3. User Accounts</h2>
              <p className="text-black mb-4">
                To use our service, you must:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Provide accurate and complete registration information</li>
                <li>Maintain the security of your account credentials</li>
                <li>Be at least 18 years old (or age of majority in your jurisdiction)</li>
                <li>Complete KYC verification for certain features</li>
                <li>Comply with all applicable laws and regulations</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">4. Trading Rules</h2>
              <p className="text-black mb-4">
                When trading on our platform, you agree to:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Only trade with funds you can afford to lose</li>
                <li>Not engage in market manipulation or insider trading</li>
                <li>Not create markets on events you can directly influence</li>
                <li>Accept all trading losses and market resolutions</li>
                <li>Not use automated trading systems without permission</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">5. Prohibited Activities</h2>
              <p className="text-black mb-4">
                You may not use our service for:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Illegal activities or money laundering</li>
                <li>Creating markets on illegal events</li>
                <li>Harassment, abuse, or harmful content</li>
                <li>Attempting to hack or compromise our systems</li>
                <li>Violating intellectual property rights</li>
                <li>Creating multiple accounts to circumvent limits</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">6. Financial Terms</h2>
              <p className="text-black mb-4">
                Our platform operates on the following financial terms:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>No fees on deposits</li>
                <li>2% fee on withdrawals</li>
                <li>Market creators earn 20% of live bet volume</li>
                <li>Platform takes 1% admin fee on all bets</li>
                <li>Remaining pool distributed to winners</li>
                <li>All fees and payouts in USD</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">7. Market Resolution</h2>
              <p className="text-black mb-4">
                Market resolutions are determined by:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Objective, verifiable outcomes</li>
                <li>Third-party data sources when available</li>
                <li>Our resolution team's judgment</li>
                <li>Appeals process for disputed resolutions</li>
                <li>Final decisions are binding and non-reversible</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">8. Risk Disclaimer</h2>
              <p className="text-black mb-4">
                Trading prediction markets involves significant risk:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>You may lose all funds you deposit</li>
                <li>Past performance does not guarantee future results</li>
                <li>Market prices may be volatile and unpredictable</li>
                <li>Technical issues may affect trading</li>
                <li>Regulatory changes may impact the service</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">9. Privacy and Data</h2>
              <p className="text-black mb-4">
                We collect and use your data according to our Privacy Policy:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Personal information for account verification</li>
                <li>Trading data for platform operation</li>
                <li>Communication data for customer support</li>
                <li>Analytics data to improve our service</li>
                <li>We do not sell your personal information</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">10. Account Suspension</h2>
              <p className="text-black mb-4">
                We may suspend or terminate your account for:
              </p>
              <ul className="list-disc list-inside text-black mb-6 space-y-2">
                <li>Violation of these terms</li>
                <li>Suspicious or fraudulent activity</li>
                <li>Non-compliance with KYC requirements</li>
                <li>Creating inappropriate or illegal markets</li>
                <li>Abuse of other users or our staff</li>
              </ul>

              <h2 className="text-2xl font-semibold text-black mb-4">11. Limitation of Liability</h2>
              <p className="text-black mb-6">
                To the maximum extent permitted by law, our platform shall not be liable for any indirect, incidental, special, consequential, or punitive damages, including without limitation, loss of profits, data, use, goodwill, or other intangible losses, resulting from your use of the service.
              </p>

              <h2 className="text-2xl font-semibold text-black mb-4">12. Governing Law</h2>
              <p className="text-black mb-6">
                These terms shall be governed by and construed in accordance with the laws of the jurisdiction in which our platform operates, without regard to its conflict of law provisions.
              </p>

              <h2 className="text-2xl font-semibold text-black mb-4">13. Changes to Terms</h2>
              <p className="text-black mb-6">
                We reserve the right to modify these terms at any time. We will notify users of significant changes via email or platform notification. Continued use of the service after changes constitutes acceptance of the new terms.
              </p>

              <h2 className="text-2xl font-semibold text-black mb-4">14. Contact Information</h2>
              <p className="text-black mb-6">
                If you have questions about these terms, please contact us at:
              </p>
              <div className="bg-gray-50 rounded-lg p-4">
                <ul className="text-black space-y-2">
                  <li><strong>Email:</strong> legal@betfusionzim.com</li>
                  <li><strong>Address:</strong> [Company Address]</li>
                  <li><strong>Phone:</strong> [Contact Number]</li>
                </ul>
              </div>

              <div className="mt-8 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                <p className="text-yellow-800 text-sm">
                  <strong>Important:</strong> By using our platform, you acknowledge that you have read, understood, and agree to be bound by these Terms of Use. If you do not agree to these terms, please do not use our service.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
