'use client'

import { useEffect } from 'react'
import { useRouter } from 'next/navigation'
import { useAuth } from './auth/ClientAuthProvider'

export default function AdminRedirect() {
  const { user, profile, loading } = useAuth()
  const router = useRouter()

  useEffect(() => {
    if (!loading && user && profile?.is_admin) {
      router.push('/admin')
    }
  }, [user, profile, loading, router])

  return null
}