'use client'

import { useAuth } from './auth/ClientAuthProvider'

export default function AuthDebug() {
  const { user, profile, loading } = useAuth()

  if (process.env.NODE_ENV !== 'development') {
    return null
  }

  return (
    <div className="fixed bottom-4 right-4 bg-black text-white p-4 rounded-lg text-xs max-w-sm">
      <h3 className="font-bold mb-2">Auth Debug</h3>
      <div className="space-y-1">
        <div>Loading: {loading ? 'Yes' : 'No'}</div>
        <div>User: {user ? user.email : 'None'}</div>
        <div>Profile: {profile ? 'Loaded' : 'None'}</div>
        <div>Admin: {profile?.is_admin ? 'Yes' : 'No'}</div>
      </div>
    </div>
  )
}
