import { initializeDatabase } from '@/lib/database-init'

export default async function DatabaseStatus() {
  const isInitialized = await initializeDatabase()
  
  if (!isInitialized) {
    return (
      <div className="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-8">
        <div className="flex items-start">
          <div className="flex-shrink-0">
            <svg className="h-5 w-5 text-yellow-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.732-.833-2.464 0L3.34 16.5c-.77.833.192 2.5 1.732 2.5z" />
            </svg>
          </div>
          <div className="ml-3">
            <h3 className="text-sm font-medium text-yellow-800">
              Database Setup Required
            </h3>
            <div className="mt-2 text-sm text-yellow-700">
              <p>Your Supabase database needs to be initialized. Please follow these steps:</p>
              <ol className="list-decimal list-inside mt-2 space-y-1">
                <li>Go to your <a href="https://supabase.com/dashboard" target="_blank" rel="noopener noreferrer" className="underline">Supabase Dashboard</a></li>
                <li>Navigate to SQL Editor</li>
                <li>Copy the contents of <code className="bg-yellow-100 px-1 rounded">supabase-schema.sql</code></li>
                <li>Paste and run the SQL in the editor</li>
                <li>Refresh this page</li>
              </ol>
            </div>
          </div>
        </div>
      </div>
    )
  }
  
  return null
}
