'use client'

import { useEffect, useState } from 'react'

export default function EnvCheck() {
  const [envStatus, setEnvStatus] = useState({
    supabaseUrl: false,
    supabaseKey: false,
  })

  useEffect(() => {
    const supabaseUrl = process.env.NEXT_PUBLIC_SUPABASE_URL
    const supabaseKey = process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY

    setEnvStatus({
      supabaseUrl: !!(supabaseUrl && !supabaseUrl.includes('your-')),
      supabaseKey: !!(supabaseKey && !supabaseKey.includes('your-')),
    })
  }, [])

  if (process.env.NODE_ENV !== 'development') {
    return null
  }

  const allGood = envStatus.supabaseUrl && envStatus.supabaseKey

  return (
    <div className="fixed top-4 right-4 bg-black text-white p-4 rounded-lg text-xs max-w-sm">
      <h3 className="font-bold mb-2">Environment Check</h3>
      <div className="space-y-1">
        <div className={envStatus.supabaseUrl ? 'text-green-400' : 'text-red-400'}>
          Supabase URL: {envStatus.supabaseUrl ? '✓' : '✗'}
        </div>
        <div className={envStatus.supabaseKey ? 'text-green-400' : 'text-red-400'}>
          Supabase Key: {envStatus.supabaseKey ? '✓' : '✗'}
        </div>
        <div className={allGood ? 'text-green-400' : 'text-red-400'}>
          Status: {allGood ? 'Ready' : 'Not Configured'}
        </div>
      </div>
    </div>
  )
}
