'use client'

import { useEffect } from 'react'
import { useRouter } from 'next/navigation'
import { useAuth } from './auth/ClientAuthProvider'

export default function UserRedirect() {
  const { user, profile, loading } = useAuth()
  const router = useRouter()

  useEffect(() => {
    if (!loading && user && profile) {
      // If user is admin, redirect to admin dashboard
      if (profile.is_admin) {
        // Admin user detected, redirecting to admin dashboard
        router.push('/admin')
      } 
      // If user is not admin, redirect to home page
      else {
        // Regular user detected, redirecting to home page
        router.push('/')
      }
    }
  }, [user, profile, loading, router])

  return null
}
