'use client'

import React, { useState, useEffect } from 'react'
import { useAuth } from '@/components/auth/FastAuthProvider'
import { LoadingSpinner } from '@/components/ui/LoadingSpinner'

interface FastSettingsWrapperProps {
  children: React.ReactNode
  requireAuth?: boolean
}

export default function FastSettingsWrapper({ 
  children, 
  requireAuth = true 
}: FastSettingsWrapperProps) {
  const { user, loading: authLoading } = useAuth()
  const [isReady, setIsReady] = useState(false)

  useEffect(() => {
    // Fast initialization for settings pages
    if (!requireAuth || user) {
      setIsReady(true)
    } else if (!authLoading && !user) {
      // User not authenticated and not loading
      setIsReady(true)
    }
  }, [user, authLoading, requireAuth])

  // Show loading only briefly
  if (authLoading || (!isReady && requireAuth)) {
    return (
      <div className="min-h-screen bg-gray-50 flex items-center justify-center">
        <div className="text-center">
          <LoadingSpinner size="lg" />
          <p className="mt-4 text-black">Loading settings...</p>
        </div>
      </div>
    )
  }

  // If authentication required but no user, redirect to login
  if (requireAuth && !user) {
    return (
      <div className="min-h-screen bg-gray-50 flex items-center justify-center">
        <div className="text-center">
          <h1 className="text-2xl font-bold text-black mb-4">Authentication Required</h1>
          <p className="text-black mb-4">Please log in to access settings.</p>
          <a href="/login" className="text-blue-600 hover:text-blue-700">
            Go to Login
          </a>
        </div>
      </div>
    )
  }

  return <>{children}</>
}
