'use client'

import { ComponentType } from 'react'
import SessionWrapper from './SessionWrapper'

interface SessionOptions {
  requireAuth?: boolean
  requireAdmin?: boolean
  redirectTo?: string
}

export function withSession<P extends object>(
  WrappedComponent: ComponentType<P>,
  options: SessionOptions = {}
) {
  const {
    requireAuth = true,
    requireAdmin = false,
    redirectTo = '/auth/login'
  } = options

  const SessionWrappedComponent = (props: P) => {
    return (
      <SessionWrapper
        requireAuth={requireAuth}
        requireAdmin={requireAdmin}
        redirectTo={redirectTo}
      >
        <WrappedComponent {...props} />
      </SessionWrapper>
    )
  }

  SessionWrappedComponent.displayName = `withSession(${WrappedComponent.displayName || WrappedComponent.name})`

  return SessionWrappedComponent
}

// Convenience functions for common use cases
export const withAuth = <P extends object>(Component: ComponentType<P>) =>
  withSession(Component, { requireAuth: true })

export const withAdmin = <P extends object>(Component: ComponentType<P>) =>
  withSession(Component, { requireAuth: true, requireAdmin: true })

export const withOptionalAuth = <P extends object>(Component: ComponentType<P>) =>
  withSession(Component, { requireAuth: false })
