'use client'

import { useAuth } from '@/components/auth/FastAuthProvider'
import { useLiveBalance } from '@/lib/hooks/useLiveBalance'

export default function LiveBalance() {
  const { user } = useAuth()
  const { balance, lastUpdated, isConnected } = useLiveBalance(user?.id)

  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat('en-US', {
      style: 'currency',
      currency: 'USD',
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    }).format(amount)
  }

  if (!user) return null

  return (
    <div className="flex items-center space-x-3 bg-white rounded-lg px-4 py-2 border border-gray-200">
      <div className="flex items-center space-x-2">
        <div className={`w-2 h-2 rounded-full ${isConnected ? 'bg-green-500 animate-pulse' : 'bg-red-500'}`}></div>
        <span className="text-sm text-gray-600">Balance</span>
      </div>
      <div className="text-sm font-medium text-black">
        {formatCurrency(balance)}
      </div>
      <div className="text-xs text-gray-500">
        {lastUpdated.toLocaleTimeString()}
      </div>
    </div>
  )
}
