'use client'

import { useState } from 'react'
import { X } from 'lucide-react'
import { Market } from '@/lib/types'
import UnifiedBetForm from './UnifiedBetForm'

interface QuickBetModalProps {
  market: Market
  isOpen: boolean
  onClose: () => void
  onBetPlaced: () => void
}

export default function QuickBetModal({ market, isOpen, onClose, onBetPlaced }: QuickBetModalProps) {
  if (!isOpen) return null

  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
      <div className="bg-white rounded-xl shadow-2xl max-w-lg w-full max-h-[90vh] overflow-y-auto">
        {/* Header */}
        <div className="flex items-center justify-between p-4 border-b border-gray-200">
          <h2 className="text-lg font-semibold text-gray-900">Place Bet</h2>
          <button
            onClick={onClose}
            className="p-1.5 hover:bg-gray-100 rounded-lg transition-colors"
          >
            <X className="w-4 h-4" />
          </button>
        </div>

        {/* Market Info - Compact */}
        <div className="p-4 border-b border-gray-200">
          <h3 className="font-medium text-gray-900 text-sm mb-1">{market.title}</h3>
          <p className="text-xs text-gray-600 line-clamp-1">{market.description}</p>
        </div>

        {/* Betting Form */}
        <div className="p-0">
          <UnifiedBetForm 
            market={market} 
            onBetPlaced={() => {
              onBetPlaced()
              onClose()
            }} 
          />
        </div>
      </div>
    </div>
  )
}
