'use client'

import { useState } from 'react'
import Link from 'next/link'
import { useRouter } from 'next/navigation'
import { LoadingSpinner } from './LoadingSpinner'

interface LoadingLinkProps {
  href: string
  children: React.ReactNode
  className?: string
  onClick?: () => void
  showLoadingOnClick?: boolean
}

export default function LoadingLink({ 
  href, 
  children, 
  className = '', 
  onClick,
  showLoadingOnClick = true 
}: LoadingLinkProps) {
  const [isNavigating, setIsNavigating] = useState(false)
  const router = useRouter()

  const handleClick = (e: React.MouseEvent) => {
    if (onClick) {
      onClick()
    }

    if (showLoadingOnClick) {
      setIsNavigating(true)
      
      // Use router.push for programmatic navigation with loading state
      router.push(href)
      
      // Reset loading state after a delay
      setTimeout(() => {
        setIsNavigating(false)
      }, 1000)
    }
  }

  if (isNavigating) {
    return (
      <div className={`flex items-center px-4 py-2 text-sm ${className}`}>
        <LoadingSpinner size="sm" />
        <span className="ml-2">Loading...</span>
      </div>
    )
  }

  return (
    <Link 
      href={href} 
      className={className}
      onClick={handleClick}
    >
      {children}
    </Link>
  )
}
