import { LoadingSpinner } from './LoadingSpinner'

interface PageLoaderProps {
  text?: string
}

export default function PageLoader({ text = 'Loading...' }: PageLoaderProps) {
  return (
    <div className="min-h-screen bg-gray-50 flex items-center justify-center">
      <div className="text-center">
        <LoadingSpinner size="lg" />
        <p className="mt-4 text-lg text-black">{text}</p>
      </div>
    </div>
  )
}
