'use client'

import { Profile } from '@/lib/types'

interface BalanceCardProps {
  profile: Profile
  onDeposit: () => void
  onWithdraw: () => void
}

export default function BalanceCard({ profile, onDeposit, onWithdraw }: BalanceCardProps) {
  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat('en-US', {
      style: 'currency',
      currency: 'USD'
    }).format(amount)
  }

  return (
    <div className="bg-gradient-to-br from-blue-600 to-purple-700 rounded-xl shadow-lg text-white">
      <div className="p-8">
        <div className="flex items-center justify-between mb-6">
          <div>
            <h2 className="text-2xl font-bold mb-2">Account Balance</h2>
            <p className="text-blue-100">Your available trading balance</p>
          </div>
          <div className="text-right">
            <div className="text-4xl font-bold mb-1">
              {formatCurrency(profile.balance)}
            </div>
            <div className="text-blue-200 text-sm">
              {profile.total_points.toLocaleString()} points
            </div>
          </div>
        </div>

        <div className="flex space-x-4">
          <button
            onClick={onDeposit}
            className="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white font-semibold py-3 px-6 rounded-lg transition-all duration-200 flex items-center justify-center space-x-2"
          >
            <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
            </svg>
            <span>Deposit</span>
          </button>
          <button
            onClick={onWithdraw}
            className="flex-1 bg-white bg-opacity-20 hover:bg-opacity-30 text-white font-semibold py-3 px-6 rounded-lg transition-all duration-200 flex items-center justify-center space-x-2"
          >
            <svg className="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M18 12H6" />
            </svg>
            <span>Withdraw</span>
          </button>
        </div>

        {/* Quick Info */}
        <div className="mt-6 pt-6 border-t border-white border-opacity-20">
          <div className="grid grid-cols-3 gap-4 text-center">
            <div>
              <div className="text-lg font-semibold">
                {formatCurrency(profile.daily_deposit_limit)}
              </div>
              <div className="text-blue-200 text-sm">Daily Deposit Limit</div>
            </div>
            <div>
              <div className="text-lg font-semibold">
                {formatCurrency(profile.daily_withdrawal_limit)}
              </div>
              <div className="text-blue-200 text-sm">Daily Withdrawal Limit</div>
            </div>
            <div>
              <div className="text-lg font-semibold">
                {profile.kyc_verified ? 'Verified' : 'Pending'}
              </div>
              <div className="text-blue-200 text-sm">KYC Status</div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
